/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/prediction_service.proto

package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Request message for [PredictionService.Predict][google.cloud.aiplatform.v1beta1.PredictionService.Predict].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.PredictRequest}
 */
public final class PredictRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.PredictRequest)
    PredictRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PredictRequest.newBuilder() to construct.
  private PredictRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PredictRequest() {
    endpoint_ = "";
    instances_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PredictRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private PredictRequest(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              endpoint_ = s;
              break;
            }
          case 18:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                instances_ = new java.util.ArrayList<com.google.protobuf.Value>();
                mutable_bitField0_ |= 0x00000001;
              }
              instances_.add(
                  input.readMessage(com.google.protobuf.Value.parser(), extensionRegistry));
              break;
            }
          case 26:
            {
              com.google.protobuf.Value.Builder subBuilder = null;
              if (parameters_ != null) {
                subBuilder = parameters_.toBuilder();
              }
              parameters_ =
                  input.readMessage(com.google.protobuf.Value.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(parameters_);
                parameters_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        instances_ = java.util.Collections.unmodifiableList(instances_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.PredictionServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_PredictRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.PredictionServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_PredictRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.PredictRequest.class,
            com.google.cloud.aiplatform.v1beta1.PredictRequest.Builder.class);
  }

  public static final int ENDPOINT_FIELD_NUMBER = 1;
  private volatile java.lang.Object endpoint_;
  /**
   *
   *
   * <pre>
   * Required. The name of the Endpoint requested to serve the prediction.
   * Format:
   * `projects/{project}/locations/{location}/endpoints/{endpoint}`
   * </pre>
   *
   * <code>
   * string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The endpoint.
   */
  @java.lang.Override
  public java.lang.String getEndpoint() {
    java.lang.Object ref = endpoint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      endpoint_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the Endpoint requested to serve the prediction.
   * Format:
   * `projects/{project}/locations/{location}/endpoints/{endpoint}`
   * </pre>
   *
   * <code>
   * string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for endpoint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEndpointBytes() {
    java.lang.Object ref = endpoint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      endpoint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INSTANCES_FIELD_NUMBER = 2;
  private java.util.List<com.google.protobuf.Value> instances_;
  /**
   *
   *
   * <pre>
   * Required. The instances that are the input to the prediction call.
   * A DeployedModel may have an upper limit on the number of instances it
   * supports per request, and when it is exceeded the prediction call errors
   * in case of AutoML Models, or, in case of customer created Models, the
   * behaviour is as documented by that Model.
   * The schema of any single instance may be specified via Endpoint's
   * DeployedModels' [Model's][google.cloud.aiplatform.v1beta1.DeployedModel.model]
   * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
   * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
   * </pre>
   *
   * <code>repeated .google.protobuf.Value instances = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.protobuf.Value> getInstancesList() {
    return instances_;
  }
  /**
   *
   *
   * <pre>
   * Required. The instances that are the input to the prediction call.
   * A DeployedModel may have an upper limit on the number of instances it
   * supports per request, and when it is exceeded the prediction call errors
   * in case of AutoML Models, or, in case of customer created Models, the
   * behaviour is as documented by that Model.
   * The schema of any single instance may be specified via Endpoint's
   * DeployedModels' [Model's][google.cloud.aiplatform.v1beta1.DeployedModel.model]
   * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
   * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
   * </pre>
   *
   * <code>repeated .google.protobuf.Value instances = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.protobuf.ValueOrBuilder> getInstancesOrBuilderList() {
    return instances_;
  }
  /**
   *
   *
   * <pre>
   * Required. The instances that are the input to the prediction call.
   * A DeployedModel may have an upper limit on the number of instances it
   * supports per request, and when it is exceeded the prediction call errors
   * in case of AutoML Models, or, in case of customer created Models, the
   * behaviour is as documented by that Model.
   * The schema of any single instance may be specified via Endpoint's
   * DeployedModels' [Model's][google.cloud.aiplatform.v1beta1.DeployedModel.model]
   * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
   * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
   * </pre>
   *
   * <code>repeated .google.protobuf.Value instances = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getInstancesCount() {
    return instances_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. The instances that are the input to the prediction call.
   * A DeployedModel may have an upper limit on the number of instances it
   * supports per request, and when it is exceeded the prediction call errors
   * in case of AutoML Models, or, in case of customer created Models, the
   * behaviour is as documented by that Model.
   * The schema of any single instance may be specified via Endpoint's
   * DeployedModels' [Model's][google.cloud.aiplatform.v1beta1.DeployedModel.model]
   * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
   * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
   * </pre>
   *
   * <code>repeated .google.protobuf.Value instances = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.Value getInstances(int index) {
    return instances_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. The instances that are the input to the prediction call.
   * A DeployedModel may have an upper limit on the number of instances it
   * supports per request, and when it is exceeded the prediction call errors
   * in case of AutoML Models, or, in case of customer created Models, the
   * behaviour is as documented by that Model.
   * The schema of any single instance may be specified via Endpoint's
   * DeployedModels' [Model's][google.cloud.aiplatform.v1beta1.DeployedModel.model]
   * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
   * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
   * </pre>
   *
   * <code>repeated .google.protobuf.Value instances = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.ValueOrBuilder getInstancesOrBuilder(int index) {
    return instances_.get(index);
  }

  public static final int PARAMETERS_FIELD_NUMBER = 3;
  private com.google.protobuf.Value parameters_;
  /**
   *
   *
   * <pre>
   * The parameters that govern the prediction. The schema of the parameters may
   * be specified via Endpoint's DeployedModels' [Model's ][google.cloud.aiplatform.v1beta1.DeployedModel.model]
   * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
   * [parameters_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri].
   * </pre>
   *
   * <code>.google.protobuf.Value parameters = 3;</code>
   *
   * @return Whether the parameters field is set.
   */
  @java.lang.Override
  public boolean hasParameters() {
    return parameters_ != null;
  }
  /**
   *
   *
   * <pre>
   * The parameters that govern the prediction. The schema of the parameters may
   * be specified via Endpoint's DeployedModels' [Model's ][google.cloud.aiplatform.v1beta1.DeployedModel.model]
   * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
   * [parameters_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri].
   * </pre>
   *
   * <code>.google.protobuf.Value parameters = 3;</code>
   *
   * @return The parameters.
   */
  @java.lang.Override
  public com.google.protobuf.Value getParameters() {
    return parameters_ == null ? com.google.protobuf.Value.getDefaultInstance() : parameters_;
  }
  /**
   *
   *
   * <pre>
   * The parameters that govern the prediction. The schema of the parameters may
   * be specified via Endpoint's DeployedModels' [Model's ][google.cloud.aiplatform.v1beta1.DeployedModel.model]
   * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
   * [parameters_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri].
   * </pre>
   *
   * <code>.google.protobuf.Value parameters = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.ValueOrBuilder getParametersOrBuilder() {
    return getParameters();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(endpoint_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, endpoint_);
    }
    for (int i = 0; i < instances_.size(); i++) {
      output.writeMessage(2, instances_.get(i));
    }
    if (parameters_ != null) {
      output.writeMessage(3, getParameters());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(endpoint_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, endpoint_);
    }
    for (int i = 0; i < instances_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, instances_.get(i));
    }
    if (parameters_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getParameters());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.PredictRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.PredictRequest other =
        (com.google.cloud.aiplatform.v1beta1.PredictRequest) obj;

    if (!getEndpoint().equals(other.getEndpoint())) return false;
    if (!getInstancesList().equals(other.getInstancesList())) return false;
    if (hasParameters() != other.hasParameters()) return false;
    if (hasParameters()) {
      if (!getParameters().equals(other.getParameters())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ENDPOINT_FIELD_NUMBER;
    hash = (53 * hash) + getEndpoint().hashCode();
    if (getInstancesCount() > 0) {
      hash = (37 * hash) + INSTANCES_FIELD_NUMBER;
      hash = (53 * hash) + getInstancesList().hashCode();
    }
    if (hasParameters()) {
      hash = (37 * hash) + PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + getParameters().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.PredictRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.PredictRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PredictRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.PredictRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PredictRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.PredictRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PredictRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.PredictRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PredictRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.PredictRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PredictRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.PredictRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.PredictRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for [PredictionService.Predict][google.cloud.aiplatform.v1beta1.PredictionService.Predict].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.PredictRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.PredictRequest)
      com.google.cloud.aiplatform.v1beta1.PredictRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.PredictionServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_PredictRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.PredictionServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_PredictRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.PredictRequest.class,
              com.google.cloud.aiplatform.v1beta1.PredictRequest.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.PredictRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getInstancesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      endpoint_ = "";

      if (instancesBuilder_ == null) {
        instances_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        instancesBuilder_.clear();
      }
      if (parametersBuilder_ == null) {
        parameters_ = null;
      } else {
        parameters_ = null;
        parametersBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.PredictionServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_PredictRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PredictRequest getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.PredictRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PredictRequest build() {
      com.google.cloud.aiplatform.v1beta1.PredictRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PredictRequest buildPartial() {
      com.google.cloud.aiplatform.v1beta1.PredictRequest result =
          new com.google.cloud.aiplatform.v1beta1.PredictRequest(this);
      int from_bitField0_ = bitField0_;
      result.endpoint_ = endpoint_;
      if (instancesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          instances_ = java.util.Collections.unmodifiableList(instances_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.instances_ = instances_;
      } else {
        result.instances_ = instancesBuilder_.build();
      }
      if (parametersBuilder_ == null) {
        result.parameters_ = parameters_;
      } else {
        result.parameters_ = parametersBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.PredictRequest) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.PredictRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.PredictRequest other) {
      if (other == com.google.cloud.aiplatform.v1beta1.PredictRequest.getDefaultInstance())
        return this;
      if (!other.getEndpoint().isEmpty()) {
        endpoint_ = other.endpoint_;
        onChanged();
      }
      if (instancesBuilder_ == null) {
        if (!other.instances_.isEmpty()) {
          if (instances_.isEmpty()) {
            instances_ = other.instances_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureInstancesIsMutable();
            instances_.addAll(other.instances_);
          }
          onChanged();
        }
      } else {
        if (!other.instances_.isEmpty()) {
          if (instancesBuilder_.isEmpty()) {
            instancesBuilder_.dispose();
            instancesBuilder_ = null;
            instances_ = other.instances_;
            bitField0_ = (bitField0_ & ~0x00000001);
            instancesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getInstancesFieldBuilder()
                    : null;
          } else {
            instancesBuilder_.addAllMessages(other.instances_);
          }
        }
      }
      if (other.hasParameters()) {
        mergeParameters(other.getParameters());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.aiplatform.v1beta1.PredictRequest parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.aiplatform.v1beta1.PredictRequest) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object endpoint_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the Endpoint requested to serve the prediction.
     * Format:
     * `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * </pre>
     *
     * <code>
     * string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The endpoint.
     */
    public java.lang.String getEndpoint() {
      java.lang.Object ref = endpoint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        endpoint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the Endpoint requested to serve the prediction.
     * Format:
     * `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * </pre>
     *
     * <code>
     * string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for endpoint.
     */
    public com.google.protobuf.ByteString getEndpointBytes() {
      java.lang.Object ref = endpoint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        endpoint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the Endpoint requested to serve the prediction.
     * Format:
     * `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * </pre>
     *
     * <code>
     * string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The endpoint to set.
     * @return This builder for chaining.
     */
    public Builder setEndpoint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      endpoint_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the Endpoint requested to serve the prediction.
     * Format:
     * `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * </pre>
     *
     * <code>
     * string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEndpoint() {

      endpoint_ = getDefaultInstance().getEndpoint();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the Endpoint requested to serve the prediction.
     * Format:
     * `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * </pre>
     *
     * <code>
     * string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for endpoint to set.
     * @return This builder for chaining.
     */
    public Builder setEndpointBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      endpoint_ = value;
      onChanged();
      return this;
    }

    private java.util.List<com.google.protobuf.Value> instances_ =
        java.util.Collections.emptyList();

    private void ensureInstancesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        instances_ = new java.util.ArrayList<com.google.protobuf.Value>(instances_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        instancesBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The instances that are the input to the prediction call.
     * A DeployedModel may have an upper limit on the number of instances it
     * supports per request, and when it is exceeded the prediction call errors
     * in case of AutoML Models, or, in case of customer created Models, the
     * behaviour is as documented by that Model.
     * The schema of any single instance may be specified via Endpoint's
     * DeployedModels' [Model's][google.cloud.aiplatform.v1beta1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value instances = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.protobuf.Value> getInstancesList() {
      if (instancesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(instances_);
      } else {
        return instancesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The instances that are the input to the prediction call.
     * A DeployedModel may have an upper limit on the number of instances it
     * supports per request, and when it is exceeded the prediction call errors
     * in case of AutoML Models, or, in case of customer created Models, the
     * behaviour is as documented by that Model.
     * The schema of any single instance may be specified via Endpoint's
     * DeployedModels' [Model's][google.cloud.aiplatform.v1beta1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value instances = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getInstancesCount() {
      if (instancesBuilder_ == null) {
        return instances_.size();
      } else {
        return instancesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The instances that are the input to the prediction call.
     * A DeployedModel may have an upper limit on the number of instances it
     * supports per request, and when it is exceeded the prediction call errors
     * in case of AutoML Models, or, in case of customer created Models, the
     * behaviour is as documented by that Model.
     * The schema of any single instance may be specified via Endpoint's
     * DeployedModels' [Model's][google.cloud.aiplatform.v1beta1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value instances = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.protobuf.Value getInstances(int index) {
      if (instancesBuilder_ == null) {
        return instances_.get(index);
      } else {
        return instancesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The instances that are the input to the prediction call.
     * A DeployedModel may have an upper limit on the number of instances it
     * supports per request, and when it is exceeded the prediction call errors
     * in case of AutoML Models, or, in case of customer created Models, the
     * behaviour is as documented by that Model.
     * The schema of any single instance may be specified via Endpoint's
     * DeployedModels' [Model's][google.cloud.aiplatform.v1beta1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value instances = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setInstances(int index, com.google.protobuf.Value value) {
      if (instancesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInstancesIsMutable();
        instances_.set(index, value);
        onChanged();
      } else {
        instancesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The instances that are the input to the prediction call.
     * A DeployedModel may have an upper limit on the number of instances it
     * supports per request, and when it is exceeded the prediction call errors
     * in case of AutoML Models, or, in case of customer created Models, the
     * behaviour is as documented by that Model.
     * The schema of any single instance may be specified via Endpoint's
     * DeployedModels' [Model's][google.cloud.aiplatform.v1beta1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value instances = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setInstances(int index, com.google.protobuf.Value.Builder builderForValue) {
      if (instancesBuilder_ == null) {
        ensureInstancesIsMutable();
        instances_.set(index, builderForValue.build());
        onChanged();
      } else {
        instancesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The instances that are the input to the prediction call.
     * A DeployedModel may have an upper limit on the number of instances it
     * supports per request, and when it is exceeded the prediction call errors
     * in case of AutoML Models, or, in case of customer created Models, the
     * behaviour is as documented by that Model.
     * The schema of any single instance may be specified via Endpoint's
     * DeployedModels' [Model's][google.cloud.aiplatform.v1beta1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value instances = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addInstances(com.google.protobuf.Value value) {
      if (instancesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInstancesIsMutable();
        instances_.add(value);
        onChanged();
      } else {
        instancesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The instances that are the input to the prediction call.
     * A DeployedModel may have an upper limit on the number of instances it
     * supports per request, and when it is exceeded the prediction call errors
     * in case of AutoML Models, or, in case of customer created Models, the
     * behaviour is as documented by that Model.
     * The schema of any single instance may be specified via Endpoint's
     * DeployedModels' [Model's][google.cloud.aiplatform.v1beta1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value instances = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addInstances(int index, com.google.protobuf.Value value) {
      if (instancesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInstancesIsMutable();
        instances_.add(index, value);
        onChanged();
      } else {
        instancesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The instances that are the input to the prediction call.
     * A DeployedModel may have an upper limit on the number of instances it
     * supports per request, and when it is exceeded the prediction call errors
     * in case of AutoML Models, or, in case of customer created Models, the
     * behaviour is as documented by that Model.
     * The schema of any single instance may be specified via Endpoint's
     * DeployedModels' [Model's][google.cloud.aiplatform.v1beta1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value instances = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addInstances(com.google.protobuf.Value.Builder builderForValue) {
      if (instancesBuilder_ == null) {
        ensureInstancesIsMutable();
        instances_.add(builderForValue.build());
        onChanged();
      } else {
        instancesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The instances that are the input to the prediction call.
     * A DeployedModel may have an upper limit on the number of instances it
     * supports per request, and when it is exceeded the prediction call errors
     * in case of AutoML Models, or, in case of customer created Models, the
     * behaviour is as documented by that Model.
     * The schema of any single instance may be specified via Endpoint's
     * DeployedModels' [Model's][google.cloud.aiplatform.v1beta1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value instances = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addInstances(int index, com.google.protobuf.Value.Builder builderForValue) {
      if (instancesBuilder_ == null) {
        ensureInstancesIsMutable();
        instances_.add(index, builderForValue.build());
        onChanged();
      } else {
        instancesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The instances that are the input to the prediction call.
     * A DeployedModel may have an upper limit on the number of instances it
     * supports per request, and when it is exceeded the prediction call errors
     * in case of AutoML Models, or, in case of customer created Models, the
     * behaviour is as documented by that Model.
     * The schema of any single instance may be specified via Endpoint's
     * DeployedModels' [Model's][google.cloud.aiplatform.v1beta1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value instances = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllInstances(java.lang.Iterable<? extends com.google.protobuf.Value> values) {
      if (instancesBuilder_ == null) {
        ensureInstancesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, instances_);
        onChanged();
      } else {
        instancesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The instances that are the input to the prediction call.
     * A DeployedModel may have an upper limit on the number of instances it
     * supports per request, and when it is exceeded the prediction call errors
     * in case of AutoML Models, or, in case of customer created Models, the
     * behaviour is as documented by that Model.
     * The schema of any single instance may be specified via Endpoint's
     * DeployedModels' [Model's][google.cloud.aiplatform.v1beta1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value instances = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearInstances() {
      if (instancesBuilder_ == null) {
        instances_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        instancesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The instances that are the input to the prediction call.
     * A DeployedModel may have an upper limit on the number of instances it
     * supports per request, and when it is exceeded the prediction call errors
     * in case of AutoML Models, or, in case of customer created Models, the
     * behaviour is as documented by that Model.
     * The schema of any single instance may be specified via Endpoint's
     * DeployedModels' [Model's][google.cloud.aiplatform.v1beta1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value instances = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeInstances(int index) {
      if (instancesBuilder_ == null) {
        ensureInstancesIsMutable();
        instances_.remove(index);
        onChanged();
      } else {
        instancesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The instances that are the input to the prediction call.
     * A DeployedModel may have an upper limit on the number of instances it
     * supports per request, and when it is exceeded the prediction call errors
     * in case of AutoML Models, or, in case of customer created Models, the
     * behaviour is as documented by that Model.
     * The schema of any single instance may be specified via Endpoint's
     * DeployedModels' [Model's][google.cloud.aiplatform.v1beta1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value instances = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.protobuf.Value.Builder getInstancesBuilder(int index) {
      return getInstancesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The instances that are the input to the prediction call.
     * A DeployedModel may have an upper limit on the number of instances it
     * supports per request, and when it is exceeded the prediction call errors
     * in case of AutoML Models, or, in case of customer created Models, the
     * behaviour is as documented by that Model.
     * The schema of any single instance may be specified via Endpoint's
     * DeployedModels' [Model's][google.cloud.aiplatform.v1beta1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value instances = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.protobuf.ValueOrBuilder getInstancesOrBuilder(int index) {
      if (instancesBuilder_ == null) {
        return instances_.get(index);
      } else {
        return instancesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The instances that are the input to the prediction call.
     * A DeployedModel may have an upper limit on the number of instances it
     * supports per request, and when it is exceeded the prediction call errors
     * in case of AutoML Models, or, in case of customer created Models, the
     * behaviour is as documented by that Model.
     * The schema of any single instance may be specified via Endpoint's
     * DeployedModels' [Model's][google.cloud.aiplatform.v1beta1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value instances = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<? extends com.google.protobuf.ValueOrBuilder>
        getInstancesOrBuilderList() {
      if (instancesBuilder_ != null) {
        return instancesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(instances_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The instances that are the input to the prediction call.
     * A DeployedModel may have an upper limit on the number of instances it
     * supports per request, and when it is exceeded the prediction call errors
     * in case of AutoML Models, or, in case of customer created Models, the
     * behaviour is as documented by that Model.
     * The schema of any single instance may be specified via Endpoint's
     * DeployedModels' [Model's][google.cloud.aiplatform.v1beta1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value instances = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.protobuf.Value.Builder addInstancesBuilder() {
      return getInstancesFieldBuilder().addBuilder(com.google.protobuf.Value.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The instances that are the input to the prediction call.
     * A DeployedModel may have an upper limit on the number of instances it
     * supports per request, and when it is exceeded the prediction call errors
     * in case of AutoML Models, or, in case of customer created Models, the
     * behaviour is as documented by that Model.
     * The schema of any single instance may be specified via Endpoint's
     * DeployedModels' [Model's][google.cloud.aiplatform.v1beta1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value instances = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.protobuf.Value.Builder addInstancesBuilder(int index) {
      return getInstancesFieldBuilder()
          .addBuilder(index, com.google.protobuf.Value.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The instances that are the input to the prediction call.
     * A DeployedModel may have an upper limit on the number of instances it
     * supports per request, and when it is exceeded the prediction call errors
     * in case of AutoML Models, or, in case of customer created Models, the
     * behaviour is as documented by that Model.
     * The schema of any single instance may be specified via Endpoint's
     * DeployedModels' [Model's][google.cloud.aiplatform.v1beta1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value instances = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.protobuf.Value.Builder> getInstancesBuilderList() {
      return getInstancesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        getInstancesFieldBuilder() {
      if (instancesBuilder_ == null) {
        instancesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.protobuf.Value,
                com.google.protobuf.Value.Builder,
                com.google.protobuf.ValueOrBuilder>(
                instances_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        instances_ = null;
      }
      return instancesBuilder_;
    }

    private com.google.protobuf.Value parameters_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        parametersBuilder_;
    /**
     *
     *
     * <pre>
     * The parameters that govern the prediction. The schema of the parameters may
     * be specified via Endpoint's DeployedModels' [Model's ][google.cloud.aiplatform.v1beta1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [parameters_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri].
     * </pre>
     *
     * <code>.google.protobuf.Value parameters = 3;</code>
     *
     * @return Whether the parameters field is set.
     */
    public boolean hasParameters() {
      return parametersBuilder_ != null || parameters_ != null;
    }
    /**
     *
     *
     * <pre>
     * The parameters that govern the prediction. The schema of the parameters may
     * be specified via Endpoint's DeployedModels' [Model's ][google.cloud.aiplatform.v1beta1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [parameters_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri].
     * </pre>
     *
     * <code>.google.protobuf.Value parameters = 3;</code>
     *
     * @return The parameters.
     */
    public com.google.protobuf.Value getParameters() {
      if (parametersBuilder_ == null) {
        return parameters_ == null ? com.google.protobuf.Value.getDefaultInstance() : parameters_;
      } else {
        return parametersBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The parameters that govern the prediction. The schema of the parameters may
     * be specified via Endpoint's DeployedModels' [Model's ][google.cloud.aiplatform.v1beta1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [parameters_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri].
     * </pre>
     *
     * <code>.google.protobuf.Value parameters = 3;</code>
     */
    public Builder setParameters(com.google.protobuf.Value value) {
      if (parametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        parameters_ = value;
        onChanged();
      } else {
        parametersBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The parameters that govern the prediction. The schema of the parameters may
     * be specified via Endpoint's DeployedModels' [Model's ][google.cloud.aiplatform.v1beta1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [parameters_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri].
     * </pre>
     *
     * <code>.google.protobuf.Value parameters = 3;</code>
     */
    public Builder setParameters(com.google.protobuf.Value.Builder builderForValue) {
      if (parametersBuilder_ == null) {
        parameters_ = builderForValue.build();
        onChanged();
      } else {
        parametersBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The parameters that govern the prediction. The schema of the parameters may
     * be specified via Endpoint's DeployedModels' [Model's ][google.cloud.aiplatform.v1beta1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [parameters_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri].
     * </pre>
     *
     * <code>.google.protobuf.Value parameters = 3;</code>
     */
    public Builder mergeParameters(com.google.protobuf.Value value) {
      if (parametersBuilder_ == null) {
        if (parameters_ != null) {
          parameters_ =
              com.google.protobuf.Value.newBuilder(parameters_).mergeFrom(value).buildPartial();
        } else {
          parameters_ = value;
        }
        onChanged();
      } else {
        parametersBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The parameters that govern the prediction. The schema of the parameters may
     * be specified via Endpoint's DeployedModels' [Model's ][google.cloud.aiplatform.v1beta1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [parameters_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri].
     * </pre>
     *
     * <code>.google.protobuf.Value parameters = 3;</code>
     */
    public Builder clearParameters() {
      if (parametersBuilder_ == null) {
        parameters_ = null;
        onChanged();
      } else {
        parameters_ = null;
        parametersBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The parameters that govern the prediction. The schema of the parameters may
     * be specified via Endpoint's DeployedModels' [Model's ][google.cloud.aiplatform.v1beta1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [parameters_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri].
     * </pre>
     *
     * <code>.google.protobuf.Value parameters = 3;</code>
     */
    public com.google.protobuf.Value.Builder getParametersBuilder() {

      onChanged();
      return getParametersFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The parameters that govern the prediction. The schema of the parameters may
     * be specified via Endpoint's DeployedModels' [Model's ][google.cloud.aiplatform.v1beta1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [parameters_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri].
     * </pre>
     *
     * <code>.google.protobuf.Value parameters = 3;</code>
     */
    public com.google.protobuf.ValueOrBuilder getParametersOrBuilder() {
      if (parametersBuilder_ != null) {
        return parametersBuilder_.getMessageOrBuilder();
      } else {
        return parameters_ == null ? com.google.protobuf.Value.getDefaultInstance() : parameters_;
      }
    }
    /**
     *
     *
     * <pre>
     * The parameters that govern the prediction. The schema of the parameters may
     * be specified via Endpoint's DeployedModels' [Model's ][google.cloud.aiplatform.v1beta1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [parameters_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri].
     * </pre>
     *
     * <code>.google.protobuf.Value parameters = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        getParametersFieldBuilder() {
      if (parametersBuilder_ == null) {
        parametersBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Value,
                com.google.protobuf.Value.Builder,
                com.google.protobuf.ValueOrBuilder>(
                getParameters(), getParentForChildren(), isClean());
        parameters_ = null;
      }
      return parametersBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.PredictRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.PredictRequest)
  private static final com.google.cloud.aiplatform.v1beta1.PredictRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.PredictRequest();
  }

  public static com.google.cloud.aiplatform.v1beta1.PredictRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PredictRequest> PARSER =
      new com.google.protobuf.AbstractParser<PredictRequest>() {
        @java.lang.Override
        public PredictRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new PredictRequest(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<PredictRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PredictRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PredictRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
