/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/featurestore_service.proto

package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Request message for [FeaturestoreService.ImportFeatureValues][google.cloud.aiplatform.v1beta1.FeaturestoreService.ImportFeatureValues].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest}
 */
public final class ImportFeatureValuesRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest)
    ImportFeatureValuesRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ImportFeatureValuesRequest.newBuilder() to construct.
  private ImportFeatureValuesRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ImportFeatureValuesRequest() {
    entityType_ = "";
    entityIdField_ = "";
    featureSpecs_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ImportFeatureValuesRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ImportFeatureValuesRequest(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              entityType_ = s;
              break;
            }
          case 18:
            {
              com.google.cloud.aiplatform.v1beta1.AvroSource.Builder subBuilder = null;
              if (sourceCase_ == 2) {
                subBuilder = ((com.google.cloud.aiplatform.v1beta1.AvroSource) source_).toBuilder();
              }
              source_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.AvroSource.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.cloud.aiplatform.v1beta1.AvroSource) source_);
                source_ = subBuilder.buildPartial();
              }
              sourceCase_ = 2;
              break;
            }
          case 26:
            {
              com.google.cloud.aiplatform.v1beta1.BigQuerySource.Builder subBuilder = null;
              if (sourceCase_ == 3) {
                subBuilder =
                    ((com.google.cloud.aiplatform.v1beta1.BigQuerySource) source_).toBuilder();
              }
              source_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.BigQuerySource.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.cloud.aiplatform.v1beta1.BigQuerySource) source_);
                source_ = subBuilder.buildPartial();
              }
              sourceCase_ = 3;
              break;
            }
          case 34:
            {
              com.google.cloud.aiplatform.v1beta1.CsvSource.Builder subBuilder = null;
              if (sourceCase_ == 4) {
                subBuilder = ((com.google.cloud.aiplatform.v1beta1.CsvSource) source_).toBuilder();
              }
              source_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.CsvSource.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.cloud.aiplatform.v1beta1.CsvSource) source_);
                source_ = subBuilder.buildPartial();
              }
              sourceCase_ = 4;
              break;
            }
          case 42:
            {
              java.lang.String s = input.readStringRequireUtf8();

              entityIdField_ = s;
              break;
            }
          case 50:
            {
              java.lang.String s = input.readStringRequireUtf8();
              featureTimeSourceCase_ = 6;
              featureTimeSource_ = s;
              break;
            }
          case 58:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (featureTimeSourceCase_ == 7) {
                subBuilder = ((com.google.protobuf.Timestamp) featureTimeSource_).toBuilder();
              }
              featureTimeSource_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.protobuf.Timestamp) featureTimeSource_);
                featureTimeSource_ = subBuilder.buildPartial();
              }
              featureTimeSourceCase_ = 7;
              break;
            }
          case 66:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                featureSpecs_ =
                    new java.util.ArrayList<
                        com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest
                            .FeatureSpec>();
                mutable_bitField0_ |= 0x00000001;
              }
              featureSpecs_.add(
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec
                          .parser(),
                      extensionRegistry));
              break;
            }
          case 72:
            {
              disableOnlineServing_ = input.readBool();
              break;
            }
          case 88:
            {
              workerCount_ = input.readInt32();
              break;
            }
          case 96:
            {
              disableIngestionAnalysis_ = input.readBool();
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        featureSpecs_ = java.util.Collections.unmodifiableList(featureSpecs_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.FeaturestoreServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_ImportFeatureValuesRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.FeaturestoreServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_ImportFeatureValuesRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.class,
            com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.Builder.class);
  }

  public interface FeatureSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. ID of the Feature to import values of. This Feature must exist in the
     * target EntityType, or the request will fail.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The id.
     */
    java.lang.String getId();
    /**
     *
     *
     * <pre>
     * Required. ID of the Feature to import values of. This Feature must exist in the
     * target EntityType, or the request will fail.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for id.
     */
    com.google.protobuf.ByteString getIdBytes();

    /**
     *
     *
     * <pre>
     * Source column to get the Feature values from. If not set, uses the column
     * with the same name as the Feature ID.
     * </pre>
     *
     * <code>string source_field = 2;</code>
     *
     * @return The sourceField.
     */
    java.lang.String getSourceField();
    /**
     *
     *
     * <pre>
     * Source column to get the Feature values from. If not set, uses the column
     * with the same name as the Feature ID.
     * </pre>
     *
     * <code>string source_field = 2;</code>
     *
     * @return The bytes for sourceField.
     */
    com.google.protobuf.ByteString getSourceFieldBytes();
  }
  /**
   *
   *
   * <pre>
   * Defines the Feature value(s) to import.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec}
   */
  public static final class FeatureSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec)
      FeatureSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use FeatureSpec.newBuilder() to construct.
    private FeatureSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private FeatureSpec() {
      id_ = "";
      sourceField_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new FeatureSpec();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private FeatureSpec(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                id_ = s;
                break;
              }
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();

                sourceField_ = s;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.FeaturestoreServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_ImportFeatureValuesRequest_FeatureSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.FeaturestoreServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_ImportFeatureValuesRequest_FeatureSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec.class,
              com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec.Builder
                  .class);
    }

    public static final int ID_FIELD_NUMBER = 1;
    private volatile java.lang.Object id_;
    /**
     *
     *
     * <pre>
     * Required. ID of the Feature to import values of. This Feature must exist in the
     * target EntityType, or the request will fail.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. ID of the Feature to import values of. This Feature must exist in the
     * target EntityType, or the request will fail.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for id.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SOURCE_FIELD_FIELD_NUMBER = 2;
    private volatile java.lang.Object sourceField_;
    /**
     *
     *
     * <pre>
     * Source column to get the Feature values from. If not set, uses the column
     * with the same name as the Feature ID.
     * </pre>
     *
     * <code>string source_field = 2;</code>
     *
     * @return The sourceField.
     */
    @java.lang.Override
    public java.lang.String getSourceField() {
      java.lang.Object ref = sourceField_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceField_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Source column to get the Feature values from. If not set, uses the column
     * with the same name as the Feature ID.
     * </pre>
     *
     * <code>string source_field = 2;</code>
     *
     * @return The bytes for sourceField.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSourceFieldBytes() {
      java.lang.Object ref = sourceField_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceField_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceField_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, sourceField_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceField_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, sourceField_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec other =
          (com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec) obj;

      if (!getId().equals(other.getId())) return false;
      if (!getSourceField().equals(other.getSourceField())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + getId().hashCode();
      hash = (37 * hash) + SOURCE_FIELD_FIELD_NUMBER;
      hash = (53 * hash) + getSourceField().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Defines the Feature value(s) to import.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec)
        com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.FeaturestoreServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_ImportFeatureValuesRequest_FeatureSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.FeaturestoreServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_ImportFeatureValuesRequest_FeatureSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec.class,
                com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        id_ = "";

        sourceField_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.FeaturestoreServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_ImportFeatureValuesRequest_FeatureSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec build() {
        com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec result =
            new com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec(this);
        result.id_ = id_;
        result.sourceField_ = sourceField_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec
                .getDefaultInstance()) return this;
        if (!other.getId().isEmpty()) {
          id_ = other.id_;
          onChanged();
        }
        if (!other.getSourceField().isEmpty()) {
          sourceField_ = other.sourceField_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec parsedMessage =
            null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object id_ = "";
      /**
       *
       *
       * <pre>
       * Required. ID of the Feature to import values of. This Feature must exist in the
       * target EntityType, or the request will fail.
       * </pre>
       *
       * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The id.
       */
      public java.lang.String getId() {
        java.lang.Object ref = id_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          id_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. ID of the Feature to import values of. This Feature must exist in the
       * target EntityType, or the request will fail.
       * </pre>
       *
       * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for id.
       */
      public com.google.protobuf.ByteString getIdBytes() {
        java.lang.Object ref = id_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          id_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. ID of the Feature to import values of. This Feature must exist in the
       * target EntityType, or the request will fail.
       * </pre>
       *
       * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The id to set.
       * @return This builder for chaining.
       */
      public Builder setId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        id_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. ID of the Feature to import values of. This Feature must exist in the
       * target EntityType, or the request will fail.
       * </pre>
       *
       * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearId() {

        id_ = getDefaultInstance().getId();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. ID of the Feature to import values of. This Feature must exist in the
       * target EntityType, or the request will fail.
       * </pre>
       *
       * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for id to set.
       * @return This builder for chaining.
       */
      public Builder setIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        id_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object sourceField_ = "";
      /**
       *
       *
       * <pre>
       * Source column to get the Feature values from. If not set, uses the column
       * with the same name as the Feature ID.
       * </pre>
       *
       * <code>string source_field = 2;</code>
       *
       * @return The sourceField.
       */
      public java.lang.String getSourceField() {
        java.lang.Object ref = sourceField_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          sourceField_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Source column to get the Feature values from. If not set, uses the column
       * with the same name as the Feature ID.
       * </pre>
       *
       * <code>string source_field = 2;</code>
       *
       * @return The bytes for sourceField.
       */
      public com.google.protobuf.ByteString getSourceFieldBytes() {
        java.lang.Object ref = sourceField_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          sourceField_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Source column to get the Feature values from. If not set, uses the column
       * with the same name as the Feature ID.
       * </pre>
       *
       * <code>string source_field = 2;</code>
       *
       * @param value The sourceField to set.
       * @return This builder for chaining.
       */
      public Builder setSourceField(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        sourceField_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Source column to get the Feature values from. If not set, uses the column
       * with the same name as the Feature ID.
       * </pre>
       *
       * <code>string source_field = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSourceField() {

        sourceField_ = getDefaultInstance().getSourceField();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Source column to get the Feature values from. If not set, uses the column
       * with the same name as the Feature ID.
       * </pre>
       *
       * <code>string source_field = 2;</code>
       *
       * @param value The bytes for sourceField to set.
       * @return This builder for chaining.
       */
      public Builder setSourceFieldBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        sourceField_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec)
    private static final com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec();
    }

    public static com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<FeatureSpec> PARSER =
        new com.google.protobuf.AbstractParser<FeatureSpec>() {
          @java.lang.Override
          public FeatureSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new FeatureSpec(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<FeatureSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FeatureSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int sourceCase_ = 0;
  private java.lang.Object source_;

  public enum SourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    AVRO_SOURCE(2),
    BIGQUERY_SOURCE(3),
    CSV_SOURCE(4),
    SOURCE_NOT_SET(0);
    private final int value;

    private SourceCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static SourceCase forNumber(int value) {
      switch (value) {
        case 2:
          return AVRO_SOURCE;
        case 3:
          return BIGQUERY_SOURCE;
        case 4:
          return CSV_SOURCE;
        case 0:
          return SOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SourceCase getSourceCase() {
    return SourceCase.forNumber(sourceCase_);
  }

  private int featureTimeSourceCase_ = 0;
  private java.lang.Object featureTimeSource_;

  public enum FeatureTimeSourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    FEATURE_TIME_FIELD(6),
    FEATURE_TIME(7),
    FEATURETIMESOURCE_NOT_SET(0);
    private final int value;

    private FeatureTimeSourceCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static FeatureTimeSourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static FeatureTimeSourceCase forNumber(int value) {
      switch (value) {
        case 6:
          return FEATURE_TIME_FIELD;
        case 7:
          return FEATURE_TIME;
        case 0:
          return FEATURETIMESOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public FeatureTimeSourceCase getFeatureTimeSourceCase() {
    return FeatureTimeSourceCase.forNumber(featureTimeSourceCase_);
  }

  public static final int AVRO_SOURCE_FIELD_NUMBER = 2;
  /**
   * <code>.google.cloud.aiplatform.v1beta1.AvroSource avro_source = 2;</code>
   *
   * @return Whether the avroSource field is set.
   */
  @java.lang.Override
  public boolean hasAvroSource() {
    return sourceCase_ == 2;
  }
  /**
   * <code>.google.cloud.aiplatform.v1beta1.AvroSource avro_source = 2;</code>
   *
   * @return The avroSource.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.AvroSource getAvroSource() {
    if (sourceCase_ == 2) {
      return (com.google.cloud.aiplatform.v1beta1.AvroSource) source_;
    }
    return com.google.cloud.aiplatform.v1beta1.AvroSource.getDefaultInstance();
  }
  /** <code>.google.cloud.aiplatform.v1beta1.AvroSource avro_source = 2;</code> */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.AvroSourceOrBuilder getAvroSourceOrBuilder() {
    if (sourceCase_ == 2) {
      return (com.google.cloud.aiplatform.v1beta1.AvroSource) source_;
    }
    return com.google.cloud.aiplatform.v1beta1.AvroSource.getDefaultInstance();
  }

  public static final int BIGQUERY_SOURCE_FIELD_NUMBER = 3;
  /**
   * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 3;</code>
   *
   * @return Whether the bigquerySource field is set.
   */
  @java.lang.Override
  public boolean hasBigquerySource() {
    return sourceCase_ == 3;
  }
  /**
   * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 3;</code>
   *
   * @return The bigquerySource.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.BigQuerySource getBigquerySource() {
    if (sourceCase_ == 3) {
      return (com.google.cloud.aiplatform.v1beta1.BigQuerySource) source_;
    }
    return com.google.cloud.aiplatform.v1beta1.BigQuerySource.getDefaultInstance();
  }
  /** <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 3;</code> */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.BigQuerySourceOrBuilder getBigquerySourceOrBuilder() {
    if (sourceCase_ == 3) {
      return (com.google.cloud.aiplatform.v1beta1.BigQuerySource) source_;
    }
    return com.google.cloud.aiplatform.v1beta1.BigQuerySource.getDefaultInstance();
  }

  public static final int CSV_SOURCE_FIELD_NUMBER = 4;
  /**
   * <code>.google.cloud.aiplatform.v1beta1.CsvSource csv_source = 4;</code>
   *
   * @return Whether the csvSource field is set.
   */
  @java.lang.Override
  public boolean hasCsvSource() {
    return sourceCase_ == 4;
  }
  /**
   * <code>.google.cloud.aiplatform.v1beta1.CsvSource csv_source = 4;</code>
   *
   * @return The csvSource.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.CsvSource getCsvSource() {
    if (sourceCase_ == 4) {
      return (com.google.cloud.aiplatform.v1beta1.CsvSource) source_;
    }
    return com.google.cloud.aiplatform.v1beta1.CsvSource.getDefaultInstance();
  }
  /** <code>.google.cloud.aiplatform.v1beta1.CsvSource csv_source = 4;</code> */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.CsvSourceOrBuilder getCsvSourceOrBuilder() {
    if (sourceCase_ == 4) {
      return (com.google.cloud.aiplatform.v1beta1.CsvSource) source_;
    }
    return com.google.cloud.aiplatform.v1beta1.CsvSource.getDefaultInstance();
  }

  public static final int FEATURE_TIME_FIELD_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Source column that holds the Feature timestamp for all Feature
   * values in each entity.
   * </pre>
   *
   * <code>string feature_time_field = 6;</code>
   *
   * @return Whether the featureTimeField field is set.
   */
  public boolean hasFeatureTimeField() {
    return featureTimeSourceCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Source column that holds the Feature timestamp for all Feature
   * values in each entity.
   * </pre>
   *
   * <code>string feature_time_field = 6;</code>
   *
   * @return The featureTimeField.
   */
  public java.lang.String getFeatureTimeField() {
    java.lang.Object ref = "";
    if (featureTimeSourceCase_ == 6) {
      ref = featureTimeSource_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (featureTimeSourceCase_ == 6) {
        featureTimeSource_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Source column that holds the Feature timestamp for all Feature
   * values in each entity.
   * </pre>
   *
   * <code>string feature_time_field = 6;</code>
   *
   * @return The bytes for featureTimeField.
   */
  public com.google.protobuf.ByteString getFeatureTimeFieldBytes() {
    java.lang.Object ref = "";
    if (featureTimeSourceCase_ == 6) {
      ref = featureTimeSource_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (featureTimeSourceCase_ == 6) {
        featureTimeSource_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FEATURE_TIME_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Single Feature timestamp for all entities being imported. The
   * timestamp must not have higher than millisecond precision.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp feature_time = 7;</code>
   *
   * @return Whether the featureTime field is set.
   */
  @java.lang.Override
  public boolean hasFeatureTime() {
    return featureTimeSourceCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Single Feature timestamp for all entities being imported. The
   * timestamp must not have higher than millisecond precision.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp feature_time = 7;</code>
   *
   * @return The featureTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getFeatureTime() {
    if (featureTimeSourceCase_ == 7) {
      return (com.google.protobuf.Timestamp) featureTimeSource_;
    }
    return com.google.protobuf.Timestamp.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Single Feature timestamp for all entities being imported. The
   * timestamp must not have higher than millisecond precision.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp feature_time = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getFeatureTimeOrBuilder() {
    if (featureTimeSourceCase_ == 7) {
      return (com.google.protobuf.Timestamp) featureTimeSource_;
    }
    return com.google.protobuf.Timestamp.getDefaultInstance();
  }

  public static final int ENTITY_TYPE_FIELD_NUMBER = 1;
  private volatile java.lang.Object entityType_;
  /**
   *
   *
   * <pre>
   * Required. The resource name of the EntityType grouping the Features for which values
   * are being imported. Format:
   * `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entityType}`
   * </pre>
   *
   * <code>
   * string entity_type = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The entityType.
   */
  @java.lang.Override
  public java.lang.String getEntityType() {
    java.lang.Object ref = entityType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      entityType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the EntityType grouping the Features for which values
   * are being imported. Format:
   * `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entityType}`
   * </pre>
   *
   * <code>
   * string entity_type = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for entityType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEntityTypeBytes() {
    java.lang.Object ref = entityType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      entityType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENTITY_ID_FIELD_FIELD_NUMBER = 5;
  private volatile java.lang.Object entityIdField_;
  /**
   *
   *
   * <pre>
   * Source column that holds entity IDs. If not provided, entity IDs are
   * extracted from the column named `entity_id`.
   * </pre>
   *
   * <code>string entity_id_field = 5;</code>
   *
   * @return The entityIdField.
   */
  @java.lang.Override
  public java.lang.String getEntityIdField() {
    java.lang.Object ref = entityIdField_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      entityIdField_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Source column that holds entity IDs. If not provided, entity IDs are
   * extracted from the column named `entity_id`.
   * </pre>
   *
   * <code>string entity_id_field = 5;</code>
   *
   * @return The bytes for entityIdField.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEntityIdFieldBytes() {
    java.lang.Object ref = entityIdField_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      entityIdField_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FEATURE_SPECS_FIELD_NUMBER = 8;
  private java.util.List<com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec>
      featureSpecs_;
  /**
   *
   *
   * <pre>
   * Required. Specifications defining which Feature values to import from the entity. The
   * request fails if no feature_specs are provided, and having multiple
   * feature_specs for one Feature is not allowed.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec feature_specs = 8 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec>
      getFeatureSpecsList() {
    return featureSpecs_;
  }
  /**
   *
   *
   * <pre>
   * Required. Specifications defining which Feature values to import from the entity. The
   * request fails if no feature_specs are provided, and having multiple
   * feature_specs for one Feature is not allowed.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec feature_specs = 8 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpecOrBuilder>
      getFeatureSpecsOrBuilderList() {
    return featureSpecs_;
  }
  /**
   *
   *
   * <pre>
   * Required. Specifications defining which Feature values to import from the entity. The
   * request fails if no feature_specs are provided, and having multiple
   * feature_specs for one Feature is not allowed.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec feature_specs = 8 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getFeatureSpecsCount() {
    return featureSpecs_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. Specifications defining which Feature values to import from the entity. The
   * request fails if no feature_specs are provided, and having multiple
   * feature_specs for one Feature is not allowed.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec feature_specs = 8 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec getFeatureSpecs(
      int index) {
    return featureSpecs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. Specifications defining which Feature values to import from the entity. The
   * request fails if no feature_specs are provided, and having multiple
   * feature_specs for one Feature is not allowed.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec feature_specs = 8 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpecOrBuilder
      getFeatureSpecsOrBuilder(int index) {
    return featureSpecs_.get(index);
  }

  public static final int DISABLE_ONLINE_SERVING_FIELD_NUMBER = 9;
  private boolean disableOnlineServing_;
  /**
   *
   *
   * <pre>
   * If set, data will not be imported for online serving. This
   * is typically used for backfilling, where Feature generation timestamps are
   * not in the timestamp range needed for online serving.
   * </pre>
   *
   * <code>bool disable_online_serving = 9;</code>
   *
   * @return The disableOnlineServing.
   */
  @java.lang.Override
  public boolean getDisableOnlineServing() {
    return disableOnlineServing_;
  }

  public static final int WORKER_COUNT_FIELD_NUMBER = 11;
  private int workerCount_;
  /**
   *
   *
   * <pre>
   * Specifies the number of workers that are used to write data to the
   * Featurestore. Consider the online serving capacity that you require to
   * achieve the desired import throughput without interfering with online
   * serving. The value must be positive, and less than or equal to 100.
   * If not set, defaults to using 1 worker. The low count ensures minimal
   * impact on online serving performance.
   * </pre>
   *
   * <code>int32 worker_count = 11;</code>
   *
   * @return The workerCount.
   */
  @java.lang.Override
  public int getWorkerCount() {
    return workerCount_;
  }

  public static final int DISABLE_INGESTION_ANALYSIS_FIELD_NUMBER = 12;
  private boolean disableIngestionAnalysis_;
  /**
   *
   *
   * <pre>
   * If true, API doesn't start ingestion analysis pipeline.
   * </pre>
   *
   * <code>bool disable_ingestion_analysis = 12;</code>
   *
   * @return The disableIngestionAnalysis.
   */
  @java.lang.Override
  public boolean getDisableIngestionAnalysis() {
    return disableIngestionAnalysis_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entityType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, entityType_);
    }
    if (sourceCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.aiplatform.v1beta1.AvroSource) source_);
    }
    if (sourceCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.aiplatform.v1beta1.BigQuerySource) source_);
    }
    if (sourceCase_ == 4) {
      output.writeMessage(4, (com.google.cloud.aiplatform.v1beta1.CsvSource) source_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entityIdField_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, entityIdField_);
    }
    if (featureTimeSourceCase_ == 6) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, featureTimeSource_);
    }
    if (featureTimeSourceCase_ == 7) {
      output.writeMessage(7, (com.google.protobuf.Timestamp) featureTimeSource_);
    }
    for (int i = 0; i < featureSpecs_.size(); i++) {
      output.writeMessage(8, featureSpecs_.get(i));
    }
    if (disableOnlineServing_ != false) {
      output.writeBool(9, disableOnlineServing_);
    }
    if (workerCount_ != 0) {
      output.writeInt32(11, workerCount_);
    }
    if (disableIngestionAnalysis_ != false) {
      output.writeBool(12, disableIngestionAnalysis_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entityType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, entityType_);
    }
    if (sourceCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.aiplatform.v1beta1.AvroSource) source_);
    }
    if (sourceCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.aiplatform.v1beta1.BigQuerySource) source_);
    }
    if (sourceCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.aiplatform.v1beta1.CsvSource) source_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entityIdField_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, entityIdField_);
    }
    if (featureTimeSourceCase_ == 6) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, featureTimeSource_);
    }
    if (featureTimeSourceCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.protobuf.Timestamp) featureTimeSource_);
    }
    for (int i = 0; i < featureSpecs_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, featureSpecs_.get(i));
    }
    if (disableOnlineServing_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(9, disableOnlineServing_);
    }
    if (workerCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(11, workerCount_);
    }
    if (disableIngestionAnalysis_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(12, disableIngestionAnalysis_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest other =
        (com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest) obj;

    if (!getEntityType().equals(other.getEntityType())) return false;
    if (!getEntityIdField().equals(other.getEntityIdField())) return false;
    if (!getFeatureSpecsList().equals(other.getFeatureSpecsList())) return false;
    if (getDisableOnlineServing() != other.getDisableOnlineServing()) return false;
    if (getWorkerCount() != other.getWorkerCount()) return false;
    if (getDisableIngestionAnalysis() != other.getDisableIngestionAnalysis()) return false;
    if (!getSourceCase().equals(other.getSourceCase())) return false;
    switch (sourceCase_) {
      case 2:
        if (!getAvroSource().equals(other.getAvroSource())) return false;
        break;
      case 3:
        if (!getBigquerySource().equals(other.getBigquerySource())) return false;
        break;
      case 4:
        if (!getCsvSource().equals(other.getCsvSource())) return false;
        break;
      case 0:
      default:
    }
    if (!getFeatureTimeSourceCase().equals(other.getFeatureTimeSourceCase())) return false;
    switch (featureTimeSourceCase_) {
      case 6:
        if (!getFeatureTimeField().equals(other.getFeatureTimeField())) return false;
        break;
      case 7:
        if (!getFeatureTime().equals(other.getFeatureTime())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ENTITY_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getEntityType().hashCode();
    hash = (37 * hash) + ENTITY_ID_FIELD_FIELD_NUMBER;
    hash = (53 * hash) + getEntityIdField().hashCode();
    if (getFeatureSpecsCount() > 0) {
      hash = (37 * hash) + FEATURE_SPECS_FIELD_NUMBER;
      hash = (53 * hash) + getFeatureSpecsList().hashCode();
    }
    hash = (37 * hash) + DISABLE_ONLINE_SERVING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisableOnlineServing());
    hash = (37 * hash) + WORKER_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getWorkerCount();
    hash = (37 * hash) + DISABLE_INGESTION_ANALYSIS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisableIngestionAnalysis());
    switch (sourceCase_) {
      case 2:
        hash = (37 * hash) + AVRO_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getAvroSource().hashCode();
        break;
      case 3:
        hash = (37 * hash) + BIGQUERY_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getBigquerySource().hashCode();
        break;
      case 4:
        hash = (37 * hash) + CSV_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getCsvSource().hashCode();
        break;
      case 0:
      default:
    }
    switch (featureTimeSourceCase_) {
      case 6:
        hash = (37 * hash) + FEATURE_TIME_FIELD_FIELD_NUMBER;
        hash = (53 * hash) + getFeatureTimeField().hashCode();
        break;
      case 7:
        hash = (37 * hash) + FEATURE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getFeatureTime().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for [FeaturestoreService.ImportFeatureValues][google.cloud.aiplatform.v1beta1.FeaturestoreService.ImportFeatureValues].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest)
      com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.FeaturestoreServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_ImportFeatureValuesRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.FeaturestoreServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_ImportFeatureValuesRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.class,
              com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getFeatureSpecsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      entityType_ = "";

      entityIdField_ = "";

      if (featureSpecsBuilder_ == null) {
        featureSpecs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        featureSpecsBuilder_.clear();
      }
      disableOnlineServing_ = false;

      workerCount_ = 0;

      disableIngestionAnalysis_ = false;

      sourceCase_ = 0;
      source_ = null;
      featureTimeSourceCase_ = 0;
      featureTimeSource_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.FeaturestoreServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_ImportFeatureValuesRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest
        getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest build() {
      com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest buildPartial() {
      com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest result =
          new com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest(this);
      int from_bitField0_ = bitField0_;
      if (sourceCase_ == 2) {
        if (avroSourceBuilder_ == null) {
          result.source_ = source_;
        } else {
          result.source_ = avroSourceBuilder_.build();
        }
      }
      if (sourceCase_ == 3) {
        if (bigquerySourceBuilder_ == null) {
          result.source_ = source_;
        } else {
          result.source_ = bigquerySourceBuilder_.build();
        }
      }
      if (sourceCase_ == 4) {
        if (csvSourceBuilder_ == null) {
          result.source_ = source_;
        } else {
          result.source_ = csvSourceBuilder_.build();
        }
      }
      if (featureTimeSourceCase_ == 6) {
        result.featureTimeSource_ = featureTimeSource_;
      }
      if (featureTimeSourceCase_ == 7) {
        if (featureTimeBuilder_ == null) {
          result.featureTimeSource_ = featureTimeSource_;
        } else {
          result.featureTimeSource_ = featureTimeBuilder_.build();
        }
      }
      result.entityType_ = entityType_;
      result.entityIdField_ = entityIdField_;
      if (featureSpecsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          featureSpecs_ = java.util.Collections.unmodifiableList(featureSpecs_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.featureSpecs_ = featureSpecs_;
      } else {
        result.featureSpecs_ = featureSpecsBuilder_.build();
      }
      result.disableOnlineServing_ = disableOnlineServing_;
      result.workerCount_ = workerCount_;
      result.disableIngestionAnalysis_ = disableIngestionAnalysis_;
      result.sourceCase_ = sourceCase_;
      result.featureTimeSourceCase_ = featureTimeSourceCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest other) {
      if (other
          == com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.getDefaultInstance())
        return this;
      if (!other.getEntityType().isEmpty()) {
        entityType_ = other.entityType_;
        onChanged();
      }
      if (!other.getEntityIdField().isEmpty()) {
        entityIdField_ = other.entityIdField_;
        onChanged();
      }
      if (featureSpecsBuilder_ == null) {
        if (!other.featureSpecs_.isEmpty()) {
          if (featureSpecs_.isEmpty()) {
            featureSpecs_ = other.featureSpecs_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureFeatureSpecsIsMutable();
            featureSpecs_.addAll(other.featureSpecs_);
          }
          onChanged();
        }
      } else {
        if (!other.featureSpecs_.isEmpty()) {
          if (featureSpecsBuilder_.isEmpty()) {
            featureSpecsBuilder_.dispose();
            featureSpecsBuilder_ = null;
            featureSpecs_ = other.featureSpecs_;
            bitField0_ = (bitField0_ & ~0x00000001);
            featureSpecsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFeatureSpecsFieldBuilder()
                    : null;
          } else {
            featureSpecsBuilder_.addAllMessages(other.featureSpecs_);
          }
        }
      }
      if (other.getDisableOnlineServing() != false) {
        setDisableOnlineServing(other.getDisableOnlineServing());
      }
      if (other.getWorkerCount() != 0) {
        setWorkerCount(other.getWorkerCount());
      }
      if (other.getDisableIngestionAnalysis() != false) {
        setDisableIngestionAnalysis(other.getDisableIngestionAnalysis());
      }
      switch (other.getSourceCase()) {
        case AVRO_SOURCE:
          {
            mergeAvroSource(other.getAvroSource());
            break;
          }
        case BIGQUERY_SOURCE:
          {
            mergeBigquerySource(other.getBigquerySource());
            break;
          }
        case CSV_SOURCE:
          {
            mergeCsvSource(other.getCsvSource());
            break;
          }
        case SOURCE_NOT_SET:
          {
            break;
          }
      }
      switch (other.getFeatureTimeSourceCase()) {
        case FEATURE_TIME_FIELD:
          {
            featureTimeSourceCase_ = 6;
            featureTimeSource_ = other.featureTimeSource_;
            onChanged();
            break;
          }
        case FEATURE_TIME:
          {
            mergeFeatureTime(other.getFeatureTime());
            break;
          }
        case FEATURETIMESOURCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest)
                e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int sourceCase_ = 0;
    private java.lang.Object source_;

    public SourceCase getSourceCase() {
      return SourceCase.forNumber(sourceCase_);
    }

    public Builder clearSource() {
      sourceCase_ = 0;
      source_ = null;
      onChanged();
      return this;
    }

    private int featureTimeSourceCase_ = 0;
    private java.lang.Object featureTimeSource_;

    public FeatureTimeSourceCase getFeatureTimeSourceCase() {
      return FeatureTimeSourceCase.forNumber(featureTimeSourceCase_);
    }

    public Builder clearFeatureTimeSource() {
      featureTimeSourceCase_ = 0;
      featureTimeSource_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.AvroSource,
            com.google.cloud.aiplatform.v1beta1.AvroSource.Builder,
            com.google.cloud.aiplatform.v1beta1.AvroSourceOrBuilder>
        avroSourceBuilder_;
    /**
     * <code>.google.cloud.aiplatform.v1beta1.AvroSource avro_source = 2;</code>
     *
     * @return Whether the avroSource field is set.
     */
    @java.lang.Override
    public boolean hasAvroSource() {
      return sourceCase_ == 2;
    }
    /**
     * <code>.google.cloud.aiplatform.v1beta1.AvroSource avro_source = 2;</code>
     *
     * @return The avroSource.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AvroSource getAvroSource() {
      if (avroSourceBuilder_ == null) {
        if (sourceCase_ == 2) {
          return (com.google.cloud.aiplatform.v1beta1.AvroSource) source_;
        }
        return com.google.cloud.aiplatform.v1beta1.AvroSource.getDefaultInstance();
      } else {
        if (sourceCase_ == 2) {
          return avroSourceBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.AvroSource.getDefaultInstance();
      }
    }
    /** <code>.google.cloud.aiplatform.v1beta1.AvroSource avro_source = 2;</code> */
    public Builder setAvroSource(com.google.cloud.aiplatform.v1beta1.AvroSource value) {
      if (avroSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        avroSourceBuilder_.setMessage(value);
      }
      sourceCase_ = 2;
      return this;
    }
    /** <code>.google.cloud.aiplatform.v1beta1.AvroSource avro_source = 2;</code> */
    public Builder setAvroSource(
        com.google.cloud.aiplatform.v1beta1.AvroSource.Builder builderForValue) {
      if (avroSourceBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        avroSourceBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 2;
      return this;
    }
    /** <code>.google.cloud.aiplatform.v1beta1.AvroSource avro_source = 2;</code> */
    public Builder mergeAvroSource(com.google.cloud.aiplatform.v1beta1.AvroSource value) {
      if (avroSourceBuilder_ == null) {
        if (sourceCase_ == 2
            && source_ != com.google.cloud.aiplatform.v1beta1.AvroSource.getDefaultInstance()) {
          source_ =
              com.google.cloud.aiplatform.v1beta1.AvroSource.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.AvroSource) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 2) {
          avroSourceBuilder_.mergeFrom(value);
        } else {
          avroSourceBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 2;
      return this;
    }
    /** <code>.google.cloud.aiplatform.v1beta1.AvroSource avro_source = 2;</code> */
    public Builder clearAvroSource() {
      if (avroSourceBuilder_ == null) {
        if (sourceCase_ == 2) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 2) {
          sourceCase_ = 0;
          source_ = null;
        }
        avroSourceBuilder_.clear();
      }
      return this;
    }
    /** <code>.google.cloud.aiplatform.v1beta1.AvroSource avro_source = 2;</code> */
    public com.google.cloud.aiplatform.v1beta1.AvroSource.Builder getAvroSourceBuilder() {
      return getAvroSourceFieldBuilder().getBuilder();
    }
    /** <code>.google.cloud.aiplatform.v1beta1.AvroSource avro_source = 2;</code> */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AvroSourceOrBuilder getAvroSourceOrBuilder() {
      if ((sourceCase_ == 2) && (avroSourceBuilder_ != null)) {
        return avroSourceBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 2) {
          return (com.google.cloud.aiplatform.v1beta1.AvroSource) source_;
        }
        return com.google.cloud.aiplatform.v1beta1.AvroSource.getDefaultInstance();
      }
    }
    /** <code>.google.cloud.aiplatform.v1beta1.AvroSource avro_source = 2;</code> */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.AvroSource,
            com.google.cloud.aiplatform.v1beta1.AvroSource.Builder,
            com.google.cloud.aiplatform.v1beta1.AvroSourceOrBuilder>
        getAvroSourceFieldBuilder() {
      if (avroSourceBuilder_ == null) {
        if (!(sourceCase_ == 2)) {
          source_ = com.google.cloud.aiplatform.v1beta1.AvroSource.getDefaultInstance();
        }
        avroSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.AvroSource,
                com.google.cloud.aiplatform.v1beta1.AvroSource.Builder,
                com.google.cloud.aiplatform.v1beta1.AvroSourceOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.AvroSource) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 2;
      onChanged();
      ;
      return avroSourceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.BigQuerySource,
            com.google.cloud.aiplatform.v1beta1.BigQuerySource.Builder,
            com.google.cloud.aiplatform.v1beta1.BigQuerySourceOrBuilder>
        bigquerySourceBuilder_;
    /**
     * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 3;</code>
     *
     * @return Whether the bigquerySource field is set.
     */
    @java.lang.Override
    public boolean hasBigquerySource() {
      return sourceCase_ == 3;
    }
    /**
     * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 3;</code>
     *
     * @return The bigquerySource.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.BigQuerySource getBigquerySource() {
      if (bigquerySourceBuilder_ == null) {
        if (sourceCase_ == 3) {
          return (com.google.cloud.aiplatform.v1beta1.BigQuerySource) source_;
        }
        return com.google.cloud.aiplatform.v1beta1.BigQuerySource.getDefaultInstance();
      } else {
        if (sourceCase_ == 3) {
          return bigquerySourceBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.BigQuerySource.getDefaultInstance();
      }
    }
    /** <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 3;</code> */
    public Builder setBigquerySource(com.google.cloud.aiplatform.v1beta1.BigQuerySource value) {
      if (bigquerySourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        bigquerySourceBuilder_.setMessage(value);
      }
      sourceCase_ = 3;
      return this;
    }
    /** <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 3;</code> */
    public Builder setBigquerySource(
        com.google.cloud.aiplatform.v1beta1.BigQuerySource.Builder builderForValue) {
      if (bigquerySourceBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        bigquerySourceBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 3;
      return this;
    }
    /** <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 3;</code> */
    public Builder mergeBigquerySource(com.google.cloud.aiplatform.v1beta1.BigQuerySource value) {
      if (bigquerySourceBuilder_ == null) {
        if (sourceCase_ == 3
            && source_ != com.google.cloud.aiplatform.v1beta1.BigQuerySource.getDefaultInstance()) {
          source_ =
              com.google.cloud.aiplatform.v1beta1.BigQuerySource.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.BigQuerySource) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 3) {
          bigquerySourceBuilder_.mergeFrom(value);
        } else {
          bigquerySourceBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 3;
      return this;
    }
    /** <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 3;</code> */
    public Builder clearBigquerySource() {
      if (bigquerySourceBuilder_ == null) {
        if (sourceCase_ == 3) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 3) {
          sourceCase_ = 0;
          source_ = null;
        }
        bigquerySourceBuilder_.clear();
      }
      return this;
    }
    /** <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 3;</code> */
    public com.google.cloud.aiplatform.v1beta1.BigQuerySource.Builder getBigquerySourceBuilder() {
      return getBigquerySourceFieldBuilder().getBuilder();
    }
    /** <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 3;</code> */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.BigQuerySourceOrBuilder
        getBigquerySourceOrBuilder() {
      if ((sourceCase_ == 3) && (bigquerySourceBuilder_ != null)) {
        return bigquerySourceBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 3) {
          return (com.google.cloud.aiplatform.v1beta1.BigQuerySource) source_;
        }
        return com.google.cloud.aiplatform.v1beta1.BigQuerySource.getDefaultInstance();
      }
    }
    /** <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 3;</code> */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.BigQuerySource,
            com.google.cloud.aiplatform.v1beta1.BigQuerySource.Builder,
            com.google.cloud.aiplatform.v1beta1.BigQuerySourceOrBuilder>
        getBigquerySourceFieldBuilder() {
      if (bigquerySourceBuilder_ == null) {
        if (!(sourceCase_ == 3)) {
          source_ = com.google.cloud.aiplatform.v1beta1.BigQuerySource.getDefaultInstance();
        }
        bigquerySourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.BigQuerySource,
                com.google.cloud.aiplatform.v1beta1.BigQuerySource.Builder,
                com.google.cloud.aiplatform.v1beta1.BigQuerySourceOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.BigQuerySource) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 3;
      onChanged();
      ;
      return bigquerySourceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.CsvSource,
            com.google.cloud.aiplatform.v1beta1.CsvSource.Builder,
            com.google.cloud.aiplatform.v1beta1.CsvSourceOrBuilder>
        csvSourceBuilder_;
    /**
     * <code>.google.cloud.aiplatform.v1beta1.CsvSource csv_source = 4;</code>
     *
     * @return Whether the csvSource field is set.
     */
    @java.lang.Override
    public boolean hasCsvSource() {
      return sourceCase_ == 4;
    }
    /**
     * <code>.google.cloud.aiplatform.v1beta1.CsvSource csv_source = 4;</code>
     *
     * @return The csvSource.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.CsvSource getCsvSource() {
      if (csvSourceBuilder_ == null) {
        if (sourceCase_ == 4) {
          return (com.google.cloud.aiplatform.v1beta1.CsvSource) source_;
        }
        return com.google.cloud.aiplatform.v1beta1.CsvSource.getDefaultInstance();
      } else {
        if (sourceCase_ == 4) {
          return csvSourceBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.CsvSource.getDefaultInstance();
      }
    }
    /** <code>.google.cloud.aiplatform.v1beta1.CsvSource csv_source = 4;</code> */
    public Builder setCsvSource(com.google.cloud.aiplatform.v1beta1.CsvSource value) {
      if (csvSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        csvSourceBuilder_.setMessage(value);
      }
      sourceCase_ = 4;
      return this;
    }
    /** <code>.google.cloud.aiplatform.v1beta1.CsvSource csv_source = 4;</code> */
    public Builder setCsvSource(
        com.google.cloud.aiplatform.v1beta1.CsvSource.Builder builderForValue) {
      if (csvSourceBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        csvSourceBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 4;
      return this;
    }
    /** <code>.google.cloud.aiplatform.v1beta1.CsvSource csv_source = 4;</code> */
    public Builder mergeCsvSource(com.google.cloud.aiplatform.v1beta1.CsvSource value) {
      if (csvSourceBuilder_ == null) {
        if (sourceCase_ == 4
            && source_ != com.google.cloud.aiplatform.v1beta1.CsvSource.getDefaultInstance()) {
          source_ =
              com.google.cloud.aiplatform.v1beta1.CsvSource.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.CsvSource) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 4) {
          csvSourceBuilder_.mergeFrom(value);
        } else {
          csvSourceBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 4;
      return this;
    }
    /** <code>.google.cloud.aiplatform.v1beta1.CsvSource csv_source = 4;</code> */
    public Builder clearCsvSource() {
      if (csvSourceBuilder_ == null) {
        if (sourceCase_ == 4) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 4) {
          sourceCase_ = 0;
          source_ = null;
        }
        csvSourceBuilder_.clear();
      }
      return this;
    }
    /** <code>.google.cloud.aiplatform.v1beta1.CsvSource csv_source = 4;</code> */
    public com.google.cloud.aiplatform.v1beta1.CsvSource.Builder getCsvSourceBuilder() {
      return getCsvSourceFieldBuilder().getBuilder();
    }
    /** <code>.google.cloud.aiplatform.v1beta1.CsvSource csv_source = 4;</code> */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.CsvSourceOrBuilder getCsvSourceOrBuilder() {
      if ((sourceCase_ == 4) && (csvSourceBuilder_ != null)) {
        return csvSourceBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 4) {
          return (com.google.cloud.aiplatform.v1beta1.CsvSource) source_;
        }
        return com.google.cloud.aiplatform.v1beta1.CsvSource.getDefaultInstance();
      }
    }
    /** <code>.google.cloud.aiplatform.v1beta1.CsvSource csv_source = 4;</code> */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.CsvSource,
            com.google.cloud.aiplatform.v1beta1.CsvSource.Builder,
            com.google.cloud.aiplatform.v1beta1.CsvSourceOrBuilder>
        getCsvSourceFieldBuilder() {
      if (csvSourceBuilder_ == null) {
        if (!(sourceCase_ == 4)) {
          source_ = com.google.cloud.aiplatform.v1beta1.CsvSource.getDefaultInstance();
        }
        csvSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.CsvSource,
                com.google.cloud.aiplatform.v1beta1.CsvSource.Builder,
                com.google.cloud.aiplatform.v1beta1.CsvSourceOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.CsvSource) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 4;
      onChanged();
      ;
      return csvSourceBuilder_;
    }

    /**
     *
     *
     * <pre>
     * Source column that holds the Feature timestamp for all Feature
     * values in each entity.
     * </pre>
     *
     * <code>string feature_time_field = 6;</code>
     *
     * @return Whether the featureTimeField field is set.
     */
    @java.lang.Override
    public boolean hasFeatureTimeField() {
      return featureTimeSourceCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Source column that holds the Feature timestamp for all Feature
     * values in each entity.
     * </pre>
     *
     * <code>string feature_time_field = 6;</code>
     *
     * @return The featureTimeField.
     */
    @java.lang.Override
    public java.lang.String getFeatureTimeField() {
      java.lang.Object ref = "";
      if (featureTimeSourceCase_ == 6) {
        ref = featureTimeSource_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (featureTimeSourceCase_ == 6) {
          featureTimeSource_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Source column that holds the Feature timestamp for all Feature
     * values in each entity.
     * </pre>
     *
     * <code>string feature_time_field = 6;</code>
     *
     * @return The bytes for featureTimeField.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFeatureTimeFieldBytes() {
      java.lang.Object ref = "";
      if (featureTimeSourceCase_ == 6) {
        ref = featureTimeSource_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (featureTimeSourceCase_ == 6) {
          featureTimeSource_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Source column that holds the Feature timestamp for all Feature
     * values in each entity.
     * </pre>
     *
     * <code>string feature_time_field = 6;</code>
     *
     * @param value The featureTimeField to set.
     * @return This builder for chaining.
     */
    public Builder setFeatureTimeField(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      featureTimeSourceCase_ = 6;
      featureTimeSource_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source column that holds the Feature timestamp for all Feature
     * values in each entity.
     * </pre>
     *
     * <code>string feature_time_field = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFeatureTimeField() {
      if (featureTimeSourceCase_ == 6) {
        featureTimeSourceCase_ = 0;
        featureTimeSource_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source column that holds the Feature timestamp for all Feature
     * values in each entity.
     * </pre>
     *
     * <code>string feature_time_field = 6;</code>
     *
     * @param value The bytes for featureTimeField to set.
     * @return This builder for chaining.
     */
    public Builder setFeatureTimeFieldBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      featureTimeSourceCase_ = 6;
      featureTimeSource_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        featureTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Single Feature timestamp for all entities being imported. The
     * timestamp must not have higher than millisecond precision.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp feature_time = 7;</code>
     *
     * @return Whether the featureTime field is set.
     */
    @java.lang.Override
    public boolean hasFeatureTime() {
      return featureTimeSourceCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Single Feature timestamp for all entities being imported. The
     * timestamp must not have higher than millisecond precision.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp feature_time = 7;</code>
     *
     * @return The featureTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getFeatureTime() {
      if (featureTimeBuilder_ == null) {
        if (featureTimeSourceCase_ == 7) {
          return (com.google.protobuf.Timestamp) featureTimeSource_;
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      } else {
        if (featureTimeSourceCase_ == 7) {
          return featureTimeBuilder_.getMessage();
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Single Feature timestamp for all entities being imported. The
     * timestamp must not have higher than millisecond precision.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp feature_time = 7;</code>
     */
    public Builder setFeatureTime(com.google.protobuf.Timestamp value) {
      if (featureTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        featureTimeSource_ = value;
        onChanged();
      } else {
        featureTimeBuilder_.setMessage(value);
      }
      featureTimeSourceCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Single Feature timestamp for all entities being imported. The
     * timestamp must not have higher than millisecond precision.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp feature_time = 7;</code>
     */
    public Builder setFeatureTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (featureTimeBuilder_ == null) {
        featureTimeSource_ = builderForValue.build();
        onChanged();
      } else {
        featureTimeBuilder_.setMessage(builderForValue.build());
      }
      featureTimeSourceCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Single Feature timestamp for all entities being imported. The
     * timestamp must not have higher than millisecond precision.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp feature_time = 7;</code>
     */
    public Builder mergeFeatureTime(com.google.protobuf.Timestamp value) {
      if (featureTimeBuilder_ == null) {
        if (featureTimeSourceCase_ == 7
            && featureTimeSource_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          featureTimeSource_ =
              com.google.protobuf.Timestamp.newBuilder(
                      (com.google.protobuf.Timestamp) featureTimeSource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          featureTimeSource_ = value;
        }
        onChanged();
      } else {
        if (featureTimeSourceCase_ == 7) {
          featureTimeBuilder_.mergeFrom(value);
        } else {
          featureTimeBuilder_.setMessage(value);
        }
      }
      featureTimeSourceCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Single Feature timestamp for all entities being imported. The
     * timestamp must not have higher than millisecond precision.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp feature_time = 7;</code>
     */
    public Builder clearFeatureTime() {
      if (featureTimeBuilder_ == null) {
        if (featureTimeSourceCase_ == 7) {
          featureTimeSourceCase_ = 0;
          featureTimeSource_ = null;
          onChanged();
        }
      } else {
        if (featureTimeSourceCase_ == 7) {
          featureTimeSourceCase_ = 0;
          featureTimeSource_ = null;
        }
        featureTimeBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Single Feature timestamp for all entities being imported. The
     * timestamp must not have higher than millisecond precision.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp feature_time = 7;</code>
     */
    public com.google.protobuf.Timestamp.Builder getFeatureTimeBuilder() {
      return getFeatureTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Single Feature timestamp for all entities being imported. The
     * timestamp must not have higher than millisecond precision.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp feature_time = 7;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getFeatureTimeOrBuilder() {
      if ((featureTimeSourceCase_ == 7) && (featureTimeBuilder_ != null)) {
        return featureTimeBuilder_.getMessageOrBuilder();
      } else {
        if (featureTimeSourceCase_ == 7) {
          return (com.google.protobuf.Timestamp) featureTimeSource_;
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Single Feature timestamp for all entities being imported. The
     * timestamp must not have higher than millisecond precision.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp feature_time = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getFeatureTimeFieldBuilder() {
      if (featureTimeBuilder_ == null) {
        if (!(featureTimeSourceCase_ == 7)) {
          featureTimeSource_ = com.google.protobuf.Timestamp.getDefaultInstance();
        }
        featureTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                (com.google.protobuf.Timestamp) featureTimeSource_,
                getParentForChildren(),
                isClean());
        featureTimeSource_ = null;
      }
      featureTimeSourceCase_ = 7;
      onChanged();
      ;
      return featureTimeBuilder_;
    }

    private java.lang.Object entityType_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the EntityType grouping the Features for which values
     * are being imported. Format:
     * `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entityType}`
     * </pre>
     *
     * <code>
     * string entity_type = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The entityType.
     */
    public java.lang.String getEntityType() {
      java.lang.Object ref = entityType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        entityType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the EntityType grouping the Features for which values
     * are being imported. Format:
     * `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entityType}`
     * </pre>
     *
     * <code>
     * string entity_type = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for entityType.
     */
    public com.google.protobuf.ByteString getEntityTypeBytes() {
      java.lang.Object ref = entityType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        entityType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the EntityType grouping the Features for which values
     * are being imported. Format:
     * `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entityType}`
     * </pre>
     *
     * <code>
     * string entity_type = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The entityType to set.
     * @return This builder for chaining.
     */
    public Builder setEntityType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      entityType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the EntityType grouping the Features for which values
     * are being imported. Format:
     * `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entityType}`
     * </pre>
     *
     * <code>
     * string entity_type = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEntityType() {

      entityType_ = getDefaultInstance().getEntityType();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the EntityType grouping the Features for which values
     * are being imported. Format:
     * `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entityType}`
     * </pre>
     *
     * <code>
     * string entity_type = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for entityType to set.
     * @return This builder for chaining.
     */
    public Builder setEntityTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      entityType_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object entityIdField_ = "";
    /**
     *
     *
     * <pre>
     * Source column that holds entity IDs. If not provided, entity IDs are
     * extracted from the column named `entity_id`.
     * </pre>
     *
     * <code>string entity_id_field = 5;</code>
     *
     * @return The entityIdField.
     */
    public java.lang.String getEntityIdField() {
      java.lang.Object ref = entityIdField_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        entityIdField_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Source column that holds entity IDs. If not provided, entity IDs are
     * extracted from the column named `entity_id`.
     * </pre>
     *
     * <code>string entity_id_field = 5;</code>
     *
     * @return The bytes for entityIdField.
     */
    public com.google.protobuf.ByteString getEntityIdFieldBytes() {
      java.lang.Object ref = entityIdField_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        entityIdField_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Source column that holds entity IDs. If not provided, entity IDs are
     * extracted from the column named `entity_id`.
     * </pre>
     *
     * <code>string entity_id_field = 5;</code>
     *
     * @param value The entityIdField to set.
     * @return This builder for chaining.
     */
    public Builder setEntityIdField(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      entityIdField_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source column that holds entity IDs. If not provided, entity IDs are
     * extracted from the column named `entity_id`.
     * </pre>
     *
     * <code>string entity_id_field = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEntityIdField() {

      entityIdField_ = getDefaultInstance().getEntityIdField();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source column that holds entity IDs. If not provided, entity IDs are
     * extracted from the column named `entity_id`.
     * </pre>
     *
     * <code>string entity_id_field = 5;</code>
     *
     * @param value The bytes for entityIdField to set.
     * @return This builder for chaining.
     */
    public Builder setEntityIdFieldBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      entityIdField_ = value;
      onChanged();
      return this;
    }

    private java.util.List<
            com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec>
        featureSpecs_ = java.util.Collections.emptyList();

    private void ensureFeatureSpecsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        featureSpecs_ =
            new java.util.ArrayList<
                com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec>(
                featureSpecs_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec,
            com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpecOrBuilder>
        featureSpecsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Specifications defining which Feature values to import from the entity. The
     * request fails if no feature_specs are provided, and having multiple
     * feature_specs for one Feature is not allowed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec feature_specs = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec>
        getFeatureSpecsList() {
      if (featureSpecsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(featureSpecs_);
      } else {
        return featureSpecsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Specifications defining which Feature values to import from the entity. The
     * request fails if no feature_specs are provided, and having multiple
     * feature_specs for one Feature is not allowed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec feature_specs = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getFeatureSpecsCount() {
      if (featureSpecsBuilder_ == null) {
        return featureSpecs_.size();
      } else {
        return featureSpecsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Specifications defining which Feature values to import from the entity. The
     * request fails if no feature_specs are provided, and having multiple
     * feature_specs for one Feature is not allowed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec feature_specs = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec
        getFeatureSpecs(int index) {
      if (featureSpecsBuilder_ == null) {
        return featureSpecs_.get(index);
      } else {
        return featureSpecsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Specifications defining which Feature values to import from the entity. The
     * request fails if no feature_specs are provided, and having multiple
     * feature_specs for one Feature is not allowed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec feature_specs = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setFeatureSpecs(
        int index,
        com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec value) {
      if (featureSpecsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFeatureSpecsIsMutable();
        featureSpecs_.set(index, value);
        onChanged();
      } else {
        featureSpecsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Specifications defining which Feature values to import from the entity. The
     * request fails if no feature_specs are provided, and having multiple
     * feature_specs for one Feature is not allowed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec feature_specs = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setFeatureSpecs(
        int index,
        com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec.Builder
            builderForValue) {
      if (featureSpecsBuilder_ == null) {
        ensureFeatureSpecsIsMutable();
        featureSpecs_.set(index, builderForValue.build());
        onChanged();
      } else {
        featureSpecsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Specifications defining which Feature values to import from the entity. The
     * request fails if no feature_specs are provided, and having multiple
     * feature_specs for one Feature is not allowed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec feature_specs = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addFeatureSpecs(
        com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec value) {
      if (featureSpecsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFeatureSpecsIsMutable();
        featureSpecs_.add(value);
        onChanged();
      } else {
        featureSpecsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Specifications defining which Feature values to import from the entity. The
     * request fails if no feature_specs are provided, and having multiple
     * feature_specs for one Feature is not allowed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec feature_specs = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addFeatureSpecs(
        int index,
        com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec value) {
      if (featureSpecsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFeatureSpecsIsMutable();
        featureSpecs_.add(index, value);
        onChanged();
      } else {
        featureSpecsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Specifications defining which Feature values to import from the entity. The
     * request fails if no feature_specs are provided, and having multiple
     * feature_specs for one Feature is not allowed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec feature_specs = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addFeatureSpecs(
        com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec.Builder
            builderForValue) {
      if (featureSpecsBuilder_ == null) {
        ensureFeatureSpecsIsMutable();
        featureSpecs_.add(builderForValue.build());
        onChanged();
      } else {
        featureSpecsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Specifications defining which Feature values to import from the entity. The
     * request fails if no feature_specs are provided, and having multiple
     * feature_specs for one Feature is not allowed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec feature_specs = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addFeatureSpecs(
        int index,
        com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec.Builder
            builderForValue) {
      if (featureSpecsBuilder_ == null) {
        ensureFeatureSpecsIsMutable();
        featureSpecs_.add(index, builderForValue.build());
        onChanged();
      } else {
        featureSpecsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Specifications defining which Feature values to import from the entity. The
     * request fails if no feature_specs are provided, and having multiple
     * feature_specs for one Feature is not allowed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec feature_specs = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllFeatureSpecs(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec>
            values) {
      if (featureSpecsBuilder_ == null) {
        ensureFeatureSpecsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, featureSpecs_);
        onChanged();
      } else {
        featureSpecsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Specifications defining which Feature values to import from the entity. The
     * request fails if no feature_specs are provided, and having multiple
     * feature_specs for one Feature is not allowed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec feature_specs = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearFeatureSpecs() {
      if (featureSpecsBuilder_ == null) {
        featureSpecs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        featureSpecsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Specifications defining which Feature values to import from the entity. The
     * request fails if no feature_specs are provided, and having multiple
     * feature_specs for one Feature is not allowed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec feature_specs = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeFeatureSpecs(int index) {
      if (featureSpecsBuilder_ == null) {
        ensureFeatureSpecsIsMutable();
        featureSpecs_.remove(index);
        onChanged();
      } else {
        featureSpecsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Specifications defining which Feature values to import from the entity. The
     * request fails if no feature_specs are provided, and having multiple
     * feature_specs for one Feature is not allowed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec feature_specs = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec.Builder
        getFeatureSpecsBuilder(int index) {
      return getFeatureSpecsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Specifications defining which Feature values to import from the entity. The
     * request fails if no feature_specs are provided, and having multiple
     * feature_specs for one Feature is not allowed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec feature_specs = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpecOrBuilder
        getFeatureSpecsOrBuilder(int index) {
      if (featureSpecsBuilder_ == null) {
        return featureSpecs_.get(index);
      } else {
        return featureSpecsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Specifications defining which Feature values to import from the entity. The
     * request fails if no feature_specs are provided, and having multiple
     * feature_specs for one Feature is not allowed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec feature_specs = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpecOrBuilder>
        getFeatureSpecsOrBuilderList() {
      if (featureSpecsBuilder_ != null) {
        return featureSpecsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(featureSpecs_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Specifications defining which Feature values to import from the entity. The
     * request fails if no feature_specs are provided, and having multiple
     * feature_specs for one Feature is not allowed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec feature_specs = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec.Builder
        addFeatureSpecsBuilder() {
      return getFeatureSpecsFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Specifications defining which Feature values to import from the entity. The
     * request fails if no feature_specs are provided, and having multiple
     * feature_specs for one Feature is not allowed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec feature_specs = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec.Builder
        addFeatureSpecsBuilder(int index) {
      return getFeatureSpecsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Specifications defining which Feature values to import from the entity. The
     * request fails if no feature_specs are provided, and having multiple
     * feature_specs for one Feature is not allowed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec feature_specs = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec.Builder>
        getFeatureSpecsBuilderList() {
      return getFeatureSpecsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec,
            com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpecOrBuilder>
        getFeatureSpecsFieldBuilder() {
      if (featureSpecsBuilder_ == null) {
        featureSpecsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec,
                com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest.FeatureSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest
                    .FeatureSpecOrBuilder>(
                featureSpecs_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        featureSpecs_ = null;
      }
      return featureSpecsBuilder_;
    }

    private boolean disableOnlineServing_;
    /**
     *
     *
     * <pre>
     * If set, data will not be imported for online serving. This
     * is typically used for backfilling, where Feature generation timestamps are
     * not in the timestamp range needed for online serving.
     * </pre>
     *
     * <code>bool disable_online_serving = 9;</code>
     *
     * @return The disableOnlineServing.
     */
    @java.lang.Override
    public boolean getDisableOnlineServing() {
      return disableOnlineServing_;
    }
    /**
     *
     *
     * <pre>
     * If set, data will not be imported for online serving. This
     * is typically used for backfilling, where Feature generation timestamps are
     * not in the timestamp range needed for online serving.
     * </pre>
     *
     * <code>bool disable_online_serving = 9;</code>
     *
     * @param value The disableOnlineServing to set.
     * @return This builder for chaining.
     */
    public Builder setDisableOnlineServing(boolean value) {

      disableOnlineServing_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, data will not be imported for online serving. This
     * is typically used for backfilling, where Feature generation timestamps are
     * not in the timestamp range needed for online serving.
     * </pre>
     *
     * <code>bool disable_online_serving = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisableOnlineServing() {

      disableOnlineServing_ = false;
      onChanged();
      return this;
    }

    private int workerCount_;
    /**
     *
     *
     * <pre>
     * Specifies the number of workers that are used to write data to the
     * Featurestore. Consider the online serving capacity that you require to
     * achieve the desired import throughput without interfering with online
     * serving. The value must be positive, and less than or equal to 100.
     * If not set, defaults to using 1 worker. The low count ensures minimal
     * impact on online serving performance.
     * </pre>
     *
     * <code>int32 worker_count = 11;</code>
     *
     * @return The workerCount.
     */
    @java.lang.Override
    public int getWorkerCount() {
      return workerCount_;
    }
    /**
     *
     *
     * <pre>
     * Specifies the number of workers that are used to write data to the
     * Featurestore. Consider the online serving capacity that you require to
     * achieve the desired import throughput without interfering with online
     * serving. The value must be positive, and less than or equal to 100.
     * If not set, defaults to using 1 worker. The low count ensures minimal
     * impact on online serving performance.
     * </pre>
     *
     * <code>int32 worker_count = 11;</code>
     *
     * @param value The workerCount to set.
     * @return This builder for chaining.
     */
    public Builder setWorkerCount(int value) {

      workerCount_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the number of workers that are used to write data to the
     * Featurestore. Consider the online serving capacity that you require to
     * achieve the desired import throughput without interfering with online
     * serving. The value must be positive, and less than or equal to 100.
     * If not set, defaults to using 1 worker. The low count ensures minimal
     * impact on online serving performance.
     * </pre>
     *
     * <code>int32 worker_count = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWorkerCount() {

      workerCount_ = 0;
      onChanged();
      return this;
    }

    private boolean disableIngestionAnalysis_;
    /**
     *
     *
     * <pre>
     * If true, API doesn't start ingestion analysis pipeline.
     * </pre>
     *
     * <code>bool disable_ingestion_analysis = 12;</code>
     *
     * @return The disableIngestionAnalysis.
     */
    @java.lang.Override
    public boolean getDisableIngestionAnalysis() {
      return disableIngestionAnalysis_;
    }
    /**
     *
     *
     * <pre>
     * If true, API doesn't start ingestion analysis pipeline.
     * </pre>
     *
     * <code>bool disable_ingestion_analysis = 12;</code>
     *
     * @param value The disableIngestionAnalysis to set.
     * @return This builder for chaining.
     */
    public Builder setDisableIngestionAnalysis(boolean value) {

      disableIngestionAnalysis_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If true, API doesn't start ingestion analysis pipeline.
     * </pre>
     *
     * <code>bool disable_ingestion_analysis = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisableIngestionAnalysis() {

      disableIngestionAnalysis_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest)
  private static final com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest();
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ImportFeatureValuesRequest> PARSER =
      new com.google.protobuf.AbstractParser<ImportFeatureValuesRequest>() {
        @java.lang.Override
        public ImportFeatureValuesRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ImportFeatureValuesRequest(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ImportFeatureValuesRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ImportFeatureValuesRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
