/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/explanation.proto

package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Example-based explainability that returns the nearest neighbors from the
 * provided dataset.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.Examples}
 */
public final class Examples extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.Examples)
    ExamplesOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Examples.newBuilder() to construct.
  private Examples(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Examples() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Examples();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private Examples(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              com.google.cloud.aiplatform.v1beta1.GcsSource.Builder subBuilder = null;
              if (gcsSource_ != null) {
                subBuilder = gcsSource_.toBuilder();
              }
              gcsSource_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.GcsSource.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(gcsSource_);
                gcsSource_ = subBuilder.buildPartial();
              }

              break;
            }
          case 18:
            {
              com.google.protobuf.Value.Builder subBuilder = null;
              if (configCase_ == 2) {
                subBuilder = ((com.google.protobuf.Value) config_).toBuilder();
              }
              config_ = input.readMessage(com.google.protobuf.Value.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.protobuf.Value) config_);
                config_ = subBuilder.buildPartial();
              }
              configCase_ = 2;
              break;
            }
          case 24:
            {
              neighborCount_ = input.readInt32();
              break;
            }
          case 34:
            {
              com.google.cloud.aiplatform.v1beta1.Presets.Builder subBuilder = null;
              if (configCase_ == 4) {
                subBuilder = ((com.google.cloud.aiplatform.v1beta1.Presets) config_).toBuilder();
              }
              config_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.Presets.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.cloud.aiplatform.v1beta1.Presets) config_);
                config_ = subBuilder.buildPartial();
              }
              configCase_ = 4;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.ExplanationProto
        .internal_static_google_cloud_aiplatform_v1beta1_Examples_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.ExplanationProto
        .internal_static_google_cloud_aiplatform_v1beta1_Examples_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.Examples.class,
            com.google.cloud.aiplatform.v1beta1.Examples.Builder.class);
  }

  private int configCase_ = 0;
  private java.lang.Object config_;

  public enum ConfigCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    NEAREST_NEIGHBOR_SEARCH_CONFIG(2),
    PRESETS(4),
    CONFIG_NOT_SET(0);
    private final int value;

    private ConfigCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ConfigCase valueOf(int value) {
      return forNumber(value);
    }

    public static ConfigCase forNumber(int value) {
      switch (value) {
        case 2:
          return NEAREST_NEIGHBOR_SEARCH_CONFIG;
        case 4:
          return PRESETS;
        case 0:
          return CONFIG_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ConfigCase getConfigCase() {
    return ConfigCase.forNumber(configCase_);
  }

  public static final int NEAREST_NEIGHBOR_SEARCH_CONFIG_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * The configuration for the generated index, the semantics are the same as
   * [metadata][google.cloud.aiplatform.v1beta1.Index.metadata] and should match NearestNeighborSearchConfig.
   * </pre>
   *
   * <code>.google.protobuf.Value nearest_neighbor_search_config = 2;</code>
   *
   * @return Whether the nearestNeighborSearchConfig field is set.
   */
  @java.lang.Override
  public boolean hasNearestNeighborSearchConfig() {
    return configCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * The configuration for the generated index, the semantics are the same as
   * [metadata][google.cloud.aiplatform.v1beta1.Index.metadata] and should match NearestNeighborSearchConfig.
   * </pre>
   *
   * <code>.google.protobuf.Value nearest_neighbor_search_config = 2;</code>
   *
   * @return The nearestNeighborSearchConfig.
   */
  @java.lang.Override
  public com.google.protobuf.Value getNearestNeighborSearchConfig() {
    if (configCase_ == 2) {
      return (com.google.protobuf.Value) config_;
    }
    return com.google.protobuf.Value.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The configuration for the generated index, the semantics are the same as
   * [metadata][google.cloud.aiplatform.v1beta1.Index.metadata] and should match NearestNeighborSearchConfig.
   * </pre>
   *
   * <code>.google.protobuf.Value nearest_neighbor_search_config = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.ValueOrBuilder getNearestNeighborSearchConfigOrBuilder() {
    if (configCase_ == 2) {
      return (com.google.protobuf.Value) config_;
    }
    return com.google.protobuf.Value.getDefaultInstance();
  }

  public static final int PRESETS_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Preset config based on the desired query speed-precision trade-off
   * and modality
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.Presets presets = 4;</code>
   *
   * @return Whether the presets field is set.
   */
  @java.lang.Override
  public boolean hasPresets() {
    return configCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Preset config based on the desired query speed-precision trade-off
   * and modality
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.Presets presets = 4;</code>
   *
   * @return The presets.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Presets getPresets() {
    if (configCase_ == 4) {
      return (com.google.cloud.aiplatform.v1beta1.Presets) config_;
    }
    return com.google.cloud.aiplatform.v1beta1.Presets.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Preset config based on the desired query speed-precision trade-off
   * and modality
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.Presets presets = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PresetsOrBuilder getPresetsOrBuilder() {
    if (configCase_ == 4) {
      return (com.google.cloud.aiplatform.v1beta1.Presets) config_;
    }
    return com.google.cloud.aiplatform.v1beta1.Presets.getDefaultInstance();
  }

  public static final int GCS_SOURCE_FIELD_NUMBER = 1;
  private com.google.cloud.aiplatform.v1beta1.GcsSource gcsSource_;
  /**
   *
   *
   * <pre>
   * The Cloud Storage location for the input instances.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 1;</code>
   *
   * @return Whether the gcsSource field is set.
   */
  @java.lang.Override
  public boolean hasGcsSource() {
    return gcsSource_ != null;
  }
  /**
   *
   *
   * <pre>
   * The Cloud Storage location for the input instances.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 1;</code>
   *
   * @return The gcsSource.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GcsSource getGcsSource() {
    return gcsSource_ == null
        ? com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance()
        : gcsSource_;
  }
  /**
   *
   *
   * <pre>
   * The Cloud Storage location for the input instances.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder getGcsSourceOrBuilder() {
    return getGcsSource();
  }

  public static final int NEIGHBOR_COUNT_FIELD_NUMBER = 3;
  private int neighborCount_;
  /**
   *
   *
   * <pre>
   * The number of neighbors to return.
   * </pre>
   *
   * <code>int32 neighbor_count = 3;</code>
   *
   * @return The neighborCount.
   */
  @java.lang.Override
  public int getNeighborCount() {
    return neighborCount_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (gcsSource_ != null) {
      output.writeMessage(1, getGcsSource());
    }
    if (configCase_ == 2) {
      output.writeMessage(2, (com.google.protobuf.Value) config_);
    }
    if (neighborCount_ != 0) {
      output.writeInt32(3, neighborCount_);
    }
    if (configCase_ == 4) {
      output.writeMessage(4, (com.google.cloud.aiplatform.v1beta1.Presets) config_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (gcsSource_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getGcsSource());
    }
    if (configCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.protobuf.Value) config_);
    }
    if (neighborCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, neighborCount_);
    }
    if (configCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.aiplatform.v1beta1.Presets) config_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.Examples)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.Examples other =
        (com.google.cloud.aiplatform.v1beta1.Examples) obj;

    if (hasGcsSource() != other.hasGcsSource()) return false;
    if (hasGcsSource()) {
      if (!getGcsSource().equals(other.getGcsSource())) return false;
    }
    if (getNeighborCount() != other.getNeighborCount()) return false;
    if (!getConfigCase().equals(other.getConfigCase())) return false;
    switch (configCase_) {
      case 2:
        if (!getNearestNeighborSearchConfig().equals(other.getNearestNeighborSearchConfig()))
          return false;
        break;
      case 4:
        if (!getPresets().equals(other.getPresets())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasGcsSource()) {
      hash = (37 * hash) + GCS_SOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getGcsSource().hashCode();
    }
    hash = (37 * hash) + NEIGHBOR_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getNeighborCount();
    switch (configCase_) {
      case 2:
        hash = (37 * hash) + NEAREST_NEIGHBOR_SEARCH_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getNearestNeighborSearchConfig().hashCode();
        break;
      case 4:
        hash = (37 * hash) + PRESETS_FIELD_NUMBER;
        hash = (53 * hash) + getPresets().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.Examples parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.Examples parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Examples parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.Examples parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Examples parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.Examples parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Examples parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.Examples parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Examples parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.Examples parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Examples parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.Examples parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.Examples prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Example-based explainability that returns the nearest neighbors from the
   * provided dataset.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.Examples}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.Examples)
      com.google.cloud.aiplatform.v1beta1.ExamplesOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ExplanationProto
          .internal_static_google_cloud_aiplatform_v1beta1_Examples_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ExplanationProto
          .internal_static_google_cloud_aiplatform_v1beta1_Examples_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.Examples.class,
              com.google.cloud.aiplatform.v1beta1.Examples.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.Examples.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (gcsSourceBuilder_ == null) {
        gcsSource_ = null;
      } else {
        gcsSource_ = null;
        gcsSourceBuilder_ = null;
      }
      neighborCount_ = 0;

      configCase_ = 0;
      config_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.ExplanationProto
          .internal_static_google_cloud_aiplatform_v1beta1_Examples_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Examples getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.Examples.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Examples build() {
      com.google.cloud.aiplatform.v1beta1.Examples result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Examples buildPartial() {
      com.google.cloud.aiplatform.v1beta1.Examples result =
          new com.google.cloud.aiplatform.v1beta1.Examples(this);
      if (configCase_ == 2) {
        if (nearestNeighborSearchConfigBuilder_ == null) {
          result.config_ = config_;
        } else {
          result.config_ = nearestNeighborSearchConfigBuilder_.build();
        }
      }
      if (configCase_ == 4) {
        if (presetsBuilder_ == null) {
          result.config_ = config_;
        } else {
          result.config_ = presetsBuilder_.build();
        }
      }
      if (gcsSourceBuilder_ == null) {
        result.gcsSource_ = gcsSource_;
      } else {
        result.gcsSource_ = gcsSourceBuilder_.build();
      }
      result.neighborCount_ = neighborCount_;
      result.configCase_ = configCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.Examples) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.Examples) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.Examples other) {
      if (other == com.google.cloud.aiplatform.v1beta1.Examples.getDefaultInstance()) return this;
      if (other.hasGcsSource()) {
        mergeGcsSource(other.getGcsSource());
      }
      if (other.getNeighborCount() != 0) {
        setNeighborCount(other.getNeighborCount());
      }
      switch (other.getConfigCase()) {
        case NEAREST_NEIGHBOR_SEARCH_CONFIG:
          {
            mergeNearestNeighborSearchConfig(other.getNearestNeighborSearchConfig());
            break;
          }
        case PRESETS:
          {
            mergePresets(other.getPresets());
            break;
          }
        case CONFIG_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.aiplatform.v1beta1.Examples parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.aiplatform.v1beta1.Examples) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int configCase_ = 0;
    private java.lang.Object config_;

    public ConfigCase getConfigCase() {
      return ConfigCase.forNumber(configCase_);
    }

    public Builder clearConfig() {
      configCase_ = 0;
      config_ = null;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        nearestNeighborSearchConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The configuration for the generated index, the semantics are the same as
     * [metadata][google.cloud.aiplatform.v1beta1.Index.metadata] and should match NearestNeighborSearchConfig.
     * </pre>
     *
     * <code>.google.protobuf.Value nearest_neighbor_search_config = 2;</code>
     *
     * @return Whether the nearestNeighborSearchConfig field is set.
     */
    @java.lang.Override
    public boolean hasNearestNeighborSearchConfig() {
      return configCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The configuration for the generated index, the semantics are the same as
     * [metadata][google.cloud.aiplatform.v1beta1.Index.metadata] and should match NearestNeighborSearchConfig.
     * </pre>
     *
     * <code>.google.protobuf.Value nearest_neighbor_search_config = 2;</code>
     *
     * @return The nearestNeighborSearchConfig.
     */
    @java.lang.Override
    public com.google.protobuf.Value getNearestNeighborSearchConfig() {
      if (nearestNeighborSearchConfigBuilder_ == null) {
        if (configCase_ == 2) {
          return (com.google.protobuf.Value) config_;
        }
        return com.google.protobuf.Value.getDefaultInstance();
      } else {
        if (configCase_ == 2) {
          return nearestNeighborSearchConfigBuilder_.getMessage();
        }
        return com.google.protobuf.Value.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The configuration for the generated index, the semantics are the same as
     * [metadata][google.cloud.aiplatform.v1beta1.Index.metadata] and should match NearestNeighborSearchConfig.
     * </pre>
     *
     * <code>.google.protobuf.Value nearest_neighbor_search_config = 2;</code>
     */
    public Builder setNearestNeighborSearchConfig(com.google.protobuf.Value value) {
      if (nearestNeighborSearchConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        config_ = value;
        onChanged();
      } else {
        nearestNeighborSearchConfigBuilder_.setMessage(value);
      }
      configCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration for the generated index, the semantics are the same as
     * [metadata][google.cloud.aiplatform.v1beta1.Index.metadata] and should match NearestNeighborSearchConfig.
     * </pre>
     *
     * <code>.google.protobuf.Value nearest_neighbor_search_config = 2;</code>
     */
    public Builder setNearestNeighborSearchConfig(
        com.google.protobuf.Value.Builder builderForValue) {
      if (nearestNeighborSearchConfigBuilder_ == null) {
        config_ = builderForValue.build();
        onChanged();
      } else {
        nearestNeighborSearchConfigBuilder_.setMessage(builderForValue.build());
      }
      configCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration for the generated index, the semantics are the same as
     * [metadata][google.cloud.aiplatform.v1beta1.Index.metadata] and should match NearestNeighborSearchConfig.
     * </pre>
     *
     * <code>.google.protobuf.Value nearest_neighbor_search_config = 2;</code>
     */
    public Builder mergeNearestNeighborSearchConfig(com.google.protobuf.Value value) {
      if (nearestNeighborSearchConfigBuilder_ == null) {
        if (configCase_ == 2 && config_ != com.google.protobuf.Value.getDefaultInstance()) {
          config_ =
              com.google.protobuf.Value.newBuilder((com.google.protobuf.Value) config_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          config_ = value;
        }
        onChanged();
      } else {
        if (configCase_ == 2) {
          nearestNeighborSearchConfigBuilder_.mergeFrom(value);
        } else {
          nearestNeighborSearchConfigBuilder_.setMessage(value);
        }
      }
      configCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration for the generated index, the semantics are the same as
     * [metadata][google.cloud.aiplatform.v1beta1.Index.metadata] and should match NearestNeighborSearchConfig.
     * </pre>
     *
     * <code>.google.protobuf.Value nearest_neighbor_search_config = 2;</code>
     */
    public Builder clearNearestNeighborSearchConfig() {
      if (nearestNeighborSearchConfigBuilder_ == null) {
        if (configCase_ == 2) {
          configCase_ = 0;
          config_ = null;
          onChanged();
        }
      } else {
        if (configCase_ == 2) {
          configCase_ = 0;
          config_ = null;
        }
        nearestNeighborSearchConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration for the generated index, the semantics are the same as
     * [metadata][google.cloud.aiplatform.v1beta1.Index.metadata] and should match NearestNeighborSearchConfig.
     * </pre>
     *
     * <code>.google.protobuf.Value nearest_neighbor_search_config = 2;</code>
     */
    public com.google.protobuf.Value.Builder getNearestNeighborSearchConfigBuilder() {
      return getNearestNeighborSearchConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The configuration for the generated index, the semantics are the same as
     * [metadata][google.cloud.aiplatform.v1beta1.Index.metadata] and should match NearestNeighborSearchConfig.
     * </pre>
     *
     * <code>.google.protobuf.Value nearest_neighbor_search_config = 2;</code>
     */
    @java.lang.Override
    public com.google.protobuf.ValueOrBuilder getNearestNeighborSearchConfigOrBuilder() {
      if ((configCase_ == 2) && (nearestNeighborSearchConfigBuilder_ != null)) {
        return nearestNeighborSearchConfigBuilder_.getMessageOrBuilder();
      } else {
        if (configCase_ == 2) {
          return (com.google.protobuf.Value) config_;
        }
        return com.google.protobuf.Value.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The configuration for the generated index, the semantics are the same as
     * [metadata][google.cloud.aiplatform.v1beta1.Index.metadata] and should match NearestNeighborSearchConfig.
     * </pre>
     *
     * <code>.google.protobuf.Value nearest_neighbor_search_config = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        getNearestNeighborSearchConfigFieldBuilder() {
      if (nearestNeighborSearchConfigBuilder_ == null) {
        if (!(configCase_ == 2)) {
          config_ = com.google.protobuf.Value.getDefaultInstance();
        }
        nearestNeighborSearchConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Value,
                com.google.protobuf.Value.Builder,
                com.google.protobuf.ValueOrBuilder>(
                (com.google.protobuf.Value) config_, getParentForChildren(), isClean());
        config_ = null;
      }
      configCase_ = 2;
      onChanged();
      ;
      return nearestNeighborSearchConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Presets,
            com.google.cloud.aiplatform.v1beta1.Presets.Builder,
            com.google.cloud.aiplatform.v1beta1.PresetsOrBuilder>
        presetsBuilder_;
    /**
     *
     *
     * <pre>
     * Preset config based on the desired query speed-precision trade-off
     * and modality
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Presets presets = 4;</code>
     *
     * @return Whether the presets field is set.
     */
    @java.lang.Override
    public boolean hasPresets() {
      return configCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Preset config based on the desired query speed-precision trade-off
     * and modality
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Presets presets = 4;</code>
     *
     * @return The presets.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Presets getPresets() {
      if (presetsBuilder_ == null) {
        if (configCase_ == 4) {
          return (com.google.cloud.aiplatform.v1beta1.Presets) config_;
        }
        return com.google.cloud.aiplatform.v1beta1.Presets.getDefaultInstance();
      } else {
        if (configCase_ == 4) {
          return presetsBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.Presets.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Preset config based on the desired query speed-precision trade-off
     * and modality
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Presets presets = 4;</code>
     */
    public Builder setPresets(com.google.cloud.aiplatform.v1beta1.Presets value) {
      if (presetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        config_ = value;
        onChanged();
      } else {
        presetsBuilder_.setMessage(value);
      }
      configCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Preset config based on the desired query speed-precision trade-off
     * and modality
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Presets presets = 4;</code>
     */
    public Builder setPresets(com.google.cloud.aiplatform.v1beta1.Presets.Builder builderForValue) {
      if (presetsBuilder_ == null) {
        config_ = builderForValue.build();
        onChanged();
      } else {
        presetsBuilder_.setMessage(builderForValue.build());
      }
      configCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Preset config based on the desired query speed-precision trade-off
     * and modality
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Presets presets = 4;</code>
     */
    public Builder mergePresets(com.google.cloud.aiplatform.v1beta1.Presets value) {
      if (presetsBuilder_ == null) {
        if (configCase_ == 4
            && config_ != com.google.cloud.aiplatform.v1beta1.Presets.getDefaultInstance()) {
          config_ =
              com.google.cloud.aiplatform.v1beta1.Presets.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.Presets) config_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          config_ = value;
        }
        onChanged();
      } else {
        if (configCase_ == 4) {
          presetsBuilder_.mergeFrom(value);
        } else {
          presetsBuilder_.setMessage(value);
        }
      }
      configCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Preset config based on the desired query speed-precision trade-off
     * and modality
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Presets presets = 4;</code>
     */
    public Builder clearPresets() {
      if (presetsBuilder_ == null) {
        if (configCase_ == 4) {
          configCase_ = 0;
          config_ = null;
          onChanged();
        }
      } else {
        if (configCase_ == 4) {
          configCase_ = 0;
          config_ = null;
        }
        presetsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Preset config based on the desired query speed-precision trade-off
     * and modality
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Presets presets = 4;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.Presets.Builder getPresetsBuilder() {
      return getPresetsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Preset config based on the desired query speed-precision trade-off
     * and modality
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Presets presets = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PresetsOrBuilder getPresetsOrBuilder() {
      if ((configCase_ == 4) && (presetsBuilder_ != null)) {
        return presetsBuilder_.getMessageOrBuilder();
      } else {
        if (configCase_ == 4) {
          return (com.google.cloud.aiplatform.v1beta1.Presets) config_;
        }
        return com.google.cloud.aiplatform.v1beta1.Presets.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Preset config based on the desired query speed-precision trade-off
     * and modality
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Presets presets = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Presets,
            com.google.cloud.aiplatform.v1beta1.Presets.Builder,
            com.google.cloud.aiplatform.v1beta1.PresetsOrBuilder>
        getPresetsFieldBuilder() {
      if (presetsBuilder_ == null) {
        if (!(configCase_ == 4)) {
          config_ = com.google.cloud.aiplatform.v1beta1.Presets.getDefaultInstance();
        }
        presetsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.Presets,
                com.google.cloud.aiplatform.v1beta1.Presets.Builder,
                com.google.cloud.aiplatform.v1beta1.PresetsOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.Presets) config_,
                getParentForChildren(),
                isClean());
        config_ = null;
      }
      configCase_ = 4;
      onChanged();
      ;
      return presetsBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.GcsSource gcsSource_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GcsSource,
            com.google.cloud.aiplatform.v1beta1.GcsSource.Builder,
            com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder>
        gcsSourceBuilder_;
    /**
     *
     *
     * <pre>
     * The Cloud Storage location for the input instances.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 1;</code>
     *
     * @return Whether the gcsSource field is set.
     */
    public boolean hasGcsSource() {
      return gcsSourceBuilder_ != null || gcsSource_ != null;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location for the input instances.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 1;</code>
     *
     * @return The gcsSource.
     */
    public com.google.cloud.aiplatform.v1beta1.GcsSource getGcsSource() {
      if (gcsSourceBuilder_ == null) {
        return gcsSource_ == null
            ? com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance()
            : gcsSource_;
      } else {
        return gcsSourceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location for the input instances.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 1;</code>
     */
    public Builder setGcsSource(com.google.cloud.aiplatform.v1beta1.GcsSource value) {
      if (gcsSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        gcsSource_ = value;
        onChanged();
      } else {
        gcsSourceBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location for the input instances.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 1;</code>
     */
    public Builder setGcsSource(
        com.google.cloud.aiplatform.v1beta1.GcsSource.Builder builderForValue) {
      if (gcsSourceBuilder_ == null) {
        gcsSource_ = builderForValue.build();
        onChanged();
      } else {
        gcsSourceBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location for the input instances.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 1;</code>
     */
    public Builder mergeGcsSource(com.google.cloud.aiplatform.v1beta1.GcsSource value) {
      if (gcsSourceBuilder_ == null) {
        if (gcsSource_ != null) {
          gcsSource_ =
              com.google.cloud.aiplatform.v1beta1.GcsSource.newBuilder(gcsSource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          gcsSource_ = value;
        }
        onChanged();
      } else {
        gcsSourceBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location for the input instances.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 1;</code>
     */
    public Builder clearGcsSource() {
      if (gcsSourceBuilder_ == null) {
        gcsSource_ = null;
        onChanged();
      } else {
        gcsSource_ = null;
        gcsSourceBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location for the input instances.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 1;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.GcsSource.Builder getGcsSourceBuilder() {

      onChanged();
      return getGcsSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location for the input instances.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 1;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder getGcsSourceOrBuilder() {
      if (gcsSourceBuilder_ != null) {
        return gcsSourceBuilder_.getMessageOrBuilder();
      } else {
        return gcsSource_ == null
            ? com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance()
            : gcsSource_;
      }
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location for the input instances.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GcsSource,
            com.google.cloud.aiplatform.v1beta1.GcsSource.Builder,
            com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder>
        getGcsSourceFieldBuilder() {
      if (gcsSourceBuilder_ == null) {
        gcsSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.GcsSource,
                com.google.cloud.aiplatform.v1beta1.GcsSource.Builder,
                com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder>(
                getGcsSource(), getParentForChildren(), isClean());
        gcsSource_ = null;
      }
      return gcsSourceBuilder_;
    }

    private int neighborCount_;
    /**
     *
     *
     * <pre>
     * The number of neighbors to return.
     * </pre>
     *
     * <code>int32 neighbor_count = 3;</code>
     *
     * @return The neighborCount.
     */
    @java.lang.Override
    public int getNeighborCount() {
      return neighborCount_;
    }
    /**
     *
     *
     * <pre>
     * The number of neighbors to return.
     * </pre>
     *
     * <code>int32 neighbor_count = 3;</code>
     *
     * @param value The neighborCount to set.
     * @return This builder for chaining.
     */
    public Builder setNeighborCount(int value) {

      neighborCount_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of neighbors to return.
     * </pre>
     *
     * <code>int32 neighbor_count = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNeighborCount() {

      neighborCount_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.Examples)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.Examples)
  private static final com.google.cloud.aiplatform.v1beta1.Examples DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.Examples();
  }

  public static com.google.cloud.aiplatform.v1beta1.Examples getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Examples> PARSER =
      new com.google.protobuf.AbstractParser<Examples>() {
        @java.lang.Override
        public Examples parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Examples(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<Examples> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Examples> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Examples getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
