/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/index_endpoint.proto

package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * A deployment of an Index. IndexEndpoints contain one or more DeployedIndexes.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.DeployedIndex}
 */
public final class DeployedIndex extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.DeployedIndex)
    DeployedIndexOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DeployedIndex.newBuilder() to construct.
  private DeployedIndex(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DeployedIndex() {
    id_ = "";
    index_ = "";
    displayName_ = "";
    reservedIpRanges_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    deploymentGroup_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DeployedIndex();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private DeployedIndex(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              id_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              index_ = s;
              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();

              displayName_ = s;
              break;
            }
          case 34:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (createTime_ != null) {
                subBuilder = createTime_.toBuilder();
              }
              createTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(createTime_);
                createTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 42:
            {
              com.google.cloud.aiplatform.v1beta1.IndexPrivateEndpoints.Builder subBuilder = null;
              if (privateEndpoints_ != null) {
                subBuilder = privateEndpoints_.toBuilder();
              }
              privateEndpoints_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.IndexPrivateEndpoints.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(privateEndpoints_);
                privateEndpoints_ = subBuilder.buildPartial();
              }

              break;
            }
          case 50:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (indexSyncTime_ != null) {
                subBuilder = indexSyncTime_.toBuilder();
              }
              indexSyncTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(indexSyncTime_);
                indexSyncTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 58:
            {
              com.google.cloud.aiplatform.v1beta1.AutomaticResources.Builder subBuilder = null;
              if (automaticResources_ != null) {
                subBuilder = automaticResources_.toBuilder();
              }
              automaticResources_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.AutomaticResources.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(automaticResources_);
                automaticResources_ = subBuilder.buildPartial();
              }

              break;
            }
          case 64:
            {
              enableAccessLogging_ = input.readBool();
              break;
            }
          case 74:
            {
              com.google.cloud.aiplatform.v1beta1.DeployedIndexAuthConfig.Builder subBuilder = null;
              if (deployedIndexAuthConfig_ != null) {
                subBuilder = deployedIndexAuthConfig_.toBuilder();
              }
              deployedIndexAuthConfig_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.DeployedIndexAuthConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(deployedIndexAuthConfig_);
                deployedIndexAuthConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          case 82:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                reservedIpRanges_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000001;
              }
              reservedIpRanges_.add(s);
              break;
            }
          case 90:
            {
              java.lang.String s = input.readStringRequireUtf8();

              deploymentGroup_ = s;
              break;
            }
          case 130:
            {
              com.google.cloud.aiplatform.v1beta1.DedicatedResources.Builder subBuilder = null;
              if (dedicatedResources_ != null) {
                subBuilder = dedicatedResources_.toBuilder();
              }
              dedicatedResources_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.DedicatedResources.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(dedicatedResources_);
                dedicatedResources_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        reservedIpRanges_ = reservedIpRanges_.getUnmodifiableView();
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.IndexEndpointProto
        .internal_static_google_cloud_aiplatform_v1beta1_DeployedIndex_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.IndexEndpointProto
        .internal_static_google_cloud_aiplatform_v1beta1_DeployedIndex_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.DeployedIndex.class,
            com.google.cloud.aiplatform.v1beta1.DeployedIndex.Builder.class);
  }

  public static final int ID_FIELD_NUMBER = 1;
  private volatile java.lang.Object id_;
  /**
   *
   *
   * <pre>
   * Required. The user specified ID of the DeployedIndex.
   * The ID can be up to 128 characters long and must start with a letter and
   * only contain letters, numbers, and underscores.
   * The ID must be unique within the project it is created in.
   * </pre>
   *
   * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The user specified ID of the DeployedIndex.
   * The ID can be up to 128 characters long and must start with a letter and
   * only contain letters, numbers, and underscores.
   * The ID must be unique within the project it is created in.
   * </pre>
   *
   * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for id.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INDEX_FIELD_NUMBER = 2;
  private volatile java.lang.Object index_;
  /**
   *
   *
   * <pre>
   * Required. The name of the Index this is the deployment of.
   * We may refer to this Index as the DeployedIndex's "original" Index.
   * </pre>
   *
   * <code>
   * string index = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The index.
   */
  @java.lang.Override
  public java.lang.String getIndex() {
    java.lang.Object ref = index_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      index_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the Index this is the deployment of.
   * We may refer to this Index as the DeployedIndex's "original" Index.
   * </pre>
   *
   * <code>
   * string index = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for index.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIndexBytes() {
    java.lang.Object ref = index_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      index_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 3;
  private volatile java.lang.Object displayName_;
  /**
   *
   *
   * <pre>
   * The display name of the DeployedIndex. If not provided upon creation,
   * the Index's display_name is used.
   * </pre>
   *
   * <code>string display_name = 3;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The display name of the DeployedIndex. If not provided upon creation,
   * the Index's display_name is used.
   * </pre>
   *
   * <code>string display_name = 3;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when the DeployedIndex was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when the DeployedIndex was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when the DeployedIndex was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int PRIVATE_ENDPOINTS_FIELD_NUMBER = 5;
  private com.google.cloud.aiplatform.v1beta1.IndexPrivateEndpoints privateEndpoints_;
  /**
   *
   *
   * <pre>
   * Output only. Provides paths for users to send requests directly to the deployed index
   * services running on Cloud via private services access. This field is
   * populated if [network][google.cloud.aiplatform.v1beta1.IndexEndpoint.network] is configured.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.IndexPrivateEndpoints private_endpoints = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the privateEndpoints field is set.
   */
  @java.lang.Override
  public boolean hasPrivateEndpoints() {
    return privateEndpoints_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Provides paths for users to send requests directly to the deployed index
   * services running on Cloud via private services access. This field is
   * populated if [network][google.cloud.aiplatform.v1beta1.IndexEndpoint.network] is configured.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.IndexPrivateEndpoints private_endpoints = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The privateEndpoints.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.IndexPrivateEndpoints getPrivateEndpoints() {
    return privateEndpoints_ == null
        ? com.google.cloud.aiplatform.v1beta1.IndexPrivateEndpoints.getDefaultInstance()
        : privateEndpoints_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Provides paths for users to send requests directly to the deployed index
   * services running on Cloud via private services access. This field is
   * populated if [network][google.cloud.aiplatform.v1beta1.IndexEndpoint.network] is configured.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.IndexPrivateEndpoints private_endpoints = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.IndexPrivateEndpointsOrBuilder
      getPrivateEndpointsOrBuilder() {
    return getPrivateEndpoints();
  }

  public static final int INDEX_SYNC_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp indexSyncTime_;
  /**
   *
   *
   * <pre>
   * Output only. The DeployedIndex may depend on various data on its original Index.
   * Additionally when certain changes to the original Index are being done
   * (e.g. when what the Index contains is being changed) the DeployedIndex may
   * be asynchronously updated in the background to reflect this changes.
   * If this timestamp's value is at least the [Index.update_time][google.cloud.aiplatform.v1beta1.Index.update_time] of the
   * original Index, it means that this DeployedIndex and the original Index are
   * in sync. If this timestamp is older, then to see which updates this
   * DeployedIndex already contains (and which not), one must
   * [list][Operations.ListOperations] [Operations][Operation]
   * [working][Operation.name] on the original Index. Only
   * the successfully completed Operations with
   * [Operations.metadata.generic_metadata.update_time]
   * [google.cloud.aiplatform.v1beta1.GenericOperationMetadata.update_time]
   * equal or before this sync time are contained in this DeployedIndex.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp index_sync_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the indexSyncTime field is set.
   */
  @java.lang.Override
  public boolean hasIndexSyncTime() {
    return indexSyncTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The DeployedIndex may depend on various data on its original Index.
   * Additionally when certain changes to the original Index are being done
   * (e.g. when what the Index contains is being changed) the DeployedIndex may
   * be asynchronously updated in the background to reflect this changes.
   * If this timestamp's value is at least the [Index.update_time][google.cloud.aiplatform.v1beta1.Index.update_time] of the
   * original Index, it means that this DeployedIndex and the original Index are
   * in sync. If this timestamp is older, then to see which updates this
   * DeployedIndex already contains (and which not), one must
   * [list][Operations.ListOperations] [Operations][Operation]
   * [working][Operation.name] on the original Index. Only
   * the successfully completed Operations with
   * [Operations.metadata.generic_metadata.update_time]
   * [google.cloud.aiplatform.v1beta1.GenericOperationMetadata.update_time]
   * equal or before this sync time are contained in this DeployedIndex.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp index_sync_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The indexSyncTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getIndexSyncTime() {
    return indexSyncTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : indexSyncTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The DeployedIndex may depend on various data on its original Index.
   * Additionally when certain changes to the original Index are being done
   * (e.g. when what the Index contains is being changed) the DeployedIndex may
   * be asynchronously updated in the background to reflect this changes.
   * If this timestamp's value is at least the [Index.update_time][google.cloud.aiplatform.v1beta1.Index.update_time] of the
   * original Index, it means that this DeployedIndex and the original Index are
   * in sync. If this timestamp is older, then to see which updates this
   * DeployedIndex already contains (and which not), one must
   * [list][Operations.ListOperations] [Operations][Operation]
   * [working][Operation.name] on the original Index. Only
   * the successfully completed Operations with
   * [Operations.metadata.generic_metadata.update_time]
   * [google.cloud.aiplatform.v1beta1.GenericOperationMetadata.update_time]
   * equal or before this sync time are contained in this DeployedIndex.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp index_sync_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getIndexSyncTimeOrBuilder() {
    return getIndexSyncTime();
  }

  public static final int AUTOMATIC_RESOURCES_FIELD_NUMBER = 7;
  private com.google.cloud.aiplatform.v1beta1.AutomaticResources automaticResources_;
  /**
   *
   *
   * <pre>
   * Optional. A description of resources that the DeployedIndex uses, which to large
   * degree are decided by Vertex AI, and optionally allows only a modest
   * additional configuration.
   * If min_replica_count is not set, the default value is 2 (we don't provide
   * SLA when min_replica_count=1). If max_replica_count is not set, the
   * default value is min_replica_count. The max allowed replica count is
   * 1000.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.AutomaticResources automatic_resources = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the automaticResources field is set.
   */
  @java.lang.Override
  public boolean hasAutomaticResources() {
    return automaticResources_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. A description of resources that the DeployedIndex uses, which to large
   * degree are decided by Vertex AI, and optionally allows only a modest
   * additional configuration.
   * If min_replica_count is not set, the default value is 2 (we don't provide
   * SLA when min_replica_count=1). If max_replica_count is not set, the
   * default value is min_replica_count. The max allowed replica count is
   * 1000.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.AutomaticResources automatic_resources = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The automaticResources.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.AutomaticResources getAutomaticResources() {
    return automaticResources_ == null
        ? com.google.cloud.aiplatform.v1beta1.AutomaticResources.getDefaultInstance()
        : automaticResources_;
  }
  /**
   *
   *
   * <pre>
   * Optional. A description of resources that the DeployedIndex uses, which to large
   * degree are decided by Vertex AI, and optionally allows only a modest
   * additional configuration.
   * If min_replica_count is not set, the default value is 2 (we don't provide
   * SLA when min_replica_count=1). If max_replica_count is not set, the
   * default value is min_replica_count. The max allowed replica count is
   * 1000.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.AutomaticResources automatic_resources = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.AutomaticResourcesOrBuilder
      getAutomaticResourcesOrBuilder() {
    return getAutomaticResources();
  }

  public static final int DEDICATED_RESOURCES_FIELD_NUMBER = 16;
  private com.google.cloud.aiplatform.v1beta1.DedicatedResources dedicatedResources_;
  /**
   *
   *
   * <pre>
   * Optional. A description of resources that are dedicated to the DeployedIndex, and
   * that need a higher degree of manual configuration.
   * If min_replica_count is not set, the default value is 2 (we don't provide
   * SLA when min_replica_count=1). If max_replica_count is not set, the
   * default value is min_replica_count. The max allowed replica count is
   * 1000.
   * Available machine types:
   * n1-standard-16
   * n1-standard-32
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 16 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the dedicatedResources field is set.
   */
  @java.lang.Override
  public boolean hasDedicatedResources() {
    return dedicatedResources_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. A description of resources that are dedicated to the DeployedIndex, and
   * that need a higher degree of manual configuration.
   * If min_replica_count is not set, the default value is 2 (we don't provide
   * SLA when min_replica_count=1). If max_replica_count is not set, the
   * default value is min_replica_count. The max allowed replica count is
   * 1000.
   * Available machine types:
   * n1-standard-16
   * n1-standard-32
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 16 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The dedicatedResources.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.DedicatedResources getDedicatedResources() {
    return dedicatedResources_ == null
        ? com.google.cloud.aiplatform.v1beta1.DedicatedResources.getDefaultInstance()
        : dedicatedResources_;
  }
  /**
   *
   *
   * <pre>
   * Optional. A description of resources that are dedicated to the DeployedIndex, and
   * that need a higher degree of manual configuration.
   * If min_replica_count is not set, the default value is 2 (we don't provide
   * SLA when min_replica_count=1). If max_replica_count is not set, the
   * default value is min_replica_count. The max allowed replica count is
   * 1000.
   * Available machine types:
   * n1-standard-16
   * n1-standard-32
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 16 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.DedicatedResourcesOrBuilder
      getDedicatedResourcesOrBuilder() {
    return getDedicatedResources();
  }

  public static final int ENABLE_ACCESS_LOGGING_FIELD_NUMBER = 8;
  private boolean enableAccessLogging_;
  /**
   *
   *
   * <pre>
   * Optional. If true, private endpoint's access logs are sent to StackDriver Logging.
   * These logs are like standard server access logs, containing
   * information like timestamp and latency for each MatchRequest.
   * Note that Stackdriver logs may incur a cost, especially if the deployed
   * index receives a high queries per second rate (QPS).
   * Estimate your costs before enabling this option.
   * </pre>
   *
   * <code>bool enable_access_logging = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The enableAccessLogging.
   */
  @java.lang.Override
  public boolean getEnableAccessLogging() {
    return enableAccessLogging_;
  }

  public static final int DEPLOYED_INDEX_AUTH_CONFIG_FIELD_NUMBER = 9;
  private com.google.cloud.aiplatform.v1beta1.DeployedIndexAuthConfig deployedIndexAuthConfig_;
  /**
   *
   *
   * <pre>
   * Optional. If set, the authentication is enabled for the private endpoint.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.DeployedIndexAuthConfig deployed_index_auth_config = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the deployedIndexAuthConfig field is set.
   */
  @java.lang.Override
  public boolean hasDeployedIndexAuthConfig() {
    return deployedIndexAuthConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. If set, the authentication is enabled for the private endpoint.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.DeployedIndexAuthConfig deployed_index_auth_config = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The deployedIndexAuthConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.DeployedIndexAuthConfig getDeployedIndexAuthConfig() {
    return deployedIndexAuthConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.DeployedIndexAuthConfig.getDefaultInstance()
        : deployedIndexAuthConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. If set, the authentication is enabled for the private endpoint.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.DeployedIndexAuthConfig deployed_index_auth_config = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.DeployedIndexAuthConfigOrBuilder
      getDeployedIndexAuthConfigOrBuilder() {
    return getDeployedIndexAuthConfig();
  }

  public static final int RESERVED_IP_RANGES_FIELD_NUMBER = 10;
  private com.google.protobuf.LazyStringList reservedIpRanges_;
  /**
   *
   *
   * <pre>
   * Optional. A list of reserved ip ranges under the VPC network that can be
   * used for this DeployedIndex.
   * If set, we will deploy the index within the provided ip ranges. Otherwise,
   * the index might be deployed to any ip ranges under the provided VPC
   * network.
   * The value sohuld be the name of the address
   * (https://cloud.google.com/compute/docs/reference/rest/v1/addresses)
   * Example: 'vertex-ai-ip-range'.
   * </pre>
   *
   * <code>repeated string reserved_ip_ranges = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the reservedIpRanges.
   */
  public com.google.protobuf.ProtocolStringList getReservedIpRangesList() {
    return reservedIpRanges_;
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of reserved ip ranges under the VPC network that can be
   * used for this DeployedIndex.
   * If set, we will deploy the index within the provided ip ranges. Otherwise,
   * the index might be deployed to any ip ranges under the provided VPC
   * network.
   * The value sohuld be the name of the address
   * (https://cloud.google.com/compute/docs/reference/rest/v1/addresses)
   * Example: 'vertex-ai-ip-range'.
   * </pre>
   *
   * <code>repeated string reserved_ip_ranges = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of reservedIpRanges.
   */
  public int getReservedIpRangesCount() {
    return reservedIpRanges_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of reserved ip ranges under the VPC network that can be
   * used for this DeployedIndex.
   * If set, we will deploy the index within the provided ip ranges. Otherwise,
   * the index might be deployed to any ip ranges under the provided VPC
   * network.
   * The value sohuld be the name of the address
   * (https://cloud.google.com/compute/docs/reference/rest/v1/addresses)
   * Example: 'vertex-ai-ip-range'.
   * </pre>
   *
   * <code>repeated string reserved_ip_ranges = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The reservedIpRanges at the given index.
   */
  public java.lang.String getReservedIpRanges(int index) {
    return reservedIpRanges_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of reserved ip ranges under the VPC network that can be
   * used for this DeployedIndex.
   * If set, we will deploy the index within the provided ip ranges. Otherwise,
   * the index might be deployed to any ip ranges under the provided VPC
   * network.
   * The value sohuld be the name of the address
   * (https://cloud.google.com/compute/docs/reference/rest/v1/addresses)
   * Example: 'vertex-ai-ip-range'.
   * </pre>
   *
   * <code>repeated string reserved_ip_ranges = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the reservedIpRanges at the given index.
   */
  public com.google.protobuf.ByteString getReservedIpRangesBytes(int index) {
    return reservedIpRanges_.getByteString(index);
  }

  public static final int DEPLOYMENT_GROUP_FIELD_NUMBER = 11;
  private volatile java.lang.Object deploymentGroup_;
  /**
   *
   *
   * <pre>
   * Optional. The deployment group can be no longer than 64 characters (eg:
   * 'test', 'prod'). If not set, we will use the 'default' deployment group.
   * Creating `deployment_groups` with `reserved_ip_ranges` is a recommended
   * practice when the peered network has multiple peering ranges. This creates
   * your deployments from predictable IP spaces for easier traffic
   * administration. Also, one deployment_group (except 'default') can only be
   * used with the same reserved_ip_ranges which means if the deployment_group
   * has been used with reserved_ip_ranges: [a, b, c], using it with [a, b] or
   * [d, e] is disallowed.
   * Note: we only support up to 5 deployment groups(not including 'default').
   * </pre>
   *
   * <code>string deployment_group = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The deploymentGroup.
   */
  @java.lang.Override
  public java.lang.String getDeploymentGroup() {
    java.lang.Object ref = deploymentGroup_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      deploymentGroup_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The deployment group can be no longer than 64 characters (eg:
   * 'test', 'prod'). If not set, we will use the 'default' deployment group.
   * Creating `deployment_groups` with `reserved_ip_ranges` is a recommended
   * practice when the peered network has multiple peering ranges. This creates
   * your deployments from predictable IP spaces for easier traffic
   * administration. Also, one deployment_group (except 'default') can only be
   * used with the same reserved_ip_ranges which means if the deployment_group
   * has been used with reserved_ip_ranges: [a, b, c], using it with [a, b] or
   * [d, e] is disallowed.
   * Note: we only support up to 5 deployment groups(not including 'default').
   * </pre>
   *
   * <code>string deployment_group = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for deploymentGroup.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDeploymentGroupBytes() {
    java.lang.Object ref = deploymentGroup_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      deploymentGroup_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(index_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, index_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, displayName_);
    }
    if (createTime_ != null) {
      output.writeMessage(4, getCreateTime());
    }
    if (privateEndpoints_ != null) {
      output.writeMessage(5, getPrivateEndpoints());
    }
    if (indexSyncTime_ != null) {
      output.writeMessage(6, getIndexSyncTime());
    }
    if (automaticResources_ != null) {
      output.writeMessage(7, getAutomaticResources());
    }
    if (enableAccessLogging_ != false) {
      output.writeBool(8, enableAccessLogging_);
    }
    if (deployedIndexAuthConfig_ != null) {
      output.writeMessage(9, getDeployedIndexAuthConfig());
    }
    for (int i = 0; i < reservedIpRanges_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, reservedIpRanges_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deploymentGroup_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, deploymentGroup_);
    }
    if (dedicatedResources_ != null) {
      output.writeMessage(16, getDedicatedResources());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(index_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, index_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, displayName_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getCreateTime());
    }
    if (privateEndpoints_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getPrivateEndpoints());
    }
    if (indexSyncTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getIndexSyncTime());
    }
    if (automaticResources_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getAutomaticResources());
    }
    if (enableAccessLogging_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(8, enableAccessLogging_);
    }
    if (deployedIndexAuthConfig_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(9, getDeployedIndexAuthConfig());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < reservedIpRanges_.size(); i++) {
        dataSize += computeStringSizeNoTag(reservedIpRanges_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getReservedIpRangesList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deploymentGroup_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, deploymentGroup_);
    }
    if (dedicatedResources_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(16, getDedicatedResources());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.DeployedIndex)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.DeployedIndex other =
        (com.google.cloud.aiplatform.v1beta1.DeployedIndex) obj;

    if (!getId().equals(other.getId())) return false;
    if (!getIndex().equals(other.getIndex())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasPrivateEndpoints() != other.hasPrivateEndpoints()) return false;
    if (hasPrivateEndpoints()) {
      if (!getPrivateEndpoints().equals(other.getPrivateEndpoints())) return false;
    }
    if (hasIndexSyncTime() != other.hasIndexSyncTime()) return false;
    if (hasIndexSyncTime()) {
      if (!getIndexSyncTime().equals(other.getIndexSyncTime())) return false;
    }
    if (hasAutomaticResources() != other.hasAutomaticResources()) return false;
    if (hasAutomaticResources()) {
      if (!getAutomaticResources().equals(other.getAutomaticResources())) return false;
    }
    if (hasDedicatedResources() != other.hasDedicatedResources()) return false;
    if (hasDedicatedResources()) {
      if (!getDedicatedResources().equals(other.getDedicatedResources())) return false;
    }
    if (getEnableAccessLogging() != other.getEnableAccessLogging()) return false;
    if (hasDeployedIndexAuthConfig() != other.hasDeployedIndexAuthConfig()) return false;
    if (hasDeployedIndexAuthConfig()) {
      if (!getDeployedIndexAuthConfig().equals(other.getDeployedIndexAuthConfig())) return false;
    }
    if (!getReservedIpRangesList().equals(other.getReservedIpRangesList())) return false;
    if (!getDeploymentGroup().equals(other.getDeploymentGroup())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    hash = (37 * hash) + INDEX_FIELD_NUMBER;
    hash = (53 * hash) + getIndex().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasPrivateEndpoints()) {
      hash = (37 * hash) + PRIVATE_ENDPOINTS_FIELD_NUMBER;
      hash = (53 * hash) + getPrivateEndpoints().hashCode();
    }
    if (hasIndexSyncTime()) {
      hash = (37 * hash) + INDEX_SYNC_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getIndexSyncTime().hashCode();
    }
    if (hasAutomaticResources()) {
      hash = (37 * hash) + AUTOMATIC_RESOURCES_FIELD_NUMBER;
      hash = (53 * hash) + getAutomaticResources().hashCode();
    }
    if (hasDedicatedResources()) {
      hash = (37 * hash) + DEDICATED_RESOURCES_FIELD_NUMBER;
      hash = (53 * hash) + getDedicatedResources().hashCode();
    }
    hash = (37 * hash) + ENABLE_ACCESS_LOGGING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableAccessLogging());
    if (hasDeployedIndexAuthConfig()) {
      hash = (37 * hash) + DEPLOYED_INDEX_AUTH_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDeployedIndexAuthConfig().hashCode();
    }
    if (getReservedIpRangesCount() > 0) {
      hash = (37 * hash) + RESERVED_IP_RANGES_FIELD_NUMBER;
      hash = (53 * hash) + getReservedIpRangesList().hashCode();
    }
    hash = (37 * hash) + DEPLOYMENT_GROUP_FIELD_NUMBER;
    hash = (53 * hash) + getDeploymentGroup().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.DeployedIndex parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.DeployedIndex parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.DeployedIndex parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.DeployedIndex parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.DeployedIndex parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.DeployedIndex parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.DeployedIndex parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.DeployedIndex parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.DeployedIndex parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.DeployedIndex parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.DeployedIndex parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.DeployedIndex parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.DeployedIndex prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A deployment of an Index. IndexEndpoints contain one or more DeployedIndexes.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.DeployedIndex}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.DeployedIndex)
      com.google.cloud.aiplatform.v1beta1.DeployedIndexOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.IndexEndpointProto
          .internal_static_google_cloud_aiplatform_v1beta1_DeployedIndex_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.IndexEndpointProto
          .internal_static_google_cloud_aiplatform_v1beta1_DeployedIndex_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.DeployedIndex.class,
              com.google.cloud.aiplatform.v1beta1.DeployedIndex.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.DeployedIndex.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      id_ = "";

      index_ = "";

      displayName_ = "";

      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      if (privateEndpointsBuilder_ == null) {
        privateEndpoints_ = null;
      } else {
        privateEndpoints_ = null;
        privateEndpointsBuilder_ = null;
      }
      if (indexSyncTimeBuilder_ == null) {
        indexSyncTime_ = null;
      } else {
        indexSyncTime_ = null;
        indexSyncTimeBuilder_ = null;
      }
      if (automaticResourcesBuilder_ == null) {
        automaticResources_ = null;
      } else {
        automaticResources_ = null;
        automaticResourcesBuilder_ = null;
      }
      if (dedicatedResourcesBuilder_ == null) {
        dedicatedResources_ = null;
      } else {
        dedicatedResources_ = null;
        dedicatedResourcesBuilder_ = null;
      }
      enableAccessLogging_ = false;

      if (deployedIndexAuthConfigBuilder_ == null) {
        deployedIndexAuthConfig_ = null;
      } else {
        deployedIndexAuthConfig_ = null;
        deployedIndexAuthConfigBuilder_ = null;
      }
      reservedIpRanges_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      deploymentGroup_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.IndexEndpointProto
          .internal_static_google_cloud_aiplatform_v1beta1_DeployedIndex_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.DeployedIndex getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.DeployedIndex.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.DeployedIndex build() {
      com.google.cloud.aiplatform.v1beta1.DeployedIndex result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.DeployedIndex buildPartial() {
      com.google.cloud.aiplatform.v1beta1.DeployedIndex result =
          new com.google.cloud.aiplatform.v1beta1.DeployedIndex(this);
      int from_bitField0_ = bitField0_;
      result.id_ = id_;
      result.index_ = index_;
      result.displayName_ = displayName_;
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (privateEndpointsBuilder_ == null) {
        result.privateEndpoints_ = privateEndpoints_;
      } else {
        result.privateEndpoints_ = privateEndpointsBuilder_.build();
      }
      if (indexSyncTimeBuilder_ == null) {
        result.indexSyncTime_ = indexSyncTime_;
      } else {
        result.indexSyncTime_ = indexSyncTimeBuilder_.build();
      }
      if (automaticResourcesBuilder_ == null) {
        result.automaticResources_ = automaticResources_;
      } else {
        result.automaticResources_ = automaticResourcesBuilder_.build();
      }
      if (dedicatedResourcesBuilder_ == null) {
        result.dedicatedResources_ = dedicatedResources_;
      } else {
        result.dedicatedResources_ = dedicatedResourcesBuilder_.build();
      }
      result.enableAccessLogging_ = enableAccessLogging_;
      if (deployedIndexAuthConfigBuilder_ == null) {
        result.deployedIndexAuthConfig_ = deployedIndexAuthConfig_;
      } else {
        result.deployedIndexAuthConfig_ = deployedIndexAuthConfigBuilder_.build();
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        reservedIpRanges_ = reservedIpRanges_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.reservedIpRanges_ = reservedIpRanges_;
      result.deploymentGroup_ = deploymentGroup_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.DeployedIndex) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.DeployedIndex) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.DeployedIndex other) {
      if (other == com.google.cloud.aiplatform.v1beta1.DeployedIndex.getDefaultInstance())
        return this;
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        onChanged();
      }
      if (!other.getIndex().isEmpty()) {
        index_ = other.index_;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasPrivateEndpoints()) {
        mergePrivateEndpoints(other.getPrivateEndpoints());
      }
      if (other.hasIndexSyncTime()) {
        mergeIndexSyncTime(other.getIndexSyncTime());
      }
      if (other.hasAutomaticResources()) {
        mergeAutomaticResources(other.getAutomaticResources());
      }
      if (other.hasDedicatedResources()) {
        mergeDedicatedResources(other.getDedicatedResources());
      }
      if (other.getEnableAccessLogging() != false) {
        setEnableAccessLogging(other.getEnableAccessLogging());
      }
      if (other.hasDeployedIndexAuthConfig()) {
        mergeDeployedIndexAuthConfig(other.getDeployedIndexAuthConfig());
      }
      if (!other.reservedIpRanges_.isEmpty()) {
        if (reservedIpRanges_.isEmpty()) {
          reservedIpRanges_ = other.reservedIpRanges_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureReservedIpRangesIsMutable();
          reservedIpRanges_.addAll(other.reservedIpRanges_);
        }
        onChanged();
      }
      if (!other.getDeploymentGroup().isEmpty()) {
        deploymentGroup_ = other.deploymentGroup_;
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.aiplatform.v1beta1.DeployedIndex parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.aiplatform.v1beta1.DeployedIndex) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * Required. The user specified ID of the DeployedIndex.
     * The ID can be up to 128 characters long and must start with a letter and
     * only contain letters, numbers, and underscores.
     * The ID must be unique within the project it is created in.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The id.
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The user specified ID of the DeployedIndex.
     * The ID can be up to 128 characters long and must start with a letter and
     * only contain letters, numbers, and underscores.
     * The ID must be unique within the project it is created in.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for id.
     */
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The user specified ID of the DeployedIndex.
     * The ID can be up to 128 characters long and must start with a letter and
     * only contain letters, numbers, and underscores.
     * The ID must be unique within the project it is created in.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      id_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The user specified ID of the DeployedIndex.
     * The ID can be up to 128 characters long and must start with a letter and
     * only contain letters, numbers, and underscores.
     * The ID must be unique within the project it is created in.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {

      id_ = getDefaultInstance().getId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The user specified ID of the DeployedIndex.
     * The ID can be up to 128 characters long and must start with a letter and
     * only contain letters, numbers, and underscores.
     * The ID must be unique within the project it is created in.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      id_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object index_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the Index this is the deployment of.
     * We may refer to this Index as the DeployedIndex's "original" Index.
     * </pre>
     *
     * <code>
     * string index = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The index.
     */
    public java.lang.String getIndex() {
      java.lang.Object ref = index_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        index_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the Index this is the deployment of.
     * We may refer to this Index as the DeployedIndex's "original" Index.
     * </pre>
     *
     * <code>
     * string index = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for index.
     */
    public com.google.protobuf.ByteString getIndexBytes() {
      java.lang.Object ref = index_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        index_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the Index this is the deployment of.
     * We may refer to this Index as the DeployedIndex's "original" Index.
     * </pre>
     *
     * <code>
     * string index = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The index to set.
     * @return This builder for chaining.
     */
    public Builder setIndex(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      index_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the Index this is the deployment of.
     * We may refer to this Index as the DeployedIndex's "original" Index.
     * </pre>
     *
     * <code>
     * string index = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIndex() {

      index_ = getDefaultInstance().getIndex();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the Index this is the deployment of.
     * We may refer to this Index as the DeployedIndex's "original" Index.
     * </pre>
     *
     * <code>
     * string index = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for index to set.
     * @return This builder for chaining.
     */
    public Builder setIndexBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      index_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * The display name of the DeployedIndex. If not provided upon creation,
     * the Index's display_name is used.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The display name of the DeployedIndex. If not provided upon creation,
     * the Index's display_name is used.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The display name of the DeployedIndex. If not provided upon creation,
     * the Index's display_name is used.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      displayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The display name of the DeployedIndex. If not provided upon creation,
     * the Index's display_name is used.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {

      displayName_ = getDefaultInstance().getDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The display name of the DeployedIndex. If not provided upon creation,
     * the Index's display_name is used.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      displayName_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the DeployedIndex was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the DeployedIndex was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the DeployedIndex was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the DeployedIndex was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the DeployedIndex was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the DeployedIndex was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the DeployedIndex was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the DeployedIndex was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the DeployedIndex was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.IndexPrivateEndpoints privateEndpoints_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.IndexPrivateEndpoints,
            com.google.cloud.aiplatform.v1beta1.IndexPrivateEndpoints.Builder,
            com.google.cloud.aiplatform.v1beta1.IndexPrivateEndpointsOrBuilder>
        privateEndpointsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Provides paths for users to send requests directly to the deployed index
     * services running on Cloud via private services access. This field is
     * populated if [network][google.cloud.aiplatform.v1beta1.IndexEndpoint.network] is configured.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.IndexPrivateEndpoints private_endpoints = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the privateEndpoints field is set.
     */
    public boolean hasPrivateEndpoints() {
      return privateEndpointsBuilder_ != null || privateEndpoints_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Provides paths for users to send requests directly to the deployed index
     * services running on Cloud via private services access. This field is
     * populated if [network][google.cloud.aiplatform.v1beta1.IndexEndpoint.network] is configured.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.IndexPrivateEndpoints private_endpoints = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The privateEndpoints.
     */
    public com.google.cloud.aiplatform.v1beta1.IndexPrivateEndpoints getPrivateEndpoints() {
      if (privateEndpointsBuilder_ == null) {
        return privateEndpoints_ == null
            ? com.google.cloud.aiplatform.v1beta1.IndexPrivateEndpoints.getDefaultInstance()
            : privateEndpoints_;
      } else {
        return privateEndpointsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Provides paths for users to send requests directly to the deployed index
     * services running on Cloud via private services access. This field is
     * populated if [network][google.cloud.aiplatform.v1beta1.IndexEndpoint.network] is configured.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.IndexPrivateEndpoints private_endpoints = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPrivateEndpoints(
        com.google.cloud.aiplatform.v1beta1.IndexPrivateEndpoints value) {
      if (privateEndpointsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        privateEndpoints_ = value;
        onChanged();
      } else {
        privateEndpointsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Provides paths for users to send requests directly to the deployed index
     * services running on Cloud via private services access. This field is
     * populated if [network][google.cloud.aiplatform.v1beta1.IndexEndpoint.network] is configured.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.IndexPrivateEndpoints private_endpoints = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPrivateEndpoints(
        com.google.cloud.aiplatform.v1beta1.IndexPrivateEndpoints.Builder builderForValue) {
      if (privateEndpointsBuilder_ == null) {
        privateEndpoints_ = builderForValue.build();
        onChanged();
      } else {
        privateEndpointsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Provides paths for users to send requests directly to the deployed index
     * services running on Cloud via private services access. This field is
     * populated if [network][google.cloud.aiplatform.v1beta1.IndexEndpoint.network] is configured.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.IndexPrivateEndpoints private_endpoints = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergePrivateEndpoints(
        com.google.cloud.aiplatform.v1beta1.IndexPrivateEndpoints value) {
      if (privateEndpointsBuilder_ == null) {
        if (privateEndpoints_ != null) {
          privateEndpoints_ =
              com.google.cloud.aiplatform.v1beta1.IndexPrivateEndpoints.newBuilder(
                      privateEndpoints_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          privateEndpoints_ = value;
        }
        onChanged();
      } else {
        privateEndpointsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Provides paths for users to send requests directly to the deployed index
     * services running on Cloud via private services access. This field is
     * populated if [network][google.cloud.aiplatform.v1beta1.IndexEndpoint.network] is configured.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.IndexPrivateEndpoints private_endpoints = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearPrivateEndpoints() {
      if (privateEndpointsBuilder_ == null) {
        privateEndpoints_ = null;
        onChanged();
      } else {
        privateEndpoints_ = null;
        privateEndpointsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Provides paths for users to send requests directly to the deployed index
     * services running on Cloud via private services access. This field is
     * populated if [network][google.cloud.aiplatform.v1beta1.IndexEndpoint.network] is configured.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.IndexPrivateEndpoints private_endpoints = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.IndexPrivateEndpoints.Builder
        getPrivateEndpointsBuilder() {

      onChanged();
      return getPrivateEndpointsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Provides paths for users to send requests directly to the deployed index
     * services running on Cloud via private services access. This field is
     * populated if [network][google.cloud.aiplatform.v1beta1.IndexEndpoint.network] is configured.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.IndexPrivateEndpoints private_endpoints = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.IndexPrivateEndpointsOrBuilder
        getPrivateEndpointsOrBuilder() {
      if (privateEndpointsBuilder_ != null) {
        return privateEndpointsBuilder_.getMessageOrBuilder();
      } else {
        return privateEndpoints_ == null
            ? com.google.cloud.aiplatform.v1beta1.IndexPrivateEndpoints.getDefaultInstance()
            : privateEndpoints_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Provides paths for users to send requests directly to the deployed index
     * services running on Cloud via private services access. This field is
     * populated if [network][google.cloud.aiplatform.v1beta1.IndexEndpoint.network] is configured.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.IndexPrivateEndpoints private_endpoints = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.IndexPrivateEndpoints,
            com.google.cloud.aiplatform.v1beta1.IndexPrivateEndpoints.Builder,
            com.google.cloud.aiplatform.v1beta1.IndexPrivateEndpointsOrBuilder>
        getPrivateEndpointsFieldBuilder() {
      if (privateEndpointsBuilder_ == null) {
        privateEndpointsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.IndexPrivateEndpoints,
                com.google.cloud.aiplatform.v1beta1.IndexPrivateEndpoints.Builder,
                com.google.cloud.aiplatform.v1beta1.IndexPrivateEndpointsOrBuilder>(
                getPrivateEndpoints(), getParentForChildren(), isClean());
        privateEndpoints_ = null;
      }
      return privateEndpointsBuilder_;
    }

    private com.google.protobuf.Timestamp indexSyncTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        indexSyncTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The DeployedIndex may depend on various data on its original Index.
     * Additionally when certain changes to the original Index are being done
     * (e.g. when what the Index contains is being changed) the DeployedIndex may
     * be asynchronously updated in the background to reflect this changes.
     * If this timestamp's value is at least the [Index.update_time][google.cloud.aiplatform.v1beta1.Index.update_time] of the
     * original Index, it means that this DeployedIndex and the original Index are
     * in sync. If this timestamp is older, then to see which updates this
     * DeployedIndex already contains (and which not), one must
     * [list][Operations.ListOperations] [Operations][Operation]
     * [working][Operation.name] on the original Index. Only
     * the successfully completed Operations with
     * [Operations.metadata.generic_metadata.update_time]
     * [google.cloud.aiplatform.v1beta1.GenericOperationMetadata.update_time]
     * equal or before this sync time are contained in this DeployedIndex.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp index_sync_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the indexSyncTime field is set.
     */
    public boolean hasIndexSyncTime() {
      return indexSyncTimeBuilder_ != null || indexSyncTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The DeployedIndex may depend on various data on its original Index.
     * Additionally when certain changes to the original Index are being done
     * (e.g. when what the Index contains is being changed) the DeployedIndex may
     * be asynchronously updated in the background to reflect this changes.
     * If this timestamp's value is at least the [Index.update_time][google.cloud.aiplatform.v1beta1.Index.update_time] of the
     * original Index, it means that this DeployedIndex and the original Index are
     * in sync. If this timestamp is older, then to see which updates this
     * DeployedIndex already contains (and which not), one must
     * [list][Operations.ListOperations] [Operations][Operation]
     * [working][Operation.name] on the original Index. Only
     * the successfully completed Operations with
     * [Operations.metadata.generic_metadata.update_time]
     * [google.cloud.aiplatform.v1beta1.GenericOperationMetadata.update_time]
     * equal or before this sync time are contained in this DeployedIndex.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp index_sync_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The indexSyncTime.
     */
    public com.google.protobuf.Timestamp getIndexSyncTime() {
      if (indexSyncTimeBuilder_ == null) {
        return indexSyncTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : indexSyncTime_;
      } else {
        return indexSyncTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The DeployedIndex may depend on various data on its original Index.
     * Additionally when certain changes to the original Index are being done
     * (e.g. when what the Index contains is being changed) the DeployedIndex may
     * be asynchronously updated in the background to reflect this changes.
     * If this timestamp's value is at least the [Index.update_time][google.cloud.aiplatform.v1beta1.Index.update_time] of the
     * original Index, it means that this DeployedIndex and the original Index are
     * in sync. If this timestamp is older, then to see which updates this
     * DeployedIndex already contains (and which not), one must
     * [list][Operations.ListOperations] [Operations][Operation]
     * [working][Operation.name] on the original Index. Only
     * the successfully completed Operations with
     * [Operations.metadata.generic_metadata.update_time]
     * [google.cloud.aiplatform.v1beta1.GenericOperationMetadata.update_time]
     * equal or before this sync time are contained in this DeployedIndex.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp index_sync_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setIndexSyncTime(com.google.protobuf.Timestamp value) {
      if (indexSyncTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        indexSyncTime_ = value;
        onChanged();
      } else {
        indexSyncTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The DeployedIndex may depend on various data on its original Index.
     * Additionally when certain changes to the original Index are being done
     * (e.g. when what the Index contains is being changed) the DeployedIndex may
     * be asynchronously updated in the background to reflect this changes.
     * If this timestamp's value is at least the [Index.update_time][google.cloud.aiplatform.v1beta1.Index.update_time] of the
     * original Index, it means that this DeployedIndex and the original Index are
     * in sync. If this timestamp is older, then to see which updates this
     * DeployedIndex already contains (and which not), one must
     * [list][Operations.ListOperations] [Operations][Operation]
     * [working][Operation.name] on the original Index. Only
     * the successfully completed Operations with
     * [Operations.metadata.generic_metadata.update_time]
     * [google.cloud.aiplatform.v1beta1.GenericOperationMetadata.update_time]
     * equal or before this sync time are contained in this DeployedIndex.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp index_sync_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setIndexSyncTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (indexSyncTimeBuilder_ == null) {
        indexSyncTime_ = builderForValue.build();
        onChanged();
      } else {
        indexSyncTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The DeployedIndex may depend on various data on its original Index.
     * Additionally when certain changes to the original Index are being done
     * (e.g. when what the Index contains is being changed) the DeployedIndex may
     * be asynchronously updated in the background to reflect this changes.
     * If this timestamp's value is at least the [Index.update_time][google.cloud.aiplatform.v1beta1.Index.update_time] of the
     * original Index, it means that this DeployedIndex and the original Index are
     * in sync. If this timestamp is older, then to see which updates this
     * DeployedIndex already contains (and which not), one must
     * [list][Operations.ListOperations] [Operations][Operation]
     * [working][Operation.name] on the original Index. Only
     * the successfully completed Operations with
     * [Operations.metadata.generic_metadata.update_time]
     * [google.cloud.aiplatform.v1beta1.GenericOperationMetadata.update_time]
     * equal or before this sync time are contained in this DeployedIndex.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp index_sync_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeIndexSyncTime(com.google.protobuf.Timestamp value) {
      if (indexSyncTimeBuilder_ == null) {
        if (indexSyncTime_ != null) {
          indexSyncTime_ =
              com.google.protobuf.Timestamp.newBuilder(indexSyncTime_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          indexSyncTime_ = value;
        }
        onChanged();
      } else {
        indexSyncTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The DeployedIndex may depend on various data on its original Index.
     * Additionally when certain changes to the original Index are being done
     * (e.g. when what the Index contains is being changed) the DeployedIndex may
     * be asynchronously updated in the background to reflect this changes.
     * If this timestamp's value is at least the [Index.update_time][google.cloud.aiplatform.v1beta1.Index.update_time] of the
     * original Index, it means that this DeployedIndex and the original Index are
     * in sync. If this timestamp is older, then to see which updates this
     * DeployedIndex already contains (and which not), one must
     * [list][Operations.ListOperations] [Operations][Operation]
     * [working][Operation.name] on the original Index. Only
     * the successfully completed Operations with
     * [Operations.metadata.generic_metadata.update_time]
     * [google.cloud.aiplatform.v1beta1.GenericOperationMetadata.update_time]
     * equal or before this sync time are contained in this DeployedIndex.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp index_sync_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearIndexSyncTime() {
      if (indexSyncTimeBuilder_ == null) {
        indexSyncTime_ = null;
        onChanged();
      } else {
        indexSyncTime_ = null;
        indexSyncTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The DeployedIndex may depend on various data on its original Index.
     * Additionally when certain changes to the original Index are being done
     * (e.g. when what the Index contains is being changed) the DeployedIndex may
     * be asynchronously updated in the background to reflect this changes.
     * If this timestamp's value is at least the [Index.update_time][google.cloud.aiplatform.v1beta1.Index.update_time] of the
     * original Index, it means that this DeployedIndex and the original Index are
     * in sync. If this timestamp is older, then to see which updates this
     * DeployedIndex already contains (and which not), one must
     * [list][Operations.ListOperations] [Operations][Operation]
     * [working][Operation.name] on the original Index. Only
     * the successfully completed Operations with
     * [Operations.metadata.generic_metadata.update_time]
     * [google.cloud.aiplatform.v1beta1.GenericOperationMetadata.update_time]
     * equal or before this sync time are contained in this DeployedIndex.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp index_sync_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getIndexSyncTimeBuilder() {

      onChanged();
      return getIndexSyncTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The DeployedIndex may depend on various data on its original Index.
     * Additionally when certain changes to the original Index are being done
     * (e.g. when what the Index contains is being changed) the DeployedIndex may
     * be asynchronously updated in the background to reflect this changes.
     * If this timestamp's value is at least the [Index.update_time][google.cloud.aiplatform.v1beta1.Index.update_time] of the
     * original Index, it means that this DeployedIndex and the original Index are
     * in sync. If this timestamp is older, then to see which updates this
     * DeployedIndex already contains (and which not), one must
     * [list][Operations.ListOperations] [Operations][Operation]
     * [working][Operation.name] on the original Index. Only
     * the successfully completed Operations with
     * [Operations.metadata.generic_metadata.update_time]
     * [google.cloud.aiplatform.v1beta1.GenericOperationMetadata.update_time]
     * equal or before this sync time are contained in this DeployedIndex.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp index_sync_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getIndexSyncTimeOrBuilder() {
      if (indexSyncTimeBuilder_ != null) {
        return indexSyncTimeBuilder_.getMessageOrBuilder();
      } else {
        return indexSyncTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : indexSyncTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The DeployedIndex may depend on various data on its original Index.
     * Additionally when certain changes to the original Index are being done
     * (e.g. when what the Index contains is being changed) the DeployedIndex may
     * be asynchronously updated in the background to reflect this changes.
     * If this timestamp's value is at least the [Index.update_time][google.cloud.aiplatform.v1beta1.Index.update_time] of the
     * original Index, it means that this DeployedIndex and the original Index are
     * in sync. If this timestamp is older, then to see which updates this
     * DeployedIndex already contains (and which not), one must
     * [list][Operations.ListOperations] [Operations][Operation]
     * [working][Operation.name] on the original Index. Only
     * the successfully completed Operations with
     * [Operations.metadata.generic_metadata.update_time]
     * [google.cloud.aiplatform.v1beta1.GenericOperationMetadata.update_time]
     * equal or before this sync time are contained in this DeployedIndex.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp index_sync_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getIndexSyncTimeFieldBuilder() {
      if (indexSyncTimeBuilder_ == null) {
        indexSyncTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getIndexSyncTime(), getParentForChildren(), isClean());
        indexSyncTime_ = null;
      }
      return indexSyncTimeBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.AutomaticResources automaticResources_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.AutomaticResources,
            com.google.cloud.aiplatform.v1beta1.AutomaticResources.Builder,
            com.google.cloud.aiplatform.v1beta1.AutomaticResourcesOrBuilder>
        automaticResourcesBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. A description of resources that the DeployedIndex uses, which to large
     * degree are decided by Vertex AI, and optionally allows only a modest
     * additional configuration.
     * If min_replica_count is not set, the default value is 2 (we don't provide
     * SLA when min_replica_count=1). If max_replica_count is not set, the
     * default value is min_replica_count. The max allowed replica count is
     * 1000.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AutomaticResources automatic_resources = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the automaticResources field is set.
     */
    public boolean hasAutomaticResources() {
      return automaticResourcesBuilder_ != null || automaticResources_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. A description of resources that the DeployedIndex uses, which to large
     * degree are decided by Vertex AI, and optionally allows only a modest
     * additional configuration.
     * If min_replica_count is not set, the default value is 2 (we don't provide
     * SLA when min_replica_count=1). If max_replica_count is not set, the
     * default value is min_replica_count. The max allowed replica count is
     * 1000.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AutomaticResources automatic_resources = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The automaticResources.
     */
    public com.google.cloud.aiplatform.v1beta1.AutomaticResources getAutomaticResources() {
      if (automaticResourcesBuilder_ == null) {
        return automaticResources_ == null
            ? com.google.cloud.aiplatform.v1beta1.AutomaticResources.getDefaultInstance()
            : automaticResources_;
      } else {
        return automaticResourcesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A description of resources that the DeployedIndex uses, which to large
     * degree are decided by Vertex AI, and optionally allows only a modest
     * additional configuration.
     * If min_replica_count is not set, the default value is 2 (we don't provide
     * SLA when min_replica_count=1). If max_replica_count is not set, the
     * default value is min_replica_count. The max allowed replica count is
     * 1000.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AutomaticResources automatic_resources = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAutomaticResources(
        com.google.cloud.aiplatform.v1beta1.AutomaticResources value) {
      if (automaticResourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        automaticResources_ = value;
        onChanged();
      } else {
        automaticResourcesBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A description of resources that the DeployedIndex uses, which to large
     * degree are decided by Vertex AI, and optionally allows only a modest
     * additional configuration.
     * If min_replica_count is not set, the default value is 2 (we don't provide
     * SLA when min_replica_count=1). If max_replica_count is not set, the
     * default value is min_replica_count. The max allowed replica count is
     * 1000.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AutomaticResources automatic_resources = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAutomaticResources(
        com.google.cloud.aiplatform.v1beta1.AutomaticResources.Builder builderForValue) {
      if (automaticResourcesBuilder_ == null) {
        automaticResources_ = builderForValue.build();
        onChanged();
      } else {
        automaticResourcesBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A description of resources that the DeployedIndex uses, which to large
     * degree are decided by Vertex AI, and optionally allows only a modest
     * additional configuration.
     * If min_replica_count is not set, the default value is 2 (we don't provide
     * SLA when min_replica_count=1). If max_replica_count is not set, the
     * default value is min_replica_count. The max allowed replica count is
     * 1000.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AutomaticResources automatic_resources = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeAutomaticResources(
        com.google.cloud.aiplatform.v1beta1.AutomaticResources value) {
      if (automaticResourcesBuilder_ == null) {
        if (automaticResources_ != null) {
          automaticResources_ =
              com.google.cloud.aiplatform.v1beta1.AutomaticResources.newBuilder(automaticResources_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          automaticResources_ = value;
        }
        onChanged();
      } else {
        automaticResourcesBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A description of resources that the DeployedIndex uses, which to large
     * degree are decided by Vertex AI, and optionally allows only a modest
     * additional configuration.
     * If min_replica_count is not set, the default value is 2 (we don't provide
     * SLA when min_replica_count=1). If max_replica_count is not set, the
     * default value is min_replica_count. The max allowed replica count is
     * 1000.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AutomaticResources automatic_resources = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAutomaticResources() {
      if (automaticResourcesBuilder_ == null) {
        automaticResources_ = null;
        onChanged();
      } else {
        automaticResources_ = null;
        automaticResourcesBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A description of resources that the DeployedIndex uses, which to large
     * degree are decided by Vertex AI, and optionally allows only a modest
     * additional configuration.
     * If min_replica_count is not set, the default value is 2 (we don't provide
     * SLA when min_replica_count=1). If max_replica_count is not set, the
     * default value is min_replica_count. The max allowed replica count is
     * 1000.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AutomaticResources automatic_resources = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.AutomaticResources.Builder
        getAutomaticResourcesBuilder() {

      onChanged();
      return getAutomaticResourcesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. A description of resources that the DeployedIndex uses, which to large
     * degree are decided by Vertex AI, and optionally allows only a modest
     * additional configuration.
     * If min_replica_count is not set, the default value is 2 (we don't provide
     * SLA when min_replica_count=1). If max_replica_count is not set, the
     * default value is min_replica_count. The max allowed replica count is
     * 1000.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AutomaticResources automatic_resources = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.AutomaticResourcesOrBuilder
        getAutomaticResourcesOrBuilder() {
      if (automaticResourcesBuilder_ != null) {
        return automaticResourcesBuilder_.getMessageOrBuilder();
      } else {
        return automaticResources_ == null
            ? com.google.cloud.aiplatform.v1beta1.AutomaticResources.getDefaultInstance()
            : automaticResources_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A description of resources that the DeployedIndex uses, which to large
     * degree are decided by Vertex AI, and optionally allows only a modest
     * additional configuration.
     * If min_replica_count is not set, the default value is 2 (we don't provide
     * SLA when min_replica_count=1). If max_replica_count is not set, the
     * default value is min_replica_count. The max allowed replica count is
     * 1000.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AutomaticResources automatic_resources = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.AutomaticResources,
            com.google.cloud.aiplatform.v1beta1.AutomaticResources.Builder,
            com.google.cloud.aiplatform.v1beta1.AutomaticResourcesOrBuilder>
        getAutomaticResourcesFieldBuilder() {
      if (automaticResourcesBuilder_ == null) {
        automaticResourcesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.AutomaticResources,
                com.google.cloud.aiplatform.v1beta1.AutomaticResources.Builder,
                com.google.cloud.aiplatform.v1beta1.AutomaticResourcesOrBuilder>(
                getAutomaticResources(), getParentForChildren(), isClean());
        automaticResources_ = null;
      }
      return automaticResourcesBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.DedicatedResources dedicatedResources_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.DedicatedResources,
            com.google.cloud.aiplatform.v1beta1.DedicatedResources.Builder,
            com.google.cloud.aiplatform.v1beta1.DedicatedResourcesOrBuilder>
        dedicatedResourcesBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. A description of resources that are dedicated to the DeployedIndex, and
     * that need a higher degree of manual configuration.
     * If min_replica_count is not set, the default value is 2 (we don't provide
     * SLA when min_replica_count=1). If max_replica_count is not set, the
     * default value is min_replica_count. The max allowed replica count is
     * 1000.
     * Available machine types:
     * n1-standard-16
     * n1-standard-32
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the dedicatedResources field is set.
     */
    public boolean hasDedicatedResources() {
      return dedicatedResourcesBuilder_ != null || dedicatedResources_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. A description of resources that are dedicated to the DeployedIndex, and
     * that need a higher degree of manual configuration.
     * If min_replica_count is not set, the default value is 2 (we don't provide
     * SLA when min_replica_count=1). If max_replica_count is not set, the
     * default value is min_replica_count. The max allowed replica count is
     * 1000.
     * Available machine types:
     * n1-standard-16
     * n1-standard-32
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The dedicatedResources.
     */
    public com.google.cloud.aiplatform.v1beta1.DedicatedResources getDedicatedResources() {
      if (dedicatedResourcesBuilder_ == null) {
        return dedicatedResources_ == null
            ? com.google.cloud.aiplatform.v1beta1.DedicatedResources.getDefaultInstance()
            : dedicatedResources_;
      } else {
        return dedicatedResourcesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A description of resources that are dedicated to the DeployedIndex, and
     * that need a higher degree of manual configuration.
     * If min_replica_count is not set, the default value is 2 (we don't provide
     * SLA when min_replica_count=1). If max_replica_count is not set, the
     * default value is min_replica_count. The max allowed replica count is
     * 1000.
     * Available machine types:
     * n1-standard-16
     * n1-standard-32
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDedicatedResources(
        com.google.cloud.aiplatform.v1beta1.DedicatedResources value) {
      if (dedicatedResourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dedicatedResources_ = value;
        onChanged();
      } else {
        dedicatedResourcesBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A description of resources that are dedicated to the DeployedIndex, and
     * that need a higher degree of manual configuration.
     * If min_replica_count is not set, the default value is 2 (we don't provide
     * SLA when min_replica_count=1). If max_replica_count is not set, the
     * default value is min_replica_count. The max allowed replica count is
     * 1000.
     * Available machine types:
     * n1-standard-16
     * n1-standard-32
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDedicatedResources(
        com.google.cloud.aiplatform.v1beta1.DedicatedResources.Builder builderForValue) {
      if (dedicatedResourcesBuilder_ == null) {
        dedicatedResources_ = builderForValue.build();
        onChanged();
      } else {
        dedicatedResourcesBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A description of resources that are dedicated to the DeployedIndex, and
     * that need a higher degree of manual configuration.
     * If min_replica_count is not set, the default value is 2 (we don't provide
     * SLA when min_replica_count=1). If max_replica_count is not set, the
     * default value is min_replica_count. The max allowed replica count is
     * 1000.
     * Available machine types:
     * n1-standard-16
     * n1-standard-32
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeDedicatedResources(
        com.google.cloud.aiplatform.v1beta1.DedicatedResources value) {
      if (dedicatedResourcesBuilder_ == null) {
        if (dedicatedResources_ != null) {
          dedicatedResources_ =
              com.google.cloud.aiplatform.v1beta1.DedicatedResources.newBuilder(dedicatedResources_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          dedicatedResources_ = value;
        }
        onChanged();
      } else {
        dedicatedResourcesBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A description of resources that are dedicated to the DeployedIndex, and
     * that need a higher degree of manual configuration.
     * If min_replica_count is not set, the default value is 2 (we don't provide
     * SLA when min_replica_count=1). If max_replica_count is not set, the
     * default value is min_replica_count. The max allowed replica count is
     * 1000.
     * Available machine types:
     * n1-standard-16
     * n1-standard-32
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearDedicatedResources() {
      if (dedicatedResourcesBuilder_ == null) {
        dedicatedResources_ = null;
        onChanged();
      } else {
        dedicatedResources_ = null;
        dedicatedResourcesBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A description of resources that are dedicated to the DeployedIndex, and
     * that need a higher degree of manual configuration.
     * If min_replica_count is not set, the default value is 2 (we don't provide
     * SLA when min_replica_count=1). If max_replica_count is not set, the
     * default value is min_replica_count. The max allowed replica count is
     * 1000.
     * Available machine types:
     * n1-standard-16
     * n1-standard-32
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.DedicatedResources.Builder
        getDedicatedResourcesBuilder() {

      onChanged();
      return getDedicatedResourcesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. A description of resources that are dedicated to the DeployedIndex, and
     * that need a higher degree of manual configuration.
     * If min_replica_count is not set, the default value is 2 (we don't provide
     * SLA when min_replica_count=1). If max_replica_count is not set, the
     * default value is min_replica_count. The max allowed replica count is
     * 1000.
     * Available machine types:
     * n1-standard-16
     * n1-standard-32
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.DedicatedResourcesOrBuilder
        getDedicatedResourcesOrBuilder() {
      if (dedicatedResourcesBuilder_ != null) {
        return dedicatedResourcesBuilder_.getMessageOrBuilder();
      } else {
        return dedicatedResources_ == null
            ? com.google.cloud.aiplatform.v1beta1.DedicatedResources.getDefaultInstance()
            : dedicatedResources_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A description of resources that are dedicated to the DeployedIndex, and
     * that need a higher degree of manual configuration.
     * If min_replica_count is not set, the default value is 2 (we don't provide
     * SLA when min_replica_count=1). If max_replica_count is not set, the
     * default value is min_replica_count. The max allowed replica count is
     * 1000.
     * Available machine types:
     * n1-standard-16
     * n1-standard-32
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.DedicatedResources,
            com.google.cloud.aiplatform.v1beta1.DedicatedResources.Builder,
            com.google.cloud.aiplatform.v1beta1.DedicatedResourcesOrBuilder>
        getDedicatedResourcesFieldBuilder() {
      if (dedicatedResourcesBuilder_ == null) {
        dedicatedResourcesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.DedicatedResources,
                com.google.cloud.aiplatform.v1beta1.DedicatedResources.Builder,
                com.google.cloud.aiplatform.v1beta1.DedicatedResourcesOrBuilder>(
                getDedicatedResources(), getParentForChildren(), isClean());
        dedicatedResources_ = null;
      }
      return dedicatedResourcesBuilder_;
    }

    private boolean enableAccessLogging_;
    /**
     *
     *
     * <pre>
     * Optional. If true, private endpoint's access logs are sent to StackDriver Logging.
     * These logs are like standard server access logs, containing
     * information like timestamp and latency for each MatchRequest.
     * Note that Stackdriver logs may incur a cost, especially if the deployed
     * index receives a high queries per second rate (QPS).
     * Estimate your costs before enabling this option.
     * </pre>
     *
     * <code>bool enable_access_logging = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The enableAccessLogging.
     */
    @java.lang.Override
    public boolean getEnableAccessLogging() {
      return enableAccessLogging_;
    }
    /**
     *
     *
     * <pre>
     * Optional. If true, private endpoint's access logs are sent to StackDriver Logging.
     * These logs are like standard server access logs, containing
     * information like timestamp and latency for each MatchRequest.
     * Note that Stackdriver logs may incur a cost, especially if the deployed
     * index receives a high queries per second rate (QPS).
     * Estimate your costs before enabling this option.
     * </pre>
     *
     * <code>bool enable_access_logging = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The enableAccessLogging to set.
     * @return This builder for chaining.
     */
    public Builder setEnableAccessLogging(boolean value) {

      enableAccessLogging_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If true, private endpoint's access logs are sent to StackDriver Logging.
     * These logs are like standard server access logs, containing
     * information like timestamp and latency for each MatchRequest.
     * Note that Stackdriver logs may incur a cost, especially if the deployed
     * index receives a high queries per second rate (QPS).
     * Estimate your costs before enabling this option.
     * </pre>
     *
     * <code>bool enable_access_logging = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableAccessLogging() {

      enableAccessLogging_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.DeployedIndexAuthConfig deployedIndexAuthConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.DeployedIndexAuthConfig,
            com.google.cloud.aiplatform.v1beta1.DeployedIndexAuthConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.DeployedIndexAuthConfigOrBuilder>
        deployedIndexAuthConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. If set, the authentication is enabled for the private endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DeployedIndexAuthConfig deployed_index_auth_config = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the deployedIndexAuthConfig field is set.
     */
    public boolean hasDeployedIndexAuthConfig() {
      return deployedIndexAuthConfigBuilder_ != null || deployedIndexAuthConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. If set, the authentication is enabled for the private endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DeployedIndexAuthConfig deployed_index_auth_config = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The deployedIndexAuthConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.DeployedIndexAuthConfig
        getDeployedIndexAuthConfig() {
      if (deployedIndexAuthConfigBuilder_ == null) {
        return deployedIndexAuthConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.DeployedIndexAuthConfig.getDefaultInstance()
            : deployedIndexAuthConfig_;
      } else {
        return deployedIndexAuthConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. If set, the authentication is enabled for the private endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DeployedIndexAuthConfig deployed_index_auth_config = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDeployedIndexAuthConfig(
        com.google.cloud.aiplatform.v1beta1.DeployedIndexAuthConfig value) {
      if (deployedIndexAuthConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deployedIndexAuthConfig_ = value;
        onChanged();
      } else {
        deployedIndexAuthConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If set, the authentication is enabled for the private endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DeployedIndexAuthConfig deployed_index_auth_config = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDeployedIndexAuthConfig(
        com.google.cloud.aiplatform.v1beta1.DeployedIndexAuthConfig.Builder builderForValue) {
      if (deployedIndexAuthConfigBuilder_ == null) {
        deployedIndexAuthConfig_ = builderForValue.build();
        onChanged();
      } else {
        deployedIndexAuthConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If set, the authentication is enabled for the private endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DeployedIndexAuthConfig deployed_index_auth_config = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeDeployedIndexAuthConfig(
        com.google.cloud.aiplatform.v1beta1.DeployedIndexAuthConfig value) {
      if (deployedIndexAuthConfigBuilder_ == null) {
        if (deployedIndexAuthConfig_ != null) {
          deployedIndexAuthConfig_ =
              com.google.cloud.aiplatform.v1beta1.DeployedIndexAuthConfig.newBuilder(
                      deployedIndexAuthConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          deployedIndexAuthConfig_ = value;
        }
        onChanged();
      } else {
        deployedIndexAuthConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If set, the authentication is enabled for the private endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DeployedIndexAuthConfig deployed_index_auth_config = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearDeployedIndexAuthConfig() {
      if (deployedIndexAuthConfigBuilder_ == null) {
        deployedIndexAuthConfig_ = null;
        onChanged();
      } else {
        deployedIndexAuthConfig_ = null;
        deployedIndexAuthConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If set, the authentication is enabled for the private endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DeployedIndexAuthConfig deployed_index_auth_config = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.DeployedIndexAuthConfig.Builder
        getDeployedIndexAuthConfigBuilder() {

      onChanged();
      return getDeployedIndexAuthConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. If set, the authentication is enabled for the private endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DeployedIndexAuthConfig deployed_index_auth_config = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.DeployedIndexAuthConfigOrBuilder
        getDeployedIndexAuthConfigOrBuilder() {
      if (deployedIndexAuthConfigBuilder_ != null) {
        return deployedIndexAuthConfigBuilder_.getMessageOrBuilder();
      } else {
        return deployedIndexAuthConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.DeployedIndexAuthConfig.getDefaultInstance()
            : deployedIndexAuthConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. If set, the authentication is enabled for the private endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DeployedIndexAuthConfig deployed_index_auth_config = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.DeployedIndexAuthConfig,
            com.google.cloud.aiplatform.v1beta1.DeployedIndexAuthConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.DeployedIndexAuthConfigOrBuilder>
        getDeployedIndexAuthConfigFieldBuilder() {
      if (deployedIndexAuthConfigBuilder_ == null) {
        deployedIndexAuthConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.DeployedIndexAuthConfig,
                com.google.cloud.aiplatform.v1beta1.DeployedIndexAuthConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.DeployedIndexAuthConfigOrBuilder>(
                getDeployedIndexAuthConfig(), getParentForChildren(), isClean());
        deployedIndexAuthConfig_ = null;
      }
      return deployedIndexAuthConfigBuilder_;
    }

    private com.google.protobuf.LazyStringList reservedIpRanges_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureReservedIpRangesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        reservedIpRanges_ = new com.google.protobuf.LazyStringArrayList(reservedIpRanges_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of reserved ip ranges under the VPC network that can be
     * used for this DeployedIndex.
     * If set, we will deploy the index within the provided ip ranges. Otherwise,
     * the index might be deployed to any ip ranges under the provided VPC
     * network.
     * The value sohuld be the name of the address
     * (https://cloud.google.com/compute/docs/reference/rest/v1/addresses)
     * Example: 'vertex-ai-ip-range'.
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the reservedIpRanges.
     */
    public com.google.protobuf.ProtocolStringList getReservedIpRangesList() {
      return reservedIpRanges_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of reserved ip ranges under the VPC network that can be
     * used for this DeployedIndex.
     * If set, we will deploy the index within the provided ip ranges. Otherwise,
     * the index might be deployed to any ip ranges under the provided VPC
     * network.
     * The value sohuld be the name of the address
     * (https://cloud.google.com/compute/docs/reference/rest/v1/addresses)
     * Example: 'vertex-ai-ip-range'.
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of reservedIpRanges.
     */
    public int getReservedIpRangesCount() {
      return reservedIpRanges_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of reserved ip ranges under the VPC network that can be
     * used for this DeployedIndex.
     * If set, we will deploy the index within the provided ip ranges. Otherwise,
     * the index might be deployed to any ip ranges under the provided VPC
     * network.
     * The value sohuld be the name of the address
     * (https://cloud.google.com/compute/docs/reference/rest/v1/addresses)
     * Example: 'vertex-ai-ip-range'.
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The reservedIpRanges at the given index.
     */
    public java.lang.String getReservedIpRanges(int index) {
      return reservedIpRanges_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of reserved ip ranges under the VPC network that can be
     * used for this DeployedIndex.
     * If set, we will deploy the index within the provided ip ranges. Otherwise,
     * the index might be deployed to any ip ranges under the provided VPC
     * network.
     * The value sohuld be the name of the address
     * (https://cloud.google.com/compute/docs/reference/rest/v1/addresses)
     * Example: 'vertex-ai-ip-range'.
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the reservedIpRanges at the given index.
     */
    public com.google.protobuf.ByteString getReservedIpRangesBytes(int index) {
      return reservedIpRanges_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of reserved ip ranges under the VPC network that can be
     * used for this DeployedIndex.
     * If set, we will deploy the index within the provided ip ranges. Otherwise,
     * the index might be deployed to any ip ranges under the provided VPC
     * network.
     * The value sohuld be the name of the address
     * (https://cloud.google.com/compute/docs/reference/rest/v1/addresses)
     * Example: 'vertex-ai-ip-range'.
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The reservedIpRanges to set.
     * @return This builder for chaining.
     */
    public Builder setReservedIpRanges(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureReservedIpRangesIsMutable();
      reservedIpRanges_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of reserved ip ranges under the VPC network that can be
     * used for this DeployedIndex.
     * If set, we will deploy the index within the provided ip ranges. Otherwise,
     * the index might be deployed to any ip ranges under the provided VPC
     * network.
     * The value sohuld be the name of the address
     * (https://cloud.google.com/compute/docs/reference/rest/v1/addresses)
     * Example: 'vertex-ai-ip-range'.
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The reservedIpRanges to add.
     * @return This builder for chaining.
     */
    public Builder addReservedIpRanges(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureReservedIpRangesIsMutable();
      reservedIpRanges_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of reserved ip ranges under the VPC network that can be
     * used for this DeployedIndex.
     * If set, we will deploy the index within the provided ip ranges. Otherwise,
     * the index might be deployed to any ip ranges under the provided VPC
     * network.
     * The value sohuld be the name of the address
     * (https://cloud.google.com/compute/docs/reference/rest/v1/addresses)
     * Example: 'vertex-ai-ip-range'.
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The reservedIpRanges to add.
     * @return This builder for chaining.
     */
    public Builder addAllReservedIpRanges(java.lang.Iterable<java.lang.String> values) {
      ensureReservedIpRangesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, reservedIpRanges_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of reserved ip ranges under the VPC network that can be
     * used for this DeployedIndex.
     * If set, we will deploy the index within the provided ip ranges. Otherwise,
     * the index might be deployed to any ip ranges under the provided VPC
     * network.
     * The value sohuld be the name of the address
     * (https://cloud.google.com/compute/docs/reference/rest/v1/addresses)
     * Example: 'vertex-ai-ip-range'.
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReservedIpRanges() {
      reservedIpRanges_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of reserved ip ranges under the VPC network that can be
     * used for this DeployedIndex.
     * If set, we will deploy the index within the provided ip ranges. Otherwise,
     * the index might be deployed to any ip ranges under the provided VPC
     * network.
     * The value sohuld be the name of the address
     * (https://cloud.google.com/compute/docs/reference/rest/v1/addresses)
     * Example: 'vertex-ai-ip-range'.
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The bytes of the reservedIpRanges to add.
     * @return This builder for chaining.
     */
    public Builder addReservedIpRangesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureReservedIpRangesIsMutable();
      reservedIpRanges_.add(value);
      onChanged();
      return this;
    }

    private java.lang.Object deploymentGroup_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The deployment group can be no longer than 64 characters (eg:
     * 'test', 'prod'). If not set, we will use the 'default' deployment group.
     * Creating `deployment_groups` with `reserved_ip_ranges` is a recommended
     * practice when the peered network has multiple peering ranges. This creates
     * your deployments from predictable IP spaces for easier traffic
     * administration. Also, one deployment_group (except 'default') can only be
     * used with the same reserved_ip_ranges which means if the deployment_group
     * has been used with reserved_ip_ranges: [a, b, c], using it with [a, b] or
     * [d, e] is disallowed.
     * Note: we only support up to 5 deployment groups(not including 'default').
     * </pre>
     *
     * <code>string deployment_group = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The deploymentGroup.
     */
    public java.lang.String getDeploymentGroup() {
      java.lang.Object ref = deploymentGroup_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        deploymentGroup_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The deployment group can be no longer than 64 characters (eg:
     * 'test', 'prod'). If not set, we will use the 'default' deployment group.
     * Creating `deployment_groups` with `reserved_ip_ranges` is a recommended
     * practice when the peered network has multiple peering ranges. This creates
     * your deployments from predictable IP spaces for easier traffic
     * administration. Also, one deployment_group (except 'default') can only be
     * used with the same reserved_ip_ranges which means if the deployment_group
     * has been used with reserved_ip_ranges: [a, b, c], using it with [a, b] or
     * [d, e] is disallowed.
     * Note: we only support up to 5 deployment groups(not including 'default').
     * </pre>
     *
     * <code>string deployment_group = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for deploymentGroup.
     */
    public com.google.protobuf.ByteString getDeploymentGroupBytes() {
      java.lang.Object ref = deploymentGroup_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        deploymentGroup_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The deployment group can be no longer than 64 characters (eg:
     * 'test', 'prod'). If not set, we will use the 'default' deployment group.
     * Creating `deployment_groups` with `reserved_ip_ranges` is a recommended
     * practice when the peered network has multiple peering ranges. This creates
     * your deployments from predictable IP spaces for easier traffic
     * administration. Also, one deployment_group (except 'default') can only be
     * used with the same reserved_ip_ranges which means if the deployment_group
     * has been used with reserved_ip_ranges: [a, b, c], using it with [a, b] or
     * [d, e] is disallowed.
     * Note: we only support up to 5 deployment groups(not including 'default').
     * </pre>
     *
     * <code>string deployment_group = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The deploymentGroup to set.
     * @return This builder for chaining.
     */
    public Builder setDeploymentGroup(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      deploymentGroup_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The deployment group can be no longer than 64 characters (eg:
     * 'test', 'prod'). If not set, we will use the 'default' deployment group.
     * Creating `deployment_groups` with `reserved_ip_ranges` is a recommended
     * practice when the peered network has multiple peering ranges. This creates
     * your deployments from predictable IP spaces for easier traffic
     * administration. Also, one deployment_group (except 'default') can only be
     * used with the same reserved_ip_ranges which means if the deployment_group
     * has been used with reserved_ip_ranges: [a, b, c], using it with [a, b] or
     * [d, e] is disallowed.
     * Note: we only support up to 5 deployment groups(not including 'default').
     * </pre>
     *
     * <code>string deployment_group = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDeploymentGroup() {

      deploymentGroup_ = getDefaultInstance().getDeploymentGroup();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The deployment group can be no longer than 64 characters (eg:
     * 'test', 'prod'). If not set, we will use the 'default' deployment group.
     * Creating `deployment_groups` with `reserved_ip_ranges` is a recommended
     * practice when the peered network has multiple peering ranges. This creates
     * your deployments from predictable IP spaces for easier traffic
     * administration. Also, one deployment_group (except 'default') can only be
     * used with the same reserved_ip_ranges which means if the deployment_group
     * has been used with reserved_ip_ranges: [a, b, c], using it with [a, b] or
     * [d, e] is disallowed.
     * Note: we only support up to 5 deployment groups(not including 'default').
     * </pre>
     *
     * <code>string deployment_group = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for deploymentGroup to set.
     * @return This builder for chaining.
     */
    public Builder setDeploymentGroupBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      deploymentGroup_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.DeployedIndex)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.DeployedIndex)
  private static final com.google.cloud.aiplatform.v1beta1.DeployedIndex DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.DeployedIndex();
  }

  public static com.google.cloud.aiplatform.v1beta1.DeployedIndex getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DeployedIndex> PARSER =
      new com.google.protobuf.AbstractParser<DeployedIndex>() {
        @java.lang.Override
        public DeployedIndex parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new DeployedIndex(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<DeployedIndex> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DeployedIndex> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.DeployedIndex getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
