/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/custom_job.proto

package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Represents the spec of a CustomJob.
 * Next Id: 14
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.CustomJobSpec}
 */
public final class CustomJobSpec extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.CustomJobSpec)
    CustomJobSpecOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CustomJobSpec.newBuilder() to construct.
  private CustomJobSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CustomJobSpec() {
    workerPoolSpecs_ = java.util.Collections.emptyList();
    serviceAccount_ = "";
    network_ = "";
    reservedIpRanges_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    tensorboard_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CustomJobSpec();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private CustomJobSpec(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                workerPoolSpecs_ =
                    new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec>();
                mutable_bitField0_ |= 0x00000001;
              }
              workerPoolSpecs_.add(
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec.parser(),
                      extensionRegistry));
              break;
            }
          case 26:
            {
              com.google.cloud.aiplatform.v1beta1.Scheduling.Builder subBuilder = null;
              if (scheduling_ != null) {
                subBuilder = scheduling_.toBuilder();
              }
              scheduling_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.Scheduling.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(scheduling_);
                scheduling_ = subBuilder.buildPartial();
              }

              break;
            }
          case 34:
            {
              java.lang.String s = input.readStringRequireUtf8();

              serviceAccount_ = s;
              break;
            }
          case 42:
            {
              java.lang.String s = input.readStringRequireUtf8();

              network_ = s;
              break;
            }
          case 50:
            {
              com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder subBuilder = null;
              if (baseOutputDirectory_ != null) {
                subBuilder = baseOutputDirectory_.toBuilder();
              }
              baseOutputDirectory_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.GcsDestination.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(baseOutputDirectory_);
                baseOutputDirectory_ = subBuilder.buildPartial();
              }

              break;
            }
          case 58:
            {
              java.lang.String s = input.readStringRequireUtf8();

              tensorboard_ = s;
              break;
            }
          case 80:
            {
              enableWebAccess_ = input.readBool();
              break;
            }
          case 106:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                reservedIpRanges_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000002;
              }
              reservedIpRanges_.add(s);
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        workerPoolSpecs_ = java.util.Collections.unmodifiableList(workerPoolSpecs_);
      }
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        reservedIpRanges_ = reservedIpRanges_.getUnmodifiableView();
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.CustomJobProto
        .internal_static_google_cloud_aiplatform_v1beta1_CustomJobSpec_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.CustomJobProto
        .internal_static_google_cloud_aiplatform_v1beta1_CustomJobSpec_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.CustomJobSpec.class,
            com.google.cloud.aiplatform.v1beta1.CustomJobSpec.Builder.class);
  }

  public static final int WORKER_POOL_SPECS_FIELD_NUMBER = 1;
  private java.util.List<com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec> workerPoolSpecs_;
  /**
   *
   *
   * <pre>
   * Required. The spec of the worker pools including machine type and Docker image.
   * All worker pools except the first one are optional and can be skipped by
   * providing an empty value.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.WorkerPoolSpec worker_pool_specs = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec>
      getWorkerPoolSpecsList() {
    return workerPoolSpecs_;
  }
  /**
   *
   *
   * <pre>
   * Required. The spec of the worker pools including machine type and Docker image.
   * All worker pools except the first one are optional and can be skipped by
   * providing an empty value.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.WorkerPoolSpec worker_pool_specs = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.WorkerPoolSpecOrBuilder>
      getWorkerPoolSpecsOrBuilderList() {
    return workerPoolSpecs_;
  }
  /**
   *
   *
   * <pre>
   * Required. The spec of the worker pools including machine type and Docker image.
   * All worker pools except the first one are optional and can be skipped by
   * providing an empty value.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.WorkerPoolSpec worker_pool_specs = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getWorkerPoolSpecsCount() {
    return workerPoolSpecs_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. The spec of the worker pools including machine type and Docker image.
   * All worker pools except the first one are optional and can be skipped by
   * providing an empty value.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.WorkerPoolSpec worker_pool_specs = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec getWorkerPoolSpecs(int index) {
    return workerPoolSpecs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. The spec of the worker pools including machine type and Docker image.
   * All worker pools except the first one are optional and can be skipped by
   * providing an empty value.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.WorkerPoolSpec worker_pool_specs = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.WorkerPoolSpecOrBuilder getWorkerPoolSpecsOrBuilder(
      int index) {
    return workerPoolSpecs_.get(index);
  }

  public static final int SCHEDULING_FIELD_NUMBER = 3;
  private com.google.cloud.aiplatform.v1beta1.Scheduling scheduling_;
  /**
   *
   *
   * <pre>
   * Scheduling options for a CustomJob.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.Scheduling scheduling = 3;</code>
   *
   * @return Whether the scheduling field is set.
   */
  @java.lang.Override
  public boolean hasScheduling() {
    return scheduling_ != null;
  }
  /**
   *
   *
   * <pre>
   * Scheduling options for a CustomJob.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.Scheduling scheduling = 3;</code>
   *
   * @return The scheduling.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Scheduling getScheduling() {
    return scheduling_ == null
        ? com.google.cloud.aiplatform.v1beta1.Scheduling.getDefaultInstance()
        : scheduling_;
  }
  /**
   *
   *
   * <pre>
   * Scheduling options for a CustomJob.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.Scheduling scheduling = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SchedulingOrBuilder getSchedulingOrBuilder() {
    return getScheduling();
  }

  public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 4;
  private volatile java.lang.Object serviceAccount_;
  /**
   *
   *
   * <pre>
   * Specifies the service account for workload run-as account.
   * Users submitting jobs must have act-as permission on this run-as account.
   * If unspecified, the [Vertex AI Custom Code Service
   * Agent](https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
   * for the CustomJob's project is used.
   * </pre>
   *
   * <code>string service_account = 4;</code>
   *
   * @return The serviceAccount.
   */
  @java.lang.Override
  public java.lang.String getServiceAccount() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccount_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Specifies the service account for workload run-as account.
   * Users submitting jobs must have act-as permission on this run-as account.
   * If unspecified, the [Vertex AI Custom Code Service
   * Agent](https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
   * for the CustomJob's project is used.
   * </pre>
   *
   * <code>string service_account = 4;</code>
   *
   * @return The bytes for serviceAccount.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceAccountBytes() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccount_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NETWORK_FIELD_NUMBER = 5;
  private volatile java.lang.Object network_;
  /**
   *
   *
   * <pre>
   * The full name of the Compute Engine
   * [network](/compute/docs/networks-and-firewalls#networks) to which the Job
   * should be peered. For example, `projects/12345/global/networks/myVPC`.
   * [Format](/compute/docs/reference/rest/v1/networks/insert)
   * is of the form `projects/{project}/global/networks/{network}`.
   * Where {project} is a project number, as in `12345`, and {network} is a
   * network name.
   * To specify this field, you must have already [configured VPC Network
   * Peering for Vertex
   * AI](https://cloud.google.com/vertex-ai/docs/general/vpc-peering).
   * If this field is left unspecified, the job is not peered with any network.
   * </pre>
   *
   * <code>string network = 5 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The network.
   */
  @java.lang.Override
  public java.lang.String getNetwork() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      network_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The full name of the Compute Engine
   * [network](/compute/docs/networks-and-firewalls#networks) to which the Job
   * should be peered. For example, `projects/12345/global/networks/myVPC`.
   * [Format](/compute/docs/reference/rest/v1/networks/insert)
   * is of the form `projects/{project}/global/networks/{network}`.
   * Where {project} is a project number, as in `12345`, and {network} is a
   * network name.
   * To specify this field, you must have already [configured VPC Network
   * Peering for Vertex
   * AI](https://cloud.google.com/vertex-ai/docs/general/vpc-peering).
   * If this field is left unspecified, the job is not peered with any network.
   * </pre>
   *
   * <code>string network = 5 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for network.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNetworkBytes() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      network_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESERVED_IP_RANGES_FIELD_NUMBER = 13;
  private com.google.protobuf.LazyStringList reservedIpRanges_;
  /**
   *
   *
   * <pre>
   * Optional. A list of names for the reserved ip ranges under the VPC network
   * that can be used for this job.
   * If set, we will deploy the job within the provided ip ranges. Otherwise,
   * the job will be deployed to any ip ranges under the provided VPC
   * network.
   * Example: ['vertex-ai-ip-range'].
   * </pre>
   *
   * <code>repeated string reserved_ip_ranges = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the reservedIpRanges.
   */
  public com.google.protobuf.ProtocolStringList getReservedIpRangesList() {
    return reservedIpRanges_;
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of names for the reserved ip ranges under the VPC network
   * that can be used for this job.
   * If set, we will deploy the job within the provided ip ranges. Otherwise,
   * the job will be deployed to any ip ranges under the provided VPC
   * network.
   * Example: ['vertex-ai-ip-range'].
   * </pre>
   *
   * <code>repeated string reserved_ip_ranges = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of reservedIpRanges.
   */
  public int getReservedIpRangesCount() {
    return reservedIpRanges_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of names for the reserved ip ranges under the VPC network
   * that can be used for this job.
   * If set, we will deploy the job within the provided ip ranges. Otherwise,
   * the job will be deployed to any ip ranges under the provided VPC
   * network.
   * Example: ['vertex-ai-ip-range'].
   * </pre>
   *
   * <code>repeated string reserved_ip_ranges = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The reservedIpRanges at the given index.
   */
  public java.lang.String getReservedIpRanges(int index) {
    return reservedIpRanges_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of names for the reserved ip ranges under the VPC network
   * that can be used for this job.
   * If set, we will deploy the job within the provided ip ranges. Otherwise,
   * the job will be deployed to any ip ranges under the provided VPC
   * network.
   * Example: ['vertex-ai-ip-range'].
   * </pre>
   *
   * <code>repeated string reserved_ip_ranges = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the reservedIpRanges at the given index.
   */
  public com.google.protobuf.ByteString getReservedIpRangesBytes(int index) {
    return reservedIpRanges_.getByteString(index);
  }

  public static final int BASE_OUTPUT_DIRECTORY_FIELD_NUMBER = 6;
  private com.google.cloud.aiplatform.v1beta1.GcsDestination baseOutputDirectory_;
  /**
   *
   *
   * <pre>
   * The Cloud Storage location to store the output of this CustomJob or
   * HyperparameterTuningJob. For HyperparameterTuningJob,
   * the baseOutputDirectory of
   * each child CustomJob backing a Trial is set to a subdirectory of name
   * [id][google.cloud.aiplatform.v1beta1.Trial.id] under its parent HyperparameterTuningJob's
   * baseOutputDirectory.
   * The following Vertex AI environment variables will be passed to
   * containers or python modules when this field is set:
   *   For CustomJob:
   *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/model/`
   *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/checkpoints/`
   *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/logs/`
   *   For CustomJob backing a Trial of HyperparameterTuningJob:
   *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/model/`
   *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/checkpoints/`
   *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/logs/`
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GcsDestination base_output_directory = 6;</code>
   *
   * @return Whether the baseOutputDirectory field is set.
   */
  @java.lang.Override
  public boolean hasBaseOutputDirectory() {
    return baseOutputDirectory_ != null;
  }
  /**
   *
   *
   * <pre>
   * The Cloud Storage location to store the output of this CustomJob or
   * HyperparameterTuningJob. For HyperparameterTuningJob,
   * the baseOutputDirectory of
   * each child CustomJob backing a Trial is set to a subdirectory of name
   * [id][google.cloud.aiplatform.v1beta1.Trial.id] under its parent HyperparameterTuningJob's
   * baseOutputDirectory.
   * The following Vertex AI environment variables will be passed to
   * containers or python modules when this field is set:
   *   For CustomJob:
   *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/model/`
   *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/checkpoints/`
   *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/logs/`
   *   For CustomJob backing a Trial of HyperparameterTuningJob:
   *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/model/`
   *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/checkpoints/`
   *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/logs/`
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GcsDestination base_output_directory = 6;</code>
   *
   * @return The baseOutputDirectory.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GcsDestination getBaseOutputDirectory() {
    return baseOutputDirectory_ == null
        ? com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance()
        : baseOutputDirectory_;
  }
  /**
   *
   *
   * <pre>
   * The Cloud Storage location to store the output of this CustomJob or
   * HyperparameterTuningJob. For HyperparameterTuningJob,
   * the baseOutputDirectory of
   * each child CustomJob backing a Trial is set to a subdirectory of name
   * [id][google.cloud.aiplatform.v1beta1.Trial.id] under its parent HyperparameterTuningJob's
   * baseOutputDirectory.
   * The following Vertex AI environment variables will be passed to
   * containers or python modules when this field is set:
   *   For CustomJob:
   *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/model/`
   *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/checkpoints/`
   *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/logs/`
   *   For CustomJob backing a Trial of HyperparameterTuningJob:
   *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/model/`
   *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/checkpoints/`
   *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/logs/`
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GcsDestination base_output_directory = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder
      getBaseOutputDirectoryOrBuilder() {
    return getBaseOutputDirectory();
  }

  public static final int TENSORBOARD_FIELD_NUMBER = 7;
  private volatile java.lang.Object tensorboard_;
  /**
   *
   *
   * <pre>
   * Optional. The name of a Vertex AI [Tensorboard][google.cloud.aiplatform.v1beta1.Tensorboard] resource to which this CustomJob
   * will upload Tensorboard logs.
   * Format:
   * `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
   * </pre>
   *
   * <code>
   * string tensorboard = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The tensorboard.
   */
  @java.lang.Override
  public java.lang.String getTensorboard() {
    java.lang.Object ref = tensorboard_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      tensorboard_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The name of a Vertex AI [Tensorboard][google.cloud.aiplatform.v1beta1.Tensorboard] resource to which this CustomJob
   * will upload Tensorboard logs.
   * Format:
   * `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
   * </pre>
   *
   * <code>
   * string tensorboard = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for tensorboard.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTensorboardBytes() {
    java.lang.Object ref = tensorboard_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      tensorboard_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENABLE_WEB_ACCESS_FIELD_NUMBER = 10;
  private boolean enableWebAccess_;
  /**
   *
   *
   * <pre>
   * Optional. Whether you want Vertex AI to enable [interactive shell
   * access](https://cloud.google.com/vertex-ai/docs/training/monitor-debug-interactive-shell)
   * to training containers.
   * If set to `true`, you can access interactive shells at the URIs given
   * by [CustomJob.web_access_uris][google.cloud.aiplatform.v1beta1.CustomJob.web_access_uris] or [Trial.web_access_uris][google.cloud.aiplatform.v1beta1.Trial.web_access_uris] (within
   * [HyperparameterTuningJob.trials][google.cloud.aiplatform.v1beta1.HyperparameterTuningJob.trials]).
   * </pre>
   *
   * <code>bool enable_web_access = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The enableWebAccess.
   */
  @java.lang.Override
  public boolean getEnableWebAccess() {
    return enableWebAccess_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < workerPoolSpecs_.size(); i++) {
      output.writeMessage(1, workerPoolSpecs_.get(i));
    }
    if (scheduling_ != null) {
      output.writeMessage(3, getScheduling());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, serviceAccount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(network_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, network_);
    }
    if (baseOutputDirectory_ != null) {
      output.writeMessage(6, getBaseOutputDirectory());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tensorboard_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, tensorboard_);
    }
    if (enableWebAccess_ != false) {
      output.writeBool(10, enableWebAccess_);
    }
    for (int i = 0; i < reservedIpRanges_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, reservedIpRanges_.getRaw(i));
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < workerPoolSpecs_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, workerPoolSpecs_.get(i));
    }
    if (scheduling_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getScheduling());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, serviceAccount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(network_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, network_);
    }
    if (baseOutputDirectory_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getBaseOutputDirectory());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tensorboard_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, tensorboard_);
    }
    if (enableWebAccess_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(10, enableWebAccess_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < reservedIpRanges_.size(); i++) {
        dataSize += computeStringSizeNoTag(reservedIpRanges_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getReservedIpRangesList().size();
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.CustomJobSpec)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.CustomJobSpec other =
        (com.google.cloud.aiplatform.v1beta1.CustomJobSpec) obj;

    if (!getWorkerPoolSpecsList().equals(other.getWorkerPoolSpecsList())) return false;
    if (hasScheduling() != other.hasScheduling()) return false;
    if (hasScheduling()) {
      if (!getScheduling().equals(other.getScheduling())) return false;
    }
    if (!getServiceAccount().equals(other.getServiceAccount())) return false;
    if (!getNetwork().equals(other.getNetwork())) return false;
    if (!getReservedIpRangesList().equals(other.getReservedIpRangesList())) return false;
    if (hasBaseOutputDirectory() != other.hasBaseOutputDirectory()) return false;
    if (hasBaseOutputDirectory()) {
      if (!getBaseOutputDirectory().equals(other.getBaseOutputDirectory())) return false;
    }
    if (!getTensorboard().equals(other.getTensorboard())) return false;
    if (getEnableWebAccess() != other.getEnableWebAccess()) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getWorkerPoolSpecsCount() > 0) {
      hash = (37 * hash) + WORKER_POOL_SPECS_FIELD_NUMBER;
      hash = (53 * hash) + getWorkerPoolSpecsList().hashCode();
    }
    if (hasScheduling()) {
      hash = (37 * hash) + SCHEDULING_FIELD_NUMBER;
      hash = (53 * hash) + getScheduling().hashCode();
    }
    hash = (37 * hash) + SERVICE_ACCOUNT_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccount().hashCode();
    hash = (37 * hash) + NETWORK_FIELD_NUMBER;
    hash = (53 * hash) + getNetwork().hashCode();
    if (getReservedIpRangesCount() > 0) {
      hash = (37 * hash) + RESERVED_IP_RANGES_FIELD_NUMBER;
      hash = (53 * hash) + getReservedIpRangesList().hashCode();
    }
    if (hasBaseOutputDirectory()) {
      hash = (37 * hash) + BASE_OUTPUT_DIRECTORY_FIELD_NUMBER;
      hash = (53 * hash) + getBaseOutputDirectory().hashCode();
    }
    hash = (37 * hash) + TENSORBOARD_FIELD_NUMBER;
    hash = (53 * hash) + getTensorboard().hashCode();
    hash = (37 * hash) + ENABLE_WEB_ACCESS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableWebAccess());
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.CustomJobSpec parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.CustomJobSpec parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.CustomJobSpec parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.CustomJobSpec parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.CustomJobSpec parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.CustomJobSpec parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.CustomJobSpec parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.CustomJobSpec parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.CustomJobSpec parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.CustomJobSpec parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.CustomJobSpec parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.CustomJobSpec parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.CustomJobSpec prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents the spec of a CustomJob.
   * Next Id: 14
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.CustomJobSpec}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.CustomJobSpec)
      com.google.cloud.aiplatform.v1beta1.CustomJobSpecOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.CustomJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_CustomJobSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.CustomJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_CustomJobSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.CustomJobSpec.class,
              com.google.cloud.aiplatform.v1beta1.CustomJobSpec.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.CustomJobSpec.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getWorkerPoolSpecsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (workerPoolSpecsBuilder_ == null) {
        workerPoolSpecs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        workerPoolSpecsBuilder_.clear();
      }
      if (schedulingBuilder_ == null) {
        scheduling_ = null;
      } else {
        scheduling_ = null;
        schedulingBuilder_ = null;
      }
      serviceAccount_ = "";

      network_ = "";

      reservedIpRanges_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      if (baseOutputDirectoryBuilder_ == null) {
        baseOutputDirectory_ = null;
      } else {
        baseOutputDirectory_ = null;
        baseOutputDirectoryBuilder_ = null;
      }
      tensorboard_ = "";

      enableWebAccess_ = false;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.CustomJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_CustomJobSpec_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.CustomJobSpec getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.CustomJobSpec.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.CustomJobSpec build() {
      com.google.cloud.aiplatform.v1beta1.CustomJobSpec result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.CustomJobSpec buildPartial() {
      com.google.cloud.aiplatform.v1beta1.CustomJobSpec result =
          new com.google.cloud.aiplatform.v1beta1.CustomJobSpec(this);
      int from_bitField0_ = bitField0_;
      if (workerPoolSpecsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          workerPoolSpecs_ = java.util.Collections.unmodifiableList(workerPoolSpecs_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.workerPoolSpecs_ = workerPoolSpecs_;
      } else {
        result.workerPoolSpecs_ = workerPoolSpecsBuilder_.build();
      }
      if (schedulingBuilder_ == null) {
        result.scheduling_ = scheduling_;
      } else {
        result.scheduling_ = schedulingBuilder_.build();
      }
      result.serviceAccount_ = serviceAccount_;
      result.network_ = network_;
      if (((bitField0_ & 0x00000002) != 0)) {
        reservedIpRanges_ = reservedIpRanges_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.reservedIpRanges_ = reservedIpRanges_;
      if (baseOutputDirectoryBuilder_ == null) {
        result.baseOutputDirectory_ = baseOutputDirectory_;
      } else {
        result.baseOutputDirectory_ = baseOutputDirectoryBuilder_.build();
      }
      result.tensorboard_ = tensorboard_;
      result.enableWebAccess_ = enableWebAccess_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.CustomJobSpec) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.CustomJobSpec) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.CustomJobSpec other) {
      if (other == com.google.cloud.aiplatform.v1beta1.CustomJobSpec.getDefaultInstance())
        return this;
      if (workerPoolSpecsBuilder_ == null) {
        if (!other.workerPoolSpecs_.isEmpty()) {
          if (workerPoolSpecs_.isEmpty()) {
            workerPoolSpecs_ = other.workerPoolSpecs_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureWorkerPoolSpecsIsMutable();
            workerPoolSpecs_.addAll(other.workerPoolSpecs_);
          }
          onChanged();
        }
      } else {
        if (!other.workerPoolSpecs_.isEmpty()) {
          if (workerPoolSpecsBuilder_.isEmpty()) {
            workerPoolSpecsBuilder_.dispose();
            workerPoolSpecsBuilder_ = null;
            workerPoolSpecs_ = other.workerPoolSpecs_;
            bitField0_ = (bitField0_ & ~0x00000001);
            workerPoolSpecsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getWorkerPoolSpecsFieldBuilder()
                    : null;
          } else {
            workerPoolSpecsBuilder_.addAllMessages(other.workerPoolSpecs_);
          }
        }
      }
      if (other.hasScheduling()) {
        mergeScheduling(other.getScheduling());
      }
      if (!other.getServiceAccount().isEmpty()) {
        serviceAccount_ = other.serviceAccount_;
        onChanged();
      }
      if (!other.getNetwork().isEmpty()) {
        network_ = other.network_;
        onChanged();
      }
      if (!other.reservedIpRanges_.isEmpty()) {
        if (reservedIpRanges_.isEmpty()) {
          reservedIpRanges_ = other.reservedIpRanges_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensureReservedIpRangesIsMutable();
          reservedIpRanges_.addAll(other.reservedIpRanges_);
        }
        onChanged();
      }
      if (other.hasBaseOutputDirectory()) {
        mergeBaseOutputDirectory(other.getBaseOutputDirectory());
      }
      if (!other.getTensorboard().isEmpty()) {
        tensorboard_ = other.tensorboard_;
        onChanged();
      }
      if (other.getEnableWebAccess() != false) {
        setEnableWebAccess(other.getEnableWebAccess());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.aiplatform.v1beta1.CustomJobSpec parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.aiplatform.v1beta1.CustomJobSpec) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec> workerPoolSpecs_ =
        java.util.Collections.emptyList();

    private void ensureWorkerPoolSpecsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        workerPoolSpecs_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec>(
                workerPoolSpecs_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec,
            com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.WorkerPoolSpecOrBuilder>
        workerPoolSpecsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The spec of the worker pools including machine type and Docker image.
     * All worker pools except the first one are optional and can be skipped by
     * providing an empty value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.WorkerPoolSpec worker_pool_specs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec>
        getWorkerPoolSpecsList() {
      if (workerPoolSpecsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(workerPoolSpecs_);
      } else {
        return workerPoolSpecsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The spec of the worker pools including machine type and Docker image.
     * All worker pools except the first one are optional and can be skipped by
     * providing an empty value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.WorkerPoolSpec worker_pool_specs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getWorkerPoolSpecsCount() {
      if (workerPoolSpecsBuilder_ == null) {
        return workerPoolSpecs_.size();
      } else {
        return workerPoolSpecsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The spec of the worker pools including machine type and Docker image.
     * All worker pools except the first one are optional and can be skipped by
     * providing an empty value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.WorkerPoolSpec worker_pool_specs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec getWorkerPoolSpecs(int index) {
      if (workerPoolSpecsBuilder_ == null) {
        return workerPoolSpecs_.get(index);
      } else {
        return workerPoolSpecsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The spec of the worker pools including machine type and Docker image.
     * All worker pools except the first one are optional and can be skipped by
     * providing an empty value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.WorkerPoolSpec worker_pool_specs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setWorkerPoolSpecs(
        int index, com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec value) {
      if (workerPoolSpecsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWorkerPoolSpecsIsMutable();
        workerPoolSpecs_.set(index, value);
        onChanged();
      } else {
        workerPoolSpecsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The spec of the worker pools including machine type and Docker image.
     * All worker pools except the first one are optional and can be skipped by
     * providing an empty value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.WorkerPoolSpec worker_pool_specs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setWorkerPoolSpecs(
        int index, com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec.Builder builderForValue) {
      if (workerPoolSpecsBuilder_ == null) {
        ensureWorkerPoolSpecsIsMutable();
        workerPoolSpecs_.set(index, builderForValue.build());
        onChanged();
      } else {
        workerPoolSpecsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The spec of the worker pools including machine type and Docker image.
     * All worker pools except the first one are optional and can be skipped by
     * providing an empty value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.WorkerPoolSpec worker_pool_specs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addWorkerPoolSpecs(com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec value) {
      if (workerPoolSpecsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWorkerPoolSpecsIsMutable();
        workerPoolSpecs_.add(value);
        onChanged();
      } else {
        workerPoolSpecsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The spec of the worker pools including machine type and Docker image.
     * All worker pools except the first one are optional and can be skipped by
     * providing an empty value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.WorkerPoolSpec worker_pool_specs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addWorkerPoolSpecs(
        int index, com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec value) {
      if (workerPoolSpecsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWorkerPoolSpecsIsMutable();
        workerPoolSpecs_.add(index, value);
        onChanged();
      } else {
        workerPoolSpecsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The spec of the worker pools including machine type and Docker image.
     * All worker pools except the first one are optional and can be skipped by
     * providing an empty value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.WorkerPoolSpec worker_pool_specs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addWorkerPoolSpecs(
        com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec.Builder builderForValue) {
      if (workerPoolSpecsBuilder_ == null) {
        ensureWorkerPoolSpecsIsMutable();
        workerPoolSpecs_.add(builderForValue.build());
        onChanged();
      } else {
        workerPoolSpecsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The spec of the worker pools including machine type and Docker image.
     * All worker pools except the first one are optional and can be skipped by
     * providing an empty value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.WorkerPoolSpec worker_pool_specs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addWorkerPoolSpecs(
        int index, com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec.Builder builderForValue) {
      if (workerPoolSpecsBuilder_ == null) {
        ensureWorkerPoolSpecsIsMutable();
        workerPoolSpecs_.add(index, builderForValue.build());
        onChanged();
      } else {
        workerPoolSpecsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The spec of the worker pools including machine type and Docker image.
     * All worker pools except the first one are optional and can be skipped by
     * providing an empty value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.WorkerPoolSpec worker_pool_specs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllWorkerPoolSpecs(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec> values) {
      if (workerPoolSpecsBuilder_ == null) {
        ensureWorkerPoolSpecsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, workerPoolSpecs_);
        onChanged();
      } else {
        workerPoolSpecsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The spec of the worker pools including machine type and Docker image.
     * All worker pools except the first one are optional and can be skipped by
     * providing an empty value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.WorkerPoolSpec worker_pool_specs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearWorkerPoolSpecs() {
      if (workerPoolSpecsBuilder_ == null) {
        workerPoolSpecs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        workerPoolSpecsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The spec of the worker pools including machine type and Docker image.
     * All worker pools except the first one are optional and can be skipped by
     * providing an empty value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.WorkerPoolSpec worker_pool_specs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeWorkerPoolSpecs(int index) {
      if (workerPoolSpecsBuilder_ == null) {
        ensureWorkerPoolSpecsIsMutable();
        workerPoolSpecs_.remove(index);
        onChanged();
      } else {
        workerPoolSpecsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The spec of the worker pools including machine type and Docker image.
     * All worker pools except the first one are optional and can be skipped by
     * providing an empty value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.WorkerPoolSpec worker_pool_specs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec.Builder getWorkerPoolSpecsBuilder(
        int index) {
      return getWorkerPoolSpecsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The spec of the worker pools including machine type and Docker image.
     * All worker pools except the first one are optional and can be skipped by
     * providing an empty value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.WorkerPoolSpec worker_pool_specs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.WorkerPoolSpecOrBuilder getWorkerPoolSpecsOrBuilder(
        int index) {
      if (workerPoolSpecsBuilder_ == null) {
        return workerPoolSpecs_.get(index);
      } else {
        return workerPoolSpecsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The spec of the worker pools including machine type and Docker image.
     * All worker pools except the first one are optional and can be skipped by
     * providing an empty value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.WorkerPoolSpec worker_pool_specs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.WorkerPoolSpecOrBuilder>
        getWorkerPoolSpecsOrBuilderList() {
      if (workerPoolSpecsBuilder_ != null) {
        return workerPoolSpecsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(workerPoolSpecs_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The spec of the worker pools including machine type and Docker image.
     * All worker pools except the first one are optional and can be skipped by
     * providing an empty value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.WorkerPoolSpec worker_pool_specs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec.Builder addWorkerPoolSpecsBuilder() {
      return getWorkerPoolSpecsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The spec of the worker pools including machine type and Docker image.
     * All worker pools except the first one are optional and can be skipped by
     * providing an empty value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.WorkerPoolSpec worker_pool_specs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec.Builder addWorkerPoolSpecsBuilder(
        int index) {
      return getWorkerPoolSpecsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The spec of the worker pools including machine type and Docker image.
     * All worker pools except the first one are optional and can be skipped by
     * providing an empty value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.WorkerPoolSpec worker_pool_specs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec.Builder>
        getWorkerPoolSpecsBuilderList() {
      return getWorkerPoolSpecsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec,
            com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.WorkerPoolSpecOrBuilder>
        getWorkerPoolSpecsFieldBuilder() {
      if (workerPoolSpecsBuilder_ == null) {
        workerPoolSpecsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec,
                com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.WorkerPoolSpecOrBuilder>(
                workerPoolSpecs_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        workerPoolSpecs_ = null;
      }
      return workerPoolSpecsBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.Scheduling scheduling_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Scheduling,
            com.google.cloud.aiplatform.v1beta1.Scheduling.Builder,
            com.google.cloud.aiplatform.v1beta1.SchedulingOrBuilder>
        schedulingBuilder_;
    /**
     *
     *
     * <pre>
     * Scheduling options for a CustomJob.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Scheduling scheduling = 3;</code>
     *
     * @return Whether the scheduling field is set.
     */
    public boolean hasScheduling() {
      return schedulingBuilder_ != null || scheduling_ != null;
    }
    /**
     *
     *
     * <pre>
     * Scheduling options for a CustomJob.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Scheduling scheduling = 3;</code>
     *
     * @return The scheduling.
     */
    public com.google.cloud.aiplatform.v1beta1.Scheduling getScheduling() {
      if (schedulingBuilder_ == null) {
        return scheduling_ == null
            ? com.google.cloud.aiplatform.v1beta1.Scheduling.getDefaultInstance()
            : scheduling_;
      } else {
        return schedulingBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Scheduling options for a CustomJob.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Scheduling scheduling = 3;</code>
     */
    public Builder setScheduling(com.google.cloud.aiplatform.v1beta1.Scheduling value) {
      if (schedulingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        scheduling_ = value;
        onChanged();
      } else {
        schedulingBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Scheduling options for a CustomJob.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Scheduling scheduling = 3;</code>
     */
    public Builder setScheduling(
        com.google.cloud.aiplatform.v1beta1.Scheduling.Builder builderForValue) {
      if (schedulingBuilder_ == null) {
        scheduling_ = builderForValue.build();
        onChanged();
      } else {
        schedulingBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Scheduling options for a CustomJob.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Scheduling scheduling = 3;</code>
     */
    public Builder mergeScheduling(com.google.cloud.aiplatform.v1beta1.Scheduling value) {
      if (schedulingBuilder_ == null) {
        if (scheduling_ != null) {
          scheduling_ =
              com.google.cloud.aiplatform.v1beta1.Scheduling.newBuilder(scheduling_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          scheduling_ = value;
        }
        onChanged();
      } else {
        schedulingBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Scheduling options for a CustomJob.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Scheduling scheduling = 3;</code>
     */
    public Builder clearScheduling() {
      if (schedulingBuilder_ == null) {
        scheduling_ = null;
        onChanged();
      } else {
        scheduling_ = null;
        schedulingBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Scheduling options for a CustomJob.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Scheduling scheduling = 3;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.Scheduling.Builder getSchedulingBuilder() {

      onChanged();
      return getSchedulingFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Scheduling options for a CustomJob.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Scheduling scheduling = 3;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.SchedulingOrBuilder getSchedulingOrBuilder() {
      if (schedulingBuilder_ != null) {
        return schedulingBuilder_.getMessageOrBuilder();
      } else {
        return scheduling_ == null
            ? com.google.cloud.aiplatform.v1beta1.Scheduling.getDefaultInstance()
            : scheduling_;
      }
    }
    /**
     *
     *
     * <pre>
     * Scheduling options for a CustomJob.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Scheduling scheduling = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Scheduling,
            com.google.cloud.aiplatform.v1beta1.Scheduling.Builder,
            com.google.cloud.aiplatform.v1beta1.SchedulingOrBuilder>
        getSchedulingFieldBuilder() {
      if (schedulingBuilder_ == null) {
        schedulingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.Scheduling,
                com.google.cloud.aiplatform.v1beta1.Scheduling.Builder,
                com.google.cloud.aiplatform.v1beta1.SchedulingOrBuilder>(
                getScheduling(), getParentForChildren(), isClean());
        scheduling_ = null;
      }
      return schedulingBuilder_;
    }

    private java.lang.Object serviceAccount_ = "";
    /**
     *
     *
     * <pre>
     * Specifies the service account for workload run-as account.
     * Users submitting jobs must have act-as permission on this run-as account.
     * If unspecified, the [Vertex AI Custom Code Service
     * Agent](https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
     * for the CustomJob's project is used.
     * </pre>
     *
     * <code>string service_account = 4;</code>
     *
     * @return The serviceAccount.
     */
    public java.lang.String getServiceAccount() {
      java.lang.Object ref = serviceAccount_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccount_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the service account for workload run-as account.
     * Users submitting jobs must have act-as permission on this run-as account.
     * If unspecified, the [Vertex AI Custom Code Service
     * Agent](https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
     * for the CustomJob's project is used.
     * </pre>
     *
     * <code>string service_account = 4;</code>
     *
     * @return The bytes for serviceAccount.
     */
    public com.google.protobuf.ByteString getServiceAccountBytes() {
      java.lang.Object ref = serviceAccount_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the service account for workload run-as account.
     * Users submitting jobs must have act-as permission on this run-as account.
     * If unspecified, the [Vertex AI Custom Code Service
     * Agent](https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
     * for the CustomJob's project is used.
     * </pre>
     *
     * <code>string service_account = 4;</code>
     *
     * @param value The serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccount(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      serviceAccount_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the service account for workload run-as account.
     * Users submitting jobs must have act-as permission on this run-as account.
     * If unspecified, the [Vertex AI Custom Code Service
     * Agent](https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
     * for the CustomJob's project is used.
     * </pre>
     *
     * <code>string service_account = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccount() {

      serviceAccount_ = getDefaultInstance().getServiceAccount();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the service account for workload run-as account.
     * Users submitting jobs must have act-as permission on this run-as account.
     * If unspecified, the [Vertex AI Custom Code Service
     * Agent](https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
     * for the CustomJob's project is used.
     * </pre>
     *
     * <code>string service_account = 4;</code>
     *
     * @param value The bytes for serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      serviceAccount_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object network_ = "";
    /**
     *
     *
     * <pre>
     * The full name of the Compute Engine
     * [network](/compute/docs/networks-and-firewalls#networks) to which the Job
     * should be peered. For example, `projects/12345/global/networks/myVPC`.
     * [Format](/compute/docs/reference/rest/v1/networks/insert)
     * is of the form `projects/{project}/global/networks/{network}`.
     * Where {project} is a project number, as in `12345`, and {network} is a
     * network name.
     * To specify this field, you must have already [configured VPC Network
     * Peering for Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/general/vpc-peering).
     * If this field is left unspecified, the job is not peered with any network.
     * </pre>
     *
     * <code>string network = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The network.
     */
    public java.lang.String getNetwork() {
      java.lang.Object ref = network_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        network_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full name of the Compute Engine
     * [network](/compute/docs/networks-and-firewalls#networks) to which the Job
     * should be peered. For example, `projects/12345/global/networks/myVPC`.
     * [Format](/compute/docs/reference/rest/v1/networks/insert)
     * is of the form `projects/{project}/global/networks/{network}`.
     * Where {project} is a project number, as in `12345`, and {network} is a
     * network name.
     * To specify this field, you must have already [configured VPC Network
     * Peering for Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/general/vpc-peering).
     * If this field is left unspecified, the job is not peered with any network.
     * </pre>
     *
     * <code>string network = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for network.
     */
    public com.google.protobuf.ByteString getNetworkBytes() {
      java.lang.Object ref = network_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        network_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full name of the Compute Engine
     * [network](/compute/docs/networks-and-firewalls#networks) to which the Job
     * should be peered. For example, `projects/12345/global/networks/myVPC`.
     * [Format](/compute/docs/reference/rest/v1/networks/insert)
     * is of the form `projects/{project}/global/networks/{network}`.
     * Where {project} is a project number, as in `12345`, and {network} is a
     * network name.
     * To specify this field, you must have already [configured VPC Network
     * Peering for Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/general/vpc-peering).
     * If this field is left unspecified, the job is not peered with any network.
     * </pre>
     *
     * <code>string network = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The network to set.
     * @return This builder for chaining.
     */
    public Builder setNetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      network_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full name of the Compute Engine
     * [network](/compute/docs/networks-and-firewalls#networks) to which the Job
     * should be peered. For example, `projects/12345/global/networks/myVPC`.
     * [Format](/compute/docs/reference/rest/v1/networks/insert)
     * is of the form `projects/{project}/global/networks/{network}`.
     * Where {project} is a project number, as in `12345`, and {network} is a
     * network name.
     * To specify this field, you must have already [configured VPC Network
     * Peering for Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/general/vpc-peering).
     * If this field is left unspecified, the job is not peered with any network.
     * </pre>
     *
     * <code>string network = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetwork() {

      network_ = getDefaultInstance().getNetwork();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full name of the Compute Engine
     * [network](/compute/docs/networks-and-firewalls#networks) to which the Job
     * should be peered. For example, `projects/12345/global/networks/myVPC`.
     * [Format](/compute/docs/reference/rest/v1/networks/insert)
     * is of the form `projects/{project}/global/networks/{network}`.
     * Where {project} is a project number, as in `12345`, and {network} is a
     * network name.
     * To specify this field, you must have already [configured VPC Network
     * Peering for Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/general/vpc-peering).
     * If this field is left unspecified, the job is not peered with any network.
     * </pre>
     *
     * <code>string network = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for network to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      network_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList reservedIpRanges_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureReservedIpRangesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        reservedIpRanges_ = new com.google.protobuf.LazyStringArrayList(reservedIpRanges_);
        bitField0_ |= 0x00000002;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of names for the reserved ip ranges under the VPC network
     * that can be used for this job.
     * If set, we will deploy the job within the provided ip ranges. Otherwise,
     * the job will be deployed to any ip ranges under the provided VPC
     * network.
     * Example: ['vertex-ai-ip-range'].
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the reservedIpRanges.
     */
    public com.google.protobuf.ProtocolStringList getReservedIpRangesList() {
      return reservedIpRanges_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of names for the reserved ip ranges under the VPC network
     * that can be used for this job.
     * If set, we will deploy the job within the provided ip ranges. Otherwise,
     * the job will be deployed to any ip ranges under the provided VPC
     * network.
     * Example: ['vertex-ai-ip-range'].
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of reservedIpRanges.
     */
    public int getReservedIpRangesCount() {
      return reservedIpRanges_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of names for the reserved ip ranges under the VPC network
     * that can be used for this job.
     * If set, we will deploy the job within the provided ip ranges. Otherwise,
     * the job will be deployed to any ip ranges under the provided VPC
     * network.
     * Example: ['vertex-ai-ip-range'].
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The reservedIpRanges at the given index.
     */
    public java.lang.String getReservedIpRanges(int index) {
      return reservedIpRanges_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of names for the reserved ip ranges under the VPC network
     * that can be used for this job.
     * If set, we will deploy the job within the provided ip ranges. Otherwise,
     * the job will be deployed to any ip ranges under the provided VPC
     * network.
     * Example: ['vertex-ai-ip-range'].
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the reservedIpRanges at the given index.
     */
    public com.google.protobuf.ByteString getReservedIpRangesBytes(int index) {
      return reservedIpRanges_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of names for the reserved ip ranges under the VPC network
     * that can be used for this job.
     * If set, we will deploy the job within the provided ip ranges. Otherwise,
     * the job will be deployed to any ip ranges under the provided VPC
     * network.
     * Example: ['vertex-ai-ip-range'].
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The reservedIpRanges to set.
     * @return This builder for chaining.
     */
    public Builder setReservedIpRanges(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureReservedIpRangesIsMutable();
      reservedIpRanges_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of names for the reserved ip ranges under the VPC network
     * that can be used for this job.
     * If set, we will deploy the job within the provided ip ranges. Otherwise,
     * the job will be deployed to any ip ranges under the provided VPC
     * network.
     * Example: ['vertex-ai-ip-range'].
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The reservedIpRanges to add.
     * @return This builder for chaining.
     */
    public Builder addReservedIpRanges(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureReservedIpRangesIsMutable();
      reservedIpRanges_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of names for the reserved ip ranges under the VPC network
     * that can be used for this job.
     * If set, we will deploy the job within the provided ip ranges. Otherwise,
     * the job will be deployed to any ip ranges under the provided VPC
     * network.
     * Example: ['vertex-ai-ip-range'].
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The reservedIpRanges to add.
     * @return This builder for chaining.
     */
    public Builder addAllReservedIpRanges(java.lang.Iterable<java.lang.String> values) {
      ensureReservedIpRangesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, reservedIpRanges_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of names for the reserved ip ranges under the VPC network
     * that can be used for this job.
     * If set, we will deploy the job within the provided ip ranges. Otherwise,
     * the job will be deployed to any ip ranges under the provided VPC
     * network.
     * Example: ['vertex-ai-ip-range'].
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReservedIpRanges() {
      reservedIpRanges_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of names for the reserved ip ranges under the VPC network
     * that can be used for this job.
     * If set, we will deploy the job within the provided ip ranges. Otherwise,
     * the job will be deployed to any ip ranges under the provided VPC
     * network.
     * Example: ['vertex-ai-ip-range'].
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The bytes of the reservedIpRanges to add.
     * @return This builder for chaining.
     */
    public Builder addReservedIpRangesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureReservedIpRangesIsMutable();
      reservedIpRanges_.add(value);
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.GcsDestination baseOutputDirectory_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GcsDestination,
            com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder,
            com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder>
        baseOutputDirectoryBuilder_;
    /**
     *
     *
     * <pre>
     * The Cloud Storage location to store the output of this CustomJob or
     * HyperparameterTuningJob. For HyperparameterTuningJob,
     * the baseOutputDirectory of
     * each child CustomJob backing a Trial is set to a subdirectory of name
     * [id][google.cloud.aiplatform.v1beta1.Trial.id] under its parent HyperparameterTuningJob's
     * baseOutputDirectory.
     * The following Vertex AI environment variables will be passed to
     * containers or python modules when this field is set:
     *   For CustomJob:
     *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/model/`
     *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/checkpoints/`
     *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/logs/`
     *   For CustomJob backing a Trial of HyperparameterTuningJob:
     *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/model/`
     *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/checkpoints/`
     *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/logs/`
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination base_output_directory = 6;</code>
     *
     * @return Whether the baseOutputDirectory field is set.
     */
    public boolean hasBaseOutputDirectory() {
      return baseOutputDirectoryBuilder_ != null || baseOutputDirectory_ != null;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location to store the output of this CustomJob or
     * HyperparameterTuningJob. For HyperparameterTuningJob,
     * the baseOutputDirectory of
     * each child CustomJob backing a Trial is set to a subdirectory of name
     * [id][google.cloud.aiplatform.v1beta1.Trial.id] under its parent HyperparameterTuningJob's
     * baseOutputDirectory.
     * The following Vertex AI environment variables will be passed to
     * containers or python modules when this field is set:
     *   For CustomJob:
     *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/model/`
     *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/checkpoints/`
     *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/logs/`
     *   For CustomJob backing a Trial of HyperparameterTuningJob:
     *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/model/`
     *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/checkpoints/`
     *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/logs/`
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination base_output_directory = 6;</code>
     *
     * @return The baseOutputDirectory.
     */
    public com.google.cloud.aiplatform.v1beta1.GcsDestination getBaseOutputDirectory() {
      if (baseOutputDirectoryBuilder_ == null) {
        return baseOutputDirectory_ == null
            ? com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance()
            : baseOutputDirectory_;
      } else {
        return baseOutputDirectoryBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location to store the output of this CustomJob or
     * HyperparameterTuningJob. For HyperparameterTuningJob,
     * the baseOutputDirectory of
     * each child CustomJob backing a Trial is set to a subdirectory of name
     * [id][google.cloud.aiplatform.v1beta1.Trial.id] under its parent HyperparameterTuningJob's
     * baseOutputDirectory.
     * The following Vertex AI environment variables will be passed to
     * containers or python modules when this field is set:
     *   For CustomJob:
     *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/model/`
     *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/checkpoints/`
     *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/logs/`
     *   For CustomJob backing a Trial of HyperparameterTuningJob:
     *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/model/`
     *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/checkpoints/`
     *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/logs/`
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination base_output_directory = 6;</code>
     */
    public Builder setBaseOutputDirectory(
        com.google.cloud.aiplatform.v1beta1.GcsDestination value) {
      if (baseOutputDirectoryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        baseOutputDirectory_ = value;
        onChanged();
      } else {
        baseOutputDirectoryBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location to store the output of this CustomJob or
     * HyperparameterTuningJob. For HyperparameterTuningJob,
     * the baseOutputDirectory of
     * each child CustomJob backing a Trial is set to a subdirectory of name
     * [id][google.cloud.aiplatform.v1beta1.Trial.id] under its parent HyperparameterTuningJob's
     * baseOutputDirectory.
     * The following Vertex AI environment variables will be passed to
     * containers or python modules when this field is set:
     *   For CustomJob:
     *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/model/`
     *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/checkpoints/`
     *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/logs/`
     *   For CustomJob backing a Trial of HyperparameterTuningJob:
     *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/model/`
     *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/checkpoints/`
     *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/logs/`
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination base_output_directory = 6;</code>
     */
    public Builder setBaseOutputDirectory(
        com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder builderForValue) {
      if (baseOutputDirectoryBuilder_ == null) {
        baseOutputDirectory_ = builderForValue.build();
        onChanged();
      } else {
        baseOutputDirectoryBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location to store the output of this CustomJob or
     * HyperparameterTuningJob. For HyperparameterTuningJob,
     * the baseOutputDirectory of
     * each child CustomJob backing a Trial is set to a subdirectory of name
     * [id][google.cloud.aiplatform.v1beta1.Trial.id] under its parent HyperparameterTuningJob's
     * baseOutputDirectory.
     * The following Vertex AI environment variables will be passed to
     * containers or python modules when this field is set:
     *   For CustomJob:
     *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/model/`
     *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/checkpoints/`
     *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/logs/`
     *   For CustomJob backing a Trial of HyperparameterTuningJob:
     *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/model/`
     *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/checkpoints/`
     *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/logs/`
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination base_output_directory = 6;</code>
     */
    public Builder mergeBaseOutputDirectory(
        com.google.cloud.aiplatform.v1beta1.GcsDestination value) {
      if (baseOutputDirectoryBuilder_ == null) {
        if (baseOutputDirectory_ != null) {
          baseOutputDirectory_ =
              com.google.cloud.aiplatform.v1beta1.GcsDestination.newBuilder(baseOutputDirectory_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          baseOutputDirectory_ = value;
        }
        onChanged();
      } else {
        baseOutputDirectoryBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location to store the output of this CustomJob or
     * HyperparameterTuningJob. For HyperparameterTuningJob,
     * the baseOutputDirectory of
     * each child CustomJob backing a Trial is set to a subdirectory of name
     * [id][google.cloud.aiplatform.v1beta1.Trial.id] under its parent HyperparameterTuningJob's
     * baseOutputDirectory.
     * The following Vertex AI environment variables will be passed to
     * containers or python modules when this field is set:
     *   For CustomJob:
     *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/model/`
     *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/checkpoints/`
     *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/logs/`
     *   For CustomJob backing a Trial of HyperparameterTuningJob:
     *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/model/`
     *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/checkpoints/`
     *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/logs/`
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination base_output_directory = 6;</code>
     */
    public Builder clearBaseOutputDirectory() {
      if (baseOutputDirectoryBuilder_ == null) {
        baseOutputDirectory_ = null;
        onChanged();
      } else {
        baseOutputDirectory_ = null;
        baseOutputDirectoryBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location to store the output of this CustomJob or
     * HyperparameterTuningJob. For HyperparameterTuningJob,
     * the baseOutputDirectory of
     * each child CustomJob backing a Trial is set to a subdirectory of name
     * [id][google.cloud.aiplatform.v1beta1.Trial.id] under its parent HyperparameterTuningJob's
     * baseOutputDirectory.
     * The following Vertex AI environment variables will be passed to
     * containers or python modules when this field is set:
     *   For CustomJob:
     *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/model/`
     *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/checkpoints/`
     *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/logs/`
     *   For CustomJob backing a Trial of HyperparameterTuningJob:
     *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/model/`
     *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/checkpoints/`
     *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/logs/`
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination base_output_directory = 6;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder
        getBaseOutputDirectoryBuilder() {

      onChanged();
      return getBaseOutputDirectoryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location to store the output of this CustomJob or
     * HyperparameterTuningJob. For HyperparameterTuningJob,
     * the baseOutputDirectory of
     * each child CustomJob backing a Trial is set to a subdirectory of name
     * [id][google.cloud.aiplatform.v1beta1.Trial.id] under its parent HyperparameterTuningJob's
     * baseOutputDirectory.
     * The following Vertex AI environment variables will be passed to
     * containers or python modules when this field is set:
     *   For CustomJob:
     *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/model/`
     *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/checkpoints/`
     *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/logs/`
     *   For CustomJob backing a Trial of HyperparameterTuningJob:
     *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/model/`
     *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/checkpoints/`
     *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/logs/`
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination base_output_directory = 6;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder
        getBaseOutputDirectoryOrBuilder() {
      if (baseOutputDirectoryBuilder_ != null) {
        return baseOutputDirectoryBuilder_.getMessageOrBuilder();
      } else {
        return baseOutputDirectory_ == null
            ? com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance()
            : baseOutputDirectory_;
      }
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location to store the output of this CustomJob or
     * HyperparameterTuningJob. For HyperparameterTuningJob,
     * the baseOutputDirectory of
     * each child CustomJob backing a Trial is set to a subdirectory of name
     * [id][google.cloud.aiplatform.v1beta1.Trial.id] under its parent HyperparameterTuningJob's
     * baseOutputDirectory.
     * The following Vertex AI environment variables will be passed to
     * containers or python modules when this field is set:
     *   For CustomJob:
     *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/model/`
     *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/checkpoints/`
     *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/logs/`
     *   For CustomJob backing a Trial of HyperparameterTuningJob:
     *   * AIP_MODEL_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/model/`
     *   * AIP_CHECKPOINT_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/checkpoints/`
     *   * AIP_TENSORBOARD_LOG_DIR = `&lt;base_output_directory&gt;/&lt;trial_id&gt;/logs/`
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination base_output_directory = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GcsDestination,
            com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder,
            com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder>
        getBaseOutputDirectoryFieldBuilder() {
      if (baseOutputDirectoryBuilder_ == null) {
        baseOutputDirectoryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.GcsDestination,
                com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder,
                com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder>(
                getBaseOutputDirectory(), getParentForChildren(), isClean());
        baseOutputDirectory_ = null;
      }
      return baseOutputDirectoryBuilder_;
    }

    private java.lang.Object tensorboard_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The name of a Vertex AI [Tensorboard][google.cloud.aiplatform.v1beta1.Tensorboard] resource to which this CustomJob
     * will upload Tensorboard logs.
     * Format:
     * `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
     * </pre>
     *
     * <code>
     * string tensorboard = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The tensorboard.
     */
    public java.lang.String getTensorboard() {
      java.lang.Object ref = tensorboard_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tensorboard_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of a Vertex AI [Tensorboard][google.cloud.aiplatform.v1beta1.Tensorboard] resource to which this CustomJob
     * will upload Tensorboard logs.
     * Format:
     * `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
     * </pre>
     *
     * <code>
     * string tensorboard = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for tensorboard.
     */
    public com.google.protobuf.ByteString getTensorboardBytes() {
      java.lang.Object ref = tensorboard_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tensorboard_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of a Vertex AI [Tensorboard][google.cloud.aiplatform.v1beta1.Tensorboard] resource to which this CustomJob
     * will upload Tensorboard logs.
     * Format:
     * `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
     * </pre>
     *
     * <code>
     * string tensorboard = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The tensorboard to set.
     * @return This builder for chaining.
     */
    public Builder setTensorboard(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      tensorboard_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of a Vertex AI [Tensorboard][google.cloud.aiplatform.v1beta1.Tensorboard] resource to which this CustomJob
     * will upload Tensorboard logs.
     * Format:
     * `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
     * </pre>
     *
     * <code>
     * string tensorboard = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTensorboard() {

      tensorboard_ = getDefaultInstance().getTensorboard();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of a Vertex AI [Tensorboard][google.cloud.aiplatform.v1beta1.Tensorboard] resource to which this CustomJob
     * will upload Tensorboard logs.
     * Format:
     * `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
     * </pre>
     *
     * <code>
     * string tensorboard = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for tensorboard to set.
     * @return This builder for chaining.
     */
    public Builder setTensorboardBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      tensorboard_ = value;
      onChanged();
      return this;
    }

    private boolean enableWebAccess_;
    /**
     *
     *
     * <pre>
     * Optional. Whether you want Vertex AI to enable [interactive shell
     * access](https://cloud.google.com/vertex-ai/docs/training/monitor-debug-interactive-shell)
     * to training containers.
     * If set to `true`, you can access interactive shells at the URIs given
     * by [CustomJob.web_access_uris][google.cloud.aiplatform.v1beta1.CustomJob.web_access_uris] or [Trial.web_access_uris][google.cloud.aiplatform.v1beta1.Trial.web_access_uris] (within
     * [HyperparameterTuningJob.trials][google.cloud.aiplatform.v1beta1.HyperparameterTuningJob.trials]).
     * </pre>
     *
     * <code>bool enable_web_access = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The enableWebAccess.
     */
    @java.lang.Override
    public boolean getEnableWebAccess() {
      return enableWebAccess_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Whether you want Vertex AI to enable [interactive shell
     * access](https://cloud.google.com/vertex-ai/docs/training/monitor-debug-interactive-shell)
     * to training containers.
     * If set to `true`, you can access interactive shells at the URIs given
     * by [CustomJob.web_access_uris][google.cloud.aiplatform.v1beta1.CustomJob.web_access_uris] or [Trial.web_access_uris][google.cloud.aiplatform.v1beta1.Trial.web_access_uris] (within
     * [HyperparameterTuningJob.trials][google.cloud.aiplatform.v1beta1.HyperparameterTuningJob.trials]).
     * </pre>
     *
     * <code>bool enable_web_access = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The enableWebAccess to set.
     * @return This builder for chaining.
     */
    public Builder setEnableWebAccess(boolean value) {

      enableWebAccess_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Whether you want Vertex AI to enable [interactive shell
     * access](https://cloud.google.com/vertex-ai/docs/training/monitor-debug-interactive-shell)
     * to training containers.
     * If set to `true`, you can access interactive shells at the URIs given
     * by [CustomJob.web_access_uris][google.cloud.aiplatform.v1beta1.CustomJob.web_access_uris] or [Trial.web_access_uris][google.cloud.aiplatform.v1beta1.Trial.web_access_uris] (within
     * [HyperparameterTuningJob.trials][google.cloud.aiplatform.v1beta1.HyperparameterTuningJob.trials]).
     * </pre>
     *
     * <code>bool enable_web_access = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableWebAccess() {

      enableWebAccess_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.CustomJobSpec)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.CustomJobSpec)
  private static final com.google.cloud.aiplatform.v1beta1.CustomJobSpec DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.CustomJobSpec();
  }

  public static com.google.cloud.aiplatform.v1beta1.CustomJobSpec getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CustomJobSpec> PARSER =
      new com.google.protobuf.AbstractParser<CustomJobSpec>() {
        @java.lang.Override
        public CustomJobSpec parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new CustomJobSpec(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<CustomJobSpec> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CustomJobSpec> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.CustomJobSpec getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
