/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SpecialistPoolName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/specialistPools/{specialist_pool}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String specialistPool;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getSpecialistPool() {
        return this.specialistPool;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private SpecialistPoolName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.specialistPool = (String)Preconditions.checkNotNull((Object)builder.getSpecialistPool());
    }

    public static SpecialistPoolName of(String project, String location, String specialistPool) {
        return SpecialistPoolName.newBuilder().setProject(project).setLocation(location).setSpecialistPool(specialistPool).build();
    }

    public static String format(String project, String location, String specialistPool) {
        return SpecialistPoolName.newBuilder().setProject(project).setLocation(location).setSpecialistPool(specialistPool).build().toString();
    }

    public static SpecialistPoolName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "SpecialistPoolName.parse: formattedString not in valid format");
        return SpecialistPoolName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("specialist_pool"));
    }

    public static List<SpecialistPoolName> parseList(List<String> formattedStrings) {
        ArrayList<SpecialistPoolName> list = new ArrayList<SpecialistPoolName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SpecialistPoolName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SpecialistPoolName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SpecialistPoolName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SpecialistPoolName specialistPoolName = this;
            synchronized (specialistPoolName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"specialistPool", (Object)this.specialistPool);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "specialist_pool", this.specialistPool});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SpecialistPoolName) {
            SpecialistPoolName that = (SpecialistPoolName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.specialistPool.equals(that.specialistPool);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        return h ^= this.specialistPool.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String specialistPool;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getSpecialistPool() {
            return this.specialistPool;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setSpecialistPool(String specialistPool) {
            this.specialistPool = specialistPool;
            return this;
        }

        private Builder() {
        }

        private Builder(SpecialistPoolName specialistPoolName) {
            this.project = specialistPoolName.project;
            this.location = specialistPoolName.location;
            this.specialistPool = specialistPoolName.specialistPool;
        }

        public SpecialistPoolName build() {
            return new SpecialistPoolName(this);
        }
    }
}

