/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ModelEvaluationSliceName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/models/{model}/evaluations/{evaluation}/slices/{slice}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String model;
    private final String evaluation;
    private final String slice;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getModel() {
        return this.model;
    }

    public String getEvaluation() {
        return this.evaluation;
    }

    public String getSlice() {
        return this.slice;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ModelEvaluationSliceName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.model = (String)Preconditions.checkNotNull((Object)builder.getModel());
        this.evaluation = (String)Preconditions.checkNotNull((Object)builder.getEvaluation());
        this.slice = (String)Preconditions.checkNotNull((Object)builder.getSlice());
    }

    public static ModelEvaluationSliceName of(String project, String location, String model, String evaluation, String slice) {
        return ModelEvaluationSliceName.newBuilder().setProject(project).setLocation(location).setModel(model).setEvaluation(evaluation).setSlice(slice).build();
    }

    public static String format(String project, String location, String model, String evaluation, String slice) {
        return ModelEvaluationSliceName.newBuilder().setProject(project).setLocation(location).setModel(model).setEvaluation(evaluation).setSlice(slice).build().toString();
    }

    public static ModelEvaluationSliceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ModelEvaluationSliceName.parse: formattedString not in valid format");
        return ModelEvaluationSliceName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("model"), (String)matchMap.get("evaluation"), (String)matchMap.get("slice"));
    }

    public static List<ModelEvaluationSliceName> parseList(List<String> formattedStrings) {
        ArrayList<ModelEvaluationSliceName> list = new ArrayList<ModelEvaluationSliceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ModelEvaluationSliceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ModelEvaluationSliceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ModelEvaluationSliceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ModelEvaluationSliceName modelEvaluationSliceName = this;
            synchronized (modelEvaluationSliceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"model", (Object)this.model);
                    fieldMapBuilder.put((Object)"evaluation", (Object)this.evaluation);
                    fieldMapBuilder.put((Object)"slice", (Object)this.slice);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "model", this.model, "evaluation", this.evaluation, "slice", this.slice});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ModelEvaluationSliceName) {
            ModelEvaluationSliceName that = (ModelEvaluationSliceName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.model.equals(that.model) && this.evaluation.equals(that.evaluation) && this.slice.equals(that.slice);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        h ^= this.model.hashCode();
        h *= 1000003;
        h ^= this.evaluation.hashCode();
        h *= 1000003;
        return h ^= this.slice.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String model;
        private String evaluation;
        private String slice;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getModel() {
            return this.model;
        }

        public String getEvaluation() {
            return this.evaluation;
        }

        public String getSlice() {
            return this.slice;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setModel(String model) {
            this.model = model;
            return this;
        }

        public Builder setEvaluation(String evaluation) {
            this.evaluation = evaluation;
            return this;
        }

        public Builder setSlice(String slice) {
            this.slice = slice;
            return this;
        }

        private Builder() {
        }

        private Builder(ModelEvaluationSliceName modelEvaluationSliceName) {
            this.project = modelEvaluationSliceName.project;
            this.location = modelEvaluationSliceName.location;
            this.model = modelEvaluationSliceName.model;
            this.evaluation = modelEvaluationSliceName.evaluation;
            this.slice = modelEvaluationSliceName.slice;
        }

        public ModelEvaluationSliceName build() {
            return new ModelEvaluationSliceName(this);
        }
    }
}

