/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HyperparameterTuningJobName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/hyperparameterTuningJobs/{hyperparameter_tuning_job}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String hyperparameterTuningJob;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getHyperparameterTuningJob() {
        return this.hyperparameterTuningJob;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private HyperparameterTuningJobName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.hyperparameterTuningJob = (String)Preconditions.checkNotNull((Object)builder.getHyperparameterTuningJob());
    }

    public static HyperparameterTuningJobName of(String project, String location, String hyperparameterTuningJob) {
        return HyperparameterTuningJobName.newBuilder().setProject(project).setLocation(location).setHyperparameterTuningJob(hyperparameterTuningJob).build();
    }

    public static String format(String project, String location, String hyperparameterTuningJob) {
        return HyperparameterTuningJobName.newBuilder().setProject(project).setLocation(location).setHyperparameterTuningJob(hyperparameterTuningJob).build().toString();
    }

    public static HyperparameterTuningJobName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "HyperparameterTuningJobName.parse: formattedString not in valid format");
        return HyperparameterTuningJobName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("hyperparameter_tuning_job"));
    }

    public static List<HyperparameterTuningJobName> parseList(List<String> formattedStrings) {
        ArrayList<HyperparameterTuningJobName> list = new ArrayList<HyperparameterTuningJobName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(HyperparameterTuningJobName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<HyperparameterTuningJobName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (HyperparameterTuningJobName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            HyperparameterTuningJobName hyperparameterTuningJobName = this;
            synchronized (hyperparameterTuningJobName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"hyperparameterTuningJob", (Object)this.hyperparameterTuningJob);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "hyperparameter_tuning_job", this.hyperparameterTuningJob});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HyperparameterTuningJobName) {
            HyperparameterTuningJobName that = (HyperparameterTuningJobName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.hyperparameterTuningJob.equals(that.hyperparameterTuningJob);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        return h ^= this.hyperparameterTuningJob.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String hyperparameterTuningJob;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getHyperparameterTuningJob() {
            return this.hyperparameterTuningJob;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setHyperparameterTuningJob(String hyperparameterTuningJob) {
            this.hyperparameterTuningJob = hyperparameterTuningJob;
            return this;
        }

        private Builder() {
        }

        private Builder(HyperparameterTuningJobName hyperparameterTuningJobName) {
            this.project = hyperparameterTuningJobName.project;
            this.location = hyperparameterTuningJobName.location;
            this.hyperparameterTuningJob = hyperparameterTuningJobName.hyperparameterTuningJob;
        }

        public HyperparameterTuningJobName build() {
            return new HyperparameterTuningJobName(this);
        }
    }
}

