/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/feature_monitoring_stats.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Stats and Anomaly generated at specific timestamp for specific Feature.
 * The start_time and end_time are used to define the time range of the dataset
 * that current stats belongs to, e.g. prediction traffic is bucketed into
 * prediction datasets by time window. If the Dataset is not defined by time
 * window, start_time = end_time. Timestamp of the stats and anomalies always
 * refers to end_time. Raw stats and anomalies are stored in stats_uri or
 * anomaly_uri in the tensorflow defined protos. Field data_stats contains
 * almost identical information with the raw stats in Vertex AI
 * defined proto, for UI to display.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.FeatureStatsAnomaly}
 */
public final class FeatureStatsAnomaly extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.FeatureStatsAnomaly)
    FeatureStatsAnomalyOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use FeatureStatsAnomaly.newBuilder() to construct.
  private FeatureStatsAnomaly(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FeatureStatsAnomaly() {
    statsUri_ = "";
    anomalyUri_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FeatureStatsAnomaly();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.FeatureMonitoringStatsProto
        .internal_static_google_cloud_aiplatform_v1_FeatureStatsAnomaly_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.FeatureMonitoringStatsProto
        .internal_static_google_cloud_aiplatform_v1_FeatureStatsAnomaly_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.FeatureStatsAnomaly.class,
            com.google.cloud.aiplatform.v1.FeatureStatsAnomaly.Builder.class);
  }

  private int bitField0_;
  public static final int SCORE_FIELD_NUMBER = 1;
  private double score_ = 0D;

  /**
   *
   *
   * <pre>
   * Feature importance score, only populated when cross-feature monitoring is
   * enabled. For now only used to represent feature attribution score within
   * range [0, 1] for
   * [ModelDeploymentMonitoringObjectiveType.FEATURE_ATTRIBUTION_SKEW][google.cloud.aiplatform.v1.ModelDeploymentMonitoringObjectiveType.FEATURE_ATTRIBUTION_SKEW]
   * and
   * [ModelDeploymentMonitoringObjectiveType.FEATURE_ATTRIBUTION_DRIFT][google.cloud.aiplatform.v1.ModelDeploymentMonitoringObjectiveType.FEATURE_ATTRIBUTION_DRIFT].
   * </pre>
   *
   * <code>double score = 1;</code>
   *
   * @return The score.
   */
  @java.lang.Override
  public double getScore() {
    return score_;
  }

  public static final int STATS_URI_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object statsUri_ = "";

  /**
   *
   *
   * <pre>
   * Path of the stats file for current feature values in Cloud Storage bucket.
   * Format: gs://&lt;bucket_name&gt;/&lt;object_name&gt;/stats.
   * Example: gs://monitoring_bucket/feature_name/stats.
   * Stats are stored as binary format with Protobuf message
   * [tensorflow.metadata.v0.FeatureNameStatistics](https://github.com/tensorflow/metadata/blob/master/tensorflow_metadata/proto/v0/statistics.proto).
   * </pre>
   *
   * <code>string stats_uri = 3;</code>
   *
   * @return The statsUri.
   */
  @java.lang.Override
  public java.lang.String getStatsUri() {
    java.lang.Object ref = statsUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      statsUri_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Path of the stats file for current feature values in Cloud Storage bucket.
   * Format: gs://&lt;bucket_name&gt;/&lt;object_name&gt;/stats.
   * Example: gs://monitoring_bucket/feature_name/stats.
   * Stats are stored as binary format with Protobuf message
   * [tensorflow.metadata.v0.FeatureNameStatistics](https://github.com/tensorflow/metadata/blob/master/tensorflow_metadata/proto/v0/statistics.proto).
   * </pre>
   *
   * <code>string stats_uri = 3;</code>
   *
   * @return The bytes for statsUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStatsUriBytes() {
    java.lang.Object ref = statsUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      statsUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ANOMALY_URI_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object anomalyUri_ = "";

  /**
   *
   *
   * <pre>
   * Path of the anomaly file for current feature values in Cloud Storage
   * bucket.
   * Format: gs://&lt;bucket_name&gt;/&lt;object_name&gt;/anomalies.
   * Example: gs://monitoring_bucket/feature_name/anomalies.
   * Stats are stored as binary format with Protobuf message
   * Anoamlies are stored as binary format with Protobuf message
   * [tensorflow.metadata.v0.AnomalyInfo]
   * (https://github.com/tensorflow/metadata/blob/master/tensorflow_metadata/proto/v0/anomalies.proto).
   * </pre>
   *
   * <code>string anomaly_uri = 4;</code>
   *
   * @return The anomalyUri.
   */
  @java.lang.Override
  public java.lang.String getAnomalyUri() {
    java.lang.Object ref = anomalyUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      anomalyUri_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Path of the anomaly file for current feature values in Cloud Storage
   * bucket.
   * Format: gs://&lt;bucket_name&gt;/&lt;object_name&gt;/anomalies.
   * Example: gs://monitoring_bucket/feature_name/anomalies.
   * Stats are stored as binary format with Protobuf message
   * Anoamlies are stored as binary format with Protobuf message
   * [tensorflow.metadata.v0.AnomalyInfo]
   * (https://github.com/tensorflow/metadata/blob/master/tensorflow_metadata/proto/v0/anomalies.proto).
   * </pre>
   *
   * <code>string anomaly_uri = 4;</code>
   *
   * @return The bytes for anomalyUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAnomalyUriBytes() {
    java.lang.Object ref = anomalyUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      anomalyUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISTRIBUTION_DEVIATION_FIELD_NUMBER = 5;
  private double distributionDeviation_ = 0D;

  /**
   *
   *
   * <pre>
   * Deviation from the current stats to baseline stats.
   *   1. For categorical feature, the distribution distance is calculated by
   *      L-inifinity norm.
   *   2. For numerical feature, the distribution distance is calculated by
   *      Jensen–Shannon divergence.
   * </pre>
   *
   * <code>double distribution_deviation = 5;</code>
   *
   * @return The distributionDeviation.
   */
  @java.lang.Override
  public double getDistributionDeviation() {
    return distributionDeviation_;
  }

  public static final int ANOMALY_DETECTION_THRESHOLD_FIELD_NUMBER = 9;
  private double anomalyDetectionThreshold_ = 0D;

  /**
   *
   *
   * <pre>
   * This is the threshold used when detecting anomalies.
   * The threshold can be changed by user, so this one might be different from
   * [ThresholdConfig.value][google.cloud.aiplatform.v1.ThresholdConfig.value].
   * </pre>
   *
   * <code>double anomaly_detection_threshold = 9;</code>
   *
   * @return The anomalyDetectionThreshold.
   */
  @java.lang.Override
  public double getAnomalyDetectionThreshold() {
    return anomalyDetectionThreshold_;
  }

  public static final int START_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp startTime_;

  /**
   *
   *
   * <pre>
   * The start timestamp of window where stats were generated.
   * For objectives where time window doesn't make sense (e.g. Featurestore
   * Snapshot Monitoring), start_time is only used to indicate the monitoring
   * intervals, so it always equals to (end_time - monitoring_interval).
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 7;</code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * The start timestamp of window where stats were generated.
   * For objectives where time window doesn't make sense (e.g. Featurestore
   * Snapshot Monitoring), start_time is only used to indicate the monitoring
   * intervals, so it always equals to (end_time - monitoring_interval).
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 7;</code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  /**
   *
   *
   * <pre>
   * The start timestamp of window where stats were generated.
   * For objectives where time window doesn't make sense (e.g. Featurestore
   * Snapshot Monitoring), start_time is only used to indicate the monitoring
   * intervals, so it always equals to (end_time - monitoring_interval).
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  public static final int END_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp endTime_;

  /**
   *
   *
   * <pre>
   * The end timestamp of window where stats were generated.
   * For objectives where time window doesn't make sense (e.g. Featurestore
   * Snapshot Monitoring), end_time indicates the timestamp of the data used to
   * generate stats (e.g. timestamp we take snapshots for feature values).
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 8;</code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * The end timestamp of window where stats were generated.
   * For objectives where time window doesn't make sense (e.g. Featurestore
   * Snapshot Monitoring), end_time indicates the timestamp of the data used to
   * generate stats (e.g. timestamp we take snapshots for feature values).
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 8;</code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  /**
   *
   *
   * <pre>
   * The end timestamp of window where stats were generated.
   * For objectives where time window doesn't make sense (e.g. Featurestore
   * Snapshot Monitoring), end_time indicates the timestamp of the data used to
   * generate stats (e.g. timestamp we take snapshots for feature values).
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 8;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (java.lang.Double.doubleToRawLongBits(score_) != 0) {
      output.writeDouble(1, score_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(statsUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, statsUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(anomalyUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, anomalyUri_);
    }
    if (java.lang.Double.doubleToRawLongBits(distributionDeviation_) != 0) {
      output.writeDouble(5, distributionDeviation_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(7, getStartTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(8, getEndTime());
    }
    if (java.lang.Double.doubleToRawLongBits(anomalyDetectionThreshold_) != 0) {
      output.writeDouble(9, anomalyDetectionThreshold_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (java.lang.Double.doubleToRawLongBits(score_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(1, score_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(statsUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, statsUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(anomalyUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, anomalyUri_);
    }
    if (java.lang.Double.doubleToRawLongBits(distributionDeviation_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(5, distributionDeviation_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getStartTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getEndTime());
    }
    if (java.lang.Double.doubleToRawLongBits(anomalyDetectionThreshold_) != 0) {
      size +=
          com.google.protobuf.CodedOutputStream.computeDoubleSize(9, anomalyDetectionThreshold_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.FeatureStatsAnomaly)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.FeatureStatsAnomaly other =
        (com.google.cloud.aiplatform.v1.FeatureStatsAnomaly) obj;

    if (java.lang.Double.doubleToLongBits(getScore())
        != java.lang.Double.doubleToLongBits(other.getScore())) return false;
    if (!getStatsUri().equals(other.getStatsUri())) return false;
    if (!getAnomalyUri().equals(other.getAnomalyUri())) return false;
    if (java.lang.Double.doubleToLongBits(getDistributionDeviation())
        != java.lang.Double.doubleToLongBits(other.getDistributionDeviation())) return false;
    if (java.lang.Double.doubleToLongBits(getAnomalyDetectionThreshold())
        != java.lang.Double.doubleToLongBits(other.getAnomalyDetectionThreshold())) return false;
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SCORE_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(java.lang.Double.doubleToLongBits(getScore()));
    hash = (37 * hash) + STATS_URI_FIELD_NUMBER;
    hash = (53 * hash) + getStatsUri().hashCode();
    hash = (37 * hash) + ANOMALY_URI_FIELD_NUMBER;
    hash = (53 * hash) + getAnomalyUri().hashCode();
    hash = (37 * hash) + DISTRIBUTION_DEVIATION_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getDistributionDeviation()));
    hash = (37 * hash) + ANOMALY_DETECTION_THRESHOLD_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getAnomalyDetectionThreshold()));
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.FeatureStatsAnomaly parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.FeatureStatsAnomaly parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.FeatureStatsAnomaly parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.FeatureStatsAnomaly parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.FeatureStatsAnomaly parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.FeatureStatsAnomaly parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.FeatureStatsAnomaly parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.FeatureStatsAnomaly parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.FeatureStatsAnomaly parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.FeatureStatsAnomaly parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.FeatureStatsAnomaly parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.FeatureStatsAnomaly parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.FeatureStatsAnomaly prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Stats and Anomaly generated at specific timestamp for specific Feature.
   * The start_time and end_time are used to define the time range of the dataset
   * that current stats belongs to, e.g. prediction traffic is bucketed into
   * prediction datasets by time window. If the Dataset is not defined by time
   * window, start_time = end_time. Timestamp of the stats and anomalies always
   * refers to end_time. Raw stats and anomalies are stored in stats_uri or
   * anomaly_uri in the tensorflow defined protos. Field data_stats contains
   * almost identical information with the raw stats in Vertex AI
   * defined proto, for UI to display.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.FeatureStatsAnomaly}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.FeatureStatsAnomaly)
      com.google.cloud.aiplatform.v1.FeatureStatsAnomalyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.FeatureMonitoringStatsProto
          .internal_static_google_cloud_aiplatform_v1_FeatureStatsAnomaly_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.FeatureMonitoringStatsProto
          .internal_static_google_cloud_aiplatform_v1_FeatureStatsAnomaly_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.FeatureStatsAnomaly.class,
              com.google.cloud.aiplatform.v1.FeatureStatsAnomaly.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.FeatureStatsAnomaly.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getStartTimeFieldBuilder();
        getEndTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      score_ = 0D;
      statsUri_ = "";
      anomalyUri_ = "";
      distributionDeviation_ = 0D;
      anomalyDetectionThreshold_ = 0D;
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.FeatureMonitoringStatsProto
          .internal_static_google_cloud_aiplatform_v1_FeatureStatsAnomaly_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FeatureStatsAnomaly getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.FeatureStatsAnomaly.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FeatureStatsAnomaly build() {
      com.google.cloud.aiplatform.v1.FeatureStatsAnomaly result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FeatureStatsAnomaly buildPartial() {
      com.google.cloud.aiplatform.v1.FeatureStatsAnomaly result =
          new com.google.cloud.aiplatform.v1.FeatureStatsAnomaly(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.FeatureStatsAnomaly result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.score_ = score_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.statsUri_ = statsUri_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.anomalyUri_ = anomalyUri_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.distributionDeviation_ = distributionDeviation_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.anomalyDetectionThreshold_ = anomalyDetectionThreshold_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.startTime_ = startTimeBuilder_ == null ? startTime_ : startTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.FeatureStatsAnomaly) {
        return mergeFrom((com.google.cloud.aiplatform.v1.FeatureStatsAnomaly) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.FeatureStatsAnomaly other) {
      if (other == com.google.cloud.aiplatform.v1.FeatureStatsAnomaly.getDefaultInstance())
        return this;
      if (other.getScore() != 0D) {
        setScore(other.getScore());
      }
      if (!other.getStatsUri().isEmpty()) {
        statsUri_ = other.statsUri_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getAnomalyUri().isEmpty()) {
        anomalyUri_ = other.anomalyUri_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.getDistributionDeviation() != 0D) {
        setDistributionDeviation(other.getDistributionDeviation());
      }
      if (other.getAnomalyDetectionThreshold() != 0D) {
        setAnomalyDetectionThreshold(other.getAnomalyDetectionThreshold());
      }
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 9:
              {
                score_ = input.readDouble();
                bitField0_ |= 0x00000001;
                break;
              } // case 9
            case 26:
              {
                statsUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            case 34:
              {
                anomalyUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 34
            case 41:
              {
                distributionDeviation_ = input.readDouble();
                bitField0_ |= 0x00000008;
                break;
              } // case 41
            case 58:
              {
                input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 66
            case 73:
              {
                anomalyDetectionThreshold_ = input.readDouble();
                bitField0_ |= 0x00000010;
                break;
              } // case 73
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private double score_;

    /**
     *
     *
     * <pre>
     * Feature importance score, only populated when cross-feature monitoring is
     * enabled. For now only used to represent feature attribution score within
     * range [0, 1] for
     * [ModelDeploymentMonitoringObjectiveType.FEATURE_ATTRIBUTION_SKEW][google.cloud.aiplatform.v1.ModelDeploymentMonitoringObjectiveType.FEATURE_ATTRIBUTION_SKEW]
     * and
     * [ModelDeploymentMonitoringObjectiveType.FEATURE_ATTRIBUTION_DRIFT][google.cloud.aiplatform.v1.ModelDeploymentMonitoringObjectiveType.FEATURE_ATTRIBUTION_DRIFT].
     * </pre>
     *
     * <code>double score = 1;</code>
     *
     * @return The score.
     */
    @java.lang.Override
    public double getScore() {
      return score_;
    }

    /**
     *
     *
     * <pre>
     * Feature importance score, only populated when cross-feature monitoring is
     * enabled. For now only used to represent feature attribution score within
     * range [0, 1] for
     * [ModelDeploymentMonitoringObjectiveType.FEATURE_ATTRIBUTION_SKEW][google.cloud.aiplatform.v1.ModelDeploymentMonitoringObjectiveType.FEATURE_ATTRIBUTION_SKEW]
     * and
     * [ModelDeploymentMonitoringObjectiveType.FEATURE_ATTRIBUTION_DRIFT][google.cloud.aiplatform.v1.ModelDeploymentMonitoringObjectiveType.FEATURE_ATTRIBUTION_DRIFT].
     * </pre>
     *
     * <code>double score = 1;</code>
     *
     * @param value The score to set.
     * @return This builder for chaining.
     */
    public Builder setScore(double value) {

      score_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Feature importance score, only populated when cross-feature monitoring is
     * enabled. For now only used to represent feature attribution score within
     * range [0, 1] for
     * [ModelDeploymentMonitoringObjectiveType.FEATURE_ATTRIBUTION_SKEW][google.cloud.aiplatform.v1.ModelDeploymentMonitoringObjectiveType.FEATURE_ATTRIBUTION_SKEW]
     * and
     * [ModelDeploymentMonitoringObjectiveType.FEATURE_ATTRIBUTION_DRIFT][google.cloud.aiplatform.v1.ModelDeploymentMonitoringObjectiveType.FEATURE_ATTRIBUTION_DRIFT].
     * </pre>
     *
     * <code>double score = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearScore() {
      bitField0_ = (bitField0_ & ~0x00000001);
      score_ = 0D;
      onChanged();
      return this;
    }

    private java.lang.Object statsUri_ = "";

    /**
     *
     *
     * <pre>
     * Path of the stats file for current feature values in Cloud Storage bucket.
     * Format: gs://&lt;bucket_name&gt;/&lt;object_name&gt;/stats.
     * Example: gs://monitoring_bucket/feature_name/stats.
     * Stats are stored as binary format with Protobuf message
     * [tensorflow.metadata.v0.FeatureNameStatistics](https://github.com/tensorflow/metadata/blob/master/tensorflow_metadata/proto/v0/statistics.proto).
     * </pre>
     *
     * <code>string stats_uri = 3;</code>
     *
     * @return The statsUri.
     */
    public java.lang.String getStatsUri() {
      java.lang.Object ref = statsUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        statsUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Path of the stats file for current feature values in Cloud Storage bucket.
     * Format: gs://&lt;bucket_name&gt;/&lt;object_name&gt;/stats.
     * Example: gs://monitoring_bucket/feature_name/stats.
     * Stats are stored as binary format with Protobuf message
     * [tensorflow.metadata.v0.FeatureNameStatistics](https://github.com/tensorflow/metadata/blob/master/tensorflow_metadata/proto/v0/statistics.proto).
     * </pre>
     *
     * <code>string stats_uri = 3;</code>
     *
     * @return The bytes for statsUri.
     */
    public com.google.protobuf.ByteString getStatsUriBytes() {
      java.lang.Object ref = statsUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        statsUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Path of the stats file for current feature values in Cloud Storage bucket.
     * Format: gs://&lt;bucket_name&gt;/&lt;object_name&gt;/stats.
     * Example: gs://monitoring_bucket/feature_name/stats.
     * Stats are stored as binary format with Protobuf message
     * [tensorflow.metadata.v0.FeatureNameStatistics](https://github.com/tensorflow/metadata/blob/master/tensorflow_metadata/proto/v0/statistics.proto).
     * </pre>
     *
     * <code>string stats_uri = 3;</code>
     *
     * @param value The statsUri to set.
     * @return This builder for chaining.
     */
    public Builder setStatsUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      statsUri_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Path of the stats file for current feature values in Cloud Storage bucket.
     * Format: gs://&lt;bucket_name&gt;/&lt;object_name&gt;/stats.
     * Example: gs://monitoring_bucket/feature_name/stats.
     * Stats are stored as binary format with Protobuf message
     * [tensorflow.metadata.v0.FeatureNameStatistics](https://github.com/tensorflow/metadata/blob/master/tensorflow_metadata/proto/v0/statistics.proto).
     * </pre>
     *
     * <code>string stats_uri = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatsUri() {
      statsUri_ = getDefaultInstance().getStatsUri();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Path of the stats file for current feature values in Cloud Storage bucket.
     * Format: gs://&lt;bucket_name&gt;/&lt;object_name&gt;/stats.
     * Example: gs://monitoring_bucket/feature_name/stats.
     * Stats are stored as binary format with Protobuf message
     * [tensorflow.metadata.v0.FeatureNameStatistics](https://github.com/tensorflow/metadata/blob/master/tensorflow_metadata/proto/v0/statistics.proto).
     * </pre>
     *
     * <code>string stats_uri = 3;</code>
     *
     * @param value The bytes for statsUri to set.
     * @return This builder for chaining.
     */
    public Builder setStatsUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      statsUri_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object anomalyUri_ = "";

    /**
     *
     *
     * <pre>
     * Path of the anomaly file for current feature values in Cloud Storage
     * bucket.
     * Format: gs://&lt;bucket_name&gt;/&lt;object_name&gt;/anomalies.
     * Example: gs://monitoring_bucket/feature_name/anomalies.
     * Stats are stored as binary format with Protobuf message
     * Anoamlies are stored as binary format with Protobuf message
     * [tensorflow.metadata.v0.AnomalyInfo]
     * (https://github.com/tensorflow/metadata/blob/master/tensorflow_metadata/proto/v0/anomalies.proto).
     * </pre>
     *
     * <code>string anomaly_uri = 4;</code>
     *
     * @return The anomalyUri.
     */
    public java.lang.String getAnomalyUri() {
      java.lang.Object ref = anomalyUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        anomalyUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Path of the anomaly file for current feature values in Cloud Storage
     * bucket.
     * Format: gs://&lt;bucket_name&gt;/&lt;object_name&gt;/anomalies.
     * Example: gs://monitoring_bucket/feature_name/anomalies.
     * Stats are stored as binary format with Protobuf message
     * Anoamlies are stored as binary format with Protobuf message
     * [tensorflow.metadata.v0.AnomalyInfo]
     * (https://github.com/tensorflow/metadata/blob/master/tensorflow_metadata/proto/v0/anomalies.proto).
     * </pre>
     *
     * <code>string anomaly_uri = 4;</code>
     *
     * @return The bytes for anomalyUri.
     */
    public com.google.protobuf.ByteString getAnomalyUriBytes() {
      java.lang.Object ref = anomalyUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        anomalyUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Path of the anomaly file for current feature values in Cloud Storage
     * bucket.
     * Format: gs://&lt;bucket_name&gt;/&lt;object_name&gt;/anomalies.
     * Example: gs://monitoring_bucket/feature_name/anomalies.
     * Stats are stored as binary format with Protobuf message
     * Anoamlies are stored as binary format with Protobuf message
     * [tensorflow.metadata.v0.AnomalyInfo]
     * (https://github.com/tensorflow/metadata/blob/master/tensorflow_metadata/proto/v0/anomalies.proto).
     * </pre>
     *
     * <code>string anomaly_uri = 4;</code>
     *
     * @param value The anomalyUri to set.
     * @return This builder for chaining.
     */
    public Builder setAnomalyUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      anomalyUri_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Path of the anomaly file for current feature values in Cloud Storage
     * bucket.
     * Format: gs://&lt;bucket_name&gt;/&lt;object_name&gt;/anomalies.
     * Example: gs://monitoring_bucket/feature_name/anomalies.
     * Stats are stored as binary format with Protobuf message
     * Anoamlies are stored as binary format with Protobuf message
     * [tensorflow.metadata.v0.AnomalyInfo]
     * (https://github.com/tensorflow/metadata/blob/master/tensorflow_metadata/proto/v0/anomalies.proto).
     * </pre>
     *
     * <code>string anomaly_uri = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAnomalyUri() {
      anomalyUri_ = getDefaultInstance().getAnomalyUri();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Path of the anomaly file for current feature values in Cloud Storage
     * bucket.
     * Format: gs://&lt;bucket_name&gt;/&lt;object_name&gt;/anomalies.
     * Example: gs://monitoring_bucket/feature_name/anomalies.
     * Stats are stored as binary format with Protobuf message
     * Anoamlies are stored as binary format with Protobuf message
     * [tensorflow.metadata.v0.AnomalyInfo]
     * (https://github.com/tensorflow/metadata/blob/master/tensorflow_metadata/proto/v0/anomalies.proto).
     * </pre>
     *
     * <code>string anomaly_uri = 4;</code>
     *
     * @param value The bytes for anomalyUri to set.
     * @return This builder for chaining.
     */
    public Builder setAnomalyUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      anomalyUri_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private double distributionDeviation_;

    /**
     *
     *
     * <pre>
     * Deviation from the current stats to baseline stats.
     *   1. For categorical feature, the distribution distance is calculated by
     *      L-inifinity norm.
     *   2. For numerical feature, the distribution distance is calculated by
     *      Jensen–Shannon divergence.
     * </pre>
     *
     * <code>double distribution_deviation = 5;</code>
     *
     * @return The distributionDeviation.
     */
    @java.lang.Override
    public double getDistributionDeviation() {
      return distributionDeviation_;
    }

    /**
     *
     *
     * <pre>
     * Deviation from the current stats to baseline stats.
     *   1. For categorical feature, the distribution distance is calculated by
     *      L-inifinity norm.
     *   2. For numerical feature, the distribution distance is calculated by
     *      Jensen–Shannon divergence.
     * </pre>
     *
     * <code>double distribution_deviation = 5;</code>
     *
     * @param value The distributionDeviation to set.
     * @return This builder for chaining.
     */
    public Builder setDistributionDeviation(double value) {

      distributionDeviation_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deviation from the current stats to baseline stats.
     *   1. For categorical feature, the distribution distance is calculated by
     *      L-inifinity norm.
     *   2. For numerical feature, the distribution distance is calculated by
     *      Jensen–Shannon divergence.
     * </pre>
     *
     * <code>double distribution_deviation = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDistributionDeviation() {
      bitField0_ = (bitField0_ & ~0x00000008);
      distributionDeviation_ = 0D;
      onChanged();
      return this;
    }

    private double anomalyDetectionThreshold_;

    /**
     *
     *
     * <pre>
     * This is the threshold used when detecting anomalies.
     * The threshold can be changed by user, so this one might be different from
     * [ThresholdConfig.value][google.cloud.aiplatform.v1.ThresholdConfig.value].
     * </pre>
     *
     * <code>double anomaly_detection_threshold = 9;</code>
     *
     * @return The anomalyDetectionThreshold.
     */
    @java.lang.Override
    public double getAnomalyDetectionThreshold() {
      return anomalyDetectionThreshold_;
    }

    /**
     *
     *
     * <pre>
     * This is the threshold used when detecting anomalies.
     * The threshold can be changed by user, so this one might be different from
     * [ThresholdConfig.value][google.cloud.aiplatform.v1.ThresholdConfig.value].
     * </pre>
     *
     * <code>double anomaly_detection_threshold = 9;</code>
     *
     * @param value The anomalyDetectionThreshold to set.
     * @return This builder for chaining.
     */
    public Builder setAnomalyDetectionThreshold(double value) {

      anomalyDetectionThreshold_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * This is the threshold used when detecting anomalies.
     * The threshold can be changed by user, so this one might be different from
     * [ThresholdConfig.value][google.cloud.aiplatform.v1.ThresholdConfig.value].
     * </pre>
     *
     * <code>double anomaly_detection_threshold = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAnomalyDetectionThreshold() {
      bitField0_ = (bitField0_ & ~0x00000010);
      anomalyDetectionThreshold_ = 0D;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;

    /**
     *
     *
     * <pre>
     * The start timestamp of window where stats were generated.
     * For objectives where time window doesn't make sense (e.g. Featurestore
     * Snapshot Monitoring), start_time is only used to indicate the monitoring
     * intervals, so it always equals to (end_time - monitoring_interval).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7;</code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * The start timestamp of window where stats were generated.
     * For objectives where time window doesn't make sense (e.g. Featurestore
     * Snapshot Monitoring), start_time is only used to indicate the monitoring
     * intervals, so it always equals to (end_time - monitoring_interval).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7;</code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The start timestamp of window where stats were generated.
     * For objectives where time window doesn't make sense (e.g. Featurestore
     * Snapshot Monitoring), start_time is only used to indicate the monitoring
     * intervals, so it always equals to (end_time - monitoring_interval).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
      } else {
        startTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The start timestamp of window where stats were generated.
     * For objectives where time window doesn't make sense (e.g. Featurestore
     * Snapshot Monitoring), start_time is only used to indicate the monitoring
     * intervals, so it always equals to (end_time - monitoring_interval).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The start timestamp of window where stats were generated.
     * For objectives where time window doesn't make sense (e.g. Featurestore
     * Snapshot Monitoring), start_time is only used to indicate the monitoring
     * intervals, so it always equals to (end_time - monitoring_interval).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7;</code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && startTime_ != null
            && startTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getStartTimeBuilder().mergeFrom(value);
        } else {
          startTime_ = value;
        }
      } else {
        startTimeBuilder_.mergeFrom(value);
      }
      if (startTime_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The start timestamp of window where stats were generated.
     * For objectives where time window doesn't make sense (e.g. Featurestore
     * Snapshot Monitoring), start_time is only used to indicate the monitoring
     * intervals, so it always equals to (end_time - monitoring_interval).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7;</code>
     */
    public Builder clearStartTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The start timestamp of window where stats were generated.
     * For objectives where time window doesn't make sense (e.g. Featurestore
     * Snapshot Monitoring), start_time is only used to indicate the monitoring
     * intervals, so it always equals to (end_time - monitoring_interval).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7;</code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The start timestamp of window where stats were generated.
     * For objectives where time window doesn't make sense (e.g. Featurestore
     * Snapshot Monitoring), start_time is only used to indicate the monitoring
     * intervals, so it always equals to (end_time - monitoring_interval).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * The start timestamp of window where stats were generated.
     * For objectives where time window doesn't make sense (e.g. Featurestore
     * Snapshot Monitoring), start_time is only used to indicate the monitoring
     * intervals, so it always equals to (end_time - monitoring_interval).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;

    /**
     *
     *
     * <pre>
     * The end timestamp of window where stats were generated.
     * For objectives where time window doesn't make sense (e.g. Featurestore
     * Snapshot Monitoring), end_time indicates the timestamp of the data used to
     * generate stats (e.g. timestamp we take snapshots for feature values).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8;</code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * The end timestamp of window where stats were generated.
     * For objectives where time window doesn't make sense (e.g. Featurestore
     * Snapshot Monitoring), end_time indicates the timestamp of the data used to
     * generate stats (e.g. timestamp we take snapshots for feature values).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8;</code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The end timestamp of window where stats were generated.
     * For objectives where time window doesn't make sense (e.g. Featurestore
     * Snapshot Monitoring), end_time indicates the timestamp of the data used to
     * generate stats (e.g. timestamp we take snapshots for feature values).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
      } else {
        endTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The end timestamp of window where stats were generated.
     * For objectives where time window doesn't make sense (e.g. Featurestore
     * Snapshot Monitoring), end_time indicates the timestamp of the data used to
     * generate stats (e.g. timestamp we take snapshots for feature values).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The end timestamp of window where stats were generated.
     * For objectives where time window doesn't make sense (e.g. Featurestore
     * Snapshot Monitoring), end_time indicates the timestamp of the data used to
     * generate stats (e.g. timestamp we take snapshots for feature values).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8;</code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && endTime_ != null
            && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEndTimeBuilder().mergeFrom(value);
        } else {
          endTime_ = value;
        }
      } else {
        endTimeBuilder_.mergeFrom(value);
      }
      if (endTime_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The end timestamp of window where stats were generated.
     * For objectives where time window doesn't make sense (e.g. Featurestore
     * Snapshot Monitoring), end_time indicates the timestamp of the data used to
     * generate stats (e.g. timestamp we take snapshots for feature values).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8;</code>
     */
    public Builder clearEndTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The end timestamp of window where stats were generated.
     * For objectives where time window doesn't make sense (e.g. Featurestore
     * Snapshot Monitoring), end_time indicates the timestamp of the data used to
     * generate stats (e.g. timestamp we take snapshots for feature values).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8;</code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The end timestamp of window where stats were generated.
     * For objectives where time window doesn't make sense (e.g. Featurestore
     * Snapshot Monitoring), end_time indicates the timestamp of the data used to
     * generate stats (e.g. timestamp we take snapshots for feature values).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * The end timestamp of window where stats were generated.
     * For objectives where time window doesn't make sense (e.g. Featurestore
     * Snapshot Monitoring), end_time indicates the timestamp of the data used to
     * generate stats (e.g. timestamp we take snapshots for feature values).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.FeatureStatsAnomaly)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.FeatureStatsAnomaly)
  private static final com.google.cloud.aiplatform.v1.FeatureStatsAnomaly DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.FeatureStatsAnomaly();
  }

  public static com.google.cloud.aiplatform.v1.FeatureStatsAnomaly getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FeatureStatsAnomaly> PARSER =
      new com.google.protobuf.AbstractParser<FeatureStatsAnomaly>() {
        @java.lang.Override
        public FeatureStatsAnomaly parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<FeatureStatsAnomaly> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FeatureStatsAnomaly> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FeatureStatsAnomaly getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
