/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/vertex_rag_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * The fact used in grounding.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.Fact}
 */
public final class Fact extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.Fact)
    FactOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Fact.newBuilder() to construct.
  private Fact(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Fact() {
    query_ = "";
    title_ = "";
    uri_ = "";
    summary_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Fact();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.VertexRagServiceProto
        .internal_static_google_cloud_aiplatform_v1_Fact_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.VertexRagServiceProto
        .internal_static_google_cloud_aiplatform_v1_Fact_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.Fact.class,
            com.google.cloud.aiplatform.v1.Fact.Builder.class);
  }

  private int bitField0_;
  public static final int QUERY_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object query_ = "";

  /**
   *
   *
   * <pre>
   * Query that is used to retrieve this fact.
   * </pre>
   *
   * <code>optional string query = 1;</code>
   *
   * @return Whether the query field is set.
   */
  @java.lang.Override
  public boolean hasQuery() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Query that is used to retrieve this fact.
   * </pre>
   *
   * <code>optional string query = 1;</code>
   *
   * @return The query.
   */
  @java.lang.Override
  public java.lang.String getQuery() {
    java.lang.Object ref = query_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      query_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Query that is used to retrieve this fact.
   * </pre>
   *
   * <code>optional string query = 1;</code>
   *
   * @return The bytes for query.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getQueryBytes() {
    java.lang.Object ref = query_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      query_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TITLE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object title_ = "";

  /**
   *
   *
   * <pre>
   * If present, it refers to the title of this fact.
   * </pre>
   *
   * <code>optional string title = 2;</code>
   *
   * @return Whether the title field is set.
   */
  @java.lang.Override
  public boolean hasTitle() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * If present, it refers to the title of this fact.
   * </pre>
   *
   * <code>optional string title = 2;</code>
   *
   * @return The title.
   */
  @java.lang.Override
  public java.lang.String getTitle() {
    java.lang.Object ref = title_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      title_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * If present, it refers to the title of this fact.
   * </pre>
   *
   * <code>optional string title = 2;</code>
   *
   * @return The bytes for title.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTitleBytes() {
    java.lang.Object ref = title_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      title_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int URI_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uri_ = "";

  /**
   *
   *
   * <pre>
   * If present, this uri links to the source of the fact.
   * </pre>
   *
   * <code>optional string uri = 3;</code>
   *
   * @return Whether the uri field is set.
   */
  @java.lang.Override
  public boolean hasUri() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * If present, this uri links to the source of the fact.
   * </pre>
   *
   * <code>optional string uri = 3;</code>
   *
   * @return The uri.
   */
  @java.lang.Override
  public java.lang.String getUri() {
    java.lang.Object ref = uri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uri_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * If present, this uri links to the source of the fact.
   * </pre>
   *
   * <code>optional string uri = 3;</code>
   *
   * @return The bytes for uri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUriBytes() {
    java.lang.Object ref = uri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUMMARY_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object summary_ = "";

  /**
   *
   *
   * <pre>
   * If present, the summary/snippet of the fact.
   * </pre>
   *
   * <code>optional string summary = 4;</code>
   *
   * @return Whether the summary field is set.
   */
  @java.lang.Override
  public boolean hasSummary() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * If present, the summary/snippet of the fact.
   * </pre>
   *
   * <code>optional string summary = 4;</code>
   *
   * @return The summary.
   */
  @java.lang.Override
  public java.lang.String getSummary() {
    java.lang.Object ref = summary_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      summary_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * If present, the summary/snippet of the fact.
   * </pre>
   *
   * <code>optional string summary = 4;</code>
   *
   * @return The bytes for summary.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSummaryBytes() {
    java.lang.Object ref = summary_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      summary_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VECTOR_DISTANCE_FIELD_NUMBER = 5;
  private double vectorDistance_ = 0D;

  /**
   *
   *
   * <pre>
   * If present, the distance between the query vector and this fact vector.
   * </pre>
   *
   * <code>optional double vector_distance = 5 [deprecated = true];</code>
   *
   * @deprecated google.cloud.aiplatform.v1.Fact.vector_distance is deprecated. See
   *     google/cloud/aiplatform/v1/vertex_rag_service.proto;l=288
   * @return Whether the vectorDistance field is set.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean hasVectorDistance() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * If present, the distance between the query vector and this fact vector.
   * </pre>
   *
   * <code>optional double vector_distance = 5 [deprecated = true];</code>
   *
   * @deprecated google.cloud.aiplatform.v1.Fact.vector_distance is deprecated. See
   *     google/cloud/aiplatform/v1/vertex_rag_service.proto;l=288
   * @return The vectorDistance.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public double getVectorDistance() {
    return vectorDistance_;
  }

  public static final int SCORE_FIELD_NUMBER = 6;
  private double score_ = 0D;

  /**
   *
   *
   * <pre>
   * If present, according to the underlying Vector DB and the selected metric
   * type, the score can be either the distance or the similarity between the
   * query and the fact and its range depends on the metric type.
   *
   * For example, if the metric type is COSINE_DISTANCE, it represents the
   * distance between the query and the fact. The larger the distance, the less
   * relevant the fact is to the query. The range is [0, 2], while 0 means the
   * most relevant and 2 means the least relevant.
   * </pre>
   *
   * <code>optional double score = 6;</code>
   *
   * @return Whether the score field is set.
   */
  @java.lang.Override
  public boolean hasScore() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * If present, according to the underlying Vector DB and the selected metric
   * type, the score can be either the distance or the similarity between the
   * query and the fact and its range depends on the metric type.
   *
   * For example, if the metric type is COSINE_DISTANCE, it represents the
   * distance between the query and the fact. The larger the distance, the less
   * relevant the fact is to the query. The range is [0, 2], while 0 means the
   * most relevant and 2 means the least relevant.
   * </pre>
   *
   * <code>optional double score = 6;</code>
   *
   * @return The score.
   */
  @java.lang.Override
  public double getScore() {
    return score_;
  }

  public static final int CHUNK_FIELD_NUMBER = 7;
  private com.google.cloud.aiplatform.v1.RagChunk chunk_;

  /**
   *
   *
   * <pre>
   * If present, chunk properties.
   * </pre>
   *
   * <code>optional .google.cloud.aiplatform.v1.RagChunk chunk = 7;</code>
   *
   * @return Whether the chunk field is set.
   */
  @java.lang.Override
  public boolean hasChunk() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * If present, chunk properties.
   * </pre>
   *
   * <code>optional .google.cloud.aiplatform.v1.RagChunk chunk = 7;</code>
   *
   * @return The chunk.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.RagChunk getChunk() {
    return chunk_ == null ? com.google.cloud.aiplatform.v1.RagChunk.getDefaultInstance() : chunk_;
  }

  /**
   *
   *
   * <pre>
   * If present, chunk properties.
   * </pre>
   *
   * <code>optional .google.cloud.aiplatform.v1.RagChunk chunk = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.RagChunkOrBuilder getChunkOrBuilder() {
    return chunk_ == null ? com.google.cloud.aiplatform.v1.RagChunk.getDefaultInstance() : chunk_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, query_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, title_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, uri_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, summary_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeDouble(5, vectorDistance_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeDouble(6, score_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(7, getChunk());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, query_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, title_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, uri_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, summary_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(5, vectorDistance_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(6, score_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getChunk());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.Fact)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.Fact other = (com.google.cloud.aiplatform.v1.Fact) obj;

    if (hasQuery() != other.hasQuery()) return false;
    if (hasQuery()) {
      if (!getQuery().equals(other.getQuery())) return false;
    }
    if (hasTitle() != other.hasTitle()) return false;
    if (hasTitle()) {
      if (!getTitle().equals(other.getTitle())) return false;
    }
    if (hasUri() != other.hasUri()) return false;
    if (hasUri()) {
      if (!getUri().equals(other.getUri())) return false;
    }
    if (hasSummary() != other.hasSummary()) return false;
    if (hasSummary()) {
      if (!getSummary().equals(other.getSummary())) return false;
    }
    if (hasVectorDistance() != other.hasVectorDistance()) return false;
    if (hasVectorDistance()) {
      if (java.lang.Double.doubleToLongBits(getVectorDistance())
          != java.lang.Double.doubleToLongBits(other.getVectorDistance())) return false;
    }
    if (hasScore() != other.hasScore()) return false;
    if (hasScore()) {
      if (java.lang.Double.doubleToLongBits(getScore())
          != java.lang.Double.doubleToLongBits(other.getScore())) return false;
    }
    if (hasChunk() != other.hasChunk()) return false;
    if (hasChunk()) {
      if (!getChunk().equals(other.getChunk())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasQuery()) {
      hash = (37 * hash) + QUERY_FIELD_NUMBER;
      hash = (53 * hash) + getQuery().hashCode();
    }
    if (hasTitle()) {
      hash = (37 * hash) + TITLE_FIELD_NUMBER;
      hash = (53 * hash) + getTitle().hashCode();
    }
    if (hasUri()) {
      hash = (37 * hash) + URI_FIELD_NUMBER;
      hash = (53 * hash) + getUri().hashCode();
    }
    if (hasSummary()) {
      hash = (37 * hash) + SUMMARY_FIELD_NUMBER;
      hash = (53 * hash) + getSummary().hashCode();
    }
    if (hasVectorDistance()) {
      hash = (37 * hash) + VECTOR_DISTANCE_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getVectorDistance()));
    }
    if (hasScore()) {
      hash = (37 * hash) + SCORE_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getScore()));
    }
    if (hasChunk()) {
      hash = (37 * hash) + CHUNK_FIELD_NUMBER;
      hash = (53 * hash) + getChunk().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.Fact parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.Fact parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Fact parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.Fact parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Fact parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.Fact parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Fact parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.Fact parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Fact parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.Fact parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Fact parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.Fact parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.Fact prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * The fact used in grounding.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.Fact}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.Fact)
      com.google.cloud.aiplatform.v1.FactOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.VertexRagServiceProto
          .internal_static_google_cloud_aiplatform_v1_Fact_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.VertexRagServiceProto
          .internal_static_google_cloud_aiplatform_v1_Fact_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.Fact.class,
              com.google.cloud.aiplatform.v1.Fact.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.Fact.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getChunkFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      query_ = "";
      title_ = "";
      uri_ = "";
      summary_ = "";
      vectorDistance_ = 0D;
      score_ = 0D;
      chunk_ = null;
      if (chunkBuilder_ != null) {
        chunkBuilder_.dispose();
        chunkBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.VertexRagServiceProto
          .internal_static_google_cloud_aiplatform_v1_Fact_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Fact getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.Fact.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Fact build() {
      com.google.cloud.aiplatform.v1.Fact result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Fact buildPartial() {
      com.google.cloud.aiplatform.v1.Fact result = new com.google.cloud.aiplatform.v1.Fact(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.Fact result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.query_ = query_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.title_ = title_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.uri_ = uri_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.summary_ = summary_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.vectorDistance_ = vectorDistance_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.score_ = score_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.chunk_ = chunkBuilder_ == null ? chunk_ : chunkBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.Fact) {
        return mergeFrom((com.google.cloud.aiplatform.v1.Fact) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.Fact other) {
      if (other == com.google.cloud.aiplatform.v1.Fact.getDefaultInstance()) return this;
      if (other.hasQuery()) {
        query_ = other.query_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasTitle()) {
        title_ = other.title_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasUri()) {
        uri_ = other.uri_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasSummary()) {
        summary_ = other.summary_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasVectorDistance()) {
        setVectorDistance(other.getVectorDistance());
      }
      if (other.hasScore()) {
        setScore(other.getScore());
      }
      if (other.hasChunk()) {
        mergeChunk(other.getChunk());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                query_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                title_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                uri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                summary_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 41:
              {
                vectorDistance_ = input.readDouble();
                bitField0_ |= 0x00000010;
                break;
              } // case 41
            case 49:
              {
                score_ = input.readDouble();
                bitField0_ |= 0x00000020;
                break;
              } // case 49
            case 58:
              {
                input.readMessage(getChunkFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object query_ = "";

    /**
     *
     *
     * <pre>
     * Query that is used to retrieve this fact.
     * </pre>
     *
     * <code>optional string query = 1;</code>
     *
     * @return Whether the query field is set.
     */
    public boolean hasQuery() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Query that is used to retrieve this fact.
     * </pre>
     *
     * <code>optional string query = 1;</code>
     *
     * @return The query.
     */
    public java.lang.String getQuery() {
      java.lang.Object ref = query_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        query_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Query that is used to retrieve this fact.
     * </pre>
     *
     * <code>optional string query = 1;</code>
     *
     * @return The bytes for query.
     */
    public com.google.protobuf.ByteString getQueryBytes() {
      java.lang.Object ref = query_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        query_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Query that is used to retrieve this fact.
     * </pre>
     *
     * <code>optional string query = 1;</code>
     *
     * @param value The query to set.
     * @return This builder for chaining.
     */
    public Builder setQuery(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      query_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Query that is used to retrieve this fact.
     * </pre>
     *
     * <code>optional string query = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearQuery() {
      query_ = getDefaultInstance().getQuery();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Query that is used to retrieve this fact.
     * </pre>
     *
     * <code>optional string query = 1;</code>
     *
     * @param value The bytes for query to set.
     * @return This builder for chaining.
     */
    public Builder setQueryBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      query_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object title_ = "";

    /**
     *
     *
     * <pre>
     * If present, it refers to the title of this fact.
     * </pre>
     *
     * <code>optional string title = 2;</code>
     *
     * @return Whether the title field is set.
     */
    public boolean hasTitle() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * If present, it refers to the title of this fact.
     * </pre>
     *
     * <code>optional string title = 2;</code>
     *
     * @return The title.
     */
    public java.lang.String getTitle() {
      java.lang.Object ref = title_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        title_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * If present, it refers to the title of this fact.
     * </pre>
     *
     * <code>optional string title = 2;</code>
     *
     * @return The bytes for title.
     */
    public com.google.protobuf.ByteString getTitleBytes() {
      java.lang.Object ref = title_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        title_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * If present, it refers to the title of this fact.
     * </pre>
     *
     * <code>optional string title = 2;</code>
     *
     * @param value The title to set.
     * @return This builder for chaining.
     */
    public Builder setTitle(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      title_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If present, it refers to the title of this fact.
     * </pre>
     *
     * <code>optional string title = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTitle() {
      title_ = getDefaultInstance().getTitle();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If present, it refers to the title of this fact.
     * </pre>
     *
     * <code>optional string title = 2;</code>
     *
     * @param value The bytes for title to set.
     * @return This builder for chaining.
     */
    public Builder setTitleBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      title_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object uri_ = "";

    /**
     *
     *
     * <pre>
     * If present, this uri links to the source of the fact.
     * </pre>
     *
     * <code>optional string uri = 3;</code>
     *
     * @return Whether the uri field is set.
     */
    public boolean hasUri() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * If present, this uri links to the source of the fact.
     * </pre>
     *
     * <code>optional string uri = 3;</code>
     *
     * @return The uri.
     */
    public java.lang.String getUri() {
      java.lang.Object ref = uri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * If present, this uri links to the source of the fact.
     * </pre>
     *
     * <code>optional string uri = 3;</code>
     *
     * @return The bytes for uri.
     */
    public com.google.protobuf.ByteString getUriBytes() {
      java.lang.Object ref = uri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * If present, this uri links to the source of the fact.
     * </pre>
     *
     * <code>optional string uri = 3;</code>
     *
     * @param value The uri to set.
     * @return This builder for chaining.
     */
    public Builder setUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uri_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If present, this uri links to the source of the fact.
     * </pre>
     *
     * <code>optional string uri = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUri() {
      uri_ = getDefaultInstance().getUri();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If present, this uri links to the source of the fact.
     * </pre>
     *
     * <code>optional string uri = 3;</code>
     *
     * @param value The bytes for uri to set.
     * @return This builder for chaining.
     */
    public Builder setUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uri_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object summary_ = "";

    /**
     *
     *
     * <pre>
     * If present, the summary/snippet of the fact.
     * </pre>
     *
     * <code>optional string summary = 4;</code>
     *
     * @return Whether the summary field is set.
     */
    public boolean hasSummary() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * If present, the summary/snippet of the fact.
     * </pre>
     *
     * <code>optional string summary = 4;</code>
     *
     * @return The summary.
     */
    public java.lang.String getSummary() {
      java.lang.Object ref = summary_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        summary_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * If present, the summary/snippet of the fact.
     * </pre>
     *
     * <code>optional string summary = 4;</code>
     *
     * @return The bytes for summary.
     */
    public com.google.protobuf.ByteString getSummaryBytes() {
      java.lang.Object ref = summary_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        summary_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * If present, the summary/snippet of the fact.
     * </pre>
     *
     * <code>optional string summary = 4;</code>
     *
     * @param value The summary to set.
     * @return This builder for chaining.
     */
    public Builder setSummary(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      summary_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If present, the summary/snippet of the fact.
     * </pre>
     *
     * <code>optional string summary = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSummary() {
      summary_ = getDefaultInstance().getSummary();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If present, the summary/snippet of the fact.
     * </pre>
     *
     * <code>optional string summary = 4;</code>
     *
     * @param value The bytes for summary to set.
     * @return This builder for chaining.
     */
    public Builder setSummaryBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      summary_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private double vectorDistance_;

    /**
     *
     *
     * <pre>
     * If present, the distance between the query vector and this fact vector.
     * </pre>
     *
     * <code>optional double vector_distance = 5 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1.Fact.vector_distance is deprecated. See
     *     google/cloud/aiplatform/v1/vertex_rag_service.proto;l=288
     * @return Whether the vectorDistance field is set.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public boolean hasVectorDistance() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * If present, the distance between the query vector and this fact vector.
     * </pre>
     *
     * <code>optional double vector_distance = 5 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1.Fact.vector_distance is deprecated. See
     *     google/cloud/aiplatform/v1/vertex_rag_service.proto;l=288
     * @return The vectorDistance.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public double getVectorDistance() {
      return vectorDistance_;
    }

    /**
     *
     *
     * <pre>
     * If present, the distance between the query vector and this fact vector.
     * </pre>
     *
     * <code>optional double vector_distance = 5 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1.Fact.vector_distance is deprecated. See
     *     google/cloud/aiplatform/v1/vertex_rag_service.proto;l=288
     * @param value The vectorDistance to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setVectorDistance(double value) {

      vectorDistance_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If present, the distance between the query vector and this fact vector.
     * </pre>
     *
     * <code>optional double vector_distance = 5 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1.Fact.vector_distance is deprecated. See
     *     google/cloud/aiplatform/v1/vertex_rag_service.proto;l=288
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearVectorDistance() {
      bitField0_ = (bitField0_ & ~0x00000010);
      vectorDistance_ = 0D;
      onChanged();
      return this;
    }

    private double score_;

    /**
     *
     *
     * <pre>
     * If present, according to the underlying Vector DB and the selected metric
     * type, the score can be either the distance or the similarity between the
     * query and the fact and its range depends on the metric type.
     *
     * For example, if the metric type is COSINE_DISTANCE, it represents the
     * distance between the query and the fact. The larger the distance, the less
     * relevant the fact is to the query. The range is [0, 2], while 0 means the
     * most relevant and 2 means the least relevant.
     * </pre>
     *
     * <code>optional double score = 6;</code>
     *
     * @return Whether the score field is set.
     */
    @java.lang.Override
    public boolean hasScore() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * If present, according to the underlying Vector DB and the selected metric
     * type, the score can be either the distance or the similarity between the
     * query and the fact and its range depends on the metric type.
     *
     * For example, if the metric type is COSINE_DISTANCE, it represents the
     * distance between the query and the fact. The larger the distance, the less
     * relevant the fact is to the query. The range is [0, 2], while 0 means the
     * most relevant and 2 means the least relevant.
     * </pre>
     *
     * <code>optional double score = 6;</code>
     *
     * @return The score.
     */
    @java.lang.Override
    public double getScore() {
      return score_;
    }

    /**
     *
     *
     * <pre>
     * If present, according to the underlying Vector DB and the selected metric
     * type, the score can be either the distance or the similarity between the
     * query and the fact and its range depends on the metric type.
     *
     * For example, if the metric type is COSINE_DISTANCE, it represents the
     * distance between the query and the fact. The larger the distance, the less
     * relevant the fact is to the query. The range is [0, 2], while 0 means the
     * most relevant and 2 means the least relevant.
     * </pre>
     *
     * <code>optional double score = 6;</code>
     *
     * @param value The score to set.
     * @return This builder for chaining.
     */
    public Builder setScore(double value) {

      score_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If present, according to the underlying Vector DB and the selected metric
     * type, the score can be either the distance or the similarity between the
     * query and the fact and its range depends on the metric type.
     *
     * For example, if the metric type is COSINE_DISTANCE, it represents the
     * distance between the query and the fact. The larger the distance, the less
     * relevant the fact is to the query. The range is [0, 2], while 0 means the
     * most relevant and 2 means the least relevant.
     * </pre>
     *
     * <code>optional double score = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearScore() {
      bitField0_ = (bitField0_ & ~0x00000020);
      score_ = 0D;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1.RagChunk chunk_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.RagChunk,
            com.google.cloud.aiplatform.v1.RagChunk.Builder,
            com.google.cloud.aiplatform.v1.RagChunkOrBuilder>
        chunkBuilder_;

    /**
     *
     *
     * <pre>
     * If present, chunk properties.
     * </pre>
     *
     * <code>optional .google.cloud.aiplatform.v1.RagChunk chunk = 7;</code>
     *
     * @return Whether the chunk field is set.
     */
    public boolean hasChunk() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * If present, chunk properties.
     * </pre>
     *
     * <code>optional .google.cloud.aiplatform.v1.RagChunk chunk = 7;</code>
     *
     * @return The chunk.
     */
    public com.google.cloud.aiplatform.v1.RagChunk getChunk() {
      if (chunkBuilder_ == null) {
        return chunk_ == null
            ? com.google.cloud.aiplatform.v1.RagChunk.getDefaultInstance()
            : chunk_;
      } else {
        return chunkBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * If present, chunk properties.
     * </pre>
     *
     * <code>optional .google.cloud.aiplatform.v1.RagChunk chunk = 7;</code>
     */
    public Builder setChunk(com.google.cloud.aiplatform.v1.RagChunk value) {
      if (chunkBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        chunk_ = value;
      } else {
        chunkBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If present, chunk properties.
     * </pre>
     *
     * <code>optional .google.cloud.aiplatform.v1.RagChunk chunk = 7;</code>
     */
    public Builder setChunk(com.google.cloud.aiplatform.v1.RagChunk.Builder builderForValue) {
      if (chunkBuilder_ == null) {
        chunk_ = builderForValue.build();
      } else {
        chunkBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If present, chunk properties.
     * </pre>
     *
     * <code>optional .google.cloud.aiplatform.v1.RagChunk chunk = 7;</code>
     */
    public Builder mergeChunk(com.google.cloud.aiplatform.v1.RagChunk value) {
      if (chunkBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && chunk_ != null
            && chunk_ != com.google.cloud.aiplatform.v1.RagChunk.getDefaultInstance()) {
          getChunkBuilder().mergeFrom(value);
        } else {
          chunk_ = value;
        }
      } else {
        chunkBuilder_.mergeFrom(value);
      }
      if (chunk_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * If present, chunk properties.
     * </pre>
     *
     * <code>optional .google.cloud.aiplatform.v1.RagChunk chunk = 7;</code>
     */
    public Builder clearChunk() {
      bitField0_ = (bitField0_ & ~0x00000040);
      chunk_ = null;
      if (chunkBuilder_ != null) {
        chunkBuilder_.dispose();
        chunkBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If present, chunk properties.
     * </pre>
     *
     * <code>optional .google.cloud.aiplatform.v1.RagChunk chunk = 7;</code>
     */
    public com.google.cloud.aiplatform.v1.RagChunk.Builder getChunkBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getChunkFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * If present, chunk properties.
     * </pre>
     *
     * <code>optional .google.cloud.aiplatform.v1.RagChunk chunk = 7;</code>
     */
    public com.google.cloud.aiplatform.v1.RagChunkOrBuilder getChunkOrBuilder() {
      if (chunkBuilder_ != null) {
        return chunkBuilder_.getMessageOrBuilder();
      } else {
        return chunk_ == null
            ? com.google.cloud.aiplatform.v1.RagChunk.getDefaultInstance()
            : chunk_;
      }
    }

    /**
     *
     *
     * <pre>
     * If present, chunk properties.
     * </pre>
     *
     * <code>optional .google.cloud.aiplatform.v1.RagChunk chunk = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.RagChunk,
            com.google.cloud.aiplatform.v1.RagChunk.Builder,
            com.google.cloud.aiplatform.v1.RagChunkOrBuilder>
        getChunkFieldBuilder() {
      if (chunkBuilder_ == null) {
        chunkBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.RagChunk,
                com.google.cloud.aiplatform.v1.RagChunk.Builder,
                com.google.cloud.aiplatform.v1.RagChunkOrBuilder>(
                getChunk(), getParentForChildren(), isClean());
        chunk_ = null;
      }
      return chunkBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.Fact)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.Fact)
  private static final com.google.cloud.aiplatform.v1.Fact DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.Fact();
  }

  public static com.google.cloud.aiplatform.v1.Fact getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Fact> PARSER =
      new com.google.protobuf.AbstractParser<Fact>() {
        @java.lang.Override
        public Fact parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Fact> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Fact> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Fact getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
