/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/model_monitoring.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * The alert config for model monitoring.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.ModelMonitoringAlertConfig}
 */
public final class ModelMonitoringAlertConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.ModelMonitoringAlertConfig)
    ModelMonitoringAlertConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ModelMonitoringAlertConfig.newBuilder() to construct.
  private ModelMonitoringAlertConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ModelMonitoringAlertConfig() {
    notificationChannels_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ModelMonitoringAlertConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.ModelMonitoringProto
        .internal_static_google_cloud_aiplatform_v1_ModelMonitoringAlertConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.ModelMonitoringProto
        .internal_static_google_cloud_aiplatform_v1_ModelMonitoringAlertConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.class,
            com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.Builder.class);
  }

  public interface EmailAlertConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The email addresses to send the alert.
     * </pre>
     *
     * <code>repeated string user_emails = 1;</code>
     *
     * @return A list containing the userEmails.
     */
    java.util.List<java.lang.String> getUserEmailsList();
    /**
     *
     *
     * <pre>
     * The email addresses to send the alert.
     * </pre>
     *
     * <code>repeated string user_emails = 1;</code>
     *
     * @return The count of userEmails.
     */
    int getUserEmailsCount();
    /**
     *
     *
     * <pre>
     * The email addresses to send the alert.
     * </pre>
     *
     * <code>repeated string user_emails = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The userEmails at the given index.
     */
    java.lang.String getUserEmails(int index);
    /**
     *
     *
     * <pre>
     * The email addresses to send the alert.
     * </pre>
     *
     * <code>repeated string user_emails = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the userEmails at the given index.
     */
    com.google.protobuf.ByteString getUserEmailsBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * The config for email alert.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig}
   */
  public static final class EmailAlertConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig)
      EmailAlertConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use EmailAlertConfig.newBuilder() to construct.
    private EmailAlertConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private EmailAlertConfig() {
      userEmails_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new EmailAlertConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.ModelMonitoringProto
          .internal_static_google_cloud_aiplatform_v1_ModelMonitoringAlertConfig_EmailAlertConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.ModelMonitoringProto
          .internal_static_google_cloud_aiplatform_v1_ModelMonitoringAlertConfig_EmailAlertConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig.class,
              com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig.Builder
                  .class);
    }

    public static final int USER_EMAILS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList userEmails_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * The email addresses to send the alert.
     * </pre>
     *
     * <code>repeated string user_emails = 1;</code>
     *
     * @return A list containing the userEmails.
     */
    public com.google.protobuf.ProtocolStringList getUserEmailsList() {
      return userEmails_;
    }
    /**
     *
     *
     * <pre>
     * The email addresses to send the alert.
     * </pre>
     *
     * <code>repeated string user_emails = 1;</code>
     *
     * @return The count of userEmails.
     */
    public int getUserEmailsCount() {
      return userEmails_.size();
    }
    /**
     *
     *
     * <pre>
     * The email addresses to send the alert.
     * </pre>
     *
     * <code>repeated string user_emails = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The userEmails at the given index.
     */
    public java.lang.String getUserEmails(int index) {
      return userEmails_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The email addresses to send the alert.
     * </pre>
     *
     * <code>repeated string user_emails = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the userEmails at the given index.
     */
    public com.google.protobuf.ByteString getUserEmailsBytes(int index) {
      return userEmails_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < userEmails_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, userEmails_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < userEmails_.size(); i++) {
          dataSize += computeStringSizeNoTag(userEmails_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getUserEmailsList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig other =
          (com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig) obj;

      if (!getUserEmailsList().equals(other.getUserEmailsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getUserEmailsCount() > 0) {
        hash = (37 * hash) + USER_EMAILS_FIELD_NUMBER;
        hash = (53 * hash) + getUserEmailsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The config for email alert.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig)
        com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.ModelMonitoringProto
            .internal_static_google_cloud_aiplatform_v1_ModelMonitoringAlertConfig_EmailAlertConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.ModelMonitoringProto
            .internal_static_google_cloud_aiplatform_v1_ModelMonitoringAlertConfig_EmailAlertConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig.class,
                com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        userEmails_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.ModelMonitoringProto
            .internal_static_google_cloud_aiplatform_v1_ModelMonitoringAlertConfig_EmailAlertConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig build() {
        com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig
          buildPartial() {
        com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig result =
            new com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          userEmails_.makeImmutable();
          result.userEmails_ = userEmails_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig other) {
        if (other
            == com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig
                .getDefaultInstance()) return this;
        if (!other.userEmails_.isEmpty()) {
          if (userEmails_.isEmpty()) {
            userEmails_ = other.userEmails_;
            bitField0_ |= 0x00000001;
          } else {
            ensureUserEmailsIsMutable();
            userEmails_.addAll(other.userEmails_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureUserEmailsIsMutable();
                  userEmails_.add(s);
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList userEmails_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureUserEmailsIsMutable() {
        if (!userEmails_.isModifiable()) {
          userEmails_ = new com.google.protobuf.LazyStringArrayList(userEmails_);
        }
        bitField0_ |= 0x00000001;
      }
      /**
       *
       *
       * <pre>
       * The email addresses to send the alert.
       * </pre>
       *
       * <code>repeated string user_emails = 1;</code>
       *
       * @return A list containing the userEmails.
       */
      public com.google.protobuf.ProtocolStringList getUserEmailsList() {
        userEmails_.makeImmutable();
        return userEmails_;
      }
      /**
       *
       *
       * <pre>
       * The email addresses to send the alert.
       * </pre>
       *
       * <code>repeated string user_emails = 1;</code>
       *
       * @return The count of userEmails.
       */
      public int getUserEmailsCount() {
        return userEmails_.size();
      }
      /**
       *
       *
       * <pre>
       * The email addresses to send the alert.
       * </pre>
       *
       * <code>repeated string user_emails = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The userEmails at the given index.
       */
      public java.lang.String getUserEmails(int index) {
        return userEmails_.get(index);
      }
      /**
       *
       *
       * <pre>
       * The email addresses to send the alert.
       * </pre>
       *
       * <code>repeated string user_emails = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the userEmails at the given index.
       */
      public com.google.protobuf.ByteString getUserEmailsBytes(int index) {
        return userEmails_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * The email addresses to send the alert.
       * </pre>
       *
       * <code>repeated string user_emails = 1;</code>
       *
       * @param index The index to set the value at.
       * @param value The userEmails to set.
       * @return This builder for chaining.
       */
      public Builder setUserEmails(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureUserEmailsIsMutable();
        userEmails_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The email addresses to send the alert.
       * </pre>
       *
       * <code>repeated string user_emails = 1;</code>
       *
       * @param value The userEmails to add.
       * @return This builder for chaining.
       */
      public Builder addUserEmails(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureUserEmailsIsMutable();
        userEmails_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The email addresses to send the alert.
       * </pre>
       *
       * <code>repeated string user_emails = 1;</code>
       *
       * @param values The userEmails to add.
       * @return This builder for chaining.
       */
      public Builder addAllUserEmails(java.lang.Iterable<java.lang.String> values) {
        ensureUserEmailsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, userEmails_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The email addresses to send the alert.
       * </pre>
       *
       * <code>repeated string user_emails = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUserEmails() {
        userEmails_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The email addresses to send the alert.
       * </pre>
       *
       * <code>repeated string user_emails = 1;</code>
       *
       * @param value The bytes of the userEmails to add.
       * @return This builder for chaining.
       */
      public Builder addUserEmailsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureUserEmailsIsMutable();
        userEmails_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig)
    private static final com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig();
    }

    public static com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<EmailAlertConfig> PARSER =
        new com.google.protobuf.AbstractParser<EmailAlertConfig>() {
          @java.lang.Override
          public EmailAlertConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<EmailAlertConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<EmailAlertConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int alertCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object alert_;

  public enum AlertCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    EMAIL_ALERT_CONFIG(1),
    ALERT_NOT_SET(0);
    private final int value;

    private AlertCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AlertCase valueOf(int value) {
      return forNumber(value);
    }

    public static AlertCase forNumber(int value) {
      switch (value) {
        case 1:
          return EMAIL_ALERT_CONFIG;
        case 0:
          return ALERT_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public AlertCase getAlertCase() {
    return AlertCase.forNumber(alertCase_);
  }

  public static final int EMAIL_ALERT_CONFIG_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Email alert config.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig email_alert_config = 1;
   * </code>
   *
   * @return Whether the emailAlertConfig field is set.
   */
  @java.lang.Override
  public boolean hasEmailAlertConfig() {
    return alertCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Email alert config.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig email_alert_config = 1;
   * </code>
   *
   * @return The emailAlertConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig
      getEmailAlertConfig() {
    if (alertCase_ == 1) {
      return (com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig) alert_;
    }
    return com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Email alert config.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig email_alert_config = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfigOrBuilder
      getEmailAlertConfigOrBuilder() {
    if (alertCase_ == 1) {
      return (com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig) alert_;
    }
    return com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig
        .getDefaultInstance();
  }

  public static final int ENABLE_LOGGING_FIELD_NUMBER = 2;
  private boolean enableLogging_ = false;
  /**
   *
   *
   * <pre>
   * Dump the anomalies to Cloud Logging. The anomalies will be put to json
   * payload encoded from proto
   * [google.cloud.aiplatform.logging.ModelMonitoringAnomaliesLogEntry][].
   * This can be further sinked to Pub/Sub or any other services supported
   * by Cloud Logging.
   * </pre>
   *
   * <code>bool enable_logging = 2;</code>
   *
   * @return The enableLogging.
   */
  @java.lang.Override
  public boolean getEnableLogging() {
    return enableLogging_;
  }

  public static final int NOTIFICATION_CHANNELS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList notificationChannels_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Resource names of the NotificationChannels to send alert.
   * Must be of the format
   * `projects/&lt;project_id_or_number&gt;/notificationChannels/&lt;channel_id&gt;`
   * </pre>
   *
   * <code>repeated string notification_channels = 3 [(.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return A list containing the notificationChannels.
   */
  public com.google.protobuf.ProtocolStringList getNotificationChannelsList() {
    return notificationChannels_;
  }
  /**
   *
   *
   * <pre>
   * Resource names of the NotificationChannels to send alert.
   * Must be of the format
   * `projects/&lt;project_id_or_number&gt;/notificationChannels/&lt;channel_id&gt;`
   * </pre>
   *
   * <code>repeated string notification_channels = 3 [(.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The count of notificationChannels.
   */
  public int getNotificationChannelsCount() {
    return notificationChannels_.size();
  }
  /**
   *
   *
   * <pre>
   * Resource names of the NotificationChannels to send alert.
   * Must be of the format
   * `projects/&lt;project_id_or_number&gt;/notificationChannels/&lt;channel_id&gt;`
   * </pre>
   *
   * <code>repeated string notification_channels = 3 [(.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the element to return.
   * @return The notificationChannels at the given index.
   */
  public java.lang.String getNotificationChannels(int index) {
    return notificationChannels_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Resource names of the NotificationChannels to send alert.
   * Must be of the format
   * `projects/&lt;project_id_or_number&gt;/notificationChannels/&lt;channel_id&gt;`
   * </pre>
   *
   * <code>repeated string notification_channels = 3 [(.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the notificationChannels at the given index.
   */
  public com.google.protobuf.ByteString getNotificationChannelsBytes(int index) {
    return notificationChannels_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (alertCase_ == 1) {
      output.writeMessage(
          1, (com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig) alert_);
    }
    if (enableLogging_ != false) {
      output.writeBool(2, enableLogging_);
    }
    for (int i = 0; i < notificationChannels_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 3, notificationChannels_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (alertCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1,
              (com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig) alert_);
    }
    if (enableLogging_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, enableLogging_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < notificationChannels_.size(); i++) {
        dataSize += computeStringSizeNoTag(notificationChannels_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getNotificationChannelsList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig other =
        (com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig) obj;

    if (getEnableLogging() != other.getEnableLogging()) return false;
    if (!getNotificationChannelsList().equals(other.getNotificationChannelsList())) return false;
    if (!getAlertCase().equals(other.getAlertCase())) return false;
    switch (alertCase_) {
      case 1:
        if (!getEmailAlertConfig().equals(other.getEmailAlertConfig())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ENABLE_LOGGING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableLogging());
    if (getNotificationChannelsCount() > 0) {
      hash = (37 * hash) + NOTIFICATION_CHANNELS_FIELD_NUMBER;
      hash = (53 * hash) + getNotificationChannelsList().hashCode();
    }
    switch (alertCase_) {
      case 1:
        hash = (37 * hash) + EMAIL_ALERT_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getEmailAlertConfig().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The alert config for model monitoring.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.ModelMonitoringAlertConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.ModelMonitoringAlertConfig)
      com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.ModelMonitoringProto
          .internal_static_google_cloud_aiplatform_v1_ModelMonitoringAlertConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.ModelMonitoringProto
          .internal_static_google_cloud_aiplatform_v1_ModelMonitoringAlertConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.class,
              com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (emailAlertConfigBuilder_ != null) {
        emailAlertConfigBuilder_.clear();
      }
      enableLogging_ = false;
      notificationChannels_ = com.google.protobuf.LazyStringArrayList.emptyList();
      alertCase_ = 0;
      alert_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.ModelMonitoringProto
          .internal_static_google_cloud_aiplatform_v1_ModelMonitoringAlertConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig build() {
      com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig buildPartial() {
      com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig result =
          new com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.enableLogging_ = enableLogging_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        notificationChannels_.makeImmutable();
        result.notificationChannels_ = notificationChannels_;
      }
    }

    private void buildPartialOneofs(
        com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig result) {
      result.alertCase_ = alertCase_;
      result.alert_ = this.alert_;
      if (alertCase_ == 1 && emailAlertConfigBuilder_ != null) {
        result.alert_ = emailAlertConfigBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig) {
        return mergeFrom((com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig other) {
      if (other == com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.getDefaultInstance())
        return this;
      if (other.getEnableLogging() != false) {
        setEnableLogging(other.getEnableLogging());
      }
      if (!other.notificationChannels_.isEmpty()) {
        if (notificationChannels_.isEmpty()) {
          notificationChannels_ = other.notificationChannels_;
          bitField0_ |= 0x00000004;
        } else {
          ensureNotificationChannelsIsMutable();
          notificationChannels_.addAll(other.notificationChannels_);
        }
        onChanged();
      }
      switch (other.getAlertCase()) {
        case EMAIL_ALERT_CONFIG:
          {
            mergeEmailAlertConfig(other.getEmailAlertConfig());
            break;
          }
        case ALERT_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getEmailAlertConfigFieldBuilder().getBuilder(), extensionRegistry);
                alertCase_ = 1;
                break;
              } // case 10
            case 16:
              {
                enableLogging_ = input.readBool();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureNotificationChannelsIsMutable();
                notificationChannels_.add(s);
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int alertCase_ = 0;
    private java.lang.Object alert_;

    public AlertCase getAlertCase() {
      return AlertCase.forNumber(alertCase_);
    }

    public Builder clearAlert() {
      alertCase_ = 0;
      alert_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig,
            com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig.Builder,
            com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfigOrBuilder>
        emailAlertConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Email alert config.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig email_alert_config = 1;
     * </code>
     *
     * @return Whether the emailAlertConfig field is set.
     */
    @java.lang.Override
    public boolean hasEmailAlertConfig() {
      return alertCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Email alert config.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig email_alert_config = 1;
     * </code>
     *
     * @return The emailAlertConfig.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig
        getEmailAlertConfig() {
      if (emailAlertConfigBuilder_ == null) {
        if (alertCase_ == 1) {
          return (com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig)
              alert_;
        }
        return com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig
            .getDefaultInstance();
      } else {
        if (alertCase_ == 1) {
          return emailAlertConfigBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Email alert config.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig email_alert_config = 1;
     * </code>
     */
    public Builder setEmailAlertConfig(
        com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig value) {
      if (emailAlertConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        alert_ = value;
        onChanged();
      } else {
        emailAlertConfigBuilder_.setMessage(value);
      }
      alertCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Email alert config.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig email_alert_config = 1;
     * </code>
     */
    public Builder setEmailAlertConfig(
        com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig.Builder
            builderForValue) {
      if (emailAlertConfigBuilder_ == null) {
        alert_ = builderForValue.build();
        onChanged();
      } else {
        emailAlertConfigBuilder_.setMessage(builderForValue.build());
      }
      alertCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Email alert config.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig email_alert_config = 1;
     * </code>
     */
    public Builder mergeEmailAlertConfig(
        com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig value) {
      if (emailAlertConfigBuilder_ == null) {
        if (alertCase_ == 1
            && alert_
                != com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig
                    .getDefaultInstance()) {
          alert_ =
              com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig.newBuilder(
                      (com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig)
                          alert_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          alert_ = value;
        }
        onChanged();
      } else {
        if (alertCase_ == 1) {
          emailAlertConfigBuilder_.mergeFrom(value);
        } else {
          emailAlertConfigBuilder_.setMessage(value);
        }
      }
      alertCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Email alert config.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig email_alert_config = 1;
     * </code>
     */
    public Builder clearEmailAlertConfig() {
      if (emailAlertConfigBuilder_ == null) {
        if (alertCase_ == 1) {
          alertCase_ = 0;
          alert_ = null;
          onChanged();
        }
      } else {
        if (alertCase_ == 1) {
          alertCase_ = 0;
          alert_ = null;
        }
        emailAlertConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Email alert config.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig email_alert_config = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig.Builder
        getEmailAlertConfigBuilder() {
      return getEmailAlertConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Email alert config.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig email_alert_config = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfigOrBuilder
        getEmailAlertConfigOrBuilder() {
      if ((alertCase_ == 1) && (emailAlertConfigBuilder_ != null)) {
        return emailAlertConfigBuilder_.getMessageOrBuilder();
      } else {
        if (alertCase_ == 1) {
          return (com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig)
              alert_;
        }
        return com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Email alert config.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig email_alert_config = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig,
            com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig.Builder,
            com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfigOrBuilder>
        getEmailAlertConfigFieldBuilder() {
      if (emailAlertConfigBuilder_ == null) {
        if (!(alertCase_ == 1)) {
          alert_ =
              com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig
                  .getDefaultInstance();
        }
        emailAlertConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig,
                com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig.Builder,
                com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig
                    .EmailAlertConfigOrBuilder>(
                (com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig.EmailAlertConfig) alert_,
                getParentForChildren(),
                isClean());
        alert_ = null;
      }
      alertCase_ = 1;
      onChanged();
      return emailAlertConfigBuilder_;
    }

    private boolean enableLogging_;
    /**
     *
     *
     * <pre>
     * Dump the anomalies to Cloud Logging. The anomalies will be put to json
     * payload encoded from proto
     * [google.cloud.aiplatform.logging.ModelMonitoringAnomaliesLogEntry][].
     * This can be further sinked to Pub/Sub or any other services supported
     * by Cloud Logging.
     * </pre>
     *
     * <code>bool enable_logging = 2;</code>
     *
     * @return The enableLogging.
     */
    @java.lang.Override
    public boolean getEnableLogging() {
      return enableLogging_;
    }
    /**
     *
     *
     * <pre>
     * Dump the anomalies to Cloud Logging. The anomalies will be put to json
     * payload encoded from proto
     * [google.cloud.aiplatform.logging.ModelMonitoringAnomaliesLogEntry][].
     * This can be further sinked to Pub/Sub or any other services supported
     * by Cloud Logging.
     * </pre>
     *
     * <code>bool enable_logging = 2;</code>
     *
     * @param value The enableLogging to set.
     * @return This builder for chaining.
     */
    public Builder setEnableLogging(boolean value) {

      enableLogging_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Dump the anomalies to Cloud Logging. The anomalies will be put to json
     * payload encoded from proto
     * [google.cloud.aiplatform.logging.ModelMonitoringAnomaliesLogEntry][].
     * This can be further sinked to Pub/Sub or any other services supported
     * by Cloud Logging.
     * </pre>
     *
     * <code>bool enable_logging = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableLogging() {
      bitField0_ = (bitField0_ & ~0x00000002);
      enableLogging_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList notificationChannels_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureNotificationChannelsIsMutable() {
      if (!notificationChannels_.isModifiable()) {
        notificationChannels_ = new com.google.protobuf.LazyStringArrayList(notificationChannels_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * Resource names of the NotificationChannels to send alert.
     * Must be of the format
     * `projects/&lt;project_id_or_number&gt;/notificationChannels/&lt;channel_id&gt;`
     * </pre>
     *
     * <code>repeated string notification_channels = 3 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return A list containing the notificationChannels.
     */
    public com.google.protobuf.ProtocolStringList getNotificationChannelsList() {
      notificationChannels_.makeImmutable();
      return notificationChannels_;
    }
    /**
     *
     *
     * <pre>
     * Resource names of the NotificationChannels to send alert.
     * Must be of the format
     * `projects/&lt;project_id_or_number&gt;/notificationChannels/&lt;channel_id&gt;`
     * </pre>
     *
     * <code>repeated string notification_channels = 3 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The count of notificationChannels.
     */
    public int getNotificationChannelsCount() {
      return notificationChannels_.size();
    }
    /**
     *
     *
     * <pre>
     * Resource names of the NotificationChannels to send alert.
     * Must be of the format
     * `projects/&lt;project_id_or_number&gt;/notificationChannels/&lt;channel_id&gt;`
     * </pre>
     *
     * <code>repeated string notification_channels = 3 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index of the element to return.
     * @return The notificationChannels at the given index.
     */
    public java.lang.String getNotificationChannels(int index) {
      return notificationChannels_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Resource names of the NotificationChannels to send alert.
     * Must be of the format
     * `projects/&lt;project_id_or_number&gt;/notificationChannels/&lt;channel_id&gt;`
     * </pre>
     *
     * <code>repeated string notification_channels = 3 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the notificationChannels at the given index.
     */
    public com.google.protobuf.ByteString getNotificationChannelsBytes(int index) {
      return notificationChannels_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Resource names of the NotificationChannels to send alert.
     * Must be of the format
     * `projects/&lt;project_id_or_number&gt;/notificationChannels/&lt;channel_id&gt;`
     * </pre>
     *
     * <code>repeated string notification_channels = 3 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The notificationChannels to set.
     * @return This builder for chaining.
     */
    public Builder setNotificationChannels(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureNotificationChannelsIsMutable();
      notificationChannels_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource names of the NotificationChannels to send alert.
     * Must be of the format
     * `projects/&lt;project_id_or_number&gt;/notificationChannels/&lt;channel_id&gt;`
     * </pre>
     *
     * <code>repeated string notification_channels = 3 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The notificationChannels to add.
     * @return This builder for chaining.
     */
    public Builder addNotificationChannels(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureNotificationChannelsIsMutable();
      notificationChannels_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource names of the NotificationChannels to send alert.
     * Must be of the format
     * `projects/&lt;project_id_or_number&gt;/notificationChannels/&lt;channel_id&gt;`
     * </pre>
     *
     * <code>repeated string notification_channels = 3 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param values The notificationChannels to add.
     * @return This builder for chaining.
     */
    public Builder addAllNotificationChannels(java.lang.Iterable<java.lang.String> values) {
      ensureNotificationChannelsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, notificationChannels_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource names of the NotificationChannels to send alert.
     * Must be of the format
     * `projects/&lt;project_id_or_number&gt;/notificationChannels/&lt;channel_id&gt;`
     * </pre>
     *
     * <code>repeated string notification_channels = 3 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNotificationChannels() {
      notificationChannels_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource names of the NotificationChannels to send alert.
     * Must be of the format
     * `projects/&lt;project_id_or_number&gt;/notificationChannels/&lt;channel_id&gt;`
     * </pre>
     *
     * <code>repeated string notification_channels = 3 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes of the notificationChannels to add.
     * @return This builder for chaining.
     */
    public Builder addNotificationChannelsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureNotificationChannelsIsMutable();
      notificationChannels_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.ModelMonitoringAlertConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.ModelMonitoringAlertConfig)
  private static final com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig();
  }

  public static com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ModelMonitoringAlertConfig> PARSER =
      new com.google.protobuf.AbstractParser<ModelMonitoringAlertConfig>() {
        @java.lang.Override
        public ModelMonitoringAlertConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ModelMonitoringAlertConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ModelMonitoringAlertConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
