/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/evaluated_annotation.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * True positive, false positive, or false negative.
 *
 * EvaluatedAnnotation is only available under ModelEvaluationSlice with slice
 * of `annotationSpec` dimension.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.EvaluatedAnnotation}
 */
public final class EvaluatedAnnotation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.EvaluatedAnnotation)
    EvaluatedAnnotationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use EvaluatedAnnotation.newBuilder() to construct.
  private EvaluatedAnnotation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private EvaluatedAnnotation() {
    type_ = 0;
    predictions_ = java.util.Collections.emptyList();
    groundTruths_ = java.util.Collections.emptyList();
    evaluatedDataItemViewId_ = "";
    explanations_ = java.util.Collections.emptyList();
    errorAnalysisAnnotations_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new EvaluatedAnnotation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.EvaluatedAnnotationProto
        .internal_static_google_cloud_aiplatform_v1_EvaluatedAnnotation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.EvaluatedAnnotationProto
        .internal_static_google_cloud_aiplatform_v1_EvaluatedAnnotation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.EvaluatedAnnotation.class,
            com.google.cloud.aiplatform.v1.EvaluatedAnnotation.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Describes the type of the EvaluatedAnnotation. The type is determined
   * </pre>
   *
   * Protobuf enum {@code google.cloud.aiplatform.v1.EvaluatedAnnotation.EvaluatedAnnotationType}
   */
  public enum EvaluatedAnnotationType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Invalid value.
     * </pre>
     *
     * <code>EVALUATED_ANNOTATION_TYPE_UNSPECIFIED = 0;</code>
     */
    EVALUATED_ANNOTATION_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The EvaluatedAnnotation is a true positive. It has a prediction created
     * by the Model and a ground truth Annotation which the prediction matches.
     * </pre>
     *
     * <code>TRUE_POSITIVE = 1;</code>
     */
    TRUE_POSITIVE(1),
    /**
     *
     *
     * <pre>
     * The EvaluatedAnnotation is false positive. It has a prediction created by
     * the Model which does not match any ground truth annotation.
     * </pre>
     *
     * <code>FALSE_POSITIVE = 2;</code>
     */
    FALSE_POSITIVE(2),
    /**
     *
     *
     * <pre>
     * The EvaluatedAnnotation is false negative. It has a ground truth
     * annotation which is not matched by any of the model created predictions.
     * </pre>
     *
     * <code>FALSE_NEGATIVE = 3;</code>
     */
    FALSE_NEGATIVE(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Invalid value.
     * </pre>
     *
     * <code>EVALUATED_ANNOTATION_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int EVALUATED_ANNOTATION_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The EvaluatedAnnotation is a true positive. It has a prediction created
     * by the Model and a ground truth Annotation which the prediction matches.
     * </pre>
     *
     * <code>TRUE_POSITIVE = 1;</code>
     */
    public static final int TRUE_POSITIVE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The EvaluatedAnnotation is false positive. It has a prediction created by
     * the Model which does not match any ground truth annotation.
     * </pre>
     *
     * <code>FALSE_POSITIVE = 2;</code>
     */
    public static final int FALSE_POSITIVE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The EvaluatedAnnotation is false negative. It has a ground truth
     * annotation which is not matched by any of the model created predictions.
     * </pre>
     *
     * <code>FALSE_NEGATIVE = 3;</code>
     */
    public static final int FALSE_NEGATIVE_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static EvaluatedAnnotationType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static EvaluatedAnnotationType forNumber(int value) {
      switch (value) {
        case 0:
          return EVALUATED_ANNOTATION_TYPE_UNSPECIFIED;
        case 1:
          return TRUE_POSITIVE;
        case 2:
          return FALSE_POSITIVE;
        case 3:
          return FALSE_NEGATIVE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<EvaluatedAnnotationType>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<EvaluatedAnnotationType>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<EvaluatedAnnotationType>() {
              public EvaluatedAnnotationType findValueByNumber(int number) {
                return EvaluatedAnnotationType.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.EvaluatedAnnotation.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final EvaluatedAnnotationType[] VALUES = values();

    public static EvaluatedAnnotationType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private EvaluatedAnnotationType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1.EvaluatedAnnotation.EvaluatedAnnotationType)
  }

  private int bitField0_;
  public static final int TYPE_FIELD_NUMBER = 1;
  private int type_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. Type of the EvaluatedAnnotation.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.EvaluatedAnnotation.EvaluatedAnnotationType type = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Type of the EvaluatedAnnotation.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.EvaluatedAnnotation.EvaluatedAnnotationType type = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.EvaluatedAnnotation.EvaluatedAnnotationType getType() {
    com.google.cloud.aiplatform.v1.EvaluatedAnnotation.EvaluatedAnnotationType result =
        com.google.cloud.aiplatform.v1.EvaluatedAnnotation.EvaluatedAnnotationType.forNumber(type_);
    return result == null
        ? com.google.cloud.aiplatform.v1.EvaluatedAnnotation.EvaluatedAnnotationType.UNRECOGNIZED
        : result;
  }

  public static final int PREDICTIONS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.protobuf.Value> predictions_;
  /**
   *
   *
   * <pre>
   * Output only. The model predicted annotations.
   *
   * For true positive, there is one and only one prediction, which matches the
   * only one ground truth annotation in
   * [ground_truths][google.cloud.aiplatform.v1.EvaluatedAnnotation.ground_truths].
   *
   * For false positive, there is one and only one prediction, which doesn't
   * match any ground truth annotation of the corresponding
   * [data_item_view_id][EvaluatedAnnotation.data_item_view_id].
   *
   * For false negative, there are zero or more predictions which are similar to
   * the only ground truth annotation in
   * [ground_truths][google.cloud.aiplatform.v1.EvaluatedAnnotation.ground_truths]
   * but not enough for a match.
   *
   * The schema of the prediction is stored in
   * [ModelEvaluation.annotation_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.annotation_schema_uri]
   * </pre>
   *
   * <code>
   * repeated .google.protobuf.Value predictions = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.protobuf.Value> getPredictionsList() {
    return predictions_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The model predicted annotations.
   *
   * For true positive, there is one and only one prediction, which matches the
   * only one ground truth annotation in
   * [ground_truths][google.cloud.aiplatform.v1.EvaluatedAnnotation.ground_truths].
   *
   * For false positive, there is one and only one prediction, which doesn't
   * match any ground truth annotation of the corresponding
   * [data_item_view_id][EvaluatedAnnotation.data_item_view_id].
   *
   * For false negative, there are zero or more predictions which are similar to
   * the only ground truth annotation in
   * [ground_truths][google.cloud.aiplatform.v1.EvaluatedAnnotation.ground_truths]
   * but not enough for a match.
   *
   * The schema of the prediction is stored in
   * [ModelEvaluation.annotation_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.annotation_schema_uri]
   * </pre>
   *
   * <code>
   * repeated .google.protobuf.Value predictions = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.protobuf.ValueOrBuilder>
      getPredictionsOrBuilderList() {
    return predictions_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The model predicted annotations.
   *
   * For true positive, there is one and only one prediction, which matches the
   * only one ground truth annotation in
   * [ground_truths][google.cloud.aiplatform.v1.EvaluatedAnnotation.ground_truths].
   *
   * For false positive, there is one and only one prediction, which doesn't
   * match any ground truth annotation of the corresponding
   * [data_item_view_id][EvaluatedAnnotation.data_item_view_id].
   *
   * For false negative, there are zero or more predictions which are similar to
   * the only ground truth annotation in
   * [ground_truths][google.cloud.aiplatform.v1.EvaluatedAnnotation.ground_truths]
   * but not enough for a match.
   *
   * The schema of the prediction is stored in
   * [ModelEvaluation.annotation_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.annotation_schema_uri]
   * </pre>
   *
   * <code>
   * repeated .google.protobuf.Value predictions = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getPredictionsCount() {
    return predictions_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The model predicted annotations.
   *
   * For true positive, there is one and only one prediction, which matches the
   * only one ground truth annotation in
   * [ground_truths][google.cloud.aiplatform.v1.EvaluatedAnnotation.ground_truths].
   *
   * For false positive, there is one and only one prediction, which doesn't
   * match any ground truth annotation of the corresponding
   * [data_item_view_id][EvaluatedAnnotation.data_item_view_id].
   *
   * For false negative, there are zero or more predictions which are similar to
   * the only ground truth annotation in
   * [ground_truths][google.cloud.aiplatform.v1.EvaluatedAnnotation.ground_truths]
   * but not enough for a match.
   *
   * The schema of the prediction is stored in
   * [ModelEvaluation.annotation_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.annotation_schema_uri]
   * </pre>
   *
   * <code>
   * repeated .google.protobuf.Value predictions = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.Value getPredictions(int index) {
    return predictions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The model predicted annotations.
   *
   * For true positive, there is one and only one prediction, which matches the
   * only one ground truth annotation in
   * [ground_truths][google.cloud.aiplatform.v1.EvaluatedAnnotation.ground_truths].
   *
   * For false positive, there is one and only one prediction, which doesn't
   * match any ground truth annotation of the corresponding
   * [data_item_view_id][EvaluatedAnnotation.data_item_view_id].
   *
   * For false negative, there are zero or more predictions which are similar to
   * the only ground truth annotation in
   * [ground_truths][google.cloud.aiplatform.v1.EvaluatedAnnotation.ground_truths]
   * but not enough for a match.
   *
   * The schema of the prediction is stored in
   * [ModelEvaluation.annotation_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.annotation_schema_uri]
   * </pre>
   *
   * <code>
   * repeated .google.protobuf.Value predictions = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.ValueOrBuilder getPredictionsOrBuilder(int index) {
    return predictions_.get(index);
  }

  public static final int GROUND_TRUTHS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.protobuf.Value> groundTruths_;
  /**
   *
   *
   * <pre>
   * Output only. The ground truth Annotations, i.e. the Annotations that exist
   * in the test data the Model is evaluated on.
   *
   * For true positive, there is one and only one ground truth annotation, which
   * matches the only prediction in
   * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions].
   *
   * For false positive, there are zero or more ground truth annotations that
   * are similar to the only prediction in
   * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions],
   * but not enough for a match.
   *
   * For false negative, there is one and only one ground truth annotation,
   * which doesn't match any predictions created by the model.
   *
   * The schema of the ground truth is stored in
   * [ModelEvaluation.annotation_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.annotation_schema_uri]
   * </pre>
   *
   * <code>
   * repeated .google.protobuf.Value ground_truths = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.protobuf.Value> getGroundTruthsList() {
    return groundTruths_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The ground truth Annotations, i.e. the Annotations that exist
   * in the test data the Model is evaluated on.
   *
   * For true positive, there is one and only one ground truth annotation, which
   * matches the only prediction in
   * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions].
   *
   * For false positive, there are zero or more ground truth annotations that
   * are similar to the only prediction in
   * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions],
   * but not enough for a match.
   *
   * For false negative, there is one and only one ground truth annotation,
   * which doesn't match any predictions created by the model.
   *
   * The schema of the ground truth is stored in
   * [ModelEvaluation.annotation_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.annotation_schema_uri]
   * </pre>
   *
   * <code>
   * repeated .google.protobuf.Value ground_truths = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.protobuf.ValueOrBuilder>
      getGroundTruthsOrBuilderList() {
    return groundTruths_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The ground truth Annotations, i.e. the Annotations that exist
   * in the test data the Model is evaluated on.
   *
   * For true positive, there is one and only one ground truth annotation, which
   * matches the only prediction in
   * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions].
   *
   * For false positive, there are zero or more ground truth annotations that
   * are similar to the only prediction in
   * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions],
   * but not enough for a match.
   *
   * For false negative, there is one and only one ground truth annotation,
   * which doesn't match any predictions created by the model.
   *
   * The schema of the ground truth is stored in
   * [ModelEvaluation.annotation_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.annotation_schema_uri]
   * </pre>
   *
   * <code>
   * repeated .google.protobuf.Value ground_truths = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getGroundTruthsCount() {
    return groundTruths_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The ground truth Annotations, i.e. the Annotations that exist
   * in the test data the Model is evaluated on.
   *
   * For true positive, there is one and only one ground truth annotation, which
   * matches the only prediction in
   * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions].
   *
   * For false positive, there are zero or more ground truth annotations that
   * are similar to the only prediction in
   * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions],
   * but not enough for a match.
   *
   * For false negative, there is one and only one ground truth annotation,
   * which doesn't match any predictions created by the model.
   *
   * The schema of the ground truth is stored in
   * [ModelEvaluation.annotation_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.annotation_schema_uri]
   * </pre>
   *
   * <code>
   * repeated .google.protobuf.Value ground_truths = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.Value getGroundTruths(int index) {
    return groundTruths_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The ground truth Annotations, i.e. the Annotations that exist
   * in the test data the Model is evaluated on.
   *
   * For true positive, there is one and only one ground truth annotation, which
   * matches the only prediction in
   * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions].
   *
   * For false positive, there are zero or more ground truth annotations that
   * are similar to the only prediction in
   * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions],
   * but not enough for a match.
   *
   * For false negative, there is one and only one ground truth annotation,
   * which doesn't match any predictions created by the model.
   *
   * The schema of the ground truth is stored in
   * [ModelEvaluation.annotation_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.annotation_schema_uri]
   * </pre>
   *
   * <code>
   * repeated .google.protobuf.Value ground_truths = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.ValueOrBuilder getGroundTruthsOrBuilder(int index) {
    return groundTruths_.get(index);
  }

  public static final int DATA_ITEM_PAYLOAD_FIELD_NUMBER = 5;
  private com.google.protobuf.Value dataItemPayload_;
  /**
   *
   *
   * <pre>
   * Output only. The data item payload that the Model predicted this
   * EvaluatedAnnotation on.
   * </pre>
   *
   * <code>
   * .google.protobuf.Value data_item_payload = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the dataItemPayload field is set.
   */
  @java.lang.Override
  public boolean hasDataItemPayload() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The data item payload that the Model predicted this
   * EvaluatedAnnotation on.
   * </pre>
   *
   * <code>
   * .google.protobuf.Value data_item_payload = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The dataItemPayload.
   */
  @java.lang.Override
  public com.google.protobuf.Value getDataItemPayload() {
    return dataItemPayload_ == null
        ? com.google.protobuf.Value.getDefaultInstance()
        : dataItemPayload_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The data item payload that the Model predicted this
   * EvaluatedAnnotation on.
   * </pre>
   *
   * <code>
   * .google.protobuf.Value data_item_payload = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.ValueOrBuilder getDataItemPayloadOrBuilder() {
    return dataItemPayload_ == null
        ? com.google.protobuf.Value.getDefaultInstance()
        : dataItemPayload_;
  }

  public static final int EVALUATED_DATA_ITEM_VIEW_ID_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object evaluatedDataItemViewId_ = "";
  /**
   *
   *
   * <pre>
   * Output only. ID of the EvaluatedDataItemView under the same ancestor
   * ModelEvaluation. The EvaluatedDataItemView consists of all ground truths
   * and predictions on
   * [data_item_payload][google.cloud.aiplatform.v1.EvaluatedAnnotation.data_item_payload].
   * </pre>
   *
   * <code>string evaluated_data_item_view_id = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The evaluatedDataItemViewId.
   */
  @java.lang.Override
  public java.lang.String getEvaluatedDataItemViewId() {
    java.lang.Object ref = evaluatedDataItemViewId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      evaluatedDataItemViewId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. ID of the EvaluatedDataItemView under the same ancestor
   * ModelEvaluation. The EvaluatedDataItemView consists of all ground truths
   * and predictions on
   * [data_item_payload][google.cloud.aiplatform.v1.EvaluatedAnnotation.data_item_payload].
   * </pre>
   *
   * <code>string evaluated_data_item_view_id = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for evaluatedDataItemViewId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEvaluatedDataItemViewIdBytes() {
    java.lang.Object ref = evaluatedDataItemViewId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      evaluatedDataItemViewId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXPLANATIONS_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation>
      explanations_;
  /**
   *
   *
   * <pre>
   * Explanations of
   * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions].
   * Each element of the explanations indicates the explanation for one
   * explanation Method.
   *
   * The attributions list in the
   * [EvaluatedAnnotationExplanation.explanation][google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation.explanation]
   * object corresponds to the
   * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions]
   * list. For example, the second element in the attributions list explains the
   * second element in the predictions list.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation explanations = 8;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation>
      getExplanationsList() {
    return explanations_;
  }
  /**
   *
   *
   * <pre>
   * Explanations of
   * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions].
   * Each element of the explanations indicates the explanation for one
   * explanation Method.
   *
   * The attributions list in the
   * [EvaluatedAnnotationExplanation.explanation][google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation.explanation]
   * object corresponds to the
   * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions]
   * list. For example, the second element in the attributions list explains the
   * second element in the predictions list.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation explanations = 8;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.aiplatform.v1.EvaluatedAnnotationExplanationOrBuilder>
      getExplanationsOrBuilderList() {
    return explanations_;
  }
  /**
   *
   *
   * <pre>
   * Explanations of
   * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions].
   * Each element of the explanations indicates the explanation for one
   * explanation Method.
   *
   * The attributions list in the
   * [EvaluatedAnnotationExplanation.explanation][google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation.explanation]
   * object corresponds to the
   * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions]
   * list. For example, the second element in the attributions list explains the
   * second element in the predictions list.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation explanations = 8;
   * </code>
   */
  @java.lang.Override
  public int getExplanationsCount() {
    return explanations_.size();
  }
  /**
   *
   *
   * <pre>
   * Explanations of
   * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions].
   * Each element of the explanations indicates the explanation for one
   * explanation Method.
   *
   * The attributions list in the
   * [EvaluatedAnnotationExplanation.explanation][google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation.explanation]
   * object corresponds to the
   * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions]
   * list. For example, the second element in the attributions list explains the
   * second element in the predictions list.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation explanations = 8;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation getExplanations(int index) {
    return explanations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Explanations of
   * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions].
   * Each element of the explanations indicates the explanation for one
   * explanation Method.
   *
   * The attributions list in the
   * [EvaluatedAnnotationExplanation.explanation][google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation.explanation]
   * object corresponds to the
   * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions]
   * list. For example, the second element in the attributions list explains the
   * second element in the predictions list.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation explanations = 8;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.EvaluatedAnnotationExplanationOrBuilder
      getExplanationsOrBuilder(int index) {
    return explanations_.get(index);
  }

  public static final int ERROR_ANALYSIS_ANNOTATIONS_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation>
      errorAnalysisAnnotations_;
  /**
   *
   *
   * <pre>
   * Annotations of model error analysis results.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ErrorAnalysisAnnotation error_analysis_annotations = 9;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation>
      getErrorAnalysisAnnotationsList() {
    return errorAnalysisAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * Annotations of model error analysis results.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ErrorAnalysisAnnotation error_analysis_annotations = 9;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotationOrBuilder>
      getErrorAnalysisAnnotationsOrBuilderList() {
    return errorAnalysisAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * Annotations of model error analysis results.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ErrorAnalysisAnnotation error_analysis_annotations = 9;
   * </code>
   */
  @java.lang.Override
  public int getErrorAnalysisAnnotationsCount() {
    return errorAnalysisAnnotations_.size();
  }
  /**
   *
   *
   * <pre>
   * Annotations of model error analysis results.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ErrorAnalysisAnnotation error_analysis_annotations = 9;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation getErrorAnalysisAnnotations(
      int index) {
    return errorAnalysisAnnotations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Annotations of model error analysis results.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ErrorAnalysisAnnotation error_analysis_annotations = 9;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotationOrBuilder
      getErrorAnalysisAnnotationsOrBuilder(int index) {
    return errorAnalysisAnnotations_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (type_
        != com.google.cloud.aiplatform.v1.EvaluatedAnnotation.EvaluatedAnnotationType
            .EVALUATED_ANNOTATION_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, type_);
    }
    for (int i = 0; i < predictions_.size(); i++) {
      output.writeMessage(2, predictions_.get(i));
    }
    for (int i = 0; i < groundTruths_.size(); i++) {
      output.writeMessage(3, groundTruths_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getDataItemPayload());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(evaluatedDataItemViewId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, evaluatedDataItemViewId_);
    }
    for (int i = 0; i < explanations_.size(); i++) {
      output.writeMessage(8, explanations_.get(i));
    }
    for (int i = 0; i < errorAnalysisAnnotations_.size(); i++) {
      output.writeMessage(9, errorAnalysisAnnotations_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (type_
        != com.google.cloud.aiplatform.v1.EvaluatedAnnotation.EvaluatedAnnotationType
            .EVALUATED_ANNOTATION_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, type_);
    }
    for (int i = 0; i < predictions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, predictions_.get(i));
    }
    for (int i = 0; i < groundTruths_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, groundTruths_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getDataItemPayload());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(evaluatedDataItemViewId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, evaluatedDataItemViewId_);
    }
    for (int i = 0; i < explanations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, explanations_.get(i));
    }
    for (int i = 0; i < errorAnalysisAnnotations_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9, errorAnalysisAnnotations_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.EvaluatedAnnotation)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.EvaluatedAnnotation other =
        (com.google.cloud.aiplatform.v1.EvaluatedAnnotation) obj;

    if (type_ != other.type_) return false;
    if (!getPredictionsList().equals(other.getPredictionsList())) return false;
    if (!getGroundTruthsList().equals(other.getGroundTruthsList())) return false;
    if (hasDataItemPayload() != other.hasDataItemPayload()) return false;
    if (hasDataItemPayload()) {
      if (!getDataItemPayload().equals(other.getDataItemPayload())) return false;
    }
    if (!getEvaluatedDataItemViewId().equals(other.getEvaluatedDataItemViewId())) return false;
    if (!getExplanationsList().equals(other.getExplanationsList())) return false;
    if (!getErrorAnalysisAnnotationsList().equals(other.getErrorAnalysisAnnotationsList()))
      return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    if (getPredictionsCount() > 0) {
      hash = (37 * hash) + PREDICTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getPredictionsList().hashCode();
    }
    if (getGroundTruthsCount() > 0) {
      hash = (37 * hash) + GROUND_TRUTHS_FIELD_NUMBER;
      hash = (53 * hash) + getGroundTruthsList().hashCode();
    }
    if (hasDataItemPayload()) {
      hash = (37 * hash) + DATA_ITEM_PAYLOAD_FIELD_NUMBER;
      hash = (53 * hash) + getDataItemPayload().hashCode();
    }
    hash = (37 * hash) + EVALUATED_DATA_ITEM_VIEW_ID_FIELD_NUMBER;
    hash = (53 * hash) + getEvaluatedDataItemViewId().hashCode();
    if (getExplanationsCount() > 0) {
      hash = (37 * hash) + EXPLANATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getExplanationsList().hashCode();
    }
    if (getErrorAnalysisAnnotationsCount() > 0) {
      hash = (37 * hash) + ERROR_ANALYSIS_ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getErrorAnalysisAnnotationsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.EvaluatedAnnotation parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.EvaluatedAnnotation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.EvaluatedAnnotation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.EvaluatedAnnotation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.EvaluatedAnnotation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.EvaluatedAnnotation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.EvaluatedAnnotation parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.EvaluatedAnnotation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.EvaluatedAnnotation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.EvaluatedAnnotation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.EvaluatedAnnotation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.EvaluatedAnnotation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.EvaluatedAnnotation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * True positive, false positive, or false negative.
   *
   * EvaluatedAnnotation is only available under ModelEvaluationSlice with slice
   * of `annotationSpec` dimension.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.EvaluatedAnnotation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.EvaluatedAnnotation)
      com.google.cloud.aiplatform.v1.EvaluatedAnnotationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.EvaluatedAnnotationProto
          .internal_static_google_cloud_aiplatform_v1_EvaluatedAnnotation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.EvaluatedAnnotationProto
          .internal_static_google_cloud_aiplatform_v1_EvaluatedAnnotation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.EvaluatedAnnotation.class,
              com.google.cloud.aiplatform.v1.EvaluatedAnnotation.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.EvaluatedAnnotation.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getPredictionsFieldBuilder();
        getGroundTruthsFieldBuilder();
        getDataItemPayloadFieldBuilder();
        getExplanationsFieldBuilder();
        getErrorAnalysisAnnotationsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      type_ = 0;
      if (predictionsBuilder_ == null) {
        predictions_ = java.util.Collections.emptyList();
      } else {
        predictions_ = null;
        predictionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      if (groundTruthsBuilder_ == null) {
        groundTruths_ = java.util.Collections.emptyList();
      } else {
        groundTruths_ = null;
        groundTruthsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      dataItemPayload_ = null;
      if (dataItemPayloadBuilder_ != null) {
        dataItemPayloadBuilder_.dispose();
        dataItemPayloadBuilder_ = null;
      }
      evaluatedDataItemViewId_ = "";
      if (explanationsBuilder_ == null) {
        explanations_ = java.util.Collections.emptyList();
      } else {
        explanations_ = null;
        explanationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      if (errorAnalysisAnnotationsBuilder_ == null) {
        errorAnalysisAnnotations_ = java.util.Collections.emptyList();
      } else {
        errorAnalysisAnnotations_ = null;
        errorAnalysisAnnotationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000040);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.EvaluatedAnnotationProto
          .internal_static_google_cloud_aiplatform_v1_EvaluatedAnnotation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.EvaluatedAnnotation getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.EvaluatedAnnotation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.EvaluatedAnnotation build() {
      com.google.cloud.aiplatform.v1.EvaluatedAnnotation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.EvaluatedAnnotation buildPartial() {
      com.google.cloud.aiplatform.v1.EvaluatedAnnotation result =
          new com.google.cloud.aiplatform.v1.EvaluatedAnnotation(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1.EvaluatedAnnotation result) {
      if (predictionsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          predictions_ = java.util.Collections.unmodifiableList(predictions_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.predictions_ = predictions_;
      } else {
        result.predictions_ = predictionsBuilder_.build();
      }
      if (groundTruthsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          groundTruths_ = java.util.Collections.unmodifiableList(groundTruths_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.groundTruths_ = groundTruths_;
      } else {
        result.groundTruths_ = groundTruthsBuilder_.build();
      }
      if (explanationsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          explanations_ = java.util.Collections.unmodifiableList(explanations_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.explanations_ = explanations_;
      } else {
        result.explanations_ = explanationsBuilder_.build();
      }
      if (errorAnalysisAnnotationsBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)) {
          errorAnalysisAnnotations_ =
              java.util.Collections.unmodifiableList(errorAnalysisAnnotations_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.errorAnalysisAnnotations_ = errorAnalysisAnnotations_;
      } else {
        result.errorAnalysisAnnotations_ = errorAnalysisAnnotationsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.EvaluatedAnnotation result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.type_ = type_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.dataItemPayload_ =
            dataItemPayloadBuilder_ == null ? dataItemPayload_ : dataItemPayloadBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.evaluatedDataItemViewId_ = evaluatedDataItemViewId_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.EvaluatedAnnotation) {
        return mergeFrom((com.google.cloud.aiplatform.v1.EvaluatedAnnotation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.EvaluatedAnnotation other) {
      if (other == com.google.cloud.aiplatform.v1.EvaluatedAnnotation.getDefaultInstance())
        return this;
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (predictionsBuilder_ == null) {
        if (!other.predictions_.isEmpty()) {
          if (predictions_.isEmpty()) {
            predictions_ = other.predictions_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensurePredictionsIsMutable();
            predictions_.addAll(other.predictions_);
          }
          onChanged();
        }
      } else {
        if (!other.predictions_.isEmpty()) {
          if (predictionsBuilder_.isEmpty()) {
            predictionsBuilder_.dispose();
            predictionsBuilder_ = null;
            predictions_ = other.predictions_;
            bitField0_ = (bitField0_ & ~0x00000002);
            predictionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPredictionsFieldBuilder()
                    : null;
          } else {
            predictionsBuilder_.addAllMessages(other.predictions_);
          }
        }
      }
      if (groundTruthsBuilder_ == null) {
        if (!other.groundTruths_.isEmpty()) {
          if (groundTruths_.isEmpty()) {
            groundTruths_ = other.groundTruths_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureGroundTruthsIsMutable();
            groundTruths_.addAll(other.groundTruths_);
          }
          onChanged();
        }
      } else {
        if (!other.groundTruths_.isEmpty()) {
          if (groundTruthsBuilder_.isEmpty()) {
            groundTruthsBuilder_.dispose();
            groundTruthsBuilder_ = null;
            groundTruths_ = other.groundTruths_;
            bitField0_ = (bitField0_ & ~0x00000004);
            groundTruthsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getGroundTruthsFieldBuilder()
                    : null;
          } else {
            groundTruthsBuilder_.addAllMessages(other.groundTruths_);
          }
        }
      }
      if (other.hasDataItemPayload()) {
        mergeDataItemPayload(other.getDataItemPayload());
      }
      if (!other.getEvaluatedDataItemViewId().isEmpty()) {
        evaluatedDataItemViewId_ = other.evaluatedDataItemViewId_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (explanationsBuilder_ == null) {
        if (!other.explanations_.isEmpty()) {
          if (explanations_.isEmpty()) {
            explanations_ = other.explanations_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureExplanationsIsMutable();
            explanations_.addAll(other.explanations_);
          }
          onChanged();
        }
      } else {
        if (!other.explanations_.isEmpty()) {
          if (explanationsBuilder_.isEmpty()) {
            explanationsBuilder_.dispose();
            explanationsBuilder_ = null;
            explanations_ = other.explanations_;
            bitField0_ = (bitField0_ & ~0x00000020);
            explanationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getExplanationsFieldBuilder()
                    : null;
          } else {
            explanationsBuilder_.addAllMessages(other.explanations_);
          }
        }
      }
      if (errorAnalysisAnnotationsBuilder_ == null) {
        if (!other.errorAnalysisAnnotations_.isEmpty()) {
          if (errorAnalysisAnnotations_.isEmpty()) {
            errorAnalysisAnnotations_ = other.errorAnalysisAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000040);
          } else {
            ensureErrorAnalysisAnnotationsIsMutable();
            errorAnalysisAnnotations_.addAll(other.errorAnalysisAnnotations_);
          }
          onChanged();
        }
      } else {
        if (!other.errorAnalysisAnnotations_.isEmpty()) {
          if (errorAnalysisAnnotationsBuilder_.isEmpty()) {
            errorAnalysisAnnotationsBuilder_.dispose();
            errorAnalysisAnnotationsBuilder_ = null;
            errorAnalysisAnnotations_ = other.errorAnalysisAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000040);
            errorAnalysisAnnotationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getErrorAnalysisAnnotationsFieldBuilder()
                    : null;
          } else {
            errorAnalysisAnnotationsBuilder_.addAllMessages(other.errorAnalysisAnnotations_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                type_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                com.google.protobuf.Value m =
                    input.readMessage(com.google.protobuf.Value.parser(), extensionRegistry);
                if (predictionsBuilder_ == null) {
                  ensurePredictionsIsMutable();
                  predictions_.add(m);
                } else {
                  predictionsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                com.google.protobuf.Value m =
                    input.readMessage(com.google.protobuf.Value.parser(), extensionRegistry);
                if (groundTruthsBuilder_ == null) {
                  ensureGroundTruthsIsMutable();
                  groundTruths_.add(m);
                } else {
                  groundTruthsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 42:
              {
                input.readMessage(getDataItemPayloadFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            case 50:
              {
                evaluatedDataItemViewId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            case 66:
              {
                com.google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation.parser(),
                        extensionRegistry);
                if (explanationsBuilder_ == null) {
                  ensureExplanationsIsMutable();
                  explanations_.add(m);
                } else {
                  explanationsBuilder_.addMessage(m);
                }
                break;
              } // case 66
            case 74:
              {
                com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.parser(),
                        extensionRegistry);
                if (errorAnalysisAnnotationsBuilder_ == null) {
                  ensureErrorAnalysisAnnotationsIsMutable();
                  errorAnalysisAnnotations_.add(m);
                } else {
                  errorAnalysisAnnotationsBuilder_.addMessage(m);
                }
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Type of the EvaluatedAnnotation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.EvaluatedAnnotation.EvaluatedAnnotationType type = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Type of the EvaluatedAnnotation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.EvaluatedAnnotation.EvaluatedAnnotationType type = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Type of the EvaluatedAnnotation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.EvaluatedAnnotation.EvaluatedAnnotationType type = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.EvaluatedAnnotation.EvaluatedAnnotationType getType() {
      com.google.cloud.aiplatform.v1.EvaluatedAnnotation.EvaluatedAnnotationType result =
          com.google.cloud.aiplatform.v1.EvaluatedAnnotation.EvaluatedAnnotationType.forNumber(
              type_);
      return result == null
          ? com.google.cloud.aiplatform.v1.EvaluatedAnnotation.EvaluatedAnnotationType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. Type of the EvaluatedAnnotation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.EvaluatedAnnotation.EvaluatedAnnotationType type = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(
        com.google.cloud.aiplatform.v1.EvaluatedAnnotation.EvaluatedAnnotationType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Type of the EvaluatedAnnotation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.EvaluatedAnnotation.EvaluatedAnnotationType type = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000001);
      type_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.protobuf.Value> predictions_ =
        java.util.Collections.emptyList();

    private void ensurePredictionsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        predictions_ = new java.util.ArrayList<com.google.protobuf.Value>(predictions_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        predictionsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The model predicted annotations.
     *
     * For true positive, there is one and only one prediction, which matches the
     * only one ground truth annotation in
     * [ground_truths][google.cloud.aiplatform.v1.EvaluatedAnnotation.ground_truths].
     *
     * For false positive, there is one and only one prediction, which doesn't
     * match any ground truth annotation of the corresponding
     * [data_item_view_id][EvaluatedAnnotation.data_item_view_id].
     *
     * For false negative, there are zero or more predictions which are similar to
     * the only ground truth annotation in
     * [ground_truths][google.cloud.aiplatform.v1.EvaluatedAnnotation.ground_truths]
     * but not enough for a match.
     *
     * The schema of the prediction is stored in
     * [ModelEvaluation.annotation_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.annotation_schema_uri]
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value predictions = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.protobuf.Value> getPredictionsList() {
      if (predictionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(predictions_);
      } else {
        return predictionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The model predicted annotations.
     *
     * For true positive, there is one and only one prediction, which matches the
     * only one ground truth annotation in
     * [ground_truths][google.cloud.aiplatform.v1.EvaluatedAnnotation.ground_truths].
     *
     * For false positive, there is one and only one prediction, which doesn't
     * match any ground truth annotation of the corresponding
     * [data_item_view_id][EvaluatedAnnotation.data_item_view_id].
     *
     * For false negative, there are zero or more predictions which are similar to
     * the only ground truth annotation in
     * [ground_truths][google.cloud.aiplatform.v1.EvaluatedAnnotation.ground_truths]
     * but not enough for a match.
     *
     * The schema of the prediction is stored in
     * [ModelEvaluation.annotation_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.annotation_schema_uri]
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value predictions = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getPredictionsCount() {
      if (predictionsBuilder_ == null) {
        return predictions_.size();
      } else {
        return predictionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The model predicted annotations.
     *
     * For true positive, there is one and only one prediction, which matches the
     * only one ground truth annotation in
     * [ground_truths][google.cloud.aiplatform.v1.EvaluatedAnnotation.ground_truths].
     *
     * For false positive, there is one and only one prediction, which doesn't
     * match any ground truth annotation of the corresponding
     * [data_item_view_id][EvaluatedAnnotation.data_item_view_id].
     *
     * For false negative, there are zero or more predictions which are similar to
     * the only ground truth annotation in
     * [ground_truths][google.cloud.aiplatform.v1.EvaluatedAnnotation.ground_truths]
     * but not enough for a match.
     *
     * The schema of the prediction is stored in
     * [ModelEvaluation.annotation_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.annotation_schema_uri]
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value predictions = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Value getPredictions(int index) {
      if (predictionsBuilder_ == null) {
        return predictions_.get(index);
      } else {
        return predictionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The model predicted annotations.
     *
     * For true positive, there is one and only one prediction, which matches the
     * only one ground truth annotation in
     * [ground_truths][google.cloud.aiplatform.v1.EvaluatedAnnotation.ground_truths].
     *
     * For false positive, there is one and only one prediction, which doesn't
     * match any ground truth annotation of the corresponding
     * [data_item_view_id][EvaluatedAnnotation.data_item_view_id].
     *
     * For false negative, there are zero or more predictions which are similar to
     * the only ground truth annotation in
     * [ground_truths][google.cloud.aiplatform.v1.EvaluatedAnnotation.ground_truths]
     * but not enough for a match.
     *
     * The schema of the prediction is stored in
     * [ModelEvaluation.annotation_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.annotation_schema_uri]
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value predictions = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPredictions(int index, com.google.protobuf.Value value) {
      if (predictionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePredictionsIsMutable();
        predictions_.set(index, value);
        onChanged();
      } else {
        predictionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The model predicted annotations.
     *
     * For true positive, there is one and only one prediction, which matches the
     * only one ground truth annotation in
     * [ground_truths][google.cloud.aiplatform.v1.EvaluatedAnnotation.ground_truths].
     *
     * For false positive, there is one and only one prediction, which doesn't
     * match any ground truth annotation of the corresponding
     * [data_item_view_id][EvaluatedAnnotation.data_item_view_id].
     *
     * For false negative, there are zero or more predictions which are similar to
     * the only ground truth annotation in
     * [ground_truths][google.cloud.aiplatform.v1.EvaluatedAnnotation.ground_truths]
     * but not enough for a match.
     *
     * The schema of the prediction is stored in
     * [ModelEvaluation.annotation_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.annotation_schema_uri]
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value predictions = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPredictions(int index, com.google.protobuf.Value.Builder builderForValue) {
      if (predictionsBuilder_ == null) {
        ensurePredictionsIsMutable();
        predictions_.set(index, builderForValue.build());
        onChanged();
      } else {
        predictionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The model predicted annotations.
     *
     * For true positive, there is one and only one prediction, which matches the
     * only one ground truth annotation in
     * [ground_truths][google.cloud.aiplatform.v1.EvaluatedAnnotation.ground_truths].
     *
     * For false positive, there is one and only one prediction, which doesn't
     * match any ground truth annotation of the corresponding
     * [data_item_view_id][EvaluatedAnnotation.data_item_view_id].
     *
     * For false negative, there are zero or more predictions which are similar to
     * the only ground truth annotation in
     * [ground_truths][google.cloud.aiplatform.v1.EvaluatedAnnotation.ground_truths]
     * but not enough for a match.
     *
     * The schema of the prediction is stored in
     * [ModelEvaluation.annotation_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.annotation_schema_uri]
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value predictions = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addPredictions(com.google.protobuf.Value value) {
      if (predictionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePredictionsIsMutable();
        predictions_.add(value);
        onChanged();
      } else {
        predictionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The model predicted annotations.
     *
     * For true positive, there is one and only one prediction, which matches the
     * only one ground truth annotation in
     * [ground_truths][google.cloud.aiplatform.v1.EvaluatedAnnotation.ground_truths].
     *
     * For false positive, there is one and only one prediction, which doesn't
     * match any ground truth annotation of the corresponding
     * [data_item_view_id][EvaluatedAnnotation.data_item_view_id].
     *
     * For false negative, there are zero or more predictions which are similar to
     * the only ground truth annotation in
     * [ground_truths][google.cloud.aiplatform.v1.EvaluatedAnnotation.ground_truths]
     * but not enough for a match.
     *
     * The schema of the prediction is stored in
     * [ModelEvaluation.annotation_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.annotation_schema_uri]
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value predictions = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addPredictions(int index, com.google.protobuf.Value value) {
      if (predictionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePredictionsIsMutable();
        predictions_.add(index, value);
        onChanged();
      } else {
        predictionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The model predicted annotations.
     *
     * For true positive, there is one and only one prediction, which matches the
     * only one ground truth annotation in
     * [ground_truths][google.cloud.aiplatform.v1.EvaluatedAnnotation.ground_truths].
     *
     * For false positive, there is one and only one prediction, which doesn't
     * match any ground truth annotation of the corresponding
     * [data_item_view_id][EvaluatedAnnotation.data_item_view_id].
     *
     * For false negative, there are zero or more predictions which are similar to
     * the only ground truth annotation in
     * [ground_truths][google.cloud.aiplatform.v1.EvaluatedAnnotation.ground_truths]
     * but not enough for a match.
     *
     * The schema of the prediction is stored in
     * [ModelEvaluation.annotation_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.annotation_schema_uri]
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value predictions = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addPredictions(com.google.protobuf.Value.Builder builderForValue) {
      if (predictionsBuilder_ == null) {
        ensurePredictionsIsMutable();
        predictions_.add(builderForValue.build());
        onChanged();
      } else {
        predictionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The model predicted annotations.
     *
     * For true positive, there is one and only one prediction, which matches the
     * only one ground truth annotation in
     * [ground_truths][google.cloud.aiplatform.v1.EvaluatedAnnotation.ground_truths].
     *
     * For false positive, there is one and only one prediction, which doesn't
     * match any ground truth annotation of the corresponding
     * [data_item_view_id][EvaluatedAnnotation.data_item_view_id].
     *
     * For false negative, there are zero or more predictions which are similar to
     * the only ground truth annotation in
     * [ground_truths][google.cloud.aiplatform.v1.EvaluatedAnnotation.ground_truths]
     * but not enough for a match.
     *
     * The schema of the prediction is stored in
     * [ModelEvaluation.annotation_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.annotation_schema_uri]
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value predictions = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addPredictions(int index, com.google.protobuf.Value.Builder builderForValue) {
      if (predictionsBuilder_ == null) {
        ensurePredictionsIsMutable();
        predictions_.add(index, builderForValue.build());
        onChanged();
      } else {
        predictionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The model predicted annotations.
     *
     * For true positive, there is one and only one prediction, which matches the
     * only one ground truth annotation in
     * [ground_truths][google.cloud.aiplatform.v1.EvaluatedAnnotation.ground_truths].
     *
     * For false positive, there is one and only one prediction, which doesn't
     * match any ground truth annotation of the corresponding
     * [data_item_view_id][EvaluatedAnnotation.data_item_view_id].
     *
     * For false negative, there are zero or more predictions which are similar to
     * the only ground truth annotation in
     * [ground_truths][google.cloud.aiplatform.v1.EvaluatedAnnotation.ground_truths]
     * but not enough for a match.
     *
     * The schema of the prediction is stored in
     * [ModelEvaluation.annotation_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.annotation_schema_uri]
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value predictions = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllPredictions(
        java.lang.Iterable<? extends com.google.protobuf.Value> values) {
      if (predictionsBuilder_ == null) {
        ensurePredictionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, predictions_);
        onChanged();
      } else {
        predictionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The model predicted annotations.
     *
     * For true positive, there is one and only one prediction, which matches the
     * only one ground truth annotation in
     * [ground_truths][google.cloud.aiplatform.v1.EvaluatedAnnotation.ground_truths].
     *
     * For false positive, there is one and only one prediction, which doesn't
     * match any ground truth annotation of the corresponding
     * [data_item_view_id][EvaluatedAnnotation.data_item_view_id].
     *
     * For false negative, there are zero or more predictions which are similar to
     * the only ground truth annotation in
     * [ground_truths][google.cloud.aiplatform.v1.EvaluatedAnnotation.ground_truths]
     * but not enough for a match.
     *
     * The schema of the prediction is stored in
     * [ModelEvaluation.annotation_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.annotation_schema_uri]
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value predictions = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearPredictions() {
      if (predictionsBuilder_ == null) {
        predictions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        predictionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The model predicted annotations.
     *
     * For true positive, there is one and only one prediction, which matches the
     * only one ground truth annotation in
     * [ground_truths][google.cloud.aiplatform.v1.EvaluatedAnnotation.ground_truths].
     *
     * For false positive, there is one and only one prediction, which doesn't
     * match any ground truth annotation of the corresponding
     * [data_item_view_id][EvaluatedAnnotation.data_item_view_id].
     *
     * For false negative, there are zero or more predictions which are similar to
     * the only ground truth annotation in
     * [ground_truths][google.cloud.aiplatform.v1.EvaluatedAnnotation.ground_truths]
     * but not enough for a match.
     *
     * The schema of the prediction is stored in
     * [ModelEvaluation.annotation_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.annotation_schema_uri]
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value predictions = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removePredictions(int index) {
      if (predictionsBuilder_ == null) {
        ensurePredictionsIsMutable();
        predictions_.remove(index);
        onChanged();
      } else {
        predictionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The model predicted annotations.
     *
     * For true positive, there is one and only one prediction, which matches the
     * only one ground truth annotation in
     * [ground_truths][google.cloud.aiplatform.v1.EvaluatedAnnotation.ground_truths].
     *
     * For false positive, there is one and only one prediction, which doesn't
     * match any ground truth annotation of the corresponding
     * [data_item_view_id][EvaluatedAnnotation.data_item_view_id].
     *
     * For false negative, there are zero or more predictions which are similar to
     * the only ground truth annotation in
     * [ground_truths][google.cloud.aiplatform.v1.EvaluatedAnnotation.ground_truths]
     * but not enough for a match.
     *
     * The schema of the prediction is stored in
     * [ModelEvaluation.annotation_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.annotation_schema_uri]
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value predictions = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Value.Builder getPredictionsBuilder(int index) {
      return getPredictionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The model predicted annotations.
     *
     * For true positive, there is one and only one prediction, which matches the
     * only one ground truth annotation in
     * [ground_truths][google.cloud.aiplatform.v1.EvaluatedAnnotation.ground_truths].
     *
     * For false positive, there is one and only one prediction, which doesn't
     * match any ground truth annotation of the corresponding
     * [data_item_view_id][EvaluatedAnnotation.data_item_view_id].
     *
     * For false negative, there are zero or more predictions which are similar to
     * the only ground truth annotation in
     * [ground_truths][google.cloud.aiplatform.v1.EvaluatedAnnotation.ground_truths]
     * but not enough for a match.
     *
     * The schema of the prediction is stored in
     * [ModelEvaluation.annotation_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.annotation_schema_uri]
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value predictions = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.ValueOrBuilder getPredictionsOrBuilder(int index) {
      if (predictionsBuilder_ == null) {
        return predictions_.get(index);
      } else {
        return predictionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The model predicted annotations.
     *
     * For true positive, there is one and only one prediction, which matches the
     * only one ground truth annotation in
     * [ground_truths][google.cloud.aiplatform.v1.EvaluatedAnnotation.ground_truths].
     *
     * For false positive, there is one and only one prediction, which doesn't
     * match any ground truth annotation of the corresponding
     * [data_item_view_id][EvaluatedAnnotation.data_item_view_id].
     *
     * For false negative, there are zero or more predictions which are similar to
     * the only ground truth annotation in
     * [ground_truths][google.cloud.aiplatform.v1.EvaluatedAnnotation.ground_truths]
     * but not enough for a match.
     *
     * The schema of the prediction is stored in
     * [ModelEvaluation.annotation_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.annotation_schema_uri]
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value predictions = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.protobuf.ValueOrBuilder>
        getPredictionsOrBuilderList() {
      if (predictionsBuilder_ != null) {
        return predictionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(predictions_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The model predicted annotations.
     *
     * For true positive, there is one and only one prediction, which matches the
     * only one ground truth annotation in
     * [ground_truths][google.cloud.aiplatform.v1.EvaluatedAnnotation.ground_truths].
     *
     * For false positive, there is one and only one prediction, which doesn't
     * match any ground truth annotation of the corresponding
     * [data_item_view_id][EvaluatedAnnotation.data_item_view_id].
     *
     * For false negative, there are zero or more predictions which are similar to
     * the only ground truth annotation in
     * [ground_truths][google.cloud.aiplatform.v1.EvaluatedAnnotation.ground_truths]
     * but not enough for a match.
     *
     * The schema of the prediction is stored in
     * [ModelEvaluation.annotation_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.annotation_schema_uri]
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value predictions = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Value.Builder addPredictionsBuilder() {
      return getPredictionsFieldBuilder()
          .addBuilder(com.google.protobuf.Value.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The model predicted annotations.
     *
     * For true positive, there is one and only one prediction, which matches the
     * only one ground truth annotation in
     * [ground_truths][google.cloud.aiplatform.v1.EvaluatedAnnotation.ground_truths].
     *
     * For false positive, there is one and only one prediction, which doesn't
     * match any ground truth annotation of the corresponding
     * [data_item_view_id][EvaluatedAnnotation.data_item_view_id].
     *
     * For false negative, there are zero or more predictions which are similar to
     * the only ground truth annotation in
     * [ground_truths][google.cloud.aiplatform.v1.EvaluatedAnnotation.ground_truths]
     * but not enough for a match.
     *
     * The schema of the prediction is stored in
     * [ModelEvaluation.annotation_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.annotation_schema_uri]
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value predictions = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Value.Builder addPredictionsBuilder(int index) {
      return getPredictionsFieldBuilder()
          .addBuilder(index, com.google.protobuf.Value.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The model predicted annotations.
     *
     * For true positive, there is one and only one prediction, which matches the
     * only one ground truth annotation in
     * [ground_truths][google.cloud.aiplatform.v1.EvaluatedAnnotation.ground_truths].
     *
     * For false positive, there is one and only one prediction, which doesn't
     * match any ground truth annotation of the corresponding
     * [data_item_view_id][EvaluatedAnnotation.data_item_view_id].
     *
     * For false negative, there are zero or more predictions which are similar to
     * the only ground truth annotation in
     * [ground_truths][google.cloud.aiplatform.v1.EvaluatedAnnotation.ground_truths]
     * but not enough for a match.
     *
     * The schema of the prediction is stored in
     * [ModelEvaluation.annotation_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.annotation_schema_uri]
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value predictions = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.protobuf.Value.Builder> getPredictionsBuilderList() {
      return getPredictionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        getPredictionsFieldBuilder() {
      if (predictionsBuilder_ == null) {
        predictionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.protobuf.Value,
                com.google.protobuf.Value.Builder,
                com.google.protobuf.ValueOrBuilder>(
                predictions_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        predictions_ = null;
      }
      return predictionsBuilder_;
    }

    private java.util.List<com.google.protobuf.Value> groundTruths_ =
        java.util.Collections.emptyList();

    private void ensureGroundTruthsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        groundTruths_ = new java.util.ArrayList<com.google.protobuf.Value>(groundTruths_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        groundTruthsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The ground truth Annotations, i.e. the Annotations that exist
     * in the test data the Model is evaluated on.
     *
     * For true positive, there is one and only one ground truth annotation, which
     * matches the only prediction in
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions].
     *
     * For false positive, there are zero or more ground truth annotations that
     * are similar to the only prediction in
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions],
     * but not enough for a match.
     *
     * For false negative, there is one and only one ground truth annotation,
     * which doesn't match any predictions created by the model.
     *
     * The schema of the ground truth is stored in
     * [ModelEvaluation.annotation_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.annotation_schema_uri]
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value ground_truths = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.protobuf.Value> getGroundTruthsList() {
      if (groundTruthsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(groundTruths_);
      } else {
        return groundTruthsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The ground truth Annotations, i.e. the Annotations that exist
     * in the test data the Model is evaluated on.
     *
     * For true positive, there is one and only one ground truth annotation, which
     * matches the only prediction in
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions].
     *
     * For false positive, there are zero or more ground truth annotations that
     * are similar to the only prediction in
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions],
     * but not enough for a match.
     *
     * For false negative, there is one and only one ground truth annotation,
     * which doesn't match any predictions created by the model.
     *
     * The schema of the ground truth is stored in
     * [ModelEvaluation.annotation_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.annotation_schema_uri]
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value ground_truths = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getGroundTruthsCount() {
      if (groundTruthsBuilder_ == null) {
        return groundTruths_.size();
      } else {
        return groundTruthsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The ground truth Annotations, i.e. the Annotations that exist
     * in the test data the Model is evaluated on.
     *
     * For true positive, there is one and only one ground truth annotation, which
     * matches the only prediction in
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions].
     *
     * For false positive, there are zero or more ground truth annotations that
     * are similar to the only prediction in
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions],
     * but not enough for a match.
     *
     * For false negative, there is one and only one ground truth annotation,
     * which doesn't match any predictions created by the model.
     *
     * The schema of the ground truth is stored in
     * [ModelEvaluation.annotation_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.annotation_schema_uri]
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value ground_truths = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Value getGroundTruths(int index) {
      if (groundTruthsBuilder_ == null) {
        return groundTruths_.get(index);
      } else {
        return groundTruthsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The ground truth Annotations, i.e. the Annotations that exist
     * in the test data the Model is evaluated on.
     *
     * For true positive, there is one and only one ground truth annotation, which
     * matches the only prediction in
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions].
     *
     * For false positive, there are zero or more ground truth annotations that
     * are similar to the only prediction in
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions],
     * but not enough for a match.
     *
     * For false negative, there is one and only one ground truth annotation,
     * which doesn't match any predictions created by the model.
     *
     * The schema of the ground truth is stored in
     * [ModelEvaluation.annotation_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.annotation_schema_uri]
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value ground_truths = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setGroundTruths(int index, com.google.protobuf.Value value) {
      if (groundTruthsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGroundTruthsIsMutable();
        groundTruths_.set(index, value);
        onChanged();
      } else {
        groundTruthsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The ground truth Annotations, i.e. the Annotations that exist
     * in the test data the Model is evaluated on.
     *
     * For true positive, there is one and only one ground truth annotation, which
     * matches the only prediction in
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions].
     *
     * For false positive, there are zero or more ground truth annotations that
     * are similar to the only prediction in
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions],
     * but not enough for a match.
     *
     * For false negative, there is one and only one ground truth annotation,
     * which doesn't match any predictions created by the model.
     *
     * The schema of the ground truth is stored in
     * [ModelEvaluation.annotation_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.annotation_schema_uri]
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value ground_truths = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setGroundTruths(int index, com.google.protobuf.Value.Builder builderForValue) {
      if (groundTruthsBuilder_ == null) {
        ensureGroundTruthsIsMutable();
        groundTruths_.set(index, builderForValue.build());
        onChanged();
      } else {
        groundTruthsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The ground truth Annotations, i.e. the Annotations that exist
     * in the test data the Model is evaluated on.
     *
     * For true positive, there is one and only one ground truth annotation, which
     * matches the only prediction in
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions].
     *
     * For false positive, there are zero or more ground truth annotations that
     * are similar to the only prediction in
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions],
     * but not enough for a match.
     *
     * For false negative, there is one and only one ground truth annotation,
     * which doesn't match any predictions created by the model.
     *
     * The schema of the ground truth is stored in
     * [ModelEvaluation.annotation_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.annotation_schema_uri]
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value ground_truths = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addGroundTruths(com.google.protobuf.Value value) {
      if (groundTruthsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGroundTruthsIsMutable();
        groundTruths_.add(value);
        onChanged();
      } else {
        groundTruthsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The ground truth Annotations, i.e. the Annotations that exist
     * in the test data the Model is evaluated on.
     *
     * For true positive, there is one and only one ground truth annotation, which
     * matches the only prediction in
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions].
     *
     * For false positive, there are zero or more ground truth annotations that
     * are similar to the only prediction in
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions],
     * but not enough for a match.
     *
     * For false negative, there is one and only one ground truth annotation,
     * which doesn't match any predictions created by the model.
     *
     * The schema of the ground truth is stored in
     * [ModelEvaluation.annotation_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.annotation_schema_uri]
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value ground_truths = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addGroundTruths(int index, com.google.protobuf.Value value) {
      if (groundTruthsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGroundTruthsIsMutable();
        groundTruths_.add(index, value);
        onChanged();
      } else {
        groundTruthsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The ground truth Annotations, i.e. the Annotations that exist
     * in the test data the Model is evaluated on.
     *
     * For true positive, there is one and only one ground truth annotation, which
     * matches the only prediction in
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions].
     *
     * For false positive, there are zero or more ground truth annotations that
     * are similar to the only prediction in
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions],
     * but not enough for a match.
     *
     * For false negative, there is one and only one ground truth annotation,
     * which doesn't match any predictions created by the model.
     *
     * The schema of the ground truth is stored in
     * [ModelEvaluation.annotation_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.annotation_schema_uri]
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value ground_truths = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addGroundTruths(com.google.protobuf.Value.Builder builderForValue) {
      if (groundTruthsBuilder_ == null) {
        ensureGroundTruthsIsMutable();
        groundTruths_.add(builderForValue.build());
        onChanged();
      } else {
        groundTruthsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The ground truth Annotations, i.e. the Annotations that exist
     * in the test data the Model is evaluated on.
     *
     * For true positive, there is one and only one ground truth annotation, which
     * matches the only prediction in
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions].
     *
     * For false positive, there are zero or more ground truth annotations that
     * are similar to the only prediction in
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions],
     * but not enough for a match.
     *
     * For false negative, there is one and only one ground truth annotation,
     * which doesn't match any predictions created by the model.
     *
     * The schema of the ground truth is stored in
     * [ModelEvaluation.annotation_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.annotation_schema_uri]
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value ground_truths = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addGroundTruths(int index, com.google.protobuf.Value.Builder builderForValue) {
      if (groundTruthsBuilder_ == null) {
        ensureGroundTruthsIsMutable();
        groundTruths_.add(index, builderForValue.build());
        onChanged();
      } else {
        groundTruthsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The ground truth Annotations, i.e. the Annotations that exist
     * in the test data the Model is evaluated on.
     *
     * For true positive, there is one and only one ground truth annotation, which
     * matches the only prediction in
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions].
     *
     * For false positive, there are zero or more ground truth annotations that
     * are similar to the only prediction in
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions],
     * but not enough for a match.
     *
     * For false negative, there is one and only one ground truth annotation,
     * which doesn't match any predictions created by the model.
     *
     * The schema of the ground truth is stored in
     * [ModelEvaluation.annotation_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.annotation_schema_uri]
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value ground_truths = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllGroundTruths(
        java.lang.Iterable<? extends com.google.protobuf.Value> values) {
      if (groundTruthsBuilder_ == null) {
        ensureGroundTruthsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, groundTruths_);
        onChanged();
      } else {
        groundTruthsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The ground truth Annotations, i.e. the Annotations that exist
     * in the test data the Model is evaluated on.
     *
     * For true positive, there is one and only one ground truth annotation, which
     * matches the only prediction in
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions].
     *
     * For false positive, there are zero or more ground truth annotations that
     * are similar to the only prediction in
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions],
     * but not enough for a match.
     *
     * For false negative, there is one and only one ground truth annotation,
     * which doesn't match any predictions created by the model.
     *
     * The schema of the ground truth is stored in
     * [ModelEvaluation.annotation_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.annotation_schema_uri]
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value ground_truths = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearGroundTruths() {
      if (groundTruthsBuilder_ == null) {
        groundTruths_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        groundTruthsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The ground truth Annotations, i.e. the Annotations that exist
     * in the test data the Model is evaluated on.
     *
     * For true positive, there is one and only one ground truth annotation, which
     * matches the only prediction in
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions].
     *
     * For false positive, there are zero or more ground truth annotations that
     * are similar to the only prediction in
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions],
     * but not enough for a match.
     *
     * For false negative, there is one and only one ground truth annotation,
     * which doesn't match any predictions created by the model.
     *
     * The schema of the ground truth is stored in
     * [ModelEvaluation.annotation_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.annotation_schema_uri]
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value ground_truths = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeGroundTruths(int index) {
      if (groundTruthsBuilder_ == null) {
        ensureGroundTruthsIsMutable();
        groundTruths_.remove(index);
        onChanged();
      } else {
        groundTruthsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The ground truth Annotations, i.e. the Annotations that exist
     * in the test data the Model is evaluated on.
     *
     * For true positive, there is one and only one ground truth annotation, which
     * matches the only prediction in
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions].
     *
     * For false positive, there are zero or more ground truth annotations that
     * are similar to the only prediction in
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions],
     * but not enough for a match.
     *
     * For false negative, there is one and only one ground truth annotation,
     * which doesn't match any predictions created by the model.
     *
     * The schema of the ground truth is stored in
     * [ModelEvaluation.annotation_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.annotation_schema_uri]
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value ground_truths = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Value.Builder getGroundTruthsBuilder(int index) {
      return getGroundTruthsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The ground truth Annotations, i.e. the Annotations that exist
     * in the test data the Model is evaluated on.
     *
     * For true positive, there is one and only one ground truth annotation, which
     * matches the only prediction in
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions].
     *
     * For false positive, there are zero or more ground truth annotations that
     * are similar to the only prediction in
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions],
     * but not enough for a match.
     *
     * For false negative, there is one and only one ground truth annotation,
     * which doesn't match any predictions created by the model.
     *
     * The schema of the ground truth is stored in
     * [ModelEvaluation.annotation_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.annotation_schema_uri]
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value ground_truths = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.ValueOrBuilder getGroundTruthsOrBuilder(int index) {
      if (groundTruthsBuilder_ == null) {
        return groundTruths_.get(index);
      } else {
        return groundTruthsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The ground truth Annotations, i.e. the Annotations that exist
     * in the test data the Model is evaluated on.
     *
     * For true positive, there is one and only one ground truth annotation, which
     * matches the only prediction in
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions].
     *
     * For false positive, there are zero or more ground truth annotations that
     * are similar to the only prediction in
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions],
     * but not enough for a match.
     *
     * For false negative, there is one and only one ground truth annotation,
     * which doesn't match any predictions created by the model.
     *
     * The schema of the ground truth is stored in
     * [ModelEvaluation.annotation_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.annotation_schema_uri]
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value ground_truths = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.protobuf.ValueOrBuilder>
        getGroundTruthsOrBuilderList() {
      if (groundTruthsBuilder_ != null) {
        return groundTruthsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(groundTruths_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The ground truth Annotations, i.e. the Annotations that exist
     * in the test data the Model is evaluated on.
     *
     * For true positive, there is one and only one ground truth annotation, which
     * matches the only prediction in
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions].
     *
     * For false positive, there are zero or more ground truth annotations that
     * are similar to the only prediction in
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions],
     * but not enough for a match.
     *
     * For false negative, there is one and only one ground truth annotation,
     * which doesn't match any predictions created by the model.
     *
     * The schema of the ground truth is stored in
     * [ModelEvaluation.annotation_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.annotation_schema_uri]
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value ground_truths = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Value.Builder addGroundTruthsBuilder() {
      return getGroundTruthsFieldBuilder()
          .addBuilder(com.google.protobuf.Value.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The ground truth Annotations, i.e. the Annotations that exist
     * in the test data the Model is evaluated on.
     *
     * For true positive, there is one and only one ground truth annotation, which
     * matches the only prediction in
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions].
     *
     * For false positive, there are zero or more ground truth annotations that
     * are similar to the only prediction in
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions],
     * but not enough for a match.
     *
     * For false negative, there is one and only one ground truth annotation,
     * which doesn't match any predictions created by the model.
     *
     * The schema of the ground truth is stored in
     * [ModelEvaluation.annotation_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.annotation_schema_uri]
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value ground_truths = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Value.Builder addGroundTruthsBuilder(int index) {
      return getGroundTruthsFieldBuilder()
          .addBuilder(index, com.google.protobuf.Value.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The ground truth Annotations, i.e. the Annotations that exist
     * in the test data the Model is evaluated on.
     *
     * For true positive, there is one and only one ground truth annotation, which
     * matches the only prediction in
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions].
     *
     * For false positive, there are zero or more ground truth annotations that
     * are similar to the only prediction in
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions],
     * but not enough for a match.
     *
     * For false negative, there is one and only one ground truth annotation,
     * which doesn't match any predictions created by the model.
     *
     * The schema of the ground truth is stored in
     * [ModelEvaluation.annotation_schema_uri][google.cloud.aiplatform.v1.ModelEvaluation.annotation_schema_uri]
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Value ground_truths = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.protobuf.Value.Builder> getGroundTruthsBuilderList() {
      return getGroundTruthsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        getGroundTruthsFieldBuilder() {
      if (groundTruthsBuilder_ == null) {
        groundTruthsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.protobuf.Value,
                com.google.protobuf.Value.Builder,
                com.google.protobuf.ValueOrBuilder>(
                groundTruths_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        groundTruths_ = null;
      }
      return groundTruthsBuilder_;
    }

    private com.google.protobuf.Value dataItemPayload_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        dataItemPayloadBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The data item payload that the Model predicted this
     * EvaluatedAnnotation on.
     * </pre>
     *
     * <code>
     * .google.protobuf.Value data_item_payload = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the dataItemPayload field is set.
     */
    public boolean hasDataItemPayload() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The data item payload that the Model predicted this
     * EvaluatedAnnotation on.
     * </pre>
     *
     * <code>
     * .google.protobuf.Value data_item_payload = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The dataItemPayload.
     */
    public com.google.protobuf.Value getDataItemPayload() {
      if (dataItemPayloadBuilder_ == null) {
        return dataItemPayload_ == null
            ? com.google.protobuf.Value.getDefaultInstance()
            : dataItemPayload_;
      } else {
        return dataItemPayloadBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The data item payload that the Model predicted this
     * EvaluatedAnnotation on.
     * </pre>
     *
     * <code>
     * .google.protobuf.Value data_item_payload = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDataItemPayload(com.google.protobuf.Value value) {
      if (dataItemPayloadBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataItemPayload_ = value;
      } else {
        dataItemPayloadBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The data item payload that the Model predicted this
     * EvaluatedAnnotation on.
     * </pre>
     *
     * <code>
     * .google.protobuf.Value data_item_payload = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDataItemPayload(com.google.protobuf.Value.Builder builderForValue) {
      if (dataItemPayloadBuilder_ == null) {
        dataItemPayload_ = builderForValue.build();
      } else {
        dataItemPayloadBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The data item payload that the Model predicted this
     * EvaluatedAnnotation on.
     * </pre>
     *
     * <code>
     * .google.protobuf.Value data_item_payload = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDataItemPayload(com.google.protobuf.Value value) {
      if (dataItemPayloadBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && dataItemPayload_ != null
            && dataItemPayload_ != com.google.protobuf.Value.getDefaultInstance()) {
          getDataItemPayloadBuilder().mergeFrom(value);
        } else {
          dataItemPayload_ = value;
        }
      } else {
        dataItemPayloadBuilder_.mergeFrom(value);
      }
      if (dataItemPayload_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The data item payload that the Model predicted this
     * EvaluatedAnnotation on.
     * </pre>
     *
     * <code>
     * .google.protobuf.Value data_item_payload = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDataItemPayload() {
      bitField0_ = (bitField0_ & ~0x00000008);
      dataItemPayload_ = null;
      if (dataItemPayloadBuilder_ != null) {
        dataItemPayloadBuilder_.dispose();
        dataItemPayloadBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The data item payload that the Model predicted this
     * EvaluatedAnnotation on.
     * </pre>
     *
     * <code>
     * .google.protobuf.Value data_item_payload = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Value.Builder getDataItemPayloadBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getDataItemPayloadFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The data item payload that the Model predicted this
     * EvaluatedAnnotation on.
     * </pre>
     *
     * <code>
     * .google.protobuf.Value data_item_payload = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.ValueOrBuilder getDataItemPayloadOrBuilder() {
      if (dataItemPayloadBuilder_ != null) {
        return dataItemPayloadBuilder_.getMessageOrBuilder();
      } else {
        return dataItemPayload_ == null
            ? com.google.protobuf.Value.getDefaultInstance()
            : dataItemPayload_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The data item payload that the Model predicted this
     * EvaluatedAnnotation on.
     * </pre>
     *
     * <code>
     * .google.protobuf.Value data_item_payload = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        getDataItemPayloadFieldBuilder() {
      if (dataItemPayloadBuilder_ == null) {
        dataItemPayloadBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Value,
                com.google.protobuf.Value.Builder,
                com.google.protobuf.ValueOrBuilder>(
                getDataItemPayload(), getParentForChildren(), isClean());
        dataItemPayload_ = null;
      }
      return dataItemPayloadBuilder_;
    }

    private java.lang.Object evaluatedDataItemViewId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. ID of the EvaluatedDataItemView under the same ancestor
     * ModelEvaluation. The EvaluatedDataItemView consists of all ground truths
     * and predictions on
     * [data_item_payload][google.cloud.aiplatform.v1.EvaluatedAnnotation.data_item_payload].
     * </pre>
     *
     * <code>string evaluated_data_item_view_id = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The evaluatedDataItemViewId.
     */
    public java.lang.String getEvaluatedDataItemViewId() {
      java.lang.Object ref = evaluatedDataItemViewId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        evaluatedDataItemViewId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. ID of the EvaluatedDataItemView under the same ancestor
     * ModelEvaluation. The EvaluatedDataItemView consists of all ground truths
     * and predictions on
     * [data_item_payload][google.cloud.aiplatform.v1.EvaluatedAnnotation.data_item_payload].
     * </pre>
     *
     * <code>string evaluated_data_item_view_id = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for evaluatedDataItemViewId.
     */
    public com.google.protobuf.ByteString getEvaluatedDataItemViewIdBytes() {
      java.lang.Object ref = evaluatedDataItemViewId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        evaluatedDataItemViewId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. ID of the EvaluatedDataItemView under the same ancestor
     * ModelEvaluation. The EvaluatedDataItemView consists of all ground truths
     * and predictions on
     * [data_item_payload][google.cloud.aiplatform.v1.EvaluatedAnnotation.data_item_payload].
     * </pre>
     *
     * <code>string evaluated_data_item_view_id = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The evaluatedDataItemViewId to set.
     * @return This builder for chaining.
     */
    public Builder setEvaluatedDataItemViewId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      evaluatedDataItemViewId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. ID of the EvaluatedDataItemView under the same ancestor
     * ModelEvaluation. The EvaluatedDataItemView consists of all ground truths
     * and predictions on
     * [data_item_payload][google.cloud.aiplatform.v1.EvaluatedAnnotation.data_item_payload].
     * </pre>
     *
     * <code>string evaluated_data_item_view_id = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEvaluatedDataItemViewId() {
      evaluatedDataItemViewId_ = getDefaultInstance().getEvaluatedDataItemViewId();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. ID of the EvaluatedDataItemView under the same ancestor
     * ModelEvaluation. The EvaluatedDataItemView consists of all ground truths
     * and predictions on
     * [data_item_payload][google.cloud.aiplatform.v1.EvaluatedAnnotation.data_item_payload].
     * </pre>
     *
     * <code>string evaluated_data_item_view_id = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for evaluatedDataItemViewId to set.
     * @return This builder for chaining.
     */
    public Builder setEvaluatedDataItemViewIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      evaluatedDataItemViewId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation>
        explanations_ = java.util.Collections.emptyList();

    private void ensureExplanationsIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        explanations_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation>(
                explanations_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation,
            com.google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation.Builder,
            com.google.cloud.aiplatform.v1.EvaluatedAnnotationExplanationOrBuilder>
        explanationsBuilder_;

    /**
     *
     *
     * <pre>
     * Explanations of
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions].
     * Each element of the explanations indicates the explanation for one
     * explanation Method.
     *
     * The attributions list in the
     * [EvaluatedAnnotationExplanation.explanation][google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation.explanation]
     * object corresponds to the
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions]
     * list. For example, the second element in the attributions list explains the
     * second element in the predictions list.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation explanations = 8;
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation>
        getExplanationsList() {
      if (explanationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(explanations_);
      } else {
        return explanationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Explanations of
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions].
     * Each element of the explanations indicates the explanation for one
     * explanation Method.
     *
     * The attributions list in the
     * [EvaluatedAnnotationExplanation.explanation][google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation.explanation]
     * object corresponds to the
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions]
     * list. For example, the second element in the attributions list explains the
     * second element in the predictions list.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation explanations = 8;
     * </code>
     */
    public int getExplanationsCount() {
      if (explanationsBuilder_ == null) {
        return explanations_.size();
      } else {
        return explanationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Explanations of
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions].
     * Each element of the explanations indicates the explanation for one
     * explanation Method.
     *
     * The attributions list in the
     * [EvaluatedAnnotationExplanation.explanation][google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation.explanation]
     * object corresponds to the
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions]
     * list. For example, the second element in the attributions list explains the
     * second element in the predictions list.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation explanations = 8;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation getExplanations(
        int index) {
      if (explanationsBuilder_ == null) {
        return explanations_.get(index);
      } else {
        return explanationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Explanations of
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions].
     * Each element of the explanations indicates the explanation for one
     * explanation Method.
     *
     * The attributions list in the
     * [EvaluatedAnnotationExplanation.explanation][google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation.explanation]
     * object corresponds to the
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions]
     * list. For example, the second element in the attributions list explains the
     * second element in the predictions list.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation explanations = 8;
     * </code>
     */
    public Builder setExplanations(
        int index, com.google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation value) {
      if (explanationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExplanationsIsMutable();
        explanations_.set(index, value);
        onChanged();
      } else {
        explanationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Explanations of
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions].
     * Each element of the explanations indicates the explanation for one
     * explanation Method.
     *
     * The attributions list in the
     * [EvaluatedAnnotationExplanation.explanation][google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation.explanation]
     * object corresponds to the
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions]
     * list. For example, the second element in the attributions list explains the
     * second element in the predictions list.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation explanations = 8;
     * </code>
     */
    public Builder setExplanations(
        int index,
        com.google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation.Builder builderForValue) {
      if (explanationsBuilder_ == null) {
        ensureExplanationsIsMutable();
        explanations_.set(index, builderForValue.build());
        onChanged();
      } else {
        explanationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Explanations of
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions].
     * Each element of the explanations indicates the explanation for one
     * explanation Method.
     *
     * The attributions list in the
     * [EvaluatedAnnotationExplanation.explanation][google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation.explanation]
     * object corresponds to the
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions]
     * list. For example, the second element in the attributions list explains the
     * second element in the predictions list.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation explanations = 8;
     * </code>
     */
    public Builder addExplanations(
        com.google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation value) {
      if (explanationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExplanationsIsMutable();
        explanations_.add(value);
        onChanged();
      } else {
        explanationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Explanations of
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions].
     * Each element of the explanations indicates the explanation for one
     * explanation Method.
     *
     * The attributions list in the
     * [EvaluatedAnnotationExplanation.explanation][google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation.explanation]
     * object corresponds to the
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions]
     * list. For example, the second element in the attributions list explains the
     * second element in the predictions list.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation explanations = 8;
     * </code>
     */
    public Builder addExplanations(
        int index, com.google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation value) {
      if (explanationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExplanationsIsMutable();
        explanations_.add(index, value);
        onChanged();
      } else {
        explanationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Explanations of
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions].
     * Each element of the explanations indicates the explanation for one
     * explanation Method.
     *
     * The attributions list in the
     * [EvaluatedAnnotationExplanation.explanation][google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation.explanation]
     * object corresponds to the
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions]
     * list. For example, the second element in the attributions list explains the
     * second element in the predictions list.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation explanations = 8;
     * </code>
     */
    public Builder addExplanations(
        com.google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation.Builder builderForValue) {
      if (explanationsBuilder_ == null) {
        ensureExplanationsIsMutable();
        explanations_.add(builderForValue.build());
        onChanged();
      } else {
        explanationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Explanations of
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions].
     * Each element of the explanations indicates the explanation for one
     * explanation Method.
     *
     * The attributions list in the
     * [EvaluatedAnnotationExplanation.explanation][google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation.explanation]
     * object corresponds to the
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions]
     * list. For example, the second element in the attributions list explains the
     * second element in the predictions list.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation explanations = 8;
     * </code>
     */
    public Builder addExplanations(
        int index,
        com.google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation.Builder builderForValue) {
      if (explanationsBuilder_ == null) {
        ensureExplanationsIsMutable();
        explanations_.add(index, builderForValue.build());
        onChanged();
      } else {
        explanationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Explanations of
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions].
     * Each element of the explanations indicates the explanation for one
     * explanation Method.
     *
     * The attributions list in the
     * [EvaluatedAnnotationExplanation.explanation][google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation.explanation]
     * object corresponds to the
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions]
     * list. For example, the second element in the attributions list explains the
     * second element in the predictions list.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation explanations = 8;
     * </code>
     */
    public Builder addAllExplanations(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation>
            values) {
      if (explanationsBuilder_ == null) {
        ensureExplanationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, explanations_);
        onChanged();
      } else {
        explanationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Explanations of
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions].
     * Each element of the explanations indicates the explanation for one
     * explanation Method.
     *
     * The attributions list in the
     * [EvaluatedAnnotationExplanation.explanation][google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation.explanation]
     * object corresponds to the
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions]
     * list. For example, the second element in the attributions list explains the
     * second element in the predictions list.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation explanations = 8;
     * </code>
     */
    public Builder clearExplanations() {
      if (explanationsBuilder_ == null) {
        explanations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        explanationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Explanations of
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions].
     * Each element of the explanations indicates the explanation for one
     * explanation Method.
     *
     * The attributions list in the
     * [EvaluatedAnnotationExplanation.explanation][google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation.explanation]
     * object corresponds to the
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions]
     * list. For example, the second element in the attributions list explains the
     * second element in the predictions list.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation explanations = 8;
     * </code>
     */
    public Builder removeExplanations(int index) {
      if (explanationsBuilder_ == null) {
        ensureExplanationsIsMutable();
        explanations_.remove(index);
        onChanged();
      } else {
        explanationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Explanations of
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions].
     * Each element of the explanations indicates the explanation for one
     * explanation Method.
     *
     * The attributions list in the
     * [EvaluatedAnnotationExplanation.explanation][google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation.explanation]
     * object corresponds to the
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions]
     * list. For example, the second element in the attributions list explains the
     * second element in the predictions list.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation explanations = 8;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation.Builder
        getExplanationsBuilder(int index) {
      return getExplanationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Explanations of
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions].
     * Each element of the explanations indicates the explanation for one
     * explanation Method.
     *
     * The attributions list in the
     * [EvaluatedAnnotationExplanation.explanation][google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation.explanation]
     * object corresponds to the
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions]
     * list. For example, the second element in the attributions list explains the
     * second element in the predictions list.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation explanations = 8;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.EvaluatedAnnotationExplanationOrBuilder
        getExplanationsOrBuilder(int index) {
      if (explanationsBuilder_ == null) {
        return explanations_.get(index);
      } else {
        return explanationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Explanations of
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions].
     * Each element of the explanations indicates the explanation for one
     * explanation Method.
     *
     * The attributions list in the
     * [EvaluatedAnnotationExplanation.explanation][google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation.explanation]
     * object corresponds to the
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions]
     * list. For example, the second element in the attributions list explains the
     * second element in the predictions list.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation explanations = 8;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.aiplatform.v1.EvaluatedAnnotationExplanationOrBuilder>
        getExplanationsOrBuilderList() {
      if (explanationsBuilder_ != null) {
        return explanationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(explanations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Explanations of
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions].
     * Each element of the explanations indicates the explanation for one
     * explanation Method.
     *
     * The attributions list in the
     * [EvaluatedAnnotationExplanation.explanation][google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation.explanation]
     * object corresponds to the
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions]
     * list. For example, the second element in the attributions list explains the
     * second element in the predictions list.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation explanations = 8;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation.Builder
        addExplanationsBuilder() {
      return getExplanationsFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Explanations of
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions].
     * Each element of the explanations indicates the explanation for one
     * explanation Method.
     *
     * The attributions list in the
     * [EvaluatedAnnotationExplanation.explanation][google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation.explanation]
     * object corresponds to the
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions]
     * list. For example, the second element in the attributions list explains the
     * second element in the predictions list.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation explanations = 8;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation.Builder
        addExplanationsBuilder(int index) {
      return getExplanationsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Explanations of
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions].
     * Each element of the explanations indicates the explanation for one
     * explanation Method.
     *
     * The attributions list in the
     * [EvaluatedAnnotationExplanation.explanation][google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation.explanation]
     * object corresponds to the
     * [predictions][google.cloud.aiplatform.v1.EvaluatedAnnotation.predictions]
     * list. For example, the second element in the attributions list explains the
     * second element in the predictions list.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation explanations = 8;
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation.Builder>
        getExplanationsBuilderList() {
      return getExplanationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation,
            com.google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation.Builder,
            com.google.cloud.aiplatform.v1.EvaluatedAnnotationExplanationOrBuilder>
        getExplanationsFieldBuilder() {
      if (explanationsBuilder_ == null) {
        explanationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation,
                com.google.cloud.aiplatform.v1.EvaluatedAnnotationExplanation.Builder,
                com.google.cloud.aiplatform.v1.EvaluatedAnnotationExplanationOrBuilder>(
                explanations_, ((bitField0_ & 0x00000020) != 0), getParentForChildren(), isClean());
        explanations_ = null;
      }
      return explanationsBuilder_;
    }

    private java.util.List<com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation>
        errorAnalysisAnnotations_ = java.util.Collections.emptyList();

    private void ensureErrorAnalysisAnnotationsIsMutable() {
      if (!((bitField0_ & 0x00000040) != 0)) {
        errorAnalysisAnnotations_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation>(
                errorAnalysisAnnotations_);
        bitField0_ |= 0x00000040;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation,
            com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.Builder,
            com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotationOrBuilder>
        errorAnalysisAnnotationsBuilder_;

    /**
     *
     *
     * <pre>
     * Annotations of model error analysis results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ErrorAnalysisAnnotation error_analysis_annotations = 9;
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation>
        getErrorAnalysisAnnotationsList() {
      if (errorAnalysisAnnotationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(errorAnalysisAnnotations_);
      } else {
        return errorAnalysisAnnotationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Annotations of model error analysis results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ErrorAnalysisAnnotation error_analysis_annotations = 9;
     * </code>
     */
    public int getErrorAnalysisAnnotationsCount() {
      if (errorAnalysisAnnotationsBuilder_ == null) {
        return errorAnalysisAnnotations_.size();
      } else {
        return errorAnalysisAnnotationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Annotations of model error analysis results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ErrorAnalysisAnnotation error_analysis_annotations = 9;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation getErrorAnalysisAnnotations(
        int index) {
      if (errorAnalysisAnnotationsBuilder_ == null) {
        return errorAnalysisAnnotations_.get(index);
      } else {
        return errorAnalysisAnnotationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Annotations of model error analysis results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ErrorAnalysisAnnotation error_analysis_annotations = 9;
     * </code>
     */
    public Builder setErrorAnalysisAnnotations(
        int index, com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation value) {
      if (errorAnalysisAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorAnalysisAnnotationsIsMutable();
        errorAnalysisAnnotations_.set(index, value);
        onChanged();
      } else {
        errorAnalysisAnnotationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotations of model error analysis results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ErrorAnalysisAnnotation error_analysis_annotations = 9;
     * </code>
     */
    public Builder setErrorAnalysisAnnotations(
        int index, com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.Builder builderForValue) {
      if (errorAnalysisAnnotationsBuilder_ == null) {
        ensureErrorAnalysisAnnotationsIsMutable();
        errorAnalysisAnnotations_.set(index, builderForValue.build());
        onChanged();
      } else {
        errorAnalysisAnnotationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotations of model error analysis results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ErrorAnalysisAnnotation error_analysis_annotations = 9;
     * </code>
     */
    public Builder addErrorAnalysisAnnotations(
        com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation value) {
      if (errorAnalysisAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorAnalysisAnnotationsIsMutable();
        errorAnalysisAnnotations_.add(value);
        onChanged();
      } else {
        errorAnalysisAnnotationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotations of model error analysis results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ErrorAnalysisAnnotation error_analysis_annotations = 9;
     * </code>
     */
    public Builder addErrorAnalysisAnnotations(
        int index, com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation value) {
      if (errorAnalysisAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorAnalysisAnnotationsIsMutable();
        errorAnalysisAnnotations_.add(index, value);
        onChanged();
      } else {
        errorAnalysisAnnotationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotations of model error analysis results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ErrorAnalysisAnnotation error_analysis_annotations = 9;
     * </code>
     */
    public Builder addErrorAnalysisAnnotations(
        com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.Builder builderForValue) {
      if (errorAnalysisAnnotationsBuilder_ == null) {
        ensureErrorAnalysisAnnotationsIsMutable();
        errorAnalysisAnnotations_.add(builderForValue.build());
        onChanged();
      } else {
        errorAnalysisAnnotationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotations of model error analysis results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ErrorAnalysisAnnotation error_analysis_annotations = 9;
     * </code>
     */
    public Builder addErrorAnalysisAnnotations(
        int index, com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.Builder builderForValue) {
      if (errorAnalysisAnnotationsBuilder_ == null) {
        ensureErrorAnalysisAnnotationsIsMutable();
        errorAnalysisAnnotations_.add(index, builderForValue.build());
        onChanged();
      } else {
        errorAnalysisAnnotationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotations of model error analysis results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ErrorAnalysisAnnotation error_analysis_annotations = 9;
     * </code>
     */
    public Builder addAllErrorAnalysisAnnotations(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation>
            values) {
      if (errorAnalysisAnnotationsBuilder_ == null) {
        ensureErrorAnalysisAnnotationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, errorAnalysisAnnotations_);
        onChanged();
      } else {
        errorAnalysisAnnotationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotations of model error analysis results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ErrorAnalysisAnnotation error_analysis_annotations = 9;
     * </code>
     */
    public Builder clearErrorAnalysisAnnotations() {
      if (errorAnalysisAnnotationsBuilder_ == null) {
        errorAnalysisAnnotations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
      } else {
        errorAnalysisAnnotationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotations of model error analysis results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ErrorAnalysisAnnotation error_analysis_annotations = 9;
     * </code>
     */
    public Builder removeErrorAnalysisAnnotations(int index) {
      if (errorAnalysisAnnotationsBuilder_ == null) {
        ensureErrorAnalysisAnnotationsIsMutable();
        errorAnalysisAnnotations_.remove(index);
        onChanged();
      } else {
        errorAnalysisAnnotationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotations of model error analysis results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ErrorAnalysisAnnotation error_analysis_annotations = 9;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.Builder
        getErrorAnalysisAnnotationsBuilder(int index) {
      return getErrorAnalysisAnnotationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Annotations of model error analysis results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ErrorAnalysisAnnotation error_analysis_annotations = 9;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotationOrBuilder
        getErrorAnalysisAnnotationsOrBuilder(int index) {
      if (errorAnalysisAnnotationsBuilder_ == null) {
        return errorAnalysisAnnotations_.get(index);
      } else {
        return errorAnalysisAnnotationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Annotations of model error analysis results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ErrorAnalysisAnnotation error_analysis_annotations = 9;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotationOrBuilder>
        getErrorAnalysisAnnotationsOrBuilderList() {
      if (errorAnalysisAnnotationsBuilder_ != null) {
        return errorAnalysisAnnotationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(errorAnalysisAnnotations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Annotations of model error analysis results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ErrorAnalysisAnnotation error_analysis_annotations = 9;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.Builder
        addErrorAnalysisAnnotationsBuilder() {
      return getErrorAnalysisAnnotationsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Annotations of model error analysis results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ErrorAnalysisAnnotation error_analysis_annotations = 9;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.Builder
        addErrorAnalysisAnnotationsBuilder(int index) {
      return getErrorAnalysisAnnotationsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Annotations of model error analysis results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ErrorAnalysisAnnotation error_analysis_annotations = 9;
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.Builder>
        getErrorAnalysisAnnotationsBuilderList() {
      return getErrorAnalysisAnnotationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation,
            com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.Builder,
            com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotationOrBuilder>
        getErrorAnalysisAnnotationsFieldBuilder() {
      if (errorAnalysisAnnotationsBuilder_ == null) {
        errorAnalysisAnnotationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation,
                com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.Builder,
                com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotationOrBuilder>(
                errorAnalysisAnnotations_,
                ((bitField0_ & 0x00000040) != 0),
                getParentForChildren(),
                isClean());
        errorAnalysisAnnotations_ = null;
      }
      return errorAnalysisAnnotationsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.EvaluatedAnnotation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.EvaluatedAnnotation)
  private static final com.google.cloud.aiplatform.v1.EvaluatedAnnotation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.EvaluatedAnnotation();
  }

  public static com.google.cloud.aiplatform.v1.EvaluatedAnnotation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<EvaluatedAnnotation> PARSER =
      new com.google.protobuf.AbstractParser<EvaluatedAnnotation>() {
        @java.lang.Override
        public EvaluatedAnnotation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<EvaluatedAnnotation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<EvaluatedAnnotation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.EvaluatedAnnotation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
