/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TuningJobName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_TUNING_JOB = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/tuningJobs/{tuning_job}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String tuningJob;

    @Deprecated
    protected TuningJobName() {
        this.project = null;
        this.location = null;
        this.tuningJob = null;
    }

    private TuningJobName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.tuningJob = (String)Preconditions.checkNotNull((Object)builder.getTuningJob());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getTuningJob() {
        return this.tuningJob;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TuningJobName of(String project, String location, String tuningJob) {
        return TuningJobName.newBuilder().setProject(project).setLocation(location).setTuningJob(tuningJob).build();
    }

    public static String format(String project, String location, String tuningJob) {
        return TuningJobName.newBuilder().setProject(project).setLocation(location).setTuningJob(tuningJob).build().toString();
    }

    public static TuningJobName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_TUNING_JOB.validatedMatch(formattedString, "TuningJobName.parse: formattedString not in valid format");
        return TuningJobName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("tuning_job"));
    }

    public static List<TuningJobName> parseList(List<String> formattedStrings) {
        ArrayList<TuningJobName> list = new ArrayList<TuningJobName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TuningJobName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TuningJobName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TuningJobName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_TUNING_JOB.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TuningJobName tuningJobName = this;
            synchronized (tuningJobName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.tuningJob != null) {
                        fieldMapBuilder.put((Object)"tuning_job", (Object)this.tuningJob);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_TUNING_JOB.instantiate(new String[]{"project", this.project, "location", this.location, "tuning_job", this.tuningJob});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            TuningJobName that = (TuningJobName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.tuningJob, that.tuningJob);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.tuningJob);
    }

    public static class Builder {
        private String project;
        private String location;
        private String tuningJob;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getTuningJob() {
            return this.tuningJob;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setTuningJob(String tuningJob) {
            this.tuningJob = tuningJob;
            return this;
        }

        private Builder(TuningJobName tuningJobName) {
            this.project = tuningJobName.project;
            this.location = tuningJobName.location;
            this.tuningJob = tuningJobName.tuningJob;
        }

        public TuningJobName build() {
            return new TuningJobName(this);
        }
    }
}

