/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FeatureGroupName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_FEATURE_GROUP = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/featureGroups/{feature_group}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String featureGroup;

    @Deprecated
    protected FeatureGroupName() {
        this.project = null;
        this.location = null;
        this.featureGroup = null;
    }

    private FeatureGroupName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.featureGroup = (String)Preconditions.checkNotNull((Object)builder.getFeatureGroup());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getFeatureGroup() {
        return this.featureGroup;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static FeatureGroupName of(String project, String location, String featureGroup) {
        return FeatureGroupName.newBuilder().setProject(project).setLocation(location).setFeatureGroup(featureGroup).build();
    }

    public static String format(String project, String location, String featureGroup) {
        return FeatureGroupName.newBuilder().setProject(project).setLocation(location).setFeatureGroup(featureGroup).build().toString();
    }

    public static FeatureGroupName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_FEATURE_GROUP.validatedMatch(formattedString, "FeatureGroupName.parse: formattedString not in valid format");
        return FeatureGroupName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("feature_group"));
    }

    public static List<FeatureGroupName> parseList(List<String> formattedStrings) {
        ArrayList<FeatureGroupName> list = new ArrayList<FeatureGroupName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(FeatureGroupName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<FeatureGroupName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (FeatureGroupName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_FEATURE_GROUP.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            FeatureGroupName featureGroupName = this;
            synchronized (featureGroupName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.featureGroup != null) {
                        fieldMapBuilder.put((Object)"feature_group", (Object)this.featureGroup);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_FEATURE_GROUP.instantiate(new String[]{"project", this.project, "location", this.location, "feature_group", this.featureGroup});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            FeatureGroupName that = (FeatureGroupName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.featureGroup, that.featureGroup);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.featureGroup);
    }

    public static class Builder {
        private String project;
        private String location;
        private String featureGroup;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getFeatureGroup() {
            return this.featureGroup;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setFeatureGroup(String featureGroup) {
            this.featureGroup = featureGroup;
            return this;
        }

        private Builder(FeatureGroupName featureGroupName) {
            this.project = featureGroupName.project;
            this.location = featureGroupName.location;
            this.featureGroup = featureGroupName.featureGroup;
        }

        public FeatureGroupName build() {
            return new FeatureGroupName(this);
        }
    }
}

