/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1;

import com.google.cloud.aiplatform.v1.IndexDatapointOrBuilder;
import com.google.cloud.aiplatform.v1.IndexProto;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class IndexDatapoint
extends GeneratedMessageV3
implements IndexDatapointOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int DATAPOINT_ID_FIELD_NUMBER = 1;
    private volatile Object datapointId_ = "";
    public static final int FEATURE_VECTOR_FIELD_NUMBER = 2;
    private Internal.FloatList featureVector_;
    private int featureVectorMemoizedSerializedSize = -1;
    public static final int RESTRICTS_FIELD_NUMBER = 4;
    private List<Restriction> restricts_;
    public static final int CROWDING_TAG_FIELD_NUMBER = 5;
    private CrowdingTag crowdingTag_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final IndexDatapoint DEFAULT_INSTANCE = new IndexDatapoint();
    private static final Parser<IndexDatapoint> PARSER = new AbstractParser<IndexDatapoint>(){

        public IndexDatapoint parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = IndexDatapoint.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private IndexDatapoint(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private IndexDatapoint() {
        this.datapointId_ = "";
        this.featureVector_ = IndexDatapoint.emptyFloatList();
        this.restricts_ = Collections.emptyList();
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new IndexDatapoint();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return IndexProto.internal_static_google_cloud_aiplatform_v1_IndexDatapoint_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return IndexProto.internal_static_google_cloud_aiplatform_v1_IndexDatapoint_fieldAccessorTable.ensureFieldAccessorsInitialized(IndexDatapoint.class, Builder.class);
    }

    @Override
    public String getDatapointId() {
        Object ref = this.datapointId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.datapointId_ = s;
        return s;
    }

    @Override
    public ByteString getDatapointIdBytes() {
        Object ref = this.datapointId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.datapointId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public List<Float> getFeatureVectorList() {
        return this.featureVector_;
    }

    @Override
    public int getFeatureVectorCount() {
        return this.featureVector_.size();
    }

    @Override
    public float getFeatureVector(int index) {
        return this.featureVector_.getFloat(index);
    }

    @Override
    public List<Restriction> getRestrictsList() {
        return this.restricts_;
    }

    @Override
    public List<? extends RestrictionOrBuilder> getRestrictsOrBuilderList() {
        return this.restricts_;
    }

    @Override
    public int getRestrictsCount() {
        return this.restricts_.size();
    }

    @Override
    public Restriction getRestricts(int index) {
        return this.restricts_.get(index);
    }

    @Override
    public RestrictionOrBuilder getRestrictsOrBuilder(int index) {
        return this.restricts_.get(index);
    }

    @Override
    public boolean hasCrowdingTag() {
        return this.crowdingTag_ != null;
    }

    @Override
    public CrowdingTag getCrowdingTag() {
        return this.crowdingTag_ == null ? CrowdingTag.getDefaultInstance() : this.crowdingTag_;
    }

    @Override
    public CrowdingTagOrBuilder getCrowdingTagOrBuilder() {
        return this.crowdingTag_ == null ? CrowdingTag.getDefaultInstance() : this.crowdingTag_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        this.getSerializedSize();
        if (!GeneratedMessageV3.isStringEmpty((Object)this.datapointId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.datapointId_);
        }
        if (this.getFeatureVectorList().size() > 0) {
            output.writeUInt32NoTag(18);
            output.writeUInt32NoTag(this.featureVectorMemoizedSerializedSize);
        }
        for (i = 0; i < this.featureVector_.size(); ++i) {
            output.writeFloatNoTag(this.featureVector_.getFloat(i));
        }
        for (i = 0; i < this.restricts_.size(); ++i) {
            output.writeMessage(4, (MessageLite)this.restricts_.get(i));
        }
        if (this.crowdingTag_ != null) {
            output.writeMessage(5, (MessageLite)this.getCrowdingTag());
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.datapointId_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.datapointId_);
        }
        int dataSize = 0;
        dataSize = 4 * this.getFeatureVectorList().size();
        size += dataSize;
        if (!this.getFeatureVectorList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeInt32SizeNoTag((int)dataSize);
        }
        this.featureVectorMemoizedSerializedSize = dataSize;
        for (int i = 0; i < this.restricts_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)4, (MessageLite)((MessageLite)this.restricts_.get(i)));
        }
        if (this.crowdingTag_ != null) {
            size += CodedOutputStream.computeMessageSize((int)5, (MessageLite)this.getCrowdingTag());
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IndexDatapoint)) {
            return super.equals(obj);
        }
        IndexDatapoint other = (IndexDatapoint)obj;
        if (!this.getDatapointId().equals(other.getDatapointId())) {
            return false;
        }
        if (!this.getFeatureVectorList().equals(other.getFeatureVectorList())) {
            return false;
        }
        if (!this.getRestrictsList().equals(other.getRestrictsList())) {
            return false;
        }
        if (this.hasCrowdingTag() != other.hasCrowdingTag()) {
            return false;
        }
        if (this.hasCrowdingTag() && !this.getCrowdingTag().equals(other.getCrowdingTag())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + IndexDatapoint.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getDatapointId().hashCode();
        if (this.getFeatureVectorCount() > 0) {
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getFeatureVectorList().hashCode();
        }
        if (this.getRestrictsCount() > 0) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getRestrictsList().hashCode();
        }
        if (this.hasCrowdingTag()) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getCrowdingTag().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static IndexDatapoint parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (IndexDatapoint)PARSER.parseFrom(data);
    }

    public static IndexDatapoint parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (IndexDatapoint)PARSER.parseFrom(data, extensionRegistry);
    }

    public static IndexDatapoint parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (IndexDatapoint)PARSER.parseFrom(data);
    }

    public static IndexDatapoint parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (IndexDatapoint)PARSER.parseFrom(data, extensionRegistry);
    }

    public static IndexDatapoint parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (IndexDatapoint)PARSER.parseFrom(data);
    }

    public static IndexDatapoint parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (IndexDatapoint)PARSER.parseFrom(data, extensionRegistry);
    }

    public static IndexDatapoint parseFrom(InputStream input) throws IOException {
        return (IndexDatapoint)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static IndexDatapoint parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (IndexDatapoint)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static IndexDatapoint parseDelimitedFrom(InputStream input) throws IOException {
        return (IndexDatapoint)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static IndexDatapoint parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (IndexDatapoint)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static IndexDatapoint parseFrom(CodedInputStream input) throws IOException {
        return (IndexDatapoint)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static IndexDatapoint parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (IndexDatapoint)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return IndexDatapoint.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(IndexDatapoint prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static IndexDatapoint getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<IndexDatapoint> parser() {
        return PARSER;
    }

    public Parser<IndexDatapoint> getParserForType() {
        return PARSER;
    }

    public IndexDatapoint getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    static /* synthetic */ Internal.FloatList access$2400() {
        return IndexDatapoint.emptyFloatList();
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements IndexDatapointOrBuilder {
        private int bitField0_;
        private Object datapointId_ = "";
        private Internal.FloatList featureVector_ = IndexDatapoint.access$2400();
        private List<Restriction> restricts_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<Restriction, Restriction.Builder, RestrictionOrBuilder> restrictsBuilder_;
        private CrowdingTag crowdingTag_;
        private SingleFieldBuilderV3<CrowdingTag, CrowdingTag.Builder, CrowdingTagOrBuilder> crowdingTagBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return IndexProto.internal_static_google_cloud_aiplatform_v1_IndexDatapoint_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return IndexProto.internal_static_google_cloud_aiplatform_v1_IndexDatapoint_fieldAccessorTable.ensureFieldAccessorsInitialized(IndexDatapoint.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.datapointId_ = "";
            this.featureVector_ = IndexDatapoint.emptyFloatList();
            if (this.restrictsBuilder_ == null) {
                this.restricts_ = Collections.emptyList();
            } else {
                this.restricts_ = null;
                this.restrictsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFFB;
            this.crowdingTag_ = null;
            if (this.crowdingTagBuilder_ != null) {
                this.crowdingTagBuilder_.dispose();
                this.crowdingTagBuilder_ = null;
            }
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return IndexProto.internal_static_google_cloud_aiplatform_v1_IndexDatapoint_descriptor;
        }

        public IndexDatapoint getDefaultInstanceForType() {
            return IndexDatapoint.getDefaultInstance();
        }

        public IndexDatapoint build() {
            IndexDatapoint result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public IndexDatapoint buildPartial() {
            IndexDatapoint result = new IndexDatapoint(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(IndexDatapoint result) {
            if ((this.bitField0_ & 2) != 0) {
                this.featureVector_.makeImmutable();
                this.bitField0_ &= 0xFFFFFFFD;
            }
            result.featureVector_ = this.featureVector_;
            if (this.restrictsBuilder_ == null) {
                if ((this.bitField0_ & 4) != 0) {
                    this.restricts_ = Collections.unmodifiableList(this.restricts_);
                    this.bitField0_ &= 0xFFFFFFFB;
                }
                result.restricts_ = this.restricts_;
            } else {
                result.restricts_ = this.restrictsBuilder_.build();
            }
        }

        private void buildPartial0(IndexDatapoint result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.datapointId_ = this.datapointId_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.crowdingTag_ = this.crowdingTagBuilder_ == null ? this.crowdingTag_ : (CrowdingTag)this.crowdingTagBuilder_.build();
            }
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof IndexDatapoint) {
                return this.mergeFrom((IndexDatapoint)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(IndexDatapoint other) {
            if (other == IndexDatapoint.getDefaultInstance()) {
                return this;
            }
            if (!other.getDatapointId().isEmpty()) {
                this.datapointId_ = other.datapointId_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (!other.featureVector_.isEmpty()) {
                if (this.featureVector_.isEmpty()) {
                    this.featureVector_ = other.featureVector_;
                    this.bitField0_ &= 0xFFFFFFFD;
                } else {
                    this.ensureFeatureVectorIsMutable();
                    this.featureVector_.addAll((Collection)other.featureVector_);
                }
                this.onChanged();
            }
            if (this.restrictsBuilder_ == null) {
                if (!other.restricts_.isEmpty()) {
                    if (this.restricts_.isEmpty()) {
                        this.restricts_ = other.restricts_;
                        this.bitField0_ &= 0xFFFFFFFB;
                    } else {
                        this.ensureRestrictsIsMutable();
                        this.restricts_.addAll(other.restricts_);
                    }
                    this.onChanged();
                }
            } else if (!other.restricts_.isEmpty()) {
                if (this.restrictsBuilder_.isEmpty()) {
                    this.restrictsBuilder_.dispose();
                    this.restrictsBuilder_ = null;
                    this.restricts_ = other.restricts_;
                    this.bitField0_ &= 0xFFFFFFFB;
                    this.restrictsBuilder_ = alwaysUseFieldBuilders ? this.getRestrictsFieldBuilder() : null;
                } else {
                    this.restrictsBuilder_.addAllMessages((Iterable)other.restricts_);
                }
            }
            if (other.hasCrowdingTag()) {
                this.mergeCrowdingTag(other.getCrowdingTag());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block13: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block13;
                        }
                        case 10: {
                            this.datapointId_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block13;
                        }
                        case 21: {
                            float v = input.readFloat();
                            this.ensureFeatureVectorIsMutable();
                            this.featureVector_.addFloat(v);
                            continue block13;
                        }
                        case 18: {
                            int length = input.readRawVarint32();
                            int limit = input.pushLimit(length);
                            this.ensureFeatureVectorIsMutable();
                            while (input.getBytesUntilLimit() > 0) {
                                this.featureVector_.addFloat(input.readFloat());
                            }
                            input.popLimit(limit);
                            continue block13;
                        }
                        case 34: {
                            Restriction m = (Restriction)input.readMessage(Restriction.parser(), extensionRegistry);
                            if (this.restrictsBuilder_ == null) {
                                this.ensureRestrictsIsMutable();
                                this.restricts_.add(m);
                                continue block13;
                            }
                            this.restrictsBuilder_.addMessage((AbstractMessage)m);
                            continue block13;
                        }
                        case 42: {
                            input.readMessage((MessageLite.Builder)this.getCrowdingTagFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 8;
                            continue block13;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getDatapointId() {
            Object ref = this.datapointId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.datapointId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getDatapointIdBytes() {
            Object ref = this.datapointId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.datapointId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setDatapointId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.datapointId_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearDatapointId() {
            this.datapointId_ = IndexDatapoint.getDefaultInstance().getDatapointId();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setDatapointIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            IndexDatapoint.checkByteStringIsUtf8((ByteString)value);
            this.datapointId_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        private void ensureFeatureVectorIsMutable() {
            if ((this.bitField0_ & 2) == 0) {
                this.featureVector_ = IndexDatapoint.mutableCopy((Internal.FloatList)this.featureVector_);
                this.bitField0_ |= 2;
            }
        }

        @Override
        public List<Float> getFeatureVectorList() {
            return (this.bitField0_ & 2) != 0 ? Collections.unmodifiableList(this.featureVector_) : this.featureVector_;
        }

        @Override
        public int getFeatureVectorCount() {
            return this.featureVector_.size();
        }

        @Override
        public float getFeatureVector(int index) {
            return this.featureVector_.getFloat(index);
        }

        public Builder setFeatureVector(int index, float value) {
            this.ensureFeatureVectorIsMutable();
            this.featureVector_.setFloat(index, value);
            this.onChanged();
            return this;
        }

        public Builder addFeatureVector(float value) {
            this.ensureFeatureVectorIsMutable();
            this.featureVector_.addFloat(value);
            this.onChanged();
            return this;
        }

        public Builder addAllFeatureVector(Iterable<? extends Float> values) {
            this.ensureFeatureVectorIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.featureVector_);
            this.onChanged();
            return this;
        }

        public Builder clearFeatureVector() {
            this.featureVector_ = IndexDatapoint.emptyFloatList();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        private void ensureRestrictsIsMutable() {
            if ((this.bitField0_ & 4) == 0) {
                this.restricts_ = new ArrayList<Restriction>(this.restricts_);
                this.bitField0_ |= 4;
            }
        }

        @Override
        public List<Restriction> getRestrictsList() {
            if (this.restrictsBuilder_ == null) {
                return Collections.unmodifiableList(this.restricts_);
            }
            return this.restrictsBuilder_.getMessageList();
        }

        @Override
        public int getRestrictsCount() {
            if (this.restrictsBuilder_ == null) {
                return this.restricts_.size();
            }
            return this.restrictsBuilder_.getCount();
        }

        @Override
        public Restriction getRestricts(int index) {
            if (this.restrictsBuilder_ == null) {
                return this.restricts_.get(index);
            }
            return (Restriction)this.restrictsBuilder_.getMessage(index);
        }

        public Builder setRestricts(int index, Restriction value) {
            if (this.restrictsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureRestrictsIsMutable();
                this.restricts_.set(index, value);
                this.onChanged();
            } else {
                this.restrictsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setRestricts(int index, Restriction.Builder builderForValue) {
            if (this.restrictsBuilder_ == null) {
                this.ensureRestrictsIsMutable();
                this.restricts_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.restrictsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addRestricts(Restriction value) {
            if (this.restrictsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureRestrictsIsMutable();
                this.restricts_.add(value);
                this.onChanged();
            } else {
                this.restrictsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addRestricts(int index, Restriction value) {
            if (this.restrictsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureRestrictsIsMutable();
                this.restricts_.add(index, value);
                this.onChanged();
            } else {
                this.restrictsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addRestricts(Restriction.Builder builderForValue) {
            if (this.restrictsBuilder_ == null) {
                this.ensureRestrictsIsMutable();
                this.restricts_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.restrictsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addRestricts(int index, Restriction.Builder builderForValue) {
            if (this.restrictsBuilder_ == null) {
                this.ensureRestrictsIsMutable();
                this.restricts_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.restrictsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllRestricts(Iterable<? extends Restriction> values) {
            if (this.restrictsBuilder_ == null) {
                this.ensureRestrictsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.restricts_);
                this.onChanged();
            } else {
                this.restrictsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearRestricts() {
            if (this.restrictsBuilder_ == null) {
                this.restricts_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFB;
                this.onChanged();
            } else {
                this.restrictsBuilder_.clear();
            }
            return this;
        }

        public Builder removeRestricts(int index) {
            if (this.restrictsBuilder_ == null) {
                this.ensureRestrictsIsMutable();
                this.restricts_.remove(index);
                this.onChanged();
            } else {
                this.restrictsBuilder_.remove(index);
            }
            return this;
        }

        public Restriction.Builder getRestrictsBuilder(int index) {
            return (Restriction.Builder)this.getRestrictsFieldBuilder().getBuilder(index);
        }

        @Override
        public RestrictionOrBuilder getRestrictsOrBuilder(int index) {
            if (this.restrictsBuilder_ == null) {
                return this.restricts_.get(index);
            }
            return (RestrictionOrBuilder)this.restrictsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends RestrictionOrBuilder> getRestrictsOrBuilderList() {
            if (this.restrictsBuilder_ != null) {
                return this.restrictsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.restricts_);
        }

        public Restriction.Builder addRestrictsBuilder() {
            return (Restriction.Builder)this.getRestrictsFieldBuilder().addBuilder((AbstractMessage)Restriction.getDefaultInstance());
        }

        public Restriction.Builder addRestrictsBuilder(int index) {
            return (Restriction.Builder)this.getRestrictsFieldBuilder().addBuilder(index, (AbstractMessage)Restriction.getDefaultInstance());
        }

        public List<Restriction.Builder> getRestrictsBuilderList() {
            return this.getRestrictsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<Restriction, Restriction.Builder, RestrictionOrBuilder> getRestrictsFieldBuilder() {
            if (this.restrictsBuilder_ == null) {
                this.restrictsBuilder_ = new RepeatedFieldBuilderV3(this.restricts_, (this.bitField0_ & 4) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.restricts_ = null;
            }
            return this.restrictsBuilder_;
        }

        @Override
        public boolean hasCrowdingTag() {
            return (this.bitField0_ & 8) != 0;
        }

        @Override
        public CrowdingTag getCrowdingTag() {
            if (this.crowdingTagBuilder_ == null) {
                return this.crowdingTag_ == null ? CrowdingTag.getDefaultInstance() : this.crowdingTag_;
            }
            return (CrowdingTag)this.crowdingTagBuilder_.getMessage();
        }

        public Builder setCrowdingTag(CrowdingTag value) {
            if (this.crowdingTagBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.crowdingTag_ = value;
            } else {
                this.crowdingTagBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder setCrowdingTag(CrowdingTag.Builder builderForValue) {
            if (this.crowdingTagBuilder_ == null) {
                this.crowdingTag_ = builderForValue.build();
            } else {
                this.crowdingTagBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder mergeCrowdingTag(CrowdingTag value) {
            if (this.crowdingTagBuilder_ == null) {
                if ((this.bitField0_ & 8) != 0 && this.crowdingTag_ != null && this.crowdingTag_ != CrowdingTag.getDefaultInstance()) {
                    this.getCrowdingTagBuilder().mergeFrom(value);
                } else {
                    this.crowdingTag_ = value;
                }
            } else {
                this.crowdingTagBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearCrowdingTag() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.crowdingTag_ = null;
            if (this.crowdingTagBuilder_ != null) {
                this.crowdingTagBuilder_.dispose();
                this.crowdingTagBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public CrowdingTag.Builder getCrowdingTagBuilder() {
            this.bitField0_ |= 8;
            this.onChanged();
            return (CrowdingTag.Builder)this.getCrowdingTagFieldBuilder().getBuilder();
        }

        @Override
        public CrowdingTagOrBuilder getCrowdingTagOrBuilder() {
            if (this.crowdingTagBuilder_ != null) {
                return (CrowdingTagOrBuilder)this.crowdingTagBuilder_.getMessageOrBuilder();
            }
            return this.crowdingTag_ == null ? CrowdingTag.getDefaultInstance() : this.crowdingTag_;
        }

        private SingleFieldBuilderV3<CrowdingTag, CrowdingTag.Builder, CrowdingTagOrBuilder> getCrowdingTagFieldBuilder() {
            if (this.crowdingTagBuilder_ == null) {
                this.crowdingTagBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getCrowdingTag(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.crowdingTag_ = null;
            }
            return this.crowdingTagBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static final class CrowdingTag
    extends GeneratedMessageV3
    implements CrowdingTagOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int CROWDING_ATTRIBUTE_FIELD_NUMBER = 1;
        private volatile Object crowdingAttribute_ = "";
        private byte memoizedIsInitialized = (byte)-1;
        private static final CrowdingTag DEFAULT_INSTANCE = new CrowdingTag();
        private static final Parser<CrowdingTag> PARSER = new AbstractParser<CrowdingTag>(){

            public CrowdingTag parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = CrowdingTag.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private CrowdingTag(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private CrowdingTag() {
            this.crowdingAttribute_ = "";
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new CrowdingTag();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return IndexProto.internal_static_google_cloud_aiplatform_v1_IndexDatapoint_CrowdingTag_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return IndexProto.internal_static_google_cloud_aiplatform_v1_IndexDatapoint_CrowdingTag_fieldAccessorTable.ensureFieldAccessorsInitialized(CrowdingTag.class, Builder.class);
        }

        @Override
        public String getCrowdingAttribute() {
            Object ref = this.crowdingAttribute_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.crowdingAttribute_ = s;
            return s;
        }

        @Override
        public ByteString getCrowdingAttributeBytes() {
            Object ref = this.crowdingAttribute_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.crowdingAttribute_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if (!GeneratedMessageV3.isStringEmpty((Object)this.crowdingAttribute_)) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.crowdingAttribute_);
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (!GeneratedMessageV3.isStringEmpty((Object)this.crowdingAttribute_)) {
                size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.crowdingAttribute_);
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CrowdingTag)) {
                return super.equals(obj);
            }
            CrowdingTag other = (CrowdingTag)obj;
            if (!this.getCrowdingAttribute().equals(other.getCrowdingAttribute())) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + CrowdingTag.getDescriptor().hashCode();
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getCrowdingAttribute().hashCode();
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static CrowdingTag parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (CrowdingTag)PARSER.parseFrom(data);
        }

        public static CrowdingTag parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (CrowdingTag)PARSER.parseFrom(data, extensionRegistry);
        }

        public static CrowdingTag parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (CrowdingTag)PARSER.parseFrom(data);
        }

        public static CrowdingTag parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (CrowdingTag)PARSER.parseFrom(data, extensionRegistry);
        }

        public static CrowdingTag parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (CrowdingTag)PARSER.parseFrom(data);
        }

        public static CrowdingTag parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (CrowdingTag)PARSER.parseFrom(data, extensionRegistry);
        }

        public static CrowdingTag parseFrom(InputStream input) throws IOException {
            return (CrowdingTag)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static CrowdingTag parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (CrowdingTag)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static CrowdingTag parseDelimitedFrom(InputStream input) throws IOException {
            return (CrowdingTag)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static CrowdingTag parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (CrowdingTag)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static CrowdingTag parseFrom(CodedInputStream input) throws IOException {
            return (CrowdingTag)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static CrowdingTag parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (CrowdingTag)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return CrowdingTag.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(CrowdingTag prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static CrowdingTag getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<CrowdingTag> parser() {
            return PARSER;
        }

        public Parser<CrowdingTag> getParserForType() {
            return PARSER;
        }

        public CrowdingTag getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements CrowdingTagOrBuilder {
            private int bitField0_;
            private Object crowdingAttribute_ = "";

            public static final Descriptors.Descriptor getDescriptor() {
                return IndexProto.internal_static_google_cloud_aiplatform_v1_IndexDatapoint_CrowdingTag_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return IndexProto.internal_static_google_cloud_aiplatform_v1_IndexDatapoint_CrowdingTag_fieldAccessorTable.ensureFieldAccessorsInitialized(CrowdingTag.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.crowdingAttribute_ = "";
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return IndexProto.internal_static_google_cloud_aiplatform_v1_IndexDatapoint_CrowdingTag_descriptor;
            }

            public CrowdingTag getDefaultInstanceForType() {
                return CrowdingTag.getDefaultInstance();
            }

            public CrowdingTag build() {
                CrowdingTag result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public CrowdingTag buildPartial() {
                CrowdingTag result = new CrowdingTag(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartial0(CrowdingTag result) {
                int from_bitField0_ = this.bitField0_;
                if ((from_bitField0_ & 1) != 0) {
                    result.crowdingAttribute_ = this.crowdingAttribute_;
                }
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof CrowdingTag) {
                    return this.mergeFrom((CrowdingTag)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(CrowdingTag other) {
                if (other == CrowdingTag.getDefaultInstance()) {
                    return this;
                }
                if (!other.getCrowdingAttribute().isEmpty()) {
                    this.crowdingAttribute_ = other.crowdingAttribute_;
                    this.bitField0_ |= 1;
                    this.onChanged();
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block9: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block9;
                            }
                            case 10: {
                                this.crowdingAttribute_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 1;
                                continue block9;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public String getCrowdingAttribute() {
                Object ref = this.crowdingAttribute_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.crowdingAttribute_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getCrowdingAttributeBytes() {
                Object ref = this.crowdingAttribute_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.crowdingAttribute_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setCrowdingAttribute(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.crowdingAttribute_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder clearCrowdingAttribute() {
                this.crowdingAttribute_ = CrowdingTag.getDefaultInstance().getCrowdingAttribute();
                this.bitField0_ &= 0xFFFFFFFE;
                this.onChanged();
                return this;
            }

            public Builder setCrowdingAttributeBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                CrowdingTag.checkByteStringIsUtf8((ByteString)value);
                this.crowdingAttribute_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static interface CrowdingTagOrBuilder
    extends MessageOrBuilder {
        public String getCrowdingAttribute();

        public ByteString getCrowdingAttributeBytes();
    }

    public static final class Restriction
    extends GeneratedMessageV3
    implements RestrictionOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int NAMESPACE_FIELD_NUMBER = 1;
        private volatile Object namespace_ = "";
        public static final int ALLOW_LIST_FIELD_NUMBER = 2;
        private LazyStringArrayList allowList_ = LazyStringArrayList.emptyList();
        public static final int DENY_LIST_FIELD_NUMBER = 3;
        private LazyStringArrayList denyList_ = LazyStringArrayList.emptyList();
        private byte memoizedIsInitialized = (byte)-1;
        private static final Restriction DEFAULT_INSTANCE = new Restriction();
        private static final Parser<Restriction> PARSER = new AbstractParser<Restriction>(){

            public Restriction parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = Restriction.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private Restriction(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private Restriction() {
            this.namespace_ = "";
            this.allowList_ = LazyStringArrayList.emptyList();
            this.denyList_ = LazyStringArrayList.emptyList();
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new Restriction();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return IndexProto.internal_static_google_cloud_aiplatform_v1_IndexDatapoint_Restriction_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return IndexProto.internal_static_google_cloud_aiplatform_v1_IndexDatapoint_Restriction_fieldAccessorTable.ensureFieldAccessorsInitialized(Restriction.class, Builder.class);
        }

        @Override
        public String getNamespace() {
            Object ref = this.namespace_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.namespace_ = s;
            return s;
        }

        @Override
        public ByteString getNamespaceBytes() {
            Object ref = this.namespace_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.namespace_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public ProtocolStringList getAllowListList() {
            return this.allowList_;
        }

        @Override
        public int getAllowListCount() {
            return this.allowList_.size();
        }

        @Override
        public String getAllowList(int index) {
            return this.allowList_.get(index);
        }

        @Override
        public ByteString getAllowListBytes(int index) {
            return this.allowList_.getByteString(index);
        }

        public ProtocolStringList getDenyListList() {
            return this.denyList_;
        }

        @Override
        public int getDenyListCount() {
            return this.denyList_.size();
        }

        @Override
        public String getDenyList(int index) {
            return this.denyList_.get(index);
        }

        @Override
        public ByteString getDenyListBytes(int index) {
            return this.denyList_.getByteString(index);
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            int i;
            if (!GeneratedMessageV3.isStringEmpty((Object)this.namespace_)) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.namespace_);
            }
            for (i = 0; i < this.allowList_.size(); ++i) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.allowList_.getRaw(i));
            }
            for (i = 0; i < this.denyList_.size(); ++i) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)3, (Object)this.denyList_.getRaw(i));
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int i;
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (!GeneratedMessageV3.isStringEmpty((Object)this.namespace_)) {
                size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.namespace_);
            }
            int dataSize = 0;
            for (i = 0; i < this.allowList_.size(); ++i) {
                dataSize += Restriction.computeStringSizeNoTag((Object)this.allowList_.getRaw(i));
            }
            size += dataSize;
            size += 1 * this.getAllowListList().size();
            dataSize = 0;
            for (i = 0; i < this.denyList_.size(); ++i) {
                dataSize += Restriction.computeStringSizeNoTag((Object)this.denyList_.getRaw(i));
            }
            size += dataSize;
            size += 1 * this.getDenyListList().size();
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Restriction)) {
                return super.equals(obj);
            }
            Restriction other = (Restriction)obj;
            if (!this.getNamespace().equals(other.getNamespace())) {
                return false;
            }
            if (!this.getAllowListList().equals(other.getAllowListList())) {
                return false;
            }
            if (!this.getDenyListList().equals(other.getDenyListList())) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + Restriction.getDescriptor().hashCode();
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getNamespace().hashCode();
            if (this.getAllowListCount() > 0) {
                hash = 37 * hash + 2;
                hash = 53 * hash + this.getAllowListList().hashCode();
            }
            if (this.getDenyListCount() > 0) {
                hash = 37 * hash + 3;
                hash = 53 * hash + this.getDenyListList().hashCode();
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static Restriction parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (Restriction)PARSER.parseFrom(data);
        }

        public static Restriction parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (Restriction)PARSER.parseFrom(data, extensionRegistry);
        }

        public static Restriction parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (Restriction)PARSER.parseFrom(data);
        }

        public static Restriction parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (Restriction)PARSER.parseFrom(data, extensionRegistry);
        }

        public static Restriction parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (Restriction)PARSER.parseFrom(data);
        }

        public static Restriction parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (Restriction)PARSER.parseFrom(data, extensionRegistry);
        }

        public static Restriction parseFrom(InputStream input) throws IOException {
            return (Restriction)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static Restriction parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (Restriction)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static Restriction parseDelimitedFrom(InputStream input) throws IOException {
            return (Restriction)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static Restriction parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (Restriction)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static Restriction parseFrom(CodedInputStream input) throws IOException {
            return (Restriction)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static Restriction parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (Restriction)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return Restriction.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(Restriction prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static Restriction getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<Restriction> parser() {
            return PARSER;
        }

        public Parser<Restriction> getParserForType() {
            return PARSER;
        }

        public Restriction getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements RestrictionOrBuilder {
            private int bitField0_;
            private Object namespace_ = "";
            private LazyStringArrayList allowList_ = LazyStringArrayList.emptyList();
            private LazyStringArrayList denyList_ = LazyStringArrayList.emptyList();

            public static final Descriptors.Descriptor getDescriptor() {
                return IndexProto.internal_static_google_cloud_aiplatform_v1_IndexDatapoint_Restriction_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return IndexProto.internal_static_google_cloud_aiplatform_v1_IndexDatapoint_Restriction_fieldAccessorTable.ensureFieldAccessorsInitialized(Restriction.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.namespace_ = "";
                this.allowList_ = LazyStringArrayList.emptyList();
                this.denyList_ = LazyStringArrayList.emptyList();
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return IndexProto.internal_static_google_cloud_aiplatform_v1_IndexDatapoint_Restriction_descriptor;
            }

            public Restriction getDefaultInstanceForType() {
                return Restriction.getDefaultInstance();
            }

            public Restriction build() {
                Restriction result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public Restriction buildPartial() {
                Restriction result = new Restriction(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartial0(Restriction result) {
                int from_bitField0_ = this.bitField0_;
                if ((from_bitField0_ & 1) != 0) {
                    result.namespace_ = this.namespace_;
                }
                if ((from_bitField0_ & 2) != 0) {
                    this.allowList_.makeImmutable();
                    result.allowList_ = this.allowList_;
                }
                if ((from_bitField0_ & 4) != 0) {
                    this.denyList_.makeImmutable();
                    result.denyList_ = this.denyList_;
                }
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof Restriction) {
                    return this.mergeFrom((Restriction)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(Restriction other) {
                if (other == Restriction.getDefaultInstance()) {
                    return this;
                }
                if (!other.getNamespace().isEmpty()) {
                    this.namespace_ = other.namespace_;
                    this.bitField0_ |= 1;
                    this.onChanged();
                }
                if (!other.allowList_.isEmpty()) {
                    if (this.allowList_.isEmpty()) {
                        this.allowList_ = other.allowList_;
                        this.bitField0_ |= 2;
                    } else {
                        this.ensureAllowListIsMutable();
                        this.allowList_.addAll((Collection)other.allowList_);
                    }
                    this.onChanged();
                }
                if (!other.denyList_.isEmpty()) {
                    if (this.denyList_.isEmpty()) {
                        this.denyList_ = other.denyList_;
                        this.bitField0_ |= 4;
                    } else {
                        this.ensureDenyListIsMutable();
                        this.denyList_.addAll((Collection)other.denyList_);
                    }
                    this.onChanged();
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block11: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block11;
                            }
                            case 10: {
                                this.namespace_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 1;
                                continue block11;
                            }
                            case 18: {
                                String s = input.readStringRequireUtf8();
                                this.ensureAllowListIsMutable();
                                this.allowList_.add((Object)s);
                                continue block11;
                            }
                            case 26: {
                                String s = input.readStringRequireUtf8();
                                this.ensureDenyListIsMutable();
                                this.denyList_.add((Object)s);
                                continue block11;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public String getNamespace() {
                Object ref = this.namespace_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.namespace_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getNamespaceBytes() {
                Object ref = this.namespace_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.namespace_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setNamespace(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.namespace_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder clearNamespace() {
                this.namespace_ = Restriction.getDefaultInstance().getNamespace();
                this.bitField0_ &= 0xFFFFFFFE;
                this.onChanged();
                return this;
            }

            public Builder setNamespaceBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                Restriction.checkByteStringIsUtf8((ByteString)value);
                this.namespace_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            private void ensureAllowListIsMutable() {
                if (!this.allowList_.isModifiable()) {
                    this.allowList_ = new LazyStringArrayList((LazyStringList)this.allowList_);
                }
                this.bitField0_ |= 2;
            }

            public ProtocolStringList getAllowListList() {
                this.allowList_.makeImmutable();
                return this.allowList_;
            }

            @Override
            public int getAllowListCount() {
                return this.allowList_.size();
            }

            @Override
            public String getAllowList(int index) {
                return this.allowList_.get(index);
            }

            @Override
            public ByteString getAllowListBytes(int index) {
                return this.allowList_.getByteString(index);
            }

            public Builder setAllowList(int index, String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAllowListIsMutable();
                this.allowList_.set(index, value);
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder addAllowList(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAllowListIsMutable();
                this.allowList_.add((Object)value);
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder addAllAllowList(Iterable<String> values) {
                this.ensureAllowListIsMutable();
                AbstractMessageLite.Builder.addAll(values, (List)this.allowList_);
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder clearAllowList() {
                this.allowList_ = LazyStringArrayList.emptyList();
                this.bitField0_ &= 0xFFFFFFFD;
                this.onChanged();
                return this;
            }

            public Builder addAllowListBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                Restriction.checkByteStringIsUtf8((ByteString)value);
                this.ensureAllowListIsMutable();
                this.allowList_.add(value);
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            private void ensureDenyListIsMutable() {
                if (!this.denyList_.isModifiable()) {
                    this.denyList_ = new LazyStringArrayList((LazyStringList)this.denyList_);
                }
                this.bitField0_ |= 4;
            }

            public ProtocolStringList getDenyListList() {
                this.denyList_.makeImmutable();
                return this.denyList_;
            }

            @Override
            public int getDenyListCount() {
                return this.denyList_.size();
            }

            @Override
            public String getDenyList(int index) {
                return this.denyList_.get(index);
            }

            @Override
            public ByteString getDenyListBytes(int index) {
                return this.denyList_.getByteString(index);
            }

            public Builder setDenyList(int index, String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureDenyListIsMutable();
                this.denyList_.set(index, value);
                this.bitField0_ |= 4;
                this.onChanged();
                return this;
            }

            public Builder addDenyList(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureDenyListIsMutable();
                this.denyList_.add((Object)value);
                this.bitField0_ |= 4;
                this.onChanged();
                return this;
            }

            public Builder addAllDenyList(Iterable<String> values) {
                this.ensureDenyListIsMutable();
                AbstractMessageLite.Builder.addAll(values, (List)this.denyList_);
                this.bitField0_ |= 4;
                this.onChanged();
                return this;
            }

            public Builder clearDenyList() {
                this.denyList_ = LazyStringArrayList.emptyList();
                this.bitField0_ &= 0xFFFFFFFB;
                this.onChanged();
                return this;
            }

            public Builder addDenyListBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                Restriction.checkByteStringIsUtf8((ByteString)value);
                this.ensureDenyListIsMutable();
                this.denyList_.add(value);
                this.bitField0_ |= 4;
                this.onChanged();
                return this;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static interface RestrictionOrBuilder
    extends MessageOrBuilder {
        public String getNamespace();

        public ByteString getNamespaceBytes();

        public List<String> getAllowListList();

        public int getAllowListCount();

        public String getAllowList(int var1);

        public ByteString getAllowListBytes(int var1);

        public List<String> getDenyListList();

        public int getDenyListCount();

        public String getDenyList(int var1);

        public ByteString getDenyListBytes(int var1);
    }
}

