/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/featurestore_service.proto

package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Response message for [FeaturestoreService.ImportFeatureValues][google.cloud.aiplatform.v1.FeaturestoreService.ImportFeatureValues].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.ImportFeatureValuesResponse}
 */
public final class ImportFeatureValuesResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.ImportFeatureValuesResponse)
    ImportFeatureValuesResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ImportFeatureValuesResponse.newBuilder() to construct.
  private ImportFeatureValuesResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ImportFeatureValuesResponse() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ImportFeatureValuesResponse();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ImportFeatureValuesResponse(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 8:
            {
              importedEntityCount_ = input.readInt64();
              break;
            }
          case 16:
            {
              importedFeatureValueCount_ = input.readInt64();
              break;
            }
          case 48:
            {
              invalidRowCount_ = input.readInt64();
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
        .internal_static_google_cloud_aiplatform_v1_ImportFeatureValuesResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
        .internal_static_google_cloud_aiplatform_v1_ImportFeatureValuesResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.ImportFeatureValuesResponse.class,
            com.google.cloud.aiplatform.v1.ImportFeatureValuesResponse.Builder.class);
  }

  public static final int IMPORTED_ENTITY_COUNT_FIELD_NUMBER = 1;
  private long importedEntityCount_;
  /**
   *
   *
   * <pre>
   * Number of entities that have been imported by the operation.
   * </pre>
   *
   * <code>int64 imported_entity_count = 1;</code>
   *
   * @return The importedEntityCount.
   */
  @java.lang.Override
  public long getImportedEntityCount() {
    return importedEntityCount_;
  }

  public static final int IMPORTED_FEATURE_VALUE_COUNT_FIELD_NUMBER = 2;
  private long importedFeatureValueCount_;
  /**
   *
   *
   * <pre>
   * Number of Feature values that have been imported by the operation.
   * </pre>
   *
   * <code>int64 imported_feature_value_count = 2;</code>
   *
   * @return The importedFeatureValueCount.
   */
  @java.lang.Override
  public long getImportedFeatureValueCount() {
    return importedFeatureValueCount_;
  }

  public static final int INVALID_ROW_COUNT_FIELD_NUMBER = 6;
  private long invalidRowCount_;
  /**
   *
   *
   * <pre>
   * The number of rows in input source that weren't imported due to either
   * * Not having any featureValues.
   * * Having a null entityId.
   * * Having a null timestamp.
   * * Not being parsable (applicable for CSV sources).
   * </pre>
   *
   * <code>int64 invalid_row_count = 6;</code>
   *
   * @return The invalidRowCount.
   */
  @java.lang.Override
  public long getInvalidRowCount() {
    return invalidRowCount_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (importedEntityCount_ != 0L) {
      output.writeInt64(1, importedEntityCount_);
    }
    if (importedFeatureValueCount_ != 0L) {
      output.writeInt64(2, importedFeatureValueCount_);
    }
    if (invalidRowCount_ != 0L) {
      output.writeInt64(6, invalidRowCount_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (importedEntityCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, importedEntityCount_);
    }
    if (importedFeatureValueCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, importedFeatureValueCount_);
    }
    if (invalidRowCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(6, invalidRowCount_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.ImportFeatureValuesResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.ImportFeatureValuesResponse other =
        (com.google.cloud.aiplatform.v1.ImportFeatureValuesResponse) obj;

    if (getImportedEntityCount() != other.getImportedEntityCount()) return false;
    if (getImportedFeatureValueCount() != other.getImportedFeatureValueCount()) return false;
    if (getInvalidRowCount() != other.getInvalidRowCount()) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + IMPORTED_ENTITY_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getImportedEntityCount());
    hash = (37 * hash) + IMPORTED_FEATURE_VALUE_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getImportedFeatureValueCount());
    hash = (37 * hash) + INVALID_ROW_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getInvalidRowCount());
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.ImportFeatureValuesResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.ImportFeatureValuesResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ImportFeatureValuesResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.ImportFeatureValuesResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ImportFeatureValuesResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.ImportFeatureValuesResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ImportFeatureValuesResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.ImportFeatureValuesResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ImportFeatureValuesResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.ImportFeatureValuesResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ImportFeatureValuesResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.ImportFeatureValuesResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1.ImportFeatureValuesResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response message for [FeaturestoreService.ImportFeatureValues][google.cloud.aiplatform.v1.FeaturestoreService.ImportFeatureValues].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.ImportFeatureValuesResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.ImportFeatureValuesResponse)
      com.google.cloud.aiplatform.v1.ImportFeatureValuesResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
          .internal_static_google_cloud_aiplatform_v1_ImportFeatureValuesResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
          .internal_static_google_cloud_aiplatform_v1_ImportFeatureValuesResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.ImportFeatureValuesResponse.class,
              com.google.cloud.aiplatform.v1.ImportFeatureValuesResponse.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.ImportFeatureValuesResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      importedEntityCount_ = 0L;

      importedFeatureValueCount_ = 0L;

      invalidRowCount_ = 0L;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
          .internal_static_google_cloud_aiplatform_v1_ImportFeatureValuesResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ImportFeatureValuesResponse getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.ImportFeatureValuesResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ImportFeatureValuesResponse build() {
      com.google.cloud.aiplatform.v1.ImportFeatureValuesResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ImportFeatureValuesResponse buildPartial() {
      com.google.cloud.aiplatform.v1.ImportFeatureValuesResponse result =
          new com.google.cloud.aiplatform.v1.ImportFeatureValuesResponse(this);
      result.importedEntityCount_ = importedEntityCount_;
      result.importedFeatureValueCount_ = importedFeatureValueCount_;
      result.invalidRowCount_ = invalidRowCount_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.ImportFeatureValuesResponse) {
        return mergeFrom((com.google.cloud.aiplatform.v1.ImportFeatureValuesResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.ImportFeatureValuesResponse other) {
      if (other == com.google.cloud.aiplatform.v1.ImportFeatureValuesResponse.getDefaultInstance())
        return this;
      if (other.getImportedEntityCount() != 0L) {
        setImportedEntityCount(other.getImportedEntityCount());
      }
      if (other.getImportedFeatureValueCount() != 0L) {
        setImportedFeatureValueCount(other.getImportedFeatureValueCount());
      }
      if (other.getInvalidRowCount() != 0L) {
        setInvalidRowCount(other.getInvalidRowCount());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.aiplatform.v1.ImportFeatureValuesResponse parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.aiplatform.v1.ImportFeatureValuesResponse) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private long importedEntityCount_;
    /**
     *
     *
     * <pre>
     * Number of entities that have been imported by the operation.
     * </pre>
     *
     * <code>int64 imported_entity_count = 1;</code>
     *
     * @return The importedEntityCount.
     */
    @java.lang.Override
    public long getImportedEntityCount() {
      return importedEntityCount_;
    }
    /**
     *
     *
     * <pre>
     * Number of entities that have been imported by the operation.
     * </pre>
     *
     * <code>int64 imported_entity_count = 1;</code>
     *
     * @param value The importedEntityCount to set.
     * @return This builder for chaining.
     */
    public Builder setImportedEntityCount(long value) {

      importedEntityCount_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of entities that have been imported by the operation.
     * </pre>
     *
     * <code>int64 imported_entity_count = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImportedEntityCount() {

      importedEntityCount_ = 0L;
      onChanged();
      return this;
    }

    private long importedFeatureValueCount_;
    /**
     *
     *
     * <pre>
     * Number of Feature values that have been imported by the operation.
     * </pre>
     *
     * <code>int64 imported_feature_value_count = 2;</code>
     *
     * @return The importedFeatureValueCount.
     */
    @java.lang.Override
    public long getImportedFeatureValueCount() {
      return importedFeatureValueCount_;
    }
    /**
     *
     *
     * <pre>
     * Number of Feature values that have been imported by the operation.
     * </pre>
     *
     * <code>int64 imported_feature_value_count = 2;</code>
     *
     * @param value The importedFeatureValueCount to set.
     * @return This builder for chaining.
     */
    public Builder setImportedFeatureValueCount(long value) {

      importedFeatureValueCount_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of Feature values that have been imported by the operation.
     * </pre>
     *
     * <code>int64 imported_feature_value_count = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImportedFeatureValueCount() {

      importedFeatureValueCount_ = 0L;
      onChanged();
      return this;
    }

    private long invalidRowCount_;
    /**
     *
     *
     * <pre>
     * The number of rows in input source that weren't imported due to either
     * * Not having any featureValues.
     * * Having a null entityId.
     * * Having a null timestamp.
     * * Not being parsable (applicable for CSV sources).
     * </pre>
     *
     * <code>int64 invalid_row_count = 6;</code>
     *
     * @return The invalidRowCount.
     */
    @java.lang.Override
    public long getInvalidRowCount() {
      return invalidRowCount_;
    }
    /**
     *
     *
     * <pre>
     * The number of rows in input source that weren't imported due to either
     * * Not having any featureValues.
     * * Having a null entityId.
     * * Having a null timestamp.
     * * Not being parsable (applicable for CSV sources).
     * </pre>
     *
     * <code>int64 invalid_row_count = 6;</code>
     *
     * @param value The invalidRowCount to set.
     * @return This builder for chaining.
     */
    public Builder setInvalidRowCount(long value) {

      invalidRowCount_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of rows in input source that weren't imported due to either
     * * Not having any featureValues.
     * * Having a null entityId.
     * * Having a null timestamp.
     * * Not being parsable (applicable for CSV sources).
     * </pre>
     *
     * <code>int64 invalid_row_count = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInvalidRowCount() {

      invalidRowCount_ = 0L;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.ImportFeatureValuesResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.ImportFeatureValuesResponse)
  private static final com.google.cloud.aiplatform.v1.ImportFeatureValuesResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.ImportFeatureValuesResponse();
  }

  public static com.google.cloud.aiplatform.v1.ImportFeatureValuesResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ImportFeatureValuesResponse> PARSER =
      new com.google.protobuf.AbstractParser<ImportFeatureValuesResponse>() {
        @java.lang.Override
        public ImportFeatureValuesResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ImportFeatureValuesResponse(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ImportFeatureValuesResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ImportFeatureValuesResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ImportFeatureValuesResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
