/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/featurestore_service.proto

package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Request message for [FeaturestoreService.ExportFeatureValues][google.cloud.aiplatform.v1.FeaturestoreService.ExportFeatureValues].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.ExportFeatureValuesRequest}
 */
public final class ExportFeatureValuesRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.ExportFeatureValuesRequest)
    ExportFeatureValuesRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ExportFeatureValuesRequest.newBuilder() to construct.
  private ExportFeatureValuesRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ExportFeatureValuesRequest() {
    entityType_ = "";
    settings_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ExportFeatureValuesRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ExportFeatureValuesRequest(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              entityType_ = s;
              break;
            }
          case 26:
            {
              com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport.Builder
                  subBuilder = null;
              if (modeCase_ == 3) {
                subBuilder =
                    ((com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport)
                            mode_)
                        .toBuilder();
              }
              mode_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport
                          .parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport)
                        mode_);
                mode_ = subBuilder.buildPartial();
              }
              modeCase_ = 3;
              break;
            }
          case 34:
            {
              com.google.cloud.aiplatform.v1.FeatureValueDestination.Builder subBuilder = null;
              if (destination_ != null) {
                subBuilder = destination_.toBuilder();
              }
              destination_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1.FeatureValueDestination.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(destination_);
                destination_ = subBuilder.buildPartial();
              }

              break;
            }
          case 42:
            {
              com.google.cloud.aiplatform.v1.FeatureSelector.Builder subBuilder = null;
              if (featureSelector_ != null) {
                subBuilder = featureSelector_.toBuilder();
              }
              featureSelector_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1.FeatureSelector.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(featureSelector_);
                featureSelector_ = subBuilder.buildPartial();
              }

              break;
            }
          case 50:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                settings_ =
                    new java.util.ArrayList<
                        com.google.cloud.aiplatform.v1.DestinationFeatureSetting>();
                mutable_bitField0_ |= 0x00000001;
              }
              settings_.add(
                  input.readMessage(
                      com.google.cloud.aiplatform.v1.DestinationFeatureSetting.parser(),
                      extensionRegistry));
              break;
            }
          case 58:
            {
              com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport.Builder
                  subBuilder = null;
              if (modeCase_ == 7) {
                subBuilder =
                    ((com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport) mode_)
                        .toBuilder();
              }
              mode_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport) mode_);
                mode_ = subBuilder.buildPartial();
              }
              modeCase_ = 7;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        settings_ = java.util.Collections.unmodifiableList(settings_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
        .internal_static_google_cloud_aiplatform_v1_ExportFeatureValuesRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
        .internal_static_google_cloud_aiplatform_v1_ExportFeatureValuesRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.class,
            com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.Builder.class);
  }

  public interface SnapshotExportOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Exports Feature values as of this timestamp. If not set,
     * retrieve values as of now. Timestamp, if present, must not have higher
     * than millisecond precision.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
     *
     * @return Whether the snapshotTime field is set.
     */
    boolean hasSnapshotTime();
    /**
     *
     *
     * <pre>
     * Exports Feature values as of this timestamp. If not set,
     * retrieve values as of now. Timestamp, if present, must not have higher
     * than millisecond precision.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
     *
     * @return The snapshotTime.
     */
    com.google.protobuf.Timestamp getSnapshotTime();
    /**
     *
     *
     * <pre>
     * Exports Feature values as of this timestamp. If not set,
     * retrieve values as of now. Timestamp, if present, must not have higher
     * than millisecond precision.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
     */
    com.google.protobuf.TimestampOrBuilder getSnapshotTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * Excludes Feature values with feature generation timestamp before this
     * timestamp. If not set, retrieve oldest values kept in Feature Store.
     * Timestamp, if present, must not have higher than millisecond precision.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2;</code>
     *
     * @return Whether the startTime field is set.
     */
    boolean hasStartTime();
    /**
     *
     *
     * <pre>
     * Excludes Feature values with feature generation timestamp before this
     * timestamp. If not set, retrieve oldest values kept in Feature Store.
     * Timestamp, if present, must not have higher than millisecond precision.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2;</code>
     *
     * @return The startTime.
     */
    com.google.protobuf.Timestamp getStartTime();
    /**
     *
     *
     * <pre>
     * Excludes Feature values with feature generation timestamp before this
     * timestamp. If not set, retrieve oldest values kept in Feature Store.
     * Timestamp, if present, must not have higher than millisecond precision.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2;</code>
     */
    com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Describes exporting the latest Feature values of all entities of the
   * EntityType between [start_time, snapshot_time].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport}
   */
  public static final class SnapshotExport extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport)
      SnapshotExportOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SnapshotExport.newBuilder() to construct.
    private SnapshotExport(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SnapshotExport() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SnapshotExport();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private SnapshotExport(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.protobuf.Timestamp.Builder subBuilder = null;
                if (snapshotTime_ != null) {
                  subBuilder = snapshotTime_.toBuilder();
                }
                snapshotTime_ =
                    input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(snapshotTime_);
                  snapshotTime_ = subBuilder.buildPartial();
                }

                break;
              }
            case 18:
              {
                com.google.protobuf.Timestamp.Builder subBuilder = null;
                if (startTime_ != null) {
                  subBuilder = startTime_.toBuilder();
                }
                startTime_ =
                    input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(startTime_);
                  startTime_ = subBuilder.buildPartial();
                }

                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
          .internal_static_google_cloud_aiplatform_v1_ExportFeatureValuesRequest_SnapshotExport_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
          .internal_static_google_cloud_aiplatform_v1_ExportFeatureValuesRequest_SnapshotExport_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport.class,
              com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport.Builder
                  .class);
    }

    public static final int SNAPSHOT_TIME_FIELD_NUMBER = 1;
    private com.google.protobuf.Timestamp snapshotTime_;
    /**
     *
     *
     * <pre>
     * Exports Feature values as of this timestamp. If not set,
     * retrieve values as of now. Timestamp, if present, must not have higher
     * than millisecond precision.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
     *
     * @return Whether the snapshotTime field is set.
     */
    @java.lang.Override
    public boolean hasSnapshotTime() {
      return snapshotTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Exports Feature values as of this timestamp. If not set,
     * retrieve values as of now. Timestamp, if present, must not have higher
     * than millisecond precision.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
     *
     * @return The snapshotTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getSnapshotTime() {
      return snapshotTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : snapshotTime_;
    }
    /**
     *
     *
     * <pre>
     * Exports Feature values as of this timestamp. If not set,
     * retrieve values as of now. Timestamp, if present, must not have higher
     * than millisecond precision.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getSnapshotTimeOrBuilder() {
      return getSnapshotTime();
    }

    public static final int START_TIME_FIELD_NUMBER = 2;
    private com.google.protobuf.Timestamp startTime_;
    /**
     *
     *
     * <pre>
     * Excludes Feature values with feature generation timestamp before this
     * timestamp. If not set, retrieve oldest values kept in Feature Store.
     * Timestamp, if present, must not have higher than millisecond precision.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2;</code>
     *
     * @return Whether the startTime field is set.
     */
    @java.lang.Override
    public boolean hasStartTime() {
      return startTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Excludes Feature values with feature generation timestamp before this
     * timestamp. If not set, retrieve oldest values kept in Feature Store.
     * Timestamp, if present, must not have higher than millisecond precision.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2;</code>
     *
     * @return The startTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getStartTime() {
      return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
    }
    /**
     *
     *
     * <pre>
     * Excludes Feature values with feature generation timestamp before this
     * timestamp. If not set, retrieve oldest values kept in Feature Store.
     * Timestamp, if present, must not have higher than millisecond precision.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      return getStartTime();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (snapshotTime_ != null) {
        output.writeMessage(1, getSnapshotTime());
      }
      if (startTime_ != null) {
        output.writeMessage(2, getStartTime());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (snapshotTime_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getSnapshotTime());
      }
      if (startTime_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getStartTime());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport other =
          (com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport) obj;

      if (hasSnapshotTime() != other.hasSnapshotTime()) return false;
      if (hasSnapshotTime()) {
        if (!getSnapshotTime().equals(other.getSnapshotTime())) return false;
      }
      if (hasStartTime() != other.hasStartTime()) return false;
      if (hasStartTime()) {
        if (!getStartTime().equals(other.getStartTime())) return false;
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasSnapshotTime()) {
        hash = (37 * hash) + SNAPSHOT_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getSnapshotTime().hashCode();
      }
      if (hasStartTime()) {
        hash = (37 * hash) + START_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getStartTime().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Describes exporting the latest Feature values of all entities of the
     * EntityType between [start_time, snapshot_time].
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport)
        com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExportOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
            .internal_static_google_cloud_aiplatform_v1_ExportFeatureValuesRequest_SnapshotExport_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
            .internal_static_google_cloud_aiplatform_v1_ExportFeatureValuesRequest_SnapshotExport_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport.class,
                com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (snapshotTimeBuilder_ == null) {
          snapshotTime_ = null;
        } else {
          snapshotTime_ = null;
          snapshotTimeBuilder_ = null;
        }
        if (startTimeBuilder_ == null) {
          startTime_ = null;
        } else {
          startTime_ = null;
          startTimeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
            .internal_static_google_cloud_aiplatform_v1_ExportFeatureValuesRequest_SnapshotExport_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport build() {
        com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport
          buildPartial() {
        com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport result =
            new com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport(this);
        if (snapshotTimeBuilder_ == null) {
          result.snapshotTime_ = snapshotTime_;
        } else {
          result.snapshotTime_ = snapshotTimeBuilder_.build();
        }
        if (startTimeBuilder_ == null) {
          result.startTime_ = startTime_;
        } else {
          result.startTime_ = startTimeBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport other) {
        if (other
            == com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport
                .getDefaultInstance()) return this;
        if (other.hasSnapshotTime()) {
          mergeSnapshotTime(other.getSnapshotTime());
        }
        if (other.hasStartTime()) {
          mergeStartTime(other.getStartTime());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport parsedMessage =
            null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private com.google.protobuf.Timestamp snapshotTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          snapshotTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Exports Feature values as of this timestamp. If not set,
       * retrieve values as of now. Timestamp, if present, must not have higher
       * than millisecond precision.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
       *
       * @return Whether the snapshotTime field is set.
       */
      public boolean hasSnapshotTime() {
        return snapshotTimeBuilder_ != null || snapshotTime_ != null;
      }
      /**
       *
       *
       * <pre>
       * Exports Feature values as of this timestamp. If not set,
       * retrieve values as of now. Timestamp, if present, must not have higher
       * than millisecond precision.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
       *
       * @return The snapshotTime.
       */
      public com.google.protobuf.Timestamp getSnapshotTime() {
        if (snapshotTimeBuilder_ == null) {
          return snapshotTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : snapshotTime_;
        } else {
          return snapshotTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Exports Feature values as of this timestamp. If not set,
       * retrieve values as of now. Timestamp, if present, must not have higher
       * than millisecond precision.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
       */
      public Builder setSnapshotTime(com.google.protobuf.Timestamp value) {
        if (snapshotTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          snapshotTime_ = value;
          onChanged();
        } else {
          snapshotTimeBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Exports Feature values as of this timestamp. If not set,
       * retrieve values as of now. Timestamp, if present, must not have higher
       * than millisecond precision.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
       */
      public Builder setSnapshotTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (snapshotTimeBuilder_ == null) {
          snapshotTime_ = builderForValue.build();
          onChanged();
        } else {
          snapshotTimeBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Exports Feature values as of this timestamp. If not set,
       * retrieve values as of now. Timestamp, if present, must not have higher
       * than millisecond precision.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
       */
      public Builder mergeSnapshotTime(com.google.protobuf.Timestamp value) {
        if (snapshotTimeBuilder_ == null) {
          if (snapshotTime_ != null) {
            snapshotTime_ =
                com.google.protobuf.Timestamp.newBuilder(snapshotTime_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            snapshotTime_ = value;
          }
          onChanged();
        } else {
          snapshotTimeBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Exports Feature values as of this timestamp. If not set,
       * retrieve values as of now. Timestamp, if present, must not have higher
       * than millisecond precision.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
       */
      public Builder clearSnapshotTime() {
        if (snapshotTimeBuilder_ == null) {
          snapshotTime_ = null;
          onChanged();
        } else {
          snapshotTime_ = null;
          snapshotTimeBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Exports Feature values as of this timestamp. If not set,
       * retrieve values as of now. Timestamp, if present, must not have higher
       * than millisecond precision.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
       */
      public com.google.protobuf.Timestamp.Builder getSnapshotTimeBuilder() {

        onChanged();
        return getSnapshotTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Exports Feature values as of this timestamp. If not set,
       * retrieve values as of now. Timestamp, if present, must not have higher
       * than millisecond precision.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getSnapshotTimeOrBuilder() {
        if (snapshotTimeBuilder_ != null) {
          return snapshotTimeBuilder_.getMessageOrBuilder();
        } else {
          return snapshotTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : snapshotTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Exports Feature values as of this timestamp. If not set,
       * retrieve values as of now. Timestamp, if present, must not have higher
       * than millisecond precision.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getSnapshotTimeFieldBuilder() {
        if (snapshotTimeBuilder_ == null) {
          snapshotTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getSnapshotTime(), getParentForChildren(), isClean());
          snapshotTime_ = null;
        }
        return snapshotTimeBuilder_;
      }

      private com.google.protobuf.Timestamp startTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          startTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Excludes Feature values with feature generation timestamp before this
       * timestamp. If not set, retrieve oldest values kept in Feature Store.
       * Timestamp, if present, must not have higher than millisecond precision.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 2;</code>
       *
       * @return Whether the startTime field is set.
       */
      public boolean hasStartTime() {
        return startTimeBuilder_ != null || startTime_ != null;
      }
      /**
       *
       *
       * <pre>
       * Excludes Feature values with feature generation timestamp before this
       * timestamp. If not set, retrieve oldest values kept in Feature Store.
       * Timestamp, if present, must not have higher than millisecond precision.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 2;</code>
       *
       * @return The startTime.
       */
      public com.google.protobuf.Timestamp getStartTime() {
        if (startTimeBuilder_ == null) {
          return startTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : startTime_;
        } else {
          return startTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Excludes Feature values with feature generation timestamp before this
       * timestamp. If not set, retrieve oldest values kept in Feature Store.
       * Timestamp, if present, must not have higher than millisecond precision.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 2;</code>
       */
      public Builder setStartTime(com.google.protobuf.Timestamp value) {
        if (startTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          startTime_ = value;
          onChanged();
        } else {
          startTimeBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Excludes Feature values with feature generation timestamp before this
       * timestamp. If not set, retrieve oldest values kept in Feature Store.
       * Timestamp, if present, must not have higher than millisecond precision.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 2;</code>
       */
      public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (startTimeBuilder_ == null) {
          startTime_ = builderForValue.build();
          onChanged();
        } else {
          startTimeBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Excludes Feature values with feature generation timestamp before this
       * timestamp. If not set, retrieve oldest values kept in Feature Store.
       * Timestamp, if present, must not have higher than millisecond precision.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 2;</code>
       */
      public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
        if (startTimeBuilder_ == null) {
          if (startTime_ != null) {
            startTime_ =
                com.google.protobuf.Timestamp.newBuilder(startTime_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            startTime_ = value;
          }
          onChanged();
        } else {
          startTimeBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Excludes Feature values with feature generation timestamp before this
       * timestamp. If not set, retrieve oldest values kept in Feature Store.
       * Timestamp, if present, must not have higher than millisecond precision.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 2;</code>
       */
      public Builder clearStartTime() {
        if (startTimeBuilder_ == null) {
          startTime_ = null;
          onChanged();
        } else {
          startTime_ = null;
          startTimeBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Excludes Feature values with feature generation timestamp before this
       * timestamp. If not set, retrieve oldest values kept in Feature Store.
       * Timestamp, if present, must not have higher than millisecond precision.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 2;</code>
       */
      public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {

        onChanged();
        return getStartTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Excludes Feature values with feature generation timestamp before this
       * timestamp. If not set, retrieve oldest values kept in Feature Store.
       * Timestamp, if present, must not have higher than millisecond precision.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 2;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
        if (startTimeBuilder_ != null) {
          return startTimeBuilder_.getMessageOrBuilder();
        } else {
          return startTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : startTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Excludes Feature values with feature generation timestamp before this
       * timestamp. If not set, retrieve oldest values kept in Feature Store.
       * Timestamp, if present, must not have higher than millisecond precision.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getStartTimeFieldBuilder() {
        if (startTimeBuilder_ == null) {
          startTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getStartTime(), getParentForChildren(), isClean());
          startTime_ = null;
        }
        return startTimeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport)
    private static final com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport();
    }

    public static com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SnapshotExport> PARSER =
        new com.google.protobuf.AbstractParser<SnapshotExport>() {
          @java.lang.Override
          public SnapshotExport parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new SnapshotExport(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<SnapshotExport> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SnapshotExport> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface FullExportOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Excludes Feature values with feature generation timestamp before this
     * timestamp. If not set, retrieve oldest values kept in Feature Store.
     * Timestamp, if present, must not have higher than millisecond precision.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2;</code>
     *
     * @return Whether the startTime field is set.
     */
    boolean hasStartTime();
    /**
     *
     *
     * <pre>
     * Excludes Feature values with feature generation timestamp before this
     * timestamp. If not set, retrieve oldest values kept in Feature Store.
     * Timestamp, if present, must not have higher than millisecond precision.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2;</code>
     *
     * @return The startTime.
     */
    com.google.protobuf.Timestamp getStartTime();
    /**
     *
     *
     * <pre>
     * Excludes Feature values with feature generation timestamp before this
     * timestamp. If not set, retrieve oldest values kept in Feature Store.
     * Timestamp, if present, must not have higher than millisecond precision.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2;</code>
     */
    com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * Exports Feature values as of this timestamp. If not set,
     * retrieve values as of now. Timestamp, if present, must not have higher
     * than millisecond precision.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 1;</code>
     *
     * @return Whether the endTime field is set.
     */
    boolean hasEndTime();
    /**
     *
     *
     * <pre>
     * Exports Feature values as of this timestamp. If not set,
     * retrieve values as of now. Timestamp, if present, must not have higher
     * than millisecond precision.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 1;</code>
     *
     * @return The endTime.
     */
    com.google.protobuf.Timestamp getEndTime();
    /**
     *
     *
     * <pre>
     * Exports Feature values as of this timestamp. If not set,
     * retrieve values as of now. Timestamp, if present, must not have higher
     * than millisecond precision.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 1;</code>
     */
    com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Describes exporting all historical Feature values of all entities of the
   * EntityType between [start_time, end_time].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport}
   */
  public static final class FullExport extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport)
      FullExportOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use FullExport.newBuilder() to construct.
    private FullExport(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private FullExport() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new FullExport();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private FullExport(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.protobuf.Timestamp.Builder subBuilder = null;
                if (endTime_ != null) {
                  subBuilder = endTime_.toBuilder();
                }
                endTime_ =
                    input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(endTime_);
                  endTime_ = subBuilder.buildPartial();
                }

                break;
              }
            case 18:
              {
                com.google.protobuf.Timestamp.Builder subBuilder = null;
                if (startTime_ != null) {
                  subBuilder = startTime_.toBuilder();
                }
                startTime_ =
                    input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(startTime_);
                  startTime_ = subBuilder.buildPartial();
                }

                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
          .internal_static_google_cloud_aiplatform_v1_ExportFeatureValuesRequest_FullExport_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
          .internal_static_google_cloud_aiplatform_v1_ExportFeatureValuesRequest_FullExport_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport.class,
              com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport.Builder.class);
    }

    public static final int START_TIME_FIELD_NUMBER = 2;
    private com.google.protobuf.Timestamp startTime_;
    /**
     *
     *
     * <pre>
     * Excludes Feature values with feature generation timestamp before this
     * timestamp. If not set, retrieve oldest values kept in Feature Store.
     * Timestamp, if present, must not have higher than millisecond precision.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2;</code>
     *
     * @return Whether the startTime field is set.
     */
    @java.lang.Override
    public boolean hasStartTime() {
      return startTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Excludes Feature values with feature generation timestamp before this
     * timestamp. If not set, retrieve oldest values kept in Feature Store.
     * Timestamp, if present, must not have higher than millisecond precision.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2;</code>
     *
     * @return The startTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getStartTime() {
      return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
    }
    /**
     *
     *
     * <pre>
     * Excludes Feature values with feature generation timestamp before this
     * timestamp. If not set, retrieve oldest values kept in Feature Store.
     * Timestamp, if present, must not have higher than millisecond precision.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      return getStartTime();
    }

    public static final int END_TIME_FIELD_NUMBER = 1;
    private com.google.protobuf.Timestamp endTime_;
    /**
     *
     *
     * <pre>
     * Exports Feature values as of this timestamp. If not set,
     * retrieve values as of now. Timestamp, if present, must not have higher
     * than millisecond precision.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 1;</code>
     *
     * @return Whether the endTime field is set.
     */
    @java.lang.Override
    public boolean hasEndTime() {
      return endTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Exports Feature values as of this timestamp. If not set,
     * retrieve values as of now. Timestamp, if present, must not have higher
     * than millisecond precision.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 1;</code>
     *
     * @return The endTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getEndTime() {
      return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
    }
    /**
     *
     *
     * <pre>
     * Exports Feature values as of this timestamp. If not set,
     * retrieve values as of now. Timestamp, if present, must not have higher
     * than millisecond precision.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 1;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      return getEndTime();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (endTime_ != null) {
        output.writeMessage(1, getEndTime());
      }
      if (startTime_ != null) {
        output.writeMessage(2, getStartTime());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (endTime_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getEndTime());
      }
      if (startTime_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getStartTime());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport other =
          (com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport) obj;

      if (hasStartTime() != other.hasStartTime()) return false;
      if (hasStartTime()) {
        if (!getStartTime().equals(other.getStartTime())) return false;
      }
      if (hasEndTime() != other.hasEndTime()) return false;
      if (hasEndTime()) {
        if (!getEndTime().equals(other.getEndTime())) return false;
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasStartTime()) {
        hash = (37 * hash) + START_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getStartTime().hashCode();
      }
      if (hasEndTime()) {
        hash = (37 * hash) + END_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getEndTime().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Describes exporting all historical Feature values of all entities of the
     * EntityType between [start_time, end_time].
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport)
        com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExportOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
            .internal_static_google_cloud_aiplatform_v1_ExportFeatureValuesRequest_FullExport_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
            .internal_static_google_cloud_aiplatform_v1_ExportFeatureValuesRequest_FullExport_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport.class,
                com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (startTimeBuilder_ == null) {
          startTime_ = null;
        } else {
          startTime_ = null;
          startTimeBuilder_ = null;
        }
        if (endTimeBuilder_ == null) {
          endTime_ = null;
        } else {
          endTime_ = null;
          endTimeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
            .internal_static_google_cloud_aiplatform_v1_ExportFeatureValuesRequest_FullExport_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport build() {
        com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport buildPartial() {
        com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport result =
            new com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport(this);
        if (startTimeBuilder_ == null) {
          result.startTime_ = startTime_;
        } else {
          result.startTime_ = startTimeBuilder_.build();
        }
        if (endTimeBuilder_ == null) {
          result.endTime_ = endTime_;
        } else {
          result.endTime_ = endTimeBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport other) {
        if (other
            == com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport
                .getDefaultInstance()) return this;
        if (other.hasStartTime()) {
          mergeStartTime(other.getStartTime());
        }
        if (other.hasEndTime()) {
          mergeEndTime(other.getEndTime());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private com.google.protobuf.Timestamp startTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          startTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Excludes Feature values with feature generation timestamp before this
       * timestamp. If not set, retrieve oldest values kept in Feature Store.
       * Timestamp, if present, must not have higher than millisecond precision.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 2;</code>
       *
       * @return Whether the startTime field is set.
       */
      public boolean hasStartTime() {
        return startTimeBuilder_ != null || startTime_ != null;
      }
      /**
       *
       *
       * <pre>
       * Excludes Feature values with feature generation timestamp before this
       * timestamp. If not set, retrieve oldest values kept in Feature Store.
       * Timestamp, if present, must not have higher than millisecond precision.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 2;</code>
       *
       * @return The startTime.
       */
      public com.google.protobuf.Timestamp getStartTime() {
        if (startTimeBuilder_ == null) {
          return startTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : startTime_;
        } else {
          return startTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Excludes Feature values with feature generation timestamp before this
       * timestamp. If not set, retrieve oldest values kept in Feature Store.
       * Timestamp, if present, must not have higher than millisecond precision.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 2;</code>
       */
      public Builder setStartTime(com.google.protobuf.Timestamp value) {
        if (startTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          startTime_ = value;
          onChanged();
        } else {
          startTimeBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Excludes Feature values with feature generation timestamp before this
       * timestamp. If not set, retrieve oldest values kept in Feature Store.
       * Timestamp, if present, must not have higher than millisecond precision.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 2;</code>
       */
      public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (startTimeBuilder_ == null) {
          startTime_ = builderForValue.build();
          onChanged();
        } else {
          startTimeBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Excludes Feature values with feature generation timestamp before this
       * timestamp. If not set, retrieve oldest values kept in Feature Store.
       * Timestamp, if present, must not have higher than millisecond precision.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 2;</code>
       */
      public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
        if (startTimeBuilder_ == null) {
          if (startTime_ != null) {
            startTime_ =
                com.google.protobuf.Timestamp.newBuilder(startTime_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            startTime_ = value;
          }
          onChanged();
        } else {
          startTimeBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Excludes Feature values with feature generation timestamp before this
       * timestamp. If not set, retrieve oldest values kept in Feature Store.
       * Timestamp, if present, must not have higher than millisecond precision.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 2;</code>
       */
      public Builder clearStartTime() {
        if (startTimeBuilder_ == null) {
          startTime_ = null;
          onChanged();
        } else {
          startTime_ = null;
          startTimeBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Excludes Feature values with feature generation timestamp before this
       * timestamp. If not set, retrieve oldest values kept in Feature Store.
       * Timestamp, if present, must not have higher than millisecond precision.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 2;</code>
       */
      public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {

        onChanged();
        return getStartTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Excludes Feature values with feature generation timestamp before this
       * timestamp. If not set, retrieve oldest values kept in Feature Store.
       * Timestamp, if present, must not have higher than millisecond precision.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 2;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
        if (startTimeBuilder_ != null) {
          return startTimeBuilder_.getMessageOrBuilder();
        } else {
          return startTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : startTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Excludes Feature values with feature generation timestamp before this
       * timestamp. If not set, retrieve oldest values kept in Feature Store.
       * Timestamp, if present, must not have higher than millisecond precision.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getStartTimeFieldBuilder() {
        if (startTimeBuilder_ == null) {
          startTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getStartTime(), getParentForChildren(), isClean());
          startTime_ = null;
        }
        return startTimeBuilder_;
      }

      private com.google.protobuf.Timestamp endTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          endTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Exports Feature values as of this timestamp. If not set,
       * retrieve values as of now. Timestamp, if present, must not have higher
       * than millisecond precision.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 1;</code>
       *
       * @return Whether the endTime field is set.
       */
      public boolean hasEndTime() {
        return endTimeBuilder_ != null || endTime_ != null;
      }
      /**
       *
       *
       * <pre>
       * Exports Feature values as of this timestamp. If not set,
       * retrieve values as of now. Timestamp, if present, must not have higher
       * than millisecond precision.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 1;</code>
       *
       * @return The endTime.
       */
      public com.google.protobuf.Timestamp getEndTime() {
        if (endTimeBuilder_ == null) {
          return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
        } else {
          return endTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Exports Feature values as of this timestamp. If not set,
       * retrieve values as of now. Timestamp, if present, must not have higher
       * than millisecond precision.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 1;</code>
       */
      public Builder setEndTime(com.google.protobuf.Timestamp value) {
        if (endTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          endTime_ = value;
          onChanged();
        } else {
          endTimeBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Exports Feature values as of this timestamp. If not set,
       * retrieve values as of now. Timestamp, if present, must not have higher
       * than millisecond precision.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 1;</code>
       */
      public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (endTimeBuilder_ == null) {
          endTime_ = builderForValue.build();
          onChanged();
        } else {
          endTimeBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Exports Feature values as of this timestamp. If not set,
       * retrieve values as of now. Timestamp, if present, must not have higher
       * than millisecond precision.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 1;</code>
       */
      public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
        if (endTimeBuilder_ == null) {
          if (endTime_ != null) {
            endTime_ =
                com.google.protobuf.Timestamp.newBuilder(endTime_).mergeFrom(value).buildPartial();
          } else {
            endTime_ = value;
          }
          onChanged();
        } else {
          endTimeBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Exports Feature values as of this timestamp. If not set,
       * retrieve values as of now. Timestamp, if present, must not have higher
       * than millisecond precision.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 1;</code>
       */
      public Builder clearEndTime() {
        if (endTimeBuilder_ == null) {
          endTime_ = null;
          onChanged();
        } else {
          endTime_ = null;
          endTimeBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Exports Feature values as of this timestamp. If not set,
       * retrieve values as of now. Timestamp, if present, must not have higher
       * than millisecond precision.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 1;</code>
       */
      public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {

        onChanged();
        return getEndTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Exports Feature values as of this timestamp. If not set,
       * retrieve values as of now. Timestamp, if present, must not have higher
       * than millisecond precision.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 1;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
        if (endTimeBuilder_ != null) {
          return endTimeBuilder_.getMessageOrBuilder();
        } else {
          return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Exports Feature values as of this timestamp. If not set,
       * retrieve values as of now. Timestamp, if present, must not have higher
       * than millisecond precision.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getEndTimeFieldBuilder() {
        if (endTimeBuilder_ == null) {
          endTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getEndTime(), getParentForChildren(), isClean());
          endTime_ = null;
        }
        return endTimeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport)
    private static final com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport();
    }

    public static com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<FullExport> PARSER =
        new com.google.protobuf.AbstractParser<FullExport>() {
          @java.lang.Override
          public FullExport parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new FullExport(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<FullExport> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FullExport> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int modeCase_ = 0;
  private java.lang.Object mode_;

  public enum ModeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    SNAPSHOT_EXPORT(3),
    FULL_EXPORT(7),
    MODE_NOT_SET(0);
    private final int value;

    private ModeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ModeCase valueOf(int value) {
      return forNumber(value);
    }

    public static ModeCase forNumber(int value) {
      switch (value) {
        case 3:
          return SNAPSHOT_EXPORT;
        case 7:
          return FULL_EXPORT;
        case 0:
          return MODE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ModeCase getModeCase() {
    return ModeCase.forNumber(modeCase_);
  }

  public static final int SNAPSHOT_EXPORT_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Exports the latest Feature values of all entities of the EntityType
   * within a time range.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport snapshot_export = 3;
   * </code>
   *
   * @return Whether the snapshotExport field is set.
   */
  @java.lang.Override
  public boolean hasSnapshotExport() {
    return modeCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Exports the latest Feature values of all entities of the EntityType
   * within a time range.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport snapshot_export = 3;
   * </code>
   *
   * @return The snapshotExport.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport
      getSnapshotExport() {
    if (modeCase_ == 3) {
      return (com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport) mode_;
    }
    return com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Exports the latest Feature values of all entities of the EntityType
   * within a time range.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport snapshot_export = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExportOrBuilder
      getSnapshotExportOrBuilder() {
    if (modeCase_ == 3) {
      return (com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport) mode_;
    }
    return com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport
        .getDefaultInstance();
  }

  public static final int FULL_EXPORT_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Exports all historical values of all entities of the EntityType within a
   * time range
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport full_export = 7;</code>
   *
   * @return Whether the fullExport field is set.
   */
  @java.lang.Override
  public boolean hasFullExport() {
    return modeCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Exports all historical values of all entities of the EntityType within a
   * time range
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport full_export = 7;</code>
   *
   * @return The fullExport.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport getFullExport() {
    if (modeCase_ == 7) {
      return (com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport) mode_;
    }
    return com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Exports all historical values of all entities of the EntityType within a
   * time range
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport full_export = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExportOrBuilder
      getFullExportOrBuilder() {
    if (modeCase_ == 7) {
      return (com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport) mode_;
    }
    return com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport
        .getDefaultInstance();
  }

  public static final int ENTITY_TYPE_FIELD_NUMBER = 1;
  private volatile java.lang.Object entityType_;
  /**
   *
   *
   * <pre>
   * Required. The resource name of the EntityType from which to export Feature values.
   * Format:
   * `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
   * </pre>
   *
   * <code>
   * string entity_type = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The entityType.
   */
  @java.lang.Override
  public java.lang.String getEntityType() {
    java.lang.Object ref = entityType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      entityType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the EntityType from which to export Feature values.
   * Format:
   * `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
   * </pre>
   *
   * <code>
   * string entity_type = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for entityType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEntityTypeBytes() {
    java.lang.Object ref = entityType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      entityType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESTINATION_FIELD_NUMBER = 4;
  private com.google.cloud.aiplatform.v1.FeatureValueDestination destination_;
  /**
   *
   *
   * <pre>
   * Required. Specifies destination location and format.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.FeatureValueDestination destination = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the destination field is set.
   */
  @java.lang.Override
  public boolean hasDestination() {
    return destination_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. Specifies destination location and format.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.FeatureValueDestination destination = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The destination.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FeatureValueDestination getDestination() {
    return destination_ == null
        ? com.google.cloud.aiplatform.v1.FeatureValueDestination.getDefaultInstance()
        : destination_;
  }
  /**
   *
   *
   * <pre>
   * Required. Specifies destination location and format.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.FeatureValueDestination destination = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FeatureValueDestinationOrBuilder getDestinationOrBuilder() {
    return getDestination();
  }

  public static final int FEATURE_SELECTOR_FIELD_NUMBER = 5;
  private com.google.cloud.aiplatform.v1.FeatureSelector featureSelector_;
  /**
   *
   *
   * <pre>
   * Required. Selects Features to export values of.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.FeatureSelector feature_selector = 5 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the featureSelector field is set.
   */
  @java.lang.Override
  public boolean hasFeatureSelector() {
    return featureSelector_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. Selects Features to export values of.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.FeatureSelector feature_selector = 5 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The featureSelector.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FeatureSelector getFeatureSelector() {
    return featureSelector_ == null
        ? com.google.cloud.aiplatform.v1.FeatureSelector.getDefaultInstance()
        : featureSelector_;
  }
  /**
   *
   *
   * <pre>
   * Required. Selects Features to export values of.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.FeatureSelector feature_selector = 5 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FeatureSelectorOrBuilder getFeatureSelectorOrBuilder() {
    return getFeatureSelector();
  }

  public static final int SETTINGS_FIELD_NUMBER = 6;
  private java.util.List<com.google.cloud.aiplatform.v1.DestinationFeatureSetting> settings_;
  /**
   *
   *
   * <pre>
   * Per-Feature export settings.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1.DestinationFeatureSetting settings = 6;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1.DestinationFeatureSetting>
      getSettingsList() {
    return settings_;
  }
  /**
   *
   *
   * <pre>
   * Per-Feature export settings.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1.DestinationFeatureSetting settings = 6;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1.DestinationFeatureSettingOrBuilder>
      getSettingsOrBuilderList() {
    return settings_;
  }
  /**
   *
   *
   * <pre>
   * Per-Feature export settings.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1.DestinationFeatureSetting settings = 6;</code>
   */
  @java.lang.Override
  public int getSettingsCount() {
    return settings_.size();
  }
  /**
   *
   *
   * <pre>
   * Per-Feature export settings.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1.DestinationFeatureSetting settings = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.DestinationFeatureSetting getSettings(int index) {
    return settings_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Per-Feature export settings.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1.DestinationFeatureSetting settings = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.DestinationFeatureSettingOrBuilder getSettingsOrBuilder(
      int index) {
    return settings_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entityType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, entityType_);
    }
    if (modeCase_ == 3) {
      output.writeMessage(
          3, (com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport) mode_);
    }
    if (destination_ != null) {
      output.writeMessage(4, getDestination());
    }
    if (featureSelector_ != null) {
      output.writeMessage(5, getFeatureSelector());
    }
    for (int i = 0; i < settings_.size(); i++) {
      output.writeMessage(6, settings_.get(i));
    }
    if (modeCase_ == 7) {
      output.writeMessage(
          7, (com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport) mode_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entityType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, entityType_);
    }
    if (modeCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport) mode_);
    }
    if (destination_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getDestination());
    }
    if (featureSelector_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getFeatureSelector());
    }
    for (int i = 0; i < settings_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, settings_.get(i));
    }
    if (modeCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport) mode_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest other =
        (com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest) obj;

    if (!getEntityType().equals(other.getEntityType())) return false;
    if (hasDestination() != other.hasDestination()) return false;
    if (hasDestination()) {
      if (!getDestination().equals(other.getDestination())) return false;
    }
    if (hasFeatureSelector() != other.hasFeatureSelector()) return false;
    if (hasFeatureSelector()) {
      if (!getFeatureSelector().equals(other.getFeatureSelector())) return false;
    }
    if (!getSettingsList().equals(other.getSettingsList())) return false;
    if (!getModeCase().equals(other.getModeCase())) return false;
    switch (modeCase_) {
      case 3:
        if (!getSnapshotExport().equals(other.getSnapshotExport())) return false;
        break;
      case 7:
        if (!getFullExport().equals(other.getFullExport())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ENTITY_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getEntityType().hashCode();
    if (hasDestination()) {
      hash = (37 * hash) + DESTINATION_FIELD_NUMBER;
      hash = (53 * hash) + getDestination().hashCode();
    }
    if (hasFeatureSelector()) {
      hash = (37 * hash) + FEATURE_SELECTOR_FIELD_NUMBER;
      hash = (53 * hash) + getFeatureSelector().hashCode();
    }
    if (getSettingsCount() > 0) {
      hash = (37 * hash) + SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getSettingsList().hashCode();
    }
    switch (modeCase_) {
      case 3:
        hash = (37 * hash) + SNAPSHOT_EXPORT_FIELD_NUMBER;
        hash = (53 * hash) + getSnapshotExport().hashCode();
        break;
      case 7:
        hash = (37 * hash) + FULL_EXPORT_FIELD_NUMBER;
        hash = (53 * hash) + getFullExport().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for [FeaturestoreService.ExportFeatureValues][google.cloud.aiplatform.v1.FeaturestoreService.ExportFeatureValues].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.ExportFeatureValuesRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.ExportFeatureValuesRequest)
      com.google.cloud.aiplatform.v1.ExportFeatureValuesRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
          .internal_static_google_cloud_aiplatform_v1_ExportFeatureValuesRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
          .internal_static_google_cloud_aiplatform_v1_ExportFeatureValuesRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.class,
              com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSettingsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      entityType_ = "";

      if (destinationBuilder_ == null) {
        destination_ = null;
      } else {
        destination_ = null;
        destinationBuilder_ = null;
      }
      if (featureSelectorBuilder_ == null) {
        featureSelector_ = null;
      } else {
        featureSelector_ = null;
        featureSelectorBuilder_ = null;
      }
      if (settingsBuilder_ == null) {
        settings_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        settingsBuilder_.clear();
      }
      modeCase_ = 0;
      mode_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
          .internal_static_google_cloud_aiplatform_v1_ExportFeatureValuesRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest build() {
      com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest buildPartial() {
      com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest result =
          new com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest(this);
      int from_bitField0_ = bitField0_;
      if (modeCase_ == 3) {
        if (snapshotExportBuilder_ == null) {
          result.mode_ = mode_;
        } else {
          result.mode_ = snapshotExportBuilder_.build();
        }
      }
      if (modeCase_ == 7) {
        if (fullExportBuilder_ == null) {
          result.mode_ = mode_;
        } else {
          result.mode_ = fullExportBuilder_.build();
        }
      }
      result.entityType_ = entityType_;
      if (destinationBuilder_ == null) {
        result.destination_ = destination_;
      } else {
        result.destination_ = destinationBuilder_.build();
      }
      if (featureSelectorBuilder_ == null) {
        result.featureSelector_ = featureSelector_;
      } else {
        result.featureSelector_ = featureSelectorBuilder_.build();
      }
      if (settingsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          settings_ = java.util.Collections.unmodifiableList(settings_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.settings_ = settings_;
      } else {
        result.settings_ = settingsBuilder_.build();
      }
      result.modeCase_ = modeCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest) {
        return mergeFrom((com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest other) {
      if (other == com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.getDefaultInstance())
        return this;
      if (!other.getEntityType().isEmpty()) {
        entityType_ = other.entityType_;
        onChanged();
      }
      if (other.hasDestination()) {
        mergeDestination(other.getDestination());
      }
      if (other.hasFeatureSelector()) {
        mergeFeatureSelector(other.getFeatureSelector());
      }
      if (settingsBuilder_ == null) {
        if (!other.settings_.isEmpty()) {
          if (settings_.isEmpty()) {
            settings_ = other.settings_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureSettingsIsMutable();
            settings_.addAll(other.settings_);
          }
          onChanged();
        }
      } else {
        if (!other.settings_.isEmpty()) {
          if (settingsBuilder_.isEmpty()) {
            settingsBuilder_.dispose();
            settingsBuilder_ = null;
            settings_ = other.settings_;
            bitField0_ = (bitField0_ & ~0x00000001);
            settingsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSettingsFieldBuilder()
                    : null;
          } else {
            settingsBuilder_.addAllMessages(other.settings_);
          }
        }
      }
      switch (other.getModeCase()) {
        case SNAPSHOT_EXPORT:
          {
            mergeSnapshotExport(other.getSnapshotExport());
            break;
          }
        case FULL_EXPORT:
          {
            mergeFullExport(other.getFullExport());
            break;
          }
        case MODE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int modeCase_ = 0;
    private java.lang.Object mode_;

    public ModeCase getModeCase() {
      return ModeCase.forNumber(modeCase_);
    }

    public Builder clearMode() {
      modeCase_ = 0;
      mode_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport,
            com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport.Builder,
            com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExportOrBuilder>
        snapshotExportBuilder_;
    /**
     *
     *
     * <pre>
     * Exports the latest Feature values of all entities of the EntityType
     * within a time range.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport snapshot_export = 3;
     * </code>
     *
     * @return Whether the snapshotExport field is set.
     */
    @java.lang.Override
    public boolean hasSnapshotExport() {
      return modeCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Exports the latest Feature values of all entities of the EntityType
     * within a time range.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport snapshot_export = 3;
     * </code>
     *
     * @return The snapshotExport.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport
        getSnapshotExport() {
      if (snapshotExportBuilder_ == null) {
        if (modeCase_ == 3) {
          return (com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport) mode_;
        }
        return com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport
            .getDefaultInstance();
      } else {
        if (modeCase_ == 3) {
          return snapshotExportBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Exports the latest Feature values of all entities of the EntityType
     * within a time range.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport snapshot_export = 3;
     * </code>
     */
    public Builder setSnapshotExport(
        com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport value) {
      if (snapshotExportBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        mode_ = value;
        onChanged();
      } else {
        snapshotExportBuilder_.setMessage(value);
      }
      modeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Exports the latest Feature values of all entities of the EntityType
     * within a time range.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport snapshot_export = 3;
     * </code>
     */
    public Builder setSnapshotExport(
        com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport.Builder
            builderForValue) {
      if (snapshotExportBuilder_ == null) {
        mode_ = builderForValue.build();
        onChanged();
      } else {
        snapshotExportBuilder_.setMessage(builderForValue.build());
      }
      modeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Exports the latest Feature values of all entities of the EntityType
     * within a time range.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport snapshot_export = 3;
     * </code>
     */
    public Builder mergeSnapshotExport(
        com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport value) {
      if (snapshotExportBuilder_ == null) {
        if (modeCase_ == 3
            && mode_
                != com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport
                    .getDefaultInstance()) {
          mode_ =
              com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport.newBuilder(
                      (com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport)
                          mode_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          mode_ = value;
        }
        onChanged();
      } else {
        if (modeCase_ == 3) {
          snapshotExportBuilder_.mergeFrom(value);
        } else {
          snapshotExportBuilder_.setMessage(value);
        }
      }
      modeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Exports the latest Feature values of all entities of the EntityType
     * within a time range.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport snapshot_export = 3;
     * </code>
     */
    public Builder clearSnapshotExport() {
      if (snapshotExportBuilder_ == null) {
        if (modeCase_ == 3) {
          modeCase_ = 0;
          mode_ = null;
          onChanged();
        }
      } else {
        if (modeCase_ == 3) {
          modeCase_ = 0;
          mode_ = null;
        }
        snapshotExportBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Exports the latest Feature values of all entities of the EntityType
     * within a time range.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport snapshot_export = 3;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport.Builder
        getSnapshotExportBuilder() {
      return getSnapshotExportFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Exports the latest Feature values of all entities of the EntityType
     * within a time range.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport snapshot_export = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExportOrBuilder
        getSnapshotExportOrBuilder() {
      if ((modeCase_ == 3) && (snapshotExportBuilder_ != null)) {
        return snapshotExportBuilder_.getMessageOrBuilder();
      } else {
        if (modeCase_ == 3) {
          return (com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport) mode_;
        }
        return com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Exports the latest Feature values of all entities of the EntityType
     * within a time range.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport snapshot_export = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport,
            com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport.Builder,
            com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExportOrBuilder>
        getSnapshotExportFieldBuilder() {
      if (snapshotExportBuilder_ == null) {
        if (!(modeCase_ == 3)) {
          mode_ =
              com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport
                  .getDefaultInstance();
        }
        snapshotExportBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport,
                com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport.Builder,
                com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExportOrBuilder>(
                (com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport) mode_,
                getParentForChildren(),
                isClean());
        mode_ = null;
      }
      modeCase_ = 3;
      onChanged();
      ;
      return snapshotExportBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport,
            com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport.Builder,
            com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExportOrBuilder>
        fullExportBuilder_;
    /**
     *
     *
     * <pre>
     * Exports all historical values of all entities of the EntityType within a
     * time range
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport full_export = 7;
     * </code>
     *
     * @return Whether the fullExport field is set.
     */
    @java.lang.Override
    public boolean hasFullExport() {
      return modeCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Exports all historical values of all entities of the EntityType within a
     * time range
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport full_export = 7;
     * </code>
     *
     * @return The fullExport.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport getFullExport() {
      if (fullExportBuilder_ == null) {
        if (modeCase_ == 7) {
          return (com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport) mode_;
        }
        return com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport
            .getDefaultInstance();
      } else {
        if (modeCase_ == 7) {
          return fullExportBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Exports all historical values of all entities of the EntityType within a
     * time range
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport full_export = 7;
     * </code>
     */
    public Builder setFullExport(
        com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport value) {
      if (fullExportBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        mode_ = value;
        onChanged();
      } else {
        fullExportBuilder_.setMessage(value);
      }
      modeCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Exports all historical values of all entities of the EntityType within a
     * time range
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport full_export = 7;
     * </code>
     */
    public Builder setFullExport(
        com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport.Builder
            builderForValue) {
      if (fullExportBuilder_ == null) {
        mode_ = builderForValue.build();
        onChanged();
      } else {
        fullExportBuilder_.setMessage(builderForValue.build());
      }
      modeCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Exports all historical values of all entities of the EntityType within a
     * time range
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport full_export = 7;
     * </code>
     */
    public Builder mergeFullExport(
        com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport value) {
      if (fullExportBuilder_ == null) {
        if (modeCase_ == 7
            && mode_
                != com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport
                    .getDefaultInstance()) {
          mode_ =
              com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport.newBuilder(
                      (com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport) mode_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          mode_ = value;
        }
        onChanged();
      } else {
        if (modeCase_ == 7) {
          fullExportBuilder_.mergeFrom(value);
        } else {
          fullExportBuilder_.setMessage(value);
        }
      }
      modeCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Exports all historical values of all entities of the EntityType within a
     * time range
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport full_export = 7;
     * </code>
     */
    public Builder clearFullExport() {
      if (fullExportBuilder_ == null) {
        if (modeCase_ == 7) {
          modeCase_ = 0;
          mode_ = null;
          onChanged();
        }
      } else {
        if (modeCase_ == 7) {
          modeCase_ = 0;
          mode_ = null;
        }
        fullExportBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Exports all historical values of all entities of the EntityType within a
     * time range
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport full_export = 7;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport.Builder
        getFullExportBuilder() {
      return getFullExportFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Exports all historical values of all entities of the EntityType within a
     * time range
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport full_export = 7;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExportOrBuilder
        getFullExportOrBuilder() {
      if ((modeCase_ == 7) && (fullExportBuilder_ != null)) {
        return fullExportBuilder_.getMessageOrBuilder();
      } else {
        if (modeCase_ == 7) {
          return (com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport) mode_;
        }
        return com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Exports all historical values of all entities of the EntityType within a
     * time range
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport full_export = 7;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport,
            com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport.Builder,
            com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExportOrBuilder>
        getFullExportFieldBuilder() {
      if (fullExportBuilder_ == null) {
        if (!(modeCase_ == 7)) {
          mode_ =
              com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport
                  .getDefaultInstance();
        }
        fullExportBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport,
                com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport.Builder,
                com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExportOrBuilder>(
                (com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport) mode_,
                getParentForChildren(),
                isClean());
        mode_ = null;
      }
      modeCase_ = 7;
      onChanged();
      ;
      return fullExportBuilder_;
    }

    private java.lang.Object entityType_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the EntityType from which to export Feature values.
     * Format:
     * `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
     * </pre>
     *
     * <code>
     * string entity_type = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The entityType.
     */
    public java.lang.String getEntityType() {
      java.lang.Object ref = entityType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        entityType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the EntityType from which to export Feature values.
     * Format:
     * `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
     * </pre>
     *
     * <code>
     * string entity_type = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for entityType.
     */
    public com.google.protobuf.ByteString getEntityTypeBytes() {
      java.lang.Object ref = entityType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        entityType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the EntityType from which to export Feature values.
     * Format:
     * `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
     * </pre>
     *
     * <code>
     * string entity_type = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The entityType to set.
     * @return This builder for chaining.
     */
    public Builder setEntityType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      entityType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the EntityType from which to export Feature values.
     * Format:
     * `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
     * </pre>
     *
     * <code>
     * string entity_type = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEntityType() {

      entityType_ = getDefaultInstance().getEntityType();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the EntityType from which to export Feature values.
     * Format:
     * `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
     * </pre>
     *
     * <code>
     * string entity_type = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for entityType to set.
     * @return This builder for chaining.
     */
    public Builder setEntityTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      entityType_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1.FeatureValueDestination destination_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.FeatureValueDestination,
            com.google.cloud.aiplatform.v1.FeatureValueDestination.Builder,
            com.google.cloud.aiplatform.v1.FeatureValueDestinationOrBuilder>
        destinationBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Specifies destination location and format.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeatureValueDestination destination = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the destination field is set.
     */
    public boolean hasDestination() {
      return destinationBuilder_ != null || destination_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. Specifies destination location and format.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeatureValueDestination destination = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The destination.
     */
    public com.google.cloud.aiplatform.v1.FeatureValueDestination getDestination() {
      if (destinationBuilder_ == null) {
        return destination_ == null
            ? com.google.cloud.aiplatform.v1.FeatureValueDestination.getDefaultInstance()
            : destination_;
      } else {
        return destinationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Specifies destination location and format.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeatureValueDestination destination = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDestination(com.google.cloud.aiplatform.v1.FeatureValueDestination value) {
      if (destinationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        destination_ = value;
        onChanged();
      } else {
        destinationBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Specifies destination location and format.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeatureValueDestination destination = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDestination(
        com.google.cloud.aiplatform.v1.FeatureValueDestination.Builder builderForValue) {
      if (destinationBuilder_ == null) {
        destination_ = builderForValue.build();
        onChanged();
      } else {
        destinationBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Specifies destination location and format.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeatureValueDestination destination = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeDestination(com.google.cloud.aiplatform.v1.FeatureValueDestination value) {
      if (destinationBuilder_ == null) {
        if (destination_ != null) {
          destination_ =
              com.google.cloud.aiplatform.v1.FeatureValueDestination.newBuilder(destination_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          destination_ = value;
        }
        onChanged();
      } else {
        destinationBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Specifies destination location and format.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeatureValueDestination destination = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearDestination() {
      if (destinationBuilder_ == null) {
        destination_ = null;
        onChanged();
      } else {
        destination_ = null;
        destinationBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Specifies destination location and format.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeatureValueDestination destination = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.FeatureValueDestination.Builder getDestinationBuilder() {

      onChanged();
      return getDestinationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Specifies destination location and format.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeatureValueDestination destination = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.FeatureValueDestinationOrBuilder
        getDestinationOrBuilder() {
      if (destinationBuilder_ != null) {
        return destinationBuilder_.getMessageOrBuilder();
      } else {
        return destination_ == null
            ? com.google.cloud.aiplatform.v1.FeatureValueDestination.getDefaultInstance()
            : destination_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Specifies destination location and format.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeatureValueDestination destination = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.FeatureValueDestination,
            com.google.cloud.aiplatform.v1.FeatureValueDestination.Builder,
            com.google.cloud.aiplatform.v1.FeatureValueDestinationOrBuilder>
        getDestinationFieldBuilder() {
      if (destinationBuilder_ == null) {
        destinationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.FeatureValueDestination,
                com.google.cloud.aiplatform.v1.FeatureValueDestination.Builder,
                com.google.cloud.aiplatform.v1.FeatureValueDestinationOrBuilder>(
                getDestination(), getParentForChildren(), isClean());
        destination_ = null;
      }
      return destinationBuilder_;
    }

    private com.google.cloud.aiplatform.v1.FeatureSelector featureSelector_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.FeatureSelector,
            com.google.cloud.aiplatform.v1.FeatureSelector.Builder,
            com.google.cloud.aiplatform.v1.FeatureSelectorOrBuilder>
        featureSelectorBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Selects Features to export values of.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeatureSelector feature_selector = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the featureSelector field is set.
     */
    public boolean hasFeatureSelector() {
      return featureSelectorBuilder_ != null || featureSelector_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. Selects Features to export values of.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeatureSelector feature_selector = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The featureSelector.
     */
    public com.google.cloud.aiplatform.v1.FeatureSelector getFeatureSelector() {
      if (featureSelectorBuilder_ == null) {
        return featureSelector_ == null
            ? com.google.cloud.aiplatform.v1.FeatureSelector.getDefaultInstance()
            : featureSelector_;
      } else {
        return featureSelectorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Selects Features to export values of.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeatureSelector feature_selector = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setFeatureSelector(com.google.cloud.aiplatform.v1.FeatureSelector value) {
      if (featureSelectorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        featureSelector_ = value;
        onChanged();
      } else {
        featureSelectorBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Selects Features to export values of.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeatureSelector feature_selector = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setFeatureSelector(
        com.google.cloud.aiplatform.v1.FeatureSelector.Builder builderForValue) {
      if (featureSelectorBuilder_ == null) {
        featureSelector_ = builderForValue.build();
        onChanged();
      } else {
        featureSelectorBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Selects Features to export values of.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeatureSelector feature_selector = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeFeatureSelector(com.google.cloud.aiplatform.v1.FeatureSelector value) {
      if (featureSelectorBuilder_ == null) {
        if (featureSelector_ != null) {
          featureSelector_ =
              com.google.cloud.aiplatform.v1.FeatureSelector.newBuilder(featureSelector_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          featureSelector_ = value;
        }
        onChanged();
      } else {
        featureSelectorBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Selects Features to export values of.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeatureSelector feature_selector = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearFeatureSelector() {
      if (featureSelectorBuilder_ == null) {
        featureSelector_ = null;
        onChanged();
      } else {
        featureSelector_ = null;
        featureSelectorBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Selects Features to export values of.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeatureSelector feature_selector = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.FeatureSelector.Builder getFeatureSelectorBuilder() {

      onChanged();
      return getFeatureSelectorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Selects Features to export values of.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeatureSelector feature_selector = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.FeatureSelectorOrBuilder getFeatureSelectorOrBuilder() {
      if (featureSelectorBuilder_ != null) {
        return featureSelectorBuilder_.getMessageOrBuilder();
      } else {
        return featureSelector_ == null
            ? com.google.cloud.aiplatform.v1.FeatureSelector.getDefaultInstance()
            : featureSelector_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Selects Features to export values of.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeatureSelector feature_selector = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.FeatureSelector,
            com.google.cloud.aiplatform.v1.FeatureSelector.Builder,
            com.google.cloud.aiplatform.v1.FeatureSelectorOrBuilder>
        getFeatureSelectorFieldBuilder() {
      if (featureSelectorBuilder_ == null) {
        featureSelectorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.FeatureSelector,
                com.google.cloud.aiplatform.v1.FeatureSelector.Builder,
                com.google.cloud.aiplatform.v1.FeatureSelectorOrBuilder>(
                getFeatureSelector(), getParentForChildren(), isClean());
        featureSelector_ = null;
      }
      return featureSelectorBuilder_;
    }

    private java.util.List<com.google.cloud.aiplatform.v1.DestinationFeatureSetting> settings_ =
        java.util.Collections.emptyList();

    private void ensureSettingsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        settings_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1.DestinationFeatureSetting>(
                settings_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.DestinationFeatureSetting,
            com.google.cloud.aiplatform.v1.DestinationFeatureSetting.Builder,
            com.google.cloud.aiplatform.v1.DestinationFeatureSettingOrBuilder>
        settingsBuilder_;

    /**
     *
     *
     * <pre>
     * Per-Feature export settings.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.DestinationFeatureSetting settings = 6;</code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.DestinationFeatureSetting>
        getSettingsList() {
      if (settingsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(settings_);
      } else {
        return settingsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Per-Feature export settings.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.DestinationFeatureSetting settings = 6;</code>
     */
    public int getSettingsCount() {
      if (settingsBuilder_ == null) {
        return settings_.size();
      } else {
        return settingsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Per-Feature export settings.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.DestinationFeatureSetting settings = 6;</code>
     */
    public com.google.cloud.aiplatform.v1.DestinationFeatureSetting getSettings(int index) {
      if (settingsBuilder_ == null) {
        return settings_.get(index);
      } else {
        return settingsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Per-Feature export settings.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.DestinationFeatureSetting settings = 6;</code>
     */
    public Builder setSettings(
        int index, com.google.cloud.aiplatform.v1.DestinationFeatureSetting value) {
      if (settingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSettingsIsMutable();
        settings_.set(index, value);
        onChanged();
      } else {
        settingsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Per-Feature export settings.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.DestinationFeatureSetting settings = 6;</code>
     */
    public Builder setSettings(
        int index,
        com.google.cloud.aiplatform.v1.DestinationFeatureSetting.Builder builderForValue) {
      if (settingsBuilder_ == null) {
        ensureSettingsIsMutable();
        settings_.set(index, builderForValue.build());
        onChanged();
      } else {
        settingsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Per-Feature export settings.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.DestinationFeatureSetting settings = 6;</code>
     */
    public Builder addSettings(com.google.cloud.aiplatform.v1.DestinationFeatureSetting value) {
      if (settingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSettingsIsMutable();
        settings_.add(value);
        onChanged();
      } else {
        settingsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Per-Feature export settings.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.DestinationFeatureSetting settings = 6;</code>
     */
    public Builder addSettings(
        int index, com.google.cloud.aiplatform.v1.DestinationFeatureSetting value) {
      if (settingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSettingsIsMutable();
        settings_.add(index, value);
        onChanged();
      } else {
        settingsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Per-Feature export settings.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.DestinationFeatureSetting settings = 6;</code>
     */
    public Builder addSettings(
        com.google.cloud.aiplatform.v1.DestinationFeatureSetting.Builder builderForValue) {
      if (settingsBuilder_ == null) {
        ensureSettingsIsMutable();
        settings_.add(builderForValue.build());
        onChanged();
      } else {
        settingsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Per-Feature export settings.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.DestinationFeatureSetting settings = 6;</code>
     */
    public Builder addSettings(
        int index,
        com.google.cloud.aiplatform.v1.DestinationFeatureSetting.Builder builderForValue) {
      if (settingsBuilder_ == null) {
        ensureSettingsIsMutable();
        settings_.add(index, builderForValue.build());
        onChanged();
      } else {
        settingsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Per-Feature export settings.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.DestinationFeatureSetting settings = 6;</code>
     */
    public Builder addAllSettings(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1.DestinationFeatureSetting>
            values) {
      if (settingsBuilder_ == null) {
        ensureSettingsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, settings_);
        onChanged();
      } else {
        settingsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Per-Feature export settings.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.DestinationFeatureSetting settings = 6;</code>
     */
    public Builder clearSettings() {
      if (settingsBuilder_ == null) {
        settings_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        settingsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Per-Feature export settings.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.DestinationFeatureSetting settings = 6;</code>
     */
    public Builder removeSettings(int index) {
      if (settingsBuilder_ == null) {
        ensureSettingsIsMutable();
        settings_.remove(index);
        onChanged();
      } else {
        settingsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Per-Feature export settings.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.DestinationFeatureSetting settings = 6;</code>
     */
    public com.google.cloud.aiplatform.v1.DestinationFeatureSetting.Builder getSettingsBuilder(
        int index) {
      return getSettingsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Per-Feature export settings.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.DestinationFeatureSetting settings = 6;</code>
     */
    public com.google.cloud.aiplatform.v1.DestinationFeatureSettingOrBuilder getSettingsOrBuilder(
        int index) {
      if (settingsBuilder_ == null) {
        return settings_.get(index);
      } else {
        return settingsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Per-Feature export settings.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.DestinationFeatureSetting settings = 6;</code>
     */
    public java.util.List<
            ? extends com.google.cloud.aiplatform.v1.DestinationFeatureSettingOrBuilder>
        getSettingsOrBuilderList() {
      if (settingsBuilder_ != null) {
        return settingsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(settings_);
      }
    }
    /**
     *
     *
     * <pre>
     * Per-Feature export settings.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.DestinationFeatureSetting settings = 6;</code>
     */
    public com.google.cloud.aiplatform.v1.DestinationFeatureSetting.Builder addSettingsBuilder() {
      return getSettingsFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1.DestinationFeatureSetting.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Per-Feature export settings.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.DestinationFeatureSetting settings = 6;</code>
     */
    public com.google.cloud.aiplatform.v1.DestinationFeatureSetting.Builder addSettingsBuilder(
        int index) {
      return getSettingsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.aiplatform.v1.DestinationFeatureSetting.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Per-Feature export settings.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.DestinationFeatureSetting settings = 6;</code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.DestinationFeatureSetting.Builder>
        getSettingsBuilderList() {
      return getSettingsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.DestinationFeatureSetting,
            com.google.cloud.aiplatform.v1.DestinationFeatureSetting.Builder,
            com.google.cloud.aiplatform.v1.DestinationFeatureSettingOrBuilder>
        getSettingsFieldBuilder() {
      if (settingsBuilder_ == null) {
        settingsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1.DestinationFeatureSetting,
                com.google.cloud.aiplatform.v1.DestinationFeatureSetting.Builder,
                com.google.cloud.aiplatform.v1.DestinationFeatureSettingOrBuilder>(
                settings_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        settings_ = null;
      }
      return settingsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.ExportFeatureValuesRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.ExportFeatureValuesRequest)
  private static final com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest();
  }

  public static com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ExportFeatureValuesRequest> PARSER =
      new com.google.protobuf.AbstractParser<ExportFeatureValuesRequest>() {
        @java.lang.Override
        public ExportFeatureValuesRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ExportFeatureValuesRequest(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ExportFeatureValuesRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ExportFeatureValuesRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ExportFeatureValuesRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
