/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/analytics/data/v1beta/analytics_data_api.proto

// Protobuf Java Version: 3.25.5
package com.google.analytics.data.v1beta;

/**
 *
 *
 * <pre>
 * The request to generate a realtime report.
 * </pre>
 *
 * Protobuf type {@code google.analytics.data.v1beta.RunRealtimeReportRequest}
 */
public final class RunRealtimeReportRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.analytics.data.v1beta.RunRealtimeReportRequest)
    RunRealtimeReportRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RunRealtimeReportRequest.newBuilder() to construct.
  private RunRealtimeReportRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RunRealtimeReportRequest() {
    property_ = "";
    dimensions_ = java.util.Collections.emptyList();
    metrics_ = java.util.Collections.emptyList();
    metricAggregations_ = java.util.Collections.emptyList();
    orderBys_ = java.util.Collections.emptyList();
    minuteRanges_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RunRealtimeReportRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.analytics.data.v1beta.AnalyticsDataApiProto
        .internal_static_google_analytics_data_v1beta_RunRealtimeReportRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.analytics.data.v1beta.AnalyticsDataApiProto
        .internal_static_google_analytics_data_v1beta_RunRealtimeReportRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.analytics.data.v1beta.RunRealtimeReportRequest.class,
            com.google.analytics.data.v1beta.RunRealtimeReportRequest.Builder.class);
  }

  private int bitField0_;
  public static final int PROPERTY_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object property_ = "";
  /**
   *
   *
   * <pre>
   * A Google Analytics GA4 property identifier whose events are tracked.
   * Specified in the URL path and not the body. To learn more, see [where to
   * find your Property
   * ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
   *
   * Example: properties/1234
   * </pre>
   *
   * <code>string property = 1;</code>
   *
   * @return The property.
   */
  @java.lang.Override
  public java.lang.String getProperty() {
    java.lang.Object ref = property_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      property_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A Google Analytics GA4 property identifier whose events are tracked.
   * Specified in the URL path and not the body. To learn more, see [where to
   * find your Property
   * ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
   *
   * Example: properties/1234
   * </pre>
   *
   * <code>string property = 1;</code>
   *
   * @return The bytes for property.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPropertyBytes() {
    java.lang.Object ref = property_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      property_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DIMENSIONS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.analytics.data.v1beta.Dimension> dimensions_;
  /**
   *
   *
   * <pre>
   * The dimensions requested and displayed.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.Dimension dimensions = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.analytics.data.v1beta.Dimension> getDimensionsList() {
    return dimensions_;
  }
  /**
   *
   *
   * <pre>
   * The dimensions requested and displayed.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.Dimension dimensions = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.analytics.data.v1beta.DimensionOrBuilder>
      getDimensionsOrBuilderList() {
    return dimensions_;
  }
  /**
   *
   *
   * <pre>
   * The dimensions requested and displayed.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.Dimension dimensions = 2;</code>
   */
  @java.lang.Override
  public int getDimensionsCount() {
    return dimensions_.size();
  }
  /**
   *
   *
   * <pre>
   * The dimensions requested and displayed.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.Dimension dimensions = 2;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.Dimension getDimensions(int index) {
    return dimensions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The dimensions requested and displayed.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.Dimension dimensions = 2;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.DimensionOrBuilder getDimensionsOrBuilder(int index) {
    return dimensions_.get(index);
  }

  public static final int METRICS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.analytics.data.v1beta.Metric> metrics_;
  /**
   *
   *
   * <pre>
   * The metrics requested and displayed.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.Metric metrics = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.analytics.data.v1beta.Metric> getMetricsList() {
    return metrics_;
  }
  /**
   *
   *
   * <pre>
   * The metrics requested and displayed.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.Metric metrics = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.analytics.data.v1beta.MetricOrBuilder>
      getMetricsOrBuilderList() {
    return metrics_;
  }
  /**
   *
   *
   * <pre>
   * The metrics requested and displayed.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.Metric metrics = 3;</code>
   */
  @java.lang.Override
  public int getMetricsCount() {
    return metrics_.size();
  }
  /**
   *
   *
   * <pre>
   * The metrics requested and displayed.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.Metric metrics = 3;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.Metric getMetrics(int index) {
    return metrics_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The metrics requested and displayed.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.Metric metrics = 3;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.MetricOrBuilder getMetricsOrBuilder(int index) {
    return metrics_.get(index);
  }

  public static final int DIMENSION_FILTER_FIELD_NUMBER = 4;
  private com.google.analytics.data.v1beta.FilterExpression dimensionFilter_;
  /**
   *
   *
   * <pre>
   * The filter clause of dimensions. Metrics cannot be used in this filter.
   * </pre>
   *
   * <code>.google.analytics.data.v1beta.FilterExpression dimension_filter = 4;</code>
   *
   * @return Whether the dimensionFilter field is set.
   */
  @java.lang.Override
  public boolean hasDimensionFilter() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The filter clause of dimensions. Metrics cannot be used in this filter.
   * </pre>
   *
   * <code>.google.analytics.data.v1beta.FilterExpression dimension_filter = 4;</code>
   *
   * @return The dimensionFilter.
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.FilterExpression getDimensionFilter() {
    return dimensionFilter_ == null
        ? com.google.analytics.data.v1beta.FilterExpression.getDefaultInstance()
        : dimensionFilter_;
  }
  /**
   *
   *
   * <pre>
   * The filter clause of dimensions. Metrics cannot be used in this filter.
   * </pre>
   *
   * <code>.google.analytics.data.v1beta.FilterExpression dimension_filter = 4;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.FilterExpressionOrBuilder getDimensionFilterOrBuilder() {
    return dimensionFilter_ == null
        ? com.google.analytics.data.v1beta.FilterExpression.getDefaultInstance()
        : dimensionFilter_;
  }

  public static final int METRIC_FILTER_FIELD_NUMBER = 5;
  private com.google.analytics.data.v1beta.FilterExpression metricFilter_;
  /**
   *
   *
   * <pre>
   * The filter clause of metrics. Applied at post aggregation phase, similar to
   * SQL having-clause. Dimensions cannot be used in this filter.
   * </pre>
   *
   * <code>.google.analytics.data.v1beta.FilterExpression metric_filter = 5;</code>
   *
   * @return Whether the metricFilter field is set.
   */
  @java.lang.Override
  public boolean hasMetricFilter() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The filter clause of metrics. Applied at post aggregation phase, similar to
   * SQL having-clause. Dimensions cannot be used in this filter.
   * </pre>
   *
   * <code>.google.analytics.data.v1beta.FilterExpression metric_filter = 5;</code>
   *
   * @return The metricFilter.
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.FilterExpression getMetricFilter() {
    return metricFilter_ == null
        ? com.google.analytics.data.v1beta.FilterExpression.getDefaultInstance()
        : metricFilter_;
  }
  /**
   *
   *
   * <pre>
   * The filter clause of metrics. Applied at post aggregation phase, similar to
   * SQL having-clause. Dimensions cannot be used in this filter.
   * </pre>
   *
   * <code>.google.analytics.data.v1beta.FilterExpression metric_filter = 5;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.FilterExpressionOrBuilder getMetricFilterOrBuilder() {
    return metricFilter_ == null
        ? com.google.analytics.data.v1beta.FilterExpression.getDefaultInstance()
        : metricFilter_;
  }

  public static final int LIMIT_FIELD_NUMBER = 6;
  private long limit_ = 0L;
  /**
   *
   *
   * <pre>
   * The number of rows to return. If unspecified, 10,000 rows are returned. The
   * API returns a maximum of 250,000 rows per request, no matter how many you
   * ask for. `limit` must be positive.
   *
   * The API can also return fewer rows than the requested `limit`, if there
   * aren't as many dimension values as the `limit`. For instance, there are
   * fewer than 300 possible values for the dimension `country`, so when
   * reporting on only `country`, you can't get more than 300 rows, even if you
   * set `limit` to a higher value.
   * </pre>
   *
   * <code>int64 limit = 6;</code>
   *
   * @return The limit.
   */
  @java.lang.Override
  public long getLimit() {
    return limit_;
  }

  public static final int METRIC_AGGREGATIONS_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> metricAggregations_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.analytics.data.v1beta.MetricAggregation>
      metricAggregations_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.analytics.data.v1beta.MetricAggregation>() {
            public com.google.analytics.data.v1beta.MetricAggregation convert(
                java.lang.Integer from) {
              com.google.analytics.data.v1beta.MetricAggregation result =
                  com.google.analytics.data.v1beta.MetricAggregation.forNumber(from);
              return result == null
                  ? com.google.analytics.data.v1beta.MetricAggregation.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Aggregation of metrics. Aggregated metric values will be shown in rows
   * where the dimension_values are set to "RESERVED_(MetricAggregation)".
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.MetricAggregation metric_aggregations = 7;</code>
   *
   * @return A list containing the metricAggregations.
   */
  @java.lang.Override
  public java.util.List<com.google.analytics.data.v1beta.MetricAggregation>
      getMetricAggregationsList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.analytics.data.v1beta.MetricAggregation>(
        metricAggregations_, metricAggregations_converter_);
  }
  /**
   *
   *
   * <pre>
   * Aggregation of metrics. Aggregated metric values will be shown in rows
   * where the dimension_values are set to "RESERVED_(MetricAggregation)".
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.MetricAggregation metric_aggregations = 7;</code>
   *
   * @return The count of metricAggregations.
   */
  @java.lang.Override
  public int getMetricAggregationsCount() {
    return metricAggregations_.size();
  }
  /**
   *
   *
   * <pre>
   * Aggregation of metrics. Aggregated metric values will be shown in rows
   * where the dimension_values are set to "RESERVED_(MetricAggregation)".
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.MetricAggregation metric_aggregations = 7;</code>
   *
   * @param index The index of the element to return.
   * @return The metricAggregations at the given index.
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.MetricAggregation getMetricAggregations(int index) {
    return metricAggregations_converter_.convert(metricAggregations_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Aggregation of metrics. Aggregated metric values will be shown in rows
   * where the dimension_values are set to "RESERVED_(MetricAggregation)".
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.MetricAggregation metric_aggregations = 7;</code>
   *
   * @return A list containing the enum numeric values on the wire for metricAggregations.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getMetricAggregationsValueList() {
    return metricAggregations_;
  }
  /**
   *
   *
   * <pre>
   * Aggregation of metrics. Aggregated metric values will be shown in rows
   * where the dimension_values are set to "RESERVED_(MetricAggregation)".
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.MetricAggregation metric_aggregations = 7;</code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of metricAggregations at the given index.
   */
  @java.lang.Override
  public int getMetricAggregationsValue(int index) {
    return metricAggregations_.get(index);
  }

  private int metricAggregationsMemoizedSerializedSize;

  public static final int ORDER_BYS_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private java.util.List<com.google.analytics.data.v1beta.OrderBy> orderBys_;
  /**
   *
   *
   * <pre>
   * Specifies how rows are ordered in the response.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.OrderBy order_bys = 8;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.analytics.data.v1beta.OrderBy> getOrderBysList() {
    return orderBys_;
  }
  /**
   *
   *
   * <pre>
   * Specifies how rows are ordered in the response.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.OrderBy order_bys = 8;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.analytics.data.v1beta.OrderByOrBuilder>
      getOrderBysOrBuilderList() {
    return orderBys_;
  }
  /**
   *
   *
   * <pre>
   * Specifies how rows are ordered in the response.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.OrderBy order_bys = 8;</code>
   */
  @java.lang.Override
  public int getOrderBysCount() {
    return orderBys_.size();
  }
  /**
   *
   *
   * <pre>
   * Specifies how rows are ordered in the response.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.OrderBy order_bys = 8;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.OrderBy getOrderBys(int index) {
    return orderBys_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Specifies how rows are ordered in the response.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.OrderBy order_bys = 8;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.OrderByOrBuilder getOrderBysOrBuilder(int index) {
    return orderBys_.get(index);
  }

  public static final int RETURN_PROPERTY_QUOTA_FIELD_NUMBER = 9;
  private boolean returnPropertyQuota_ = false;
  /**
   *
   *
   * <pre>
   * Toggles whether to return the current state of this Analytics Property's
   * Realtime quota. Quota is returned in [PropertyQuota](#PropertyQuota).
   * </pre>
   *
   * <code>bool return_property_quota = 9;</code>
   *
   * @return The returnPropertyQuota.
   */
  @java.lang.Override
  public boolean getReturnPropertyQuota() {
    return returnPropertyQuota_;
  }

  public static final int MINUTE_RANGES_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private java.util.List<com.google.analytics.data.v1beta.MinuteRange> minuteRanges_;
  /**
   *
   *
   * <pre>
   * The minute ranges of event data to read. If unspecified, one minute range
   * for the last 30 minutes will be used. If multiple minute ranges are
   * requested, each response row will contain a zero based minute range index.
   * If two minute ranges overlap, the event data for the overlapping minutes is
   * included in the response rows for both minute ranges.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.MinuteRange minute_ranges = 10;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.analytics.data.v1beta.MinuteRange> getMinuteRangesList() {
    return minuteRanges_;
  }
  /**
   *
   *
   * <pre>
   * The minute ranges of event data to read. If unspecified, one minute range
   * for the last 30 minutes will be used. If multiple minute ranges are
   * requested, each response row will contain a zero based minute range index.
   * If two minute ranges overlap, the event data for the overlapping minutes is
   * included in the response rows for both minute ranges.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.MinuteRange minute_ranges = 10;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.analytics.data.v1beta.MinuteRangeOrBuilder>
      getMinuteRangesOrBuilderList() {
    return minuteRanges_;
  }
  /**
   *
   *
   * <pre>
   * The minute ranges of event data to read. If unspecified, one minute range
   * for the last 30 minutes will be used. If multiple minute ranges are
   * requested, each response row will contain a zero based minute range index.
   * If two minute ranges overlap, the event data for the overlapping minutes is
   * included in the response rows for both minute ranges.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.MinuteRange minute_ranges = 10;</code>
   */
  @java.lang.Override
  public int getMinuteRangesCount() {
    return minuteRanges_.size();
  }
  /**
   *
   *
   * <pre>
   * The minute ranges of event data to read. If unspecified, one minute range
   * for the last 30 minutes will be used. If multiple minute ranges are
   * requested, each response row will contain a zero based minute range index.
   * If two minute ranges overlap, the event data for the overlapping minutes is
   * included in the response rows for both minute ranges.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.MinuteRange minute_ranges = 10;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.MinuteRange getMinuteRanges(int index) {
    return minuteRanges_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The minute ranges of event data to read. If unspecified, one minute range
   * for the last 30 minutes will be used. If multiple minute ranges are
   * requested, each response row will contain a zero based minute range index.
   * If two minute ranges overlap, the event data for the overlapping minutes is
   * included in the response rows for both minute ranges.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.MinuteRange minute_ranges = 10;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.MinuteRangeOrBuilder getMinuteRangesOrBuilder(int index) {
    return minuteRanges_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(property_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, property_);
    }
    for (int i = 0; i < dimensions_.size(); i++) {
      output.writeMessage(2, dimensions_.get(i));
    }
    for (int i = 0; i < metrics_.size(); i++) {
      output.writeMessage(3, metrics_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getDimensionFilter());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(5, getMetricFilter());
    }
    if (limit_ != 0L) {
      output.writeInt64(6, limit_);
    }
    if (getMetricAggregationsList().size() > 0) {
      output.writeUInt32NoTag(58);
      output.writeUInt32NoTag(metricAggregationsMemoizedSerializedSize);
    }
    for (int i = 0; i < metricAggregations_.size(); i++) {
      output.writeEnumNoTag(metricAggregations_.get(i));
    }
    for (int i = 0; i < orderBys_.size(); i++) {
      output.writeMessage(8, orderBys_.get(i));
    }
    if (returnPropertyQuota_ != false) {
      output.writeBool(9, returnPropertyQuota_);
    }
    for (int i = 0; i < minuteRanges_.size(); i++) {
      output.writeMessage(10, minuteRanges_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(property_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, property_);
    }
    for (int i = 0; i < dimensions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, dimensions_.get(i));
    }
    for (int i = 0; i < metrics_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, metrics_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getDimensionFilter());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getMetricFilter());
    }
    if (limit_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(6, limit_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < metricAggregations_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(metricAggregations_.get(i));
      }
      size += dataSize;
      if (!getMetricAggregationsList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      metricAggregationsMemoizedSerializedSize = dataSize;
    }
    for (int i = 0; i < orderBys_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, orderBys_.get(i));
    }
    if (returnPropertyQuota_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(9, returnPropertyQuota_);
    }
    for (int i = 0; i < minuteRanges_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, minuteRanges_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.analytics.data.v1beta.RunRealtimeReportRequest)) {
      return super.equals(obj);
    }
    com.google.analytics.data.v1beta.RunRealtimeReportRequest other =
        (com.google.analytics.data.v1beta.RunRealtimeReportRequest) obj;

    if (!getProperty().equals(other.getProperty())) return false;
    if (!getDimensionsList().equals(other.getDimensionsList())) return false;
    if (!getMetricsList().equals(other.getMetricsList())) return false;
    if (hasDimensionFilter() != other.hasDimensionFilter()) return false;
    if (hasDimensionFilter()) {
      if (!getDimensionFilter().equals(other.getDimensionFilter())) return false;
    }
    if (hasMetricFilter() != other.hasMetricFilter()) return false;
    if (hasMetricFilter()) {
      if (!getMetricFilter().equals(other.getMetricFilter())) return false;
    }
    if (getLimit() != other.getLimit()) return false;
    if (!metricAggregations_.equals(other.metricAggregations_)) return false;
    if (!getOrderBysList().equals(other.getOrderBysList())) return false;
    if (getReturnPropertyQuota() != other.getReturnPropertyQuota()) return false;
    if (!getMinuteRangesList().equals(other.getMinuteRangesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PROPERTY_FIELD_NUMBER;
    hash = (53 * hash) + getProperty().hashCode();
    if (getDimensionsCount() > 0) {
      hash = (37 * hash) + DIMENSIONS_FIELD_NUMBER;
      hash = (53 * hash) + getDimensionsList().hashCode();
    }
    if (getMetricsCount() > 0) {
      hash = (37 * hash) + METRICS_FIELD_NUMBER;
      hash = (53 * hash) + getMetricsList().hashCode();
    }
    if (hasDimensionFilter()) {
      hash = (37 * hash) + DIMENSION_FILTER_FIELD_NUMBER;
      hash = (53 * hash) + getDimensionFilter().hashCode();
    }
    if (hasMetricFilter()) {
      hash = (37 * hash) + METRIC_FILTER_FIELD_NUMBER;
      hash = (53 * hash) + getMetricFilter().hashCode();
    }
    hash = (37 * hash) + LIMIT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getLimit());
    if (getMetricAggregationsCount() > 0) {
      hash = (37 * hash) + METRIC_AGGREGATIONS_FIELD_NUMBER;
      hash = (53 * hash) + metricAggregations_.hashCode();
    }
    if (getOrderBysCount() > 0) {
      hash = (37 * hash) + ORDER_BYS_FIELD_NUMBER;
      hash = (53 * hash) + getOrderBysList().hashCode();
    }
    hash = (37 * hash) + RETURN_PROPERTY_QUOTA_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getReturnPropertyQuota());
    if (getMinuteRangesCount() > 0) {
      hash = (37 * hash) + MINUTE_RANGES_FIELD_NUMBER;
      hash = (53 * hash) + getMinuteRangesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.analytics.data.v1beta.RunRealtimeReportRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1beta.RunRealtimeReportRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1beta.RunRealtimeReportRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1beta.RunRealtimeReportRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1beta.RunRealtimeReportRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1beta.RunRealtimeReportRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1beta.RunRealtimeReportRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1beta.RunRealtimeReportRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1beta.RunRealtimeReportRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1beta.RunRealtimeReportRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1beta.RunRealtimeReportRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1beta.RunRealtimeReportRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.analytics.data.v1beta.RunRealtimeReportRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request to generate a realtime report.
   * </pre>
   *
   * Protobuf type {@code google.analytics.data.v1beta.RunRealtimeReportRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.analytics.data.v1beta.RunRealtimeReportRequest)
      com.google.analytics.data.v1beta.RunRealtimeReportRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.analytics.data.v1beta.AnalyticsDataApiProto
          .internal_static_google_analytics_data_v1beta_RunRealtimeReportRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.analytics.data.v1beta.AnalyticsDataApiProto
          .internal_static_google_analytics_data_v1beta_RunRealtimeReportRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.analytics.data.v1beta.RunRealtimeReportRequest.class,
              com.google.analytics.data.v1beta.RunRealtimeReportRequest.Builder.class);
    }

    // Construct using com.google.analytics.data.v1beta.RunRealtimeReportRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDimensionsFieldBuilder();
        getMetricsFieldBuilder();
        getDimensionFilterFieldBuilder();
        getMetricFilterFieldBuilder();
        getOrderBysFieldBuilder();
        getMinuteRangesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      property_ = "";
      if (dimensionsBuilder_ == null) {
        dimensions_ = java.util.Collections.emptyList();
      } else {
        dimensions_ = null;
        dimensionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      if (metricsBuilder_ == null) {
        metrics_ = java.util.Collections.emptyList();
      } else {
        metrics_ = null;
        metricsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      dimensionFilter_ = null;
      if (dimensionFilterBuilder_ != null) {
        dimensionFilterBuilder_.dispose();
        dimensionFilterBuilder_ = null;
      }
      metricFilter_ = null;
      if (metricFilterBuilder_ != null) {
        metricFilterBuilder_.dispose();
        metricFilterBuilder_ = null;
      }
      limit_ = 0L;
      metricAggregations_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000040);
      if (orderBysBuilder_ == null) {
        orderBys_ = java.util.Collections.emptyList();
      } else {
        orderBys_ = null;
        orderBysBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000080);
      returnPropertyQuota_ = false;
      if (minuteRangesBuilder_ == null) {
        minuteRanges_ = java.util.Collections.emptyList();
      } else {
        minuteRanges_ = null;
        minuteRangesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000200);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.analytics.data.v1beta.AnalyticsDataApiProto
          .internal_static_google_analytics_data_v1beta_RunRealtimeReportRequest_descriptor;
    }

    @java.lang.Override
    public com.google.analytics.data.v1beta.RunRealtimeReportRequest getDefaultInstanceForType() {
      return com.google.analytics.data.v1beta.RunRealtimeReportRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.analytics.data.v1beta.RunRealtimeReportRequest build() {
      com.google.analytics.data.v1beta.RunRealtimeReportRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.analytics.data.v1beta.RunRealtimeReportRequest buildPartial() {
      com.google.analytics.data.v1beta.RunRealtimeReportRequest result =
          new com.google.analytics.data.v1beta.RunRealtimeReportRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.analytics.data.v1beta.RunRealtimeReportRequest result) {
      if (dimensionsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          dimensions_ = java.util.Collections.unmodifiableList(dimensions_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.dimensions_ = dimensions_;
      } else {
        result.dimensions_ = dimensionsBuilder_.build();
      }
      if (metricsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          metrics_ = java.util.Collections.unmodifiableList(metrics_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.metrics_ = metrics_;
      } else {
        result.metrics_ = metricsBuilder_.build();
      }
      if (((bitField0_ & 0x00000040) != 0)) {
        metricAggregations_ = java.util.Collections.unmodifiableList(metricAggregations_);
        bitField0_ = (bitField0_ & ~0x00000040);
      }
      result.metricAggregations_ = metricAggregations_;
      if (orderBysBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)) {
          orderBys_ = java.util.Collections.unmodifiableList(orderBys_);
          bitField0_ = (bitField0_ & ~0x00000080);
        }
        result.orderBys_ = orderBys_;
      } else {
        result.orderBys_ = orderBysBuilder_.build();
      }
      if (minuteRangesBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)) {
          minuteRanges_ = java.util.Collections.unmodifiableList(minuteRanges_);
          bitField0_ = (bitField0_ & ~0x00000200);
        }
        result.minuteRanges_ = minuteRanges_;
      } else {
        result.minuteRanges_ = minuteRangesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.analytics.data.v1beta.RunRealtimeReportRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.property_ = property_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.dimensionFilter_ =
            dimensionFilterBuilder_ == null ? dimensionFilter_ : dimensionFilterBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.metricFilter_ =
            metricFilterBuilder_ == null ? metricFilter_ : metricFilterBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.limit_ = limit_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.returnPropertyQuota_ = returnPropertyQuota_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.analytics.data.v1beta.RunRealtimeReportRequest) {
        return mergeFrom((com.google.analytics.data.v1beta.RunRealtimeReportRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.analytics.data.v1beta.RunRealtimeReportRequest other) {
      if (other == com.google.analytics.data.v1beta.RunRealtimeReportRequest.getDefaultInstance())
        return this;
      if (!other.getProperty().isEmpty()) {
        property_ = other.property_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (dimensionsBuilder_ == null) {
        if (!other.dimensions_.isEmpty()) {
          if (dimensions_.isEmpty()) {
            dimensions_ = other.dimensions_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureDimensionsIsMutable();
            dimensions_.addAll(other.dimensions_);
          }
          onChanged();
        }
      } else {
        if (!other.dimensions_.isEmpty()) {
          if (dimensionsBuilder_.isEmpty()) {
            dimensionsBuilder_.dispose();
            dimensionsBuilder_ = null;
            dimensions_ = other.dimensions_;
            bitField0_ = (bitField0_ & ~0x00000002);
            dimensionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDimensionsFieldBuilder()
                    : null;
          } else {
            dimensionsBuilder_.addAllMessages(other.dimensions_);
          }
        }
      }
      if (metricsBuilder_ == null) {
        if (!other.metrics_.isEmpty()) {
          if (metrics_.isEmpty()) {
            metrics_ = other.metrics_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureMetricsIsMutable();
            metrics_.addAll(other.metrics_);
          }
          onChanged();
        }
      } else {
        if (!other.metrics_.isEmpty()) {
          if (metricsBuilder_.isEmpty()) {
            metricsBuilder_.dispose();
            metricsBuilder_ = null;
            metrics_ = other.metrics_;
            bitField0_ = (bitField0_ & ~0x00000004);
            metricsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMetricsFieldBuilder()
                    : null;
          } else {
            metricsBuilder_.addAllMessages(other.metrics_);
          }
        }
      }
      if (other.hasDimensionFilter()) {
        mergeDimensionFilter(other.getDimensionFilter());
      }
      if (other.hasMetricFilter()) {
        mergeMetricFilter(other.getMetricFilter());
      }
      if (other.getLimit() != 0L) {
        setLimit(other.getLimit());
      }
      if (!other.metricAggregations_.isEmpty()) {
        if (metricAggregations_.isEmpty()) {
          metricAggregations_ = other.metricAggregations_;
          bitField0_ = (bitField0_ & ~0x00000040);
        } else {
          ensureMetricAggregationsIsMutable();
          metricAggregations_.addAll(other.metricAggregations_);
        }
        onChanged();
      }
      if (orderBysBuilder_ == null) {
        if (!other.orderBys_.isEmpty()) {
          if (orderBys_.isEmpty()) {
            orderBys_ = other.orderBys_;
            bitField0_ = (bitField0_ & ~0x00000080);
          } else {
            ensureOrderBysIsMutable();
            orderBys_.addAll(other.orderBys_);
          }
          onChanged();
        }
      } else {
        if (!other.orderBys_.isEmpty()) {
          if (orderBysBuilder_.isEmpty()) {
            orderBysBuilder_.dispose();
            orderBysBuilder_ = null;
            orderBys_ = other.orderBys_;
            bitField0_ = (bitField0_ & ~0x00000080);
            orderBysBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getOrderBysFieldBuilder()
                    : null;
          } else {
            orderBysBuilder_.addAllMessages(other.orderBys_);
          }
        }
      }
      if (other.getReturnPropertyQuota() != false) {
        setReturnPropertyQuota(other.getReturnPropertyQuota());
      }
      if (minuteRangesBuilder_ == null) {
        if (!other.minuteRanges_.isEmpty()) {
          if (minuteRanges_.isEmpty()) {
            minuteRanges_ = other.minuteRanges_;
            bitField0_ = (bitField0_ & ~0x00000200);
          } else {
            ensureMinuteRangesIsMutable();
            minuteRanges_.addAll(other.minuteRanges_);
          }
          onChanged();
        }
      } else {
        if (!other.minuteRanges_.isEmpty()) {
          if (minuteRangesBuilder_.isEmpty()) {
            minuteRangesBuilder_.dispose();
            minuteRangesBuilder_ = null;
            minuteRanges_ = other.minuteRanges_;
            bitField0_ = (bitField0_ & ~0x00000200);
            minuteRangesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMinuteRangesFieldBuilder()
                    : null;
          } else {
            minuteRangesBuilder_.addAllMessages(other.minuteRanges_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                property_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.analytics.data.v1beta.Dimension m =
                    input.readMessage(
                        com.google.analytics.data.v1beta.Dimension.parser(), extensionRegistry);
                if (dimensionsBuilder_ == null) {
                  ensureDimensionsIsMutable();
                  dimensions_.add(m);
                } else {
                  dimensionsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                com.google.analytics.data.v1beta.Metric m =
                    input.readMessage(
                        com.google.analytics.data.v1beta.Metric.parser(), extensionRegistry);
                if (metricsBuilder_ == null) {
                  ensureMetricsIsMutable();
                  metrics_.add(m);
                } else {
                  metricsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getDimensionFilterFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getMetricFilterFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 48:
              {
                limit_ = input.readInt64();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 56:
              {
                int tmpRaw = input.readEnum();
                ensureMetricAggregationsIsMutable();
                metricAggregations_.add(tmpRaw);
                break;
              } // case 56
            case 58:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureMetricAggregationsIsMutable();
                  metricAggregations_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 58
            case 66:
              {
                com.google.analytics.data.v1beta.OrderBy m =
                    input.readMessage(
                        com.google.analytics.data.v1beta.OrderBy.parser(), extensionRegistry);
                if (orderBysBuilder_ == null) {
                  ensureOrderBysIsMutable();
                  orderBys_.add(m);
                } else {
                  orderBysBuilder_.addMessage(m);
                }
                break;
              } // case 66
            case 72:
              {
                returnPropertyQuota_ = input.readBool();
                bitField0_ |= 0x00000100;
                break;
              } // case 72
            case 82:
              {
                com.google.analytics.data.v1beta.MinuteRange m =
                    input.readMessage(
                        com.google.analytics.data.v1beta.MinuteRange.parser(), extensionRegistry);
                if (minuteRangesBuilder_ == null) {
                  ensureMinuteRangesIsMutable();
                  minuteRanges_.add(m);
                } else {
                  minuteRangesBuilder_.addMessage(m);
                }
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object property_ = "";
    /**
     *
     *
     * <pre>
     * A Google Analytics GA4 property identifier whose events are tracked.
     * Specified in the URL path and not the body. To learn more, see [where to
     * find your Property
     * ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
     *
     * Example: properties/1234
     * </pre>
     *
     * <code>string property = 1;</code>
     *
     * @return The property.
     */
    public java.lang.String getProperty() {
      java.lang.Object ref = property_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        property_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A Google Analytics GA4 property identifier whose events are tracked.
     * Specified in the URL path and not the body. To learn more, see [where to
     * find your Property
     * ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
     *
     * Example: properties/1234
     * </pre>
     *
     * <code>string property = 1;</code>
     *
     * @return The bytes for property.
     */
    public com.google.protobuf.ByteString getPropertyBytes() {
      java.lang.Object ref = property_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        property_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A Google Analytics GA4 property identifier whose events are tracked.
     * Specified in the URL path and not the body. To learn more, see [where to
     * find your Property
     * ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
     *
     * Example: properties/1234
     * </pre>
     *
     * <code>string property = 1;</code>
     *
     * @param value The property to set.
     * @return This builder for chaining.
     */
    public Builder setProperty(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      property_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A Google Analytics GA4 property identifier whose events are tracked.
     * Specified in the URL path and not the body. To learn more, see [where to
     * find your Property
     * ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
     *
     * Example: properties/1234
     * </pre>
     *
     * <code>string property = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProperty() {
      property_ = getDefaultInstance().getProperty();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A Google Analytics GA4 property identifier whose events are tracked.
     * Specified in the URL path and not the body. To learn more, see [where to
     * find your Property
     * ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
     *
     * Example: properties/1234
     * </pre>
     *
     * <code>string property = 1;</code>
     *
     * @param value The bytes for property to set.
     * @return This builder for chaining.
     */
    public Builder setPropertyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      property_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.analytics.data.v1beta.Dimension> dimensions_ =
        java.util.Collections.emptyList();

    private void ensureDimensionsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        dimensions_ =
            new java.util.ArrayList<com.google.analytics.data.v1beta.Dimension>(dimensions_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.analytics.data.v1beta.Dimension,
            com.google.analytics.data.v1beta.Dimension.Builder,
            com.google.analytics.data.v1beta.DimensionOrBuilder>
        dimensionsBuilder_;

    /**
     *
     *
     * <pre>
     * The dimensions requested and displayed.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Dimension dimensions = 2;</code>
     */
    public java.util.List<com.google.analytics.data.v1beta.Dimension> getDimensionsList() {
      if (dimensionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(dimensions_);
      } else {
        return dimensionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The dimensions requested and displayed.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Dimension dimensions = 2;</code>
     */
    public int getDimensionsCount() {
      if (dimensionsBuilder_ == null) {
        return dimensions_.size();
      } else {
        return dimensionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The dimensions requested and displayed.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Dimension dimensions = 2;</code>
     */
    public com.google.analytics.data.v1beta.Dimension getDimensions(int index) {
      if (dimensionsBuilder_ == null) {
        return dimensions_.get(index);
      } else {
        return dimensionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The dimensions requested and displayed.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Dimension dimensions = 2;</code>
     */
    public Builder setDimensions(int index, com.google.analytics.data.v1beta.Dimension value) {
      if (dimensionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDimensionsIsMutable();
        dimensions_.set(index, value);
        onChanged();
      } else {
        dimensionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The dimensions requested and displayed.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Dimension dimensions = 2;</code>
     */
    public Builder setDimensions(
        int index, com.google.analytics.data.v1beta.Dimension.Builder builderForValue) {
      if (dimensionsBuilder_ == null) {
        ensureDimensionsIsMutable();
        dimensions_.set(index, builderForValue.build());
        onChanged();
      } else {
        dimensionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The dimensions requested and displayed.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Dimension dimensions = 2;</code>
     */
    public Builder addDimensions(com.google.analytics.data.v1beta.Dimension value) {
      if (dimensionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDimensionsIsMutable();
        dimensions_.add(value);
        onChanged();
      } else {
        dimensionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The dimensions requested and displayed.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Dimension dimensions = 2;</code>
     */
    public Builder addDimensions(int index, com.google.analytics.data.v1beta.Dimension value) {
      if (dimensionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDimensionsIsMutable();
        dimensions_.add(index, value);
        onChanged();
      } else {
        dimensionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The dimensions requested and displayed.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Dimension dimensions = 2;</code>
     */
    public Builder addDimensions(
        com.google.analytics.data.v1beta.Dimension.Builder builderForValue) {
      if (dimensionsBuilder_ == null) {
        ensureDimensionsIsMutable();
        dimensions_.add(builderForValue.build());
        onChanged();
      } else {
        dimensionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The dimensions requested and displayed.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Dimension dimensions = 2;</code>
     */
    public Builder addDimensions(
        int index, com.google.analytics.data.v1beta.Dimension.Builder builderForValue) {
      if (dimensionsBuilder_ == null) {
        ensureDimensionsIsMutable();
        dimensions_.add(index, builderForValue.build());
        onChanged();
      } else {
        dimensionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The dimensions requested and displayed.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Dimension dimensions = 2;</code>
     */
    public Builder addAllDimensions(
        java.lang.Iterable<? extends com.google.analytics.data.v1beta.Dimension> values) {
      if (dimensionsBuilder_ == null) {
        ensureDimensionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dimensions_);
        onChanged();
      } else {
        dimensionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The dimensions requested and displayed.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Dimension dimensions = 2;</code>
     */
    public Builder clearDimensions() {
      if (dimensionsBuilder_ == null) {
        dimensions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        dimensionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The dimensions requested and displayed.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Dimension dimensions = 2;</code>
     */
    public Builder removeDimensions(int index) {
      if (dimensionsBuilder_ == null) {
        ensureDimensionsIsMutable();
        dimensions_.remove(index);
        onChanged();
      } else {
        dimensionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The dimensions requested and displayed.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Dimension dimensions = 2;</code>
     */
    public com.google.analytics.data.v1beta.Dimension.Builder getDimensionsBuilder(int index) {
      return getDimensionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The dimensions requested and displayed.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Dimension dimensions = 2;</code>
     */
    public com.google.analytics.data.v1beta.DimensionOrBuilder getDimensionsOrBuilder(int index) {
      if (dimensionsBuilder_ == null) {
        return dimensions_.get(index);
      } else {
        return dimensionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The dimensions requested and displayed.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Dimension dimensions = 2;</code>
     */
    public java.util.List<? extends com.google.analytics.data.v1beta.DimensionOrBuilder>
        getDimensionsOrBuilderList() {
      if (dimensionsBuilder_ != null) {
        return dimensionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(dimensions_);
      }
    }
    /**
     *
     *
     * <pre>
     * The dimensions requested and displayed.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Dimension dimensions = 2;</code>
     */
    public com.google.analytics.data.v1beta.Dimension.Builder addDimensionsBuilder() {
      return getDimensionsFieldBuilder()
          .addBuilder(com.google.analytics.data.v1beta.Dimension.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The dimensions requested and displayed.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Dimension dimensions = 2;</code>
     */
    public com.google.analytics.data.v1beta.Dimension.Builder addDimensionsBuilder(int index) {
      return getDimensionsFieldBuilder()
          .addBuilder(index, com.google.analytics.data.v1beta.Dimension.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The dimensions requested and displayed.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Dimension dimensions = 2;</code>
     */
    public java.util.List<com.google.analytics.data.v1beta.Dimension.Builder>
        getDimensionsBuilderList() {
      return getDimensionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.analytics.data.v1beta.Dimension,
            com.google.analytics.data.v1beta.Dimension.Builder,
            com.google.analytics.data.v1beta.DimensionOrBuilder>
        getDimensionsFieldBuilder() {
      if (dimensionsBuilder_ == null) {
        dimensionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.analytics.data.v1beta.Dimension,
                com.google.analytics.data.v1beta.Dimension.Builder,
                com.google.analytics.data.v1beta.DimensionOrBuilder>(
                dimensions_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        dimensions_ = null;
      }
      return dimensionsBuilder_;
    }

    private java.util.List<com.google.analytics.data.v1beta.Metric> metrics_ =
        java.util.Collections.emptyList();

    private void ensureMetricsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        metrics_ = new java.util.ArrayList<com.google.analytics.data.v1beta.Metric>(metrics_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.analytics.data.v1beta.Metric,
            com.google.analytics.data.v1beta.Metric.Builder,
            com.google.analytics.data.v1beta.MetricOrBuilder>
        metricsBuilder_;

    /**
     *
     *
     * <pre>
     * The metrics requested and displayed.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Metric metrics = 3;</code>
     */
    public java.util.List<com.google.analytics.data.v1beta.Metric> getMetricsList() {
      if (metricsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(metrics_);
      } else {
        return metricsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The metrics requested and displayed.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Metric metrics = 3;</code>
     */
    public int getMetricsCount() {
      if (metricsBuilder_ == null) {
        return metrics_.size();
      } else {
        return metricsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The metrics requested and displayed.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Metric metrics = 3;</code>
     */
    public com.google.analytics.data.v1beta.Metric getMetrics(int index) {
      if (metricsBuilder_ == null) {
        return metrics_.get(index);
      } else {
        return metricsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The metrics requested and displayed.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Metric metrics = 3;</code>
     */
    public Builder setMetrics(int index, com.google.analytics.data.v1beta.Metric value) {
      if (metricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricsIsMutable();
        metrics_.set(index, value);
        onChanged();
      } else {
        metricsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metrics requested and displayed.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Metric metrics = 3;</code>
     */
    public Builder setMetrics(
        int index, com.google.analytics.data.v1beta.Metric.Builder builderForValue) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.set(index, builderForValue.build());
        onChanged();
      } else {
        metricsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metrics requested and displayed.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Metric metrics = 3;</code>
     */
    public Builder addMetrics(com.google.analytics.data.v1beta.Metric value) {
      if (metricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricsIsMutable();
        metrics_.add(value);
        onChanged();
      } else {
        metricsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metrics requested and displayed.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Metric metrics = 3;</code>
     */
    public Builder addMetrics(int index, com.google.analytics.data.v1beta.Metric value) {
      if (metricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricsIsMutable();
        metrics_.add(index, value);
        onChanged();
      } else {
        metricsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metrics requested and displayed.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Metric metrics = 3;</code>
     */
    public Builder addMetrics(com.google.analytics.data.v1beta.Metric.Builder builderForValue) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.add(builderForValue.build());
        onChanged();
      } else {
        metricsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metrics requested and displayed.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Metric metrics = 3;</code>
     */
    public Builder addMetrics(
        int index, com.google.analytics.data.v1beta.Metric.Builder builderForValue) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.add(index, builderForValue.build());
        onChanged();
      } else {
        metricsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metrics requested and displayed.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Metric metrics = 3;</code>
     */
    public Builder addAllMetrics(
        java.lang.Iterable<? extends com.google.analytics.data.v1beta.Metric> values) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, metrics_);
        onChanged();
      } else {
        metricsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metrics requested and displayed.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Metric metrics = 3;</code>
     */
    public Builder clearMetrics() {
      if (metricsBuilder_ == null) {
        metrics_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        metricsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metrics requested and displayed.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Metric metrics = 3;</code>
     */
    public Builder removeMetrics(int index) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.remove(index);
        onChanged();
      } else {
        metricsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metrics requested and displayed.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Metric metrics = 3;</code>
     */
    public com.google.analytics.data.v1beta.Metric.Builder getMetricsBuilder(int index) {
      return getMetricsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The metrics requested and displayed.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Metric metrics = 3;</code>
     */
    public com.google.analytics.data.v1beta.MetricOrBuilder getMetricsOrBuilder(int index) {
      if (metricsBuilder_ == null) {
        return metrics_.get(index);
      } else {
        return metricsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The metrics requested and displayed.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Metric metrics = 3;</code>
     */
    public java.util.List<? extends com.google.analytics.data.v1beta.MetricOrBuilder>
        getMetricsOrBuilderList() {
      if (metricsBuilder_ != null) {
        return metricsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(metrics_);
      }
    }
    /**
     *
     *
     * <pre>
     * The metrics requested and displayed.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Metric metrics = 3;</code>
     */
    public com.google.analytics.data.v1beta.Metric.Builder addMetricsBuilder() {
      return getMetricsFieldBuilder()
          .addBuilder(com.google.analytics.data.v1beta.Metric.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The metrics requested and displayed.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Metric metrics = 3;</code>
     */
    public com.google.analytics.data.v1beta.Metric.Builder addMetricsBuilder(int index) {
      return getMetricsFieldBuilder()
          .addBuilder(index, com.google.analytics.data.v1beta.Metric.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The metrics requested and displayed.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Metric metrics = 3;</code>
     */
    public java.util.List<com.google.analytics.data.v1beta.Metric.Builder> getMetricsBuilderList() {
      return getMetricsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.analytics.data.v1beta.Metric,
            com.google.analytics.data.v1beta.Metric.Builder,
            com.google.analytics.data.v1beta.MetricOrBuilder>
        getMetricsFieldBuilder() {
      if (metricsBuilder_ == null) {
        metricsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.analytics.data.v1beta.Metric,
                com.google.analytics.data.v1beta.Metric.Builder,
                com.google.analytics.data.v1beta.MetricOrBuilder>(
                metrics_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        metrics_ = null;
      }
      return metricsBuilder_;
    }

    private com.google.analytics.data.v1beta.FilterExpression dimensionFilter_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1beta.FilterExpression,
            com.google.analytics.data.v1beta.FilterExpression.Builder,
            com.google.analytics.data.v1beta.FilterExpressionOrBuilder>
        dimensionFilterBuilder_;
    /**
     *
     *
     * <pre>
     * The filter clause of dimensions. Metrics cannot be used in this filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.FilterExpression dimension_filter = 4;</code>
     *
     * @return Whether the dimensionFilter field is set.
     */
    public boolean hasDimensionFilter() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The filter clause of dimensions. Metrics cannot be used in this filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.FilterExpression dimension_filter = 4;</code>
     *
     * @return The dimensionFilter.
     */
    public com.google.analytics.data.v1beta.FilterExpression getDimensionFilter() {
      if (dimensionFilterBuilder_ == null) {
        return dimensionFilter_ == null
            ? com.google.analytics.data.v1beta.FilterExpression.getDefaultInstance()
            : dimensionFilter_;
      } else {
        return dimensionFilterBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The filter clause of dimensions. Metrics cannot be used in this filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.FilterExpression dimension_filter = 4;</code>
     */
    public Builder setDimensionFilter(com.google.analytics.data.v1beta.FilterExpression value) {
      if (dimensionFilterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dimensionFilter_ = value;
      } else {
        dimensionFilterBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The filter clause of dimensions. Metrics cannot be used in this filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.FilterExpression dimension_filter = 4;</code>
     */
    public Builder setDimensionFilter(
        com.google.analytics.data.v1beta.FilterExpression.Builder builderForValue) {
      if (dimensionFilterBuilder_ == null) {
        dimensionFilter_ = builderForValue.build();
      } else {
        dimensionFilterBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The filter clause of dimensions. Metrics cannot be used in this filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.FilterExpression dimension_filter = 4;</code>
     */
    public Builder mergeDimensionFilter(com.google.analytics.data.v1beta.FilterExpression value) {
      if (dimensionFilterBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && dimensionFilter_ != null
            && dimensionFilter_
                != com.google.analytics.data.v1beta.FilterExpression.getDefaultInstance()) {
          getDimensionFilterBuilder().mergeFrom(value);
        } else {
          dimensionFilter_ = value;
        }
      } else {
        dimensionFilterBuilder_.mergeFrom(value);
      }
      if (dimensionFilter_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The filter clause of dimensions. Metrics cannot be used in this filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.FilterExpression dimension_filter = 4;</code>
     */
    public Builder clearDimensionFilter() {
      bitField0_ = (bitField0_ & ~0x00000008);
      dimensionFilter_ = null;
      if (dimensionFilterBuilder_ != null) {
        dimensionFilterBuilder_.dispose();
        dimensionFilterBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The filter clause of dimensions. Metrics cannot be used in this filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.FilterExpression dimension_filter = 4;</code>
     */
    public com.google.analytics.data.v1beta.FilterExpression.Builder getDimensionFilterBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getDimensionFilterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The filter clause of dimensions. Metrics cannot be used in this filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.FilterExpression dimension_filter = 4;</code>
     */
    public com.google.analytics.data.v1beta.FilterExpressionOrBuilder
        getDimensionFilterOrBuilder() {
      if (dimensionFilterBuilder_ != null) {
        return dimensionFilterBuilder_.getMessageOrBuilder();
      } else {
        return dimensionFilter_ == null
            ? com.google.analytics.data.v1beta.FilterExpression.getDefaultInstance()
            : dimensionFilter_;
      }
    }
    /**
     *
     *
     * <pre>
     * The filter clause of dimensions. Metrics cannot be used in this filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.FilterExpression dimension_filter = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1beta.FilterExpression,
            com.google.analytics.data.v1beta.FilterExpression.Builder,
            com.google.analytics.data.v1beta.FilterExpressionOrBuilder>
        getDimensionFilterFieldBuilder() {
      if (dimensionFilterBuilder_ == null) {
        dimensionFilterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.analytics.data.v1beta.FilterExpression,
                com.google.analytics.data.v1beta.FilterExpression.Builder,
                com.google.analytics.data.v1beta.FilterExpressionOrBuilder>(
                getDimensionFilter(), getParentForChildren(), isClean());
        dimensionFilter_ = null;
      }
      return dimensionFilterBuilder_;
    }

    private com.google.analytics.data.v1beta.FilterExpression metricFilter_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1beta.FilterExpression,
            com.google.analytics.data.v1beta.FilterExpression.Builder,
            com.google.analytics.data.v1beta.FilterExpressionOrBuilder>
        metricFilterBuilder_;
    /**
     *
     *
     * <pre>
     * The filter clause of metrics. Applied at post aggregation phase, similar to
     * SQL having-clause. Dimensions cannot be used in this filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.FilterExpression metric_filter = 5;</code>
     *
     * @return Whether the metricFilter field is set.
     */
    public boolean hasMetricFilter() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The filter clause of metrics. Applied at post aggregation phase, similar to
     * SQL having-clause. Dimensions cannot be used in this filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.FilterExpression metric_filter = 5;</code>
     *
     * @return The metricFilter.
     */
    public com.google.analytics.data.v1beta.FilterExpression getMetricFilter() {
      if (metricFilterBuilder_ == null) {
        return metricFilter_ == null
            ? com.google.analytics.data.v1beta.FilterExpression.getDefaultInstance()
            : metricFilter_;
      } else {
        return metricFilterBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The filter clause of metrics. Applied at post aggregation phase, similar to
     * SQL having-clause. Dimensions cannot be used in this filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.FilterExpression metric_filter = 5;</code>
     */
    public Builder setMetricFilter(com.google.analytics.data.v1beta.FilterExpression value) {
      if (metricFilterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metricFilter_ = value;
      } else {
        metricFilterBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The filter clause of metrics. Applied at post aggregation phase, similar to
     * SQL having-clause. Dimensions cannot be used in this filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.FilterExpression metric_filter = 5;</code>
     */
    public Builder setMetricFilter(
        com.google.analytics.data.v1beta.FilterExpression.Builder builderForValue) {
      if (metricFilterBuilder_ == null) {
        metricFilter_ = builderForValue.build();
      } else {
        metricFilterBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The filter clause of metrics. Applied at post aggregation phase, similar to
     * SQL having-clause. Dimensions cannot be used in this filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.FilterExpression metric_filter = 5;</code>
     */
    public Builder mergeMetricFilter(com.google.analytics.data.v1beta.FilterExpression value) {
      if (metricFilterBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && metricFilter_ != null
            && metricFilter_
                != com.google.analytics.data.v1beta.FilterExpression.getDefaultInstance()) {
          getMetricFilterBuilder().mergeFrom(value);
        } else {
          metricFilter_ = value;
        }
      } else {
        metricFilterBuilder_.mergeFrom(value);
      }
      if (metricFilter_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The filter clause of metrics. Applied at post aggregation phase, similar to
     * SQL having-clause. Dimensions cannot be used in this filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.FilterExpression metric_filter = 5;</code>
     */
    public Builder clearMetricFilter() {
      bitField0_ = (bitField0_ & ~0x00000010);
      metricFilter_ = null;
      if (metricFilterBuilder_ != null) {
        metricFilterBuilder_.dispose();
        metricFilterBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The filter clause of metrics. Applied at post aggregation phase, similar to
     * SQL having-clause. Dimensions cannot be used in this filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.FilterExpression metric_filter = 5;</code>
     */
    public com.google.analytics.data.v1beta.FilterExpression.Builder getMetricFilterBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getMetricFilterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The filter clause of metrics. Applied at post aggregation phase, similar to
     * SQL having-clause. Dimensions cannot be used in this filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.FilterExpression metric_filter = 5;</code>
     */
    public com.google.analytics.data.v1beta.FilterExpressionOrBuilder getMetricFilterOrBuilder() {
      if (metricFilterBuilder_ != null) {
        return metricFilterBuilder_.getMessageOrBuilder();
      } else {
        return metricFilter_ == null
            ? com.google.analytics.data.v1beta.FilterExpression.getDefaultInstance()
            : metricFilter_;
      }
    }
    /**
     *
     *
     * <pre>
     * The filter clause of metrics. Applied at post aggregation phase, similar to
     * SQL having-clause. Dimensions cannot be used in this filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.FilterExpression metric_filter = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1beta.FilterExpression,
            com.google.analytics.data.v1beta.FilterExpression.Builder,
            com.google.analytics.data.v1beta.FilterExpressionOrBuilder>
        getMetricFilterFieldBuilder() {
      if (metricFilterBuilder_ == null) {
        metricFilterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.analytics.data.v1beta.FilterExpression,
                com.google.analytics.data.v1beta.FilterExpression.Builder,
                com.google.analytics.data.v1beta.FilterExpressionOrBuilder>(
                getMetricFilter(), getParentForChildren(), isClean());
        metricFilter_ = null;
      }
      return metricFilterBuilder_;
    }

    private long limit_;
    /**
     *
     *
     * <pre>
     * The number of rows to return. If unspecified, 10,000 rows are returned. The
     * API returns a maximum of 250,000 rows per request, no matter how many you
     * ask for. `limit` must be positive.
     *
     * The API can also return fewer rows than the requested `limit`, if there
     * aren't as many dimension values as the `limit`. For instance, there are
     * fewer than 300 possible values for the dimension `country`, so when
     * reporting on only `country`, you can't get more than 300 rows, even if you
     * set `limit` to a higher value.
     * </pre>
     *
     * <code>int64 limit = 6;</code>
     *
     * @return The limit.
     */
    @java.lang.Override
    public long getLimit() {
      return limit_;
    }
    /**
     *
     *
     * <pre>
     * The number of rows to return. If unspecified, 10,000 rows are returned. The
     * API returns a maximum of 250,000 rows per request, no matter how many you
     * ask for. `limit` must be positive.
     *
     * The API can also return fewer rows than the requested `limit`, if there
     * aren't as many dimension values as the `limit`. For instance, there are
     * fewer than 300 possible values for the dimension `country`, so when
     * reporting on only `country`, you can't get more than 300 rows, even if you
     * set `limit` to a higher value.
     * </pre>
     *
     * <code>int64 limit = 6;</code>
     *
     * @param value The limit to set.
     * @return This builder for chaining.
     */
    public Builder setLimit(long value) {

      limit_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of rows to return. If unspecified, 10,000 rows are returned. The
     * API returns a maximum of 250,000 rows per request, no matter how many you
     * ask for. `limit` must be positive.
     *
     * The API can also return fewer rows than the requested `limit`, if there
     * aren't as many dimension values as the `limit`. For instance, there are
     * fewer than 300 possible values for the dimension `country`, so when
     * reporting on only `country`, you can't get more than 300 rows, even if you
     * set `limit` to a higher value.
     * </pre>
     *
     * <code>int64 limit = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLimit() {
      bitField0_ = (bitField0_ & ~0x00000020);
      limit_ = 0L;
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> metricAggregations_ =
        java.util.Collections.emptyList();

    private void ensureMetricAggregationsIsMutable() {
      if (!((bitField0_ & 0x00000040) != 0)) {
        metricAggregations_ = new java.util.ArrayList<java.lang.Integer>(metricAggregations_);
        bitField0_ |= 0x00000040;
      }
    }
    /**
     *
     *
     * <pre>
     * Aggregation of metrics. Aggregated metric values will be shown in rows
     * where the dimension_values are set to "RESERVED_(MetricAggregation)".
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MetricAggregation metric_aggregations = 7;
     * </code>
     *
     * @return A list containing the metricAggregations.
     */
    public java.util.List<com.google.analytics.data.v1beta.MetricAggregation>
        getMetricAggregationsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.analytics.data.v1beta.MetricAggregation>(
          metricAggregations_, metricAggregations_converter_);
    }
    /**
     *
     *
     * <pre>
     * Aggregation of metrics. Aggregated metric values will be shown in rows
     * where the dimension_values are set to "RESERVED_(MetricAggregation)".
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MetricAggregation metric_aggregations = 7;
     * </code>
     *
     * @return The count of metricAggregations.
     */
    public int getMetricAggregationsCount() {
      return metricAggregations_.size();
    }
    /**
     *
     *
     * <pre>
     * Aggregation of metrics. Aggregated metric values will be shown in rows
     * where the dimension_values are set to "RESERVED_(MetricAggregation)".
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MetricAggregation metric_aggregations = 7;
     * </code>
     *
     * @param index The index of the element to return.
     * @return The metricAggregations at the given index.
     */
    public com.google.analytics.data.v1beta.MetricAggregation getMetricAggregations(int index) {
      return metricAggregations_converter_.convert(metricAggregations_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Aggregation of metrics. Aggregated metric values will be shown in rows
     * where the dimension_values are set to "RESERVED_(MetricAggregation)".
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MetricAggregation metric_aggregations = 7;
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The metricAggregations to set.
     * @return This builder for chaining.
     */
    public Builder setMetricAggregations(
        int index, com.google.analytics.data.v1beta.MetricAggregation value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureMetricAggregationsIsMutable();
      metricAggregations_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Aggregation of metrics. Aggregated metric values will be shown in rows
     * where the dimension_values are set to "RESERVED_(MetricAggregation)".
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MetricAggregation metric_aggregations = 7;
     * </code>
     *
     * @param value The metricAggregations to add.
     * @return This builder for chaining.
     */
    public Builder addMetricAggregations(com.google.analytics.data.v1beta.MetricAggregation value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureMetricAggregationsIsMutable();
      metricAggregations_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Aggregation of metrics. Aggregated metric values will be shown in rows
     * where the dimension_values are set to "RESERVED_(MetricAggregation)".
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MetricAggregation metric_aggregations = 7;
     * </code>
     *
     * @param values The metricAggregations to add.
     * @return This builder for chaining.
     */
    public Builder addAllMetricAggregations(
        java.lang.Iterable<? extends com.google.analytics.data.v1beta.MetricAggregation> values) {
      ensureMetricAggregationsIsMutable();
      for (com.google.analytics.data.v1beta.MetricAggregation value : values) {
        metricAggregations_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Aggregation of metrics. Aggregated metric values will be shown in rows
     * where the dimension_values are set to "RESERVED_(MetricAggregation)".
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MetricAggregation metric_aggregations = 7;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMetricAggregations() {
      metricAggregations_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Aggregation of metrics. Aggregated metric values will be shown in rows
     * where the dimension_values are set to "RESERVED_(MetricAggregation)".
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MetricAggregation metric_aggregations = 7;
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for metricAggregations.
     */
    public java.util.List<java.lang.Integer> getMetricAggregationsValueList() {
      return java.util.Collections.unmodifiableList(metricAggregations_);
    }
    /**
     *
     *
     * <pre>
     * Aggregation of metrics. Aggregated metric values will be shown in rows
     * where the dimension_values are set to "RESERVED_(MetricAggregation)".
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MetricAggregation metric_aggregations = 7;
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of metricAggregations at the given index.
     */
    public int getMetricAggregationsValue(int index) {
      return metricAggregations_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Aggregation of metrics. Aggregated metric values will be shown in rows
     * where the dimension_values are set to "RESERVED_(MetricAggregation)".
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MetricAggregation metric_aggregations = 7;
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for metricAggregations to set.
     * @return This builder for chaining.
     */
    public Builder setMetricAggregationsValue(int index, int value) {
      ensureMetricAggregationsIsMutable();
      metricAggregations_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Aggregation of metrics. Aggregated metric values will be shown in rows
     * where the dimension_values are set to "RESERVED_(MetricAggregation)".
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MetricAggregation metric_aggregations = 7;
     * </code>
     *
     * @param value The enum numeric value on the wire for metricAggregations to add.
     * @return This builder for chaining.
     */
    public Builder addMetricAggregationsValue(int value) {
      ensureMetricAggregationsIsMutable();
      metricAggregations_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Aggregation of metrics. Aggregated metric values will be shown in rows
     * where the dimension_values are set to "RESERVED_(MetricAggregation)".
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MetricAggregation metric_aggregations = 7;
     * </code>
     *
     * @param values The enum numeric values on the wire for metricAggregations to add.
     * @return This builder for chaining.
     */
    public Builder addAllMetricAggregationsValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureMetricAggregationsIsMutable();
      for (int value : values) {
        metricAggregations_.add(value);
      }
      onChanged();
      return this;
    }

    private java.util.List<com.google.analytics.data.v1beta.OrderBy> orderBys_ =
        java.util.Collections.emptyList();

    private void ensureOrderBysIsMutable() {
      if (!((bitField0_ & 0x00000080) != 0)) {
        orderBys_ = new java.util.ArrayList<com.google.analytics.data.v1beta.OrderBy>(orderBys_);
        bitField0_ |= 0x00000080;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.analytics.data.v1beta.OrderBy,
            com.google.analytics.data.v1beta.OrderBy.Builder,
            com.google.analytics.data.v1beta.OrderByOrBuilder>
        orderBysBuilder_;

    /**
     *
     *
     * <pre>
     * Specifies how rows are ordered in the response.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.OrderBy order_bys = 8;</code>
     */
    public java.util.List<com.google.analytics.data.v1beta.OrderBy> getOrderBysList() {
      if (orderBysBuilder_ == null) {
        return java.util.Collections.unmodifiableList(orderBys_);
      } else {
        return orderBysBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies how rows are ordered in the response.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.OrderBy order_bys = 8;</code>
     */
    public int getOrderBysCount() {
      if (orderBysBuilder_ == null) {
        return orderBys_.size();
      } else {
        return orderBysBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies how rows are ordered in the response.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.OrderBy order_bys = 8;</code>
     */
    public com.google.analytics.data.v1beta.OrderBy getOrderBys(int index) {
      if (orderBysBuilder_ == null) {
        return orderBys_.get(index);
      } else {
        return orderBysBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies how rows are ordered in the response.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.OrderBy order_bys = 8;</code>
     */
    public Builder setOrderBys(int index, com.google.analytics.data.v1beta.OrderBy value) {
      if (orderBysBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOrderBysIsMutable();
        orderBys_.set(index, value);
        onChanged();
      } else {
        orderBysBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies how rows are ordered in the response.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.OrderBy order_bys = 8;</code>
     */
    public Builder setOrderBys(
        int index, com.google.analytics.data.v1beta.OrderBy.Builder builderForValue) {
      if (orderBysBuilder_ == null) {
        ensureOrderBysIsMutable();
        orderBys_.set(index, builderForValue.build());
        onChanged();
      } else {
        orderBysBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies how rows are ordered in the response.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.OrderBy order_bys = 8;</code>
     */
    public Builder addOrderBys(com.google.analytics.data.v1beta.OrderBy value) {
      if (orderBysBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOrderBysIsMutable();
        orderBys_.add(value);
        onChanged();
      } else {
        orderBysBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies how rows are ordered in the response.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.OrderBy order_bys = 8;</code>
     */
    public Builder addOrderBys(int index, com.google.analytics.data.v1beta.OrderBy value) {
      if (orderBysBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOrderBysIsMutable();
        orderBys_.add(index, value);
        onChanged();
      } else {
        orderBysBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies how rows are ordered in the response.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.OrderBy order_bys = 8;</code>
     */
    public Builder addOrderBys(com.google.analytics.data.v1beta.OrderBy.Builder builderForValue) {
      if (orderBysBuilder_ == null) {
        ensureOrderBysIsMutable();
        orderBys_.add(builderForValue.build());
        onChanged();
      } else {
        orderBysBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies how rows are ordered in the response.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.OrderBy order_bys = 8;</code>
     */
    public Builder addOrderBys(
        int index, com.google.analytics.data.v1beta.OrderBy.Builder builderForValue) {
      if (orderBysBuilder_ == null) {
        ensureOrderBysIsMutable();
        orderBys_.add(index, builderForValue.build());
        onChanged();
      } else {
        orderBysBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies how rows are ordered in the response.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.OrderBy order_bys = 8;</code>
     */
    public Builder addAllOrderBys(
        java.lang.Iterable<? extends com.google.analytics.data.v1beta.OrderBy> values) {
      if (orderBysBuilder_ == null) {
        ensureOrderBysIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, orderBys_);
        onChanged();
      } else {
        orderBysBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies how rows are ordered in the response.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.OrderBy order_bys = 8;</code>
     */
    public Builder clearOrderBys() {
      if (orderBysBuilder_ == null) {
        orderBys_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000080);
        onChanged();
      } else {
        orderBysBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies how rows are ordered in the response.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.OrderBy order_bys = 8;</code>
     */
    public Builder removeOrderBys(int index) {
      if (orderBysBuilder_ == null) {
        ensureOrderBysIsMutable();
        orderBys_.remove(index);
        onChanged();
      } else {
        orderBysBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies how rows are ordered in the response.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.OrderBy order_bys = 8;</code>
     */
    public com.google.analytics.data.v1beta.OrderBy.Builder getOrderBysBuilder(int index) {
      return getOrderBysFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Specifies how rows are ordered in the response.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.OrderBy order_bys = 8;</code>
     */
    public com.google.analytics.data.v1beta.OrderByOrBuilder getOrderBysOrBuilder(int index) {
      if (orderBysBuilder_ == null) {
        return orderBys_.get(index);
      } else {
        return orderBysBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies how rows are ordered in the response.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.OrderBy order_bys = 8;</code>
     */
    public java.util.List<? extends com.google.analytics.data.v1beta.OrderByOrBuilder>
        getOrderBysOrBuilderList() {
      if (orderBysBuilder_ != null) {
        return orderBysBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(orderBys_);
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies how rows are ordered in the response.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.OrderBy order_bys = 8;</code>
     */
    public com.google.analytics.data.v1beta.OrderBy.Builder addOrderBysBuilder() {
      return getOrderBysFieldBuilder()
          .addBuilder(com.google.analytics.data.v1beta.OrderBy.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Specifies how rows are ordered in the response.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.OrderBy order_bys = 8;</code>
     */
    public com.google.analytics.data.v1beta.OrderBy.Builder addOrderBysBuilder(int index) {
      return getOrderBysFieldBuilder()
          .addBuilder(index, com.google.analytics.data.v1beta.OrderBy.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Specifies how rows are ordered in the response.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.OrderBy order_bys = 8;</code>
     */
    public java.util.List<com.google.analytics.data.v1beta.OrderBy.Builder>
        getOrderBysBuilderList() {
      return getOrderBysFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.analytics.data.v1beta.OrderBy,
            com.google.analytics.data.v1beta.OrderBy.Builder,
            com.google.analytics.data.v1beta.OrderByOrBuilder>
        getOrderBysFieldBuilder() {
      if (orderBysBuilder_ == null) {
        orderBysBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.analytics.data.v1beta.OrderBy,
                com.google.analytics.data.v1beta.OrderBy.Builder,
                com.google.analytics.data.v1beta.OrderByOrBuilder>(
                orderBys_, ((bitField0_ & 0x00000080) != 0), getParentForChildren(), isClean());
        orderBys_ = null;
      }
      return orderBysBuilder_;
    }

    private boolean returnPropertyQuota_;
    /**
     *
     *
     * <pre>
     * Toggles whether to return the current state of this Analytics Property's
     * Realtime quota. Quota is returned in [PropertyQuota](#PropertyQuota).
     * </pre>
     *
     * <code>bool return_property_quota = 9;</code>
     *
     * @return The returnPropertyQuota.
     */
    @java.lang.Override
    public boolean getReturnPropertyQuota() {
      return returnPropertyQuota_;
    }
    /**
     *
     *
     * <pre>
     * Toggles whether to return the current state of this Analytics Property's
     * Realtime quota. Quota is returned in [PropertyQuota](#PropertyQuota).
     * </pre>
     *
     * <code>bool return_property_quota = 9;</code>
     *
     * @param value The returnPropertyQuota to set.
     * @return This builder for chaining.
     */
    public Builder setReturnPropertyQuota(boolean value) {

      returnPropertyQuota_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Toggles whether to return the current state of this Analytics Property's
     * Realtime quota. Quota is returned in [PropertyQuota](#PropertyQuota).
     * </pre>
     *
     * <code>bool return_property_quota = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReturnPropertyQuota() {
      bitField0_ = (bitField0_ & ~0x00000100);
      returnPropertyQuota_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.analytics.data.v1beta.MinuteRange> minuteRanges_ =
        java.util.Collections.emptyList();

    private void ensureMinuteRangesIsMutable() {
      if (!((bitField0_ & 0x00000200) != 0)) {
        minuteRanges_ =
            new java.util.ArrayList<com.google.analytics.data.v1beta.MinuteRange>(minuteRanges_);
        bitField0_ |= 0x00000200;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.analytics.data.v1beta.MinuteRange,
            com.google.analytics.data.v1beta.MinuteRange.Builder,
            com.google.analytics.data.v1beta.MinuteRangeOrBuilder>
        minuteRangesBuilder_;

    /**
     *
     *
     * <pre>
     * The minute ranges of event data to read. If unspecified, one minute range
     * for the last 30 minutes will be used. If multiple minute ranges are
     * requested, each response row will contain a zero based minute range index.
     * If two minute ranges overlap, the event data for the overlapping minutes is
     * included in the response rows for both minute ranges.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MinuteRange minute_ranges = 10;</code>
     */
    public java.util.List<com.google.analytics.data.v1beta.MinuteRange> getMinuteRangesList() {
      if (minuteRangesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(minuteRanges_);
      } else {
        return minuteRangesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The minute ranges of event data to read. If unspecified, one minute range
     * for the last 30 minutes will be used. If multiple minute ranges are
     * requested, each response row will contain a zero based minute range index.
     * If two minute ranges overlap, the event data for the overlapping minutes is
     * included in the response rows for both minute ranges.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MinuteRange minute_ranges = 10;</code>
     */
    public int getMinuteRangesCount() {
      if (minuteRangesBuilder_ == null) {
        return minuteRanges_.size();
      } else {
        return minuteRangesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The minute ranges of event data to read. If unspecified, one minute range
     * for the last 30 minutes will be used. If multiple minute ranges are
     * requested, each response row will contain a zero based minute range index.
     * If two minute ranges overlap, the event data for the overlapping minutes is
     * included in the response rows for both minute ranges.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MinuteRange minute_ranges = 10;</code>
     */
    public com.google.analytics.data.v1beta.MinuteRange getMinuteRanges(int index) {
      if (minuteRangesBuilder_ == null) {
        return minuteRanges_.get(index);
      } else {
        return minuteRangesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The minute ranges of event data to read. If unspecified, one minute range
     * for the last 30 minutes will be used. If multiple minute ranges are
     * requested, each response row will contain a zero based minute range index.
     * If two minute ranges overlap, the event data for the overlapping minutes is
     * included in the response rows for both minute ranges.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MinuteRange minute_ranges = 10;</code>
     */
    public Builder setMinuteRanges(int index, com.google.analytics.data.v1beta.MinuteRange value) {
      if (minuteRangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMinuteRangesIsMutable();
        minuteRanges_.set(index, value);
        onChanged();
      } else {
        minuteRangesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The minute ranges of event data to read. If unspecified, one minute range
     * for the last 30 minutes will be used. If multiple minute ranges are
     * requested, each response row will contain a zero based minute range index.
     * If two minute ranges overlap, the event data for the overlapping minutes is
     * included in the response rows for both minute ranges.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MinuteRange minute_ranges = 10;</code>
     */
    public Builder setMinuteRanges(
        int index, com.google.analytics.data.v1beta.MinuteRange.Builder builderForValue) {
      if (minuteRangesBuilder_ == null) {
        ensureMinuteRangesIsMutable();
        minuteRanges_.set(index, builderForValue.build());
        onChanged();
      } else {
        minuteRangesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The minute ranges of event data to read. If unspecified, one minute range
     * for the last 30 minutes will be used. If multiple minute ranges are
     * requested, each response row will contain a zero based minute range index.
     * If two minute ranges overlap, the event data for the overlapping minutes is
     * included in the response rows for both minute ranges.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MinuteRange minute_ranges = 10;</code>
     */
    public Builder addMinuteRanges(com.google.analytics.data.v1beta.MinuteRange value) {
      if (minuteRangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMinuteRangesIsMutable();
        minuteRanges_.add(value);
        onChanged();
      } else {
        minuteRangesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The minute ranges of event data to read. If unspecified, one minute range
     * for the last 30 minutes will be used. If multiple minute ranges are
     * requested, each response row will contain a zero based minute range index.
     * If two minute ranges overlap, the event data for the overlapping minutes is
     * included in the response rows for both minute ranges.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MinuteRange minute_ranges = 10;</code>
     */
    public Builder addMinuteRanges(int index, com.google.analytics.data.v1beta.MinuteRange value) {
      if (minuteRangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMinuteRangesIsMutable();
        minuteRanges_.add(index, value);
        onChanged();
      } else {
        minuteRangesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The minute ranges of event data to read. If unspecified, one minute range
     * for the last 30 minutes will be used. If multiple minute ranges are
     * requested, each response row will contain a zero based minute range index.
     * If two minute ranges overlap, the event data for the overlapping minutes is
     * included in the response rows for both minute ranges.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MinuteRange minute_ranges = 10;</code>
     */
    public Builder addMinuteRanges(
        com.google.analytics.data.v1beta.MinuteRange.Builder builderForValue) {
      if (minuteRangesBuilder_ == null) {
        ensureMinuteRangesIsMutable();
        minuteRanges_.add(builderForValue.build());
        onChanged();
      } else {
        minuteRangesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The minute ranges of event data to read. If unspecified, one minute range
     * for the last 30 minutes will be used. If multiple minute ranges are
     * requested, each response row will contain a zero based minute range index.
     * If two minute ranges overlap, the event data for the overlapping minutes is
     * included in the response rows for both minute ranges.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MinuteRange minute_ranges = 10;</code>
     */
    public Builder addMinuteRanges(
        int index, com.google.analytics.data.v1beta.MinuteRange.Builder builderForValue) {
      if (minuteRangesBuilder_ == null) {
        ensureMinuteRangesIsMutable();
        minuteRanges_.add(index, builderForValue.build());
        onChanged();
      } else {
        minuteRangesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The minute ranges of event data to read. If unspecified, one minute range
     * for the last 30 minutes will be used. If multiple minute ranges are
     * requested, each response row will contain a zero based minute range index.
     * If two minute ranges overlap, the event data for the overlapping minutes is
     * included in the response rows for both minute ranges.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MinuteRange minute_ranges = 10;</code>
     */
    public Builder addAllMinuteRanges(
        java.lang.Iterable<? extends com.google.analytics.data.v1beta.MinuteRange> values) {
      if (minuteRangesBuilder_ == null) {
        ensureMinuteRangesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, minuteRanges_);
        onChanged();
      } else {
        minuteRangesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The minute ranges of event data to read. If unspecified, one minute range
     * for the last 30 minutes will be used. If multiple minute ranges are
     * requested, each response row will contain a zero based minute range index.
     * If two minute ranges overlap, the event data for the overlapping minutes is
     * included in the response rows for both minute ranges.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MinuteRange minute_ranges = 10;</code>
     */
    public Builder clearMinuteRanges() {
      if (minuteRangesBuilder_ == null) {
        minuteRanges_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000200);
        onChanged();
      } else {
        minuteRangesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The minute ranges of event data to read. If unspecified, one minute range
     * for the last 30 minutes will be used. If multiple minute ranges are
     * requested, each response row will contain a zero based minute range index.
     * If two minute ranges overlap, the event data for the overlapping minutes is
     * included in the response rows for both minute ranges.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MinuteRange minute_ranges = 10;</code>
     */
    public Builder removeMinuteRanges(int index) {
      if (minuteRangesBuilder_ == null) {
        ensureMinuteRangesIsMutable();
        minuteRanges_.remove(index);
        onChanged();
      } else {
        minuteRangesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The minute ranges of event data to read. If unspecified, one minute range
     * for the last 30 minutes will be used. If multiple minute ranges are
     * requested, each response row will contain a zero based minute range index.
     * If two minute ranges overlap, the event data for the overlapping minutes is
     * included in the response rows for both minute ranges.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MinuteRange minute_ranges = 10;</code>
     */
    public com.google.analytics.data.v1beta.MinuteRange.Builder getMinuteRangesBuilder(int index) {
      return getMinuteRangesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The minute ranges of event data to read. If unspecified, one minute range
     * for the last 30 minutes will be used. If multiple minute ranges are
     * requested, each response row will contain a zero based minute range index.
     * If two minute ranges overlap, the event data for the overlapping minutes is
     * included in the response rows for both minute ranges.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MinuteRange minute_ranges = 10;</code>
     */
    public com.google.analytics.data.v1beta.MinuteRangeOrBuilder getMinuteRangesOrBuilder(
        int index) {
      if (minuteRangesBuilder_ == null) {
        return minuteRanges_.get(index);
      } else {
        return minuteRangesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The minute ranges of event data to read. If unspecified, one minute range
     * for the last 30 minutes will be used. If multiple minute ranges are
     * requested, each response row will contain a zero based minute range index.
     * If two minute ranges overlap, the event data for the overlapping minutes is
     * included in the response rows for both minute ranges.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MinuteRange minute_ranges = 10;</code>
     */
    public java.util.List<? extends com.google.analytics.data.v1beta.MinuteRangeOrBuilder>
        getMinuteRangesOrBuilderList() {
      if (minuteRangesBuilder_ != null) {
        return minuteRangesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(minuteRanges_);
      }
    }
    /**
     *
     *
     * <pre>
     * The minute ranges of event data to read. If unspecified, one minute range
     * for the last 30 minutes will be used. If multiple minute ranges are
     * requested, each response row will contain a zero based minute range index.
     * If two minute ranges overlap, the event data for the overlapping minutes is
     * included in the response rows for both minute ranges.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MinuteRange minute_ranges = 10;</code>
     */
    public com.google.analytics.data.v1beta.MinuteRange.Builder addMinuteRangesBuilder() {
      return getMinuteRangesFieldBuilder()
          .addBuilder(com.google.analytics.data.v1beta.MinuteRange.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The minute ranges of event data to read. If unspecified, one minute range
     * for the last 30 minutes will be used. If multiple minute ranges are
     * requested, each response row will contain a zero based minute range index.
     * If two minute ranges overlap, the event data for the overlapping minutes is
     * included in the response rows for both minute ranges.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MinuteRange minute_ranges = 10;</code>
     */
    public com.google.analytics.data.v1beta.MinuteRange.Builder addMinuteRangesBuilder(int index) {
      return getMinuteRangesFieldBuilder()
          .addBuilder(index, com.google.analytics.data.v1beta.MinuteRange.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The minute ranges of event data to read. If unspecified, one minute range
     * for the last 30 minutes will be used. If multiple minute ranges are
     * requested, each response row will contain a zero based minute range index.
     * If two minute ranges overlap, the event data for the overlapping minutes is
     * included in the response rows for both minute ranges.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MinuteRange minute_ranges = 10;</code>
     */
    public java.util.List<com.google.analytics.data.v1beta.MinuteRange.Builder>
        getMinuteRangesBuilderList() {
      return getMinuteRangesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.analytics.data.v1beta.MinuteRange,
            com.google.analytics.data.v1beta.MinuteRange.Builder,
            com.google.analytics.data.v1beta.MinuteRangeOrBuilder>
        getMinuteRangesFieldBuilder() {
      if (minuteRangesBuilder_ == null) {
        minuteRangesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.analytics.data.v1beta.MinuteRange,
                com.google.analytics.data.v1beta.MinuteRange.Builder,
                com.google.analytics.data.v1beta.MinuteRangeOrBuilder>(
                minuteRanges_, ((bitField0_ & 0x00000200) != 0), getParentForChildren(), isClean());
        minuteRanges_ = null;
      }
      return minuteRangesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.analytics.data.v1beta.RunRealtimeReportRequest)
  }

  // @@protoc_insertion_point(class_scope:google.analytics.data.v1beta.RunRealtimeReportRequest)
  private static final com.google.analytics.data.v1beta.RunRealtimeReportRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.analytics.data.v1beta.RunRealtimeReportRequest();
  }

  public static com.google.analytics.data.v1beta.RunRealtimeReportRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RunRealtimeReportRequest> PARSER =
      new com.google.protobuf.AbstractParser<RunRealtimeReportRequest>() {
        @java.lang.Override
        public RunRealtimeReportRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RunRealtimeReportRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RunRealtimeReportRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.analytics.data.v1beta.RunRealtimeReportRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
