/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.data.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MetadataName
implements ResourceName {
    private static final PathTemplate PROPERTY = PathTemplate.createWithoutUrlEncoding((String)"properties/{property}/metadata");
    private volatile Map<String, String> fieldValuesMap;
    private final String property;

    @Deprecated
    protected MetadataName() {
        this.property = null;
    }

    private MetadataName(Builder builder) {
        this.property = (String)Preconditions.checkNotNull((Object)builder.getProperty());
    }

    public String getProperty() {
        return this.property;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static MetadataName of(String property) {
        return MetadataName.newBuilder().setProperty(property).build();
    }

    public static String format(String property) {
        return MetadataName.newBuilder().setProperty(property).build().toString();
    }

    public static MetadataName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROPERTY.validatedMatch(formattedString, "MetadataName.parse: formattedString not in valid format");
        return MetadataName.of((String)matchMap.get("property"));
    }

    public static List<MetadataName> parseList(List<String> formattedStrings) {
        ArrayList<MetadataName> list = new ArrayList<MetadataName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(MetadataName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<MetadataName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (MetadataName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROPERTY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            MetadataName metadataName = this;
            synchronized (metadataName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.property != null) {
                        fieldMapBuilder.put((Object)"property", (Object)this.property);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROPERTY.instantiate(new String[]{"property", this.property});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            MetadataName that = (MetadataName)o;
            return Objects.equals(this.property, that.property);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= Objects.hashCode(this.property);
    }

    public static class Builder {
        private String property;

        protected Builder() {
        }

        public String getProperty() {
            return this.property;
        }

        public Builder setProperty(String property) {
            this.property = property;
            return this;
        }

        private Builder(MetadataName metadataName) {
            this.property = metadataName.property;
        }

        public MetadataName build() {
            return new MetadataName(this);
        }
    }
}

