/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/analytics/data/v1alpha/analytics_data_api.proto

// Protobuf Java Version: 3.25.5
package com.google.analytics.data.v1alpha;

/**
 *
 *
 * <pre>
 * An audience list is a list of users in an audience at the time of the list's
 * creation. One audience may have multiple audience lists created for different
 * days.
 * </pre>
 *
 * Protobuf type {@code google.analytics.data.v1alpha.AudienceList}
 */
public final class AudienceList extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.analytics.data.v1alpha.AudienceList)
    AudienceListOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AudienceList.newBuilder() to construct.
  private AudienceList(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AudienceList() {
    name_ = "";
    audience_ = "";
    audienceDisplayName_ = "";
    dimensions_ = java.util.Collections.emptyList();
    state_ = 0;
    errorMessage_ = "";
    recurringAudienceList_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AudienceList();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.analytics.data.v1alpha.AnalyticsDataApiProto
        .internal_static_google_analytics_data_v1alpha_AudienceList_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.analytics.data.v1alpha.AnalyticsDataApiProto
        .internal_static_google_analytics_data_v1alpha_AudienceList_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.analytics.data.v1alpha.AudienceList.class,
            com.google.analytics.data.v1alpha.AudienceList.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The AudienceList currently exists in this state.
   * </pre>
   *
   * Protobuf enum {@code google.analytics.data.v1alpha.AudienceList.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified state will never be used.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The AudienceList is currently creating and will be available in the
     * future. Creating occurs immediately after the CreateAudienceList call.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    CREATING(1),
    /**
     *
     *
     * <pre>
     * The AudienceList is fully created and ready for querying. An AudienceList
     * is updated to active asynchronously from a request; this occurs some
     * time (for example 15 minutes) after the initial create call.
     * </pre>
     *
     * <code>ACTIVE = 2;</code>
     */
    ACTIVE(2),
    /**
     *
     *
     * <pre>
     * The AudienceList failed to be created. It is possible that re-requesting
     * this audience list will succeed.
     * </pre>
     *
     * <code>FAILED = 3;</code>
     */
    FAILED(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified state will never be used.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The AudienceList is currently creating and will be available in the
     * future. Creating occurs immediately after the CreateAudienceList call.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    public static final int CREATING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The AudienceList is fully created and ready for querying. An AudienceList
     * is updated to active asynchronously from a request; this occurs some
     * time (for example 15 minutes) after the initial create call.
     * </pre>
     *
     * <code>ACTIVE = 2;</code>
     */
    public static final int ACTIVE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The AudienceList failed to be created. It is possible that re-requesting
     * this audience list will succeed.
     * </pre>
     *
     * <code>FAILED = 3;</code>
     */
    public static final int FAILED_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return CREATING;
        case 2:
          return ACTIVE;
        case 3:
          return FAILED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.analytics.data.v1alpha.AudienceList.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.analytics.data.v1alpha.AudienceList.State)
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Identifier. The audience list resource name assigned during
   * creation. This resource name identifies this `AudienceList`.
   *
   * Format: `properties/{property}/audienceLists/{audience_list}`
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Identifier. The audience list resource name assigned during
   * creation. This resource name identifies this `AudienceList`.
   *
   * Format: `properties/{property}/audienceLists/{audience_list}`
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AUDIENCE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object audience_ = "";
  /**
   *
   *
   * <pre>
   * Required. The audience resource name. This resource name identifies the
   * audience being listed and is shared between the Analytics Data &amp; Admin
   * APIs.
   *
   * Format: `properties/{property}/audiences/{audience}`
   * </pre>
   *
   * <code>string audience = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The audience.
   */
  @java.lang.Override
  public java.lang.String getAudience() {
    java.lang.Object ref = audience_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      audience_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The audience resource name. This resource name identifies the
   * audience being listed and is shared between the Analytics Data &amp; Admin
   * APIs.
   *
   * Format: `properties/{property}/audiences/{audience}`
   * </pre>
   *
   * <code>string audience = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for audience.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAudienceBytes() {
    java.lang.Object ref = audience_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      audience_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AUDIENCE_DISPLAY_NAME_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object audienceDisplayName_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The descriptive display name for this audience. For example,
   * "Purchasers".
   * </pre>
   *
   * <code>string audience_display_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The audienceDisplayName.
   */
  @java.lang.Override
  public java.lang.String getAudienceDisplayName() {
    java.lang.Object ref = audienceDisplayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      audienceDisplayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The descriptive display name for this audience. For example,
   * "Purchasers".
   * </pre>
   *
   * <code>string audience_display_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for audienceDisplayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAudienceDisplayNameBytes() {
    java.lang.Object ref = audienceDisplayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      audienceDisplayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DIMENSIONS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.analytics.data.v1alpha.AudienceDimension> dimensions_;
  /**
   *
   *
   * <pre>
   * Required. The dimensions requested and displayed in the query response.
   * </pre>
   *
   * <code>
   * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.analytics.data.v1alpha.AudienceDimension> getDimensionsList() {
    return dimensions_;
  }
  /**
   *
   *
   * <pre>
   * Required. The dimensions requested and displayed in the query response.
   * </pre>
   *
   * <code>
   * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.analytics.data.v1alpha.AudienceDimensionOrBuilder>
      getDimensionsOrBuilderList() {
    return dimensions_;
  }
  /**
   *
   *
   * <pre>
   * Required. The dimensions requested and displayed in the query response.
   * </pre>
   *
   * <code>
   * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getDimensionsCount() {
    return dimensions_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. The dimensions requested and displayed in the query response.
   * </pre>
   *
   * <code>
   * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.AudienceDimension getDimensions(int index) {
    return dimensions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. The dimensions requested and displayed in the query response.
   * </pre>
   *
   * <code>
   * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.AudienceDimensionOrBuilder getDimensionsOrBuilder(
      int index) {
    return dimensions_.get(index);
  }

  public static final int STATE_FIELD_NUMBER = 5;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The current state for this AudienceList.
   * </pre>
   *
   * <code>
   * optional .google.analytics.data.v1alpha.AudienceList.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the state field is set.
   */
  @java.lang.Override
  public boolean hasState() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The current state for this AudienceList.
   * </pre>
   *
   * <code>
   * optional .google.analytics.data.v1alpha.AudienceList.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The current state for this AudienceList.
   * </pre>
   *
   * <code>
   * optional .google.analytics.data.v1alpha.AudienceList.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.AudienceList.State getState() {
    com.google.analytics.data.v1alpha.AudienceList.State result =
        com.google.analytics.data.v1alpha.AudienceList.State.forNumber(state_);
    return result == null
        ? com.google.analytics.data.v1alpha.AudienceList.State.UNRECOGNIZED
        : result;
  }

  public static final int BEGIN_CREATING_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp beginCreatingTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time when CreateAudienceList was called and the
   * AudienceList began the `CREATING` state.
   * </pre>
   *
   * <code>
   * optional .google.protobuf.Timestamp begin_creating_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the beginCreatingTime field is set.
   */
  @java.lang.Override
  public boolean hasBeginCreatingTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when CreateAudienceList was called and the
   * AudienceList began the `CREATING` state.
   * </pre>
   *
   * <code>
   * optional .google.protobuf.Timestamp begin_creating_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The beginCreatingTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getBeginCreatingTime() {
    return beginCreatingTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : beginCreatingTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when CreateAudienceList was called and the
   * AudienceList began the `CREATING` state.
   * </pre>
   *
   * <code>
   * optional .google.protobuf.Timestamp begin_creating_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getBeginCreatingTimeOrBuilder() {
    return beginCreatingTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : beginCreatingTime_;
  }

  public static final int CREATION_QUOTA_TOKENS_CHARGED_FIELD_NUMBER = 7;
  private int creationQuotaTokensCharged_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The total quota tokens charged during creation of the
   * AudienceList. Because this token count is based on activity from the
   * `CREATING` state, this tokens charged will be fixed once an AudienceList
   * enters the `ACTIVE` or `FAILED` states.
   * </pre>
   *
   * <code>int32 creation_quota_tokens_charged = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The creationQuotaTokensCharged.
   */
  @java.lang.Override
  public int getCreationQuotaTokensCharged() {
    return creationQuotaTokensCharged_;
  }

  public static final int ROW_COUNT_FIELD_NUMBER = 8;
  private int rowCount_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The total number of rows in the AudienceList result.
   * </pre>
   *
   * <code>optional int32 row_count = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the rowCount field is set.
   */
  @java.lang.Override
  public boolean hasRowCount() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The total number of rows in the AudienceList result.
   * </pre>
   *
   * <code>optional int32 row_count = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The rowCount.
   */
  @java.lang.Override
  public int getRowCount() {
    return rowCount_;
  }

  public static final int ERROR_MESSAGE_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object errorMessage_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Error message is populated when an audience list fails during
   * creation. A common reason for such a failure is quota exhaustion.
   * </pre>
   *
   * <code>optional string error_message = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the errorMessage field is set.
   */
  @java.lang.Override
  public boolean hasErrorMessage() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Error message is populated when an audience list fails during
   * creation. A common reason for such a failure is quota exhaustion.
   * </pre>
   *
   * <code>optional string error_message = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The errorMessage.
   */
  @java.lang.Override
  public java.lang.String getErrorMessage() {
    java.lang.Object ref = errorMessage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      errorMessage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Error message is populated when an audience list fails during
   * creation. A common reason for such a failure is quota exhaustion.
   * </pre>
   *
   * <code>optional string error_message = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for errorMessage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getErrorMessageBytes() {
    java.lang.Object ref = errorMessage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      errorMessage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PERCENTAGE_COMPLETED_FIELD_NUMBER = 11;
  private double percentageCompleted_ = 0D;
  /**
   *
   *
   * <pre>
   * Output only. The percentage completed for this audience export ranging
   * between 0 to 100.
   * </pre>
   *
   * <code>optional double percentage_completed = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the percentageCompleted field is set.
   */
  @java.lang.Override
  public boolean hasPercentageCompleted() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The percentage completed for this audience export ranging
   * between 0 to 100.
   * </pre>
   *
   * <code>optional double percentage_completed = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The percentageCompleted.
   */
  @java.lang.Override
  public double getPercentageCompleted() {
    return percentageCompleted_;
  }

  public static final int RECURRING_AUDIENCE_LIST_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private volatile java.lang.Object recurringAudienceList_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The recurring audience list that created this audience list.
   * Recurring audience lists create audience lists daily.
   *
   * If audience lists are created directly, they will have no associated
   * recurring audience list, and this field will be blank.
   * </pre>
   *
   * <code>
   * optional string recurring_audience_list = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the recurringAudienceList field is set.
   */
  @java.lang.Override
  public boolean hasRecurringAudienceList() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The recurring audience list that created this audience list.
   * Recurring audience lists create audience lists daily.
   *
   * If audience lists are created directly, they will have no associated
   * recurring audience list, and this field will be blank.
   * </pre>
   *
   * <code>
   * optional string recurring_audience_list = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The recurringAudienceList.
   */
  @java.lang.Override
  public java.lang.String getRecurringAudienceList() {
    java.lang.Object ref = recurringAudienceList_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      recurringAudienceList_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The recurring audience list that created this audience list.
   * Recurring audience lists create audience lists daily.
   *
   * If audience lists are created directly, they will have no associated
   * recurring audience list, and this field will be blank.
   * </pre>
   *
   * <code>
   * optional string recurring_audience_list = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for recurringAudienceList.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRecurringAudienceListBytes() {
    java.lang.Object ref = recurringAudienceList_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      recurringAudienceList_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int WEBHOOK_NOTIFICATION_FIELD_NUMBER = 13;
  private com.google.analytics.data.v1alpha.WebhookNotification webhookNotification_;
  /**
   *
   *
   * <pre>
   * Optional. Configures webhook notifications to be sent from the Google
   * Analytics Data API to your webhook server. Use of webhooks is optional. If
   * unused, you'll need to poll this API to determine when an audience list is
   * ready to be used. Webhooks allow a notification to be sent to your servers
   * &amp; avoid the need for polling.
   *
   * Either one or two POST requests will be sent to the webhook. The first POST
   * request will be sent immediately showing the newly created audience list in
   * its CREATING state. The second POST request will be sent after the audience
   * list completes creation (either the ACTIVE or FAILED state).
   *
   * If identical audience lists are requested in quick succession, the second &amp;
   * subsequent audience lists can be served from cache. In that case, the
   * audience list create method can return an audience list is already ACTIVE.
   * In this scenario, only one POST request will be sent to the webhook.
   * </pre>
   *
   * <code>
   * optional .google.analytics.data.v1alpha.WebhookNotification webhook_notification = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the webhookNotification field is set.
   */
  @java.lang.Override
  public boolean hasWebhookNotification() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Configures webhook notifications to be sent from the Google
   * Analytics Data API to your webhook server. Use of webhooks is optional. If
   * unused, you'll need to poll this API to determine when an audience list is
   * ready to be used. Webhooks allow a notification to be sent to your servers
   * &amp; avoid the need for polling.
   *
   * Either one or two POST requests will be sent to the webhook. The first POST
   * request will be sent immediately showing the newly created audience list in
   * its CREATING state. The second POST request will be sent after the audience
   * list completes creation (either the ACTIVE or FAILED state).
   *
   * If identical audience lists are requested in quick succession, the second &amp;
   * subsequent audience lists can be served from cache. In that case, the
   * audience list create method can return an audience list is already ACTIVE.
   * In this scenario, only one POST request will be sent to the webhook.
   * </pre>
   *
   * <code>
   * optional .google.analytics.data.v1alpha.WebhookNotification webhook_notification = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The webhookNotification.
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.WebhookNotification getWebhookNotification() {
    return webhookNotification_ == null
        ? com.google.analytics.data.v1alpha.WebhookNotification.getDefaultInstance()
        : webhookNotification_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Configures webhook notifications to be sent from the Google
   * Analytics Data API to your webhook server. Use of webhooks is optional. If
   * unused, you'll need to poll this API to determine when an audience list is
   * ready to be used. Webhooks allow a notification to be sent to your servers
   * &amp; avoid the need for polling.
   *
   * Either one or two POST requests will be sent to the webhook. The first POST
   * request will be sent immediately showing the newly created audience list in
   * its CREATING state. The second POST request will be sent after the audience
   * list completes creation (either the ACTIVE or FAILED state).
   *
   * If identical audience lists are requested in quick succession, the second &amp;
   * subsequent audience lists can be served from cache. In that case, the
   * audience list create method can return an audience list is already ACTIVE.
   * In this scenario, only one POST request will be sent to the webhook.
   * </pre>
   *
   * <code>
   * optional .google.analytics.data.v1alpha.WebhookNotification webhook_notification = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.WebhookNotificationOrBuilder
      getWebhookNotificationOrBuilder() {
    return webhookNotification_ == null
        ? com.google.analytics.data.v1alpha.WebhookNotification.getDefaultInstance()
        : webhookNotification_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(audience_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, audience_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(audienceDisplayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, audienceDisplayName_);
    }
    for (int i = 0; i < dimensions_.size(); i++) {
      output.writeMessage(4, dimensions_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeEnum(5, state_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(6, getBeginCreatingTime());
    }
    if (creationQuotaTokensCharged_ != 0) {
      output.writeInt32(7, creationQuotaTokensCharged_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeInt32(8, rowCount_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, errorMessage_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeDouble(11, percentageCompleted_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, recurringAudienceList_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(13, getWebhookNotification());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(audience_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, audience_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(audienceDisplayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, audienceDisplayName_);
    }
    for (int i = 0; i < dimensions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, dimensions_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, state_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getBeginCreatingTime());
    }
    if (creationQuotaTokensCharged_ != 0) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(7, creationQuotaTokensCharged_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(8, rowCount_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, errorMessage_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(11, percentageCompleted_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, recurringAudienceList_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(13, getWebhookNotification());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.analytics.data.v1alpha.AudienceList)) {
      return super.equals(obj);
    }
    com.google.analytics.data.v1alpha.AudienceList other =
        (com.google.analytics.data.v1alpha.AudienceList) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getAudience().equals(other.getAudience())) return false;
    if (!getAudienceDisplayName().equals(other.getAudienceDisplayName())) return false;
    if (!getDimensionsList().equals(other.getDimensionsList())) return false;
    if (hasState() != other.hasState()) return false;
    if (hasState()) {
      if (state_ != other.state_) return false;
    }
    if (hasBeginCreatingTime() != other.hasBeginCreatingTime()) return false;
    if (hasBeginCreatingTime()) {
      if (!getBeginCreatingTime().equals(other.getBeginCreatingTime())) return false;
    }
    if (getCreationQuotaTokensCharged() != other.getCreationQuotaTokensCharged()) return false;
    if (hasRowCount() != other.hasRowCount()) return false;
    if (hasRowCount()) {
      if (getRowCount() != other.getRowCount()) return false;
    }
    if (hasErrorMessage() != other.hasErrorMessage()) return false;
    if (hasErrorMessage()) {
      if (!getErrorMessage().equals(other.getErrorMessage())) return false;
    }
    if (hasPercentageCompleted() != other.hasPercentageCompleted()) return false;
    if (hasPercentageCompleted()) {
      if (java.lang.Double.doubleToLongBits(getPercentageCompleted())
          != java.lang.Double.doubleToLongBits(other.getPercentageCompleted())) return false;
    }
    if (hasRecurringAudienceList() != other.hasRecurringAudienceList()) return false;
    if (hasRecurringAudienceList()) {
      if (!getRecurringAudienceList().equals(other.getRecurringAudienceList())) return false;
    }
    if (hasWebhookNotification() != other.hasWebhookNotification()) return false;
    if (hasWebhookNotification()) {
      if (!getWebhookNotification().equals(other.getWebhookNotification())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + AUDIENCE_FIELD_NUMBER;
    hash = (53 * hash) + getAudience().hashCode();
    hash = (37 * hash) + AUDIENCE_DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getAudienceDisplayName().hashCode();
    if (getDimensionsCount() > 0) {
      hash = (37 * hash) + DIMENSIONS_FIELD_NUMBER;
      hash = (53 * hash) + getDimensionsList().hashCode();
    }
    if (hasState()) {
      hash = (37 * hash) + STATE_FIELD_NUMBER;
      hash = (53 * hash) + state_;
    }
    if (hasBeginCreatingTime()) {
      hash = (37 * hash) + BEGIN_CREATING_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getBeginCreatingTime().hashCode();
    }
    hash = (37 * hash) + CREATION_QUOTA_TOKENS_CHARGED_FIELD_NUMBER;
    hash = (53 * hash) + getCreationQuotaTokensCharged();
    if (hasRowCount()) {
      hash = (37 * hash) + ROW_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getRowCount();
    }
    if (hasErrorMessage()) {
      hash = (37 * hash) + ERROR_MESSAGE_FIELD_NUMBER;
      hash = (53 * hash) + getErrorMessage().hashCode();
    }
    if (hasPercentageCompleted()) {
      hash = (37 * hash) + PERCENTAGE_COMPLETED_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getPercentageCompleted()));
    }
    if (hasRecurringAudienceList()) {
      hash = (37 * hash) + RECURRING_AUDIENCE_LIST_FIELD_NUMBER;
      hash = (53 * hash) + getRecurringAudienceList().hashCode();
    }
    if (hasWebhookNotification()) {
      hash = (37 * hash) + WEBHOOK_NOTIFICATION_FIELD_NUMBER;
      hash = (53 * hash) + getWebhookNotification().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.analytics.data.v1alpha.AudienceList parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1alpha.AudienceList parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.AudienceList parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1alpha.AudienceList parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.AudienceList parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1alpha.AudienceList parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.AudienceList parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1alpha.AudienceList parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.AudienceList parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1alpha.AudienceList parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.AudienceList parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1alpha.AudienceList parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.analytics.data.v1alpha.AudienceList prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * An audience list is a list of users in an audience at the time of the list's
   * creation. One audience may have multiple audience lists created for different
   * days.
   * </pre>
   *
   * Protobuf type {@code google.analytics.data.v1alpha.AudienceList}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.analytics.data.v1alpha.AudienceList)
      com.google.analytics.data.v1alpha.AudienceListOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.analytics.data.v1alpha.AnalyticsDataApiProto
          .internal_static_google_analytics_data_v1alpha_AudienceList_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.analytics.data.v1alpha.AnalyticsDataApiProto
          .internal_static_google_analytics_data_v1alpha_AudienceList_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.analytics.data.v1alpha.AudienceList.class,
              com.google.analytics.data.v1alpha.AudienceList.Builder.class);
    }

    // Construct using com.google.analytics.data.v1alpha.AudienceList.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDimensionsFieldBuilder();
        getBeginCreatingTimeFieldBuilder();
        getWebhookNotificationFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      audience_ = "";
      audienceDisplayName_ = "";
      if (dimensionsBuilder_ == null) {
        dimensions_ = java.util.Collections.emptyList();
      } else {
        dimensions_ = null;
        dimensionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      state_ = 0;
      beginCreatingTime_ = null;
      if (beginCreatingTimeBuilder_ != null) {
        beginCreatingTimeBuilder_.dispose();
        beginCreatingTimeBuilder_ = null;
      }
      creationQuotaTokensCharged_ = 0;
      rowCount_ = 0;
      errorMessage_ = "";
      percentageCompleted_ = 0D;
      recurringAudienceList_ = "";
      webhookNotification_ = null;
      if (webhookNotificationBuilder_ != null) {
        webhookNotificationBuilder_.dispose();
        webhookNotificationBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.analytics.data.v1alpha.AnalyticsDataApiProto
          .internal_static_google_analytics_data_v1alpha_AudienceList_descriptor;
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.AudienceList getDefaultInstanceForType() {
      return com.google.analytics.data.v1alpha.AudienceList.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.AudienceList build() {
      com.google.analytics.data.v1alpha.AudienceList result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.AudienceList buildPartial() {
      com.google.analytics.data.v1alpha.AudienceList result =
          new com.google.analytics.data.v1alpha.AudienceList(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.analytics.data.v1alpha.AudienceList result) {
      if (dimensionsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          dimensions_ = java.util.Collections.unmodifiableList(dimensions_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.dimensions_ = dimensions_;
      } else {
        result.dimensions_ = dimensionsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.analytics.data.v1alpha.AudienceList result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.audience_ = audience_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.audienceDisplayName_ = audienceDisplayName_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.state_ = state_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.beginCreatingTime_ =
            beginCreatingTimeBuilder_ == null
                ? beginCreatingTime_
                : beginCreatingTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.creationQuotaTokensCharged_ = creationQuotaTokensCharged_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.rowCount_ = rowCount_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.errorMessage_ = errorMessage_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.percentageCompleted_ = percentageCompleted_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.recurringAudienceList_ = recurringAudienceList_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.webhookNotification_ =
            webhookNotificationBuilder_ == null
                ? webhookNotification_
                : webhookNotificationBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.analytics.data.v1alpha.AudienceList) {
        return mergeFrom((com.google.analytics.data.v1alpha.AudienceList) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.analytics.data.v1alpha.AudienceList other) {
      if (other == com.google.analytics.data.v1alpha.AudienceList.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getAudience().isEmpty()) {
        audience_ = other.audience_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getAudienceDisplayName().isEmpty()) {
        audienceDisplayName_ = other.audienceDisplayName_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (dimensionsBuilder_ == null) {
        if (!other.dimensions_.isEmpty()) {
          if (dimensions_.isEmpty()) {
            dimensions_ = other.dimensions_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureDimensionsIsMutable();
            dimensions_.addAll(other.dimensions_);
          }
          onChanged();
        }
      } else {
        if (!other.dimensions_.isEmpty()) {
          if (dimensionsBuilder_.isEmpty()) {
            dimensionsBuilder_.dispose();
            dimensionsBuilder_ = null;
            dimensions_ = other.dimensions_;
            bitField0_ = (bitField0_ & ~0x00000008);
            dimensionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDimensionsFieldBuilder()
                    : null;
          } else {
            dimensionsBuilder_.addAllMessages(other.dimensions_);
          }
        }
      }
      if (other.hasState()) {
        setState(other.getState());
      }
      if (other.hasBeginCreatingTime()) {
        mergeBeginCreatingTime(other.getBeginCreatingTime());
      }
      if (other.getCreationQuotaTokensCharged() != 0) {
        setCreationQuotaTokensCharged(other.getCreationQuotaTokensCharged());
      }
      if (other.hasRowCount()) {
        setRowCount(other.getRowCount());
      }
      if (other.hasErrorMessage()) {
        errorMessage_ = other.errorMessage_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.hasPercentageCompleted()) {
        setPercentageCompleted(other.getPercentageCompleted());
      }
      if (other.hasRecurringAudienceList()) {
        recurringAudienceList_ = other.recurringAudienceList_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (other.hasWebhookNotification()) {
        mergeWebhookNotification(other.getWebhookNotification());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                audience_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                audienceDisplayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.analytics.data.v1alpha.AudienceDimension m =
                    input.readMessage(
                        com.google.analytics.data.v1alpha.AudienceDimension.parser(),
                        extensionRegistry);
                if (dimensionsBuilder_ == null) {
                  ensureDimensionsIsMutable();
                  dimensions_.add(m);
                } else {
                  dimensionsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 40:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 50:
              {
                input.readMessage(
                    getBeginCreatingTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 56:
              {
                creationQuotaTokensCharged_ = input.readInt32();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            case 64:
              {
                rowCount_ = input.readInt32();
                bitField0_ |= 0x00000080;
                break;
              } // case 64
            case 74:
              {
                errorMessage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 89:
              {
                percentageCompleted_ = input.readDouble();
                bitField0_ |= 0x00000200;
                break;
              } // case 89
            case 98:
              {
                recurringAudienceList_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(
                    getWebhookNotificationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 106
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Identifier. The audience list resource name assigned during
     * creation. This resource name identifies this `AudienceList`.
     *
     * Format: `properties/{property}/audienceLists/{audience_list}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Identifier. The audience list resource name assigned during
     * creation. This resource name identifies this `AudienceList`.
     *
     * Format: `properties/{property}/audienceLists/{audience_list}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Identifier. The audience list resource name assigned during
     * creation. This resource name identifies this `AudienceList`.
     *
     * Format: `properties/{property}/audienceLists/{audience_list}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Identifier. The audience list resource name assigned during
     * creation. This resource name identifies this `AudienceList`.
     *
     * Format: `properties/{property}/audienceLists/{audience_list}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Identifier. The audience list resource name assigned during
     * creation. This resource name identifies this `AudienceList`.
     *
     * Format: `properties/{property}/audienceLists/{audience_list}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object audience_ = "";
    /**
     *
     *
     * <pre>
     * Required. The audience resource name. This resource name identifies the
     * audience being listed and is shared between the Analytics Data &amp; Admin
     * APIs.
     *
     * Format: `properties/{property}/audiences/{audience}`
     * </pre>
     *
     * <code>string audience = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The audience.
     */
    public java.lang.String getAudience() {
      java.lang.Object ref = audience_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        audience_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The audience resource name. This resource name identifies the
     * audience being listed and is shared between the Analytics Data &amp; Admin
     * APIs.
     *
     * Format: `properties/{property}/audiences/{audience}`
     * </pre>
     *
     * <code>string audience = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for audience.
     */
    public com.google.protobuf.ByteString getAudienceBytes() {
      java.lang.Object ref = audience_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        audience_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The audience resource name. This resource name identifies the
     * audience being listed and is shared between the Analytics Data &amp; Admin
     * APIs.
     *
     * Format: `properties/{property}/audiences/{audience}`
     * </pre>
     *
     * <code>string audience = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The audience to set.
     * @return This builder for chaining.
     */
    public Builder setAudience(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      audience_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The audience resource name. This resource name identifies the
     * audience being listed and is shared between the Analytics Data &amp; Admin
     * APIs.
     *
     * Format: `properties/{property}/audiences/{audience}`
     * </pre>
     *
     * <code>string audience = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAudience() {
      audience_ = getDefaultInstance().getAudience();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The audience resource name. This resource name identifies the
     * audience being listed and is shared between the Analytics Data &amp; Admin
     * APIs.
     *
     * Format: `properties/{property}/audiences/{audience}`
     * </pre>
     *
     * <code>string audience = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for audience to set.
     * @return This builder for chaining.
     */
    public Builder setAudienceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      audience_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object audienceDisplayName_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The descriptive display name for this audience. For example,
     * "Purchasers".
     * </pre>
     *
     * <code>string audience_display_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The audienceDisplayName.
     */
    public java.lang.String getAudienceDisplayName() {
      java.lang.Object ref = audienceDisplayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        audienceDisplayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The descriptive display name for this audience. For example,
     * "Purchasers".
     * </pre>
     *
     * <code>string audience_display_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for audienceDisplayName.
     */
    public com.google.protobuf.ByteString getAudienceDisplayNameBytes() {
      java.lang.Object ref = audienceDisplayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        audienceDisplayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The descriptive display name for this audience. For example,
     * "Purchasers".
     * </pre>
     *
     * <code>string audience_display_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The audienceDisplayName to set.
     * @return This builder for chaining.
     */
    public Builder setAudienceDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      audienceDisplayName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The descriptive display name for this audience. For example,
     * "Purchasers".
     * </pre>
     *
     * <code>string audience_display_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAudienceDisplayName() {
      audienceDisplayName_ = getDefaultInstance().getAudienceDisplayName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The descriptive display name for this audience. For example,
     * "Purchasers".
     * </pre>
     *
     * <code>string audience_display_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for audienceDisplayName to set.
     * @return This builder for chaining.
     */
    public Builder setAudienceDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      audienceDisplayName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.util.List<com.google.analytics.data.v1alpha.AudienceDimension> dimensions_ =
        java.util.Collections.emptyList();

    private void ensureDimensionsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        dimensions_ =
            new java.util.ArrayList<com.google.analytics.data.v1alpha.AudienceDimension>(
                dimensions_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.analytics.data.v1alpha.AudienceDimension,
            com.google.analytics.data.v1alpha.AudienceDimension.Builder,
            com.google.analytics.data.v1alpha.AudienceDimensionOrBuilder>
        dimensionsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The dimensions requested and displayed in the query response.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.analytics.data.v1alpha.AudienceDimension> getDimensionsList() {
      if (dimensionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(dimensions_);
      } else {
        return dimensionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The dimensions requested and displayed in the query response.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getDimensionsCount() {
      if (dimensionsBuilder_ == null) {
        return dimensions_.size();
      } else {
        return dimensionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The dimensions requested and displayed in the query response.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.analytics.data.v1alpha.AudienceDimension getDimensions(int index) {
      if (dimensionsBuilder_ == null) {
        return dimensions_.get(index);
      } else {
        return dimensionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The dimensions requested and displayed in the query response.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDimensions(
        int index, com.google.analytics.data.v1alpha.AudienceDimension value) {
      if (dimensionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDimensionsIsMutable();
        dimensions_.set(index, value);
        onChanged();
      } else {
        dimensionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The dimensions requested and displayed in the query response.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDimensions(
        int index, com.google.analytics.data.v1alpha.AudienceDimension.Builder builderForValue) {
      if (dimensionsBuilder_ == null) {
        ensureDimensionsIsMutable();
        dimensions_.set(index, builderForValue.build());
        onChanged();
      } else {
        dimensionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The dimensions requested and displayed in the query response.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addDimensions(com.google.analytics.data.v1alpha.AudienceDimension value) {
      if (dimensionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDimensionsIsMutable();
        dimensions_.add(value);
        onChanged();
      } else {
        dimensionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The dimensions requested and displayed in the query response.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addDimensions(
        int index, com.google.analytics.data.v1alpha.AudienceDimension value) {
      if (dimensionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDimensionsIsMutable();
        dimensions_.add(index, value);
        onChanged();
      } else {
        dimensionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The dimensions requested and displayed in the query response.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addDimensions(
        com.google.analytics.data.v1alpha.AudienceDimension.Builder builderForValue) {
      if (dimensionsBuilder_ == null) {
        ensureDimensionsIsMutable();
        dimensions_.add(builderForValue.build());
        onChanged();
      } else {
        dimensionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The dimensions requested and displayed in the query response.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addDimensions(
        int index, com.google.analytics.data.v1alpha.AudienceDimension.Builder builderForValue) {
      if (dimensionsBuilder_ == null) {
        ensureDimensionsIsMutable();
        dimensions_.add(index, builderForValue.build());
        onChanged();
      } else {
        dimensionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The dimensions requested and displayed in the query response.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllDimensions(
        java.lang.Iterable<? extends com.google.analytics.data.v1alpha.AudienceDimension> values) {
      if (dimensionsBuilder_ == null) {
        ensureDimensionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dimensions_);
        onChanged();
      } else {
        dimensionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The dimensions requested and displayed in the query response.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearDimensions() {
      if (dimensionsBuilder_ == null) {
        dimensions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        dimensionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The dimensions requested and displayed in the query response.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeDimensions(int index) {
      if (dimensionsBuilder_ == null) {
        ensureDimensionsIsMutable();
        dimensions_.remove(index);
        onChanged();
      } else {
        dimensionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The dimensions requested and displayed in the query response.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.analytics.data.v1alpha.AudienceDimension.Builder getDimensionsBuilder(
        int index) {
      return getDimensionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The dimensions requested and displayed in the query response.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.analytics.data.v1alpha.AudienceDimensionOrBuilder getDimensionsOrBuilder(
        int index) {
      if (dimensionsBuilder_ == null) {
        return dimensions_.get(index);
      } else {
        return dimensionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The dimensions requested and displayed in the query response.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<? extends com.google.analytics.data.v1alpha.AudienceDimensionOrBuilder>
        getDimensionsOrBuilderList() {
      if (dimensionsBuilder_ != null) {
        return dimensionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(dimensions_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The dimensions requested and displayed in the query response.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.analytics.data.v1alpha.AudienceDimension.Builder addDimensionsBuilder() {
      return getDimensionsFieldBuilder()
          .addBuilder(com.google.analytics.data.v1alpha.AudienceDimension.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The dimensions requested and displayed in the query response.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.analytics.data.v1alpha.AudienceDimension.Builder addDimensionsBuilder(
        int index) {
      return getDimensionsFieldBuilder()
          .addBuilder(
              index, com.google.analytics.data.v1alpha.AudienceDimension.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The dimensions requested and displayed in the query response.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.analytics.data.v1alpha.AudienceDimension.Builder>
        getDimensionsBuilderList() {
      return getDimensionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.analytics.data.v1alpha.AudienceDimension,
            com.google.analytics.data.v1alpha.AudienceDimension.Builder,
            com.google.analytics.data.v1alpha.AudienceDimensionOrBuilder>
        getDimensionsFieldBuilder() {
      if (dimensionsBuilder_ == null) {
        dimensionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.analytics.data.v1alpha.AudienceDimension,
                com.google.analytics.data.v1alpha.AudienceDimension.Builder,
                com.google.analytics.data.v1alpha.AudienceDimensionOrBuilder>(
                dimensions_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        dimensions_ = null;
      }
      return dimensionsBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The current state for this AudienceList.
     * </pre>
     *
     * <code>
     * optional .google.analytics.data.v1alpha.AudienceList.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the state field is set.
     */
    @java.lang.Override
    public boolean hasState() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state for this AudienceList.
     * </pre>
     *
     * <code>
     * optional .google.analytics.data.v1alpha.AudienceList.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state for this AudienceList.
     * </pre>
     *
     * <code>
     * optional .google.analytics.data.v1alpha.AudienceList.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state for this AudienceList.
     * </pre>
     *
     * <code>
     * optional .google.analytics.data.v1alpha.AudienceList.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.analytics.data.v1alpha.AudienceList.State getState() {
      com.google.analytics.data.v1alpha.AudienceList.State result =
          com.google.analytics.data.v1alpha.AudienceList.State.forNumber(state_);
      return result == null
          ? com.google.analytics.data.v1alpha.AudienceList.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state for this AudienceList.
     * </pre>
     *
     * <code>
     * optional .google.analytics.data.v1alpha.AudienceList.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.analytics.data.v1alpha.AudienceList.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state for this AudienceList.
     * </pre>
     *
     * <code>
     * optional .google.analytics.data.v1alpha.AudienceList.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000010);
      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp beginCreatingTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        beginCreatingTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time when CreateAudienceList was called and the
     * AudienceList began the `CREATING` state.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp begin_creating_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the beginCreatingTime field is set.
     */
    public boolean hasBeginCreatingTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when CreateAudienceList was called and the
     * AudienceList began the `CREATING` state.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp begin_creating_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The beginCreatingTime.
     */
    public com.google.protobuf.Timestamp getBeginCreatingTime() {
      if (beginCreatingTimeBuilder_ == null) {
        return beginCreatingTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : beginCreatingTime_;
      } else {
        return beginCreatingTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when CreateAudienceList was called and the
     * AudienceList began the `CREATING` state.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp begin_creating_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setBeginCreatingTime(com.google.protobuf.Timestamp value) {
      if (beginCreatingTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        beginCreatingTime_ = value;
      } else {
        beginCreatingTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when CreateAudienceList was called and the
     * AudienceList began the `CREATING` state.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp begin_creating_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setBeginCreatingTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (beginCreatingTimeBuilder_ == null) {
        beginCreatingTime_ = builderForValue.build();
      } else {
        beginCreatingTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when CreateAudienceList was called and the
     * AudienceList began the `CREATING` state.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp begin_creating_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeBeginCreatingTime(com.google.protobuf.Timestamp value) {
      if (beginCreatingTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && beginCreatingTime_ != null
            && beginCreatingTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getBeginCreatingTimeBuilder().mergeFrom(value);
        } else {
          beginCreatingTime_ = value;
        }
      } else {
        beginCreatingTimeBuilder_.mergeFrom(value);
      }
      if (beginCreatingTime_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when CreateAudienceList was called and the
     * AudienceList began the `CREATING` state.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp begin_creating_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearBeginCreatingTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      beginCreatingTime_ = null;
      if (beginCreatingTimeBuilder_ != null) {
        beginCreatingTimeBuilder_.dispose();
        beginCreatingTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when CreateAudienceList was called and the
     * AudienceList began the `CREATING` state.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp begin_creating_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getBeginCreatingTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getBeginCreatingTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when CreateAudienceList was called and the
     * AudienceList began the `CREATING` state.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp begin_creating_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getBeginCreatingTimeOrBuilder() {
      if (beginCreatingTimeBuilder_ != null) {
        return beginCreatingTimeBuilder_.getMessageOrBuilder();
      } else {
        return beginCreatingTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : beginCreatingTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when CreateAudienceList was called and the
     * AudienceList began the `CREATING` state.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp begin_creating_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getBeginCreatingTimeFieldBuilder() {
      if (beginCreatingTimeBuilder_ == null) {
        beginCreatingTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getBeginCreatingTime(), getParentForChildren(), isClean());
        beginCreatingTime_ = null;
      }
      return beginCreatingTimeBuilder_;
    }

    private int creationQuotaTokensCharged_;
    /**
     *
     *
     * <pre>
     * Output only. The total quota tokens charged during creation of the
     * AudienceList. Because this token count is based on activity from the
     * `CREATING` state, this tokens charged will be fixed once an AudienceList
     * enters the `ACTIVE` or `FAILED` states.
     * </pre>
     *
     * <code>int32 creation_quota_tokens_charged = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The creationQuotaTokensCharged.
     */
    @java.lang.Override
    public int getCreationQuotaTokensCharged() {
      return creationQuotaTokensCharged_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The total quota tokens charged during creation of the
     * AudienceList. Because this token count is based on activity from the
     * `CREATING` state, this tokens charged will be fixed once an AudienceList
     * enters the `ACTIVE` or `FAILED` states.
     * </pre>
     *
     * <code>int32 creation_quota_tokens_charged = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The creationQuotaTokensCharged to set.
     * @return This builder for chaining.
     */
    public Builder setCreationQuotaTokensCharged(int value) {

      creationQuotaTokensCharged_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The total quota tokens charged during creation of the
     * AudienceList. Because this token count is based on activity from the
     * `CREATING` state, this tokens charged will be fixed once an AudienceList
     * enters the `ACTIVE` or `FAILED` states.
     * </pre>
     *
     * <code>int32 creation_quota_tokens_charged = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreationQuotaTokensCharged() {
      bitField0_ = (bitField0_ & ~0x00000040);
      creationQuotaTokensCharged_ = 0;
      onChanged();
      return this;
    }

    private int rowCount_;
    /**
     *
     *
     * <pre>
     * Output only. The total number of rows in the AudienceList result.
     * </pre>
     *
     * <code>optional int32 row_count = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the rowCount field is set.
     */
    @java.lang.Override
    public boolean hasRowCount() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The total number of rows in the AudienceList result.
     * </pre>
     *
     * <code>optional int32 row_count = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The rowCount.
     */
    @java.lang.Override
    public int getRowCount() {
      return rowCount_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The total number of rows in the AudienceList result.
     * </pre>
     *
     * <code>optional int32 row_count = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The rowCount to set.
     * @return This builder for chaining.
     */
    public Builder setRowCount(int value) {

      rowCount_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The total number of rows in the AudienceList result.
     * </pre>
     *
     * <code>optional int32 row_count = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRowCount() {
      bitField0_ = (bitField0_ & ~0x00000080);
      rowCount_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object errorMessage_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Error message is populated when an audience list fails during
     * creation. A common reason for such a failure is quota exhaustion.
     * </pre>
     *
     * <code>optional string error_message = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the errorMessage field is set.
     */
    public boolean hasErrorMessage() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Error message is populated when an audience list fails during
     * creation. A common reason for such a failure is quota exhaustion.
     * </pre>
     *
     * <code>optional string error_message = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The errorMessage.
     */
    public java.lang.String getErrorMessage() {
      java.lang.Object ref = errorMessage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        errorMessage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Error message is populated when an audience list fails during
     * creation. A common reason for such a failure is quota exhaustion.
     * </pre>
     *
     * <code>optional string error_message = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for errorMessage.
     */
    public com.google.protobuf.ByteString getErrorMessageBytes() {
      java.lang.Object ref = errorMessage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        errorMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Error message is populated when an audience list fails during
     * creation. A common reason for such a failure is quota exhaustion.
     * </pre>
     *
     * <code>optional string error_message = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The errorMessage to set.
     * @return This builder for chaining.
     */
    public Builder setErrorMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      errorMessage_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Error message is populated when an audience list fails during
     * creation. A common reason for such a failure is quota exhaustion.
     * </pre>
     *
     * <code>optional string error_message = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearErrorMessage() {
      errorMessage_ = getDefaultInstance().getErrorMessage();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Error message is populated when an audience list fails during
     * creation. A common reason for such a failure is quota exhaustion.
     * </pre>
     *
     * <code>optional string error_message = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for errorMessage to set.
     * @return This builder for chaining.
     */
    public Builder setErrorMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      errorMessage_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private double percentageCompleted_;
    /**
     *
     *
     * <pre>
     * Output only. The percentage completed for this audience export ranging
     * between 0 to 100.
     * </pre>
     *
     * <code>optional double percentage_completed = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the percentageCompleted field is set.
     */
    @java.lang.Override
    public boolean hasPercentageCompleted() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The percentage completed for this audience export ranging
     * between 0 to 100.
     * </pre>
     *
     * <code>optional double percentage_completed = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The percentageCompleted.
     */
    @java.lang.Override
    public double getPercentageCompleted() {
      return percentageCompleted_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The percentage completed for this audience export ranging
     * between 0 to 100.
     * </pre>
     *
     * <code>optional double percentage_completed = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The percentageCompleted to set.
     * @return This builder for chaining.
     */
    public Builder setPercentageCompleted(double value) {

      percentageCompleted_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The percentage completed for this audience export ranging
     * between 0 to 100.
     * </pre>
     *
     * <code>optional double percentage_completed = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPercentageCompleted() {
      bitField0_ = (bitField0_ & ~0x00000200);
      percentageCompleted_ = 0D;
      onChanged();
      return this;
    }

    private java.lang.Object recurringAudienceList_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The recurring audience list that created this audience list.
     * Recurring audience lists create audience lists daily.
     *
     * If audience lists are created directly, they will have no associated
     * recurring audience list, and this field will be blank.
     * </pre>
     *
     * <code>
     * optional string recurring_audience_list = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the recurringAudienceList field is set.
     */
    public boolean hasRecurringAudienceList() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The recurring audience list that created this audience list.
     * Recurring audience lists create audience lists daily.
     *
     * If audience lists are created directly, they will have no associated
     * recurring audience list, and this field will be blank.
     * </pre>
     *
     * <code>
     * optional string recurring_audience_list = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The recurringAudienceList.
     */
    public java.lang.String getRecurringAudienceList() {
      java.lang.Object ref = recurringAudienceList_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        recurringAudienceList_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The recurring audience list that created this audience list.
     * Recurring audience lists create audience lists daily.
     *
     * If audience lists are created directly, they will have no associated
     * recurring audience list, and this field will be blank.
     * </pre>
     *
     * <code>
     * optional string recurring_audience_list = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for recurringAudienceList.
     */
    public com.google.protobuf.ByteString getRecurringAudienceListBytes() {
      java.lang.Object ref = recurringAudienceList_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        recurringAudienceList_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The recurring audience list that created this audience list.
     * Recurring audience lists create audience lists daily.
     *
     * If audience lists are created directly, they will have no associated
     * recurring audience list, and this field will be blank.
     * </pre>
     *
     * <code>
     * optional string recurring_audience_list = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The recurringAudienceList to set.
     * @return This builder for chaining.
     */
    public Builder setRecurringAudienceList(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      recurringAudienceList_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The recurring audience list that created this audience list.
     * Recurring audience lists create audience lists daily.
     *
     * If audience lists are created directly, they will have no associated
     * recurring audience list, and this field will be blank.
     * </pre>
     *
     * <code>
     * optional string recurring_audience_list = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRecurringAudienceList() {
      recurringAudienceList_ = getDefaultInstance().getRecurringAudienceList();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The recurring audience list that created this audience list.
     * Recurring audience lists create audience lists daily.
     *
     * If audience lists are created directly, they will have no associated
     * recurring audience list, and this field will be blank.
     * </pre>
     *
     * <code>
     * optional string recurring_audience_list = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for recurringAudienceList to set.
     * @return This builder for chaining.
     */
    public Builder setRecurringAudienceListBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      recurringAudienceList_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private com.google.analytics.data.v1alpha.WebhookNotification webhookNotification_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.WebhookNotification,
            com.google.analytics.data.v1alpha.WebhookNotification.Builder,
            com.google.analytics.data.v1alpha.WebhookNotificationOrBuilder>
        webhookNotificationBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Configures webhook notifications to be sent from the Google
     * Analytics Data API to your webhook server. Use of webhooks is optional. If
     * unused, you'll need to poll this API to determine when an audience list is
     * ready to be used. Webhooks allow a notification to be sent to your servers
     * &amp; avoid the need for polling.
     *
     * Either one or two POST requests will be sent to the webhook. The first POST
     * request will be sent immediately showing the newly created audience list in
     * its CREATING state. The second POST request will be sent after the audience
     * list completes creation (either the ACTIVE or FAILED state).
     *
     * If identical audience lists are requested in quick succession, the second &amp;
     * subsequent audience lists can be served from cache. In that case, the
     * audience list create method can return an audience list is already ACTIVE.
     * In this scenario, only one POST request will be sent to the webhook.
     * </pre>
     *
     * <code>
     * optional .google.analytics.data.v1alpha.WebhookNotification webhook_notification = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the webhookNotification field is set.
     */
    public boolean hasWebhookNotification() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Configures webhook notifications to be sent from the Google
     * Analytics Data API to your webhook server. Use of webhooks is optional. If
     * unused, you'll need to poll this API to determine when an audience list is
     * ready to be used. Webhooks allow a notification to be sent to your servers
     * &amp; avoid the need for polling.
     *
     * Either one or two POST requests will be sent to the webhook. The first POST
     * request will be sent immediately showing the newly created audience list in
     * its CREATING state. The second POST request will be sent after the audience
     * list completes creation (either the ACTIVE or FAILED state).
     *
     * If identical audience lists are requested in quick succession, the second &amp;
     * subsequent audience lists can be served from cache. In that case, the
     * audience list create method can return an audience list is already ACTIVE.
     * In this scenario, only one POST request will be sent to the webhook.
     * </pre>
     *
     * <code>
     * optional .google.analytics.data.v1alpha.WebhookNotification webhook_notification = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The webhookNotification.
     */
    public com.google.analytics.data.v1alpha.WebhookNotification getWebhookNotification() {
      if (webhookNotificationBuilder_ == null) {
        return webhookNotification_ == null
            ? com.google.analytics.data.v1alpha.WebhookNotification.getDefaultInstance()
            : webhookNotification_;
      } else {
        return webhookNotificationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Configures webhook notifications to be sent from the Google
     * Analytics Data API to your webhook server. Use of webhooks is optional. If
     * unused, you'll need to poll this API to determine when an audience list is
     * ready to be used. Webhooks allow a notification to be sent to your servers
     * &amp; avoid the need for polling.
     *
     * Either one or two POST requests will be sent to the webhook. The first POST
     * request will be sent immediately showing the newly created audience list in
     * its CREATING state. The second POST request will be sent after the audience
     * list completes creation (either the ACTIVE or FAILED state).
     *
     * If identical audience lists are requested in quick succession, the second &amp;
     * subsequent audience lists can be served from cache. In that case, the
     * audience list create method can return an audience list is already ACTIVE.
     * In this scenario, only one POST request will be sent to the webhook.
     * </pre>
     *
     * <code>
     * optional .google.analytics.data.v1alpha.WebhookNotification webhook_notification = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setWebhookNotification(
        com.google.analytics.data.v1alpha.WebhookNotification value) {
      if (webhookNotificationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        webhookNotification_ = value;
      } else {
        webhookNotificationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configures webhook notifications to be sent from the Google
     * Analytics Data API to your webhook server. Use of webhooks is optional. If
     * unused, you'll need to poll this API to determine when an audience list is
     * ready to be used. Webhooks allow a notification to be sent to your servers
     * &amp; avoid the need for polling.
     *
     * Either one or two POST requests will be sent to the webhook. The first POST
     * request will be sent immediately showing the newly created audience list in
     * its CREATING state. The second POST request will be sent after the audience
     * list completes creation (either the ACTIVE or FAILED state).
     *
     * If identical audience lists are requested in quick succession, the second &amp;
     * subsequent audience lists can be served from cache. In that case, the
     * audience list create method can return an audience list is already ACTIVE.
     * In this scenario, only one POST request will be sent to the webhook.
     * </pre>
     *
     * <code>
     * optional .google.analytics.data.v1alpha.WebhookNotification webhook_notification = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setWebhookNotification(
        com.google.analytics.data.v1alpha.WebhookNotification.Builder builderForValue) {
      if (webhookNotificationBuilder_ == null) {
        webhookNotification_ = builderForValue.build();
      } else {
        webhookNotificationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configures webhook notifications to be sent from the Google
     * Analytics Data API to your webhook server. Use of webhooks is optional. If
     * unused, you'll need to poll this API to determine when an audience list is
     * ready to be used. Webhooks allow a notification to be sent to your servers
     * &amp; avoid the need for polling.
     *
     * Either one or two POST requests will be sent to the webhook. The first POST
     * request will be sent immediately showing the newly created audience list in
     * its CREATING state. The second POST request will be sent after the audience
     * list completes creation (either the ACTIVE or FAILED state).
     *
     * If identical audience lists are requested in quick succession, the second &amp;
     * subsequent audience lists can be served from cache. In that case, the
     * audience list create method can return an audience list is already ACTIVE.
     * In this scenario, only one POST request will be sent to the webhook.
     * </pre>
     *
     * <code>
     * optional .google.analytics.data.v1alpha.WebhookNotification webhook_notification = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeWebhookNotification(
        com.google.analytics.data.v1alpha.WebhookNotification value) {
      if (webhookNotificationBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && webhookNotification_ != null
            && webhookNotification_
                != com.google.analytics.data.v1alpha.WebhookNotification.getDefaultInstance()) {
          getWebhookNotificationBuilder().mergeFrom(value);
        } else {
          webhookNotification_ = value;
        }
      } else {
        webhookNotificationBuilder_.mergeFrom(value);
      }
      if (webhookNotification_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configures webhook notifications to be sent from the Google
     * Analytics Data API to your webhook server. Use of webhooks is optional. If
     * unused, you'll need to poll this API to determine when an audience list is
     * ready to be used. Webhooks allow a notification to be sent to your servers
     * &amp; avoid the need for polling.
     *
     * Either one or two POST requests will be sent to the webhook. The first POST
     * request will be sent immediately showing the newly created audience list in
     * its CREATING state. The second POST request will be sent after the audience
     * list completes creation (either the ACTIVE or FAILED state).
     *
     * If identical audience lists are requested in quick succession, the second &amp;
     * subsequent audience lists can be served from cache. In that case, the
     * audience list create method can return an audience list is already ACTIVE.
     * In this scenario, only one POST request will be sent to the webhook.
     * </pre>
     *
     * <code>
     * optional .google.analytics.data.v1alpha.WebhookNotification webhook_notification = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearWebhookNotification() {
      bitField0_ = (bitField0_ & ~0x00000800);
      webhookNotification_ = null;
      if (webhookNotificationBuilder_ != null) {
        webhookNotificationBuilder_.dispose();
        webhookNotificationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configures webhook notifications to be sent from the Google
     * Analytics Data API to your webhook server. Use of webhooks is optional. If
     * unused, you'll need to poll this API to determine when an audience list is
     * ready to be used. Webhooks allow a notification to be sent to your servers
     * &amp; avoid the need for polling.
     *
     * Either one or two POST requests will be sent to the webhook. The first POST
     * request will be sent immediately showing the newly created audience list in
     * its CREATING state. The second POST request will be sent after the audience
     * list completes creation (either the ACTIVE or FAILED state).
     *
     * If identical audience lists are requested in quick succession, the second &amp;
     * subsequent audience lists can be served from cache. In that case, the
     * audience list create method can return an audience list is already ACTIVE.
     * In this scenario, only one POST request will be sent to the webhook.
     * </pre>
     *
     * <code>
     * optional .google.analytics.data.v1alpha.WebhookNotification webhook_notification = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.analytics.data.v1alpha.WebhookNotification.Builder
        getWebhookNotificationBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getWebhookNotificationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Configures webhook notifications to be sent from the Google
     * Analytics Data API to your webhook server. Use of webhooks is optional. If
     * unused, you'll need to poll this API to determine when an audience list is
     * ready to be used. Webhooks allow a notification to be sent to your servers
     * &amp; avoid the need for polling.
     *
     * Either one or two POST requests will be sent to the webhook. The first POST
     * request will be sent immediately showing the newly created audience list in
     * its CREATING state. The second POST request will be sent after the audience
     * list completes creation (either the ACTIVE or FAILED state).
     *
     * If identical audience lists are requested in quick succession, the second &amp;
     * subsequent audience lists can be served from cache. In that case, the
     * audience list create method can return an audience list is already ACTIVE.
     * In this scenario, only one POST request will be sent to the webhook.
     * </pre>
     *
     * <code>
     * optional .google.analytics.data.v1alpha.WebhookNotification webhook_notification = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.analytics.data.v1alpha.WebhookNotificationOrBuilder
        getWebhookNotificationOrBuilder() {
      if (webhookNotificationBuilder_ != null) {
        return webhookNotificationBuilder_.getMessageOrBuilder();
      } else {
        return webhookNotification_ == null
            ? com.google.analytics.data.v1alpha.WebhookNotification.getDefaultInstance()
            : webhookNotification_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Configures webhook notifications to be sent from the Google
     * Analytics Data API to your webhook server. Use of webhooks is optional. If
     * unused, you'll need to poll this API to determine when an audience list is
     * ready to be used. Webhooks allow a notification to be sent to your servers
     * &amp; avoid the need for polling.
     *
     * Either one or two POST requests will be sent to the webhook. The first POST
     * request will be sent immediately showing the newly created audience list in
     * its CREATING state. The second POST request will be sent after the audience
     * list completes creation (either the ACTIVE or FAILED state).
     *
     * If identical audience lists are requested in quick succession, the second &amp;
     * subsequent audience lists can be served from cache. In that case, the
     * audience list create method can return an audience list is already ACTIVE.
     * In this scenario, only one POST request will be sent to the webhook.
     * </pre>
     *
     * <code>
     * optional .google.analytics.data.v1alpha.WebhookNotification webhook_notification = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.WebhookNotification,
            com.google.analytics.data.v1alpha.WebhookNotification.Builder,
            com.google.analytics.data.v1alpha.WebhookNotificationOrBuilder>
        getWebhookNotificationFieldBuilder() {
      if (webhookNotificationBuilder_ == null) {
        webhookNotificationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.analytics.data.v1alpha.WebhookNotification,
                com.google.analytics.data.v1alpha.WebhookNotification.Builder,
                com.google.analytics.data.v1alpha.WebhookNotificationOrBuilder>(
                getWebhookNotification(), getParentForChildren(), isClean());
        webhookNotification_ = null;
      }
      return webhookNotificationBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.analytics.data.v1alpha.AudienceList)
  }

  // @@protoc_insertion_point(class_scope:google.analytics.data.v1alpha.AudienceList)
  private static final com.google.analytics.data.v1alpha.AudienceList DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.analytics.data.v1alpha.AudienceList();
  }

  public static com.google.analytics.data.v1alpha.AudienceList getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AudienceList> PARSER =
      new com.google.protobuf.AbstractParser<AudienceList>() {
        @java.lang.Override
        public AudienceList parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AudienceList> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AudienceList> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.analytics.data.v1alpha.AudienceList getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
