/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/analytics/data/v1alpha/data.proto

// Protobuf Java Version: 3.25.3
package com.google.analytics.data.v1alpha;

public interface ResponseMetaDataOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.analytics.data.v1alpha.ResponseMetaData)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * If true, indicates some buckets of dimension combinations are rolled into
   * "(other)" row. This can happen for high cardinality reports.
   *
   * The metadata parameter dataLossFromOtherRow is populated based on the
   * aggregated data table used in the report. The parameter will be accurately
   * populated regardless of the filters and limits in the report.
   *
   * For example, the (other) row could be dropped from the report because the
   * request contains a filter on sessionSource = google. This parameter will
   * still be populated if data loss from other row was present in the input
   * aggregate data used to generate this report.
   *
   * To learn more, see [About the (other) row and data
   * sampling](https://support.google.com/analytics/answer/13208658#reports).
   * </pre>
   *
   * <code>bool data_loss_from_other_row = 3;</code>
   *
   * @return The dataLossFromOtherRow.
   */
  boolean getDataLossFromOtherRow();

  /**
   *
   *
   * <pre>
   * Describes the schema restrictions actively enforced in creating this
   * report. To learn more, see [Access and data-restriction
   * management](https://support.google.com/analytics/answer/10851388).
   * </pre>
   *
   * <code>
   * optional .google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse schema_restriction_response = 4;
   * </code>
   *
   * @return Whether the schemaRestrictionResponse field is set.
   */
  boolean hasSchemaRestrictionResponse();
  /**
   *
   *
   * <pre>
   * Describes the schema restrictions actively enforced in creating this
   * report. To learn more, see [Access and data-restriction
   * management](https://support.google.com/analytics/answer/10851388).
   * </pre>
   *
   * <code>
   * optional .google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse schema_restriction_response = 4;
   * </code>
   *
   * @return The schemaRestrictionResponse.
   */
  com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse
      getSchemaRestrictionResponse();
  /**
   *
   *
   * <pre>
   * Describes the schema restrictions actively enforced in creating this
   * report. To learn more, see [Access and data-restriction
   * management](https://support.google.com/analytics/answer/10851388).
   * </pre>
   *
   * <code>
   * optional .google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponse schema_restriction_response = 4;
   * </code>
   */
  com.google.analytics.data.v1alpha.ResponseMetaData.SchemaRestrictionResponseOrBuilder
      getSchemaRestrictionResponseOrBuilder();

  /**
   *
   *
   * <pre>
   * The currency code used in this report. Intended to be used in formatting
   * currency metrics like `purchaseRevenue` for visualization. If currency_code
   * was specified in the request, this response parameter will echo the request
   * parameter; otherwise, this response parameter is the property's current
   * currency_code.
   *
   * Currency codes are string encodings of currency types from the ISO 4217
   * standard (https://en.wikipedia.org/wiki/ISO_4217); for example "USD",
   * "EUR", "JPY". To learn more, see
   * https://support.google.com/analytics/answer/9796179.
   * </pre>
   *
   * <code>optional string currency_code = 5;</code>
   *
   * @return Whether the currencyCode field is set.
   */
  boolean hasCurrencyCode();
  /**
   *
   *
   * <pre>
   * The currency code used in this report. Intended to be used in formatting
   * currency metrics like `purchaseRevenue` for visualization. If currency_code
   * was specified in the request, this response parameter will echo the request
   * parameter; otherwise, this response parameter is the property's current
   * currency_code.
   *
   * Currency codes are string encodings of currency types from the ISO 4217
   * standard (https://en.wikipedia.org/wiki/ISO_4217); for example "USD",
   * "EUR", "JPY". To learn more, see
   * https://support.google.com/analytics/answer/9796179.
   * </pre>
   *
   * <code>optional string currency_code = 5;</code>
   *
   * @return The currencyCode.
   */
  java.lang.String getCurrencyCode();
  /**
   *
   *
   * <pre>
   * The currency code used in this report. Intended to be used in formatting
   * currency metrics like `purchaseRevenue` for visualization. If currency_code
   * was specified in the request, this response parameter will echo the request
   * parameter; otherwise, this response parameter is the property's current
   * currency_code.
   *
   * Currency codes are string encodings of currency types from the ISO 4217
   * standard (https://en.wikipedia.org/wiki/ISO_4217); for example "USD",
   * "EUR", "JPY". To learn more, see
   * https://support.google.com/analytics/answer/9796179.
   * </pre>
   *
   * <code>optional string currency_code = 5;</code>
   *
   * @return The bytes for currencyCode.
   */
  com.google.protobuf.ByteString getCurrencyCodeBytes();

  /**
   *
   *
   * <pre>
   * The property's current timezone. Intended to be used to interpret
   * time-based dimensions like `hour` and `minute`. Formatted as strings from
   * the IANA Time Zone database (https://www.iana.org/time-zones); for example
   * "America/New_York" or "Asia/Tokyo".
   * </pre>
   *
   * <code>optional string time_zone = 6;</code>
   *
   * @return Whether the timeZone field is set.
   */
  boolean hasTimeZone();
  /**
   *
   *
   * <pre>
   * The property's current timezone. Intended to be used to interpret
   * time-based dimensions like `hour` and `minute`. Formatted as strings from
   * the IANA Time Zone database (https://www.iana.org/time-zones); for example
   * "America/New_York" or "Asia/Tokyo".
   * </pre>
   *
   * <code>optional string time_zone = 6;</code>
   *
   * @return The timeZone.
   */
  java.lang.String getTimeZone();
  /**
   *
   *
   * <pre>
   * The property's current timezone. Intended to be used to interpret
   * time-based dimensions like `hour` and `minute`. Formatted as strings from
   * the IANA Time Zone database (https://www.iana.org/time-zones); for example
   * "America/New_York" or "Asia/Tokyo".
   * </pre>
   *
   * <code>optional string time_zone = 6;</code>
   *
   * @return The bytes for timeZone.
   */
  com.google.protobuf.ByteString getTimeZoneBytes();

  /**
   *
   *
   * <pre>
   * If empty reason is specified, the report is empty for this reason.
   * </pre>
   *
   * <code>optional string empty_reason = 7;</code>
   *
   * @return Whether the emptyReason field is set.
   */
  boolean hasEmptyReason();
  /**
   *
   *
   * <pre>
   * If empty reason is specified, the report is empty for this reason.
   * </pre>
   *
   * <code>optional string empty_reason = 7;</code>
   *
   * @return The emptyReason.
   */
  java.lang.String getEmptyReason();
  /**
   *
   *
   * <pre>
   * If empty reason is specified, the report is empty for this reason.
   * </pre>
   *
   * <code>optional string empty_reason = 7;</code>
   *
   * @return The bytes for emptyReason.
   */
  com.google.protobuf.ByteString getEmptyReasonBytes();

  /**
   *
   *
   * <pre>
   * If `subjectToThresholding` is true, this report is subject to thresholding
   * and only returns data that meets the minimum aggregation thresholds. It is
   * possible for a request to be subject to thresholding thresholding and no
   * data is absent from the report, and this happens when all data is above the
   * thresholds. To learn more, see [Data
   * thresholds](https://support.google.com/analytics/answer/9383630) and [About
   * Demographics and
   * Interests](https://support.google.com/analytics/answer/2799357).
   * </pre>
   *
   * <code>optional bool subject_to_thresholding = 8;</code>
   *
   * @return Whether the subjectToThresholding field is set.
   */
  boolean hasSubjectToThresholding();
  /**
   *
   *
   * <pre>
   * If `subjectToThresholding` is true, this report is subject to thresholding
   * and only returns data that meets the minimum aggregation thresholds. It is
   * possible for a request to be subject to thresholding thresholding and no
   * data is absent from the report, and this happens when all data is above the
   * thresholds. To learn more, see [Data
   * thresholds](https://support.google.com/analytics/answer/9383630) and [About
   * Demographics and
   * Interests](https://support.google.com/analytics/answer/2799357).
   * </pre>
   *
   * <code>optional bool subject_to_thresholding = 8;</code>
   *
   * @return The subjectToThresholding.
   */
  boolean getSubjectToThresholding();
}
