/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.data.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AudienceListName
implements ResourceName {
    private static final PathTemplate PROPERTY_AUDIENCE_LIST = PathTemplate.createWithoutUrlEncoding((String)"properties/{property}/audienceLists/{audience_list}");
    private volatile Map<String, String> fieldValuesMap;
    private final String property;
    private final String audienceList;

    @Deprecated
    protected AudienceListName() {
        this.property = null;
        this.audienceList = null;
    }

    private AudienceListName(Builder builder) {
        this.property = (String)Preconditions.checkNotNull((Object)builder.getProperty());
        this.audienceList = (String)Preconditions.checkNotNull((Object)builder.getAudienceList());
    }

    public String getProperty() {
        return this.property;
    }

    public String getAudienceList() {
        return this.audienceList;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AudienceListName of(String property, String audienceList) {
        return AudienceListName.newBuilder().setProperty(property).setAudienceList(audienceList).build();
    }

    public static String format(String property, String audienceList) {
        return AudienceListName.newBuilder().setProperty(property).setAudienceList(audienceList).build().toString();
    }

    public static AudienceListName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROPERTY_AUDIENCE_LIST.validatedMatch(formattedString, "AudienceListName.parse: formattedString not in valid format");
        return AudienceListName.of((String)matchMap.get("property"), (String)matchMap.get("audience_list"));
    }

    public static List<AudienceListName> parseList(List<String> formattedStrings) {
        ArrayList<AudienceListName> list = new ArrayList<AudienceListName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AudienceListName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AudienceListName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AudienceListName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROPERTY_AUDIENCE_LIST.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AudienceListName audienceListName = this;
            synchronized (audienceListName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.property != null) {
                        fieldMapBuilder.put((Object)"property", (Object)this.property);
                    }
                    if (this.audienceList != null) {
                        fieldMapBuilder.put((Object)"audience_list", (Object)this.audienceList);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROPERTY_AUDIENCE_LIST.instantiate(new String[]{"property", this.property, "audience_list", this.audienceList});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AudienceListName that = (AudienceListName)o;
            return Objects.equals(this.property, that.property) && Objects.equals(this.audienceList, that.audienceList);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.property);
        h *= 1000003;
        return h ^= Objects.hashCode(this.audienceList);
    }

    public static class Builder {
        private String property;
        private String audienceList;

        protected Builder() {
        }

        public String getProperty() {
            return this.property;
        }

        public String getAudienceList() {
            return this.audienceList;
        }

        public Builder setProperty(String property) {
            this.property = property;
            return this;
        }

        public Builder setAudienceList(String audienceList) {
            this.audienceList = audienceList;
            return this;
        }

        private Builder(AudienceListName audienceListName) {
            this.property = audienceListName.property;
            this.audienceList = audienceListName.audienceList;
        }

        public AudienceListName build() {
            return new AudienceListName(this);
        }
    }
}

