/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.admin.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SubpropertySyncConfigName
implements ResourceName {
    private static final PathTemplate PROPERTY_SUBPROPERTY_SYNC_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"properties/{property}/subpropertySyncConfigs/{subproperty_sync_config}");
    private volatile Map<String, String> fieldValuesMap;
    private final String property;
    private final String subpropertySyncConfig;

    @Deprecated
    protected SubpropertySyncConfigName() {
        this.property = null;
        this.subpropertySyncConfig = null;
    }

    private SubpropertySyncConfigName(Builder builder) {
        this.property = (String)Preconditions.checkNotNull((Object)builder.getProperty());
        this.subpropertySyncConfig = (String)Preconditions.checkNotNull((Object)builder.getSubpropertySyncConfig());
    }

    public String getProperty() {
        return this.property;
    }

    public String getSubpropertySyncConfig() {
        return this.subpropertySyncConfig;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SubpropertySyncConfigName of(String property, String subpropertySyncConfig) {
        return SubpropertySyncConfigName.newBuilder().setProperty(property).setSubpropertySyncConfig(subpropertySyncConfig).build();
    }

    public static String format(String property, String subpropertySyncConfig) {
        return SubpropertySyncConfigName.newBuilder().setProperty(property).setSubpropertySyncConfig(subpropertySyncConfig).build().toString();
    }

    public static SubpropertySyncConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROPERTY_SUBPROPERTY_SYNC_CONFIG.validatedMatch(formattedString, "SubpropertySyncConfigName.parse: formattedString not in valid format");
        return SubpropertySyncConfigName.of((String)matchMap.get("property"), (String)matchMap.get("subproperty_sync_config"));
    }

    public static List<SubpropertySyncConfigName> parseList(List<String> formattedStrings) {
        ArrayList<SubpropertySyncConfigName> list = new ArrayList<SubpropertySyncConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SubpropertySyncConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SubpropertySyncConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SubpropertySyncConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROPERTY_SUBPROPERTY_SYNC_CONFIG.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SubpropertySyncConfigName subpropertySyncConfigName = this;
            synchronized (subpropertySyncConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.property != null) {
                        fieldMapBuilder.put((Object)"property", (Object)this.property);
                    }
                    if (this.subpropertySyncConfig != null) {
                        fieldMapBuilder.put((Object)"subproperty_sync_config", (Object)this.subpropertySyncConfig);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROPERTY_SUBPROPERTY_SYNC_CONFIG.instantiate(new String[]{"property", this.property, "subproperty_sync_config", this.subpropertySyncConfig});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SubpropertySyncConfigName that = (SubpropertySyncConfigName)o;
            return Objects.equals(this.property, that.property) && Objects.equals(this.subpropertySyncConfig, that.subpropertySyncConfig);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.property);
        h *= 1000003;
        return h ^= Objects.hashCode(this.subpropertySyncConfig);
    }

    public static class Builder {
        private String property;
        private String subpropertySyncConfig;

        protected Builder() {
        }

        public String getProperty() {
            return this.property;
        }

        public String getSubpropertySyncConfig() {
            return this.subpropertySyncConfig;
        }

        public Builder setProperty(String property) {
            this.property = property;
            return this;
        }

        public Builder setSubpropertySyncConfig(String subpropertySyncConfig) {
            this.subpropertySyncConfig = subpropertySyncConfig;
            return this;
        }

        private Builder(SubpropertySyncConfigName subpropertySyncConfigName) {
            this.property = subpropertySyncConfigName.property;
            this.subpropertySyncConfig = subpropertySyncConfigName.subpropertySyncConfig;
        }

        public SubpropertySyncConfigName build() {
            return new SubpropertySyncConfigName(this);
        }
    }
}

