/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.admin.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GlobalSiteTagName
implements ResourceName {
    private static final PathTemplate PROPERTY_DATA_STREAM = PathTemplate.createWithoutUrlEncoding((String)"properties/{property}/dataStreams/{data_stream}/globalSiteTag");
    private volatile Map<String, String> fieldValuesMap;
    private final String property;
    private final String dataStream;

    @Deprecated
    protected GlobalSiteTagName() {
        this.property = null;
        this.dataStream = null;
    }

    private GlobalSiteTagName(Builder builder) {
        this.property = (String)Preconditions.checkNotNull((Object)builder.getProperty());
        this.dataStream = (String)Preconditions.checkNotNull((Object)builder.getDataStream());
    }

    public String getProperty() {
        return this.property;
    }

    public String getDataStream() {
        return this.dataStream;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static GlobalSiteTagName of(String property, String dataStream) {
        return GlobalSiteTagName.newBuilder().setProperty(property).setDataStream(dataStream).build();
    }

    public static String format(String property, String dataStream) {
        return GlobalSiteTagName.newBuilder().setProperty(property).setDataStream(dataStream).build().toString();
    }

    public static GlobalSiteTagName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROPERTY_DATA_STREAM.validatedMatch(formattedString, "GlobalSiteTagName.parse: formattedString not in valid format");
        return GlobalSiteTagName.of((String)matchMap.get("property"), (String)matchMap.get("data_stream"));
    }

    public static List<GlobalSiteTagName> parseList(List<String> formattedStrings) {
        ArrayList<GlobalSiteTagName> list = new ArrayList<GlobalSiteTagName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(GlobalSiteTagName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<GlobalSiteTagName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (GlobalSiteTagName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROPERTY_DATA_STREAM.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            GlobalSiteTagName globalSiteTagName = this;
            synchronized (globalSiteTagName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.property != null) {
                        fieldMapBuilder.put((Object)"property", (Object)this.property);
                    }
                    if (this.dataStream != null) {
                        fieldMapBuilder.put((Object)"data_stream", (Object)this.dataStream);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROPERTY_DATA_STREAM.instantiate(new String[]{"property", this.property, "data_stream", this.dataStream});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            GlobalSiteTagName that = (GlobalSiteTagName)o;
            return Objects.equals(this.property, that.property) && Objects.equals(this.dataStream, that.dataStream);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.property);
        h *= 1000003;
        return h ^= Objects.hashCode(this.dataStream);
    }

    public static class Builder {
        private String property;
        private String dataStream;

        protected Builder() {
        }

        public String getProperty() {
            return this.property;
        }

        public String getDataStream() {
            return this.dataStream;
        }

        public Builder setProperty(String property) {
            this.property = property;
            return this;
        }

        public Builder setDataStream(String dataStream) {
            this.dataStream = dataStream;
            return this;
        }

        private Builder(GlobalSiteTagName globalSiteTagName) {
            this.property = globalSiteTagName.property;
            this.dataStream = globalSiteTagName.dataStream;
        }

        public GlobalSiteTagName build() {
            return new GlobalSiteTagName(this);
        }
    }
}

