/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.admin.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CalculatedMetricName
implements ResourceName {
    private static final PathTemplate PROPERTY_CALCULATED_METRIC = PathTemplate.createWithoutUrlEncoding((String)"properties/{property}/calculatedMetrics/{calculated_metric}");
    private volatile Map<String, String> fieldValuesMap;
    private final String property;
    private final String calculatedMetric;

    @Deprecated
    protected CalculatedMetricName() {
        this.property = null;
        this.calculatedMetric = null;
    }

    private CalculatedMetricName(Builder builder) {
        this.property = (String)Preconditions.checkNotNull((Object)builder.getProperty());
        this.calculatedMetric = (String)Preconditions.checkNotNull((Object)builder.getCalculatedMetric());
    }

    public String getProperty() {
        return this.property;
    }

    public String getCalculatedMetric() {
        return this.calculatedMetric;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CalculatedMetricName of(String property, String calculatedMetric) {
        return CalculatedMetricName.newBuilder().setProperty(property).setCalculatedMetric(calculatedMetric).build();
    }

    public static String format(String property, String calculatedMetric) {
        return CalculatedMetricName.newBuilder().setProperty(property).setCalculatedMetric(calculatedMetric).build().toString();
    }

    public static CalculatedMetricName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROPERTY_CALCULATED_METRIC.validatedMatch(formattedString, "CalculatedMetricName.parse: formattedString not in valid format");
        return CalculatedMetricName.of((String)matchMap.get("property"), (String)matchMap.get("calculated_metric"));
    }

    public static List<CalculatedMetricName> parseList(List<String> formattedStrings) {
        ArrayList<CalculatedMetricName> list = new ArrayList<CalculatedMetricName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CalculatedMetricName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CalculatedMetricName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CalculatedMetricName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROPERTY_CALCULATED_METRIC.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CalculatedMetricName calculatedMetricName = this;
            synchronized (calculatedMetricName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.property != null) {
                        fieldMapBuilder.put((Object)"property", (Object)this.property);
                    }
                    if (this.calculatedMetric != null) {
                        fieldMapBuilder.put((Object)"calculated_metric", (Object)this.calculatedMetric);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROPERTY_CALCULATED_METRIC.instantiate(new String[]{"property", this.property, "calculated_metric", this.calculatedMetric});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CalculatedMetricName that = (CalculatedMetricName)o;
            return Objects.equals(this.property, that.property) && Objects.equals(this.calculatedMetric, that.calculatedMetric);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.property);
        h *= 1000003;
        return h ^= Objects.hashCode(this.calculatedMetric);
    }

    public static class Builder {
        private String property;
        private String calculatedMetric;

        protected Builder() {
        }

        public String getProperty() {
            return this.property;
        }

        public String getCalculatedMetric() {
            return this.calculatedMetric;
        }

        public Builder setProperty(String property) {
            this.property = property;
            return this;
        }

        public Builder setCalculatedMetric(String calculatedMetric) {
            this.calculatedMetric = calculatedMetric;
            return this;
        }

        private Builder(CalculatedMetricName calculatedMetricName) {
            this.property = calculatedMetricName.property;
            this.calculatedMetric = calculatedMetricName.calculatedMetric;
        }

        public CalculatedMetricName build() {
            return new CalculatedMetricName(this);
        }
    }
}

