/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.admin.v1alpha;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AccessBindingName
implements ResourceName {
    private static final PathTemplate ACCOUNT_ACCESS_BINDING = PathTemplate.createWithoutUrlEncoding((String)"accounts/{account}/accessBindings/{access_binding}");
    private static final PathTemplate PROPERTY_ACCESS_BINDING = PathTemplate.createWithoutUrlEncoding((String)"properties/{property}/accessBindings/{access_binding}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String account;
    private final String accessBinding;
    private final String property;

    @Deprecated
    protected AccessBindingName() {
        this.account = null;
        this.accessBinding = null;
        this.property = null;
    }

    private AccessBindingName(Builder builder) {
        this.account = (String)Preconditions.checkNotNull((Object)builder.getAccount());
        this.accessBinding = (String)Preconditions.checkNotNull((Object)builder.getAccessBinding());
        this.property = null;
        this.pathTemplate = ACCOUNT_ACCESS_BINDING;
    }

    private AccessBindingName(PropertyAccessBindingBuilder builder) {
        this.property = (String)Preconditions.checkNotNull((Object)builder.getProperty());
        this.accessBinding = (String)Preconditions.checkNotNull((Object)builder.getAccessBinding());
        this.account = null;
        this.pathTemplate = PROPERTY_ACCESS_BINDING;
    }

    public String getAccount() {
        return this.account;
    }

    public String getAccessBinding() {
        return this.accessBinding;
    }

    public String getProperty() {
        return this.property;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newAccountAccessBindingBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static PropertyAccessBindingBuilder newPropertyAccessBindingBuilder() {
        return new PropertyAccessBindingBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AccessBindingName of(String account, String accessBinding) {
        return AccessBindingName.newBuilder().setAccount(account).setAccessBinding(accessBinding).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static AccessBindingName ofAccountAccessBindingName(String account, String accessBinding) {
        return AccessBindingName.newBuilder().setAccount(account).setAccessBinding(accessBinding).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static AccessBindingName ofPropertyAccessBindingName(String property, String accessBinding) {
        return AccessBindingName.newPropertyAccessBindingBuilder().setProperty(property).setAccessBinding(accessBinding).build();
    }

    public static String format(String account, String accessBinding) {
        return AccessBindingName.newBuilder().setAccount(account).setAccessBinding(accessBinding).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatAccountAccessBindingName(String account, String accessBinding) {
        return AccessBindingName.newBuilder().setAccount(account).setAccessBinding(accessBinding).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatPropertyAccessBindingName(String property, String accessBinding) {
        return AccessBindingName.newPropertyAccessBindingBuilder().setProperty(property).setAccessBinding(accessBinding).build().toString();
    }

    public static AccessBindingName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (ACCOUNT_ACCESS_BINDING.matches(formattedString)) {
            Map matchMap = ACCOUNT_ACCESS_BINDING.match(formattedString);
            return AccessBindingName.ofAccountAccessBindingName((String)matchMap.get("account"), (String)matchMap.get("access_binding"));
        }
        if (PROPERTY_ACCESS_BINDING.matches(formattedString)) {
            Map matchMap = PROPERTY_ACCESS_BINDING.match(formattedString);
            return AccessBindingName.ofPropertyAccessBindingName((String)matchMap.get("property"), (String)matchMap.get("access_binding"));
        }
        throw new ValidationException("AccessBindingName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<AccessBindingName> parseList(List<String> formattedStrings) {
        ArrayList<AccessBindingName> list = new ArrayList<AccessBindingName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AccessBindingName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AccessBindingName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AccessBindingName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ACCOUNT_ACCESS_BINDING.matches(formattedString) || PROPERTY_ACCESS_BINDING.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AccessBindingName accessBindingName = this;
            synchronized (accessBindingName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.account != null) {
                        fieldMapBuilder.put((Object)"account", (Object)this.account);
                    }
                    if (this.accessBinding != null) {
                        fieldMapBuilder.put((Object)"access_binding", (Object)this.accessBinding);
                    }
                    if (this.property != null) {
                        fieldMapBuilder.put((Object)"property", (Object)this.property);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AccessBindingName that = (AccessBindingName)o;
            return Objects.equals(this.account, that.account) && Objects.equals(this.accessBinding, that.accessBinding) && Objects.equals(this.property, that.property);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.account);
        h *= 1000003;
        h ^= Objects.hashCode(this.accessBinding);
        h *= 1000003;
        return h ^= Objects.hashCode(this.property);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class PropertyAccessBindingBuilder {
        private String property;
        private String accessBinding;

        protected PropertyAccessBindingBuilder() {
        }

        public String getProperty() {
            return this.property;
        }

        public String getAccessBinding() {
            return this.accessBinding;
        }

        public PropertyAccessBindingBuilder setProperty(String property) {
            this.property = property;
            return this;
        }

        public PropertyAccessBindingBuilder setAccessBinding(String accessBinding) {
            this.accessBinding = accessBinding;
            return this;
        }

        public AccessBindingName build() {
            return new AccessBindingName(this);
        }
    }

    public static class Builder {
        private String account;
        private String accessBinding;

        protected Builder() {
        }

        public String getAccount() {
            return this.account;
        }

        public String getAccessBinding() {
            return this.accessBinding;
        }

        public Builder setAccount(String account) {
            this.account = account;
            return this;
        }

        public Builder setAccessBinding(String accessBinding) {
            this.accessBinding = accessBinding;
            return this;
        }

        private Builder(AccessBindingName accessBindingName) {
            Preconditions.checkArgument((boolean)Objects.equals(accessBindingName.pathTemplate, ACCOUNT_ACCESS_BINDING), (Object)"toBuilder is only supported when AccessBindingName has the pattern of accounts/{account}/accessBindings/{access_binding}");
            this.account = accessBindingName.account;
            this.accessBinding = accessBindingName.accessBinding;
        }

        public AccessBindingName build() {
            return new AccessBindingName(this);
        }
    }
}

