/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.admin.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GoogleAdsLinkName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"properties/{property}/googleAdsLinks/{google_ads_link}");
    private volatile Map<String, String> fieldValuesMap;
    private final String property;
    private final String googleAdsLink;

    public String getProperty() {
        return this.property;
    }

    public String getGoogleAdsLink() {
        return this.googleAdsLink;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private GoogleAdsLinkName(Builder builder) {
        this.property = (String)Preconditions.checkNotNull((Object)builder.getProperty());
        this.googleAdsLink = (String)Preconditions.checkNotNull((Object)builder.getGoogleAdsLink());
    }

    public static GoogleAdsLinkName of(String property, String googleAdsLink) {
        return GoogleAdsLinkName.newBuilder().setProperty(property).setGoogleAdsLink(googleAdsLink).build();
    }

    public static String format(String property, String googleAdsLink) {
        return GoogleAdsLinkName.newBuilder().setProperty(property).setGoogleAdsLink(googleAdsLink).build().toString();
    }

    public static GoogleAdsLinkName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "GoogleAdsLinkName.parse: formattedString not in valid format");
        return GoogleAdsLinkName.of((String)matchMap.get("property"), (String)matchMap.get("google_ads_link"));
    }

    public static List<GoogleAdsLinkName> parseList(List<String> formattedStrings) {
        ArrayList<GoogleAdsLinkName> list = new ArrayList<GoogleAdsLinkName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(GoogleAdsLinkName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<GoogleAdsLinkName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (GoogleAdsLinkName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            GoogleAdsLinkName googleAdsLinkName = this;
            synchronized (googleAdsLinkName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"property", (Object)this.property);
                    fieldMapBuilder.put((Object)"googleAdsLink", (Object)this.googleAdsLink);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"property", this.property, "google_ads_link", this.googleAdsLink});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof GoogleAdsLinkName) {
            GoogleAdsLinkName that = (GoogleAdsLinkName)o;
            return this.property.equals(that.property) && this.googleAdsLink.equals(that.googleAdsLink);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.property.hashCode();
        h *= 1000003;
        return h ^= this.googleAdsLink.hashCode();
    }

    public static class Builder {
        private String property;
        private String googleAdsLink;

        public String getProperty() {
            return this.property;
        }

        public String getGoogleAdsLink() {
            return this.googleAdsLink;
        }

        public Builder setProperty(String property) {
            this.property = property;
            return this;
        }

        public Builder setGoogleAdsLink(String googleAdsLink) {
            this.googleAdsLink = googleAdsLink;
            return this;
        }

        private Builder() {
        }

        private Builder(GoogleAdsLinkName googleAdsLinkName) {
            this.property = googleAdsLinkName.property;
            this.googleAdsLink = googleAdsLinkName.googleAdsLink;
        }

        public GoogleAdsLinkName build() {
            return new GoogleAdsLinkName(this);
        }
    }
}

