/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.admin.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AndroidAppDataStreamName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"properties/{property}/androidAppDataStreams/{android_app_data_stream}");
    private volatile Map<String, String> fieldValuesMap;
    private final String property;
    private final String androidAppDataStream;

    public String getProperty() {
        return this.property;
    }

    public String getAndroidAppDataStream() {
        return this.androidAppDataStream;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private AndroidAppDataStreamName(Builder builder) {
        this.property = (String)Preconditions.checkNotNull((Object)builder.getProperty());
        this.androidAppDataStream = (String)Preconditions.checkNotNull((Object)builder.getAndroidAppDataStream());
    }

    public static AndroidAppDataStreamName of(String property, String androidAppDataStream) {
        return AndroidAppDataStreamName.newBuilder().setProperty(property).setAndroidAppDataStream(androidAppDataStream).build();
    }

    public static String format(String property, String androidAppDataStream) {
        return AndroidAppDataStreamName.newBuilder().setProperty(property).setAndroidAppDataStream(androidAppDataStream).build().toString();
    }

    public static AndroidAppDataStreamName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "AndroidAppDataStreamName.parse: formattedString not in valid format");
        return AndroidAppDataStreamName.of((String)matchMap.get("property"), (String)matchMap.get("android_app_data_stream"));
    }

    public static List<AndroidAppDataStreamName> parseList(List<String> formattedStrings) {
        ArrayList<AndroidAppDataStreamName> list = new ArrayList<AndroidAppDataStreamName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AndroidAppDataStreamName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AndroidAppDataStreamName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AndroidAppDataStreamName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AndroidAppDataStreamName androidAppDataStreamName = this;
            synchronized (androidAppDataStreamName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"property", (Object)this.property);
                    fieldMapBuilder.put((Object)"androidAppDataStream", (Object)this.androidAppDataStream);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"property", this.property, "android_app_data_stream", this.androidAppDataStream});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AndroidAppDataStreamName) {
            AndroidAppDataStreamName that = (AndroidAppDataStreamName)o;
            return this.property.equals(that.property) && this.androidAppDataStream.equals(that.androidAppDataStream);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.property.hashCode();
        h *= 1000003;
        return h ^= this.androidAppDataStream.hashCode();
    }

    public static class Builder {
        private String property;
        private String androidAppDataStream;

        public String getProperty() {
            return this.property;
        }

        public String getAndroidAppDataStream() {
            return this.androidAppDataStream;
        }

        public Builder setProperty(String property) {
            this.property = property;
            return this;
        }

        public Builder setAndroidAppDataStream(String androidAppDataStream) {
            this.androidAppDataStream = androidAppDataStream;
            return this;
        }

        private Builder() {
        }

        private Builder(AndroidAppDataStreamName androidAppDataStreamName) {
            this.property = androidAppDataStreamName.property;
            this.androidAppDataStream = androidAppDataStreamName.androidAppDataStream;
        }

        public AndroidAppDataStreamName build() {
            return new AndroidAppDataStreamName(this);
        }
    }
}

