/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.admin.v1alpha;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class UserLinkName
implements ResourceName {
    private static final PathTemplate ACCOUNT_USER_LINK = PathTemplate.createWithoutUrlEncoding((String)"accounts/{account}/userLinks/{user_link}");
    private static final PathTemplate PROPERTY_USER_LINK = PathTemplate.createWithoutUrlEncoding((String)"properties/{property}/userLinks/{user_link}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String account;
    private final String userLink;
    private final String property;

    @Deprecated
    protected UserLinkName() {
        this.account = null;
        this.userLink = null;
        this.property = null;
    }

    private UserLinkName(Builder builder) {
        this.account = (String)Preconditions.checkNotNull((Object)builder.getAccount());
        this.userLink = (String)Preconditions.checkNotNull((Object)builder.getUserLink());
        this.property = null;
        this.pathTemplate = ACCOUNT_USER_LINK;
    }

    private UserLinkName(PropertyUserLinkBuilder builder) {
        this.property = (String)Preconditions.checkNotNull((Object)builder.getProperty());
        this.userLink = (String)Preconditions.checkNotNull((Object)builder.getUserLink());
        this.account = null;
        this.pathTemplate = PROPERTY_USER_LINK;
    }

    public String getAccount() {
        return this.account;
    }

    public String getUserLink() {
        return this.userLink;
    }

    public String getProperty() {
        return this.property;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newAccountUserLinkBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static PropertyUserLinkBuilder newPropertyUserLinkBuilder() {
        return new PropertyUserLinkBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static UserLinkName of(String account, String userLink) {
        return UserLinkName.newBuilder().setAccount(account).setUserLink(userLink).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static UserLinkName ofAccountUserLinkName(String account, String userLink) {
        return UserLinkName.newBuilder().setAccount(account).setUserLink(userLink).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static UserLinkName ofPropertyUserLinkName(String property, String userLink) {
        return UserLinkName.newPropertyUserLinkBuilder().setProperty(property).setUserLink(userLink).build();
    }

    public static String format(String account, String userLink) {
        return UserLinkName.newBuilder().setAccount(account).setUserLink(userLink).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatAccountUserLinkName(String account, String userLink) {
        return UserLinkName.newBuilder().setAccount(account).setUserLink(userLink).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatPropertyUserLinkName(String property, String userLink) {
        return UserLinkName.newPropertyUserLinkBuilder().setProperty(property).setUserLink(userLink).build().toString();
    }

    public static UserLinkName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (ACCOUNT_USER_LINK.matches(formattedString)) {
            Map matchMap = ACCOUNT_USER_LINK.match(formattedString);
            return UserLinkName.ofAccountUserLinkName((String)matchMap.get("account"), (String)matchMap.get("user_link"));
        }
        if (PROPERTY_USER_LINK.matches(formattedString)) {
            Map matchMap = PROPERTY_USER_LINK.match(formattedString);
            return UserLinkName.ofPropertyUserLinkName((String)matchMap.get("property"), (String)matchMap.get("user_link"));
        }
        throw new ValidationException("UserLinkName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<UserLinkName> parseList(List<String> formattedStrings) {
        ArrayList<UserLinkName> list = new ArrayList<UserLinkName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(UserLinkName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<UserLinkName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (UserLinkName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ACCOUNT_USER_LINK.matches(formattedString) || PROPERTY_USER_LINK.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            UserLinkName userLinkName = this;
            synchronized (userLinkName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.account != null) {
                        fieldMapBuilder.put((Object)"account", (Object)this.account);
                    }
                    if (this.userLink != null) {
                        fieldMapBuilder.put((Object)"user_link", (Object)this.userLink);
                    }
                    if (this.property != null) {
                        fieldMapBuilder.put((Object)"property", (Object)this.property);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            UserLinkName that = (UserLinkName)o;
            return Objects.equals(this.account, that.account) && Objects.equals(this.userLink, that.userLink) && Objects.equals(this.property, that.property);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.account);
        h *= 1000003;
        h ^= Objects.hashCode(this.userLink);
        h *= 1000003;
        return h ^= Objects.hashCode(this.property);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class PropertyUserLinkBuilder {
        private String property;
        private String userLink;

        protected PropertyUserLinkBuilder() {
        }

        public String getProperty() {
            return this.property;
        }

        public String getUserLink() {
            return this.userLink;
        }

        public PropertyUserLinkBuilder setProperty(String property) {
            this.property = property;
            return this;
        }

        public PropertyUserLinkBuilder setUserLink(String userLink) {
            this.userLink = userLink;
            return this;
        }

        public UserLinkName build() {
            return new UserLinkName(this);
        }
    }

    public static class Builder {
        private String account;
        private String userLink;

        protected Builder() {
        }

        public String getAccount() {
            return this.account;
        }

        public String getUserLink() {
            return this.userLink;
        }

        public Builder setAccount(String account) {
            this.account = account;
            return this;
        }

        public Builder setUserLink(String userLink) {
            this.userLink = userLink;
            return this;
        }

        private Builder(UserLinkName userLinkName) {
            Preconditions.checkArgument((boolean)Objects.equals(userLinkName.pathTemplate, ACCOUNT_USER_LINK), (Object)"toBuilder is only supported when UserLinkName has the pattern of accounts/{account}/userLinks/{user_link}");
            this.account = userLinkName.account;
            this.userLink = userLinkName.userLink;
        }

        public UserLinkName build() {
            return new UserLinkName(this);
        }
    }
}

