/*
 * Decompiled with CFR 0.152.
 */
package com.google.storage.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StreamingCallSettings;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.storage.v2.QueryWriteStatusRequest;
import com.google.storage.v2.QueryWriteStatusResponse;
import com.google.storage.v2.ReadObjectRequest;
import com.google.storage.v2.ReadObjectResponse;
import com.google.storage.v2.StartResumableWriteRequest;
import com.google.storage.v2.StartResumableWriteResponse;
import com.google.storage.v2.WriteObjectRequest;
import com.google.storage.v2.WriteObjectResponse;
import com.google.storage.v2.stub.GrpcStorageStub;
import com.google.storage.v2.stub.StorageStub;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class StorageStubSettings
extends StubSettings<StorageStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/cloud-platform.read-only").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final ServerStreamingCallSettings<ReadObjectRequest, ReadObjectResponse> readObjectSettings;
    private final StreamingCallSettings<WriteObjectRequest, WriteObjectResponse> writeObjectSettings;
    private final UnaryCallSettings<StartResumableWriteRequest, StartResumableWriteResponse> startResumableWriteSettings;
    private final UnaryCallSettings<QueryWriteStatusRequest, QueryWriteStatusResponse> queryWriteStatusSettings;

    public ServerStreamingCallSettings<ReadObjectRequest, ReadObjectResponse> readObjectSettings() {
        return this.readObjectSettings;
    }

    public StreamingCallSettings<WriteObjectRequest, WriteObjectResponse> writeObjectSettings() {
        return this.writeObjectSettings;
    }

    public UnaryCallSettings<StartResumableWriteRequest, StartResumableWriteResponse> startResumableWriteSettings() {
        return this.startResumableWriteSettings;
    }

    public UnaryCallSettings<QueryWriteStatusRequest, QueryWriteStatusResponse> queryWriteStatusSettings() {
        return this.queryWriteStatusSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public StorageStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcStorageStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "storage.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "storage.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return StorageStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(StorageStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected StorageStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.readObjectSettings = settingsBuilder.readObjectSettings().build();
        this.writeObjectSettings = settingsBuilder.writeObjectSettings().build();
        this.startResumableWriteSettings = settingsBuilder.startResumableWriteSettings().build();
        this.queryWriteStatusSettings = settingsBuilder.queryWriteStatusSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<StorageStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final ServerStreamingCallSettings.Builder<ReadObjectRequest, ReadObjectResponse> readObjectSettings;
        private final StreamingCallSettings.Builder<WriteObjectRequest, WriteObjectResponse> writeObjectSettings;
        private final UnaryCallSettings.Builder<StartResumableWriteRequest, StartResumableWriteResponse> startResumableWriteSettings;
        private final UnaryCallSettings.Builder<QueryWriteStatusRequest, QueryWriteStatusResponse> queryWriteStatusSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.readObjectSettings = ServerStreamingCallSettings.newBuilder();
            this.writeObjectSettings = StreamingCallSettings.newBuilder();
            this.startResumableWriteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.queryWriteStatusSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.startResumableWriteSettings, this.queryWriteStatusSettings);
            Builder.initDefaults(this);
        }

        protected Builder(StorageStubSettings settings) {
            super((StubSettings)settings);
            this.readObjectSettings = settings.readObjectSettings.toBuilder();
            this.writeObjectSettings = settings.writeObjectSettings.toBuilder();
            this.startResumableWriteSettings = settings.startResumableWriteSettings.toBuilder();
            this.queryWriteStatusSettings = settings.queryWriteStatusSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.startResumableWriteSettings, this.queryWriteStatusSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(StorageStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)StorageStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)StorageStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(StorageStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(StorageStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.readObjectSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.startResumableWriteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.queryWriteStatusSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public ServerStreamingCallSettings.Builder<ReadObjectRequest, ReadObjectResponse> readObjectSettings() {
            return this.readObjectSettings;
        }

        public StreamingCallSettings.Builder<WriteObjectRequest, WriteObjectResponse> writeObjectSettings() {
            return this.writeObjectSettings;
        }

        public UnaryCallSettings.Builder<StartResumableWriteRequest, StartResumableWriteResponse> startResumableWriteSettings() {
            return this.startResumableWriteSettings;
        }

        public UnaryCallSettings.Builder<QueryWriteStatusRequest, QueryWriteStatusResponse> queryWriteStatusSettings() {
            return this.queryWriteStatusSettings;
        }

        public StorageStubSettings build() throws IOException {
            return new StorageStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

