package com.google.api.gax.batching;

import javax.annotation.Generated;
import javax.annotation.Nullable;
import org.threeten.bp.Duration;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_BatchingSettings extends BatchingSettings {

  private final Long elementCountThreshold;

  private final Long requestByteThreshold;

  private final Duration delayThreshold;

  private final Boolean isEnabled;

  private final FlowControlSettings flowControlSettings;

  private AutoValue_BatchingSettings(
      @Nullable Long elementCountThreshold,
      @Nullable Long requestByteThreshold,
      @Nullable Duration delayThreshold,
      Boolean isEnabled,
      FlowControlSettings flowControlSettings) {
    this.elementCountThreshold = elementCountThreshold;
    this.requestByteThreshold = requestByteThreshold;
    this.delayThreshold = delayThreshold;
    this.isEnabled = isEnabled;
    this.flowControlSettings = flowControlSettings;
  }

  @Nullable
  @Override
  public Long getElementCountThreshold() {
    return elementCountThreshold;
  }

  @Nullable
  @Override
  public Long getRequestByteThreshold() {
    return requestByteThreshold;
  }

  @Nullable
  @Override
  public Duration getDelayThreshold() {
    return delayThreshold;
  }

  @Override
  public Boolean getIsEnabled() {
    return isEnabled;
  }

  @Override
  public FlowControlSettings getFlowControlSettings() {
    return flowControlSettings;
  }

  @Override
  public String toString() {
    return "BatchingSettings{"
        + "elementCountThreshold=" + elementCountThreshold + ", "
        + "requestByteThreshold=" + requestByteThreshold + ", "
        + "delayThreshold=" + delayThreshold + ", "
        + "isEnabled=" + isEnabled + ", "
        + "flowControlSettings=" + flowControlSettings
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof BatchingSettings) {
      BatchingSettings that = (BatchingSettings) o;
      return (this.elementCountThreshold == null ? that.getElementCountThreshold() == null : this.elementCountThreshold.equals(that.getElementCountThreshold()))
          && (this.requestByteThreshold == null ? that.getRequestByteThreshold() == null : this.requestByteThreshold.equals(that.getRequestByteThreshold()))
          && (this.delayThreshold == null ? that.getDelayThreshold() == null : this.delayThreshold.equals(that.getDelayThreshold()))
          && this.isEnabled.equals(that.getIsEnabled())
          && this.flowControlSettings.equals(that.getFlowControlSettings());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (elementCountThreshold == null) ? 0 : elementCountThreshold.hashCode();
    h$ *= 1000003;
    h$ ^= (requestByteThreshold == null) ? 0 : requestByteThreshold.hashCode();
    h$ *= 1000003;
    h$ ^= (delayThreshold == null) ? 0 : delayThreshold.hashCode();
    h$ *= 1000003;
    h$ ^= isEnabled.hashCode();
    h$ *= 1000003;
    h$ ^= flowControlSettings.hashCode();
    return h$;
  }

  @Override
  public BatchingSettings.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends BatchingSettings.Builder {
    private Long elementCountThreshold;
    private Long requestByteThreshold;
    private Duration delayThreshold;
    private Boolean isEnabled;
    private FlowControlSettings flowControlSettings;
    Builder() {
    }
    private Builder(BatchingSettings source) {
      this.elementCountThreshold = source.getElementCountThreshold();
      this.requestByteThreshold = source.getRequestByteThreshold();
      this.delayThreshold = source.getDelayThreshold();
      this.isEnabled = source.getIsEnabled();
      this.flowControlSettings = source.getFlowControlSettings();
    }
    @Override
    public BatchingSettings.Builder setElementCountThreshold(Long elementCountThreshold) {
      this.elementCountThreshold = elementCountThreshold;
      return this;
    }
    @Override
    public BatchingSettings.Builder setRequestByteThreshold(Long requestByteThreshold) {
      this.requestByteThreshold = requestByteThreshold;
      return this;
    }
    @Override
    public BatchingSettings.Builder setDelayThreshold(Duration delayThreshold) {
      this.delayThreshold = delayThreshold;
      return this;
    }
    @Override
    public BatchingSettings.Builder setIsEnabled(Boolean isEnabled) {
      if (isEnabled == null) {
        throw new NullPointerException("Null isEnabled");
      }
      this.isEnabled = isEnabled;
      return this;
    }
    @Override
    public BatchingSettings.Builder setFlowControlSettings(FlowControlSettings flowControlSettings) {
      if (flowControlSettings == null) {
        throw new NullPointerException("Null flowControlSettings");
      }
      this.flowControlSettings = flowControlSettings;
      return this;
    }
    @Override
    BatchingSettings autoBuild() {
      if (this.isEnabled == null
          || this.flowControlSettings == null) {
        StringBuilder missing = new StringBuilder();
        if (this.isEnabled == null) {
          missing.append(" isEnabled");
        }
        if (this.flowControlSettings == null) {
          missing.append(" flowControlSettings");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_BatchingSettings(
          this.elementCountThreshold,
          this.requestByteThreshold,
          this.delayThreshold,
          this.isEnabled,
          this.flowControlSettings);
    }
  }

}
