/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.tracing;

import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.CancelledException;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.testing.FakeCallContext;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.api.gax.rpc.testing.MockStreamingApi;
import com.google.api.gax.tracing.ApiTracer;
import com.google.api.gax.tracing.ApiTracerFactory;
import com.google.api.gax.tracing.SpanName;
import com.google.api.gax.tracing.TracedServerStreamingCallable;
import com.google.common.truth.Truth;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.quality.Strictness;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class TracedServerStreamingCallableTest {
    private static final SpanName SPAN_NAME = SpanName.of((String)"FakeClient", (String)"FakeRpc");
    @Rule
    public final MockitoRule mockitoRule = MockitoJUnit.rule().strictness(Strictness.STRICT_STUBS);
    @Mock
    private ApiTracerFactory tracerFactory;
    @Mock
    private ApiTracer tracer;
    private MockStreamingApi.MockServerStreamingCallable<String, String> innerCallable;
    private TracedServerStreamingCallable<String, String> tracedCallable;
    private MockStreamingApi.MockResponseObserver<String> responseObserver;
    private ApiCallContext callContext;
    @Mock
    private ApiTracer parentTracer;

    @Before
    public void setUp() {
        Mockito.when((Object)this.tracerFactory.newTracer((ApiTracer)Mockito.any(ApiTracer.class), (SpanName)Mockito.any(SpanName.class), (ApiTracerFactory.OperationType)Mockito.eq((Object)ApiTracerFactory.OperationType.ServerStreaming))).thenReturn((Object)this.tracer);
        this.innerCallable = new MockStreamingApi.MockServerStreamingCallable();
        this.responseObserver = new MockStreamingApi.MockResponseObserver(true);
        this.callContext = FakeCallContext.createDefault().withTracer(this.parentTracer);
        this.tracedCallable = new TracedServerStreamingCallable(this.innerCallable, this.tracerFactory, SPAN_NAME);
    }

    @Test
    public void testTracerCreated() {
        this.tracedCallable.call((Object)"test", this.responseObserver, this.callContext);
        ((ApiTracerFactory)Mockito.verify((Object)this.tracerFactory, (VerificationMode)Mockito.times((int)1))).newTracer(this.parentTracer, SPAN_NAME, ApiTracerFactory.OperationType.ServerStreaming);
    }

    @Test
    public void testResponseNotify() {
        this.tracedCallable.call((Object)"test", this.responseObserver, this.callContext);
        MockStreamingApi.MockServerStreamingCall<String, String> innerCall = this.innerCallable.popLastCall();
        innerCall.getController().getObserver().onResponse((Object)"response1");
        innerCall.getController().getObserver().onResponse((Object)"response2");
        Truth.assertThat((String)this.responseObserver.popNextResponse()).isEqualTo((Object)"response1");
        Truth.assertThat((String)this.responseObserver.popNextResponse()).isEqualTo((Object)"response2");
        ((ApiTracer)Mockito.verify((Object)this.tracer, (VerificationMode)Mockito.times((int)2))).responseReceived();
    }

    @Test
    public void testOperationCancelled() {
        this.tracedCallable.call((Object)"test", this.responseObserver, this.callContext);
        this.responseObserver.getController().cancel();
        MockStreamingApi.MockServerStreamingCall<String, String> innerCall = this.innerCallable.popLastCall();
        innerCall.getController().getObserver().onError((Throwable)new CancelledException("fake cancel", null, (StatusCode)new FakeStatusCode(StatusCode.Code.CANCELLED), false));
        Truth.assertThat((Boolean)this.responseObserver.isDone()).isTrue();
        ((ApiTracer)Mockito.verify((Object)this.tracer, (VerificationMode)Mockito.times((int)1))).operationCancelled();
    }

    @Test
    public void testOperationFinish() {
        this.tracedCallable.call((Object)"test", this.responseObserver, this.callContext);
        MockStreamingApi.MockServerStreamingCall<String, String> innerCall = this.innerCallable.popLastCall();
        innerCall.getController().getObserver().onComplete();
        Truth.assertThat((Boolean)this.responseObserver.isDone()).isTrue();
        ((ApiTracer)Mockito.verify((Object)this.tracer, (VerificationMode)Mockito.times((int)1))).operationSucceeded();
    }

    @Test
    public void testOperationFail() {
        RuntimeException expectedError = new RuntimeException("expected error");
        this.tracedCallable.call((Object)"test", this.responseObserver, this.callContext);
        MockStreamingApi.MockServerStreamingCall<String, String> innerCall = this.innerCallable.popLastCall();
        innerCall.getController().getObserver().onError((Throwable)expectedError);
        Truth.assertThat((Throwable)this.responseObserver.getFinalError()).isEqualTo((Object)expectedError);
        ((ApiTracer)Mockito.verify((Object)this.tracer, (VerificationMode)Mockito.times((int)1))).operationFailed((Throwable)expectedError);
    }

    @Test
    public void testSyncError() {
        RuntimeException expectedError = new RuntimeException("expected error");
        ServerStreamingCallable innerCallable = (ServerStreamingCallable)Mockito.mock(ServerStreamingCallable.class);
        ((ServerStreamingCallable)Mockito.doThrow((Throwable[])new Throwable[]{expectedError}).when((Object)innerCallable)).call(Mockito.eq((Object)"test"), (ResponseObserver)Mockito.any(ResponseObserver.class), (ApiCallContext)Mockito.any(ApiCallContext.class));
        this.tracedCallable = new TracedServerStreamingCallable(innerCallable, this.tracerFactory, SPAN_NAME);
        try {
            this.tracedCallable.call((Object)"test", this.responseObserver, this.callContext);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        ((ApiTracer)Mockito.verify((Object)this.tracer, (VerificationMode)Mockito.times((int)1))).operationFailed((Throwable)expectedError);
    }
}

