/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.core.ApiClock;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.core.FakeApiClock;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.StreamController;
import com.google.api.gax.rpc.Watchdog;
import com.google.api.gax.rpc.WatchdogTimeoutException;
import com.google.api.gax.rpc.testing.MockStreamingApi;
import com.google.common.collect.Queues;
import com.google.common.truth.Truth;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class WatchdogTest {
    private FakeApiClock clock;
    private Duration waitTime = Duration.ofSeconds((long)10L);
    private Duration idleTime = Duration.ofMinutes((long)5L);
    private Watchdog watchdog;
    private MockStreamingApi.MockServerStreamingCallable<String, String> callable;
    private AccumulatingObserver<String> innerObserver;
    private MockStreamingApi.MockServerStreamingCall<String, String> call;

    @Before
    public void setUp() {
        this.clock = new FakeApiClock(0L);
        this.watchdog = new Watchdog((ApiClock)this.clock);
        this.callable = new MockStreamingApi.MockServerStreamingCallable();
        this.innerObserver = new AccumulatingObserver();
        this.callable.call("request", this.watchdog.watch(this.innerObserver, this.waitTime, this.idleTime));
        this.call = this.callable.popLastCall();
    }

    @Test
    public void testRequestPassthrough() throws Exception {
        ((StreamController)this.innerObserver.controller.get()).request(1);
        Truth.assertThat((Integer)this.call.getController().popLastPull()).isEqualTo((Object)1);
    }

    @Test
    public void testWaitTimeout() throws Exception {
        ((StreamController)this.innerObserver.controller.get(1L, TimeUnit.MILLISECONDS)).request(1);
        this.clock.incrementNanoTime(this.waitTime.toNanos() - 1L);
        this.watchdog.run();
        Truth.assertThat((Boolean)this.call.getController().isCancelled()).isFalse();
        this.clock.incrementNanoTime(1L);
        this.watchdog.run();
        Truth.assertThat((Boolean)this.call.getController().isCancelled()).isTrue();
        this.call.getController().getObserver().onError((Throwable)new RuntimeException("Some upstream exception representing cancellation"));
        Throwable actualError = null;
        try {
            this.innerObserver.done.get();
        }
        catch (ExecutionException t) {
            actualError = t.getCause();
        }
        Truth.assertThat((Throwable)actualError).isInstanceOf(WatchdogTimeoutException.class);
    }

    @Test
    public void testIdleTimeout() throws InterruptedException {
        this.clock.incrementNanoTime(this.idleTime.toNanos() - 1L);
        this.watchdog.run();
        Truth.assertThat((Boolean)this.call.getController().isCancelled()).isFalse();
        this.clock.incrementNanoTime(1L);
        this.watchdog.run();
        Truth.assertThat((Boolean)this.call.getController().isCancelled()).isTrue();
        this.call.getController().getObserver().onError((Throwable)new RuntimeException("Some upstream exception representing cancellation"));
        Throwable actualError = null;
        try {
            this.innerObserver.done.get();
        }
        catch (ExecutionException t) {
            actualError = t.getCause();
        }
        Truth.assertThat((Throwable)actualError).isInstanceOf(WatchdogTimeoutException.class);
    }

    @Test
    public void testMultiple() throws Exception {
        AccumulatingObserver downstreamObserver1 = new AccumulatingObserver();
        this.callable.call("request", this.watchdog.watch(downstreamObserver1, this.waitTime, this.idleTime));
        MockStreamingApi.MockServerStreamingCall<String, String> call1 = this.callable.popLastCall();
        ((StreamController)downstreamObserver1.controller.get()).request(1);
        AccumulatingObserver downstreamObserver2 = new AccumulatingObserver();
        this.callable.call("req2", this.watchdog.watch(downstreamObserver2, this.waitTime, this.idleTime));
        MockStreamingApi.MockServerStreamingCall<String, String> call2 = this.callable.popLastCall();
        ((StreamController)downstreamObserver2.controller.get()).request(1);
        this.clock.incrementNanoTime(this.waitTime.toNanos());
        call1.getController().getObserver().onResponse((Object)"resp1");
        this.watchdog.run();
        Truth.assertThat((Boolean)call1.getController().isCancelled()).isFalse();
        Truth.assertThat((Boolean)downstreamObserver1.done.isDone()).isFalse();
        Truth.assertThat((Boolean)call2.getController().isCancelled()).isTrue();
        call2.getController().getObserver().onError((Throwable)new CancellationException("User cancelled"));
        Throwable error = null;
        try {
            downstreamObserver2.done.get();
        }
        catch (ExecutionException t) {
            error = t.getCause();
        }
        Truth.assertThat((Throwable)error).isInstanceOf(WatchdogTimeoutException.class);
    }

    static class AccumulatingObserver<T>
    implements ResponseObserver<T> {
        SettableApiFuture<StreamController> controller = SettableApiFuture.create();
        Queue<T> responses = Queues.newLinkedBlockingDeque();
        SettableApiFuture<Void> done = SettableApiFuture.create();

        AccumulatingObserver() {
        }

        public void onStart(StreamController controller) {
            controller.disableAutoInboundFlowControl();
            this.controller.set((Object)controller);
        }

        public void onResponse(T response) {
            this.responses.add(response);
        }

        public void onError(Throwable t) {
            this.done.setException(t);
        }

        public void onComplete() {
            this.done.set(null);
        }
    }
}

