/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.core.ApiClock;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.ListenableFutureToApiFuture;
import com.google.api.gax.core.FakeApiClock;
import com.google.api.gax.core.RecordingScheduler;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.longrunning.OperationFutureImpl;
import com.google.api.gax.longrunning.OperationSnapshot;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.AlreadyExistsException;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.Callables;
import com.google.api.gax.rpc.CancellationHelpers;
import com.google.api.gax.rpc.CancelledException;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.DeadlineExceededException;
import com.google.api.gax.rpc.FailedPreconditionException;
import com.google.api.gax.rpc.LatchCountDownScheduler;
import com.google.api.gax.rpc.LongRunningClient;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.OperationCallableImpl;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.gax.rpc.UnavailableException;
import com.google.api.gax.rpc.UnknownException;
import com.google.api.gax.rpc.testing.FakeCallContext;
import com.google.api.gax.rpc.testing.FakeCallableFactory;
import com.google.api.gax.rpc.testing.FakeChannel;
import com.google.api.gax.rpc.testing.FakeOperationApi;
import com.google.api.gax.rpc.testing.FakeOperationSnapshot;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.api.gax.rpc.testing.FakeTransportChannel;
import com.google.auth.Credentials;
import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.Futures;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Currency;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.LockSupport;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class OperationCallableImplTest {
    private static final RetrySettings FAST_RETRY_SETTINGS = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)2L)).setRetryDelayMultiplier(1.0).setMaxRetryDelay(Duration.ofMillis((long)2L)).setInitialRpcTimeout(Duration.ofMillis((long)2L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)2L)).setTotalTimeout(Duration.ofMillis((long)10L)).build();
    private static final RetrySettings FAST_RECHECKING_SETTINGS = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1L)).setRetryDelayMultiplier(1.0).setMaxRetryDelay(Duration.ofMillis((long)1L)).setInitialRpcTimeout(Duration.ZERO).setMaxAttempts(0).setJittered(false).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)5L)).build();
    private FakeChannel initialChannel;
    private TransportChannel pollTransportChannel;
    private RecordingScheduler executor;
    private ClientContext initialContext;
    private OperationCallSettings<Integer, Color, Currency> callSettings;
    private FakeApiClock clock;
    private OperationTimedPollAlgorithm pollingAlgorithm;

    @Before
    public void setUp() throws IOException {
        this.initialChannel = (FakeChannel)Mockito.mock(FakeChannel.class);
        this.pollTransportChannel = (TransportChannel)Mockito.mock(TransportChannel.class);
        TransportChannelProvider operationsChannelProvider = (TransportChannelProvider)Mockito.mock(TransportChannelProvider.class);
        Mockito.when((Object)operationsChannelProvider.getTransportChannel()).thenReturn((Object)this.pollTransportChannel);
        this.clock = new FakeApiClock(0L);
        this.executor = RecordingScheduler.create(this.clock);
        this.pollingAlgorithm = OperationTimedPollAlgorithm.create((RetrySettings)FAST_RECHECKING_SETTINGS, (ApiClock)this.clock);
        UnaryCallSettings initialCallSettings = UnaryCallSettings.newUnaryCallSettingsBuilder().setRetrySettings(FAST_RETRY_SETTINGS.toBuilder().setMaxAttempts(1).build()).build();
        this.callSettings = OperationCallSettings.newBuilder().setInitialCallSettings(initialCallSettings).setResponseTransformer((ApiFunction)new ResponseTransformer()).setMetadataTransformer((ApiFunction)new MetadataTransformer()).setPollingAlgorithm((TimedRetryAlgorithm)this.pollingAlgorithm).build();
        this.initialContext = this.getClientContext(this.initialChannel, this.executor);
    }

    @After
    public void tearDown() throws Exception {
        this.executor.shutdown();
    }

    @Test
    public void testCall() {
        Color resp = this.getColor(1.0f);
        Currency meta = Currency.getInstance("UAH");
        OperationSnapshot resultOperation = this.getOperation("testCall", resp, null, meta, true);
        UnaryCallable initialCallable = this.mockGetOpSnapshotCallable(StatusCode.Code.OK, resultOperation);
        UnsupportedOperationApi longRunningClient = new UnsupportedOperationApi();
        OperationCallable<Integer, Color, Currency> callable = FakeCallableFactory.createOperationCallable(initialCallable, this.callSettings, this.initialContext, longRunningClient);
        Color response = (Color)callable.call((Object)2, (ApiCallContext)FakeCallContext.createDefault());
        Truth.assertThat((Object)response).isEqualTo((Object)resp);
        Truth.assertThat((Integer)this.executor.getIterationsCount()).isEqualTo((Object)0);
    }

    @Test
    public void testResumeFutureCall() throws Exception {
        String opName = "testResumeFutureCall";
        Color resp = this.getColor(0.5f);
        Currency meta = Currency.getInstance("UAH");
        OperationSnapshot resultOperation = this.getOperation(opName, resp, null, meta, true);
        LongRunningClient longRunningClient = this.mockGetOperation(StatusCode.Code.OK, resultOperation);
        ClientContext mockContext = this.getClientContext(new FakeChannel(), this.executor);
        OperationCallable<Integer, Color, Currency> callable = FakeCallableFactory.createOperationCallable(this.getUnexpectedStartCallable(), this.callSettings, mockContext, longRunningClient);
        OperationFuture future = callable.resumeFutureCall(opName);
        this.assertFutureSuccessMetaSuccess(opName, (OperationFuture<Color, Currency>)future, resp, meta);
        Truth.assertThat((Integer)this.executor.getIterationsCount()).isEqualTo((Object)0);
    }

    @Test
    public void testCancelOperation() throws Exception {
        String opName = "testCancelOperation";
        LongRunningClient longRunningClient = this.mockCancelOperation(StatusCode.Code.OK);
        ClientContext mockContext = this.getClientContext(new FakeChannel(), this.executor);
        OperationCallable<Integer, Color, Currency> callable = FakeCallableFactory.createOperationCallable(this.getUnexpectedStartCallable(), this.callSettings, mockContext, longRunningClient);
        ApiFuture future = callable.cancel(opName);
        Truth.assertThat((Object)future.get()).isNull();
    }

    @Test
    public void testFutureCallInitialDone() throws Exception {
        String opName = "testFutureCallInitialDone";
        Color resp = this.getColor(0.5f);
        Currency meta = Currency.getInstance("UAH");
        OperationSnapshot resultOperation = this.getOperation(opName, resp, null, meta, true);
        UnaryCallable initialCallable = this.mockGetOpSnapshotCallable(StatusCode.Code.OK, resultOperation);
        UnsupportedOperationApi longRunningClient = new UnsupportedOperationApi();
        OperationCallable<Integer, Color, Currency> callable = FakeCallableFactory.createOperationCallable(initialCallable, this.callSettings, this.initialContext, longRunningClient);
        OperationFuture future = callable.futureCall((Object)2, (ApiCallContext)FakeCallContext.createDefault());
        this.assertFutureSuccessMetaSuccess(opName, (OperationFuture<Color, Currency>)future, resp, meta);
        Truth.assertThat((Integer)this.executor.getIterationsCount()).isEqualTo((Object)0);
    }

    @Test
    public void testFutureCallInitialError() throws Exception {
        String opName = "testFutureCallInitialError";
        Color resp = this.getColor(1.0f);
        Currency meta = Currency.getInstance("UAH");
        OperationSnapshot resultOperation = this.getOperation(opName, resp, null, meta, true);
        UnaryCallable initialCallable = this.mockGetOpSnapshotCallable(StatusCode.Code.UNAVAILABLE, resultOperation);
        UnsupportedOperationApi longRunningClient = new UnsupportedOperationApi();
        OperationCallable<Integer, Color, Currency> callable = FakeCallableFactory.createOperationCallable(initialCallable, this.callSettings, this.initialContext, longRunningClient);
        OperationFuture future = callable.futureCall((Object)2, (ApiCallContext)FakeCallContext.createDefault());
        this.assertFutureFailMetaFail((OperationFuture<Color, Currency>)future, null, FakeStatusCode.of(StatusCode.Code.UNAVAILABLE));
        Truth.assertThat((Integer)this.executor.getIterationsCount()).isEqualTo((Object)0);
    }

    @Test
    public void testFutureCallInitialDoneWithError() throws Exception {
        String opName = "testFutureCallInitialDoneWithError";
        FakeStatusCode errorCode = FakeStatusCode.of(StatusCode.Code.ALREADY_EXISTS);
        Currency meta = Currency.getInstance("UAH");
        OperationSnapshot resultOperation = this.getOperation(opName, null, errorCode, meta, true, "Already exists error");
        UnaryCallable initialCallable = this.mockGetOpSnapshotCallable(StatusCode.Code.OK, resultOperation);
        UnsupportedOperationApi longRunningClient = new UnsupportedOperationApi();
        OperationCallable<Integer, Color, Currency> callable = FakeCallableFactory.createOperationCallable(initialCallable, this.callSettings, this.initialContext, longRunningClient);
        OperationFuture future = callable.futureCall((Object)2, (ApiCallContext)FakeCallContext.createDefault());
        String errorMessage = "Operation with name \"" + opName + "\" failed with status = " + errorCode + " and message = Already exists error";
        this.assertFutureFailMetaSuccess((OperationFuture<Color, Currency>)future, meta, FakeStatusCode.of(StatusCode.Code.ALREADY_EXISTS), errorMessage);
        Truth.assertThat((Integer)this.executor.getIterationsCount()).isEqualTo((Object)0);
    }

    @Test
    public void testFutureCallInitialDoneWrongType() throws Exception {
        String opName = "testFutureCallInitialDoneWrongType";
        Currency resp = Currency.getInstance("USD");
        Currency meta = Currency.getInstance("UAH");
        OperationSnapshot resultOperation = this.getOperation(opName, resp, null, meta, true);
        UnaryCallable initialCallable = this.mockGetOpSnapshotCallable(StatusCode.Code.OK, resultOperation);
        UnsupportedOperationApi longRunningClient = new UnsupportedOperationApi();
        OperationCallable<Integer, Color, Currency> callable = FakeCallableFactory.createOperationCallable(initialCallable, this.callSettings, this.initialContext, longRunningClient);
        OperationFuture future = callable.futureCall((Object)2, (ApiCallContext)FakeCallContext.createDefault());
        this.assertFutureFailMetaSuccess((OperationFuture<Color, Currency>)future, meta, FakeStatusCode.of(StatusCode.Code.OK), "type mismatch: expected java.awt.Color, found java.util.Currency");
        Truth.assertThat((Integer)this.executor.getIterationsCount()).isEqualTo((Object)0);
    }

    @Test
    public void testFutureCallInitialDoneMetaWrongType() throws Exception {
        String opName = "testFutureCallInitialDoneMetaWrongType";
        Color resp = this.getColor(1.0f);
        Color meta = this.getColor(1.0f);
        OperationSnapshot resultOperation = this.getOperation(opName, resp, null, meta, true);
        UnaryCallable initialCallable = this.mockGetOpSnapshotCallable(StatusCode.Code.OK, resultOperation);
        UnsupportedOperationApi longRunningClient = new UnsupportedOperationApi();
        OperationCallable<Integer, Color, Currency> callable = FakeCallableFactory.createOperationCallable(initialCallable, this.callSettings, this.initialContext, longRunningClient);
        OperationFuture future = callable.futureCall((Object)2, (ApiCallContext)FakeCallContext.createDefault());
        this.assertFutureSuccessMetaFail((OperationFuture<Color, Currency>)future, resp, FakeStatusCode.of(StatusCode.Code.OK));
        Truth.assertThat((Integer)this.executor.getIterationsCount()).isEqualTo((Object)0);
    }

    @Test
    public void testFutureCallInitialCancel() throws Exception {
        String opName = "testFutureCallInitialCancel";
        OperationSnapshot initialOperation = this.getOperation(opName, null, null, null, false);
        OperationSnapshot resultOperation = this.getOperation(opName, null, null, null, false);
        UnaryCallable initialCallable = this.mockGetOpSnapshotCallable(StatusCode.Code.OK, initialOperation);
        LongRunningClient longRunningClient = this.mockGetOperation(StatusCode.Code.OK, resultOperation);
        OperationCallableImpl callableImpl = Callables.longRunningOperationImpl(initialCallable, this.callSettings, (ClientContext)this.initialContext, (LongRunningClient)longRunningClient);
        OperationFutureImpl future = callableImpl.futureCall((ApiFuture)new ListenableFutureToApiFuture(Futures.immediateCancelledFuture()), (ApiCallContext)FakeCallContext.createDefault());
        CancellationException exception = null;
        try {
            future.get(3L, TimeUnit.SECONDS);
        }
        catch (CancellationException e) {
            exception = e;
        }
        Truth.assertThat((Throwable)exception).isNotNull();
        Truth.assertThat((Boolean)future.isDone()).isTrue();
        Truth.assertThat((Boolean)future.isCancelled()).isTrue();
        Truth.assertThat((Boolean)future.getInitialFuture().isDone()).isTrue();
        Truth.assertThat((Boolean)future.getInitialFuture().isCancelled()).isTrue();
        this.assertFutureCancelMetaCancel((OperationFuture<Color, Currency>)future);
        Truth.assertThat((Integer)this.executor.getIterationsCount()).isEqualTo((Object)0);
    }

    @Test
    public void testFutureCallInitialOperationUnexpectedFail() throws Exception {
        String opName = "testFutureCallInitialOperationUnexpectedFail";
        OperationSnapshot initialOperation = this.getOperation(opName, null, null, null, false);
        OperationSnapshot resultOperation = this.getOperation(opName, null, null, null, false);
        UnaryCallable initialCallable = this.mockGetOpSnapshotCallable(StatusCode.Code.OK, initialOperation);
        LongRunningClient longRunningClient = this.mockGetOperation(StatusCode.Code.OK, resultOperation);
        OperationCallableImpl callableImpl = Callables.longRunningOperationImpl(initialCallable, this.callSettings, (ClientContext)this.initialContext, (LongRunningClient)longRunningClient);
        RuntimeException thrownException = new RuntimeException();
        ApiFuture initialFuture = ApiFutures.immediateFailedFuture((Throwable)thrownException);
        OperationFutureImpl future = callableImpl.futureCall(initialFuture, (ApiCallContext)FakeCallContext.createDefault());
        this.assertFutureFailMetaFail((OperationFuture<Color, Currency>)future, RuntimeException.class, null);
        Truth.assertThat((Integer)this.executor.getIterationsCount()).isEqualTo((Object)0);
    }

    @Test
    public void testFutureCallPollDoneOnFirst() throws Exception {
        String opName = "testFutureCallPollDoneOnFirst";
        Color resp = this.getColor(0.5f);
        Currency meta = Currency.getInstance("UAH");
        OperationSnapshot initialOperation = this.getOperation(opName, null, null, null, false);
        OperationSnapshot resultOperation = this.getOperation(opName, resp, null, meta, true);
        UnaryCallable initialCallable = this.mockGetOpSnapshotCallable(StatusCode.Code.OK, initialOperation);
        LongRunningClient longRunningClient = this.mockGetOperation(StatusCode.Code.OK, resultOperation);
        OperationCallable<Integer, Color, Currency> callable = FakeCallableFactory.createOperationCallable(initialCallable, this.callSettings, this.initialContext, longRunningClient);
        OperationFuture future = callable.futureCall((Object)2, (ApiCallContext)FakeCallContext.createDefault());
        this.assertFutureSuccessMetaSuccess(opName, (OperationFuture<Color, Currency>)future, resp, meta);
        Truth.assertThat((Integer)this.executor.getIterationsCount()).isEqualTo((Object)0);
    }

    @Test
    public void testFutureCallPollDoneOnSecond() throws Exception {
        String opName = "testFutureCallPollDoneOnSecond";
        Color resp = this.getColor(0.5f);
        Currency meta1 = Currency.getInstance("UAH");
        Currency meta2 = Currency.getInstance("USD");
        OperationSnapshot initialOperation = this.getOperation(opName, null, null, null, false);
        OperationSnapshot resultOperation1 = this.getOperation(opName, null, null, meta1, false);
        OperationSnapshot resultOperation2 = this.getOperation(opName, resp, null, meta2, true);
        UnaryCallable initialCallable = this.mockGetOpSnapshotCallable(StatusCode.Code.OK, initialOperation);
        LongRunningClient longRunningClient = this.mockGetOperation(StatusCode.Code.OK, resultOperation1, resultOperation2);
        OperationCallable<Integer, Color, Currency> callable = FakeCallableFactory.createOperationCallable(initialCallable, this.callSettings, this.initialContext, longRunningClient);
        OperationFuture future = callable.futureCall((Object)2, (ApiCallContext)FakeCallContext.createDefault());
        this.assertFutureSuccessMetaSuccess(opName, (OperationFuture<Color, Currency>)future, resp, meta2);
        Truth.assertThat((Integer)this.executor.getIterationsCount()).isEqualTo((Object)1);
    }

    @Test
    public void testFutureCallPollRPCTimeout() throws Exception {
        String opName = "testFutureCallPollRPCTimeout";
        this.pollingAlgorithm = OperationTimedPollAlgorithm.create((RetrySettings)FAST_RECHECKING_SETTINGS.toBuilder().setInitialRpcTimeout(Duration.ofMillis((long)100L)).setMaxRpcTimeout(Duration.ofSeconds((long)1L)).setRpcTimeoutMultiplier(2.0).build(), (ApiClock)this.clock);
        this.callSettings = this.callSettings.toBuilder().setPollingAlgorithm((TimedRetryAlgorithm)this.pollingAlgorithm).build();
        Color resp = this.getColor(0.5f);
        Currency meta1 = Currency.getInstance("UAH");
        Currency meta2 = Currency.getInstance("USD");
        OperationSnapshot initialOperation = this.getOperation(opName, null, null, null, false);
        OperationSnapshot resultOperation1 = this.getOperation(opName, null, null, meta1, false);
        OperationSnapshot resultOperation2 = this.getOperation(opName, null, null, meta1, false);
        OperationSnapshot resultOperation3 = this.getOperation(opName, resp, null, meta2, true);
        UnaryCallable initialCallable = this.mockGetOpSnapshotCallable(StatusCode.Code.OK, initialOperation);
        LongRunningClient longRunningClient = (LongRunningClient)Mockito.mock(LongRunningClient.class);
        UnaryCallable getOpCallable = (UnaryCallable)Mockito.mock(UnaryCallable.class);
        ArgumentCaptor callContextCaptor = ArgumentCaptor.forClass(ApiCallContext.class);
        Mockito.when((Object)longRunningClient.getOperationCallable()).thenReturn((Object)getOpCallable);
        Mockito.when((Object)getOpCallable.futureCall(Mockito.any(), (ApiCallContext)callContextCaptor.capture())).thenReturn((Object)ApiFutures.immediateFuture((Object)resultOperation1)).thenReturn((Object)ApiFutures.immediateFuture((Object)resultOperation2)).thenReturn((Object)ApiFutures.immediateFuture((Object)resultOperation3));
        OperationCallable<Integer, Color, Currency> callable = FakeCallableFactory.createOperationCallable(initialCallable, this.callSettings, this.initialContext, longRunningClient);
        callable.futureCall((Object)2, (ApiCallContext)FakeCallContext.createDefault()).get(10L, TimeUnit.SECONDS);
        ArrayList actualTimeouts = Lists.newArrayList();
        for (ApiCallContext callContext : callContextCaptor.getAllValues()) {
            actualTimeouts.add(callContext.getTimeout());
        }
        ArrayList expectedTimeouts = Lists.newArrayList((Object[])new Duration[]{Duration.ofMillis((long)100L), Duration.ofMillis((long)200L), Duration.ofMillis((long)400L)});
        Truth.assertThat((Iterable)actualTimeouts).isEqualTo((Object)expectedTimeouts);
    }

    @Test
    public void testFutureCallContextPropagation() throws Exception {
        String opName = "testFutureCallContextPropagation";
        Color resp = this.getColor(0.5f);
        Currency meta1 = Currency.getInstance("UAH");
        Currency meta2 = Currency.getInstance("USD");
        OperationSnapshot initialOperation = this.getOperation(opName, null, null, null, false);
        OperationSnapshot resultOperation = this.getOperation(opName, resp, null, meta2, true);
        UnaryCallable initialCallable = this.mockGetOpSnapshotCallable(StatusCode.Code.OK, initialOperation);
        LongRunningClient longRunningClient = (LongRunningClient)Mockito.mock(LongRunningClient.class);
        UnaryCallable getOpCallable = (UnaryCallable)Mockito.mock(UnaryCallable.class);
        ArgumentCaptor callContextCaptor = ArgumentCaptor.forClass(ApiCallContext.class);
        Mockito.when((Object)longRunningClient.getOperationCallable()).thenReturn((Object)getOpCallable);
        Mockito.when((Object)getOpCallable.futureCall(Mockito.any(), (ApiCallContext)callContextCaptor.capture())).thenReturn((Object)ApiFutures.immediateFuture((Object)resultOperation));
        OperationCallable<Integer, Color, Currency> callable = FakeCallableFactory.createOperationCallable(initialCallable, this.callSettings, this.initialContext, longRunningClient);
        FakeCallContext callContext = FakeCallContext.createDefault().withTimeout(Duration.ofMillis((long)10L));
        callable.futureCall((Object)2, (ApiCallContext)callContext).get(10L, TimeUnit.SECONDS);
        Truth.assertThat((Comparable)((ApiCallContext)callContextCaptor.getValue()).getTimeout()).isEqualTo((Object)Duration.ofMillis((long)10L));
    }

    @Test
    public void testFutureCallPollDoneOnMany() throws Exception {
        int iterationsCount = 1000;
        String opName = "testFutureCallPollDoneOnMany";
        Color resp = this.getColor(0.5f);
        Currency meta = Currency.getInstance("UAH");
        OperationSnapshot initialOperation = this.getOperation(opName, null, null, null, false);
        OperationSnapshot[] pollOperations = new OperationSnapshot[1000];
        for (int i = 0; i < 999; ++i) {
            pollOperations[i] = this.getOperation(opName, null, null, meta, false);
        }
        pollOperations[999] = this.getOperation(opName, resp, null, meta, true);
        UnaryCallable initialCallable = this.mockGetOpSnapshotCallable(StatusCode.Code.OK, initialOperation);
        LongRunningClient longRunningClient = this.mockGetOperation(StatusCode.Code.OK, pollOperations);
        this.pollingAlgorithm = OperationTimedPollAlgorithm.create((RetrySettings)FAST_RECHECKING_SETTINGS.toBuilder().setTotalTimeout(Duration.ofMillis((long)1000L)).build(), (ApiClock)this.clock);
        this.callSettings = this.callSettings.toBuilder().setPollingAlgorithm((TimedRetryAlgorithm)this.pollingAlgorithm).build();
        OperationCallable<Integer, Color, Currency> callable = FakeCallableFactory.createOperationCallable(initialCallable, this.callSettings, this.initialContext, longRunningClient);
        OperationFuture future = callable.futureCall((Object)2, (ApiCallContext)FakeCallContext.createDefault());
        Truth.assertThat((Object)future.get(5L, TimeUnit.SECONDS)).isEqualTo((Object)resp);
        this.assertFutureSuccessMetaSuccess(opName, (OperationFuture<Color, Currency>)future, resp, meta);
        Truth.assertThat((Integer)this.executor.getIterationsCount()).isEqualTo((Object)999);
    }

    @Test
    public void testFutureCallPollError() throws Exception {
        String opName = "testFutureCallPollError";
        Currency meta = Currency.getInstance("UAH");
        Color resp = this.getColor(1.0f);
        OperationSnapshot initialOperation = this.getOperation(opName, resp, null, meta, false);
        UnaryCallable initialCallable = this.mockGetOpSnapshotCallable(StatusCode.Code.OK, initialOperation);
        OperationSnapshot resultOperation = this.getOperation(opName, resp, null, meta, false);
        LongRunningClient longRunningClient = this.mockGetOperation(StatusCode.Code.ALREADY_EXISTS, resultOperation);
        OperationCallable<Integer, Color, Currency> callable = FakeCallableFactory.createOperationCallable(initialCallable, this.callSettings, this.initialContext, longRunningClient);
        OperationFuture future = callable.futureCall((Object)2, (ApiCallContext)FakeCallContext.createDefault());
        this.assertFutureFailMetaFail((OperationFuture<Color, Currency>)future, null, FakeStatusCode.of(StatusCode.Code.ALREADY_EXISTS));
        Truth.assertThat((Integer)this.executor.getIterationsCount()).isEqualTo((Object)0);
    }

    @Test
    public void testFutureCallPollDoneWithError() throws Exception {
        String opName = "testFutureCallPollDoneWithError";
        Currency meta = Currency.getInstance("UAH");
        Color resp = this.getColor(1.0f);
        OperationSnapshot initialOperation = this.getOperation(opName, resp, null, meta, false, "Already exists error");
        UnaryCallable initialCallable = this.mockGetOpSnapshotCallable(StatusCode.Code.OK, initialOperation);
        FakeStatusCode errorCode = FakeStatusCode.of(StatusCode.Code.ALREADY_EXISTS);
        OperationSnapshot resultOperation = this.getOperation(opName, null, errorCode, meta, true, "Already exists error");
        LongRunningClient longRunningClient = this.mockGetOperation(StatusCode.Code.OK, resultOperation);
        OperationCallable<Integer, Color, Currency> callable = FakeCallableFactory.createOperationCallable(initialCallable, this.callSettings, this.initialContext, longRunningClient);
        OperationFuture future = callable.futureCall((Object)2, (ApiCallContext)FakeCallContext.createDefault());
        String errorMessage = "Operation with name \"" + opName + "\" failed with status = " + errorCode + " and message = Already exists error";
        this.assertFutureFailMetaSuccess((OperationFuture<Color, Currency>)future, meta, FakeStatusCode.of(StatusCode.Code.ALREADY_EXISTS), errorMessage);
        Truth.assertThat((Integer)this.executor.getIterationsCount()).isEqualTo((Object)0);
    }

    @Test
    public void testFutureCallPollCancelOnTimeoutExceeded() throws Exception {
        String opName = "testFutureCallPollCancelOnPollingTimeoutExceeded";
        OperationSnapshot initialOperation = this.getOperation(opName, null, null, null, false);
        OperationSnapshot resultOperation = this.getOperation(opName, null, null, null, false);
        UnaryCallable initialCallable = this.mockGetOpSnapshotCallable(StatusCode.Code.OK, initialOperation);
        LongRunningClient longRunningClient = this.mockGetOperation(StatusCode.Code.OK, resultOperation);
        OperationCallable<Integer, Color, Currency> callable = FakeCallableFactory.createOperationCallable(initialCallable, this.callSettings, this.initialContext, longRunningClient);
        OperationFuture future = callable.futureCall((Object)2, (ApiCallContext)FakeCallContext.createDefault());
        this.assertFutureCancelMetaCancel((OperationFuture<Color, Currency>)future);
        Truth.assertThat((Integer)this.executor.getIterationsCount()).isEqualTo((Object)5);
    }

    @Test
    public void testFutureCallPollCancelOnLongTimeoutExceeded() throws Exception {
        int iterationsCount = 1000;
        String opName = "testFutureCallPollCancelOnLongTimeoutExceeded";
        OperationSnapshot initialOperation = this.getOperation(opName, null, null, null, false);
        OperationSnapshot[] pollOperations = new OperationSnapshot[1000];
        for (int i = 0; i < 1000; ++i) {
            pollOperations[i] = this.getOperation(opName, null, null, null, false);
        }
        UnaryCallable initialCallable = this.mockGetOpSnapshotCallable(StatusCode.Code.OK, initialOperation);
        LongRunningClient longRunningClient = this.mockGetOperation(StatusCode.Code.OK, pollOperations);
        this.pollingAlgorithm = OperationTimedPollAlgorithm.create((RetrySettings)FAST_RECHECKING_SETTINGS.toBuilder().setTotalTimeout(Duration.ofMillis((long)1000L)).build(), (ApiClock)this.clock);
        this.callSettings = this.callSettings.toBuilder().setPollingAlgorithm((TimedRetryAlgorithm)this.pollingAlgorithm).build();
        OperationCallable<Integer, Color, Currency> callable = FakeCallableFactory.createOperationCallable(initialCallable, this.callSettings, this.initialContext, longRunningClient);
        OperationFuture future = callable.futureCall((Object)2, (ApiCallContext)FakeCallContext.createDefault());
        this.assertFutureCancelMetaCancel((OperationFuture<Color, Currency>)future);
        Truth.assertThat((Integer)this.executor.getIterationsCount()).isEqualTo((Object)1000);
    }

    @Test
    public void testFutureCancelImmediately() throws Exception {
        int iterationsCount = 3;
        String opName = "testCancelImmediately";
        Color resp = this.getColor(0.5f);
        Currency meta = Currency.getInstance("UAH");
        OperationSnapshot initialOperation = this.getOperation(opName, null, null, null, false);
        UnaryCallable initialCallable = this.mockGetOpSnapshotCallable(StatusCode.Code.OK, initialOperation);
        OperationSnapshot[] pollOperations = new OperationSnapshot[iterationsCount];
        for (int i = 0; i < iterationsCount; ++i) {
            pollOperations[i] = this.getOperation(opName, null, null, null, false);
        }
        pollOperations[iterationsCount - 1] = this.getOperation(opName, resp, null, meta, true);
        LongRunningClient longRunningClient = this.mockGetOperation(StatusCode.Code.OK, pollOperations);
        CountDownLatch retryScheduledLatch = new CountDownLatch(1);
        LatchCountDownScheduler scheduler = LatchCountDownScheduler.get(retryScheduledLatch, 0L, 20L);
        ClientContext schedulerContext = this.getClientContext(this.initialChannel, scheduler);
        OperationCallable<Integer, Color, Currency> callable = FakeCallableFactory.createOperationCallable(initialCallable, this.callSettings, schedulerContext, longRunningClient);
        OperationFuture future = callable.futureCall((Object)2, (ApiCallContext)FakeCallContext.createDefault());
        while (!future.cancel(true) && !future.isDone()) {
            LockSupport.parkNanos(1000L);
        }
        this.assertFutureCancelMetaCancel((OperationFuture<Color, Currency>)future);
        scheduler.shutdownNow();
    }

    @Test
    public void testFutureCancelInTheMiddle() throws Exception {
        int iterationsCount = 1000;
        String opName = "testCancelInTheMiddle";
        Color resp = this.getColor(0.5f);
        Currency meta = Currency.getInstance("UAH");
        OperationSnapshot resultOperation = this.getOperation(opName, null, null, null, false);
        UnaryCallable initialCallable = this.mockGetOpSnapshotCallable(StatusCode.Code.OK, resultOperation);
        OperationSnapshot[] pollOperations = new OperationSnapshot[iterationsCount];
        for (int i = 0; i < iterationsCount - 1; ++i) {
            pollOperations[i] = this.getOperation(opName, null, null, null, false);
        }
        pollOperations[iterationsCount - 1] = this.getOperation(opName, resp, null, meta, true);
        LongRunningClient longRunningClient = this.mockGetOperation(StatusCode.Code.OK, pollOperations);
        CountDownLatch retryScheduledLatch = new CountDownLatch(10);
        LatchCountDownScheduler scheduler = LatchCountDownScheduler.get(retryScheduledLatch, 0L, 1L);
        ClientContext schedulerContext = this.getClientContext(this.initialChannel, scheduler);
        OperationCallable<Integer, Color, Currency> callable = FakeCallableFactory.createOperationCallable(initialCallable, this.callSettings, schedulerContext, longRunningClient);
        OperationFuture future = callable.futureCall((Object)2, (ApiCallContext)FakeCallContext.createDefault());
        CancellationHelpers.cancelInThreadAfterLatchCountDown(future, retryScheduledLatch);
        this.assertFutureCancelMetaCancel((OperationFuture<Color, Currency>)future);
    }

    @Test
    public void testInitialServerSideCancel() throws Exception {
        String opName = "testInitialServerSideCancel";
        FakeStatusCode errorCode = FakeStatusCode.of(StatusCode.Code.CANCELLED);
        Currency meta = Currency.getInstance("UAH");
        OperationSnapshot resultOperation = this.getOperation(opName, null, errorCode, meta, true);
        UnaryCallable initialCallable = this.mockGetOpSnapshotCallable(StatusCode.Code.OK, resultOperation);
        UnsupportedOperationApi longRunningClient = new UnsupportedOperationApi();
        OperationCallable<Integer, Color, Currency> callable = FakeCallableFactory.createOperationCallable(initialCallable, this.callSettings, this.initialContext, longRunningClient);
        OperationFuture future = callable.futureCall((Object)2, (ApiCallContext)FakeCallContext.createDefault());
        String errorMessage = "Operation with name \"" + opName + "\" failed with status = " + errorCode + " and message = null";
        this.assertFutureFailMetaSuccess((OperationFuture<Color, Currency>)future, meta, FakeStatusCode.of(StatusCode.Code.CANCELLED), errorMessage);
        Truth.assertThat((Integer)this.executor.getIterationsCount()).isEqualTo((Object)0);
    }

    @Test
    public void testPollServerSideCancel() throws Exception {
        String opName = "testPollServerSideCancel";
        FakeStatusCode errorCode = FakeStatusCode.of(StatusCode.Code.CANCELLED);
        Currency meta = Currency.getInstance("UAH");
        OperationSnapshot initialOperation = this.getOperation(opName, null, null, meta, false);
        UnaryCallable initialCallable = this.mockGetOpSnapshotCallable(StatusCode.Code.OK, initialOperation);
        OperationSnapshot resultOperation1 = this.getOperation(opName, null, null, null, false);
        OperationSnapshot resultOperation2 = this.getOperation(opName, null, errorCode, meta, true);
        LongRunningClient longRunningClient = this.mockGetOperation(StatusCode.Code.OK, resultOperation1, resultOperation2);
        OperationCallable<Integer, Color, Currency> callable = FakeCallableFactory.createOperationCallable(initialCallable, this.callSettings, this.initialContext, longRunningClient);
        OperationFuture future = callable.futureCall((Object)2, (ApiCallContext)FakeCallContext.createDefault());
        String errorMessage = "Operation with name \"" + opName + "\" failed with status = " + errorCode + " and message = null";
        this.assertFutureFailMetaSuccess((OperationFuture<Color, Currency>)future, meta, FakeStatusCode.of(StatusCode.Code.CANCELLED), errorMessage);
        Truth.assertThat((Integer)this.executor.getIterationsCount()).isEqualTo((Object)1);
    }

    @Test
    public void call() throws Exception {
        FakeCallContext defaultCallContext = FakeCallContext.createDefault();
        FakeOperationApi.OperationStashCallable stashCallable = new FakeOperationApi.OperationStashCallable();
        OperationCallable callable = stashCallable.withDefaultCallContext(defaultCallContext);
        String response = (String)callable.call((Object)1);
        Truth.assertThat((String)response).isEqualTo((Object)"1");
        Truth.assertThat((Object)stashCallable.getContext()).isSameInstanceAs((Object)defaultCallContext);
    }

    @Test
    public void callWithContext() throws Exception {
        FakeChannel channel = new FakeChannel();
        Credentials credentials = (Credentials)Mockito.mock(Credentials.class);
        FakeCallContext context = FakeCallContext.createDefault().withChannel(channel).withCredentials(credentials);
        FakeOperationApi.OperationStashCallable stashCallable = new FakeOperationApi.OperationStashCallable();
        OperationCallable callable = stashCallable.withDefaultCallContext(FakeCallContext.createDefault());
        String response = (String)callable.call((Object)2, (ApiCallContext)context);
        Truth.assertThat((String)response).isEqualTo((Object)"2");
        FakeCallContext actualContext = (FakeCallContext)stashCallable.getContext();
        Truth.assertThat((Object)actualContext.getChannel()).isSameInstanceAs((Object)channel);
        Truth.assertThat((Object)actualContext.getCredentials()).isSameInstanceAs((Object)credentials);
    }

    @Test
    public void callResume() throws Exception {
        FakeCallContext defaultCallContext = FakeCallContext.createDefault();
        FakeOperationApi.OperationStashCallable stashCallable = new FakeOperationApi.OperationStashCallable();
        OperationCallable callable = stashCallable.withDefaultCallContext(defaultCallContext);
        OperationFuture operationFuture = callable.futureCall((Object)45);
        String response = (String)callable.resumeFutureCall(operationFuture.getName()).get();
        Truth.assertThat((String)response).isEqualTo((Object)"45");
        Truth.assertThat((Object)stashCallable.getResumeContext()).isSameInstanceAs((Object)defaultCallContext);
    }

    @Test
    public void callResumeWithContext() throws Exception {
        FakeChannel channel = new FakeChannel();
        Credentials credentials = (Credentials)Mockito.mock(Credentials.class);
        FakeCallContext context = FakeCallContext.createDefault().withChannel(channel).withCredentials(credentials);
        FakeOperationApi.OperationStashCallable stashCallable = new FakeOperationApi.OperationStashCallable();
        OperationCallable callable = stashCallable.withDefaultCallContext(FakeCallContext.createDefault());
        OperationFuture operationFuture = callable.futureCall((Object)45);
        String response = (String)callable.resumeFutureCall(operationFuture.getName(), (ApiCallContext)context).get();
        Truth.assertThat((String)response).isEqualTo((Object)"45");
        FakeCallContext actualContext = (FakeCallContext)stashCallable.getResumeContext();
        Truth.assertThat((Object)actualContext.getChannel()).isSameInstanceAs((Object)channel);
        Truth.assertThat((Object)actualContext.getCredentials()).isSameInstanceAs((Object)credentials);
    }

    @Test
    public void callCancel() throws Exception {
        FakeCallContext defaultCallContext = FakeCallContext.createDefault();
        FakeOperationApi.OperationStashCallable stashCallable = new FakeOperationApi.OperationStashCallable();
        OperationCallable callable = stashCallable.withDefaultCallContext(defaultCallContext);
        OperationFuture operationFuture = callable.futureCall((Object)45);
        callable.cancel(operationFuture.getName()).get();
        Truth.assertThat((Boolean)stashCallable.wasCancelCalled()).isTrue();
        Truth.assertThat((Object)stashCallable.getCancelContext()).isSameInstanceAs((Object)defaultCallContext);
    }

    @Test
    public void callCancelWithContext() throws Exception {
        FakeChannel channel = new FakeChannel();
        Credentials credentials = (Credentials)Mockito.mock(Credentials.class);
        FakeCallContext context = FakeCallContext.createDefault().withChannel(channel).withCredentials(credentials);
        FakeOperationApi.OperationStashCallable stashCallable = new FakeOperationApi.OperationStashCallable();
        OperationCallable callable = stashCallable.withDefaultCallContext(FakeCallContext.createDefault());
        OperationFuture operationFuture = callable.futureCall((Object)45);
        callable.cancel(operationFuture.getName(), (ApiCallContext)context).get();
        Truth.assertThat((Boolean)stashCallable.wasCancelCalled()).isTrue();
        FakeCallContext actualContext = (FakeCallContext)stashCallable.getCancelContext();
        Truth.assertThat((Object)actualContext.getChannel()).isSameInstanceAs((Object)channel);
        Truth.assertThat((Object)actualContext.getCredentials()).isSameInstanceAs((Object)credentials);
    }

    private void assertFutureSuccessMetaSuccess(String opName, OperationFuture<Color, Currency> future, Color resp, Currency meta) throws InterruptedException, ExecutionException, TimeoutException {
        Truth.assertThat((String)future.getName()).isEqualTo((Object)opName);
        Truth.assertThat((Object)future.get(3L, TimeUnit.SECONDS)).isEqualTo((Object)resp);
        Truth.assertThat((Boolean)future.isDone()).isTrue();
        Truth.assertThat((Boolean)future.isCancelled()).isFalse();
        Truth.assertThat((Object)future.get()).isEqualTo((Object)resp);
        Truth.assertThat((Object)future.peekMetadata().get()).isEqualTo((Object)meta);
        Truth.assertThat((Object)future.peekMetadata()).isSameInstanceAs((Object)future.peekMetadata());
        Truth.assertThat((Boolean)future.peekMetadata().isDone()).isTrue();
        Truth.assertThat((Boolean)future.peekMetadata().isCancelled()).isFalse();
        Truth.assertThat((Object)future.getMetadata().get()).isEqualTo((Object)meta);
        Truth.assertThat((Object)future.getMetadata()).isSameInstanceAs((Object)future.getMetadata());
        Truth.assertThat((Boolean)future.getMetadata().isDone()).isTrue();
        Truth.assertThat((Boolean)future.getMetadata().isCancelled()).isFalse();
    }

    private void assertFutureFailMetaFail(OperationFuture<Color, Currency> future, Class<? extends Exception> exceptionClass, FakeStatusCode statusCode) throws TimeoutException, InterruptedException {
        ApiException cause;
        ExecutionException exception = null;
        try {
            future.get(3L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            exception = e;
        }
        Truth.assertThat((Throwable)exception).isNotNull();
        if (statusCode != null) {
            this.assertExceptionMatchesCode(statusCode, exception.getCause());
            cause = (ApiException)exception.getCause();
            Truth.assertThat((Object)cause.getStatusCode()).isEqualTo((Object)statusCode);
        } else {
            Truth.assertThat(exception.getCause().getClass()).isEqualTo(exceptionClass);
        }
        Truth.assertThat((Boolean)future.isDone()).isTrue();
        Truth.assertThat((Boolean)future.isCancelled()).isFalse();
        try {
            future.peekMetadata().get(3L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            exception = e;
        }
        Truth.assertThat((Throwable)exception).isNotNull();
        if (statusCode != null) {
            this.assertExceptionMatchesCode(statusCode, exception.getCause());
            cause = (ApiException)exception.getCause();
            Truth.assertThat((Object)cause.getStatusCode()).isEqualTo((Object)statusCode);
        } else {
            Truth.assertThat(exception.getCause().getClass()).isEqualTo(exceptionClass);
        }
        Truth.assertThat((Object)future.peekMetadata()).isSameInstanceAs((Object)future.peekMetadata());
        Truth.assertThat((Boolean)future.peekMetadata().isDone()).isTrue();
        Truth.assertThat((Boolean)future.peekMetadata().isCancelled()).isFalse();
        try {
            future.getMetadata().get(3L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            exception = e;
        }
        Truth.assertThat((Throwable)exception).isNotNull();
        if (statusCode != null) {
            this.assertExceptionMatchesCode(statusCode, exception.getCause());
            cause = (ApiException)exception.getCause();
            Truth.assertThat((Object)cause.getStatusCode()).isEqualTo((Object)statusCode);
        } else {
            Truth.assertThat(exception.getCause().getClass()).isEqualTo(exceptionClass);
        }
        Truth.assertThat((Object)future.getMetadata()).isSameInstanceAs((Object)future.getMetadata());
        Truth.assertThat((Boolean)future.getMetadata().isDone()).isTrue();
        Truth.assertThat((Boolean)future.getMetadata().isCancelled()).isFalse();
    }

    private void assertFutureFailMetaSuccess(OperationFuture<Color, Currency> future, Currency meta, FakeStatusCode statusCode, String errorMessage) throws TimeoutException, InterruptedException, ExecutionException {
        ExecutionException exception = null;
        try {
            future.get(3L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            exception = e;
        }
        Truth.assertThat((Throwable)exception).isNotNull();
        this.assertExceptionMatchesCode(statusCode, exception.getCause());
        ApiException cause = (ApiException)exception.getCause();
        Truth.assertThat((Object)cause.getStatusCode()).isEqualTo((Object)statusCode);
        Truth.assertThat((String)cause.getMessage()).isEqualTo((Object)errorMessage);
        Truth.assertThat((Boolean)future.isDone()).isTrue();
        Truth.assertThat((Boolean)future.isCancelled()).isFalse();
        Truth.assertThat((Object)future.peekMetadata().get()).isEqualTo((Object)meta);
        Truth.assertThat((Object)future.peekMetadata()).isSameInstanceAs((Object)future.peekMetadata());
        Truth.assertThat((Boolean)future.peekMetadata().isDone()).isTrue();
        Truth.assertThat((Boolean)future.peekMetadata().isCancelled()).isFalse();
        Truth.assertThat((Object)future.getMetadata().get()).isEqualTo((Object)meta);
        Truth.assertThat((Object)future.getMetadata()).isSameInstanceAs((Object)future.getMetadata());
        Truth.assertThat((Boolean)future.getMetadata().isDone()).isTrue();
        Truth.assertThat((Boolean)future.getMetadata().isCancelled()).isFalse();
    }

    private void assertFutureSuccessMetaFail(OperationFuture<Color, Currency> future, Color resp, FakeStatusCode statusCode) throws TimeoutException, InterruptedException, ExecutionException {
        ExecutionException exception = null;
        Truth.assertThat((Object)future.get(3L, TimeUnit.SECONDS)).isEqualTo((Object)resp);
        Truth.assertThat((Boolean)future.isDone()).isTrue();
        Truth.assertThat((Boolean)future.isCancelled()).isFalse();
        Truth.assertThat((Object)future.get()).isEqualTo((Object)resp);
        try {
            future.peekMetadata().get(3L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            exception = e;
        }
        Truth.assertThat((Object)future.peekMetadata()).isSameInstanceAs((Object)future.peekMetadata());
        Truth.assertThat((Throwable)exception).isNotNull();
        this.assertExceptionMatchesCode(statusCode, exception.getCause());
        ApiException cause = (ApiException)exception.getCause();
        Truth.assertThat((Object)cause.getStatusCode()).isEqualTo((Object)statusCode);
        Truth.assertThat((Boolean)future.peekMetadata().isDone()).isTrue();
        Truth.assertThat((Boolean)future.peekMetadata().isCancelled()).isFalse();
        try {
            future.getMetadata().get(3L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            exception = e;
        }
        Truth.assertThat((Object)future.getMetadata()).isSameInstanceAs((Object)future.getMetadata());
        Truth.assertThat((Throwable)exception).isNotNull();
        this.assertExceptionMatchesCode(statusCode, exception.getCause());
        cause = (ApiException)exception.getCause();
        Truth.assertThat((Object)cause.getStatusCode()).isEqualTo((Object)statusCode);
        Truth.assertThat((Boolean)future.getMetadata().isDone()).isTrue();
        Truth.assertThat((Boolean)future.getMetadata().isCancelled()).isFalse();
    }

    private void assertFutureCancelMetaCancel(OperationFuture<Color, Currency> future) throws InterruptedException, ExecutionException, TimeoutException {
        CancellationException exception = null;
        try {
            future.get(3L, TimeUnit.SECONDS);
        }
        catch (CancellationException e) {
            exception = e;
        }
        Truth.assertThat((Throwable)exception).isNotNull();
        Truth.assertThat((Boolean)future.isDone()).isTrue();
        Truth.assertThat((Boolean)future.isCancelled()).isTrue();
        try {
            future.peekMetadata().get();
        }
        catch (CancellationException e) {
            exception = e;
        }
        Truth.assertThat((Object)future.peekMetadata()).isSameInstanceAs((Object)future.peekMetadata());
        Truth.assertThat((Throwable)exception).isNotNull();
        Truth.assertThat((Boolean)future.peekMetadata().isDone()).isTrue();
        Truth.assertThat((Boolean)future.peekMetadata().isCancelled()).isTrue();
        try {
            future.getMetadata().get();
        }
        catch (CancellationException e) {
            exception = e;
        }
        Truth.assertThat((Object)future.getMetadata()).isSameInstanceAs((Object)future.getMetadata());
        Truth.assertThat((Throwable)exception).isNotNull();
        Truth.assertThat((Boolean)future.getMetadata().isDone()).isTrue();
        Truth.assertThat((Boolean)future.getMetadata().isCancelled()).isTrue();
    }

    private Color getColor(float blueValue) {
        return new Color(0.0f, 0.0f, blueValue);
    }

    private ClientContext getClientContext(FakeChannel channel, ScheduledExecutorService executor) {
        return ClientContext.newBuilder().setTransportChannel((TransportChannel)FakeTransportChannel.create(channel)).setExecutor(executor).setDefaultCallContext((ApiCallContext)FakeCallContext.createDefault()).build();
    }

    private OperationSnapshot getOperation(String name, Object response, StatusCode errorCode, Object metadata, boolean done, String errorMessage) {
        FakeOperationSnapshot.Builder builder = FakeOperationSnapshot.newBuilder().setName(name).setDone(done);
        if (response != null) {
            builder.setResponse(response);
        }
        if (errorCode != null) {
            builder.setErrorCode(errorCode);
        } else {
            builder.setErrorCode(FakeStatusCode.of(StatusCode.Code.OK));
        }
        if (metadata != null) {
            builder.setMetadata(metadata);
        }
        if (errorMessage != null) {
            builder.setErrorMessage(errorMessage);
        }
        return builder.build();
    }

    private OperationSnapshot getOperation(String name, Object response, StatusCode errorCode, Object metadata, boolean done) {
        return this.getOperation(name, response, errorCode, metadata, done, null);
    }

    private <RequestT> UnaryCallable<RequestT, OperationSnapshot> mockGetOpSnapshotCallable(final StatusCode.Code returnStatusCode, final OperationSnapshot ... results) {
        return new UnaryCallable<RequestT, OperationSnapshot>(){
            private int index = 0;

            public ApiFuture<OperationSnapshot> futureCall(RequestT request, ApiCallContext context) {
                FakeCallContext fakeCallContext = (FakeCallContext)context;
                if (fakeCallContext != null && fakeCallContext.getTimeout() != null && fakeCallContext.getTimeout().isZero()) {
                    throw new DeadlineExceededException("Invalid timeout of 0 s", null, (StatusCode)FakeStatusCode.of(StatusCode.Code.DEADLINE_EXCEEDED), true);
                }
                OperationSnapshot response = results[this.index];
                if (this.index < results.length - 1) {
                    ++this.index;
                }
                return OperationCallableImplTest.this.newFuture(returnStatusCode, response);
            }
        };
    }

    private UnaryCallable<Integer, OperationSnapshot> getUnexpectedStartCallable() {
        return new UnaryCallable<Integer, OperationSnapshot>(){

            public ApiFuture<OperationSnapshot> futureCall(Integer request, ApiCallContext context) {
                return ApiFutures.immediateFailedFuture((Throwable)new UnsupportedOperationException("Unexpected call to start operation"));
            }
        };
    }

    private LongRunningClient mockGetOperation(final StatusCode.Code returnStatusCode, final OperationSnapshot ... results) {
        return new UnsupportedOperationApi(){
            private UnaryCallable<String, OperationSnapshot> getOperationCallable;
            {
                this.getOperationCallable = OperationCallableImplTest.this.mockGetOpSnapshotCallable(returnStatusCode, results);
            }

            @Override
            public UnaryCallable<String, OperationSnapshot> getOperationCallable() {
                return this.getOperationCallable;
            }
        };
    }

    private LongRunningClient mockCancelOperation(final StatusCode.Code returnStatusCode) {
        return new UnsupportedOperationApi(){
            private UnaryCallable<String, Void> cancelOperationCallable = new UnaryCallable<String, Void>(){

                public ApiFuture<Void> futureCall(String request, ApiCallContext context) {
                    return OperationCallableImplTest.this.newFuture(returnStatusCode, null);
                }
            };

            @Override
            public UnaryCallable<String, Void> cancelOperationCallable() {
                return this.cancelOperationCallable;
            }
        };
    }

    private <ResponseT> ApiFuture<ResponseT> newFuture(StatusCode.Code returnStatusCode, ResponseT response) {
        if (StatusCode.Code.OK.equals((Object)returnStatusCode)) {
            return ApiFutures.immediateFuture(response);
        }
        return ApiFutures.immediateFailedFuture((Throwable)ApiExceptionFactory.createException(null, (StatusCode)FakeStatusCode.of(returnStatusCode), (boolean)false));
    }

    private void assertExceptionMatchesCode(FakeStatusCode code, Throwable exception) {
        Class<CancelledException> expectedClass;
        switch (code.getCode()) {
            case CANCELLED: {
                expectedClass = CancelledException.class;
                break;
            }
            case UNKNOWN: {
                expectedClass = UnknownException.class;
                break;
            }
            case DEADLINE_EXCEEDED: {
                expectedClass = DeadlineExceededException.class;
                break;
            }
            case ALREADY_EXISTS: {
                expectedClass = AlreadyExistsException.class;
                break;
            }
            case FAILED_PRECONDITION: {
                expectedClass = FailedPreconditionException.class;
                break;
            }
            case UNAVAILABLE: {
                expectedClass = UnavailableException.class;
                break;
            }
            default: {
                expectedClass = ApiException.class;
            }
        }
        Truth.assertThat((Throwable)exception).isInstanceOf(expectedClass);
    }

    private class UnsupportedOperationApi
    implements LongRunningClient {
        private UnsupportedOperationApi() {
        }

        public UnaryCallable<String, OperationSnapshot> getOperationCallable() {
            throw new UnsupportedOperationException("Didn't expect call to getOperationCallable()");
        }

        public UnaryCallable<String, Void> cancelOperationCallable() {
            throw new UnsupportedOperationException("Didn't expect call to cancelOperationCallable()");
        }

        public UnaryCallable<String, Void> deleteOperationCallable() {
            throw new UnsupportedOperationException("Didn't expect call to deleteOperationCallable()");
        }
    }

    private static class MetadataTransformer
    implements ApiFunction<OperationSnapshot, Currency> {
        private MetadataTransformer() {
        }

        public Currency apply(OperationSnapshot operationSnapshot) {
            if (operationSnapshot.getMetadata() == null) {
                return null;
            }
            if (!(operationSnapshot.getMetadata() instanceof Currency)) {
                String errorMessage = "type mismatch: expected " + Currency.class.getName() + ", found " + operationSnapshot.getMetadata().getClass().getName();
                throw new ApiException(errorMessage, null, (StatusCode)FakeStatusCode.of(StatusCode.Code.OK), false);
            }
            return (Currency)operationSnapshot.getMetadata();
        }
    }

    private static class ResponseTransformer
    implements ApiFunction<OperationSnapshot, Color> {
        private ResponseTransformer() {
        }

        public Color apply(OperationSnapshot operationSnapshot) {
            if (!operationSnapshot.getErrorCode().getCode().equals((Object)StatusCode.Code.OK)) {
                throw ApiExceptionFactory.createException((String)("Operation with name \"" + operationSnapshot.getName() + "\" failed with status = " + operationSnapshot.getErrorCode() + " and message = " + operationSnapshot.getErrorMessage()), null, (StatusCode)operationSnapshot.getErrorCode(), (boolean)false);
            }
            if (operationSnapshot.getResponse() == null) {
                return null;
            }
            if (!(operationSnapshot.getResponse() instanceof Color)) {
                String errorMessage = "type mismatch: expected " + Color.class.getName() + ", found " + operationSnapshot.getResponse().getClass().getName();
                throw new ApiException(errorMessage, null, (StatusCode)FakeStatusCode.of(StatusCode.Code.OK), false);
            }
            return (Color)operationSnapshot.getResponse();
        }
    }
}

