/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.core.AbstractApiFuture;
import com.google.api.core.ApiClock;
import com.google.api.core.ApiFuture;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.core.FakeApiClock;
import com.google.api.gax.core.RecordingScheduler;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.CancellationHelpers;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.LatchCountDownScheduler;
import com.google.api.gax.rpc.RetryingTest;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.gax.rpc.UnavailableException;
import com.google.api.gax.rpc.testing.FakeCallContext;
import com.google.api.gax.rpc.testing.FakeCallableFactory;
import com.google.api.gax.rpc.testing.FakeChannel;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.api.gax.rpc.testing.FakeTransportChannel;
import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class CancellationTest {
    private UnaryCallable<Integer, Integer> callInt = (UnaryCallable)Mockito.mock(UnaryCallable.class);
    private static final RetrySettings FAST_RETRY_SETTINGS = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)2L)).setRetryDelayMultiplier(1.0).setMaxRetryDelay(Duration.ofMillis((long)2L)).setInitialRpcTimeout(Duration.ofMillis((long)2L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)2L)).setTotalTimeout(Duration.ofMillis((long)20L)).build();
    private static final RetrySettings SLOW_RETRY_SETTINGS = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)3000L)).setRetryDelayMultiplier(1.0).setMaxRetryDelay(Duration.ofMillis((long)3000L)).setInitialRpcTimeout(Duration.ofMillis((long)3000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)3000L)).setTotalTimeout(Duration.ofMillis((long)3000L)).build();
    private FakeApiClock fakeClock;
    private RecordingScheduler executor;
    private ClientContext clientContext;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void resetClock() {
        this.fakeClock = new FakeApiClock(System.nanoTime());
        this.executor = RecordingScheduler.create(this.fakeClock);
        this.clientContext = ClientContext.newBuilder().setExecutor((ScheduledExecutorService)this.executor).setClock((ApiClock)this.fakeClock).setDefaultCallContext((ApiCallContext)FakeCallContext.createDefault()).setTransportChannel((TransportChannel)FakeTransportChannel.create(new FakeChannel())).build();
    }

    @After
    public void teardown() {
        this.executor.shutdownNow();
    }

    @Test
    public void cancellationBeforeGetOnRetryingCallable() throws Exception {
        this.thrown.expect(CancellationException.class);
        Mockito.when((Object)this.callInt.futureCall((Object)((Integer)Mockito.any()), (ApiCallContext)Mockito.any())).thenReturn((Object)SettableApiFuture.create());
        UnaryCallSettings<Integer, Integer> callSettings = RetryingTest.createSettings(FAST_RETRY_SETTINGS);
        UnaryCallable<Integer, Integer> callable = FakeCallableFactory.createUnaryCallable(this.callInt, callSettings, this.clientContext);
        ApiFuture resultFuture = callable.futureCall((Object)0);
        resultFuture.cancel(true);
        resultFuture.get();
    }

    @Test
    public void cancellationDuringFirstCall() throws Exception {
        CancellationTrackingFuture innerFuture = CancellationTrackingFuture.create();
        CountDownLatch callIssuedLatch = new CountDownLatch(1);
        LatchCountDownFutureCallable innerCallable = new LatchCountDownFutureCallable(callIssuedLatch, innerFuture);
        UnaryCallSettings<Integer, Integer> callSettings = RetryingTest.createSettings(FAST_RETRY_SETTINGS);
        UnaryCallable<Integer, Integer> callable = FakeCallableFactory.createUnaryCallable(innerCallable, callSettings, this.clientContext.toBuilder().setExecutor((ScheduledExecutorService)new ScheduledThreadPoolExecutor(1)).build());
        ApiFuture resultFuture = callable.futureCall((Object)0);
        CancellationHelpers.cancelInThreadAfterLatchCountDown(resultFuture, callIssuedLatch);
        CancellationException gotException = null;
        try {
            resultFuture.get();
        }
        catch (CancellationException e) {
            gotException = e;
        }
        Truth.assertThat((Throwable)gotException).isNotNull();
        Truth.assertThat((Boolean)innerFuture.isCancelled()).isTrue();
    }

    @Test
    public void cancellationDuringRetryDelay() throws Exception {
        UnavailableException throwable = new UnavailableException(null, (StatusCode)FakeStatusCode.of(StatusCode.Code.UNAVAILABLE), true);
        CancellationTrackingFuture innerFuture = CancellationTrackingFuture.create();
        Mockito.when((Object)this.callInt.futureCall((Object)((Integer)Mockito.any()), (ApiCallContext)Mockito.any())).thenReturn(RetryingTest.immediateFailedFuture((Throwable)throwable)).thenReturn(innerFuture);
        CountDownLatch retryScheduledLatch = new CountDownLatch(1);
        LatchCountDownScheduler scheduler = LatchCountDownScheduler.get(retryScheduledLatch, 0L, 0L);
        UnaryCallSettings<Integer, Integer> callSettings = RetryingTest.createSettings(SLOW_RETRY_SETTINGS);
        UnaryCallable<Integer, Integer> callable = FakeCallableFactory.createUnaryCallable(this.callInt, callSettings, this.clientContext.toBuilder().setExecutor((ScheduledExecutorService)scheduler).build());
        ApiFuture resultFuture = callable.futureCall((Object)0);
        CancellationHelpers.cancelInThreadAfterLatchCountDown(resultFuture, retryScheduledLatch);
        CancellationException gotException = null;
        try {
            resultFuture.get();
        }
        catch (CancellationException e) {
            gotException = e;
        }
        Truth.assertThat((Throwable)gotException).isNotNull();
        Truth.assertThat((Boolean)resultFuture.isDone()).isTrue();
        Truth.assertThat((Boolean)resultFuture.isCancelled()).isTrue();
        Truth.assertThat((Boolean)innerFuture.isCancelled()).isFalse();
        scheduler.shutdownNow();
    }

    @Test
    public void cancellationDuringSecondCall() throws Exception {
        UnavailableException throwable = new UnavailableException(null, (StatusCode)FakeStatusCode.of(StatusCode.Code.UNAVAILABLE), true);
        ApiFuture failingFuture = RetryingTest.immediateFailedFuture((Throwable)throwable);
        CancellationTrackingFuture innerFuture = CancellationTrackingFuture.create();
        CountDownLatch callIssuedLatch = new CountDownLatch(2);
        LatchCountDownFutureCallable innerCallable = new LatchCountDownFutureCallable(callIssuedLatch, Lists.newArrayList((Object[])new ApiFuture[]{failingFuture, innerFuture}));
        UnaryCallSettings<Integer, Integer> callSettings = RetryingTest.createSettings(FAST_RETRY_SETTINGS);
        UnaryCallable<Integer, Integer> callable = FakeCallableFactory.createUnaryCallable(innerCallable, callSettings, this.clientContext.toBuilder().setExecutor((ScheduledExecutorService)new ScheduledThreadPoolExecutor(1)).build());
        ApiFuture resultFuture = callable.futureCall((Object)0);
        CancellationHelpers.cancelInThreadAfterLatchCountDown(resultFuture, callIssuedLatch);
        CancellationException gotException = null;
        try {
            resultFuture.get();
        }
        catch (CancellationException e) {
            gotException = e;
        }
        Truth.assertThat((Throwable)gotException).isNotNull();
        Truth.assertThat((Boolean)resultFuture.isDone()).isTrue();
        Truth.assertThat((Boolean)resultFuture.isCancelled()).isTrue();
        Truth.assertThat((Boolean)innerFuture.isDone()).isTrue();
    }

    private static class LatchCountDownFutureCallable<RequestT, ResponseT>
    extends UnaryCallable<RequestT, ResponseT> {
        private CountDownLatch callLatch;
        private List<ApiFuture<ResponseT>> injectedFutures;

        public LatchCountDownFutureCallable(CountDownLatch callLatch, ApiFuture<ResponseT> injectedFuture) {
            this(callLatch, Lists.newArrayList((Object[])new ApiFuture[]{injectedFuture}));
        }

        public LatchCountDownFutureCallable(CountDownLatch callLatch, List<ApiFuture<ResponseT>> injectedFutures) {
            this.callLatch = callLatch;
            this.injectedFutures = Lists.newArrayList(injectedFutures);
        }

        public ApiFuture<ResponseT> futureCall(RequestT request, ApiCallContext context) {
            this.callLatch.countDown();
            return this.injectedFutures.remove(0);
        }
    }

    private static class CancellationTrackingFuture<RespT>
    extends AbstractApiFuture<RespT> {
        private volatile boolean cancelled = false;

        public static <RespT> CancellationTrackingFuture<RespT> create() {
            return new CancellationTrackingFuture<RespT>();
        }

        private CancellationTrackingFuture() {
        }

        protected void interruptTask() {
            this.cancelled = true;
        }

        public boolean isCancelled() {
            return this.cancelled;
        }
    }
}

