/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.batching.FlowController;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.BatchingCallSettings;
import com.google.api.gax.rpc.BatchingDescriptor;
import com.google.api.gax.rpc.StatusCode;
import com.google.common.collect.Sets;
import com.google.common.truth.Truth;
import java.util.HashSet;
import java.util.Set;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class BatchingCallSettingsTest {
    @Test
    public void testEmptyBuilder() {
        BatchingDescriptor batchingDescriptor = (BatchingDescriptor)Mockito.mock(BatchingDescriptor.class);
        BatchingCallSettings.Builder builder = BatchingCallSettings.newBuilder((BatchingDescriptor)batchingDescriptor);
        Truth.assertThat((Object)builder.getBatchingDescriptor()).isSameInstanceAs((Object)batchingDescriptor);
        Truth.assertThat((Object)builder.getBatchingSettings()).isNull();
        Truth.assertThat((Object)builder.getFlowController()).isNull();
        Truth.assertThat((Integer)builder.getRetryableCodes().size()).isEqualTo((Object)0);
        Truth.assertThat((Object)builder.getRetrySettings()).isNotNull();
        BatchingSettings batchingSettings = BatchingSettings.newBuilder().setElementCountThreshold(Long.valueOf(1L)).build();
        builder.setBatchingSettings(batchingSettings);
        BatchingCallSettings settings = builder.build();
        Truth.assertThat((Object)settings.getBatchingDescriptor()).isSameInstanceAs((Object)batchingDescriptor);
        Truth.assertThat((Object)settings.getBatchingSettings()).isSameInstanceAs((Object)batchingSettings);
        Truth.assertThat((Object)settings.getFlowController()).isNotNull();
        Truth.assertThat((Integer)settings.getRetryableCodes().size()).isEqualTo((Object)0);
        Truth.assertThat((Object)settings.getRetrySettings()).isNotNull();
    }

    @Test
    public void testBuilder() {
        BatchingDescriptor batchingDescriptor = (BatchingDescriptor)Mockito.mock(BatchingDescriptor.class);
        BatchingCallSettings.Builder builder = BatchingCallSettings.newBuilder((BatchingDescriptor)batchingDescriptor);
        BatchingSettings batchingSettings = BatchingSettings.newBuilder().setElementCountThreshold(Long.valueOf(1L)).build();
        FlowController flowController = (FlowController)Mockito.mock(FlowController.class);
        HashSet retryCodes = Sets.newHashSet((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE});
        RetrySettings retrySettings = RetrySettings.newBuilder().build();
        builder.setBatchingSettings(batchingSettings);
        builder.setFlowController(flowController);
        builder.setRetryableCodes((Set)retryCodes);
        builder.setRetrySettings(retrySettings);
        Truth.assertThat((Object)builder.getBatchingDescriptor()).isSameInstanceAs((Object)batchingDescriptor);
        Truth.assertThat((Object)builder.getBatchingSettings()).isSameInstanceAs((Object)batchingSettings);
        Truth.assertThat((Object)builder.getFlowController()).isSameInstanceAs((Object)flowController);
        Truth.assertThat((Integer)builder.getRetryableCodes().size()).isEqualTo((Object)1);
        Truth.assertThat((Object)builder.getRetrySettings()).isSameInstanceAs((Object)retrySettings);
        BatchingCallSettings settings = builder.build();
        Truth.assertThat((Object)settings.getBatchingDescriptor()).isSameInstanceAs((Object)batchingDescriptor);
        Truth.assertThat((Object)settings.getBatchingSettings()).isSameInstanceAs((Object)batchingSettings);
        Truth.assertThat((Object)settings.getFlowController()).isSameInstanceAs((Object)flowController);
        Truth.assertThat((Integer)settings.getRetryableCodes().size()).isEqualTo((Object)1);
        Truth.assertThat((Object)settings.getRetrySettings()).isSameInstanceAs((Object)retrySettings);
    }

    @Test
    public void testBuilderFromSettings() throws Exception {
        BatchingDescriptor batchingDescriptor = (BatchingDescriptor)Mockito.mock(BatchingDescriptor.class);
        BatchingCallSettings.Builder builder = BatchingCallSettings.newBuilder((BatchingDescriptor)batchingDescriptor);
        BatchingSettings batchingSettings = BatchingSettings.newBuilder().setElementCountThreshold(Long.valueOf(1L)).build();
        FlowController flowController = (FlowController)Mockito.mock(FlowController.class);
        HashSet retryCodes = Sets.newHashSet((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE});
        RetrySettings retrySettings = RetrySettings.newBuilder().build();
        builder.setBatchingSettings(batchingSettings);
        builder.setFlowController(flowController);
        builder.setRetryableCodes((Set)retryCodes);
        builder.setRetrySettings(retrySettings);
        BatchingCallSettings settings = builder.build();
        BatchingCallSettings.Builder newBuilder = settings.toBuilder();
        Truth.assertThat((Object)newBuilder.getBatchingDescriptor()).isSameInstanceAs((Object)batchingDescriptor);
        Truth.assertThat((Object)newBuilder.getBatchingSettings()).isSameInstanceAs((Object)batchingSettings);
        Truth.assertThat((Object)newBuilder.getFlowController()).isSameInstanceAs((Object)flowController);
        Truth.assertThat((Integer)newBuilder.getRetryableCodes().size()).isEqualTo((Object)1);
        Truth.assertThat((Object)newBuilder.getRetrySettings()).isSameInstanceAs((Object)retrySettings);
    }

    @Test
    public void testNoFlowControlSettings() throws Exception {
        BatchingDescriptor batchingDescriptor = (BatchingDescriptor)Mockito.mock(BatchingDescriptor.class);
        BatchingCallSettings.Builder builder = BatchingCallSettings.newBuilder((BatchingDescriptor)batchingDescriptor);
        BatchingSettings batchingSettings = BatchingSettings.newBuilder().setElementCountThreshold(Long.valueOf(1L)).build();
        builder.setBatchingSettings(batchingSettings);
        BatchingCallSettings settings = builder.build();
        Truth.assertThat((Object)settings.getFlowController()).isNotNull();
    }
}

