/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.batching.FlowController;
import com.google.api.gax.batching.PartitionKey;
import com.google.api.gax.batching.ThresholdBatcher;
import com.google.api.gax.rpc.BatcherFactory;
import com.google.api.gax.rpc.BatchingDescriptor;
import com.google.api.gax.rpc.testing.FakeBatchableApi;
import com.google.common.truth.Truth;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class BatcherFactoryTest {
    private ScheduledExecutorService batchingExecutor;

    @Before
    public void setUp() {
        this.batchingExecutor = new ScheduledThreadPoolExecutor(1);
    }

    @After
    public void tearDown() {
        this.batchingExecutor.shutdownNow();
    }

    @Test
    public void testGetPushingBatcher() {
        BatchingSettings batchingSettings = BatchingSettings.newBuilder().setDelayThreshold(Duration.ofSeconds((long)1L)).setElementCountThreshold(Long.valueOf(2L)).setRequestByteThreshold(Long.valueOf(1000L)).build();
        FlowControlSettings flowControlSettings = FlowControlSettings.newBuilder().setLimitExceededBehavior(FlowController.LimitExceededBehavior.Ignore).build();
        FlowController flowController = new FlowController(flowControlSettings);
        BatcherFactory batcherFactory = new BatcherFactory((BatchingDescriptor)new FakeBatchableApi.SquarerBatchingDescriptor(), batchingSettings, this.batchingExecutor, flowController);
        Truth.assertThat((Object)batcherFactory.getBatchingSettings()).isSameInstanceAs((Object)batchingSettings);
        ThresholdBatcher batcherFoo = batcherFactory.getPushingBatcher(new PartitionKey(new Object[]{"foo"}));
        ThresholdBatcher batcherFoo2 = batcherFactory.getPushingBatcher(new PartitionKey(new Object[]{"foo"}));
        ThresholdBatcher batcherBar = batcherFactory.getPushingBatcher(new PartitionKey(new Object[]{"bar"}));
        Truth.assertThat((Object)batcherFoo).isSameInstanceAs((Object)batcherFoo2);
        Truth.assertThat((Object)batcherFoo).isNotSameInstanceAs((Object)batcherBar);
    }
}

