/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.batching;

import com.google.api.gax.batching.BatchingCallSettings;
import com.google.api.gax.batching.BatchingDescriptor;
import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.batching.FlowController;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.testing.FakeBatchableApi;
import com.google.common.collect.ImmutableSet;
import com.google.common.truth.Truth;
import java.util.Set;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class BatchingCallSettingsTest {
    private static final BatchingSettings BATCHING_SETTINGS = BatchingSettings.newBuilder().setElementCountThreshold(Long.valueOf(10L)).setRequestByteThreshold(Long.valueOf(20L)).setDelayThreshold(Duration.ofMillis((long)5L)).setFlowControlSettings(FlowControlSettings.newBuilder().setMaxOutstandingElementCount(Long.valueOf(100L)).setMaxOutstandingRequestBytes(Long.valueOf(100L)).setLimitExceededBehavior(FlowController.LimitExceededBehavior.Block).build()).build();

    @Test
    public void testEmptyBuilder() {
        BatchingCallSettings.Builder builder = BatchingCallSettings.newBuilder((BatchingDescriptor)FakeBatchableApi.SQUARER_BATCHING_DESC_V2);
        Truth.assertThat((Object)builder.getBatchingSettings()).isNull();
        Truth.assertThat((Iterable)builder.getRetryableCodes()).isEmpty();
        Truth.assertThat((Object)builder.getRetrySettings()).isNotNull();
    }

    @Test
    public void testBuilder() {
        BatchingCallSettings.Builder builder = BatchingCallSettings.newBuilder((BatchingDescriptor)FakeBatchableApi.SQUARER_BATCHING_DESC_V2);
        ImmutableSet retryCodes = ImmutableSet.of((Object)StatusCode.Code.UNAVAILABLE);
        RetrySettings retrySettings = RetrySettings.newBuilder().build();
        builder.setBatchingSettings(BATCHING_SETTINGS).setRetryableCodes((Set)retryCodes).setRetrySettings(retrySettings);
        BatchingCallSettings settings = builder.build();
        Truth.assertThat((Object)settings.getBatchingSettings()).isEqualTo((Object)BATCHING_SETTINGS);
        Truth.assertThat((Iterable)settings.getRetryableCodes()).isEqualTo((Object)retryCodes);
        Truth.assertThat((Object)settings.getRetrySettings()).isEqualTo((Object)retrySettings);
    }

    @Test
    public void testBuilderFromSettings() {
        BatchingCallSettings.Builder builder = BatchingCallSettings.newBuilder((BatchingDescriptor)FakeBatchableApi.SQUARER_BATCHING_DESC_V2);
        RetrySettings retrySettings = RetrySettings.newBuilder().setTotalTimeout(Duration.ofMinutes((long)1L)).build();
        builder.setBatchingSettings(BATCHING_SETTINGS).setRetryableCodes(new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.UNAUTHENTICATED}).setRetrySettings(retrySettings);
        BatchingCallSettings settings = builder.build();
        BatchingCallSettings.Builder newBuilder = settings.toBuilder();
        Truth.assertThat((Object)newBuilder.getBatchingSettings()).isEqualTo((Object)BATCHING_SETTINGS);
        Truth.assertThat((Iterable)newBuilder.getRetryableCodes()).containsExactly(new Object[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.UNAUTHENTICATED});
        Truth.assertThat((Object)newBuilder.getRetrySettings()).isEqualTo((Object)retrySettings);
    }

    @Test
    public void testMandatorySettings() {
        Exception actualEx = null;
        try {
            BatchingCallSettings.newBuilder(null);
        }
        catch (Exception ex) {
            actualEx = ex;
        }
        Truth.assertThat((Throwable)actualEx).isInstanceOf(NullPointerException.class);
        actualEx = null;
        try {
            BatchingCallSettings.newBuilder((BatchingDescriptor)FakeBatchableApi.SQUARER_BATCHING_DESC_V2).build();
        }
        catch (Exception ex) {
            actualEx = ex;
        }
        Truth.assertThat((Throwable)actualEx).isInstanceOf(IllegalStateException.class);
    }
}

