/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.batching;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.batching.Batcher;
import com.google.api.gax.batching.BatcherImpl;
import com.google.api.gax.batching.BatchingDescriptor;
import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.gax.rpc.testing.FakeBatchableApi;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class BatcherImplTest {
    private static final ScheduledExecutorService EXECUTOR = Executors.newSingleThreadScheduledExecutor();
    private Batcher<Integer, Integer> underTest;
    private final FakeBatchableApi.LabeledIntList labeledIntList = new FakeBatchableApi.LabeledIntList("Default", new Integer[0]);
    private final BatchingSettings batchingSettings = BatchingSettings.newBuilder().setElementCountThreshold(Long.valueOf(1000L)).setRequestByteThreshold(Long.valueOf(1000L)).setDelayThreshold(Duration.ofSeconds((long)1L)).build();

    @After
    public void tearDown() throws InterruptedException {
        if (this.underTest != null) {
            this.underTest.close();
        }
    }

    @AfterClass
    public static void tearDownExecutor() throws InterruptedException {
        EXECUTOR.shutdown();
        EXECUTOR.awaitTermination(100L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void testResultsAreResolvedAfterFlush() throws Exception {
        this.underTest = new BatcherImpl((BatchingDescriptor)FakeBatchableApi.SQUARER_BATCHING_DESC_V2, (UnaryCallable)FakeBatchableApi.callLabeledIntSquarer, (Object)this.labeledIntList, this.batchingSettings, EXECUTOR);
        ApiFuture result = this.underTest.add((Object)4);
        Truth.assertThat((Boolean)result.isDone()).isFalse();
        this.underTest.flush();
        Truth.assertThat((Boolean)result.isDone()).isTrue();
        Truth.assertThat((Integer)((Integer)result.get())).isEqualTo((Object)16);
        ApiFuture anotherResult = this.underTest.add((Object)5);
        Truth.assertThat((Boolean)anotherResult.isDone()).isFalse();
    }

    @Test
    public void testSendOutstanding() {
        final AtomicInteger callableCounter = new AtomicInteger();
        this.underTest = new BatcherImpl((BatchingDescriptor)FakeBatchableApi.SQUARER_BATCHING_DESC_V2, (UnaryCallable)new FakeBatchableApi.LabeledIntSquarerCallable(){

            public ApiFuture<List<Integer>> futureCall(FakeBatchableApi.LabeledIntList request) {
                callableCounter.incrementAndGet();
                return super.futureCall((Object)request);
            }
        }, (Object)this.labeledIntList, this.batchingSettings, EXECUTOR);
        this.underTest.sendOutstanding();
        Truth.assertThat((Integer)callableCounter.get()).isEqualTo((Object)0);
        this.underTest.add((Object)2);
        this.underTest.add((Object)3);
        this.underTest.add((Object)4);
        this.underTest.sendOutstanding();
        Truth.assertThat((Integer)callableCounter.get()).isEqualTo((Object)1);
    }

    @Test
    public void testWhenBatcherIsClose() throws Exception {
        ApiFuture result;
        try (BatcherImpl batcher = new BatcherImpl((BatchingDescriptor)FakeBatchableApi.SQUARER_BATCHING_DESC_V2, (UnaryCallable)FakeBatchableApi.callLabeledIntSquarer, (Object)this.labeledIntList, this.batchingSettings, EXECUTOR);){
            result = batcher.add((Object)5);
        }
        Truth.assertThat((Boolean)result.isDone()).isTrue();
        Truth.assertThat((Integer)((Integer)result.get())).isEqualTo((Object)25);
    }

    @Test
    public void testNoElementAdditionAfterClose() throws Exception {
        this.underTest = new BatcherImpl((BatchingDescriptor)FakeBatchableApi.SQUARER_BATCHING_DESC_V2, (UnaryCallable)FakeBatchableApi.callLabeledIntSquarer, (Object)this.labeledIntList, this.batchingSettings, EXECUTOR);
        this.underTest.close();
        Exception addOnClosedError = null;
        try {
            this.underTest.add((Object)1);
        }
        catch (Exception ex) {
            addOnClosedError = ex;
        }
        Truth.assertThat((Throwable)addOnClosedError).isInstanceOf(IllegalStateException.class);
        Truth.assertThat((Throwable)addOnClosedError).hasMessageThat().matches("Cannot add elements on a closed batcher");
    }

    @Test
    public void testResultFailureAfterRPCFailure() throws Exception {
        final RuntimeException fakeError = new RuntimeException();
        UnaryCallable<FakeBatchableApi.LabeledIntList, List<Integer>> unaryCallable = new UnaryCallable<FakeBatchableApi.LabeledIntList, List<Integer>>(){

            public ApiFuture<List<Integer>> futureCall(FakeBatchableApi.LabeledIntList request, ApiCallContext context) {
                return ApiFutures.immediateFailedFuture((Throwable)fakeError);
            }
        };
        this.underTest = new BatcherImpl((BatchingDescriptor)FakeBatchableApi.SQUARER_BATCHING_DESC_V2, (UnaryCallable)unaryCallable, (Object)this.labeledIntList, this.batchingSettings, EXECUTOR);
        ApiFuture failedResult = this.underTest.add((Object)5);
        this.underTest.flush();
        Truth.assertThat((Boolean)failedResult.isDone()).isTrue();
        Exception actualError = null;
        try {
            failedResult.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            actualError = ex;
        }
        Truth.assertThat((Throwable)actualError).hasCauseThat().isSameInstanceAs((Object)fakeError);
    }

    @Test
    public void testExceptionInDescriptor() throws InterruptedException {
        final RuntimeException fakeError = new RuntimeException("internal exception");
        FakeBatchableApi.SquarerBatchingDescriptorV2 descriptor = new FakeBatchableApi.SquarerBatchingDescriptorV2(){

            @Override
            public void splitResponse(List<Integer> batchResponse, List<SettableApiFuture<Integer>> batch) {
                throw fakeError;
            }
        };
        this.underTest = new BatcherImpl((BatchingDescriptor)descriptor, (UnaryCallable)FakeBatchableApi.callLabeledIntSquarer, (Object)this.labeledIntList, this.batchingSettings, EXECUTOR);
        ApiFuture result = this.underTest.add((Object)2);
        this.underTest.flush();
        ExecutionException actualError = null;
        try {
            result.get();
        }
        catch (ExecutionException ex) {
            actualError = ex;
        }
        Truth.assertThat((Throwable)actualError).hasCauseThat().isSameInstanceAs((Object)fakeError);
    }

    @Test
    public void testExceptionInDescriptorErrorHandling() throws InterruptedException {
        final RuntimeException fakeError = new RuntimeException("internal exception");
        FakeBatchableApi.SquarerBatchingDescriptorV2 descriptor = new FakeBatchableApi.SquarerBatchingDescriptorV2(){

            @Override
            public void splitResponse(List<Integer> batchResponse, List<SettableApiFuture<Integer>> batch) {
                throw fakeError;
            }

            @Override
            public void splitException(Throwable throwable, List<SettableApiFuture<Integer>> batch) {
                throw fakeError;
            }
        };
        this.underTest = new BatcherImpl((BatchingDescriptor)descriptor, (UnaryCallable)FakeBatchableApi.callLabeledIntSquarer, (Object)this.labeledIntList, this.batchingSettings, EXECUTOR);
        ApiFuture result = this.underTest.add((Object)2);
        this.underTest.flush();
        ExecutionException actualError = null;
        try {
            result.get();
        }
        catch (ExecutionException ex) {
            actualError = ex;
        }
        Truth.assertThat((Throwable)actualError).hasCauseThat().isSameInstanceAs((Object)fakeError);
    }

    @Test
    public void testWhenElementCountExceeds() throws Exception {
        BatchingSettings settings = this.batchingSettings.toBuilder().setElementCountThreshold(Long.valueOf(2L)).build();
        this.testElementTriggers(settings);
    }

    @Test
    public void testWhenElementBytesExceeds() throws Exception {
        BatchingSettings settings = this.batchingSettings.toBuilder().setRequestByteThreshold(Long.valueOf(2L)).build();
        this.testElementTriggers(settings);
    }

    @Test
    public void testWhenThresholdIsDisabled() throws Exception {
        BatchingSettings settings = BatchingSettings.newBuilder().setElementCountThreshold(null).setRequestByteThreshold(null).setDelayThreshold(null).build();
        this.underTest = new BatcherImpl((BatchingDescriptor)FakeBatchableApi.SQUARER_BATCHING_DESC_V2, (UnaryCallable)FakeBatchableApi.callLabeledIntSquarer, (Object)this.labeledIntList, settings, EXECUTOR);
        ApiFuture result = this.underTest.add((Object)2);
        Truth.assertThat((Boolean)result.isDone()).isTrue();
        Truth.assertThat((Integer)((Integer)result.get())).isEqualTo((Object)4);
    }

    @Test
    public void testWhenDelayThresholdExceeds() throws Exception {
        BatchingSettings settings = this.batchingSettings.toBuilder().setDelayThreshold(Duration.ofMillis((long)100L)).build();
        this.underTest = new BatcherImpl((BatchingDescriptor)FakeBatchableApi.SQUARER_BATCHING_DESC_V2, (UnaryCallable)FakeBatchableApi.callLabeledIntSquarer, (Object)this.labeledIntList, settings, EXECUTOR);
        ApiFuture result = this.underTest.add((Object)6);
        Truth.assertThat((Boolean)result.isDone()).isFalse();
        Truth.assertThat((Integer)((Integer)result.get())).isEqualTo((Object)36);
    }

    @Test(timeout=500L)
    public void testElementsNotLeaking() throws Exception {
        ExecutorService singleThreadExecutor = Executors.newSingleThreadExecutor();
        ScheduledExecutorService multiThreadExecutor = Executors.newScheduledThreadPool(20);
        final AtomicBoolean isDuplicateElement = new AtomicBoolean(false);
        final ConcurrentHashMap map = new ConcurrentHashMap();
        UnaryCallable<FakeBatchableApi.LabeledIntList, List<Integer>> callable = new UnaryCallable<FakeBatchableApi.LabeledIntList, List<Integer>>(){

            public ApiFuture<List<Integer>> futureCall(FakeBatchableApi.LabeledIntList request, ApiCallContext context) {
                for (int val : request.ints) {
                    Boolean isPresent = map.putIfAbsent(val, Boolean.TRUE);
                    if (isPresent == null || !isPresent.booleanValue()) continue;
                    isDuplicateElement.set(true);
                    throw new AssertionError((Object)"Duplicate Element found");
                }
                return ApiFutures.immediateFuture(request.ints);
            }
        };
        BatchingSettings settings = this.batchingSettings.toBuilder().setDelayThreshold(Duration.ofMillis((long)50L)).build();
        try (final BatcherImpl batcherTest = new BatcherImpl((BatchingDescriptor)FakeBatchableApi.SQUARER_BATCHING_DESC_V2, (UnaryCallable)callable, (Object)this.labeledIntList, settings, EXECUTOR);){
            Callable<Void> addElement = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    int counter = 0;
                    while (!isDuplicateElement.get() && counter < 10000) {
                        batcherTest.add((Object)counter++);
                    }
                    return null;
                }
            };
            Callable<Void> sendBatch = new Callable<Void>(){

                @Override
                public Void call() throws InterruptedException {
                    batcherTest.flush();
                    return null;
                }
            };
            Future<Void> future = singleThreadExecutor.submit(addElement);
            for (int i = 0; !isDuplicateElement.get() && i < 3000; ++i) {
                multiThreadExecutor.submit(sendBatch);
            }
            future.get();
            Truth.assertThat((Boolean)isDuplicateElement.get()).isFalse();
            singleThreadExecutor.shutdown();
            multiThreadExecutor.shutdown();
        }
    }

    @Test
    public void testPushCurrentBatchRunnable() throws Exception {
        long DELAY_TIME = 50L;
        BatchingSettings settings = this.batchingSettings.toBuilder().setDelayThreshold(Duration.ofMillis((long)DELAY_TIME)).build();
        BatcherImpl batcher = new BatcherImpl((BatchingDescriptor)FakeBatchableApi.SQUARER_BATCHING_DESC_V2, (UnaryCallable)FakeBatchableApi.callLabeledIntSquarer, (Object)this.labeledIntList, settings, EXECUTOR);
        BatcherImpl.PushCurrentBatchRunnable pushBatchRunnable = new BatcherImpl.PushCurrentBatchRunnable(batcher);
        ScheduledFuture<?> onGoingRunnable = EXECUTOR.scheduleWithFixedDelay((Runnable)pushBatchRunnable, DELAY_TIME, DELAY_TIME, TimeUnit.MILLISECONDS);
        pushBatchRunnable.setScheduledFuture(onGoingRunnable);
        boolean isExecutorCancelled = pushBatchRunnable.isCancelled();
        Truth.assertThat((Boolean)isExecutorCancelled).isFalse();
        batcher.close();
        batcher = null;
        for (int retry = 0; retry < 3; ++retry) {
            System.gc();
            System.runFinalization();
            isExecutorCancelled = pushBatchRunnable.isCancelled();
            if (isExecutorCancelled) break;
            Thread.sleep(DELAY_TIME * (1L << retry));
        }
        Truth.assertThat((Boolean)pushBatchRunnable.isCancelled()).isTrue();
    }

    @Test
    public void testEmptyBatchesAreNeverSent() throws Exception {
        UnaryCallable<FakeBatchableApi.LabeledIntList, List<Integer>> callable = new UnaryCallable<FakeBatchableApi.LabeledIntList, List<Integer>>(){

            public ApiFuture<List<Integer>> futureCall(FakeBatchableApi.LabeledIntList request, ApiCallContext context) {
                throw new AssertionError((Object)"Should not call");
            }
        };
        this.underTest = new BatcherImpl((BatchingDescriptor)FakeBatchableApi.SQUARER_BATCHING_DESC_V2, (UnaryCallable)callable, (Object)this.labeledIntList, this.batchingSettings, EXECUTOR);
        this.underTest.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnclosedBatchersAreLogged() throws Exception {
        long DELAY_TIME = 30L;
        int actualRemaining = 0;
        for (int retry = 0; retry < 3; ++retry) {
            System.gc();
            System.runFinalization();
            actualRemaining = BatcherImpl.BatcherReference.cleanQueue();
            if (actualRemaining == 0) break;
            Thread.sleep(30L * (1L << retry));
        }
        Truth.assertThat((Integer)actualRemaining).isAtMost((Comparable)Integer.valueOf(0));
        this.underTest = new BatcherImpl((BatchingDescriptor)FakeBatchableApi.SQUARER_BATCHING_DESC_V2, (UnaryCallable)FakeBatchableApi.callLabeledIntSquarer, (Object)this.labeledIntList, this.batchingSettings, EXECUTOR);
        BatcherImpl extraBatcher = new BatcherImpl((BatchingDescriptor)FakeBatchableApi.SQUARER_BATCHING_DESC_V2, (UnaryCallable)FakeBatchableApi.callLabeledIntSquarer, (Object)this.labeledIntList, this.batchingSettings, EXECUTOR);
        final ArrayList records = new ArrayList(1);
        Logger batcherLogger = Logger.getLogger(BatcherImpl.class.getName());
        Filter oldFilter = batcherLogger.getFilter();
        batcherLogger.setFilter(new Filter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isLoggable(LogRecord record) {
                List list = records;
                synchronized (list) {
                    records.add(record);
                }
                return false;
            }
        });
        try {
            LogRecord lr;
            extraBatcher.close();
            extraBatcher = null;
            this.underTest = null;
            boolean success = false;
            for (int retry = 0; retry < 3; ++retry) {
                System.gc();
                System.runFinalization();
                int orphans = BatcherImpl.BatcherReference.cleanQueue();
                if (orphans == 1) {
                    success = true;
                    break;
                }
                Truth.assertWithMessage((String)"unexpected extra orphans").that(Integer.valueOf(orphans)).isEqualTo((Object)0);
                Thread.sleep(30L * (1L << retry));
            }
            Truth.assertWithMessage((String)"Batcher was not garbage collected").that(Boolean.valueOf(success)).isTrue();
            ArrayList arrayList = records;
            synchronized (arrayList) {
                Truth.assertThat((Integer)records.size()).isEqualTo((Object)1);
                lr = (LogRecord)records.get(0);
            }
            Truth.assertThat((String)lr.getMessage()).contains((CharSequence)"not closed properly");
            Truth.assertThat((Object)lr.getLevel()).isEqualTo((Object)Level.SEVERE);
        }
        finally {
            batcherLogger.setFilter(oldFilter);
        }
    }

    private void testElementTriggers(BatchingSettings settings) throws Exception {
        this.underTest = new BatcherImpl((BatchingDescriptor)FakeBatchableApi.SQUARER_BATCHING_DESC_V2, (UnaryCallable)FakeBatchableApi.callLabeledIntSquarer, (Object)this.labeledIntList, settings, EXECUTOR);
        ApiFuture result = this.underTest.add((Object)4);
        Truth.assertThat((Boolean)result.isDone()).isFalse();
        ApiFuture anotherResult = this.underTest.add((Object)5);
        Truth.assertThat((Boolean)result.isDone()).isTrue();
        Truth.assertThat((Integer)((Integer)result.get())).isEqualTo((Object)16);
        Truth.assertThat((Boolean)anotherResult.isDone()).isTrue();
    }
}

