/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.core.ApiFuture;
import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.batching.FlowController;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.BatcherFactory;
import com.google.api.gax.rpc.BatchingCallable;
import com.google.api.gax.rpc.BatchingDescriptor;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.gax.rpc.testing.FakeBatchableApi;
import com.google.api.gax.rpc.testing.FakeCallContext;
import com.google.common.truth.Truth;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class BatchingCallableTest {
    private ScheduledExecutorService batchingExecutor;

    @Before
    public void setUp() {
        this.batchingExecutor = new ScheduledThreadPoolExecutor(2);
    }

    @After
    public void tearDown() {
        this.batchingExecutor.shutdownNow();
    }

    @Test
    public void testBatchedCall() throws Exception {
        BatchingSettings batchingSettings = BatchingSettings.newBuilder().setDelayThreshold(Duration.ofSeconds((long)10L)).setElementCountThreshold(Long.valueOf(2L)).setRequestByteThreshold(Long.valueOf(1000L)).build();
        FlowControlSettings flowControlSettings = FlowControlSettings.newBuilder().setLimitExceededBehavior(FlowController.LimitExceededBehavior.Ignore).build();
        FlowController flowController = new FlowController(flowControlSettings);
        BatcherFactory batcherFactory = new BatcherFactory((BatchingDescriptor)new FakeBatchableApi.SquarerBatchingDescriptor(), batchingSettings, this.batchingExecutor, flowController);
        BatchingCallable batchingCallable = new BatchingCallable((UnaryCallable)FakeBatchableApi.callLabeledIntSquarer, (BatchingDescriptor)FakeBatchableApi.SQUARER_BATCHING_DESC, batcherFactory);
        FakeBatchableApi.LabeledIntList request1 = new FakeBatchableApi.LabeledIntList("label", 2);
        ApiFuture future1 = batchingCallable.futureCall((Object)request1, (ApiCallContext)FakeCallContext.createDefault());
        Truth.assertThat((Boolean)future1.isDone()).isFalse();
        FakeBatchableApi.LabeledIntList request2 = new FakeBatchableApi.LabeledIntList("label", 3);
        ApiFuture future2 = batchingCallable.futureCall((Object)request2, (ApiCallContext)FakeCallContext.createDefault());
        List response1 = (List)future1.get();
        List response2 = (List)future2.get();
        Truth.assertThat((Integer)response1.size()).isEqualTo((Object)1);
        Truth.assertThat((Integer)((Integer)response1.get(0))).isEqualTo((Object)4);
        Truth.assertThat((Integer)response2.size()).isEqualTo((Object)1);
        Truth.assertThat((Integer)((Integer)response2.get(0))).isEqualTo((Object)9);
    }

    @Test
    public void testUnbatchedCall() throws Exception {
        BatchingSettings batchingSettings = BatchingSettings.newBuilder().setIsEnabled(Boolean.valueOf(false)).build();
        FlowControlSettings flowControlSettings = FlowControlSettings.newBuilder().setLimitExceededBehavior(FlowController.LimitExceededBehavior.Ignore).build();
        FlowController flowController = new FlowController(flowControlSettings);
        BatcherFactory batcherFactory = new BatcherFactory((BatchingDescriptor)new FakeBatchableApi.SquarerBatchingDescriptor(), batchingSettings, this.batchingExecutor, flowController);
        BatchingCallable batchingCallable = new BatchingCallable((UnaryCallable)FakeBatchableApi.callLabeledIntSquarer, (BatchingDescriptor)FakeBatchableApi.SQUARER_BATCHING_DESC, batcherFactory);
        FakeBatchableApi.LabeledIntList request1 = new FakeBatchableApi.LabeledIntList("label", 2);
        ApiFuture future1 = batchingCallable.futureCall((Object)request1, (ApiCallContext)FakeCallContext.createDefault());
        List response1 = (List)future1.get();
        Truth.assertThat((Integer)response1.size()).isEqualTo((Object)1);
        Truth.assertThat((Integer)((Integer)response1.get(0))).isEqualTo((Object)4);
    }
}

