/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.core;

import java.io.IOException;
import java.util.Properties;

public class GaxPropertiesProvider {
    private static final Properties gaxProperties = new Properties();
    private static final String DEFAULT_VERSION = "";

    public static String getGaxVersion() {
        String gaxVersion = GaxPropertiesProvider.loadGaxProperty("version");
        return gaxVersion != null ? gaxVersion : DEFAULT_VERSION;
    }

    public static String getGrpcVersion() {
        String grpcVersion = GaxPropertiesProvider.loadGaxProperty("grpc_version");
        return grpcVersion != null ? grpcVersion : DEFAULT_VERSION;
    }

    private static String loadGaxProperty(String key) {
        try {
            if (gaxProperties.isEmpty()) {
                gaxProperties.load(GaxPropertiesProvider.class.getResourceAsStream("/com/google/api/gax/gax.properties"));
            }
            return gaxProperties.getProperty(key);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            return null;
        }
    }
}

