/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.retrying;

import com.google.api.core.ApiFuture;
import com.google.api.core.ListenableFutureToApiFuture;
import com.google.api.gax.retrying.RetryAlgorithm;
import com.google.api.gax.retrying.RetryingExecutor;
import com.google.api.gax.retrying.RetryingFuture;
import com.google.api.gax.retrying.RetryingFutureImpl;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Callable;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class ScheduledRetryingExecutor<ResponseT>
implements RetryingExecutor<ResponseT> {
    private final RetryAlgorithm retryAlgorithm;
    private final ListeningScheduledExecutorService scheduler;

    public ScheduledRetryingExecutor(RetryAlgorithm retryAlgorithm, ScheduledExecutorService scheduler) {
        this.retryAlgorithm = retryAlgorithm;
        this.scheduler = MoreExecutors.listeningDecorator((ScheduledExecutorService)scheduler);
    }

    @Override
    public RetryingFuture<ResponseT> createFuture(Callable<ResponseT> callable) {
        return new RetryingFutureImpl<ResponseT>(callable, this.retryAlgorithm, this);
    }

    @Override
    public void submit(RetryingFuture<ResponseT> retryingFuture) {
        ListenableFuture attemptFuture;
        try {
            attemptFuture = this.scheduler.schedule(retryingFuture.getCallable(), retryingFuture.getAttemptSettings().getRandomizedRetryDelay().getMillis(), TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException e) {
            attemptFuture = Futures.immediateCancelledFuture();
        }
        retryingFuture.setAttemptFuture((ApiFuture<ResponseT>)new ListenableFutureToApiFuture(attemptFuture));
    }
}

