/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.ApiFuture;
import com.google.api.gax.batching.PartitionKey;
import com.google.api.gax.batching.ThresholdBatcher;
import com.google.api.gax.core.FlowController;
import com.google.api.gax.grpc.Batch;
import com.google.api.gax.grpc.BatchedFuture;
import com.google.api.gax.grpc.BatcherFactory;
import com.google.api.gax.grpc.BatchingDescriptor;
import com.google.api.gax.grpc.CallContext;
import com.google.api.gax.grpc.FutureCallable;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.common.base.Preconditions;

class BatchingCallable<RequestT, ResponseT>
implements FutureCallable<RequestT, ResponseT> {
    private final FutureCallable<RequestT, ResponseT> callable;
    private final BatchingDescriptor<RequestT, ResponseT> batchingDescriptor;
    private final BatcherFactory<RequestT, ResponseT> batcherFactory;

    public BatchingCallable(FutureCallable<RequestT, ResponseT> callable, BatchingDescriptor<RequestT, ResponseT> batchingDescriptor, BatcherFactory<RequestT, ResponseT> batcherFactory) {
        this.callable = (FutureCallable)Preconditions.checkNotNull(callable);
        this.batchingDescriptor = (BatchingDescriptor)Preconditions.checkNotNull(batchingDescriptor);
        this.batcherFactory = (BatcherFactory)Preconditions.checkNotNull(batcherFactory);
    }

    @Override
    public ApiFuture<ResponseT> futureCall(RequestT request, CallContext context) {
        if (this.batcherFactory.getBatchingSettings().getIsEnabled().booleanValue()) {
            BatchedFuture result = BatchedFuture.create();
            UnaryCallable<RequestT, ResponseT> unaryCallable = UnaryCallable.create(this.callable).bind(context.getChannel());
            Batch<RequestT, ResponseT> batchableMessage = new Batch<RequestT, ResponseT>(this.batchingDescriptor, request, unaryCallable, result);
            PartitionKey partitionKey = this.batchingDescriptor.getBatchPartitionKey(request);
            ThresholdBatcher<Batch<RequestT, ResponseT>> batcher = this.batcherFactory.getPushingBatcher(partitionKey);
            try {
                batcher.add(batchableMessage);
                return result;
            }
            catch (FlowController.FlowControlException e) {
                throw FlowController.FlowControlRuntimeException.fromFlowControlException(e);
            }
        }
        return this.callable.futureCall(request, context);
    }
}

