/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.grpc.OperationCallable;
import com.google.api.gax.grpc.SimpleCallSettings;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Message;
import io.grpc.Channel;
import io.grpc.MethodDescriptor;
import java.util.concurrent.ScheduledExecutorService;

public final class OperationCallSettings<RequestT, ResponseT extends Message> {
    private final SimpleCallSettings<RequestT, Operation> initialCallSettings;
    private final Class<ResponseT> responseClass;

    public final SimpleCallSettings<RequestT, Operation> getInitialCallSettings() {
        return this.initialCallSettings;
    }

    OperationCallable<RequestT, ResponseT> createOperationCallable(Channel channel, ScheduledExecutorService executor, OperationsClient operationsClient) {
        UnaryCallable<RequestT, Operation> initialCallable = this.initialCallSettings.create(channel, executor);
        OperationCallable<RequestT, ResponseT> operationCallable = new OperationCallable<RequestT, ResponseT>(initialCallable, channel, executor, operationsClient, this.responseClass, this);
        return operationCallable;
    }

    private OperationCallSettings(SimpleCallSettings<RequestT, Operation> initialCallSettings, Class<ResponseT> responseClass) {
        this.initialCallSettings = initialCallSettings;
        this.responseClass = responseClass;
    }

    public static <RequestT, ResponseT extends Message> Builder<RequestT, ResponseT> newBuilder(MethodDescriptor<RequestT, Operation> grpcMethodDescriptor, Class<ResponseT> responseClass) {
        return new Builder<RequestT, ResponseT>(grpcMethodDescriptor, responseClass);
    }

    public final Builder<RequestT, ResponseT> toBuilder() {
        return new Builder(this);
    }

    public static class Builder<RequestT, ResponseT extends Message> {
        private SimpleCallSettings.Builder<RequestT, Operation> initialCallSettings;
        private Class<ResponseT> responseClass;

        public Builder(MethodDescriptor<RequestT, Operation> grpcMethodDescriptor, Class<ResponseT> responseClass) {
            this.initialCallSettings = SimpleCallSettings.newBuilder(grpcMethodDescriptor);
            this.responseClass = responseClass;
        }

        public Builder(OperationCallSettings<RequestT, ResponseT> settings) {
            this.initialCallSettings = ((OperationCallSettings)settings).initialCallSettings.toBuilder();
            this.responseClass = ((OperationCallSettings)settings).responseClass;
        }

        public Builder setInitialCallSettings(SimpleCallSettings.Builder<RequestT, Operation> initialCallSettings) {
            this.initialCallSettings = initialCallSettings;
            return this;
        }

        public SimpleCallSettings.Builder<RequestT, Operation> getInitialCallSettings() {
            return this.initialCallSettings;
        }

        public OperationCallSettings<RequestT, ResponseT> build() {
            return new OperationCallSettings((SimpleCallSettings)this.initialCallSettings.build(), this.responseClass);
        }
    }
}

