/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.bundling.ThresholdBundleReceiver;
import com.google.api.gax.grpc.BundlingContext;
import com.google.api.gax.grpc.BundlingDescriptor;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;

class BundleExecutor<RequestT, ResponseT>
implements ThresholdBundleReceiver<BundlingContext<RequestT, ResponseT>> {
    private final BundlingDescriptor<RequestT, ResponseT> bundlingDescriptor;
    private final String partitionKey;

    public BundleExecutor(BundlingDescriptor<RequestT, ResponseT> bundlingDescriptor, String partitionKey) {
        this.bundlingDescriptor = (BundlingDescriptor)Preconditions.checkNotNull(bundlingDescriptor);
        this.partitionKey = (String)Preconditions.checkNotNull((Object)partitionKey);
    }

    @Override
    public void validateItem(BundlingContext<RequestT, ResponseT> item) {
        String itemPartitionKey = this.bundlingDescriptor.getBundlePartitionKey(item.getRequest());
        if (!itemPartitionKey.equals(this.partitionKey)) {
            String requestClassName = item.getRequest().getClass().getSimpleName();
            throw new IllegalArgumentException(String.format("For type %s, invalid partition key: %s, should be: %s", requestClassName, itemPartitionKey, this.partitionKey));
        }
    }

    @Override
    public void processBundle(List<BundlingContext<RequestT, ResponseT>> bundle) {
        ArrayList<RequestT> requests = new ArrayList<RequestT>(bundle.size());
        for (BundlingContext<RequestT, ResponseT> message : bundle) {
            requests.add(message.getRequest());
        }
        RequestT bundleRequest = this.bundlingDescriptor.mergeRequests(requests);
        UnaryCallable<RequestT, ResponseT> callable = bundle.get(0).getCallable();
        try {
            ResponseT bundleResponse = callable.call(bundleRequest);
            this.bundlingDescriptor.splitResponse(bundleResponse, bundle);
        }
        catch (Throwable exception) {
            this.bundlingDescriptor.splitException(exception, bundle);
        }
        for (BundlingContext<RequestT, ResponseT> message : bundle) {
            message.sendResult();
        }
    }
}

