
package com.google.api.gax.grpc;

import javax.annotation.Generated;
import org.joda.time.Duration;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_BundlingSettings extends BundlingSettings {

  private final Integer elementCountThreshold;
  private final Integer elementCountLimit;
  private final Integer requestByteThreshold;
  private final Integer requestByteLimit;
  private final Duration delayThreshold;
  private final Integer blockingCallCountThreshold;
  private final Boolean isEnabled;

  private AutoValue_BundlingSettings(
      @javax.annotation.Nullable Integer elementCountThreshold,
      @javax.annotation.Nullable Integer elementCountLimit,
      @javax.annotation.Nullable Integer requestByteThreshold,
      @javax.annotation.Nullable Integer requestByteLimit,
      @javax.annotation.Nullable Duration delayThreshold,
      @javax.annotation.Nullable Integer blockingCallCountThreshold,
      Boolean isEnabled) {
    this.elementCountThreshold = elementCountThreshold;
    this.elementCountLimit = elementCountLimit;
    this.requestByteThreshold = requestByteThreshold;
    this.requestByteLimit = requestByteLimit;
    this.delayThreshold = delayThreshold;
    this.blockingCallCountThreshold = blockingCallCountThreshold;
    if (isEnabled == null) {
      throw new NullPointerException("Null isEnabled");
    }
    this.isEnabled = isEnabled;
  }

  @javax.annotation.Nullable
  @Override
  public Integer getElementCountThreshold() {
    return elementCountThreshold;
  }

  @javax.annotation.Nullable
  @Override
  public Integer getElementCountLimit() {
    return elementCountLimit;
  }

  @javax.annotation.Nullable
  @Override
  public Integer getRequestByteThreshold() {
    return requestByteThreshold;
  }

  @javax.annotation.Nullable
  @Override
  public Integer getRequestByteLimit() {
    return requestByteLimit;
  }

  @javax.annotation.Nullable
  @Override
  public Duration getDelayThreshold() {
    return delayThreshold;
  }

  @javax.annotation.Nullable
  @Override
  public Integer getBlockingCallCountThreshold() {
    return blockingCallCountThreshold;
  }

  @Override
  public Boolean getIsEnabled() {
    return isEnabled;
  }

  @Override
  public String toString() {
    return "BundlingSettings{"
        + "elementCountThreshold=" + elementCountThreshold + ", "
        + "elementCountLimit=" + elementCountLimit + ", "
        + "requestByteThreshold=" + requestByteThreshold + ", "
        + "requestByteLimit=" + requestByteLimit + ", "
        + "delayThreshold=" + delayThreshold + ", "
        + "blockingCallCountThreshold=" + blockingCallCountThreshold + ", "
        + "isEnabled=" + isEnabled
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof BundlingSettings) {
      BundlingSettings that = (BundlingSettings) o;
      return ((this.elementCountThreshold == null) ? (that.getElementCountThreshold() == null) : this.elementCountThreshold.equals(that.getElementCountThreshold()))
           && ((this.elementCountLimit == null) ? (that.getElementCountLimit() == null) : this.elementCountLimit.equals(that.getElementCountLimit()))
           && ((this.requestByteThreshold == null) ? (that.getRequestByteThreshold() == null) : this.requestByteThreshold.equals(that.getRequestByteThreshold()))
           && ((this.requestByteLimit == null) ? (that.getRequestByteLimit() == null) : this.requestByteLimit.equals(that.getRequestByteLimit()))
           && ((this.delayThreshold == null) ? (that.getDelayThreshold() == null) : this.delayThreshold.equals(that.getDelayThreshold()))
           && ((this.blockingCallCountThreshold == null) ? (that.getBlockingCallCountThreshold() == null) : this.blockingCallCountThreshold.equals(that.getBlockingCallCountThreshold()))
           && (this.isEnabled.equals(that.getIsEnabled()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= (elementCountThreshold == null) ? 0 : elementCountThreshold.hashCode();
    h *= 1000003;
    h ^= (elementCountLimit == null) ? 0 : elementCountLimit.hashCode();
    h *= 1000003;
    h ^= (requestByteThreshold == null) ? 0 : requestByteThreshold.hashCode();
    h *= 1000003;
    h ^= (requestByteLimit == null) ? 0 : requestByteLimit.hashCode();
    h *= 1000003;
    h ^= (delayThreshold == null) ? 0 : delayThreshold.hashCode();
    h *= 1000003;
    h ^= (blockingCallCountThreshold == null) ? 0 : blockingCallCountThreshold.hashCode();
    h *= 1000003;
    h ^= isEnabled.hashCode();
    return h;
  }

  static final class Builder extends BundlingSettings.Builder {
    private Integer elementCountThreshold;
    private Integer elementCountLimit;
    private Integer requestByteThreshold;
    private Integer requestByteLimit;
    private Duration delayThreshold;
    private Integer blockingCallCountThreshold;
    private Boolean isEnabled;
    Builder() {
    }
    Builder(BundlingSettings source) {
      this.elementCountThreshold = source.getElementCountThreshold();
      this.elementCountLimit = source.getElementCountLimit();
      this.requestByteThreshold = source.getRequestByteThreshold();
      this.requestByteLimit = source.getRequestByteLimit();
      this.delayThreshold = source.getDelayThreshold();
      this.blockingCallCountThreshold = source.getBlockingCallCountThreshold();
      this.isEnabled = source.getIsEnabled();
    }
    @Override
    public BundlingSettings.Builder setElementCountThreshold(Integer elementCountThreshold) {
      this.elementCountThreshold = elementCountThreshold;
      return this;
    }
    @Override
    public BundlingSettings.Builder setElementCountLimit(Integer elementCountLimit) {
      this.elementCountLimit = elementCountLimit;
      return this;
    }
    @Override
    public BundlingSettings.Builder setRequestByteThreshold(Integer requestByteThreshold) {
      this.requestByteThreshold = requestByteThreshold;
      return this;
    }
    @Override
    public BundlingSettings.Builder setRequestByteLimit(Integer requestByteLimit) {
      this.requestByteLimit = requestByteLimit;
      return this;
    }
    @Override
    public BundlingSettings.Builder setDelayThreshold(Duration delayThreshold) {
      this.delayThreshold = delayThreshold;
      return this;
    }
    @Override
    public BundlingSettings.Builder setBlockingCallCountThreshold(Integer blockingCallCountThreshold) {
      this.blockingCallCountThreshold = blockingCallCountThreshold;
      return this;
    }
    @Override
    public BundlingSettings.Builder setIsEnabled(Boolean isEnabled) {
      this.isEnabled = isEnabled;
      return this;
    }
    @Override
    public BundlingSettings autoBuild() {
      String missing = "";
      if (isEnabled == null) {
        missing += " isEnabled";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_BundlingSettings(
          this.elementCountThreshold,
          this.elementCountLimit,
          this.requestByteThreshold,
          this.requestByteLimit,
          this.delayThreshold,
          this.blockingCallCountThreshold,
          this.isEnabled);
    }
  }
}
