/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.core.ApiFuture;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallContext;
import com.google.api.gax.httpjson.HttpJsonCallOptions;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.base.Preconditions;

class HttpJsonDirectCallable<RequestT, ResponseT>
extends UnaryCallable<RequestT, ResponseT> {
    private final ApiMethodDescriptor<RequestT, ResponseT> descriptor;

    HttpJsonDirectCallable(ApiMethodDescriptor<RequestT, ResponseT> descriptor) {
        this.descriptor = descriptor;
    }

    public ApiFuture<ResponseT> futureCall(RequestT request, ApiCallContext inputContext) {
        Preconditions.checkNotNull(request);
        HttpJsonCallContext context = HttpJsonCallContext.createDefault().nullToSelf(inputContext);
        HttpJsonCallOptions callOptions = HttpJsonCallOptions.newBuilder().setDeadline(context.getDeadline()).setCredentials(context.getCredentials()).build();
        return context.getChannel().issueFutureUnaryCall(callOptions, request, this.descriptor);
    }

    public String toString() {
        return String.format("direct(%s)", this.descriptor);
    }
}

