/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.gax.httpjson.HttpJsonCallOptions;
import com.google.auth.Credentials;
import javax.annotation.Nullable;
import org.threeten.bp.Instant;

final class AutoValue_HttpJsonCallOptions
extends HttpJsonCallOptions {
    private final Instant deadline;
    private final Credentials credentials;

    private AutoValue_HttpJsonCallOptions(@Nullable Instant deadline, Credentials credentials) {
        this.deadline = deadline;
        if (credentials == null) {
            throw new NullPointerException("Null credentials");
        }
        this.credentials = credentials;
    }

    @Override
    @Nullable
    public Instant getDeadline() {
        return this.deadline;
    }

    @Override
    public Credentials getCredentials() {
        return this.credentials;
    }

    public String toString() {
        return "HttpJsonCallOptions{deadline=" + this.deadline + ", credentials=" + this.credentials + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HttpJsonCallOptions) {
            HttpJsonCallOptions that = (HttpJsonCallOptions)o;
            return (this.deadline == null ? that.getDeadline() == null : this.deadline.equals((Object)that.getDeadline())) && this.credentials.equals(that.getCredentials());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.deadline == null ? 0 : this.deadline.hashCode();
        h *= 1000003;
        return h ^= this.credentials.hashCode();
    }

    static final class Builder
    extends HttpJsonCallOptions.Builder {
        private Instant deadline;
        private Credentials credentials;

        Builder() {
        }

        Builder(HttpJsonCallOptions source) {
            this.deadline = source.getDeadline();
            this.credentials = source.getCredentials();
        }

        @Override
        public HttpJsonCallOptions.Builder setDeadline(@Nullable Instant deadline) {
            this.deadline = deadline;
            return this;
        }

        @Override
        public HttpJsonCallOptions.Builder setCredentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        @Override
        public HttpJsonCallOptions build() {
            String missing = "";
            if (this.credentials == null) {
                missing = missing + " credentials";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_HttpJsonCallOptions(this.deadline, this.credentials);
        }
    }
}

