/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.grpc.GrpcLongRunningClient;
import com.google.api.gax.longrunning.OperationSnapshot;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.truth.Truth;
import com.google.longrunning.CancelOperationRequest;
import com.google.longrunning.DeleteOperationRequest;
import com.google.longrunning.GetOperationRequest;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class GrpcLongRunningClientTest {
    @Test
    public void get() {
        OperationsStub operationsStub = (OperationsStub)Mockito.mock(OperationsStub.class);
        Mockito.when((Object)operationsStub.getOperationCallable()).thenReturn((Object)new UnaryCallable<GetOperationRequest, Operation>(){

            public ApiFuture<Operation> futureCall(GetOperationRequest request, ApiCallContext context) {
                if (!request.getName().equals("poseidon")) {
                    return ApiFutures.immediateFailedFuture((Throwable)new IllegalStateException("Unexpected request: " + request));
                }
                return ApiFutures.immediateFuture((Object)Operation.newBuilder().setName("greece").build());
            }
        });
        GrpcLongRunningClient longRunningClient = new GrpcLongRunningClient(operationsStub);
        Truth.assertThat((String)((OperationSnapshot)longRunningClient.getOperationCallable().call((Object)"poseidon")).getName()).isEqualTo((Object)"greece");
    }

    @Test
    public void cancel() {
        OperationsStub operationsStub = (OperationsStub)Mockito.mock(OperationsStub.class);
        Mockito.when((Object)operationsStub.cancelOperationCallable()).thenReturn((Object)new UnaryCallable<CancelOperationRequest, Empty>(){

            public ApiFuture<Empty> futureCall(CancelOperationRequest request, ApiCallContext context) {
                if (!request.getName().equals("poseidon")) {
                    return ApiFutures.immediateFailedFuture((Throwable)new IllegalStateException("Unexpected request: " + request));
                }
                return ApiFutures.immediateFuture((Object)Empty.getDefaultInstance());
            }
        });
        GrpcLongRunningClient longRunningClient = new GrpcLongRunningClient(operationsStub);
        Truth.assertThat((Object)longRunningClient.cancelOperationCallable().call((Object)"poseidon")).isNull();
    }

    @Test
    public void delete() {
        OperationsStub operationsStub = (OperationsStub)Mockito.mock(OperationsStub.class);
        Mockito.when((Object)operationsStub.deleteOperationCallable()).thenReturn((Object)new UnaryCallable<DeleteOperationRequest, Empty>(){

            public ApiFuture<Empty> futureCall(DeleteOperationRequest request, ApiCallContext context) {
                if (!request.getName().equals("poseidon")) {
                    return ApiFutures.immediateFailedFuture((Throwable)new IllegalStateException("Unexpected request: " + request));
                }
                return ApiFutures.immediateFuture((Object)Empty.getDefaultInstance());
            }
        });
        GrpcLongRunningClient longRunningClient = new GrpcLongRunningClient(operationsStub);
        Truth.assertThat((Object)longRunningClient.deleteOperationCallable().call((Object)"poseidon")).isNull();
    }
}

