/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.ApiFuture;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcCallableFactory;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.common.collect.ImmutableSet;
import com.google.common.truth.Truth;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.Deadline;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import java.util.concurrent.TimeUnit;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.quality.Strictness;
import org.mockito.verification.VerificationMode;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class TimeoutTest {
    private static final String CALL_OPTIONS_AUTHORITY = "RETRYING_TEST";
    private static final int DEADLINE_IN_DAYS = 7;
    private static final ImmutableSet<StatusCode.Code> emptyRetryCodes = ImmutableSet.of();
    private static final Duration totalTimeout = Duration.ofDays((long)7L);
    @Rule
    public MockitoRule mockitoRule = MockitoJUnit.rule().strictness(Strictness.STRICT_STUBS);
    @Mock
    private MethodDescriptor.Marshaller<String> stringMarshaller;
    @Mock
    private RequestParamsExtractor<String> paramsExtractor;
    @Mock
    private ManagedChannel managedChannel;
    private MethodDescriptor<String, String> methodDescriptor;
    private RetrySettings nonRetrySettings;

    @Before
    public void setUp() {
        this.methodDescriptor = MethodDescriptor.newBuilder().setSchemaDescriptor((Object)"yaml").setFullMethodName("fake.test/RingRing").setResponseMarshaller(this.stringMarshaller).setRequestMarshaller(this.stringMarshaller).setType(MethodDescriptor.MethodType.UNARY).build();
        this.nonRetrySettings = RetrySettings.newBuilder().setTotalTimeout(totalTimeout).setInitialRetryDelay(Duration.ZERO).setRetryDelayMultiplier(1.0).setMaxRetryDelay(Duration.ZERO).setMaxAttempts(1).setJittered(true).setInitialRpcTimeout(totalTimeout).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(totalTimeout).build();
    }

    @Test
    public void testNonRetryUnarySettings() {
        ClientCall clientCall = (ClientCall)Mockito.mock(ClientCall.class);
        ((ManagedChannel)Mockito.doReturn((Object)clientCall).when((Object)this.managedChannel)).newCall((MethodDescriptor)ArgumentMatchers.eq(this.methodDescriptor), (CallOptions)ArgumentMatchers.any(CallOptions.class));
        CallOptions spyCallOptions = CallOptions.DEFAULT.withAuthority(CALL_OPTIONS_AUTHORITY);
        GrpcCallContext grpcCallContext = GrpcCallContext.createDefault().withChannel((Channel)this.managedChannel).withCallOptions(spyCallOptions);
        ArgumentCaptor callOptionsArgumentCaptor = ArgumentCaptor.forClass(CallOptions.class);
        ((ClientCall)Mockito.doThrow((Throwable[])new Throwable[]{new ApiException((Throwable)new RuntimeException(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.UNAVAILABLE), false)}).when((Object)clientCall)).halfClose();
        GrpcCallSettings grpcCallSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(this.methodDescriptor).setParamsExtractor(this.paramsExtractor).build();
        UnaryCallSettings nonRetriedCallSettings = UnaryCallSettings.newUnaryCallSettingsBuilder().setRetrySettings(this.nonRetrySettings).setRetryableCodes(emptyRetryCodes).build();
        UnaryCallable callable = GrpcCallableFactory.createUnaryCallable((GrpcCallSettings)grpcCallSettings, (UnaryCallSettings)nonRetriedCallSettings, (ClientContext)ClientContext.newBuilder().setDefaultCallContext((ApiCallContext)grpcCallContext).build());
        try {
            ApiFuture apiFuture = callable.futureCall((Object)"Is your refrigerator running?");
        }
        catch (ApiException apiException) {
            // empty catch block
        }
        ((ManagedChannel)Mockito.verify((Object)this.managedChannel, (VerificationMode)Mockito.times((int)1))).newCall((MethodDescriptor)ArgumentMatchers.eq(this.methodDescriptor), (CallOptions)callOptionsArgumentCaptor.capture());
        CallOptions callOptionsUsed = (CallOptions)callOptionsArgumentCaptor.getValue();
        Truth.assertThat((Comparable)callOptionsUsed.getDeadline()).isNotNull();
        Truth.assertThat((Comparable)callOptionsUsed.getDeadline()).isGreaterThan((Comparable)Deadline.after((long)6L, (TimeUnit)TimeUnit.DAYS));
        Truth.assertThat((Comparable)callOptionsUsed.getDeadline()).isLessThan((Comparable)Deadline.after((long)7L, (TimeUnit)TimeUnit.DAYS));
        Truth.assertThat((String)callOptionsUsed.getAuthority()).isEqualTo((Object)CALL_OPTIONS_AUTHORITY);
    }
}

